' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ²
' // ² L I T T L E   N E M O   X
' // ² Version 1.0
' // ²
' // ² By EikSoft (www.EikSoft.com)
' // ² 9.17.23 Project Start
' // ² 10.16.23 Last Modified
' // ²
' // ² Ported from Blitz2D version of Little Nemo's Nightmare
' // ² released on 08.28.14
' // ²
' // ² For J.B. - In loving memory of Celeste <3
' // ²
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // 
SuperStrict

Framework BRL.GLMax2D 

Import BRL.Matrix
Import BRL.Retro
Import BRL.PNGLoader
Import BRL.Random
Import BRL.WAVLoader
Import BRL.OGGLoader
Import SDL.SDLFreeAudio
Import PUB.FreeJoy

SetAudioDriver("FreeAudio SDL")

AppTitle = "Little Nemo X v1.0"
SetGraphicsDriver GLMax2DDriver()
SeedRnd MilliSecs()

' // Config
Global cfgSfx:Int = 100
Global cfgMusic:Int = 70
Global cfgFilter:Int = 0
Global cfgCRT:Int = 0
Global cfgFull:Int = 0
Global cfgDiff:Int = 1

' // Input.Cfg
Global inKey:String[2, 7]

Global INP_U:Int = 0, INP_D:Int = 1, INP_L:Int = 2, INP_R:Int = 3, INP_B:Int = 4, INP_A:Int = 5, INP_S:Int = 6
Global p1Joy:Int = 0, p2Joy:Int = 1

LoadCFG()
LoadInput()

'cfgFull = 0

' // Master flags
Global bWindowed:Int ' // Windowed
If cfgFull = 0 Then bWindowed = True Else bWindowed = False
Global bTitle:Int = True ' // Title screen
Global bDebug:Int = False ' // Debug info

If bWindowed = True Then 
	Graphics 588, 448, 0, 60
Else
	Graphics 640, 480, 32, 60
EndIf

If bWindowed = False Then HideMouse

' // Loading screen
SetMaskColor 255, 0, 255
imgFont = LoadAnimImage("gfx/font.png", 8, 8, 0, 64, MASKEDIMAGE)
SetScale 2.299, 2.0
If bWindowed = False Then SetOrigin 26, 16
DrawFont "Loading", -1, 216
Flip

' // Tick count and FPS
Global MyMilliSecs:Int, LastMilliSecs:Int = MilliSecs() ' // MilliSecs FIX
Global FPS:Int, curFrames:Int, frameTimer:Int, fpsTimer:Int = GetMilliSecs() ' // FPS Counter

' // FULL PC IS 2.5 / 2.15
' // FULL CRT IS 2.3 / 2.0
Global sclX:Float = 2.299, sclY:Float = 2.0
Global crtMode:Int = cfgCRT

' // Joystick
Global bJoy1YHit:Int = False, bJoy1XHit:Int = False
Global bJoy2YHit:Int = False, bJoy2XHit:Int = False

' // Title
Global tSel:Int = 0, tScreen:Int = 0
Global ebbF:Int = 0, ebbT:Int, ebbD:Int = 0
Global secretC:String = "", bSecret:Int = False

' // Game level
Global bPaused:Int = False, pauseStart:Int, pauseTotal:Int

Global b2Player:Int = False
Global curPlayer:Int

Global curLevel:Int[2]
curLevel[0] = 1; curLevel[1] = 1
Global bHard:Int[2]
bHard[0] = 0; bHard[1] = 0

Global net_Score:String[100], netP:Int

Global scrollX:Float = 0
Global tileX:Float = 0
Global caveX1:Float

Global offX:Int = 0, offY:Int = 0
Global lavaF:Int = 0, lavaT:Int
Global timeMin:Int = 2, timeSec:Int = 0, timeTimer:Int
Global bTransform:Int = 1, transTime:Int 
Global b2Transform:Int = 1
Global createTime:Int
Global caveF1:Int = 0, caveF2:Int, caveF3:Int
Global caveD1:Int = 1, caveD2:Int = 1, caveD3:Int = 1
Global bAlien:Int[2]
bAlien[0] = False; bAlien[1] = False
Global bCandy:Int = False
Global faceCount:Int = 0

Global caveT:Int

Global objC:Int = 0 ' // Object count
Global partC:Int = 0 ' // Particle count

' // Player
Global pX# = 0, pY# = 240, pF:Int = 0, pD:Int = 1, pT:Int, pJ:Int = False, pJV# = 5
Global pScore:Int = 0, p2Score:Int = 0
Global jumpC:Int = 0
Global pLife:Int = 3, pLives:Int = 2
Global p2Lives:Int = 2
Global pHurt:Int = False, pHurtT:Int
Global gloHit:Int = False, hitX:Int, hitY:Int, hitT:Int
Global bPlat:Int = False
Global pFall:Int = False
Global pDeath:Int = False
Global dF:Int = 0
Global spinF:Int = 0
Global deathT:Int
Global bBoss:Int = False
Global bCounting:Int = False
Global pShoot:Int, pShootT:Int
Global pIdle:Int = False
Global bSkip:Int = False
Global bGameOver:Int = False
Global bSpikes:Int = False

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² IMAGES                                           
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // General
Global imgTitle:TImage
Global imgSel:TImage
Global imgDrop:TImage
Global imgFont:TImage
Global imgHit:TImage
Global imgPickup:TImage
Global imgGameOver:TImage
Global imgDoor:TImage
Global imgDeath:TImage
Global imgCandy:TImage
Global imgLife:TImage
Global imgHi:TImage 
Global imgCRT:TImage
Global imgLives:TImage

Global imgSpin:TImage[2]
Global imgSleep:TImage[2]
Global imgStatus:TImage[2]
Global imgWin:TImage[2]

' // Level 1
Global imgBack:TImage
Global imgBack2:TImage
Global imgDog:TImage
Global imgSnail:TImage
Global imgTile:TImage
Global imgTileO:TImage
Global imgTile2:TImage
Global imgShroom1:TImage
Global imgShroom2:TImage
Global imgShroom3:TImage
Global imgBase1:TImage
Global imgBase2:TImage
Global imgCloud:TImage
Global imgTree:TImage
Global imgTreeO:TImage
Global imgTree3:TImage
Global imgGrave:TImage
Global imgEye:TImage
Global imgLaser:TImage
Global imgSky:TImage
Global imgFlip:TImage
Global imgWelcome:TImage
Global imgWelcomeO:TImage
Global imgBoss1:TImage
Global imgPump:TImage
Global imgFloat:TImage
Global imgEx1:TImage
Global imgDrop3:TImage

Global imgFrog:TImage[2]
Global imgFrogO:TImage[2]

' // Level 2
Global imgTile3:TImage
Global imgSky2:TImage
Global imgFloat2:TImage
Global imgTile4:TImage
Global imgFlame:TImage
Global imgShot:TImage
Global imgMonkey:TImage
Global imgWelcome2:TImage
Global imgTree2:TImage
Global imgTree4:TImage
Global imgSkel:TImage
Global imgIce:TImage
Global imgTile5:TImage
Global imgDrop2:TImage
Global imgBoss2:TImage
Global imgFire:TImage
Global imgCave1:TImage
Global imgCave2:TImage
Global imgCave3:TImage
Global imgEgg:TImage
Global imgGhost:TImage
Global imgMark:TImage
Global imgBoss2C:TImage

Global imgLizard:TImage[2]
Global imgLizardF:TImage[2]

' // Level 3
Global imgTile6:TImage
Global imgBlast:TImage
Global imgSky3:TImage
Global imgWolf:TImage
Global imgWelcome3:TImage
Global imgTile7:TImage
Global imgBack3:TImage
Global imgBoss3:TImage
Global imgFace:TImage
Global imgSpikes:TImage
Global imgWelcomeA:TImage
Global imgBack4:TImage
Global imgFish:TImage
Global imgTile8:TImage
Global imgBackO:TImage
Global imgRain:TImage

Global imgNemo:TImage[2]
Global imgNemoIdle:TImage[2]
Global imgNemoF:TImage[2]


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SOUNDS                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global sfxStart:TSound = LoadSound("sfx/start.wav")
Global sfxJump:TSound = LoadSound("sfx/jump.wav")
Global sfxHit:TSound = LoadSound("sfx/hit.wav")
Global sfxHit2:TSound = LoadSound("sfx/hit2.wav")
Global sfxLaser:TSound = LoadSound("sfx/laser.wav")
Global sfxKill:TSound = LoadSound("sfx/kill1.wav")
Global sfxPick:TSound = LoadSound("sfx/pickup.wav")
Global sfxBoss:TSound = LoadSound("sfx/boss.wav")
Global sfxDeath:TSound = LoadSound("sfx/death.wav")
Global sfxEnd:TSound = LoadSound("sfx/end.wav")
Global sfxCount:TSound = LoadSound("sfx/count.wav")
Global sfxFlame:TSound = LoadSound("sfx/flame.wav")
Global sfxPickup2:TSound = LoadSound("sfx/pickup2.wav")
Global sfxShot:TSound = LoadSound("sfx/shot.wav")
Global sfxIce:TSound = LoadSound("sfx/ice.wav")
Global sfxDestroy:TSound = LoadSound("sfx/destroy.wav")
Global sfxTime:TSound = LoadSound("sfx/time.wav")
Global sfxBlast:TSound = LoadSound("sfx/blast.wav")
Global sfxGame:TSound = LoadSound("sfx/game.wav")

Global sfxBed:TSound = LoadSound("sfx/bed.wav")
Global sfxPause:TSound = LoadSound("sfx/pause.wav")
Global sfxDie:TSound = LoadSound("sfx/die.wav")
Global sfxSleep:TSound = LoadSound("sfx/sleep.wav")
Global sfxNJump:TSound = LoadSound("sfx/njump.wav")
Global sfxPoof:TSound = LoadSound("sfx/poof.wav")
Global sfxHug:TSound = LoadSound("sfx/hug.wav")
Global sfxDing:TSound = LoadSound("sfx/ding.wav")
Global sfxGhost:TSound = LoadSound("sfx/ghost.wav")
Global sfxFlame2:TSound = LoadSound("sfx/flame2.wav")
Global sfxFlame3:TSound = LoadSound("sfx/flame3.wav")
Global sfxKing:TSound = LoadSound("sfx/king.wav")
Global sfx1Up:TSound = LoadSound("sfx/1up.wav")
Global sfxUpload:TSound = LoadSound("sfx/upload.wav")

Global sfxChan:TChannel = AllocChannel()


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² MUSIC                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global musTitle:TSound = LoadSound("ogg/title.ogg", SOUND_LOOP)
Global musLevel1:TSound = LoadSound("ogg/level1.ogg", SOUND_LOOP)
Global musLevel2:TSound = LoadSound("ogg/level2.ogg", SOUND_LOOP)
Global musLevel3:TSound = LoadSound("ogg/level3.ogg", SOUND_LOOP)
Global musOver:TSound = LoadSound("ogg/over.ogg", SOUND_LOOP)
Global musTerror:TSound = LoadSound("ogg/terror.ogg", SOUND_LOOP)
Global musNemo:TSound = LoadSound("ogg/nemo.ogg", SOUND_LOOP)
Global musAlien:TSound = LoadSound("ogg/alien.ogg", SOUND_LOOP)
Global musEntry:TSound = LoadSound("ogg/entry.ogg", SOUND_LOOP)

Global curSong:Int = 1

Global musChan:TChannel = AllocChannel()

musChan = PlaySound(musTitle, musChan)
musChan.SetVolume(Float(cfgMusic) / 10) 


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CONSTANTS                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Const PLAYER_1:Int = 0
Const PLAYER_2:Int = 1

Const OBJ_DROP:Int = 1
Const OBJ_DOG:Int = 2
Const OBJ_CLOUD:Int = 3
Const OBJ_EYEBALL:Int = 4
Const OBJ_PLAT:Int = 5
Const OBJ_HEALTH:Int = 6
Const OBJ_ANIMAL:Int = 7
Const OBJ_PUMPKIN:Int = 8
Const OBJ_FLAME:Int = 9
Const OBJ_SKEL:Int = 10
Const OBJ_COMET:Int = 11
Const OBJ_SNAKE:Int = 12
Const OBJ_KING:Int = 13
Const OBJ_FACE:Int = 14
Const OBJ_SNAIL:Int = 15 ' // !!! ADJUST
Const OBJ_CANDY:Int = 16
Const OBJ_FADER:Int = 17
Const OBJ_EGG:Int = 18
Const OBJ_HUGGER:Int = 19
Const OBJ_GHOST:Int = 20
Const OBJ_FISH:Int = 21
Const OBJ_SPIKE:Int = 22
Const OBJ_RAIN:Int = 23

Const PART_SPLASH:Int = 1
Const PART_EXPLODE:Int = 2
Const PART_SCORE:Int = 3 ' // !!! Adjust
Const PART_LASER:Int = 4 
Const PART_SHOT:Int = 5
Const PART_FADE:Int = 6
Const PART_RISER:Int = 7
Const PART_WAND:Int = 8

Const TYPE_BLOOD:Int = 0
Const TYPE_CANDY:Int = 1

Global o:Obj, objList:TList = CreateList()
Global p:Part, partList:TList = CreateList()

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PARTICLES                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Part   
    Field X:Float, Y:Float, A:Int, ID:Int
	Field R:Float, V:Float, VS:Float, D:Float, F:Int, T:Int, Txt:String, L:Int
	Field Alp:Float, S:Float, C2:Int, myType:Int , T2:Int, Rot:Int, YI:Float
	Field Col1:Int[3], Col2:Int[3]
	
    Function Create:Part(X:Float, Y:Float, ID:Int, T:Int = 0)
		p:Part = New Part
		p.X = X; p.Y = Y; p.ID = ID; p.Alp = 1
		p.myType = T
		
		If ID = PART_SPLASH Then
			p.A = Rand(220, 320)
			If T = 11 Or T = 12 Then
				p.S = Rnd(2, 3.5)
			Else
				p.S = Rnd(1.5, 2.5)
			EndIf
			p.D = Rnd(.075, .1)				
			
			p.myType = T
			p.R = 0
			p.C2 = Rand(0, 1)			

			If T = 10 Then ' // Acid
				p.Col1[0] = 169; p.Col1[1] = 247; p.Col1[2] = 173
				p.Col2[0] = 12; p.Col2[1] = 218; p.Col2[2] = 12
			
			ElseIf T = 11 Then ' // Lava
				p.Col1[0] = 216; p.Col1[1] = 40; p.Col1[2] = 0
				p.Col2[0] = 252; p.Col2[1] = 116; p.Col2[2] = 96
			
			ElseIf T = 12 ' // Water
				p.Col1[0] = 96; p.Col1[1] = 116; p.Col1[2] = 252
				p.Col2[0] = 0; p.Col2[1] = 40; p.Col2[2] = 216
				
			EndIf
			
		ElseIf ID = PART_SCORE Then		
			p.X = p.X - (Len(String(p.myType)) * (6 * sclX)) / 2
		
		ElseIf ID = PART_LASER Then
			p.A = Rand(170, 200); p.R = 0
			p.Alp = .95
			p.V = T
			p.T2 = GetMilliSecs()
			p.D = 0
			
			If T = 1 Then ' // Pumpkin
				If Rand(0, 1) = 1 Then
					p.A = Rand(180, 210)
				Else
					p.A = Rand(330, 359)
				EndIf			
			EndIf
		
		ElseIf ID = PART_RISER Then 
			p.Alp = 1
			p.C2 = T
			If p.C2 <= 1 Then ' // Egg
				p.D = .Rnd(.01, .025)	
				p.V = Rnd(.05, 1)
			Else ' // Serpent
				p.D = .Rnd(.01, .025)	
				p.V = Rnd(.1, 1)
			EndIf
			p.Y:-4
			
		EndIf
		
		Return p
	End Function
	
	Method Render()
        Local Del:Int = False
		Local bHit:Int = False
		
		Local createP:Int = False
		Local cX:Int, cY:Int
		
		Select ID	
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² SPLASH                                        
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case PART_SPLASH
			SetBlend LIGHTBLEND; SetAlpha Alp
			SetScale 1, 1
			
			If myType = TYPE_BLOOD Then
				If C2 = 0 Then SetColor 216, 40, 0 ElseIf C2 = 1 Then SetColor 107, 0, 0
			Else
				If C2 = 0 Then SetColor Col1[0], Col1[1], Col1[2] ElseIf C2 = 1 Then SetColor Col2[0], Col2[1], Col2[2]
			EndIf
			
			Local tmpS:Int
			
			If S >= 1.5 Then ' // Sizing
				tmpS = 4; Alp = 1
			ElseIf S >= .5 Then
				tmpS = 3; Alp = .66
			Else
				tmpS = 2; Alp = .33
			EndIf			
			
			'tmpS:+1 ' // Burst
			
			DrawRect Float((R * Cos(A) + X) - (tmpS / 2)) + (-scrollX), Float((R * Sin(A) + Y) - (tmpS / 2)), tmpS, tmpS
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255
			
			R = R + S
			Alp = Alp - .01
			If S > 0 Then S = S - D Else Del = True
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² EXPLODE                                    
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case PART_EXPLODE
			SetBlend ALPHABLEND; SetAlpha Alp; SetScale sclX, sclY; SetColor 255, 255, 255

			If GetMilliSecs() >= T + V Then
				Local tmpF:Int = 0
				If Alp < .75 Then tmpF = 0 Else tmpF = 1
				If curLevel[curPlayer-1] = 2 Then tmpF:+2 ElseIf curLevel[curPlayer-1] = 3 Then tmpF:+4
				DrawImage imgEx1, X + (-scrollX), Int(Y), tmpF
				If Alp > 0 Then Alp:-.015
			EndIf
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255
			
			If Alp <= 0 Then Del = True
						
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² SCORE                                       
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case PART_SCORE
			SetBlend LIGHTBLEND; SetAlpha Alp
			SetScale 1.5, 1.5
			
			SetColor 255, 255, 255
			Local tmpS:Int
						
			DrawFont String(myType), Int(X + (-scrollX)), Int(Y), 1
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

			Y:-1
			Alp = Alp - .025
			If Alp <= 0 Then Del = True
			

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² LASER                                     
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case PART_LASER 
			SetBlend LIGHTBLEND; SetAlpha Alp; SetScale 1, 1
			
			If V = 0 Then
				DrawImage imgLaser, Float((R * Cos(A) + X) + (-scrollX)), Float(R * Sin(A) + Y), F
			ElseIf V = 1 Then
				DrawImage imgPump, Float((R * Cos(A) + X) + (-scrollX)), Float(R * Sin(A) + Y), F
			ElseIf V = 2 Then
				DrawImage imgFire, Float((R * Cos(A) + X) + (-scrollX)), Float(R * Sin(A) + Y), F
			EndIf

			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255
												
			If GetMilliSecs() >= T + 50 Then
				If F = 0 Then F = 1 Else F = 0
				T = GetMilliSecs()
			EndIf
			
			If D = 0 Then
				R = R + 3
			ElseIf V = 2 And D = 1 Then ' // CHECK THIS
				R = R + 2.5
			ElseIf V = 2 And D = 2 Then
				R = R + 2
			EndIf
					
			If pHurt = False And bHit = False Then
				'Color 255, 0, 0
				';Rect pX + 16, pY + 20, 40, 40, 1
				
				Local tmpImg:TImage
				
				If V = 0 Then 
					tmpImg = imgLaser
				ElseIf V = 1 Then
					tmpImg = imgPump
				ElseIf V = 2 Then
					tmpImg = imgFire
				EndIf

				If ImageRectCollide(tmpImg, Int((R * Cos(A) + X) + (-scrollX)), Int(R * Sin(A) + Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
					If pLife > 0 Then
						PlaySFX sfxHit2

						pLife = pLife - 1
						pHurt = True; pHurtT = GetMilliSecs()		
						Del = True		
					EndIf
				EndIf
				
			EndIf	
			
			If Del = False Then ' // Fader
				If GetMilliSecs() >= T2 + 60 Then
					o:Obj = New Obj
					o.ID = OBJ_FADER
					o.X = Int((R * Cos(A) + X))
					o.Y = Int(R * Sin(A) + Y)
					o.Alp = .75; o.V = V; o.F = F
					objList.AddLast o	
					T2 = GetMilliSecs()
				EndIf
			EndIf
			
			If (V = 1 Or V = 2) And bBoss <> True Then ' // Kill If boss dies
				Del = True
			EndIf
				
			If Int((R * Cos(A) + X)) <= Int(scrollX - 17) Then Del = True
			If Int(R * Cos(A) + X) >= Int(scrollX + 588) Then Del = True
			If Int(Y) <= -16 Then Del = True
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² LIZARD SHOT                                     
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
			Case PART_SHOT
			SetBlend LIGHTBLEND; SetAlpha .9; SetScale sclX, sclY
			DrawImage imgShot, X + (-scrollX), Int(Y), F
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			If GetMilliSecs() >= T + 80 Then
				If D = 1 Then
					If F = 0 Then F = 1 Else F = 0
				Else
					If F = 2 Then F = 3 Else F = 2
				EndIf
				T = GetMilliSecs()
			EndIf
					
			If D = 1 Then
				X = X + 6
			Else
				X = X - 6
			EndIf
			
			If Int(X + (-scrollX) + 37) >= 0 And (X + (-scrollX)) <= 588 Then
				cY = Int(Y + Rand(0, 12))
				If D = 1 Then cX = Int(X + 23) ElseIf D = 0 Then cX = Int(X + 11)
				createP = 1
			Else
				Del = True
			EndIf
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² WAND SHOT                                   
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
			Case PART_WAND
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			Local tmpOff:Int = 0
			If D = 1 Then tmpOff = 2
			DrawImage imgBlast, X + (-scrollX), Int(Y), F + tmpOff
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
						
			If GetMilliSecs() >= T + 60 Then
				If F = 0 Then F = 1 Else F = 0
				T = GetMilliSecs()
			EndIf

			If D = 1 Then
				X = X + 4
			Else
				X = X - 4
			EndIf
			
			Y = Y - 3

			If (X + (-scrollX) + 37) >= 0 And (X + (-scrollX)) <= 588 Then
			Else
				Del = True
			EndIf

			If Y > -32 Then
			Else
				Del = True
			EndIf
							
			If Del = False Then ' // Faders
				cY = Int(Y + Rand(6, 26))
				cX = Int(X + Rand(10, 27))
				createP = 1
			EndIf
				
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² SHOT FADE                                     
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
			Case PART_FADE
			SetBlend LIGHTBLEND; SetAlpha Alp; SetScale 1, 1
			If C2 = 0 Then SetColor 252, 188, 176 ElseIf C2 = 1 Then SetColor 252, 252, 252
			If C2 = 2 Then SetColor 128, 0, 240 ElseIf C2 = 3 Then SetColor 252, 188, 176
			
			DrawRect X + (-scrollX), Int(Y), 3, 3
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

			If Alp > 0 Then Alp:-D Else Del = True
									
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² RISING PARTICLE                                     
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
			Case PART_RISER
			SetBlend LIGHTBLEND; SetAlpha Alp; SetScale 1, 1
			'If C2 = 0 Then SetColor 192, 223, 255 ElseIf C2 = 1 Then SetColor 100, 176, 255
			If C2 = 0 Then SetColor 223, 255, 192 ElseIf C2 = 1 Then SetColor 176, 255, 100
			If C2 = 3 Then SetColor 216, 40, 0 ElseIf C2 = 4 Then SetColor 252, 116, 96 ElseIf C2 = 5 Then SetColor 164, 0, 0
			
			DrawRect X + (-scrollX), Y, 4, 4
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255
						
			Y:-V
			If Alp > 0 Then Alp:-D Else Del = True
									
		End Select
				
		If Del = True Then partList.Remove p
		
		If createP <> 0 Then
			If createP = 1 Then ' // Shot fade
				'For Local i:Int = 1 To 2
					p:Part = New Part
					p.ID = PART_FADE; p.X = cX; p.Y = cY; p.Alp = 1					
					If curLevel[curPlayer-1] = 2 Then ' // Lizard shot
						p.C2 = Rand(0, 1)
						p.D = Rnd(.025, .075)						
					ElseIf curLevel[curPlayer-1] = 3 Then ' // Wand blast
						p.C2 = Rand(2, 3)
						p.D = Rnd(.025, .075)						
					EndIf
					partList.AddLast p				
				'Next
			
			EndIf
		EndIf
		
	End Method
		
End Type


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² OBJECTS                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Obj    
    Field X:Float, Y:Float, A:Int, ID:Int
	Field R:Float, V:Float, VS:Float, D:Int, F:Int, T:Int, Txt:String, L:Int
	Field Die:Int, YI:Float, Alp:Float, myType:Int, C2:Int, S:Int
	
    Function Create:Obj(X:Float, Y:Float, ID:Int, T:Int = 0)
		o:Obj = New Obj
		o.X = X; o.Y = Y; o.ID = ID
		
		If ID = OBJ_DROP Then ' // Blood drop
			o.A = 0 ' // Fall
			o.L = 0 ' // Drip count
			o.D = Rand(10, 30) ' // Fall time
			o.T = GetMilliSecs()
			o.VS = 1 ' // Y Scale
			o.myType = T ' // Title or game
			If T = 1 Then o.D = 0
			o.F = 0 ' // Color
			
		ElseIf ID = OBJ_CANDY Then ' // Align to grid
			
		EndIf
		
		Return o
	End Function
	
	Method Render(rLayer:Int) ' // Front / back
        Local Del:Int = False
		
		Local createO:Int = False
		Local cX:Int, cY:Int, cD:Int, cF:Int
		
		Local bHit:Int = False
		
		If rLayer = 0 Then ' // Back layer
		Select ID	
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² DROP                                         
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case OBJ_DROP
			SetBlend ALPHABLEND; SetAlpha .85; SetScale 1, VS
			If myType = 0 Then ' // Blood
				DrawImage imgDrop, X + (-scrollX), Y
			ElseIf myType = 1 Then ' // Acid
				DrawImage imgDrop3, X + (-scrollX), Y
			ElseIf myType = 2 Then ' // Water
				DrawImage imgDrop, X + (-scrollX), Y
			
				'DrawImage imgDrop2, Int(X + (-scrollX)), Int(Y)
			EndIf
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
							
			If A = 0 Then ' // Drip
				If GetMilliSecs() >= T + 30 Then
					VS = 1 + Rnd(-.1, .1)
					If L < D Then L:+1 Else A = 1; VS = 1
					T = GetMilliSecs()
				EndIf
				
			ElseIf A = 1 Then ' // Fall
				Y = Y + 4
				
			EndIf
			
			'DebugLog "DROP" + String(myType)
			
			Local tmpY:Int
			If myType = 0 Then ' // Title
				If F = 0 Then tmpY = (382 - ebbF) - 16
			ElseIf myType = 1 Or myType = 2 Then ' // Level
				tmpY = 304 - 16
			EndIf
						
			If myType <> 0 Then ' // Level drop
				If pHurt = False And bHit = False Then			
					If ImageRectCollide(imgDrop, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
						If pLife > 0 Then
							PlaySFX sfxHit2
	
							pLife = pLife - 1
							pHurt = True; pHurtT = GetMilliSecs()					
						EndIf
						Del = True
					EndIf
					
				EndIf
			EndIf
					
			If Y >= tmpY Or Del = True Then
				Local myT:Int = 0
				If myType = 1 Then myT = 10
				For Local i:Int = 1 To 10
					partList.AddLast part.Create(Int(X) + 4, Int(Y) + 16, PART_SPLASH, myT)
				Next
				Del = True
			EndIf			
		

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² DOG / SNAIL                                    
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //				
			Case OBJ_DOG, OBJ_SNAIL
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
						
			Local tmpImage:TImage
			If ID = OBJ_DOG Then tmpImage = imgDog ElseIf ID = OBJ_SNAIL Then tmpImage = imgSnail
			
			DrawImage tmpImage, X + (-scrollX), Y, F
			
			If Die = False Then ' // DIE BLOCK
			If D = 0 Then
				If ID = OBJ_DOG Then X = X - 2 ElseIf ID = OBJ_SNAIL Then X:-1
			Else
				X = X + 2
			EndIf
					
			If D = 0 Then
				If X <= (scrollX - 74) Then Del = True
			Else
				If X >= (scrollX + 588) Then Del = True
			EndIf
			
			If bBoss = True Then Del = True
							
			If ID = OBJ_DOG Then
				If D = 0 And (X <= scrollX + 147) Then ' // Chase
					If Rand(1, 70) = 35 Then 
						D = 1; F = 2
					EndIf
				ElseIf D = 1 And (X >= scrollX + 405) Then
					If Rand(1, 70) = 35 Then
						D = 0; F = 0
					EndIf
				EndIf
			EndIf

			If bDebug = True Then
				SetColor 255, 0, 0
				DrawRect Int(X + (-scrollX)), Int(Y) + 32, 32, 4
				SetColor 255, 255, 255
			EndIf
									
			If PlayerCheck() = True Then ' // Check collosion
				If bDebug = True Then
					SetColor 255, 0, 0
					DrawRect pX + 8, pY + 60, 24, 4
					SetColor 255, 255, 255
				EndIf
				
				If ImageRectCollide(tmpImage, Int(X + (-scrollX)), Int(Y), F, Int(pX + 8), Int(pY + 60), 24, 4) Then
					pJV = 7 ' // Bounce
					pJ = True
					pY:-4 ' // Double enemy fix
					Die = True; YI = -3
					PlaySFX sfxHit
					PlaySFX sfxDie
					jumpC = jumpC + 1
					AddScore (100 * jumpC)
					
					gloHit = True; hitX = Int((pX + 37) + scrollX); hitY = Int(pY + 64); hitT = GetMilliSecs()

					If ID = OBJ_DOG Then
						partList.AddLast part.Create(Int(X) + 37, Int(Y) - 24, PART_SCORE, (100 * jumpC))
					ElseIf ID = OBJ_SNAIL Then			
						partList.AddLast part.Create(Int(X) + 35, Int(Y) - 24, PART_SCORE, (100 * jumpC))
					EndIf
									
					bHit = True
				EndIf
			Else ' // Hurt
				If pHurt = False And bHit = False Then
					If bDebug = True Then
						SetColor 255, 0, 0
						DrawRect Int(pX + 16), Int(pY + 20), 20, 20
						SetColor 255, 255, 255
					EndIf
					
					If ImageRectCollide(tmpImage, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
						If pLife > 0 Then
							Playsfx sfxHit2
	
							pLife = pLife - 1
							pHurt = True; pHurtT = GetMilliSecs()					
						EndIf
					EndIf
					
				EndIf			
			EndIf
			
			If Del = False Then
				Local tmpT:Int = 200
				'If ID = OBJ_SNAIL Then tmpT = 400
				If GetMilliSecs() >= T + tmpT Then
					If D = 0 Then
						If F = 0 Then 
							F = 1
						Else
							F = 0
						EndIf
					Else
						If F = 2 Then 
							F = 3
						Else
							F = 2
						EndIf
					EndIf
									
					T = GetMilliSecs()
				EndIf
			EndIf

			ElseIf Die = True Then ' // END DIE BLOCK
				Y:+YI
				If YI < 6 Then YI:+.25 Else YI = 6
				If Y >= 368 Then Del = True
			
			EndIf
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² CLOUD                                         
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //				
			Case OBJ_CLOUD
			SetBlend ALPHABLEND; SetAlpha .85; SetScale sclX, sclY
			If V = 1 Then ' // Riding
				If GetMilliSecs() >= C2 + 10000 Then
					If Rand(0, 1) = 1 Then DrawImage imgCloud, X + (-scrollX), Y
				Else
					DrawImage imgCloud, X + (-scrollX), Y
				EndIf
			Else
				DrawImage imgCloud, X + (-scrollX), Y
			EndIf
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
			If A = 0 Then
				X = X - 1
			
				If X <= (scrollX - 74) Then Del = True
				
			ElseIf A = 1 Then ' // Riding
				X = X + 1.5
				
			EndIf
			
			Local tmpRand:Int ' // Difficulty switch
			If bHard[curPlayer-1] = True Then
				tmpRand = 70
			Else
				If cfgDiff = 0 Then tmpRand = 100 ElseIf cfgDiff = 1 Then tmpRand = 80
			EndIf
			
			If Rand(1, tmpRand) = Int(tmpRand / 2) And Del = False Then ' // Create drop
				cX = Int(X); cY = Int(Y)
				createO = 1 ' // Create drop
			EndIf
			
			If Del = False Then
				Local col1:Int = 16, col2:Int = 46
				
				If RectsOverlap(Int(X + (-scrollX)), Int(Y), Int(32 * sclX), Int(8), Int(pX + col1), Int(pY + 64), col2, 8) Then
					If pJ = True And pJV < 0 Then
						pJ = False
						pY = Y - 64
						jumpC = 0
						If pD = 0 Then pF = 6 Else pF = 0
					ElseIf pFall = True Then
						pY = Y - 64
					EndIf				
					bPlat = True
					pFall = False					
				EndIf
			
				' // Move with it
				If RectsOverlap(Int(X + (-scrollX)), Int(Y), Int(32 * sclX), Int(8), Int(pX + col1), Int(pY + 64), col2, 8) Then
					If pJ = False And pDeath = False Then
						If pX >= 268 Then
							scrollX = scrollX + 1.5
							tileX:+1.5
							caveX1:+1.125						
						Else
							pX:+1.5
						EndIf
						If A = 0 Then A = 1; V = 1; C2 = GetMilliSecs()
					EndIf
				Else
					A = 0
				EndIf
			EndIf
			
			If V = 1 And GetMilliSecs() >= C2 + 13000 Then Del = True
				
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² EYEBALL                                         
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //				
			Case OBJ_EYEBALL
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			DrawImage imgEye, X + (-scrollX), Y, F
			
			If Die = False Then ' // DIE BLOCK
			X:-1
					
			If X <= (scrollX - 37) Then Del = True
			
			If GetMilliSecs() >= T + 200 Then
				If F = 0 Then F = 1	Else F = 0
								
				T = GetMilliSecs()
			EndIf
			
			If PlayerCheck() = True Then ' // Check collosion
				'Color 255, 0, 0
				';Rect pX + 16, pY + 60, 32, 1, 1
				
				If ImageRectCollide(imgEye, Int(X + (-scrollX)), Int(Y), F, Int(pX + 8), Int(pY + 60), 24, 4) Then
					pJV = 7 ' // Bounce
					pY:-4 ' // Double enemy fix
					pJ = True

					gloHit = True; hitX = Int((pX + 37) + scrollX); hitY = Int(pY + 64); hitT = GetMilliSecs()
					
					If L = 1 Then
						L = 0
						PlaySFX sfxHit
					Else
						Die = True; YI = -3
						PlaySFX sfxHit
						PlaySFX sfxDie
						jumpC = jumpC + 1
						AddScore (200 * jumpC)
					
						partList.AddLast part.Create(Int(X) + 21, Int(Y) - 24, PART_SCORE, (200 * jumpC))															
					EndIf
					bHit = True
				EndIf
			Else ' // Hurt
				If pHurt = False And bHit = False Then
					'Color 255, 0, 0
					';Rect pX + 16, pY + 20, 40, 40, 1
				
					If ImageRectCollide(imgEye, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
						If pLife > 0 Then
							PlaySFX sfxHit2
	
							pLife = pLife - 1
							pHurt = True; pHurtT = GetMilliSecs()					
						EndIf
					EndIf
					
				EndIf			
			EndIf

			' // Lasers
			If Int(pX + 96) < Int(X + (-scrollX)) And Int(X + (-scrollX)) < 551 And Del = False Then
				'If bHard = False Then tmpRand = 75 Else tmpRand = 50
				Local tmpRand:Int
				If bHard[curPlayer-1] = True Then
					tmpRand = 50
				Else
					If cfgDiff = 0 Then tmpRand = 100 ElseIf cfgDiff = 1 Then tmpRand = 75
				EndIf				
				
				If Rand(1, tmpRand) = Int(tmpRand / 2) And NoLaser(2) = True Then ' // Shoot laser
					'tmpX = o\X: tmpY = o\Y
					'CreateLaser(tmpX, tmpY)

					partList.AddLast part.Create(Int(X), Int(Y) + 14, PART_LASER)															
					PlaySFX sfxLaser
				EndIf
			EndIf
						
			ElseIf Die = True Then ' // END DIE BLOCK
				Y:+YI
				If YI < 6 Then YI:+.25 Else YI = 6
				If Y >= 368 Then Del = True			
			EndIf		
						
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² PLATFORM                                         
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //				
			Case OBJ_PLAT
			If curLevel[curPlayer-1] = 1 Then
				DrawImage imgFloat, X + (-scrollX), Int(Y), F
			ElseIf curLevel[curPlayer-1] = 2 Then
				DrawImage imgFloat2, X + (-scrollX), Int(Y), 0
			EndIf
						
			Local col1:Int, col2:Int
			If curLevel[curPlayer-1] = 1 Then
				col1 = 16; col2 = 46
			ElseIf curLevel[curPlayer-1] = 2 Then
				If pD = 1 Then
					col1 = 10; col2 = 46
				ElseIf pD = 0 Then
					col1 = 14; col2 = 46
				EndIf				
			EndIf
			
			If bDebug = True Then
				SetColor 255, 0, 0
				'DrawRect X + (-scrollX), Y, 16, 4
				DrawRect Int(pX + col1), Int(pY + 64), col2 / 2, 8 / 2
				SetColor 255, 255, 255
			EndIf
			
			If RectsOverlap(Int(X + (-scrollX)), Int(Y), Int(16 * sclX), Int(8), Int(pX + col1), Int(pY + 64), col2, 8) Then
				If pJ = True And pJV < 0 Then
					pJ = False
					pY = Y - 64
					jumpC = 0
					If pD = 0 Then pF = 6 Else pF = 0
				ElseIf pFall = True Then
					pY = Y - 64					
				EndIf				
				bPlat = True
				pFall = False					
			EndIf
			
			If A = 1 Then ' // Vertical Movement
				If D = 0 Then
					If Y > R Then
						Y = Y - 1
					Else
						D = 1
						If F = 0 Then F = 1 Else F = 0
					EndIf
				Else
					If Y < V Then
						Y = Y + 1
					Else
						D = 0
						If F = 0 Then F = 1 Else F = 0
					EndIf
				EndIf
	
				' // Move with it
				If RectsOverlap(Int(X + (-scrollX)), Int(Y), Int(16 * sclX), Int(8), Int(pX + col1), Int(pY + 64), col2, 8) Then
					If pJ = False And pDeath = False Then
						pY = Y - 64
					EndIf
				EndIf
				
			ElseIf A = 2 Then ' // Horizontal Movement
				If D = 0 Then
					If X > V Then
						If C2 = 1 Then X:-1.5 Else X = X - 1
					Else
						D = 1
						If F = 0 Then F = 1 Else F = 0					
					EndIf
				Else
					If X < R Then
						If C2 = 1 Then X:+1.5 Else X = X + 1
					Else
						D = 0
						If F = 0 Then F = 1 Else F = 0					
					EndIf
				EndIf
	
				' // Move with it
				If RectsOverlap(Int(X + (-scrollX)), Int(Y), Int(16 * sclX), Int(8), Int(pX + col1), Int(pY + 64), col2, 8) Then
					If pJ = False And pDeath = False Then
						If D = 0 Then 
							If pX <= 242 Then
								If C2 = 1 Then
									scrollX = scrollX - 1.5
									tileX:-1.5
									caveX1:-1.125						
								Else
									scrollX = scrollX - 1
									tileX:-1
									caveX1:-.75
								EndIf
							Else
								If C2 = 1 Then pX:-1.5 Else pX = pX - 1 
							EndIf
						Else 
							If pX >= 268 Then
								If C2 = 1 Then
									scrollX = scrollX + 1.5
									tileX:+1.5
									caveX1:+1.125						
								Else
									scrollX = scrollX + 1
									tileX:+1
									caveX1:+.75						
								EndIf
							Else
								If C2 = 1 Then pX:+1.5 Else pX = pX + 1						
							EndIf
						EndIf
					EndIf
				EndIf
					
			EndIf

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² HEALTH                                         
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
			Case OBJ_HEALTH
			DrawImage imgPickup, X + (-scrollX), Y, F
			
			If bDebug = True Then
				SetColor 255, 0, 0
				DrawRect Int(pX + 16), Int(pY + 20), 20, 20
				SetColor 255, 255, 255
			EndIf
			
			If ImageRectCollide(imgPickup, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
				If F <> 2 Then
					Local tmpL:Int = 3
					If cfgDiff = 0 Then tmpL = 5
					If pLife < tmpL Then 
						pLife = pLife + 1
					Else ' // Already full health, give points
						AddScore + 500
					EndIf
				Else ' // ?
					AddScore 500
					bAlien[curPlayer-1] = True
				EndIf
				
				PlaySFX sfxPickup2
				Del = True
			EndIf			

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² CANDY                                         
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
			Case OBJ_CANDY
			DrawImage imgCandy, X + (-scrollX) + 2, Y - 2, F
			
			If bDebug = True Then
				SetColor 255, 0, 0
				DrawRect Int(pX + 16), Int(pY + 20), 20, 20
				SetColor 255, 255, 255
			EndIf
			
			If ImageRectCollide(imgCandy, Int(X + (-scrollX)) + 2, Int(Y) - 2, 0, Int(pX + 16), Int(pY + 20), 20, 20) Then
				PlaySFX sfxPick
				Del = True
				AddScore 250
				
				For Local i:Int = 1 To 20
					p:Part = New Part
					p.ID = PART_SPLASH; p.X = Int(X) + 16; p.Y = Int(Y) + 4
					p.myType = TYPE_CANDY
					p.Alp = 1
		
					p.A = Rand(0, 360)
					p.S = Rnd(1, 2.5)
					p.D = Rnd(.075, .1)				
			
					p.myType = TYPE_CANDY
					p.R = 0
					p.C2 = Rand(0, 1)	
								
					Select F
						Case 0
						p.Col1[0] = 252; p.Col1[1] = 188; p.Col1[2] = 176
						p.Col2[0] = 128; p.Col2[1] = 0; p.Col2[2] = 240
						
						Case 1
						p.Col1[0] = 176; p.Col1[1] = 188; p.Col1[2] = 252
						p.Col2[0] = 240; p.Col2[1] = 0; p.Col2[2] = 128

						Case 2
						p.Col1[0] = 188; p.Col1[1] = 252; p.Col1[2] = 176
						p.Col2[0] = 0; p.Col2[1] = 128; p.Col2[2] = 240
						
						Case 3
						p.Col1[0] = 188; p.Col1[1] = 176; p.Col1[2] = 252
						p.Col2[0] = 0; p.Col2[1] = 240; p.Col2[2] = 128

						Case 4
						p.Col1[0] = 252; p.Col1[1] = 176; p.Col1[2] = 188
						p.Col2[0] = 128; p.Col2[1] = 240; p.Col2[2] = 0
						
						Case 5
						p.Col1[0] = 176; p.Col1[1] = 252; p.Col1[2] = 188
						p.Col2[0] = 240; p.Col2[1] = 128; p.Col2[2] = 0
						
					End Select
						
					partList.AddLast p
				Next
				
			EndIf	
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² FADER                                       
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_FADER
			SetBlend ALPHABLEND; SetAlpha Alp
			If V <> 3 Then SetScale 1, 1 Else SetScale sclX, sclY
						
			If V = 0 Then
				DrawImage imgLaser, X + (-scrollX), Y, F
			ElseIf V = 1 Then
				DrawImage imgPump, X + (-scrollX), Y, F
			ElseIf V = 2 Then
				DrawImage imgFire, X + (-scrollX), Y, F
			ElseIf V = 3 Then
				DrawImage imgGhost, X + (-scrollX), Y, F
			EndIf
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			'If Alp > 0 Then Alp:-.01 Else Del = True
			
			If V <> 3 Then
				If Alp > 0 Then Alp:-.04 Else Del = True
			Else
				If Alp > 0 Then Alp:-.01 Else Del = True
			EndIf
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² ANIMAL                                        
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_ANIMAL
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			If D = 0 Then
				DrawImage imgFlip, X + (-scrollX), Y, F
			ElseIf D = 1 Then
				DrawImage imgMonkey, Int(X + (-scrollX)), Y, F
			ElseIf D = 2 Then
				DrawImage imgWolf, Int(X + (-scrollX)), Y, F	
			ElseIf D = 3 Then ' // Mark
				DrawImage imgMark, Int(X + (-scrollX)), Y, F			
			EndIf
			
			If D <> 3 Then		
				If GetMilliSecs() >= T + 200 Then
					If F < 2 Then F = F + 1 Else F = 0
					T = GetMilliSecs()
				EndIf
			EndIf
			
			';Color 255, 0, 0
			'Rect pX + 16, pY + 20, 30, 40
			
			Local tmpTransform:Int = bTransform
			If b2Player = True Then
				If curPlayer = 1 Then tmpTransform = bTransform ElseIf curPlayer = 2 Then tmpTransform = b2Transform
			EndIf
			
			' // Welcome msg
			If D = 0 Then
				If ImageRectCollide(imgFlip, Int(X + (-scrollX)), Int(Y), F, Int(pX + 18), Int(pY + 20), 46, 46) Then
					SetScale 1, 1
					If tmpTransform Mod 2 = 0 Then
						DrawImage imgWelcome, Int(X + (-scrollX)) - 80, Int(Y) - 40
					Else
						DrawImage imgWelcomeo, Int(X + (-scrollX)) - 80, Int(Y) - 40
					EndIf					
				EndIf
			ElseIf D = 1 Then
				If ImageRectCollide(imgMonkey, Int(X + (-scrollX)), Int(Y), F, Int(pX + 18), Int(pY + 20), 46, 46) Then
					SetScale 1, 1
					DrawImage imgWelcome2, Int(X + (-scrollX)) - 80, Int(Y) - 40
				EndIf
			ElseIf D = 2 Then
				If ImageRectCollide(imgWolf, Int(X + (-scrollX)), Int(Y), F, Int(pX + 18), Int(pY + 20), 35, 46) Then
					SetScale 1, 1
					If bAlien[curPlayer-1] = False Then
						DrawImage imgWelcome3, Int(X + (-scrollX)) - 70, Int(Y) - 40
					Else
						DrawImage imgWelcomeA, Int(X + (-scrollX)) - 77, Int(Y) - 40
					EndIf
				EndIf			
			ElseIf D = 3 Then ' // MARK

				For p:Part = EachIn partList ' // Check for shot collision
					
					If p.ID = PART_SHOT Then 
						If ImagesCollide(imgMark, Int(X + (-scrollX)), Int(Y), F, imgShot, Int(p.X + (-scrollX)), Int(p.Y), p.F) = True Then

							gloHit = True; hitY = Int(p.Y + 6); hitT = GetMilliSecs()
							If p.D = 0 Then hitX = Int(p.X) ElseIf p.D  = 1 Then hitX = Int(p.X + 37)
							partList.Remove p

							If Rand(1, 20) = 10 And bCandy = False Then ' // Give candy								
								createO = 2
								cX = X; cY = Y - 32
								bCandy = True
								PlaySFX sfxHug
							EndIf
							
							PlaySFX sfxDing
																					
							Exit
						EndIf
					EndIf
					
				Next 
								
			EndIf
			
			SetScale sclX, sclY
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² PUMPKIN                                       
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_PUMPKIN
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			DrawImage imgBoss1, X + (-scrollX), Y, F
			
			If GetMilliSecs() >= T + 150 Then
				If F < 3 Then F = F + 1 Else F = 0
				T = GetMilliSecs()
			EndIf
			
			If A = 1 Then ' // Raising
				If Y > 304 - 94 Then 
					Y = Y - 1 
				Else 
					A = 0; Y = 304 - 94
					PlaySFX sfxBoss
				EndIf
			Else
				Local tmpS:Int
				
				If L >= 8 Then 
					tmpS = 1
				ElseIf L >= 5 Then
					tmpS = 2
				Else
					tmpS = 3
				EndIf
												
				If D = 0 Then
					If Int(X + (-scrollX)) > 32 Then X = X - tmpS Else D = 1
				Else
					If Int(X + (-scrollX)) < 588 - 92 Then X = X + tmpS Else D = 0
				EndIf
				
				If Rand(1, 100) = 50 And R = 0 Then ' // Jump
					R = 1
					V = 7
				EndIf
				
				If R = 1 Then ' // Jumping
					Y = Y - V
					
					V = V - .4
						
					If Y >= 304 - 94 Then ' // Land
						Y = 304 - 94
						R = 0
					EndIf		
				EndIf
				
				If PlayerCheck() = True Then ' // Check collision
					'Color 255, 0, 0
					';Rect pX + 16, pY + 60, 32, 1, 1
					
					If ImageRectCollide(imgBoss1, Int(X + (-scrollX)), Int(Y), F, Int(pX + 8), Int(pY + 60), 24, 4) Then
						pJV = 7 ' // Bounce
						pY:-4 ' // Double enemy fix
						pJ = True

						If R = 1 And V > 0 Then V = 0 ' // Stop pumpkin jump
						
						gloHit = True; hitX = Int((pX + 37) + scrollX); hitY = Int(pY + 64); hitT = GetMilliSecs()
						
						If L > 1 Then
							L = L - 1
							PlaySFX sfxHit
							PlaySFX sfxBoss
						Else
							Del = True
							PlaySFX sfxHit							
							PlaySFX sfxDestroy
							jumpC = jumpC + 1
							AddScore 1000

							CreateParts(Int(X), Int(Y), 2)
							
							partList.AddLast part.Create(Int(X) + 31, Int(Y) - 24, PART_SCORE, (1000 * jumpC))															

							bBoss = 2 ' // Boss Dead
						EndIf
						bHit = True
					EndIf
				Else ' // Hurt
					If pHurt = False And bHit = False Then
						'Color 255, 0, 0
						';Rect pX + 16, pY + 20, 40, 40, 1
					
						If ImageRectCollide(imgBoss1, Int(X + (-scrollX)), Int(Y), Int(F), Int(pX + 16), Int(pY + 20), 20, 20) Then
							If pLife > 0 Then
								PlaySFX sfxHit2
		
								pLife = pLife - 1
								pHurt = True; pHurtT = GetMilliSecs()					
							EndIf
						EndIf
						
					EndIf			
				EndIf				
							
				Local tmpRand:Int
				If bHard[curPlayer-1] = True Then
					tmpRand = 40
				Else
					If cfgDiff = 0 Then tmpRand = 60 ElseIf cfgDiff = 1 Then tmpRand = 50
				EndIf	
												
				Local tmpLim:Int = 2
				If L <= 5 Then tmpLim:+1
				
				If Rand(1, tmpRand) = Int(tmpRand / 2) And NoLaser(tmpLim) = True And R = 0 And Del = False Then ' // Shoot laser
					partList.AddLast part.Create(Int(X) + 28, Int(Y) + 30, PART_LASER, 1)															

					PlaySFX sfxLaser
				EndIf
										
			EndIf

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² SERPENT
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //												
			Case OBJ_SNAKE
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
			Local bFire1:Int = False
			Local bPlume:Int = False
						
			If F <> -1 Then
				DrawImage imgBoss2, X + (-scrollX), Y, F
				
				For p:Part = EachIn partList ' // Check for shot collision
					
					If p.ID = PART_SHOT Then 
						If ImagesCollide(imgBoss2C, Int(X + (-scrollX)), Int(Y), F, imgShot, Int(p.X + (-scrollX)), Int(p.Y), p.F) = True Then

							gloHit = True; hitY = Int(p.Y + 6); hitT = GetMilliSecs()
							If p.D = 0 Then hitX = Int(p.X) ElseIf p.D  = 1 Then hitX = Int(p.X + 37)
							partList.Remove p
							
							If L > 1 Then
								L = L - 1
								PlaySFX sfxHit
								PlaySFX sfxBoss
							Else
								Del = True
								PlaySFX sfxHit
								PlaySFX sfxDestroy
								AddScore 1500
								
								'Int(X) + 28, Int(Y) + 30
								CreateParts(Int(X), Int(Y), 3)
								
								bBoss = 2 ' // Boss Dead
							EndIf
													
							Exit
						EndIf
					EndIf
					
				Next 
				
				If Del = False Then ' // Del check
				If pHurt = False And bHit = False Then
					'Color 255, 0, 0
					';Rect pX + 16, pY + 20, 40, 40, 1
					
					If ImageRectCollide(imgBoss2, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
						If pLife > 0 Then
							PlaySFX sfxHit2
		
							pLife = pLife - 1
							pHurt = True; pHurtT = GetMilliSecs()			
						EndIf
					EndIf
						
				EndIf
								
				If GetMilliSecs() >= T + 200 Then
					T = GetMilliSecs()
										
					If A = 0 Then ' // Rising
						Local tmpTime:Int = 500

						If bHard[curPlayer-1] = True Then
							tmpTime = 400
						Else
							If cfgDiff = 0 Then tmpTime = 600 ElseIf cfgDiff = 1 Then tmpTime = 500
						EndIf	
										
						If D = 0 Then
							If F < 5 Then 
								F = F + 1 
							Else 
								A = 1; bFire1 = True
								
								If L >= 8 Then
									T = GetMilliSecs() + tmpTime
								ElseIf L >= 5 Then
									T = GetMilliSecs() + (tmpTime - 200)
								Else
									T = GetMilliSecs() + (tmpTime - 400)
								EndIf								
							EndIf
							
						ElseIf D = 1 Then
							If F < 2 Then 
								F = F + 1 
							Else 
								A = 1; bFire1 = True

								If L >= 8 Then
									T = GetMilliSecs() + tmpTime
								ElseIf L >= 5 Then
									T = GetMilliSecs() + (tmpTime - 200)
								Else
									T = GetMilliSecs() + (tmpTime - 400)
								EndIf								
							EndIf
						EndIf
						
					Else
						If A = 1 Then
							If D = 0 Then
								If F > 3 Then F = F - 1 Else F = -1; V = 0
							ElseIf D = 1 Then
								If F > 0 Then F = F - 1 Else F = -1; V = 0
							EndIf
						EndIf
					EndIf
					
				EndIf
				EndIf ' // End del block
				
			Else ' // Under lava

				If GetMilliSecs() >= T + 1000 Then
					A = 0
					T = GetMilliSecs()
					
					If (pX + scrollX) + 32 >= X + 18 Then D = 1; F = 0 Else D = 0; F = 3
					
				Else
					If V = 0 And GetMilliSecs() >= T + 750 Then ' // Choose Next spot And Create plume
						Local tmpR:Int = Rand(0, 3)
						If tmpR = 3 Then X = 462 + scrollX
						If tmpR = 2 Then X = 302 + scrollX
						If tmpR = 1 Then X = 186 + scrollX
						If tmpR = 0 Then X = 34 + scrollX
						
						bPlume = True
						V = 1
						
					EndIf
				EndIf
			EndIf
			
			If Del = False Then
				If bFire1 = True Then ' // Shoot fireball
													
					Local tmpLim:Int = 1
					If L <= 5 And cfgDiff <> 0 Then tmpLim:+1
					If bHard[curPlayer-1] = True Then tmpLim:+1
					
					For Local i:Int = 1 To tmpLim
						p:Part = New Part
						p.Y = Y + 24; p.ID = PART_LASER; p.R = 0; p.V = 2
						p.Alp = .95
						p.T2 = GetMilliSecs()
						p.D = D
						If D = 0 Then
							p.A = Rand(170, 190)
							p.X = X + 17
						ElseIf D = 1
							p.A = Rand(-10, 10)
							p.X = X + 51
						EndIf			

						partList.AddLast p
					Next
					
					PlaySFX sfxFlame2
					
				EndIf
				
				If bPlume = True Then ' // Show plume
					PlaySFX sfxFlame3
												
					For Local i:Int = 1 To 20
						partList.AddLast part.Create(Int(X + Rand(21, 53)), Int(Y + 116), PART_SPLASH, 11)
					Next
				EndIf
			EndIf				
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² NIGHTMARE KING                                   
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_KING
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			DrawImage imgBoss3, X + (-scrollX), Y, F
					
			If A = 1 Then ' // Raising
				If Y > 304 - 220 Then 
					Y = Y - 2
				Else 
					A = 0; Y = 304 - 220
					PlaySFX sfxBoss
					D = GetMilliSecs() - 3000
				EndIf
			Else ' // Alive

				If pHurt = False And bHit = False Then
					'Color 255, 0, 0
					'	;Rect pX + 16, pY + 20, 40, 40, 1
				
					If ImageRectCollide(imgBoss3, Int(X + (-scrollX)), Int(Y), Int(F), Int(pX + 16), Int(pY + 20), 15, 20) Then
						If pLife > 0 Then
							PlaySFX sfxHit2
		
							pLife = pLife - 1
							pHurt = True; pHurtT = GetMilliSecs()					
						EndIf
					EndIf
						
				EndIf			
				
				For p:Part = EachIn partList ' // Check for shot collision
					
					If p.ID = PART_WAND Then 
					
						If bDebug = True Then
							SetColor 255, 0, 0
							If bAlien[curPlayer-1] = False Then
								DrawRect Int(X + (-scrollX) + 51), Y + 18, 19, 21
							Else
								DrawRect Int(X + (-scrollX) + 4), Y + 34, 19, 21
							EndIf
											
							SetColor 255, 255, 255
						EndIf
						
						Local tmpCX:Int = 51, tmpCY:Int = 18
						If bAlien[curPlayer-1] = True Then tmpCX = 4; tmpCY:Int = 34
						
						'o\X + (-scrollX) + 44, o\Y + 18, 38, 42
						If RectsOverlap(Int(X + (-scrollX) + tmpCX), Int(Y + tmpCY), 38, 42, Int(p.X + (-scrollX)), Int(p.Y), 37, 32) = True Then

							gloHit = True; hitY = Int(p.Y + 16); hitT = GetMilliSecs()
							If p.D = 0 Then hitX = Int(p.X + 18) ElseIf p.D  = 1 Then hitX = Int(p.X + 18)
							partList.Remove p

							If L > 1 Then
								L = L - 1
								PlaySFX sfxHit
								PlaySFX sfxBoss
							Else
								Del = True
								PlaySFX sfxHit								
								PlaySFX sfxKing
								AddScore 2500
								
								CreateParts(Int(X), Int(Y), 4)
								
								bBoss = 2 ' // Boss Dead
							EndIf
																					
							Exit
						EndIf
					EndIf
					
				Next 
				
				If Del = False Then
					Local tmpT:Int, tmpRand:Int 
					If L >= 15 Then
						tmpT = 2000
						tmpRand = 5000
											
					ElseIf L >= 10 Then
						tmpT = 1750
						tmpRand = 4500
					
					ElseIf L >= 5 Then
						tmpT = 1500
						tmpRand = 4000
					
					Else
						tmpT = 1250
						tmpRand = 3500
					
					EndIf
					
					If GetMilliSecs() >= D + tmpRand Then ' // Create spikes
						'CreateSpikes
						'createO = 7	
						bSpikes = True ' // Create spikes
											
						D = GetMilliSecs()
					EndIf
					
					If GetMilliSecs() >= R + tmpT And faceCount <= 1 Then
						'tmpX = o\X: tmpY = o\Y: tmpD = o\D
						cX = X; cY = Y; cD = D
						
						If L >= 10 Then
							cF = 1
						Else
							cF = 2
						EndIf
						
						createO = 6
						R = GetMilliSecs()
						faceCount:+1
					EndIf
				EndIf
						
			EndIf
						
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² EGG                                     
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_EGG
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			DrawImage imgEgg, X + (-scrollX), Int(Y), F
			
			If A = 0 Then ' // Whole
			
				For p:Part = EachIn partList ' // Check for shot collision
					
					If p.ID = PART_SHOT Then 
						If ImagesCollide(imgEgg, Int(X + (-scrollX)), Int(Y), F, imgShot, Int(p.X + (-scrollX)), Int(p.Y), p.F) = True Then

							If L <> 0 Then ' // Secret egg
								If L = 1 And p.D = 0 Then
									L = 2
								ElseIf L = 2 And p.D = 1 Then
									L = 3
								ElseIf L = 3 And p.D = 0 Then
									L = 4 ' // Alien queen unlocked
								EndIf
							EndIf
							
							Local oldD:Int = p.D
							gloHit = True; hitY = Int(p.Y + 6); hitT = GetMilliSecs()
							If p.D = 0 Then hitX = Int(p.X) ElseIf p.D  = 1 Then hitX = Int(p.X + 37)
						
							R:-1 ' // Life
							partList.Remove p

							If R > 0 Then
								PlaySFX sfxHit

							Else
								A = 1; F = 1
							
								For Local i:Int = 1 To 15
									partList.AddLast part.Create(Int(X + Rand(4, 26)), Int(Y + 14), PART_RISER, Rand(0, 1))															
								Next
								
								If L <> 4 Then ' // Normal egg
									Local tmpR:Int = Rand(1, 4)
									'tmpR = 3 ' // ! All huggers, all the time
									If tmpR <> 4 Then PlaySFX sfxPoof Else PlaySFX sfxHug

									If tmpR = 1 Then ' // No item
									ElseIf tmpR = 2 Or tmpR = 3 Then ' // Candy
										createO = 2
										cX = X; cY = Y - 32
									ElseIf tmpR = 4 Then ' // Face hugger
										createO = 3
										cX = X; cY = Y - 32
										If oldD = 0 Then cD = 1 ElseIf oldD = 1 Then cD = 0								
									EndIf
								Else ' // Secret egg
									PlaySFX sfxHug
									
									If bCandy = True Then ' // Secret vs. hugger
										createO = 4
										cX = X; cY = Y - 64								
									Else
										createO = 3
										cX = X; cY = Y - 32
										If oldD = 0 Then cD = 1 ElseIf oldD = 1 Then cD = 0								
									EndIf
									
								EndIf
								
							EndIf
											
							Exit
						EndIf
					EndIf
					
				Next 

				
			EndIf
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² SKELETON                                  
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_SKEL
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			DrawImage imgSkel, X + (-scrollX), Y, F
			
			If Die = False Then
			If D = 0 Then
				If R = 1 Then X = X - 1 Else X = X - 2
				If X <= (scrollX - 74) Then Del = True
			Else
				If R = 1 Then X = X + 1 Else X = X + 2
				If X >= (scrollX + 588) Then Del = True
			EndIf
							
			If bBoss = True Then Del = True
				
			If D = 0 And (X <= scrollX + 147) Then ' // Chase
				If Rand(1, 70) = 35 Then D = 1; F = 2
			ElseIf D = 1 And (X >= scrollX + 405) Then
				If Rand(1, 70) = 35 Then D = 0; F = 0
			EndIf

			If Rand(1, 100) = 50 And R = 0 Then ' // Jump
				R = 1
				V = 7
			EndIf
				
			If R = 1 Then ' // Jumping
				Y = Y - V					
				V = V - .4
						
				If Y >= 240 Then ' // Land
					Y = 240
					R = 0
				EndIf		
			EndIf
			
			If Del = False Then
				For p:Part = EachIn partList ' // Check for shot collision
					
					If p.ID = PART_SHOT Then 
						If ImagesCollide(imgSkel, Int(X + (-scrollX)), Int(Y), F, imgShot, Int(p.X + (-scrollX)), Int(p.Y), p.F) = True Then

							gloHit = True; hitY = Int(p.Y + 6); hitT = GetMilliSecs()
							If p.D = 0 Then hitX = Int(p.X) ElseIf p.D  = 1 Then hitX = Int(p.X + 37)
							partList.Remove p

							If L > 0 Then
								PlaySFX sfxHit
								L:-1
							Else
								Die = True; YI = -3
								PlaySFX sfxHit
								PlaySFX sfxDie
								AddScore 200
									
							EndIf
											
							Exit
						EndIf
					EndIf
					
				Next 
			EndIf
						
			If pHurt = False And Del = False Then
				'Color 255, 0, 0
				';Rect pX + 16, pY + 20, 40, 40, 1
				
				If ImageRectCollide(imgSkel, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
					If pLife > 0 Then
						PlaySFX sfxHit2
	
						pLife = pLife - 1
						pHurt = True; pHurtT = GetMilliSecs()					
					EndIf
				EndIf
					
			EndIf
				
			If GetMilliSecs() >= T + 200 Then
				If D = 0 Then
					If F = 0 Then F = 1 Else F = 0
				Else
					If F = 2 Then F = 3 Else F = 2
				EndIf
								
				T = GetMilliSecs()
			EndIf
			
			Else ' // Die block
				Y:+YI
				If YI < 6 Then YI:+.25 Else YI = 6
				If Y >= 368 Then Del = True				
			EndIf		

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² FISH
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_FISH
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			If Die = False Then ' // Die block
			If A = 0 Then ' // Splash
				A = 1
				PlaySFX sfxFlame2

				For Local i:Int = 1 To 20
					partList.AddLast part.Create(Int(X + Rand(0, 36)), Int(Y), PART_SPLASH, 12)
				Next

				C2 = GetMilliSecs()
				
			ElseIf A = 1 Then ' // Spawn
			
				If GetMilliSecs() >= C2 + 250 Then A = 2; F = 1
				
			ElseIf A = 2 Then ' // Jumping
				DrawImage imgFish, X + (-scrollX), Int(Y), F
				
				Y:+YI
				If YI < 4 Then YI:+.1
				X:-1
				
				If YI > 0 Then
					If Y >= 304 - 44 Then A = 3 ' // Walk
				EndIf
				
				If X <= (scrollX - 37) Then Del = True
				
			ElseIf A = 3 Then ' // Walking

				DrawImage imgFish, X + (-scrollX), Int(Y), F
				
				If GetMilliSecs() >= C2 + 120 Then
					If F = 0 Then F = 1 Else F = 0
					C2 = GetMilliSecs()
				EndIf			

				If X <= (scrollX - 37) Then Del = True Else X:-2

			EndIf

			If (A = 2 Or A = 3) And Del = False Then
			
				If bDebug = True Then
					SetColor 255, 0, 0
					DrawRect Int(pX + 16), Int(pY + 20), 15, 20
					SetColor 255, 255, 255
				EndIf

				For p:Part = EachIn partList ' // Check for shot collision
					
					If p.ID = PART_WAND Then 
						If ImagesCollide(imgFish, Int(X + (-scrollX)), Int(Y), F, imgBlast, Int(p.X + (-scrollX)), Int(p.Y), p.F) = True Then

							gloHit = True; hitY = Int(p.Y + 16); hitT = GetMilliSecs()
							If p.D = 0 Then hitX = Int(p.X + 18) ElseIf p.D  = 1 Then hitX = Int(p.X + 18)
							partList.Remove p

							Die = True; YI = -3
							
							PlaySFX sfxHit
							PlaySFX sfxDie
							AddScore 100
																					
							Exit
						EndIf
					EndIf
					
				Next 
									
				If pHurt = False Then
					If ImageRectCollide(imgFish, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 15, 20) Then
						If pLife > 0 Then
							PlaySFX sfxHit2
		
							pLife = pLife - 1
							pHurt = True; pHurtT = GetMilliSecs()	
						EndIf
					EndIf
				EndIf
				
			EndIf
			
			ElseIf Die = True Then ' // Die block
				DrawImage imgFish, X + (-scrollX), Int(Y), F
			
				Y:+YI
				If YI < 6 Then YI:+.25 Else YI = 6
				If Y >= 342 Then 
					'For Local i:Int = 1 To 10
					'	partList.AddLast part.Create(Int(X + Rand(0, 36)), Int(Y), PART_SPLASH, 12)
					'Next				
					Del = True					
				EndIf
			EndIf
			
			'If X <= (scrollX - 74) Then Del = True
						
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² COMET
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_COMET
			SetBlend LIGHTBLEND; SetAlpha .95; SetScale sclX, sclY		
			DrawImage imgIce, X + (-scrollX), Y, F
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
			X = X - 3
			Y = Y + 4
			
			If GetMilliSecs() >= T + 80 Then
				If F = 0 Then F = 1 Else F = 0
				T = GetMilliSecs()
			EndIf

			If pHurt = False And bHit = False Then
				'Color 255, 0, 0
				';Rect pX + 16, pY + 20, 40, 40, 1
				
				If ImageRectCollide(imgIce, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
					If pLife > 0 Then
						PlaySFX sfxHit2
	
						pLife = pLife - 1
						pHurt = True; pHurtT = GetMilliSecs()	
						Del = True				
					EndIf
				EndIf
					
			EndIf
			
			Local tmpY:Int
			If Del = True Then
				tmpY = Y + 32
			Else							
				If Y >= 304 - 32 Then Del = True; tmpY = 304
			EndIf
						
			If Del = True Then ' // Comet explosion
				'tmpX = o\X
				'CreateParts(tmpX + 8, tmpY, 4)
				PlaySFX sfxIce
			EndIf

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² SPIKES
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_SPIKE
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255
			Local tmpF:Int = 0
			If bAlien[curPlayer-1] = True Then tmpF = 1
			DrawImage imgSpikes, X + (-scrollX), Y, tmpF

			If pHurt = False And bHit = False Then
				'Color 255, 0, 0
				'	;Rect pX + 16, pY + 20, 30, 40, 1
			
				If ImageRectCollide(imgSpikes, Int(X + (-scrollX)), Int(Y), 0, Int(pX + 16), Int(pY + 20), 15, 20) Then
					If pLife > 0 Then
						PlaySFX sfxHit2
	
						pLife = pLife - 1
						pHurt = True; pHurtT = GetMilliSecs()					
					EndIf
				EndIf
					
			EndIf
									
			If GetMilliSecs() >= T + 1 Then
				If A = 0 Then
					If Y > 304 - 32 Then Y = Y - 1 Else A = 1
				Else
					If Y < 304 Then Y = Y + 1 Else Del = True
				EndIf
		
				T = GetMilliSecs()
			EndIf
			
			If bBoss <> True Then Del = True ' // Remove If boss dies
									
		End Select
		
		ElseIf rLayer = 1 Then ' // Front layer

		Select ID
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² FLAME JET                                       
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_FLAME
			SetBlend LIGHTBLEND; SetAlpha .9; SetScale sclX, sclY			
						
			If D = 0 Then
			
				If GetMilliSecs() >= T + 1000 Then
					D = 1; T = GetMilliSecs()
					F = 0
					' // Only play sound If in range
					If (X + (-scrollX) + 18) >= 0 And (X + (-scrollX) - 18) <= 588 Then
						PlaySFX sfxFlame
					EndIf
				EndIf
			Else
				DrawImage imgFlame, X + (-scrollX) - 18, Y, F
			
				If GetMilliSecs() >= T + 80 Then
					If F < 7 Then F = F + 1 Else F = 0; D = 0
					T = GetMilliSecs()
				EndIf

				If pHurt = False And bHit = False Then
				
					Local col1:Int, col2:Int
					If pD = 0 Then
						col1 = 16; col2 = 15
					ElseIf pD = 1 Then
						col1 = 24; col2 = 15
					EndIf
					
					If bDebug = True Then
						SetColor 255, 0, 0
						DrawRect Int(pX + col1), Int(pY + 20), col2, 20
						SetColor 255, 255, 255
					EndIf
					
					If ImageRectCollide(imgFlame, Int(X + (-scrollX) - 18), Int(Y), F, Int(pX + col1), Int(pY + 20), col2, 20) Then
						If pLife > 0 Then
							PlaySFX sfxHit2
		
							pLife = pLife - 1
							pHurt = True; pHurtT = GetMilliSecs()					
						EndIf
					EndIf
						
				EndIf
									
			EndIf

			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY			
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² FACE HUGGER                       
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //											
			Case OBJ_HUGGER
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY			

			DrawImage imgEgg, X + (-scrollX), Y, F
			
			If pHurt = False And bHit = False Then
				'Color 255, 0, 0
				';Rect pX + 16, pY + 20, 40, 40, 1
			
				If ImageRectCollide(imgEgg, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
					If pLife > 0 Then
						PlaySFX sfxHit2

						pLife = pLife - 1
						pHurt = True; pHurtT = GetMilliSecs()					
					EndIf
				EndIf
				
			EndIf	

			If D = 0 Then X:-3 ElseIf D = 1 Then X:+3
						
			Y:+V
			If V < 7 Then V:+.2 Else V = 7
							
			If Y >= 368 Then Del = True
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² GHOST
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_GHOST
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			DrawImage imgGhost, X + (-scrollX), Y, F
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
						
			If X <= (scrollX - 74) Then Del = True

			If Die = False And Del = False Then
				X:-1.5
				Y:+YI
				
				If D = 0 Then
					If YI < 4 Then YI:+.149 Else D = 1
				ElseIf D = 1 Then
					If YI > -4 Then YI:-.15 Else D = 0
				EndIf			
			
				If GetMilliSecs() >= T + 200 Then
					If F < 1 Then F:+1 Else F = 0
					T = GetMilliSecs()
				EndIf
							
				If Del = False Then
					For p:Part = EachIn partList ' // Check for shot collision
						
						If p.ID = PART_SHOT Then 
							If ImagesCollide(imgGhost, Int(X + (-scrollX)), Int(Y), F, imgShot, Int(p.X + (-scrollX)), Int(p.Y), p.F) = True Then

								gloHit = True; hitY = Int(p.Y + 6); hitT = GetMilliSecs()
								If p.D = 0 Then hitX = Int(p.X) ElseIf p.D  = 1 Then hitX = Int(p.X + 37)
								partList.Remove p

								Die = True; YI = -3
								PlaySFX sfxHit
								PlaySFX sfxDie
								AddScore 100
																						
								Exit
							EndIf
						EndIf
						
					Next 
				EndIf
							
				If pHurt = False And Del = False Then
					'Color 255, 0, 0
					';Rect pX + 16, pY + 20, 40, 40, 1
					
					If ImageRectCollide(imgGhost, Int(X + (-scrollX)), Int(Y), F, Int(pX + 16), Int(pY + 20), 20, 20) Then
						If pLife > 0 Then
							PlaySFX sfxHit2
		
							pLife = pLife - 1
							pHurt = True; pHurtT = GetMilliSecs()					
						EndIf
					EndIf
						
				EndIf
					
				If Del = False Then ' // Fader
					If GetMilliSecs() >= C2 + 120 Then
						cX = X; cY = Y; cF = F
						createO = 5
						C2 = GetMilliSecs()
					EndIf
				EndIf
																	
			ElseIf Die = True Then ' // Die block
				Y:+YI
				If YI < 6 Then YI:+.25 Else YI = 6
				If Y >= 368 Then Del = True		
			EndIf

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² FACE
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //									
			Case OBJ_FACE
			SetBlend ALPHABLEND; SetAlpha .9; SetScale sclX, sclY
			Local tmpF:Int = 0
			If bAlien[curPlayer-1] = True Then tmpF:+2
			DrawImage imgFace, Float((R * Cos(A) + X) + (-scrollX)), Float(R * Sin(A) + Y), F + tmpF
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
			If GetMilliSecs() >= T + 100 Then
				If F < 1 Then F = F + 1 Else F = 0
				T = GetMilliSecs()
			EndIf

			If pHurt = False And bHit = False Then
				If ImageRectCollide(imgFace, Int((R * Cos(A) + X) + (-scrollX)), Int(R * Sin(A) + Y), F + tmpF, Int(pX + 16), Int(pY + 20), 15, 20) Then
					If pLife > 0 Then
						PlaySFX sfxHit2

						pLife = pLife - 1
						pHurt = True; pHurtT = GetMilliSecs()		
						Del = True		
					EndIf
				EndIf
			EndIf
			
			If Del = False Then
				For p:Part = EachIn partList ' // Check for shot collision
					
					If p.ID = PART_WAND Then 
						If ImagesCollide(imgFace, Int((R * Cos(A) + X) + (-scrollX)), Int(R * Sin(A) + Y), F + tmpF, imgBlast, Int(p.X + (-scrollX)), Int(p.Y), p.F) = True Then

							gloHit = True; hitY = Int(p.Y + 16); hitT = GetMilliSecs()
							If p.D = 0 Then hitX = Int(p.X + 18) ElseIf p.D  = 1 Then hitX = Int(p.X + 18)
							partList.Remove p

							Del = True
							PlaySFX sfxHit
							AddScore 100
																					
							Exit
						EndIf
					EndIf				
				Next 
				
				If Del = True Then ' // Particles
					For Local i:Int = 1 To 30
						p:Part = New Part
						p.ID = PART_SPLASH; p.X = Int((R * Cos(A) + X) + 17); p.Y = Int(R * Sin(A) + (Y + 16))
						p.myType = TYPE_CANDY
						p.Alp = 1
			
						p.A = Rand(0, 360)
						p.S = Rnd(1, 2.5)
						p.D = Rnd(.075, .1)				
				
						p.R = 0
						p.C2 = Rand(0, 1)	
									
						If bAlien[curPlayer-1] = False Then
							p.Col1[0] = 255; p.Col1[1] = 111; p.Col1[2] = 153
							p.Col2[0] = 255; p.Col2[1] = 162; p.Col2[2] = 51							
						Else
							p.Col1[0] = 229; p.Col1[1] = 155; p.Col1[2] = 51
							p.Col2[0] = 254; p.Col2[1] = 206; p.Col2[2] = 199
						EndIf
						
						partList.AddLast p
					Next					
				EndIf
									
			EndIf
						
			If Del = False Then
				Local tmpRot:Int = 4
				If V = 2 Then tmpRot = 6
				If D = 0 Then			
					If A < 360 Then A = A + (tmpRot) Else A = 0
				Else
					If A > 0 Then A = A - (tmpRot) Else A = 359
				EndIf
				
				X = X - 1

				If bBoss <> True Then Del = True ' // Delete If boss dies
							
				If Int(X + (-scrollX) + 18) >= 0 Then															
				Else
					Del = True
				EndIf
			EndIf

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² RAIN                                             
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case OBJ_RAIN ' // Rain
			SetBlend LIGHTBLEND; SetAlpha Alp
			SetScale sclX, S
			SetColor 255, 255, 255
			
			DrawImage imgRain, X + (-scrollX), Y
					
			Local oldX:Int, oldY:Int							
			If S < 5 Then
				oldX = Int(X)
				If S = 2 Then 
					oldY = Int(Y + 6)
				ElseIf S = 3 Then
					oldY = Int(Y + 9)
				ElseIf S = 4 Then
					oldY = Int(Y + 12)				
				EndIf
					
				If oldY >= Int(304) Then 
					For Local i:Int = 1 To S
						partList.AddLast part.Create(Int(X), Int(oldY), PART_SPLASH, 0)
					Next
				
					Del = True
				EndIf
			Else				
				If Y >= 448 Then Del = True
			EndIf
			
			Y:+YI
						
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
						
		End Select		
		EndIf
		
		If Del = True Then objList.Remove o
		
		If createO <> 0 Then ' // Create object
			If createO = 1 Then ' // Drop
				objList.AddLast obj.Create(cX + Rand(7, 62), Int(cY + 32), OBJ_DROP, 1)

			ElseIf createO = 2 Then ' // Candy
				o:Obj = New Obj
				o.ID = OBJ_CANDY; o.X = cX; o.Y = cY; o.F = Rand(0, 5)	
				objList.AddLast o	
			
			ElseIf createO = 3 Then ' // Face hugger
				o:Obj = New Obj
				o.ID = OBJ_HUGGER; o.X = cX; o.Y = cY; o.D = cD
				If o.D = 0 Then o.F = 2 ElseIf o.D = 1 Then o.F = 3
				o.V = Rnd(-1, -4)
				objList.AddLast o	

			ElseIf createO = 4 Then ' // Secret
				o:Obj = New Obj
				o.ID = OBJ_HEALTH; o.X = cX; o.Y = cY; o.F = 2	
				objList.AddLast o	
			
			ElseIf createO = 5 Then ' // Ghost fader
				o:Obj = New Obj
				o.ID = OBJ_FADER
				o.X = cX
				o.Y = cY
				o.Alp = .3; o.V = 3; o.F = cF
				objList.AddLast o	
			
			ElseIf createO = 6 Then ' // Face
				'CreateFace(tmpX, tmpY + Rand(64, 176), tmpS)
				o:Obj = New Obj
				o.X = cX + 18; o.Y = cY + Rand(64, 176) + 16; o.ID = OBJ_FACE; o.R = 50; o.V = cF
				o.A = 0; o.D = Rand(0, 1)
				objList.AddLast o	
	
			ElseIf createO = 7 Then ' // Spikes

									
			EndIf
			
		EndIf
		
	End Method
	
End Type

LoadImages(cfgFilter) ' // Load all images

Rem
bTitle = False
StopChannel musChan
curLevel[0] = 3
curLevel[1] = 3

bTransform = 1
b2Transform = 1

bAlien[0] = False
bAlien[1] = True

bHard[0] = 0
bHard[1] = 0

b2Player = True
curPlayer = 1

'cfgDiff = 1
NewGame True
scrollX = 0' 6000 '1300
'pLives = 0; pLife = 1
pLife = 5
EndRem		

#MAIN
DefData "MAIN"

SetBlend ALPHABLEND
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² MAIN
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Repeat
	frameTimer = GetMilliSecs()	
	If bWindowed = False Then 
		SetOrigin 26, 16 ' // Fullscreen
		offX = 26; offY = 16
	EndIf
	
	SetScale sclX, sclY; SetColor 255, 255, 255
	SetBlend ALPHABLEND; SetAlpha 1
	
	If bTitle = True Then ' // Title
		
		' // Ebbing blood
		Local tmpY:Int
		tmpY = 382 - ebbF
		SetColor 216, 40, 0
		DrawRect 37, tmpY, 515, 20
		SetColor 255, 255, 255
		
		If GetMilliSecs() >= ebbT + 250 Then
			If ebbD = 0 Then
				If ebbF < 6 Then ebbF:+1 Else ebbD = 1
			ElseIf ebbD = 1 Then
				If ebbF > 0 Then ebbF:-1 Else ebbD = 0
			EndIf
			ebbT = GetMilliSecs()
		EndIf

		Local tmpTF:Int = 0
		If tScreen = 2 Then tmpTF = 1
		DrawImage imgTitle, 0, 0, tmpTF

		For o:Obj = EachIn objList; o.Render(0); Next ' // Back objects

		If tScreen = 0 Then ' // Main
			DrawFont "  1 Player", -1, 160
			DrawFont "  2 Player", -1, 192
			DrawFont "  Hi Score", -1, 224
			DrawFont "  Options ", -1, 256	
			DrawFont "  End Game", -1, 288

			SetColor 255, 255, 255
			DrawFont "2023 EikSoft", -1, Int(198 * sclY)
			'SetColor 252, 152, 56
			DrawFont "www.EikSoft.com", -1, Int(206 * sclY)
			'SetColor 252, 188, 176

			If tSel = 0 Then tmpY = 160 ElseIf tSel = 1 Then tmpY = 192 ElseIf tSel = 2 Then tmpY = 224 ElseIf tSel = 3 Then tmpY = 256 ElseIf tSel = 4 Then tmpY = 288
			DrawImage imgSel, 192, tmpY
		
		ElseIf tScreen = 1 Then ' // Options
			Local tmpS:String
			
			SetColor 252, 252, 252
			DrawFont "  SFX     ", -1, 160
			DrawFont String(cfgSFX * 10) + "%", 362, 160
			
			DrawFont "  Music   ", -1, 192
			DrawFont String(cfgMusic * 10) + "%", 362, 192
			
			DrawFont "  Filter  ", -1, 224
			If cfgFilter = 0 Then tmpS$ = "Off" Else tmpS$ = "On"
			DrawFont tmpS$, 362, 224
			
			DrawFont "  CRT     ", -1, 256
			If cfgCRT = 0 Then tmpS$ = "0%" ElseIf cfgCRT = 1 Then tmpS$ = "25%" ElseIf cfgCRT = 2 Then tmpS$ = "50%" ElseIf cfgCRT = 3 Then tmpS$ = "75%" ElseIf cfgCRT = 4 Then tmpS$ = "100%"
			DrawFont tmpS$, 362, 256
			
			If cfgFull = 0 Then
				DrawFont "  Window  ", -1, 288
			Else
				DrawFont "  Full    ", -1, 288
			EndIf

			If cfgDiff = 0 Then
				DrawFont "  Easy    ", -1, 320
			ElseIf cfgDiff = 1 Then
				DrawFont "  Normal  ", -1, 320
			EndIf

			DrawFont "  Back    ", -1, 352
			SetColor 255, 255, 255

			If tSel = 0 Then tmpY = 160 ElseIf tSel = 1 Then tmpY = 192 ElseIf tSel = 2 Then tmpY = 224 ElseIf tSel = 3 Then tmpY = 256 ElseIf tSel = 4 Then tmpY = 288 ElseIf tSel = 5 Then tmpY = 320 ElseIf tSel = 6 Then tmpY =  352 ' // Selection
			DrawImage imgSel, 192, tmpY
	
		ElseIf tScreen = 2 Then ' // Hi scores
		
			If netP > 0 Then DrawFont "$", 438, 118
			If netP < 90 Then DrawFont "+", 438, 352

			DrawFont "Online Top 100", -1, 118
			
			' // Draw online scores
			Local tmpY:Int = 142
			For Local i:Int = netP To netP + 9
				If i = 0 Then 
					SetColor 255, 0, 0
				Else
					SetColor 252, 252, 252
				EndIf
								
				DrawFont RSet(String(i + 1), 3) + " " + Upper(Right(net_Score[i], 6)) + " " + NumFormat(Left(net_Score[i], Len(net_Score[i]) - 7)), 124, tmpY

				tmpY:+21
			Next
				
		EndIf
		
		For p:Part = EachIn partList; p.Render(); Next ' // Particles

		' // Generate blood drops
		If Rand(1, 20) = 10 Then CreateDrops()
			
		Local bJoyUp:Int = -1
		Local bJoyDown:Int = -1
		Local bJoyLeft:Int = -1
		Local bJoyRight:Int = -1
		
		' // Up
		If GetInput(PLAYER_1, INP_U) = True And bJoy1YHit = False Then bJoyUp = PLAYER_1; secretC$:+"U" 
				
		' // Down
		If GetInput(PLAYER_1, INP_D) = True And bJoy1YHit = False Then bJoyDown = PLAYER_1; secretC$:+"D"
				
		' // Left
		If GetInput(PLAYER_1, INP_L) = True And bJoy1XHit = False Then bJoyLeft = PLAYER_1; secretC$:+"L"
		
		' // Right
		If GetInput(PLAYER_1, INP_R) = True And bJoy1XHit = False Then bJoyRight = PLAYER_1; secretC$:+"R"
		
		If bJoyUp <> -1 Then
		
			If tScreen = 0 Or tScreen = 1 Then ' // Main
				If tSel > 0 Then tSel:-1 Else tSel = 0
			
			ElseIf tScreen = 2 Then ' // Hi scores
			
				If netP > 0 Then netP:-10

			EndIf
		
			bJoy1YHit = True
			
		ElseIf bJoyDown <> -1 Then
		
			If tScreen = 0 Then ' // Main
				If tSel < 4 Then tSel:+1 Else tSel = 4
			
			ElseIf tScreen = 1 Then ' // Options
				If tSel < 6 Then tSel:+1 Else tSel = 6
				
			ElseIf tScreen = 2 Then ' // Hi scores
			
				If netP < 90 Then netP:+10
				
			EndIf
			
			bJoy1YHit = True
			
		EndIf
		
		' // Select
		If GetInput(PLAYER_1, INP_S) = True Or GetInput(PLAYER_1, INP_B) = True Then 
		
			If tScreen = 0 Then ' // Main
				If tSel = 0 Then ' // 1 Player
					b2Player = False
					curPlayer = 1
					
					bTitle = False
					
					StopChannel musChan
					musChan = PlaySFX(sfxBed)
					Repeat
						Delay 10
					Until ChannelPlaying(musChan) = False

					NewGame()				
					SleepScene()
					FlushInput			
				
				ElseIf tSel = 1 Then ' // 2 Player
					b2Player = True
					curPlayer = 1
					
					bTitle = False
					
					StopChannel musChan
					musChan = PlaySFX(sfxBed)
					Repeat
						Delay 10
					Until ChannelPlaying(musChan) = False

					NewGame()					
					SleepScene()
					PlayerScene()
					FlushInput	
										
				ElseIf tSel = 2 Then ' // Hi score
					If LoadScores() = True Then
						tSel = 0
						tScreen = 2
					EndIf
					FlushInput
					
				ElseIf tSel = 3 Then ' // Options
					tSel = 0
					tScreen = 1
					PlaySFX sfxShot
					FlushInput					
					
				ElseIf tSel = 4 Then ' // End Game
					EndGame
					
				EndIf
				
			ElseIf tScreen = 1 Then ' // Options

				If tSel <> 0 And tSel <> 6 Then PlaySFX sfxShot

				If tSel = 0 Then ' // SFX
					If cfgSFX < 10 Then cfgSFX = cfgSFX + 1 Else cfgSFX = 0
					PlaySFX(sfxShot)
					
				ElseIf tSel = 1 Then ' // Music
					If cfgMusic < 10 Then cfgMusic = cfgMusic + 1 Else cfgMusic = 0
					musChan.SetVolume(Float(cfgMusic) / 10)

				ElseIf tSel = 2 Then ' // Filter
					If cfgFilter = 0 Then cfgFilter = 1; LoadImages(True) Else cfgFilter = 0; LoadImages(False)					
				ElseIf tSel = 3 Then ' // CRT
					If cfgCRT < 4 Then cfgCRT = cfgCRT + 1 Else cfgCRT = 0
					crtMode = cfgCRT
				ElseIf tSel = 4 Then ' // Full				
					If cfgFull = 0 Then cfgFull = 1 Else cfgFull = 0
			
				ElseIf tSel = 5 Then ' // Difficulty				
					If cfgDiff < 1 Then cfgDiff:+1 Else cfgDiff = 0
					
				ElseIf tSel = 6 Then ' // Back
					PlaySFX sfxPoof
					
					tSel = 0
					tScreen = 0
					
					FlushInput
				EndIf
			
			ElseIf tScreen = 2 Then ' // Hi scores
				PlaySFX sfxPoof
				
				tSel = 0
				tScreen = 0
					
				FlushInput
				
			EndIf

		EndIf

		' // Reset joysticks
		If JoyY(p1Joy) <= .5 And JoyY(p1Joy) >= -.5 Then 
			bJoy1YHit = False ' // Reset joystick
		EndIf
		
		If JoyX(p1Joy) <= .5 And JoyX(p1Joy) >= -.5 Then 
			bJoy1XHit = False ' // Reset joystick
		EndIf
		
		' // Secret code
		'If Right$(secretC$, 10) = "UUDDLLRRAA" Then
		'	PlaySFX sfxPick
		'	bSecret = True
		'	secretC$ = ""
		'EndIf
		
	Else ' // Game
	
		If curLevel[curPlayer-1] = 3 Then ' // Lightning
			If Rand(1, 50) = 25 Then
				SetColor 255, 255, 255
				DrawRect 0, 0, 588, 368
			EndIf
		EndIf

		Local tmpTransform:Int = bTransform
		If b2Player = True Then
			If curPlayer = 1 Then tmpTransform = bTransform ElseIf curPlayer = 2 Then tmpTransform = b2Transform
		EndIf
		
		If curLevel[curPlayer-1] = 1 Then
			If tmpTransform Mod 2 = 0 Then
				TileScaleImage imgTile, Int(-scrollX), 304
			Else
				TileScaleImage imgTileO, Int(-scrollX), 304
			EndIf
		ElseIf curLevel[curPlayer-1] = 2 Then
			TileScaleImage imgTile3, Int(-scrollX), 304
		ElseIf curLevel[curPlayer-1] = 3 Then
			TileScaleImage imgTile6, Int(-scrollX), 304
		EndIf
		
		If curLevel[curPlayer-1] = 1 Then
			If tmpTransform Mod 2 = 0 Then
				TileScaleImage imgSky, Int(-scrollX), 0
			Else
				TileScaleImage imgSky2, Int(-scrollX), 0
			EndIf
		ElseIf curLevel[curPlayer-1] = 2 Then
			'TileScaleImage imgSky2, Int(-scrollX), 0
			
			TileCaveImage imgCave1, Int(-scrollX), 0, caveF1
			TileCaveImage imgCave2, Int(-scrollX), 0, caveF2
			TileCaveImage imgCave3, Int(-scrollX), 0, caveF3
						
		ElseIf curLevel[curPlayer-1] = 3 Then
			TileCaveImage2 imgSky3, Int(-caveX1), 0
		EndIf		
	
		If curLevel[curPlayer-1] = 1 Then ' // Level 1 background
			If tmpTransform Mod 2 = 0 Then
				DrawImage imgBack, -scrollX, 0
			Else
				DrawImage imgBack2, -scrollX, 0
			EndIf
		
			' // Background objs
			If tmpTransform Mod 2 = 0 Then
				' !!! 690
				DrawImage imgShroom2, 1035 + -scrollX, 148
			Else
				DrawImage imgShroom1, 1035 + -scrollX, 148
			EndIf

			If tmpTransform Mod 2 = 0 Then
				DrawImage imgTree, 1725 + -scrollX, 6
			Else
				DrawImage imgTreeO, 1725 + -scrollX, 6
			EndIf
			'DrawImage imgGrave, 1500 + -scrollX, 200
			
			DrawImage imgTile2, 2760 + -scrollX, 304
			DrawImage imgTile2, 3054 + -scrollX, 304
			DrawImage imgTile2, 3348 + -scrollX, 304
			DrawImage imgTile2, 3642 + -scrollX, 304
			
			DrawImage imgBase1, 4370 + -scrollX, 80, 0
			'DrawImage imgBase2, Int(5060 + -scrollX), 176

			DrawImage imgTile2, 5060 + -scrollX, 304
			DrawImage imgTile2, 5354 + -scrollX, 304
			
			' !! 5980
			DrawImage imgTree3, 6180 + -scrollX, 80, 0

			DrawImage imgDoor, 7452 + -scrollX, 304 - 64
		
		ElseIf curLevel[curPlayer-1] = 2 Then ' // Level 2 background
			
			Local tmpLavaX:Int = 1178'1024
			DrawImage imgTile4, tmpLavaX + -scrollX, 304, lavaF
			DrawImage imgTile4, (tmpLavaX + 147) + -scrollX, 304, lavaF
			DrawImage imgTile4, (tmpLavaX + 294) + -scrollX, 304, lavaF
			DrawImage imgTile4, (tmpLavaX + 441) + -scrollX, 304, lavaF

			DrawImage imgTile4, (tmpLavaX + 588) + -scrollX, 304, lavaF
			DrawImage imgTile4, (tmpLavaX + 735) + -scrollX, 304, lavaF
			DrawImage imgTile4, (tmpLavaX + 882) + -scrollX, 304, lavaF
			DrawImage imgTile4, (tmpLavaX + 1029) + -scrollX, 304, lavaF

			DrawImage imgTile4, (tmpLavaX + 1176) + -scrollX, 304, lavaF
			DrawImage imgTile4, (tmpLavaX + 1323) + -scrollX, 304, lavaF

			DrawImage imgTree2, 3220 + -scrollX, 0
			DrawImage imgTree4, 4749 + -scrollX, 0
			
			DrawImage imgTile5, 5525 + -scrollX, 0
			DrawImage imgTile5, 5966 + -scrollX, 0
			DrawImage imgTile5, 6407 + -scrollX, 0
			
			DrawImage imgTile4, 6845 + -scrollX, 304, lavaF
			DrawImage imgTile4, 6992 + -scrollX, 304, lavaF
			DrawImage imgTile4, 7139 + -scrollX, 304, lavaF
			DrawImage imgTile4, 7286 + -scrollX, 304, lavaF

			DrawImage imgDoor, 7452 + -scrollX, 304 - 64

			If GetMilliSecs() >= lavaT + 200 Then ' // Lava animation
				If lavaF > 0 Then lavaF = lavaF - 1 Else lavaF = 2
				lavaT = GetMilliSecs()
			EndIf

			If GetMilliSecs() >= caveT + 120 Then ' // Cave animation
				If caveD1 = 1 Then
					If caveF1 < 4 Then caveF1 = caveF1 + 1 Else caveD1 = 0
				Else
					If caveF1 > 0 Then caveF1 = caveF1 - 1 Else caveD1 = 1
				EndIf

				If caveD2 = 1 Then
					If caveF2 < 4 Then caveF2 = caveF2 + 1 Else caveD2 = 0
				Else
					If caveF2 > 0 Then caveF2 = caveF2 - 1 Else caveD2 = 1
				EndIf

				If caveD3 = 1 Then
					If caveF3 < 4 Then caveF3 = caveF3 + 1 Else caveD3 = 0
				Else
					If caveF3 > 0 Then caveF3 = caveF3 - 1 Else caveD3 = 1
				EndIf
								
				caveT = GetMilliSecs()
			EndIf
					
		ElseIf curLevel[curPlayer-1] = 3 Then ' // Level 3 background
		
			Local tmpLavaX:Int = 881
			DrawImage imgTile7, 588 + -scrollX, 304, lavaF
			DrawImage imgTile7, 735 + -scrollX, 304, lavaF

			DrawImage imgTile7, 882 + -scrollX, 304, lavaF
			DrawImage imgTile7, (tmpLavaX + 148) + -scrollX, 304, lavaF
			DrawImage imgTile7, (tmpLavaX + 295) + -scrollX, 304, lavaF
			DrawImage imgTile7, (tmpLavaX + 442) + -scrollX, 304, lavaF
			
			'Rem
			If bAlien[curPlayer-1] = False Then
				DrawImage imgBack3, (tmpLavaX + 589) + -scrollX, 0, 0
			Else
				DrawImage imgBack4, (tmpLavaX + 589) + -scrollX, 0, 0
			EndIf
			DrawImage imgDoor, (tmpLavaX + 1141) + -scrollX, 304 - 64

			If GetMilliSecs() >= lavaT + 200 Then
				If lavaF < 2 Then lavaF = lavaF + 1 Else lavaF = 0
				lavaT = GetMilliSecs()
			EndIf
			'EndRem			
		
		EndIf

		Local bBase:Int = False, bBaseY:Int
		bPlat = False

		' // Bases
		If curLevel[curPlayer-1] = 1 And pDeath = False Then
			' // Tree level 1
			If ImageRectCollide(imgTreeO, Int(1725 + -scrollX), 6, 1, Int(pX + 16), Int(pY + 64), 21, 4) Then
				bBase = True; bBaseY = 102

			' // Tree level 2
			ElseIf ImageRectCollide(imgTreeO, Int(1725 + -scrollX), 6, 2, Int(pX + 16), Int(pY + 64), 21, 4) Then
				bBase = True; bBaseY = 6

			' // Health base level 1
			ElseIf ImageRectCollide(imgBase1, Int(4370 + -scrollX), 80, 1, Int(pX + 16), Int(pY + 64), 21, 4) Then
				bBase = True; bBaseY = 208
					
			' // Health base level 2
			ElseIf ImageRectCollide(imgBase1, Int(4370 + -scrollX), 80, 2, Int(pX + 16), Int(pY + 64), 21, 4) Then
				bBase = True; bBaseY = 176

			' // Tree				
			ElseIf ImageRectCollide(imgTree3, Int(6180 + -scrollX), 80, 1, Int(pX + 16), Int(pY + 64), 21, 4) Then
				bBase = True; bBaseY = 176
										
			EndIf
			
			If bBase = True Then ' // Hit
				If pJ = True And pJV < 0 Then
					pJ = False
					jumpC = 0
					pT = GetMilliSecs()
					If pD = 0 Then pF = 6 Else pF = 0
				EndIf
				If pFall = True Then
					If pF = 4 Or pF = 10 Then  ' // Fall frame reset
						If pD = 0 Then pF = 6 Else pF = 0
					EndIf	
				EndIf
				If pJ = False Then pY = bBaseY
				bPlat = True; pFall = False
				
			EndIf	
			
		ElseIf curLevel[curPlayer-1] = 2 And pDeath = False Then ' // Bases

			Local col1:Int, col2:Int
			
			If pD = 1 Then
				col1 = 10; col2 = 23
			ElseIf pD = 0 Then
				col1 = 14; col2 = 23
			EndIf	
			
			' // Left Tree level 2
			If ImageRectCollide(imgTree2, Int(3220 + -scrollX), 0, 1, Int(pX + col1), Int(pY + 64), col2, 4) Then
				bBase = True; bBaseY = 78
			
			ElseIf ImageRectCollide(imgTree2, Int(3220 + -scrollX), 0, 2, Int(pX + col1), Int(pY + 64), col2, 4) Then
				bBase = True; bBaseY = 14

			ElseIf ImageRectCollide(imgTree4, Int(4749 + -scrollX), 0, 1, Int(pX + col1), Int(pY + 64), col2, 4) Then
				bBase = True; bBaseY = 78
			
			ElseIf ImageRectCollide(imgTree4, Int(4749 + -scrollX), 0, 2, Int(pX + col1), Int(pY + 64), col2, 4) Then
				bBase = True; bBaseY = 14
			
			EndIf

			If bBase = True Then ' // Hit
				If pJ = True And pJV < 0 Then
					pJ = False
					jumpC = 0
					pT = GetMilliSecs()
					If pD = 0 Then pF = 6 Else pF = 0
				EndIf
				If pFall = True Then
					If pF = 4 Or pF = 10 Then  ' // Fall frame reset
						If pD = 0 Then pF = 6 Else pF = 0
					EndIf	
				EndIf
				If pJ = False Then pY = bBaseY
				bPlat = True; pFall = False
				
			EndIf	
						
		EndIf
		
		If bDebug = True Then
			SetColor 255, 0, 0
			DrawRect Int(pX + 16), Int(pY + 64), 21, 4
			SetColor 255, 255, 255
		EndIf
		
		' // Spikes
		If curLevel[curPlayer-1] = 1 Then
			If pHurt = False And pLife > 0 Then
				If RectsOverlap(Int(2760 + -scrollX), 304, 1178, 64, Int(pX + 26), Int(pY + 64), 27, 8) Or..
					RectsOverlap(Int(5060 + -scrollX), 304, 589, 64, Int(pX + 26), Int(pY + 64), 27, 8) Then
					PlaySFX sfxHit2
					pLife = pLife - 1
					pHurt = True; pHurtT = GetMilliSecs()
					pY = 240
					pFall = False					
				EndIf
			EndIf
		
		ElseIf curLevel[curPlayer-1] = 2 Then ' // Lava
			If pHurt = False And pLife > 0 Then
				If RectsOverlap(Int(1178 + -scrollX), 304, 1472, 64, Int(pX + 26), Int(pY + 64), 27, 8) Or..
					RectsOverlap(Int(6845 + -scrollX), 304, 552, 64, Int(pX + 26), Int(pY + 64), 27, 8) Then
					PlaySFX sfxHit2
					pLife = pLife - 1
					pHurt = True; pHurtT = GetMilliSecs()
					pY = 240
					pFall = False					
				EndIf
			EndIf
									
		EndIf
		
		objC = 0; partC = 0 
		For o:Obj = EachIn objList; o.Render(0); Next ' // Back objects

		If bSpikes = True And curLevel[curPlayer-1] = 3 Then ' // Create spikes
			Local tmpX:Int, tmpT:Int
			tmpX = Int((37 + scrollX) + (9 * 37))
			tmpT = 100
			For Local i:Int = 1 To 10
				o:Obj = New Obj
				o.X = tmpX; o.ID = OBJ_SPIKE; o.Y = 304; o.A = 0
				o.T = GetMilliSecs() + tmpT
				tmpT = tmpT + 200
				tmpX = tmpX - 37
				
				objList.AddLast o
			Next	
			bSpikes = False
		EndIf
				
		' // !!! Better way to do this
		
		If scrollX >= 6900 And curLevel[curPlayer-1] = 1 Then ' // Draw ground infront of boss
			TileScaleImage imgTile, -scrollX, 304
		EndIf
		
		If curLevel[curPlayer-1] = 3 Then ' // Draw water infront of fish

			Local tmpLavaX:Int = 881
			DrawImage imgTile8, 588 + -scrollX, 304, lavaF
			DrawImage imgTile8, 735 + -scrollX, 304, lavaF

			DrawImage imgTile8, 882 + -scrollX, 304, lavaF
			DrawImage imgTile8, (tmpLavaX + 148) + -scrollX, 304, lavaF
			DrawImage imgTile8, (tmpLavaX + 295) + -scrollX, 304, lavaF
			DrawImage imgTile8, (tmpLavaX + 442) + -scrollX, 304, lavaF
		
			'Local tmpLavaX:Int = 881
			
			If bAlien[curPlayer-1] = False Then
				DrawImage imgBackO, (tmpLavaX + 589) + -scrollX, 0, 0
			Else
				DrawImage imgBackO, (tmpLavaX + 589) + -scrollX, 0, 1
			EndIf		
		EndIf
		
		' // Death vs hurt vs normal
		If pDeath = True Then
			DrawImage imgSpin[curPlayer-1], Int(pX), Int(pY), spinF
			If dF < 4 Then DrawImage imgDeath, Int(px), Int(pY), dF
			If GetMilliSecs() >= pT + 100 Then
				dF = dF + 1
				If spinF < 3 Then spinF = spinF + 1 Else spinF = 0
				pT = GetMilliSecs()
			EndIf
			
			If GetMilliSecs() >= deathT + 1500 Then
				pY = pY + 4
			EndIf
			If GetMilliSecs() >= deathT + 3000 Then ' // End
				If curPlayer = 1 Then
					pLives:-1

					If pLives < 0 Then 
						NewGame 3				
						GameOver()											
					Else
						NewGame True
					EndIf							

					If b2Player = True Then
						If p2Lives < 0 Then
						Else
							curPlayer = 2
							PlayerScene()
							NewGame True
							bGameOver = False
						EndIf
					EndIf
						
				ElseIf curPlayer = 2 Then
					p2Lives:-1

					If p2Lives < 0 Then 
						NewGame 3				
						GameOver()
					Else									
						NewGame True
					EndIf							
					
					If b2Player = True Then
						If pLives < 0 Then
						Else
							curPlayer = 1
							PlayerScene()
							NewGame True							
							bGameOver = False
						EndIf
					EndIf
											
				EndIf
						
				' // MARK IT
						
			EndIf
		Else
			Local tmpF:Int	
			
			SetBlend ALPHABLEND; SetAlpha 1
			If pHurt = True Then
				If Rand(1, 2) = 1 Then SetBlend LIGHTBLEND; SetAlpha .5
			EndIf

			Local tmpTransform:Int = bTransform
			If b2Player = True Then
				If curPlayer = 1 Then tmpTransform = bTransform ElseIf curPlayer = 2 Then tmpTransform = b2Transform
			EndIf
			
			If curLevel[curPlayer-1] = 1 Then
				If tmpTransform Mod 2 = 0 Then
					DrawImage imgFrog[curPlayer-1], Int(pX), Int(pY), pF
				Else
					DrawImage imgFrogO[curPlayer-1], Int(pX), Int(pY), pF
				EndIf
			ElseIf curLevel[curPlayer-1] = 2 Then
				If pShoot = True Then
					If pD = 1 Then tmpF = 0 Else tmpF = 1
					DrawImage imgLizardF[curPlayer-1], Int(pX), Int(pY), tmpF
				Else
					DrawImage imgLizard[curPlayer-1], Int(pX), Int(pY), pF
				EndIf
			ElseIf curLevel[curPlayer-1] = 3 Then
				If pIdle = True And pShoot = False Then
					If pD = 1 Then
						DrawImage imgNemoIdle[curPlayer-1], Int(pX), Int(pY), 0
					Else
						DrawImage imgNemoIdle[curPlayer-1], Int(pX), Int(pY), 1
					EndIf
				ElseIf pShoot = True Then
					If pD = 1 Then tmpF = 0 Else tmpF = 1
					DrawImage imgNemoF[curPlayer-1], Int(pX), Int(pY), tmpF			
				Else
					DrawImage imgNemo[curPlayer-1], Int(pX), Int(pY), pF			
				EndIf
			EndIf
			SetBlend ALPHABLEND; SetAlpha 1

		EndIf

		If curLevel[curPlayer-1] = 3 Then ' // Rain
			'If Rand(1, 2) = 1 Then
			'For Local i:Int = 1 To 10
				o:Obj = New Obj
				o.X = Rand(-128, 716) + scrollX
				o.Y = -8
				o.ID = OBJ_RAIN
				
				Local tmpS:Int = Rand(0, 3)
				If tmpS = 0 Then ' // Fore
					o.Alp = .7
					o.S = 5
					o.YI = 5
				ElseIf tmpS = 1 Then
					o.Alp = .6
					o.S = 4
					o.YI = 4.5
				ElseIf tmpS = 2 Then
					o.Alp = .5
					o.S = 3
					o.YI = 4
				ElseIf tmpS = 3 Then
					o.Alp = .4
					o.S = 2
					o.YI = 3.5
				EndIf
				
				If o.X < 1454 Then objList.AddLast o
			'Next
			'EndIf
		EndIf
				
		If bSkip = False Then ' // Don't render flag
		faceCount = 0
		For o:Obj = EachIn objList
			If o.ID = OBJ_FACE Then faceCount:+1
			o.Render(1); objC:+1
		Next ' // Front objects
		
		For p:Part = EachIn partList ' // Particles
			If p.ID <> PART_WAND Then p.Render(); partC:+1
		Next 
				
		If curLevel[curPlayer-1] = 3 Then ' // Draw floor over objects
			For p:Part = EachIn partList ' // Wand always on top
				If p.ID = PART_WAND Then p.Render(); partC:+1
			Next 	
		EndIf
				
		If gloHit = True Then ' // Hit flare
			SetBlend LIGHTBLEND
			If GetMilliSecs() >= hitT + 114 Then 
				SetAlpha .25
			ElseIf GetMilliSecs() >= hitT + 76 Then 
				SetAlpha .5
			ElseIf GetMilliSecs() >= hitT + 38 Then 
				SetAlpha .75
			ElseIf GetMilliSecs() >= hitT Then
				SetAlpha 1
			EndIf
			
			'DebugLog "HITX: " + hitX
			
			DrawImage imgHit, Int(hitX + (-scrollX)), Int(hitY)
			If GetMilliSecs() >= hitT + 150 Then gloHit = False
			SetBlend ALPHABLEND; SetAlpha 1
		EndIf
	
		RenderStatus()
		
		' // End of level countdown
		Local tmpOffX:Int
		If pDeath = False Then
			If curLevel[curPlayer-1] = 1 Or curLevel[curPlayer-1] = 2 Then
				tmpOffX = 6900
			Else
				tmpOffX = 1470
			EndIf
			If scrollX >= tmpOffX And bBoss = 2 And pX >= (588 - 81) And pY >= 240 And bCounting = False Then 
				bCounting = True
				StopChannel musChan
				sfxChan = PlaySFX(sfxEnd)
			
			EndIf
		EndIf
		
		Local tmpTime:Int
		If bCounting = 2 Then tmpTime = 40 Else tmpTime = 1000
		
		If GetMilliSecs() >= timeTimer + tmpTime And ((timeSec + timeMin) > 0 Or bCounting <> False) And pDeath = False And bSkip = False And bGameOver = False Then
			If bCounting = False Then
				If timeSec > 0 Then
					timeSec = timeSec - 1
				Else
					timeSec = 59
					timeMin = timeMin - 1
				EndIf
				
				If timeMin = 0 And timeSec <= 15 Then ' // Danger tick
					PlaySFX sfxTime
				EndIf
			Else
				If ChannelPlaying(sfxChan) = False And bCounting = True Then
					sfxChan = PlaySFX(sfxCount)
					'pScore = pScore + (pLife * 500) ' // Add remaining life To score

					bCounting = 2
				ElseIf bCounting = 2 Then
					'If ChannelPlaying(sfxChan) = False Then sfxChan = PlaySFX(sfxCount)

					If timeSec > 0 Then
						timeSec = timeSec - 1
						AddScore 50
					Else
						If timeMin > 0 Then
							timeSec = 59
							timeMin = timeMin - 1
							AddScore 50
						Else
							timeSec = 0; timeMin = 0
						EndIf
					EndIf
					
					If pLife > 0 Then pLife = pLife - 1; AddScore 500
					
					If timeSec = 0 And timeMin = 0 And pLife = 0 Then ' // Give time to show
						'timeSec = -1; timeMin = -1; pLife = -1
						
					'ElseIf timeSec = -1 And timeMin = -1 And pLife = -1 Then
						'Repeat
						'Until WaitKey()
						RenderStatus()
						RenderOverlay() ' // Overlay graphics
						
						Flip 1
						Repeat
							Delay 10
						Until ChannelPlaying(sfxChan) = False
						Cls
						
						curLevel[curPlayer-1] = curLevel[curPlayer-1] + 1
						
						' // MARK IT
						If curLevel[curPlayer-1] = 4 Then ' // Star level
							If cfgDiff = 0 Then ' // Easy, game over
								GameWon()
								NewGame 3				
								GameOver()
								
								If curPlayer = 1 Then 
									pLives = -1 ' // Done
								ElseIf curPlayer = 2 Then
									p2Lives = -1 ' // Done
								EndIf
								
								If b2Player = True Then								
									If curPlayer = 1 Then
										If p2Lives < 0 Then
										Else
											curPlayer = 2
											NewGame(True) ' // Start next level
											PlayerScene()
											bGameOver = False
										EndIf									
									ElseIf curPlayer = 2 Then					
										If pLives < 0 Then
										Else
											curPlayer = 1
											NewGame(True) ' // Start next level
											PlayerScene()
											bGameOver = False
										EndIf
									EndIf	
								EndIf
																					
							Else
								GameWon()
								curLevel[curPlayer-1] = 1; bHard[curPlayer-1] = True
								If curPlayer = 1 Then
									bTransform = 1
								ElseIf curPlayer = 2 Then
									b2Transform = 1
								EndIf
								SleepScene()
								NewGame(True) ' // Start next level
							EndIf
						Else
							SleepScene()
							NewGame(True) ' // Start next level
						EndIf
						
						bSkip = True
					EndIf
				EndIf
			EndIf
			
			timeTimer = GetMilliSecs()
			
			If timeSec = 0 And timeMin = 0 And pDeath = False And bSkip = False And bCounting = False Then ' // Timeout
				pDeath = True
				pT = GetMilliSecs()
				dF = 0
				spinF = 0
				StopChannel musChan ' // Stop music
				PlaySFX sfxDeath
				deathT = GetMilliSecs()
				pLife = 0
			EndIf
		EndIf
		EndIf ' // END SKIP BLOCK

		If bCounting <> False Or pDeath = True Or bSkip = True Or bGameOver = True Then ' // STEPOVER BLOCK 1
		Else
		
		Local pMove:Int = False, tmpAnim:Int
		
		Local tmpPlayer:Int = 0 ' // Player input
		If b2Player = True Then
			If curPlayer = 1 Then tmpPlayer = 0 ElseIf curPlayer = 2 Then tmpPlayer = 1
		EndIf
			
		If GetInput(tmpPlayer, INP_R, 1) = True Then
			If pD = 0 Then pF = 0; pT = GetMilliSecs()
			pD = 1
			
			Local tmpOffX:Int
			
			If curLevel[curPlayer-1] = 1 Or curLevel[curPlayer-1] = 2 Then
				tmpOffX = 6900
			ElseIf curLevel[curPlayer-1] = 3 Then
				tmpOffX = 1470
			EndIf
			
			If pX >= 308 Then
				If scrollX >= tmpOffX Then ' // End of level
					scrollX = tmpOffX					

					If bBoss = False Then
						bBoss = True
						StopChannel musChan
						musChan = PlaySound(musTerror)
						musChan.SetVolume(Float(cfgMusic) / 10) 
						
						If curLevel[curPlayer-1] = 1 Then
							' // Create Pumpkin boss						
							o:Obj = New Obj
							o.ID = OBJ_PUMPKIN; o.X = Int(266 + scrollX); o.Y = 304; o.F = 0; o.A = 1
							o.D = Rand(0, 1)
							
							If bHard[curPlayer-1] = True Then
								o.L = 12
							Else
								If cfgDiff = 0 Then o.L = 8 ElseIf cfgDiff = 1 Then o.L = 10
							EndIf
											
							'o.L = 1 ' // DEBUG
							objList.AddLast o	
							
						ElseIf curLevel[curPlayer-1] = 2 Then ' // Create serpent boss
							o:Obj = New Obj
							o.ID = OBJ_SNAKE; o.X = 407 + scrollX; o.Y = 310 - 112; o.F = -1; o.A = 0
							o.D = 0; o.T = GetMilliSecs()
							
							If bHard[curPlayer-1] = True Then
								o.L = 12
							Else
								If cfgDiff = 0 Then o.L = 8 ElseIf cfgDiff = 1 Then o.L = 10
							EndIf
														
							objList.AddLast o	
							
						ElseIf curLevel[curPlayer-1] = 3 Then ' // Create Death boss
							o:Obj = New Obj
							o.ID = OBJ_KING; o.X = 412 + scrollX; o.Y = 304; o.A = 1

							If bHard[curPlayer-1] = True Then
								o.L = 23
							Else
								If cfgDiff = 0 Then o.L = 17 ElseIf cfgDiff = 1 Then o.L = 20
							EndIf
														
							If bAlien[curPlayer-1] = True Then o.F = 1 Else o.F = 0
							'o.L = 1 ' // DEBUG
							o.T = GetMilliSecs()
							objList.AddLast o	
						EndIf
							
					EndIf					
					
					If pX < 588 - 73 Then
						If pJ = False Then
							If curLevel[curPlayer-1] = 1 Then 
								pX = pX + 2 ' // !!! WALK SPEED
							ElseIf curLevel[curPlayer-1] = 2 Or curLevel[curPlayer-1] = 3 Then
								pX = pX + 2
							EndIf
						Else
							pX = pX + 2
						EndIf
					Else
						pX = 588 - 73
					EndIf	
								
				Else
				
					If pJ = False Then
						If curLevel[curPlayer-1] = 1 Then
							scrollX = scrollX + 2 ' // !!! WALK SPEED
							tileX:+2
							caveX1:+1.5
							
						ElseIf curLevel[curPlayer-1] = 2 Or curLevel[curPlayer-1] = 3 Then
							scrollX = scrollX + 2
							tileX:+2
							caveX1:+1.5
						EndIf					
					Else
						scrollX = scrollX + 2
						tileX:+2
						caveX1:+1.5
						
					EndIf

				EndIf
			Else
				If pJ = False Then
					If curLevel[curPlayer-1] = 1 Then
						pX = pX + 2 ' // !!! WALK SPEED
					ElseIf curLevel[curPlayer-1] = 2 Or curLevel[curPlayer-1] = 3 Then
						pX = pX + 2
					EndIf
				Else
					pX = pX + 2
				EndIf
			EndIf
			
			If curLevel[curPlayer-1] = 3 Then tmpAnim = 120 Else tmpAnim = 200 
			If pIdle = True Then tmpAnim = 0 ' // First frame fix
			
			If GetMilliSecs() >= pT + tmpAnim Then
				If pF < 3 Then 
					pF = pF + 1
				Else
					pF = 0
				EndIf
				pT = GetMilliSecs()
			EndIf
			
			If pFall = True Then pF = 4  ' // Falling frame fix

			pMove = True
			
		ElseIf GetInput(tmpPlayer, INP_L, 1) = True Then
			If pD = 1 Then pF = 6; pT = GetMilliSecs()
			pD = 0
			
			If pX <= 200 Then
				
				Local tmpOffX:Int
				
				If curLevel[curPlayer-1] = 1 Or curLevel[curPlayer-1] = 2 Then
					tmpOffX = 6900
				ElseIf curLevel[curPlayer-1] = 3 Then
					tmpOffX = 1470
				EndIf
					
				If scrollX <= 0 Or scrollX >= tmpOffX Then
					If scrollX <= 0 Then
						scrollX = 0 
					ElseIf scrollX >= tmpOffX Then
						scrollX = tmpOffX
					EndIf
					
					If pX > 0 Then
						If pJ = False Then
							If curLevel[curPlayer-1] = 1 Then
								pX = pX - 2 ' // !!! WALK SPEED
							ElseIf curLevel[curPlayer-1] = 2 Or curLevel[curPlayer-1] = 3 Then
								pX = pX - 2
							EndIf						
						Else
							pX = pX - 2
						EndIf
					Else
						pX = 0
					EndIf
				Else
					If pJ = False Then
						If curLevel[curPlayer-1] = 1 Then
							scrollX = scrollX - 2 ' // !!! WALK SPEED
							tileX:-2
							caveX1:-1.5
							
						ElseIf curLevel[curPlayer-1] = 2 Or curLevel[curPlayer-1] = 3 Then
							scrollX = scrollX - 2
							tileX:-2
							caveX1:-1.5

						EndIf					
					Else
						scrollX = scrollX - 2
						tileX:-2
						caveX1:-1.5
						
					EndIf				
				EndIf
			Else
				If pJ = False Then
					If curLevel[curPlayer-1] = 1 Then
						pX = pX - 2 ' // !!! WALK SPEED
					ElseIf curLevel[curPlayer-1] = 2 Or curLevel[curPlayer-1] = 3 Then
						pX = pX - 2
					EndIf
				Else
					pX = pX - 2
				EndIf
			EndIf

			If curLevel[curPlayer-1] = 3 Then tmpAnim = 120 Else tmpAnim = 200 
			If pIdle = True Then tmpAnim = 0 ' // First frame fix
					
			If GetMilliSecs() >= pT + tmpAnim Then
				If pF < 9 Then 
					pF = pF + 1
				Else
					pF = 6
				EndIf
				pT = GetMilliSecs()
			EndIf
			
			If pFall = True Then pF = 10  ' // Falling frame fix
			
			pMove = True			
		EndIf
	

		If GetInput(tmpPlayer, INP_A) = True And pJ = False And pFall = False Then
			
			If curLevel[curPlayer-1] = 1 Then
				pJV = 9
			ElseIf curLevel[curPlayer-1] = 2 Then
				pJV = 6
			ElseIf curLevel[curPlayer-1] = 3 Then
				pJV = 7
			EndIf
			pJ = True
			If curLevel[curPlayer-1] = 1 Then PlaySFX sfxJump Else PlaySFX sfxNJump
			
		EndIf


		If pShoot = True Then ' // Shooting
			If GetMilliSecs() >= pShootT + 150 Then pShoot = False
		EndIf

		If curLevel[curPlayer-1] = 2 Then ' // Shoot Lizard
			If GetInput(tmpPlayer, INP_B) And pShoot = False And NoShot() = True Then
				pShoot = True
				pShootT = GetMilliSecs()
				
				PlaySFX sfxShot
				
				If pD = 1 Then
					p:Part = New Part
					p.ID = PART_SHOT; p.X = Int((pX + 60) + scrollX); p.Y = pY + 37; p.D = 1; p.F = 0
					partList.AddLast p
				Else
					p:Part = New Part
					p.ID = PART_SHOT; p.X = Int((pX - 23) + scrollX); p.Y = pY + 37; p.D = 0; p.F = 2
					partList.AddLast p
				EndIf
			EndIf
			
		ElseIf curLevel[curPlayer-1] = 3 Then ' // Shoot Nemo
			If GetInput(tmpPlayer, INP_B) And pShoot = False And NoShot(1) = True Then
				pShoot = True
				pShootT = GetMilliSecs()
				
				PlaySFX sfxBlast
				
				If pD = 1 Then
					p:Part = New Part
					p.ID = PART_WAND; p.X = Int((pX + 46) + scrollX); p.Y = pY + 8; p.D = 1; p.F = 0
					partList.AddLast p
				Else
					p:Part = New Part
					p.ID = PART_WAND; p.X = Int((pX - 12) + scrollX); p.Y = pY + 8; p.D = 0; p.F = 0
					partList.AddLast p
				EndIf
			EndIf	
			
		EndIf
					
		pIdle = False
		If pMove = False And pJ = False Then  ' // Idle
			If pD = 0 Then 
				pF = 6
			Else 
				pF = 0
			EndIf
			pIdle = True
		EndIf
		
		If pJ = True Then ' // Jumping
			If pD = 0 Then
				pF = 10 
			Else 
				pF = 4
			EndIf
			
			pY = pY - pJV
			
			If GetInput(tmpPlayer, INP_A, 1) = True Then
				pJV = pJV - .25
			Else
				pJV = pJV - .5
			EndIf
				
			If pY >= 240 Then ' // Land
				pY = 240; pJ = False; pT = GetMilliSecs()
				If pD = 0 Then 
					pF = 6 
				Else 
					pF = 0
				EndIf
				jumpC = 0
				pFall = False
			EndIf
			
		
		EndIf
				
		' // Fall
		If bPlat = False And pJ = False And pY < 240 Then
			If pY < 240 Then
				pY = pY + 6
				pFall = True
			Else
				pY = 240
				pFall = False
				
			EndIf
			
			' // Falling while idle fix
			If pD = 0 Then pF = 10 ElseIf pD = 1 Then pF = 4
		EndIf
		
		If pY >= 240 Then 
			pY = 240; pFall = False ' // height fix
			If pF = 4 Or pF = 10 Then  ' // Fall frame reset
				If pD = 0 Then pF = 6 Else pF = 0
			EndIf
		EndIf
		
		If pHurt = True Then ' // Hurt
			pIdle = False
			If GetMilliSecs() <= pHurtT + 200 Then
			
				If pD = 1 Then
					pF = 5
				Else
					pF = 11
				EndIf
			
			Else
				If GetMilliSecs() >= pHurtT + 1250 Then
					pHurt = False
				EndIf
			EndIf
		EndIf
	
		' // Death
		If pLife <= 0 And pDeath = False Then
			pDeath = True
			pT = GetMilliSecs()
			dF = 0
			spinF = 0
			StopChannel musChan ' // Stop music
			PlaySFX sfxDeath
			deathT = GetMilliSecs()
		EndIf
					
		' // Don't create enemies at start or end
		If scrollX <= 230 Then 
		Else
		If curLevel[curPlayer-1] = 1 And scrollX < 6440 Then ' // Generate Level 1 enemies
			
			Local tmpTransform:Int = bTransform
			If b2Player = True Then
				If curPlayer = 1 Then tmpTransform = bTransform ElseIf curPlayer = 2 Then tmpTransform = b2Transform
			EndIf
				
			' // Difficulty setting
			Local tmpRand:Int

			If bHard[curPlayer-1] = True Then
				tmpRand = 150
			Else
				If cfgDiff = 0 Then tmpRand = 250 ElseIf cfgDiff = 1 Then tmpRand = 200
			EndIf
						
			If Rand(1, tmpRand) = Int(tmpRand / 2) And GetMilliSecs() >= createTime + 500 Then ' // Eyeball
				Local tmpC:Int = 0
				For o:Obj = EachIn objList
					If o.ID = OBJ_EYEBALL Then tmpC:+1
				Next 

				' // Don't spawn during transform
				If tmpTransform <> 0 Then tmpC = 2
															
				If tmpC = 0 Then ' // 1 eyeball Max
					o:Obj = New Obj
					o.ID = OBJ_EYEBALL
					o.X = 588 + scrollX; o.L = 1
					o.Y = 240
					objList.AddLast o					
				
					createTime = GetMilliSecs()
				EndIf
			
			EndIf
						
			If Rand(1, tmpRand) = Int(tmpRand / 2) And GetMilliSecs() >= createTime + 500 Then ' // Cloud
				Local tmpC:Int = 0
				For o:Obj = EachIn objList
					If o.ID = OBJ_CLOUD Or o.ID = OBJ_SNAIL Then tmpC:+1
				Next 

				' // Don't spawn during transform
				If tmpTransform <> 0 Then tmpC = 2
				
				If scrollX >= 2172 And scrollX <= 3611 Then ' // Spike check
					tmpC = 2
				EndIf

				If scrollX >= 4468 And scrollX <= 5330 Then ' // Spike check
					tmpC = 2
				EndIf
				
				' // Spike check				
				If tmpC = 0 Then ' // 1 cloud max
					o:Obj = New Obj
					o.X = 588 + scrollX; o.Y = 32; o.ID = OBJ_CLOUD
					objList.AddLast o							
					
					createTime = GetMilliSecs()
				EndIf
								
			EndIf
						
			If Rand(1, tmpRand) = Int(tmpRand / 2) And GetMilliSecs() >= createTime + 500 Then ' // Generate Dog
				Local tmpC:Int = 0
				For o:Obj = EachIn objList
					If o.ID = OBJ_DOG Or o.ID = OBJ_SNAIL Then tmpC:+1
				Next 

				' // Don't spawn during transform
				If tmpTransform = 1 And scrollX >= 1288 Then 
					tmpC = 2
				ElseIf tmpTransform > 1 Then
					tmpC = 2
				EndIf
				
				If scrollX >= 2172 And scrollX <= 3611 Then ' // Spike check
					tmpC = 2
				EndIf

				If scrollX >= 4468 And scrollX <= 5330 Then ' // Spike check
					tmpC = 2
				EndIf
				
				' // Spike check				
				If tmpC < 2 Then ' // Two dog Max
					o:Obj = New Obj
					If tmpTransform = 1 Then o.ID = OBJ_SNAIL Else o.ID = OBJ_DOG
					o.X = 588 + scrollX; o.D = 0		
					If o.ID = OBJ_DOG Then o.Y = 272 ElseIf o.ID = OBJ_SNAIL Then o.Y = 256
					objList.AddLast o							
					
					createTime = GetMilliSecs()
				EndIf			
					
			EndIf
			
		ElseIf curLevel[curPlayer-1] = 2 Then ' // Gen level 2 enemies

			Local tmpRand:Int
					
			If scrollX >= 2600 And scrollX <= 5000 Then
				' // Difficulty setting
				If bHard[curPlayer-1] = True Then
					tmpRand = 150
				Else
					If cfgDiff = 0 Then tmpRand = 250 ElseIf cfgDiff = 1 Then tmpRand = 200
				EndIf
							
				If Rand(1, tmpRand) = Int(tmpRand / 2) And GetMilliSecs() >= createTime + 500 Then ' // Generate Skeleton
					
					Local tmpC:Int = 0
					For o:Obj = EachIn objList
						If o.ID = OBJ_SKEL Then tmpC:+1
					Next 
					
					If tmpC < 2 Then ' // Two skeleton Max
						o:Obj = New Obj
						o.ID = OBJ_SKEL
						o.X = 588 + scrollX; o.D = 0				
						o.Y = 240; o.L = 1

						objList.AddLast o							
						
						createTime = GetMilliSecs()					
					EndIf
				EndIf	
			EndIf
			
			If scrollX >= 5300 And scrollX <= 6260 Then
				' // Difficulty setting
				If bHard[curPlayer-1] = True Then
					tmpRand = 100
				Else
					If cfgDiff = 0 Then tmpRand = 200 ElseIf cfgDiff = 1 Then tmpRand = 150
				EndIf			
			
				If Rand(1, tmpRand) = Int(tmpRand / 2) And GetMilliSecs() >= createTime + 500 Then ' // Generate Skeleton
					
					Local tmpC:Int = 0
					For o:Obj = EachIn objList
						If o.ID = OBJ_GHOST Then tmpC:+1
					Next 
					
					If tmpC < 1 Then ' // 1 ghost max
						o:Obj = New Obj
						o.ID = OBJ_GHOST
						o.X = 588 + scrollX; o.D = 0
						o.YI = -4
						o.Y = 304 - 128; o.L = 0
						o.Alp = .95
						o.C2 = GetMilliSecs()
						
						objList.AddLast o							
						
						createTime = GetMilliSecs()					
					EndIf
				EndIf	
			EndIf
			
			If scrollX >= 4934 And scrollX <= 6875 Then ' // Create cave drops
				If bHard[curPlayer-1] = True Then
					tmpRand = 10
				Else
					If cfgDiff = 0 Then tmpRand = 14 ElseIf cfgDiff = 1 Then tmpRand = 12
				EndIf
							
				If Rand(1, tmpRand) = Int(tmpRand / 2) Then ' // Generate drop
					objList.AddLast obj.Create(5525 + Rand(0, 1288), 60, OBJ_DROP, 2)
				EndIf
			EndIf
		
		ElseIf curLevel[curPlayer-1] = 3 Then ' // Gen level 3 enemies
			
			Local tmpRand:Int
						
			If scrollX >= 100 And scrollX <= 900 Then ' // Bridge
				' // Difficulty setting
				If bHard[curPlayer-1] = True Then
					tmpRand = 50
				Else
					If cfgDiff = 0 Then tmpRand = 150 ElseIf cfgDiff = 1 Then tmpRand = 100
				EndIf
										
				If Rand(1, tmpRand) = Int(tmpRand / 2) And GetMilliSecs() >= createTime + 500 Then ' // Generate Fish
										
					o:Obj = New Obj
					o.ID = OBJ_FISH
					o.X = Rand(464, 551) + scrollX; o.D = 0
					o.YI = -Rand(4,7)
					o.Y = 342; o.L = 0
					o.Alp = 1
					o.C2 = GetMilliSecs()
					o.A = 0
						
					
					objList.AddLast o							
					
					createTime = GetMilliSecs()					

				EndIf	
							
			EndIf
			
		EndIf
		EndIf ' // LEVEL START BLOCK

		Local tmpTransform:Int = bTransform
		If b2Player = True Then
			If curPlayer = 1 Then tmpTransform = bTransform ElseIf curPlayer = 2 Then tmpTransform = b2Transform
		EndIf
										
		' // Nightmare transition
		If scrollX >= 1570 And tmpTransform = 1 Then
			transTime = GetMilliSecs()
			StopChannel musChan
			sfxChan = PlaySFX(sfxStart)
			If curPlayer = 1 Then
				bTransform = 2
			ElseIf curPlayer = 2 Then
				b2Transform = 2
			EndIf
		EndIf
		
		If curPlayer = 1 Then
			If bTransform > 1 And bTransform < 32 Then
				If GetMilliSecs() >= transTime + (bTransform * 5) Then
					If bTransform < 31 Then 
						bTransform:+1 
					Else 
						bTransform = 0
						musChan = PlaySound(musLevel1, musChan)
						musChan.SetVolume(Float(cfgMusic) / 10)	
					EndIf
					
					If bTransform Mod 2 = 0 Then
						SetClsColor 0, 0, 0
					Else
						SetClsColor 255, 255, 255
					EndIf
					transTime = GetMilliSecs()
				EndIf
			EndIf
		ElseIf curPlayer = 2 Then
			If b2Transform > 1 And b2Transform < 32 Then
				If GetMilliSecs() >= transTime + (b2Transform * 5) Then
					If b2Transform < 31 Then 
						b2Transform:+1 
					Else 
						b2Transform = 0
						musChan = PlaySound(musLevel1, musChan)
						musChan.SetVolume(Float(cfgMusic) / 10)	
					EndIf
					
					If b2Transform Mod 2 = 0 Then
						SetClsColor 0, 0, 0
					Else
						SetClsColor 255, 255, 255
					EndIf
					transTime = GetMilliSecs()
				EndIf
			EndIf		
		EndIf
		
		' // PAUSE 
		Local bP1Start:Int = False
		Local bP2Start:Int = False

		If GetInput(tmpPlayer, INP_S) = True Then bP1Start = True
		
		If bP1Start = True Or bP2Start = True Then
			
				'If waveC <> 999 Then ' // Not game over
			bPaused = True; PlaySFX sfxPause
			FlushInput			
			pauseStart = GetMilliSecs() ' // Hold pause start time
			PauseChannel musChan
				'EndIf
		EndIf
		
		' // StepOver
		EndIf
	EndIf
	
	If bDebug = True Then DrawDebug
	
	RenderOverlay() ' // Overlay graphics
						
	GetFuncInput ' // Function Keys
	
	If bSkip = True Or bGameOver = True Then Cls; bSkip = False ' // Don't draw this frame
	
	If bGameOver = True Then ' // Back to title
		bTitle = True
		bGameOver = False
		
		For o:Obj = EachIn objList; objList.Remove o; Next ' // Objects
		For p:Part = EachIn partList; partList.Remove p; Next ' // Particles

		StopChannel musChan
		musChan = PlaySound(musTitle, musChan)
		musChan.SetVolume(Float(cfgMusic) / 10) 
		
	EndIf
	
	If GetMilliSecs() >= fpsTimer + 1000 Then FPS = curFrames; curFrames = 0; fpsTimer = GetMilliSecs()
	curFrames = curFrames + 1
	
	Flip 1 

	If bPaused = True Then ' // PAUSE
		Local tmpIn:Int = 0

		Repeat
			GetFuncInput ' // Function Keys

			If GetInput(curPlayer-1, INP_S) = True Then tmpIn = 1

			If KeyDown(KEY_ESCAPE) = True Then tmpIn = 2
			Delay 10 ' // Give CPU time
		Until tmpIn <> 0
		
		PlaySFX sfxPause; bPaused = False
		pauseTotal = pauseTotal + (GetMilliSecs() - pauseStart) ' // Time offset fix
		ResumeChannel musChan
		FlushJoy(0); FlushJoy(1)
		If tmpIn <> 2 Then 
			FlushKeys
		Else
			EndGame
		EndIf
		
	EndIf

	Cls
	
Until KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True
EndGame


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SLEEPSCENE - Shows sleep scene
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SleepScene()

	StopChannel sfxChan
	PauseChannel musChan
	
	Local sleepT:Int = GetMilliSecs()
	Local sleepF:Int = 0
	Local nemoF:Int = 6, nemoX:Float = 588, nemoY:Float = 268
	Local nemoJ:Int = False, nemoYI:Float = 0
	Local puffF:Int = 1
	Local bExit:Int = False
	
	Cls
	FlushInput
	
	sfxChan = PlaySFX(sfxSleep)

	Repeat
		SetAlpha ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

		DrawImage imgSleep[curPlayer-1], 0, 0, sleepF
		
		Local tmpStar:String = ""
		If bHard[curPlayer-1] = True Then tmpStar$ = "&"
		
		DrawFont "Dream " + String(curLevel[curPlayer-1]) + tmpStar$, -1, 158
		If curLevel[curPlayer-1] = 1 Then
			DrawFont "Mushroom Forest", -1, 190
		ElseIf curLevel[curPlayer-1] = 2 Then
			DrawFont "Frozen Caverns", -1, 190
		ElseIf curLevel[curPlayer-1] = 3 Then
			DrawFont "Nightmare Land", -1, 190	
		EndIf
		
		If nemoX > 110 Then DrawImage imgNemo[curPlayer-1], Int(nemoX), Int(nemoY), nemoF
		
		If nemoX > 230 Then
			nemoX:-2.3
			If GetMilliSecs() >= sleepT + 120 Then
				nemoF:+1
				If nemoF > 9 Then nemoF = 6
				sleepT = GetMilliSecs()
			EndIf
		ElseIf nemoX > 110 Then
			If nemoJ = False Then nemoJ = True; nemoF = 10; nemoYI = -7
			
			If nemoJ = True Then
				nemoX:-2.6
				If nemoYI < 6 Then nemoYI:+.27
				nemoY:+nemoYI
			EndIf
		
			sleepT = GetMilliSecs()
		Else
			If GetMilliSecs() >= sleepT + 120 And puffF >= 0 Then
				If puffF < 3 Then 
					puffF:+1 
					sleepT = GetMilliSecs()					
				Else 
					puffF = -1; sleepF = 1
				EndIf
			EndIf
			
			If puffF <> -1 Then
				DrawImage imgDeath, 101, 263, puffF
			EndIf
		EndIf
		
		
		SetColor 255, 255, 255
	
		If bDebug = True Then DrawDebug
		
		RenderOverlay() ' // Draw overlay graphics
						
		GetFuncInput ' // Function Keys
		If KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True Then bExit = True
		
		Flip 1; Cls
	Until ChannelPlaying(sfxChan) = False Or bExit = True

	If bExit = True Then EndGame ' // End game

	ResumeChannel musChan
	
	FlushInput	
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYERSCENE - Shows active player and their lives
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlayerScene()

	StopChannel sfxChan
	PauseChannel musChan
	
	Cls
	FlushInput
	
	Local playT:Int = GetMilliSecs(), bExit:Int = False
	
	Repeat
		SetAlpha ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255
			
		DrawFont "Player " + String(curPlayer), -1, 158
		
		DrawImage imgLives, 254, 190, curPlayer - 1
		Local tmpS:String
		If curPlayer = 1 Then tmpS$ = String(pLives) ElseIf curPlayer = 2 Then tmpS$ = String(p2Lives)
		
		DrawFont tmpS$, 315, 202
		
		SetColor 255, 255, 255
	
		If bDebug = True Then DrawDebug
		
		RenderOverlay() ' // Draw overlay graphics
						
		GetFuncInput ' // Function Keys
		If KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True Then bExit = True
		
		Flip 1; Cls
	Until GetMilliSecs() >= playT + 2000 Or bExit = True 

	If bExit = True Then EndGame ' // End game

	ResumeChannel musChan
	
	FlushInput	
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GAMEOVER - Shows game over / name entry screen
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GameOver()

	StopChannel sfxChan
	StopChannel musChan
	musChan = PlaySound(musOver, musChan)
	musChan.SetVolume(Float(cfgMusic) / 10) 	
	
	' // Flush input
	FlushInput
	
	Local tScreen:Int = 0
	Local tSelX:Int = 141, tSelY:Int = 126, hi_A:Int
	
	Local tmpName:String = ""
	
	Local bExit:Int = False
	Repeat
		SetAlpha ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

		' // Ebbing blood
		Local tmpY:Int
		tmpY = 382 - ebbF
		SetColor 216, 40, 0
		DrawRect 0, tmpY, 588, 20
		SetColor 255, 255, 255
		
		If GetMilliSecs() >= ebbT + 250 Then
			If ebbD = 0 Then
				If ebbF < 6 Then ebbF:+1 Else ebbD = 1
			ElseIf ebbD = 1 Then
				If ebbF > 0 Then ebbF:-1 Else ebbD = 0
			EndIf
			ebbT = GetMilliSecs()
		EndIf

		Local tmpF:Int = 0
		If tScreen <> 0 Then tmpF = 1
		DrawImage imgGameOver, 0, 0, tmpF
				
		For o:Obj = EachIn objList; o.Render(0); Next ' // Back objects
		For p:Part = EachIn partList; p.Render(); Next ' // Particles

		Local tmpScore:Int
		If curPlayer = 1 Then tmpScore = pScore ElseIf curPlayer = 2 Then tmpScore = p2Score
							
		If tScreen = 0 Then 
			If b2Player = True Then
				DrawFont "Player " + String(curPlayer), -1, 120
			EndIf
			
			DrawFont NumFormat(tmpScore), -1, 254
			DrawFont "B - Exit", -1, 350
		EndIf
		
		If tmpScore <> 0 And cfgDiff > 0 Then ' // Save score
			If tScreen = 0 Then
				SetColor 255, 255, 255
				DrawFont "A - Save", -1, 318
			ElseIf tScreen = 1 Then
			
				DrawFont tmpName$, -1, 316
				
				Local tmpA:Int = 65
				For Local tmpY:Int = 126 To 311 Step 42
					For Local tmpX:Int = 141 To 435 Step 48
						If tSelX = tmpX And tSelY = tmpY Then ' // Current letter
							SetColor Rand(128, 255), 0, 0
							hi_A = tmpA
						Else
							SetColor 252, 252, 252
						EndIf
						DrawFont Chr(tmpA), tmpX, tmpY
						If tmpA < 90 Then tmpA:+1 Else Exit
					Next
					If tmpA = 90 Then Exit
				Next
							
				If tSelX = 381 And tSelY = 252 Then 
					SetColor Rand(128, 255), 0, 0  'SetColor Rand(78, 255), 0, 0 Else SetColor 255, 255, 255
				Else
					SetColor 252, 252, 252				
					'DrawImage imgHi, Int(tSelX - 10), Int(tSelY - 6)
				EndIf

				DrawFont "END", 383, 252
				SetColor 255, 255, 255
				
				DebugLog "TSelX: " + tSelX + " TSelY: " + tSelY

				Local bJoyUp:Int = -1
				Local bJoyDown:Int = -1
				Local bJoyLeft:Int = -1
				Local bJoyRight:Int = -1
				
				If GetInput(curPlayer-1, INP_U) = True And bJoy1YHit = False Then bJoyUp = PLAYER_1 
				If GetInput(curPlayer-1, INP_D) = True And bJoy1YHit = False Then bJoyDown = PLAYER_1
				If GetInput(curPlayer-1, INP_L) = True And bJoy1XHit = False Then bJoyLeft = PLAYER_1			
				If GetInput(curPlayer-1, INP_R) = True And bJoy1XHit = False Then bJoyRight = PLAYER_1

				If bJoyUp = 0 Then
					If tSelY > 126 Then tSelY:-42
				
					bJoy1YHit = True
					bJoy2YHit = True
					
				ElseIf bJoyDown = 0 Then
					If tSelY < 252 Then 
						If tSelX = 429 And tSelY = 210 Then tSelX:-48 ' // End
						tSelY:+42
					EndIf
					
					bJoy1YHit = True
					bJoy2YHit = True					
					
				ElseIf bJoyLeft = 0 Then
					If tSelX > 141 Then tSelX:-48
				
					bJoy1XHit = True
					bJoy2XHit = True
					
				ElseIf bJoyRight = 0 Then			
					If tSelX < 429 Then 
						If tSelX = 381 And tSelY = 252 Then ' // End
						Else
							tSelX:+48	
						EndIf
					EndIf
					
					bJoy1XHit = True
					bJoy2XHit = True					
				EndIf
				
				' // Reset joysticks
				Local tmpJoy:Int
				If b2Player = True Then
					If curPlayer = 1 Then tmpJoy = p1Joy ElseIf curPlayer = 2 Then tmpJoy = p2Joy				
				EndIf
				
				If JoyY(tmpJoy) <= .5 And JoyY(tmpJoy) >= -.5 Then 
					bJoy1YHit = False ' // Reset joystick
				EndIf
				
				If JoyX(tmpJoy) <= .5 And JoyX(tmpJoy) >= -.5 Then 
					bJoy1XHit = False ' // Reset joystick
				EndIf
				
				If JoyY(tmpJoy) <= .5 And JoyY(tmpJoy) >= -.5 Then 
					bJoy2YHit = False ' // Reset joystick
				EndIf
				
				If JoyX(tmpJoy) <= .5 And JoyX(tmpJoy) >= -.5 Then 
					bJoy2XHit = False ' // Reset joystick
				EndIf
				
			EndIf
		EndIf
		
		' // Generate blood drops
		If Rand(1, 20) = 10 Then CreateDrops(1)

		If bDebug = True Then DrawDebug
		
		RenderOverlay() ' // Draw overlay graphics
						
		GetFuncInput ' // Function Keys
		
		If GetInput(curPlayer-1, INP_B) = True Then 
			If tScreen = 0 Then 
				bExit = True
				PlaySFX sfxPoof
				
			ElseIf tScreen = 1 Then
				If tSelX = 381 And tSelY = 252 Then ' // End (UPLOAD)
					PlaySFX sfxShot
					If tmpName$ = "" Then tmpName$ = "NemoX" ' // Default
					
					sfxChan = PlaySFX(sfxUpload)					
					UploadScore(tmpScore + " " + LSet(tmpName$, 6))	
					bExit = True
					
				Else ' // Letter
					If Len(tmpName$) < 6 Then tmpName$ = tmpName$ + Chr(hi_A); PlaySFX sfxShot
				EndIf
			
			EndIf
		EndIf
		
		If tmpScore <> 0 And cfgDiff > 0 Then
			If GetInput(curPlayer-1, INP_A) = True Then
				If tScreen = 0 Then
					tScreen = 1
					
					StopChannel sfxChan
					StopChannel musChan
					musChan = PlaySound(musEntry, musChan)
					musChan.SetVolume(Float(cfgMusic) / 10) 	
					
					PlaySFX sfxShot
					
				ElseIf tScreen = 1 Then
					If Len(tmpName$) > 0 Then tmpName$ = Left$(tmpName$, Len(tmpName$) - 1); PlaySFX sfxPoof

				EndIf
			EndIf
		EndIf
		
		Flip 1; Cls
	Until bExit = True Or KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True 

	If bExit = False Then EndGame ' // End game

	' // Flush input
	FlushInput
		
	bGameOver = True
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² FLUSHINPUT - Flushes joystick and keyboard input
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function FlushInput()

	FlushKeys; FlushJoy 0; FlushJoy 1	
	If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_A) = True Or GetInput(PLAYER_1, INP_S) = True Then
	EndIf
	If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_A) = True Or GetInput(PLAYER_2, INP_S) = True Then
	EndIf
	FlushKeys; FlushJoy 0; FlushJoy 1	

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GAMEWON - Game won screen
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GameWon()

	StopChannel sfxChan
	StopChannel musChan
	
	sfxChan = PlaySFX(sfxGame)
	
	' // Flush input
	Cls
	FlushInput
	
	Local bExit:Int = False
	Repeat
		SetAlpha ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

		DrawImage imgWin[curPlayer-1], 0, 0, 0
				
		DrawFont "Congratulations, Nemo!", -1, 32

		DrawFont "You have defeated death...", -1, 96
		DrawFont "or have you?", -1, 120

		If cfgDiff <> 0 Then
			DrawFont "Unable to awake, you slip", -1, 184
			DrawFont "deeper into the depths of", -1, 208
			DrawFont "your hellish nightmare...", -1, 232
			
		EndIf
		
		If bDebug = True Then DrawDebug
		
		RenderOverlay() ' // Draw overlay graphics
						
		GetFuncInput ' // Function Keys
		If ChannelPlaying(sfxChan) = False Then

			If cfgDiff = 0 Then DrawFont "Try again on normal", -1, 448 - 56	
			DrawFont "Press START to continue", -1, 448 - 32
						
			If GetInput(curPlayer-1, INP_S) = True Then bExit = True
		EndIf
		
		Flip 1; Cls
	Until bExit = True Or KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True

	If bExit = False Then EndGame ' // End game

	' // Flush input
	FlushInput	
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADSCORES - Loads online hi scores
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadScores:Int()
	
	' ///////////////////////////////////////////
	' // CODE REMOVED TO KEEP SCORES SECURE
	' ///////////////////////////////////////////
	Return False
					
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYERCHECK - Adds score and handles 1 ups
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function AddScore(myAdd:Int)

	Local oldS:Int
	Local tmp1:Int = False

	If curPlayer = 1 Then 
		oldS = pScore
		pScore:+myAdd

		For Local tmpS:Int = 1000000 To 20000 Step -20000
			If oldS < tmpS And pScore >= tmpS Then tmp1 = True; Exit ' // 1-Up check
		Next
		
		If tmp1 = True Then ' // 1-UP Check
			If pLives < 9 Then pLives:+1; PlaySFX sfx1UP
		EndIf

	ElseIf curPlayer = 2 Then
		oldS = p2Score
		p2Score:+myAdd

		For Local tmpS:Int = 1000000 To 20000 Step -20000
			If oldS < tmpS And p2Score >= tmpS Then tmp1 = True; Exit ' // 1-Up check
		Next
		
		If tmp1 = True Then ' // 1-UP Check
			If p2Lives < 9 Then p2Lives:+1; PlaySFX sfx1UP
		EndIf
		
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYERCHECK - Checks whether player can jump on an enemy
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlayerCheck:Int()

	If pDeath = False Then
		If pJ = True And pJV < 0 Then Return True
		If pFall = True And (pF = 4 Or pF = 10) Then Return True
	EndIf
	
	Return False
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NEWGAME - Starts new game or restarts level
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NewGame(bRestart:Int = False)

	For o:Obj = EachIn objList; objList.Remove o; Next ' // Objects
	For p:Part = EachIn partList; partList.Remove p; Next ' // Particles

	pX# = 0; pY = 240; pF = 0; pD:Int = 1
	pJ = False; pJV = 5; pHurt = False
	jumpC = 0; gloHit = False
	bPlat = False; pFall = False; pDeath = False; dF = 0; spinF = 0
	bBoss = False; bCounting = False; pShoot = False; pIdle = False
	scrollX = 0; tileX = 0

	bCandy = False ' // Candy secret
	faceCount = 0
	
	caveX1 = 0
	caveF1 = 0; caveF2 = 2; caveF3 = 4
	caveD1 = 1; caveD2 = 1; caveD3 = 1
	
	lavaF = 0
	
	If bRestart = 3 Then Return ' // Back to title
	
	If cfgDiff = 0 Then ' // Easy
		pLife = 5
		
	ElseIf cfgDiff = 1 Then ' // Normal
		pLife = 3
		
	EndIf
	
	If bRestart = False Then
		pScore = 0
		p2Score = 0
		curLevel[0] = 1
		curLevel[1] = 1
		bHard[0] = False
		bHard[1] = False
		bTransform = 1
		b2Transform = 1
		bSkip = False
		bGameOver = False
		bSpikes = False
				
		If cfgDiff = 0 Then ' // Easy
			pLife = 5; pLives = 3
			p2Lives= 3
			
		ElseIf cfgDiff = 1 Then ' // Normal
			pLife = 3; pLives = 2
			p2Lives = 2
						
		EndIf
		
		bAlien[0] = False
		bAlien[1] = False
		
	Else
		If bTransform <> 1 Then bTransform = 0
		If b2Transform <> 1 Then b2Transform = 0
	EndIf
	
	' // Timer
	If cfgDiff = 0 Then
		If curLevel[curPlayer-1] = 1 Then
			timeMin = 2; timeSec = 30
		ElseIf curLevel[curPlayer-1] = 2 Then
			timeMin = 3; timeSec = 0
		ElseIf curLevel[curPlayer-1] = 3 Then
			timeMin = 1; timeSec = 30
		EndIf
	Else
		If curLevel[curPlayer-1] = 1 Then
			timeMin = 2; timeSec = 0
		ElseIf curLevel[curPlayer-1] = 2 Then
			timeMin = 2; timeSec = 30
		ElseIf curLevel[curPlayer-1] = 3 Then
			timeMin = 1; timeSec = 0
		EndIf
	EndIf
	
	StopChannel sfxChan
	StopChannel musChan
	
	Local tmpTransform:Int = bTransform
	If b2Player = True Then
		If curPlayer = 1 Then tmpTransform = bTransform ElseIf curPlayer = 2 Then tmpTransform = b2Transform
	EndIf
	
	If curLevel[curPlayer-1] = 1 Then
		If tmpTransform = 1 Then
			musChan = PlaySound(musNemo, musChan)
		Else
			musChan = PlaySound(musLevel1, musChan)
		EndIf
	ElseIf curLevel[curPlayer-1] = 2 Then
		musChan = PlaySound(musLevel2, musChan)
	ElseIf curLevel[curPlayer-1] = 3 Then
		If bAlien[curPlayer-1] = True Then
			musChan = PlaySound(musAlien, musChan)
		Else
			musChan = PlaySound(musLevel3, musChan)
		EndIf
	EndIf
	
	musChan.SetVolume(Float(cfgMusic) / 10)	
	curSong = curLevel[curPlayer-1] + 1
	ebbF = 0; ebbD = 0
			
	CreatePlats curLevel[curPlayer-1] ' // Create platforms
	
	FlushInput	
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADIMAGES - Load images with desired filter
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadImages(bFil:Int)

	Local imgFlags:Int, i:Int
	If bFil = True Then imgFlags = MASKEDIMAGE|FILTEREDIMAGE Else imgFlags = MASKEDIMAGE

	' // General
	For i = 0 To 1
		imgSpin[i] = Null
		imgSleep[i] = Null
		imgStatus[i] = Null
		imgWin[i] = Null
	Next
	
	imgTitle = Null
	imgSel = Null
	imgDrop = Null
	imgFont = Null
	imgHit = Null
	imgPickup = Null
	imgGameOver = Null
	imgDoor = Null
	imgDeath = Null
	imgCRT = Null
	imgCandy = Null
	imgLife = Null
	imgHi = Null
	imgLives = Null
	
	' // Level 1
	For i = 0 To 1
		imgFrog[i] = Null
		imgFrogO[i] = Null	
	Next
	
	imgBack = Null
	imgBack2 = Null
	imgDog = Null
	imgSnail = Null
	imgTile = Null
	imgTileO = Null
	imgTile2 = Null
	imgShroom1 = Null
	imgShroom2 = Null
	imgShroom3 = Null
	imgBase1 = Null
	imgBase2 = Null
	imgCloud = Null
	imgTree = Null
	imgTreeO = Null
	imgTree3 = Null
	imgGrave = Null
	imgEye = Null
	imgLaser = Null
	imgSky = Null
	imgFlip = Null
	imgWelcome = Null
	imgWelcomeO = Null
	imgBoss1 = Null
	imgPump = Null
	imgFloat = Null
	imgEx1 = Null
	imgDrop3 = Null
	
	' // Level 2
	For i = 0 To 1
		imgLizard[i] = Null
		imgLizardF[i] = Null
	Next
	
	imgTile3 = Null
	imgSky2 = Null
	imgFloat2 = Null
	imgTile4 = Null
	imgFlame = Null
	imgShot = Null
	imgMonkey = Null
	imgWelcome2 = Null
	imgTree2 = Null
	imgTree3 = Null
	imgSkel = Null
	imgIce = Null
	imgTile5 = Null
	imgDrop2 = Null
	imgBoss2 = Null
	imgFire = Null
	imgCave1 = Null
	imgCave2 = Null
	imgCave3 = Null
	imgEgg = Null
	imgGhost = Null
	imgMark = Null
	imgBoss2C = Null
	
	' // Level 3
	For i = 0 To 1
		imgNemo[i] = Null
		imgNemoIdle[i] = Null
		imgNemoF[i] = Null
	Next
	
	imgTile6 = Null
	imgBlast = Null
	imgSky3 = Null
	imgWolf = Null
	imgWelcome3 = Null
	imgTile7 = Null
	imgBack3 = Null
	imgBoss3 = Null
	imgFace = Null
	imgSpikes = Null
	imgWelcomeA = Null
	imgBack4 = Null
	imgFish = Null
	imgTile8 = Null
	imgBackO = Null
	imgRain = Null
	
	SetMaskColor 255, 0, 255
	
	' // General
	Local tmpS:String
	For i = 0 To 1
		If i = 0 Then tmpS$ = "" Else tmpS$ = "2"
		imgSpin[i] = LoadAnimImage("gfx/spin" + tmpS$ + ".png", 32, 32, 0, 4, imgFlags)
		imgSleep[i] = LoadAnimImage("gfx/sleep" + tmpS$ + ".png", 256, 224, 0, 2, imgFlags)
		imgWin[i] = LoadImage("gfx/win" + tmpS$ + ".png", imgFlags)
		imgStatus[i] = LoadImage("gfx/status" + tmpS$ + ".png", imgFlags)
	Next
	
	imgTitle = LoadAnimImage("gfx/title.png", 256, 224, 0, 2, imgFlags)
	imgSel = LoadImage("gfx/sel.png", imgFlags)
	imgDrop = LoadImage("gfx/drop.png", imgFlags)
	imgFont = LoadAnimImage("gfx/font.png", 8, 8, 0, 64, imgFlags)
	imgHit = LoadImage("gfx/hit.png", imgFlags)
	imgPickup = LoadAnimImage("gfx/pick.png", 16, 16, 0, 3, imgFlags)
	imgGameOver = LoadAnimImage("gfx/over.png", 256, 224, 0, 2, imgFlags)
	imgDoor = LoadImage("gfx/door.png", imgFlags)
	imgDeath = LoadAnimImage("gfx/death.png", 32, 32, 0, 4, imgFlags)
	imgCandy = LoadAnimImage("gfx/candy.png", 14, 8, 0, 6, imgFlags)
	imgCRT = LoadImage("gfx/crt5.png", MASKEDIMAGE)
	imgLife = LoadAnimImage("gfx/life.png", 7, 4, 0, 2, imgFlags)
	imgHi = LoadImage("gfx/hi.png", MASKEDIMAGE)
	imgLives = LoadAnimImage("gfx/lives.png", 23, 15, 0, 2, imgFlags)
	
	' // Level 1
	For i = 0 To 1
		If i = 0 Then tmpS$ = "" Else tmpS$ = "2"
		imgFrog[i] = LoadAnimImage("gfx/frog" + tmpS$ + ".png", 32, 32, 0, 12, imgFlags)
		imgFrogO[i] = LoadAnimImage("gfx/frogo" + tmpS$ + ".png", 32, 32, 0, 12, imgFlags)
	Next
	
	imgBack = LoadImage("gfx/back2.png", imgFlags)
	imgBack2 = LoadImage("gfx/back1.png", imgFlags)	
	imgDog = LoadAnimImage("gfx/dog.png", 32, 16, 0, 4, imgFlags)
	imgSnail = LoadAnimImage("gfx/snail.png", 29, 24, 0, 2, imgFlags)
	imgTile = LoadImage("gfx/tile1.png", imgFlags)
	imgTileO = LoadImage("gfx/tile1o.png", imgFlags)
	imgTile2 = LoadImage("gfx/tile2.png", imgFlags)
	imgShroom1 = LoadImage("gfx/shroom1.png", imgFlags)
	imgShroom2 = LoadImage("gfx/shroom2.png", imgFlags)
	imgShroom3 = LoadImage("gfx/shroom3.png", imgFlags)
	imgBase1 = LoadAnimImage("gfx/base1.png", 176, 112, 0, 3, imgFlags)
	imgBase2 = LoadImage("gfx/base2.png", imgFlags)
	imgCloud = LoadImage("gfx/cloud.png", imgFlags)
	imgTree = LoadImage("gfx/tree.png", imgFlags)
	imgTreeO = LoadAnimImage("gfx/treeo.png", 128, 149, 0, 3, imgFlags)
	imgTree3 = LoadAnimImage("gfx/tree3.png", 144, 112, 0, 2, imgFlags)
	imgGrave = LoadImage("gfx/grave.png", imgFlags)
	imgEye = LoadAnimImage("gfx/eye.png", 16, 32, 0, 2, imgFlags)
	imgLaser = LoadAnimImage("gfx/laser.png", 16, 16, 0, 2, imgFlags)
	imgSky = LoadImage("gfx/sky.png", imgFlags)
	imgFlip = LoadAnimImage("gfx/flip.png", 23, 33, 0, 3, imgFlags)
	imgWelcome = LoadImage("gfx/welcome.png", imgFlags)
	imgWelcomeO = LoadImage("gfx/welcomeo.png", imgFlags)	
	imgBoss1 = LoadAnimImage("gfx/boss1.png", 24, 47, 0, 4, imgFlags)
	imgPump = LoadAnimImage("gfx/pump.png", 16, 16, 0, 2, imgFlags)
	imgFloat = LoadAnimImage("gfx/float.png", 16, 16, 0, 2, imgFlags)
	imgEx1 = LoadAnimImage("gfx/ex1.png", 24, 24, 0, 6, imgFlags)
	imgDrop3 = LoadImage("gfx/drop3.png", imgFlags)
		
	' // Level 2
	For i = 0 To 1
		If i = 0 Then tmpS$ = "" Else tmpS$ = "2"
		imgLizard[i] = LoadAnimImage("gfx/lizard" + tmpS$ + ".png", 32, 32, 0, 12, imgFlags)
		imgLizardF[i] = LoadAnimImage("gfx/lizardf" + tmpS$ + ".png", 32, 32, 0, 2, imgFlags)
	Next
	
	imgTile3 = LoadImage("gfx/tile3.png", imgFlags)
	imgSky2 = LoadImage("gfx/sky2.png", imgFlags)	
	imgFloat2 = LoadImage("gfx/float2.png", imgFlags)
	imgTile4 = LoadAnimImage("gfx/tile4.png", 64, 32, 0, 3, imgFlags)
	imgFlame = LoadAnimImage("gfx/flame.png", 32, 56, 0, 8, imgFlags)
	imgShot = LoadAnimImage("gfx/shot.png", 16, 7, 0, 4, imgFlags)
	imgMonkey = LoadAnimImage("gfx/monkey.png", 30, 32, 0, 3, imgFlags)
	imgWelcome2 = LoadImage("gfx/welcome2.png", imgFlags)
	imgTree2 = LoadAnimImage("gfx/tree2.png", 160, 152, 0, 3, imgFlags)
	imgTree4 = LoadAnimImage("gfx/tree4.png", 160, 152, 0, 3, imgFlags)	
	imgSkel = LoadAnimImage("gfx/skel.png", 16, 32, 0, 4, imgFlags)
	imgIce = LoadAnimImage("gfx/ice2.png", 16, 16, 0, 2, imgFlags)
	imgTile5 = LoadImage("gfx/tile5.png", imgFlags)
	imgDrop2 = LoadImage("gfx/drop2.png", imgFlags)
	imgBoss2 = LoadAnimImage("gfx/boss2.png", 32, 56, 0, 6, imgFlags)
	imgFire = LoadAnimImage("gfx/fire.png", 16, 16, 0, 2, imgFlags)
	imgCave1 = LoadAnimImage("gfx/cave1.png", 384, 120, 0, 5, imgFlags)
	imgCave2 = LoadAnimImage("gfx/cave2.png", 384, 120, 0, 5, imgFlags)
	imgCave3 = LoadAnimImage("gfx/cave3.png", 384, 120, 0, 5, imgFlags)
	imgEgg = LoadAnimImage("gfx/egg.png", 16, 16, 0, 4, imgFlags)
	imgGhost = LoadAnimImage("gfx/ghost.png", 32, 32, 0, 2, imgFlags)
	imgMark = LoadImage("gfx/mark.png", imgFlags)
	imgBoss2C = LoadAnimImage("gfx/boss2c.png", 32, 56, 0, 6, imgFlags)
	
	' // Level 3
	For i = 0 To 1
		If i = 0 Then tmpS$ = "" Else tmpS$ = "2"
		imgNemo[i] = LoadAnimImage("gfx/nemo" + tmpS$ + ".png", 32, 32, 0, 12, imgFlags)
		imgNemoIdle[i] = LoadAnimImage("gfx/nemoi" + tmpS$ + ".png", 32, 32, 0, 2, imgFlags)
		imgNemoF[i] = LoadAnimImage("gfx/nemof" + tmpS$ + ".png", 32, 32, 0, 2, imgFlags)
	Next
	
	imgTile6 = LoadImage("gfx/tile6.png", imgFlags)
	imgBlast = LoadAnimImage("gfx/blast.png", 16, 16, 0, 4, imgFlags)
	imgSky3 = LoadImage("gfx/sky3.png", imgFlags)
	imgWolf = LoadAnimImage("gfx/wolf.png", 32, 32, 0, 3, imgFlags)
	imgWelcome3 = LoadImage("gfx/welcome3.png", imgFlags)
	imgTile7 = LoadAnimImage("gfx/tile7.png", 64, 32, 0, 3, imgFlags)
	imgBack3 = LoadImage("gfx/back3.png", imgFlags)
	imgBoss3 = LoadAnimImage("gfx/boss3.png", 57, 110, 0, 2, imgFlags)
	imgFace = LoadAnimImage("gfx/face.png", 16, 16, 0, 4, imgFlags)
	imgSpikes = LoadAnimImage("gfx/spikes.png", 16, 16, 0, 2, imgFlags)
	imgWelcomeA = LoadImage("gfx/welcomea.png", imgFlags)
	imgBack4 = LoadImage("gfx/back4.png", imgFlags)
	imgFish = LoadAnimImage("gfx/fish.png", 16, 22, 0, 2, imgFlags)
	imgTile8 = LoadAnimImage("gfx/tile8.png", 64, 32, 0, 3, imgFlags)
	imgBackO = LoadAnimImage("gfx/backO.png", 256, 184, 0, 2, imgFlags)
	imgRain = LoadImage("gfx/rain.png", imgFlags)
	
	MidHandleImage imgHit
	
	MidHandleImage imgLaser
	MidHandleImage imgPump
	MidHandleImage imgFire
	
	MidHandleImage imgEx1
	
End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETFUNCINPUT - Handles function key input                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetFuncInput()
		
	If KeyHit(KEY_F1) Then ' // Save snapshot
		SaveScreen

	ElseIf KeyHit(KEY_F2) Then ' // Image filter
		If cfgFilter = True Then cfgFilter = False Else cfgFilter = True
		LoadImages(cfgFilter)
	
	ElseIf KeyHit(KEY_F3) Then ' // CRT mode
		If cfgCRT < 4 Then cfgCRT = cfgCRT + 1 Else cfgCRT = 0
		
	ElseIf KeyHit(KEY_F4) Then ' // Debug
		If bDebug = True Then bDebug = False Else bDebug = True
	
	EndIf
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² RENDEROVERLAY - Draws overlaying game graphics                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RenderOverlay()

	' // CRT Filter
	If cfgCRT > 0 Then
		If cfgCRT = 1 Then SetAlpha .25 ElseIf cfgCRT = 2 Then SetAlpha .5 ElseIf cfgCRT = 3 Then SetAlpha .75 ElseIf cfgCRT = 4 Then SetAlpha 1
		SetScale .368, .373; SetColor 255, 255, 255; SetBlend ALPHABLEND
		DrawImage imgCRT, 0, 0
		SetAlpha 1; SetScale sclX, sclY
	EndIf
	
	If bWindowed = False Then ' // Fullscreen border
		SetOrigin 0, 0	
		SetScale 1, 1; SetColor 0, 0, 0
		DrawRect 0, 0, 640, 16; DrawRect 0, 0, 26, 480
		DrawRect 640 - 26, 0, 26, 480; DrawRect 0, 480 - 16, 640, 16
		SetColor 255, 255, 255
		SetOrigin 26, 16; SetScale sclX, sclY
	EndIf

End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² RENDERSTATUS - Draws bottom status panel                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RenderStatus()

	SetColor 255, 255, 255
	' // Status bar
	DrawImage imgStatus[curPlayer-1], 0, 368
	Local tmpScore:Int
	If curPlayer = 1 Then tmpScore = pScore ElseIf curPlayer = 2 Then tmpScore = p2Score
	DrawFont String(tmpScore), 55, 382
	Local tmpX:Int = 405
	' // Empty life
	Local tmpE:Int = 3
	If cfgDiff = 0 Then tmpE = 5
	For Local i:Int = 1 To tmpE
		DrawImage imgLife, Int(tmpX), 420, 0
		tmpX = tmpX + 18
	Next
	tmpX = 405
	' // Current life
	For Local i:Int = 1 To pLife
		DrawImage imgLife, Int(tmpX), 420, 1
		tmpX = tmpX + 18
	Next
	
	Local tmpTransform:Int = bTransform
	If b2Player = True Then
		If curPlayer = 1 Then tmpTransform = bTransform ElseIf curPlayer = 2 Then tmpTransform = b2Transform
	EndIf
			
	' // Level desc
	SetColor 255, 255, 255
	If tmpTransform = 0 Then
		If curLevel[curPlayer-1] = 1 Then
			DrawFont "Hell", -1, 382
		ElseIf curLevel[curPlayer-1] = 2 Then
			DrawFont "Frozen Caverns", -1, 382
		ElseIf curLevel[curPlayer-1] = 3 Then
			DrawFont "Nightmare Land", -1, 382
		EndIf
	Else
		DrawFont "Mushroom Forest", -1, 382
	EndIf
	' // Lives
	Local tmpLives:String
	If curPlayer = 1 Then tmpLives = pLives ElseIf curPlayer = 2 Then tmpLives = p2Lives
	DrawFont String(tmpLives), 116, 414
	
	' // Timer
	SetColor 252, 116, 96
	Local tmpS:String, tmpP:String
	DrawFont String(timeMin) + ":", 466, 382
	If timeSec = 0 Then tmpS$ = "0" Else tmpS$ = ""
	If timeSec > 0 And timeSec < 10 Then tmpP$ = "0" Else tmpP$ = ""
	DrawFont tmpP$ + String(timeSec) + tmpS$, 499, 382
	SetColor 255, 255, 255

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWDEBUG - Show debug information                                       
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawDebug()

	' // DEBUG INFO
	SetScale 1, 1; SetColor 255, 255, 255
	DrawText "ScrollX: " + Left$(String(scrollX), 7) + " / pX: " + Int(pX) + " / pY: " + Int(pY), 16, 16
	DrawText "Jump: " + pJ + " / Fall: " + pFall + " / Hurt: " + pHurt + " / Dead: " + pDeath + " / Plat: " + bPlat, 16, 32
	DrawText "FPS: " + FPS + " / Objs: " + objC + " / Parts: " + partC + " / Mem: " + String(GCMemAlloced() / 1024) + " kb", 16, 48

	Rem
	DrawText "X: " + Int(p_X[0]) + ", Y: " + Int(p_Y[0]) + " | D: " + String(p_D[0]) + ", I: " + Left$(String(p_I[0]), 5) + ", Skid: " + p_Skid[0] + ", F: " + String(p_F[0]), 16, 16 
	DrawText "Flap: " + p_Flap[0] + ", Fall: " + p_Fall[0] + ", YI: " + Left$(String(p_YI[0]), 5) + ", EnemyC: " + en_C + ", Wave: " + waveC, 16, 32
	
	' // Collision rects
	SetColor 255, 0, 0; SetScale sclX, sclY
	
	Local tmpSX:Int, tmpSW:Int		
	If p_Skid[0] = True And (p_X[0] > 0 And p_X[0] < 588 - Int(16 * sclX)) Then
		tmpSW = 5
		If p_I[0] > 0 Then ' // Right skid
			tmpSX = 9
		Else ' // Left skid
			tmpSX = 2
		EndIf
	Else
		tmpSX = 3; tmpSW = 10
	EndIf
	DrawRect Int(p_X[0] + (tmpSX * sclX)), Int(p_Y[0] + (24 * sclY)), tmpSW, 1 ' // Feet / skid
	
	SetColor 255, 255, 0
	DrawRect Int(p_X[0] + (2 * sclX)), Int(p_Y[0] + (16 * sclY)), 12, 1
	SetColor 255, 0, 0
	'DrawRect Int(p1_X + (3 * sclX)), Int(p1_Y + (24 * sclY)), 10, 1
	
	DrawRect Int(p_X[0] + (3 * sclX)), Int(p_Y[0] - (1 * sclY)), 10, 1 ' // Head

	DrawRect Int(p_X[0]), Int(p_Y[0]), 1, 18 ' // Left
	DrawRect Int(p_X[0] + (15 * sclX)), Int(p_Y[0]), 1, 18 ' // Right
	EndRem
	
	SetColor 255, 255, 255; SetScale sclX, sclY
	
End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CREATEPLATS - Creates level platforms                               
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function CreatePlats(lvl:Int)

	If lvl = 1 Then ' // Level 1

		o:Obj = New Obj
		o.ID = OBJ_CANDY; o.X = 1725 + (0 * (16 * sclX)); o.Y = 304 - (9 * 32); o.F = Rand(0, 5)	
		objList.AddLast o	
			
		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 2760 + (2 * (16 * sclX)); o.Y = 304 - (4 * 32); o.F = Rand(0, 1)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_CANDY; o.X = 2760 + (5 * (16 * sclX)); o.Y = 304 - (9 * 32); o.F = Rand(0, 5)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_CANDY; o.X = 2760 + (11 * (16 * sclX)); o.Y = 304 - (8 * 32); o.F = Rand(0, 5)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_CANDY; o.X = 2760 + (28 * (16 * sclX)); o.Y = 304 - (6 * 32); o.F = Rand(0, 5)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 2760 + (8 * (16 * sclX)); o.Y = 304 - (2 * 32); o.F = Rand(0, 1)
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 2760 + (14 * (16 * sclX)); o.Y = 304 - (3 * 32); o.F = Rand(0, 1)
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 2760 + (20 * (16 * sclX)); o.Y = 304 - (5 * 32); o.F = Rand(0, 1)
		o.A = 1; o.R = 304 - (8 * 32); o.V = 304 - (3 * 32); o.D = 0
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 2760 + (27 * (16 * sclX)); o.Y = 304 - (2 * 32); o.F = Rand(0, 1)
		o.A = 2; o.R = 2760 + (30 * (16 * sclX)); o.V = 2760 + (26 * (16 * sclX)); o.D = 1
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 5060 + (1 * (16 * sclX)); o.Y = 304 - (2 * 32); o.F = Rand(0, 1)
		o.A = 2; o.R = 5060 + (6 * (16 * sclX)); o.V = 5060 + (1 * (16 * sclX)); o.D = 1
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 5060 + (14 * (16 * sclX)); o.Y = 304 - (2 * 32); o.F = Rand(0, 1)
		o.A = 2; o.R = 5060 + (14 * (16 * sclX)); o.V = 5060 + (9 * (16 * sclX)); o.D = 1
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_CANDY; o.X = 5060 + (3 * (16 * sclX)); o.Y = 304 - (6 * 32); o.F = Rand(0, 5)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_CANDY; o.X = 5060 + (12 * (16 * sclX)); o.Y = 304 - (6 * 32); o.F = Rand(0, 5)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_CANDY; o.X = 6329 + (0 * (16 * sclX)); o.Y = 304 - (9 * 32); o.F = Rand(0, 5)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 6900 + (2 * (16 * sclX)); o.Y = 304 - (3 * 32); o.F = Rand(0, 1)
		o.A = 1; o.R = 304 - (6 * 32); o.V = 304 - (3 * 32); o.D = 0
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 6900 + (13 * (16 * sclX)); o.Y = 304 - (6 * 32); o.F = Rand(0, 1)
		o.A = 1; o.R = 304 - (6 * 32); o.V = 304 - (3 * 32); o.D = 1
		objList.AddLast o

		' // Pickup
		o:Obj = New Obj
		o.ID = OBJ_HEALTH; o.X = 4554; o.Y = 304 - (4 * 32); o.F = 0
		objList.AddLast o

		' // Animal
		o:Obj = New Obj
		o.ID = OBJ_ANIMAL; o.X = 478; o.Y = 304 - 66; o.F = 0
		objList.AddLast o
				
	ElseIf lvl = 2 Then

		Local tmpR:Int
		Local tmpLavaX:Int = 1178
				
		' // Tree eggs
		o:Obj = New Obj
		o.ID = OBJ_EGG; o.X = 3928 + (-18 * (16 * sclX)); o.Y = 302 - (6 * 32); o.F = 0; o.A = 0; o.R = Rand(1, 3)
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_EGG; o.X = 3931 + (30 * (16 * sclX)); o.Y = 302 - (6 * 32); o.F = 0; o.A = 0; o.R = Rand(1, 3)
		objList.AddLast o	

		
		' // Random egg field
		For Local i:Int = 1 To 60 Step 7
			o:Obj = New Obj
			tmpR = Rand(-2, 2)
			o.ID = OBJ_EGG; o.X = 3100 + ((i + tmpR) * (16 * sclX)); o.Y = 304 - (1 * 32); o.F = 0; o.A = 0; o.R = Rand(1, 3)
			If i = 57 Then o.R = 3; o.L = 1 ' // Secret egg
			objList.AddLast o	
		Next
		
		' // Platforms
		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (1 * (16 * sclX)); o.Y = 304 - (2 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (3 * (16 * sclX)); o.Y = 304 - (2 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (7 * (16 * sclX)); o.Y = 304 - (2 * 32)
		o.A = 2; o.R = tmpLavaX + (10 * (16 * sclX)); o.V = tmpLavaX + (7 * (16 * sclX)); o.D = 1
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (14 * (16 * sclX)); o.Y = 304 - (1 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (18 * (16 * sclX)); o.Y = 304 - (2 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (22 * (16 * sclX)); o.Y = 304 - (4 * 32)
		o.A = 1; o.R = 304 - (7 * 32); o.V = 304 - (3 * 32); o.D = 1
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (28 * (16 * sclX)); o.Y = 304 - (1 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (32 * (16 * sclX)); o.Y = 304 - (1 * 32)	
		objList.AddLast o	
		
		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (34 * (16 * sclX)); o.Y = 304 - (1 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (36 * (16 * sclX)); o.Y = 304 - (1 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = tmpLavaX + (38 * (16 * sclX)); o.Y = 304 - (1 * 32)	
		objList.AddLast o	

		'o:Obj = New Obj
		'o.ID = OBJ_PLAT; o.X = 6900 + (-1 * (16 * sclX)); o.Y = 304 - (1 * 32)	
		'objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 6900 + (0 * (16 * sclX)); o.Y = 304 - (1 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 6900 + (4 * (16 * sclX)); o.Y = 304 - (2 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 6900 + (7 * (16 * sclX)) + 5; o.Y = 304 - (2 * 32)	
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 6900 + (10 * (16 * sclX)) + 10; o.Y = 304 - (2 * 32)	
		objList.AddLast o	

		' // Flame jets
		o:Obj = New Obj
		o.ID = OBJ_FLAME; o.X = tmpLavaX + (2 * (16 * sclX)); o.Y = 308 - 112; o.T = GetMilliSecs() + 500; o.D = 0
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_FLAME; o.X = tmpLavaX + (6 * (16 * sclX)); o.Y = 308 - 112; o.T = GetMilliSecs(); o.D = 0
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_FLAME; o.X = tmpLavaX + (12 * (16 * sclX)); o.Y = 308 - 112; o.T = GetMilliSecs(); o.D = 0
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_FLAME; o.X = tmpLavaX + (16 * (16 * sclX)); o.Y = 308 - 112; o.T = GetMilliSecs() + 500; o.D = 0
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_FLAME; o.X = tmpLavaX + (20 * (16 * sclX)); o.Y = 308 - 112; o.T = GetMilliSecs(); o.D = 0
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_FLAME; o.X = tmpLavaX + (25 * (16 * sclX)); o.Y = 308 - 112; o.T = GetMilliSecs() + 500; o.D = 0
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_FLAME; o.X = tmpLavaX + (33 * (16 * sclX)); o.Y = 308 - 112; o.T = GetMilliSecs(); o.D = 0
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_FLAME; o.X = tmpLavaX + (35 * (16 * sclX)); o.Y = 308 - 112; o.T = GetMilliSecs() + 333; o.D = 0
		objList.AddLast o	

		o:Obj = New Obj
		o.ID = OBJ_FLAME; o.X = tmpLavaX + (37 * (16 * sclX)); o.Y = 308 - 112; o.T = GetMilliSecs() + 666; o.D = 0
		objList.AddLast o	

		'o:Obj = New Obj
		'o.ID = OBJ_FLAME; o.X = tmpLavaX + (39 * (16 * sclX)); o.Y = 304 - 112; o.T = GetMilliSecs() + 750; o.D = 0
		'objList.AddLast o	

		Rem

		; // Pickup
		o.Obj = New Obj
		o\ID = 9: o\X =  3416 + (6 * 32): o\Y = 304 - (9 * 32): o\F = 1

		EndRem
		
		' // Tree plats
		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 3928 + (-12 * (16 * sclX)); o.Y = 304 - (2 * 32)
		o.A = 1; o.R = 304 - (4 * 32); o.V = 304 - (2 * 32); o.D = 1
		objList.AddLast o
		
		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 3928 + (0 * (16 * sclX)); o.Y = 304 - (7 * 32)
		o.A = 2; o.R = 3928 + (5 * (16 * sclX)); o.V = 3928 + (-7 * (16 * sclX)); o.D = 1
		o.C2 = 1
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 3928 + (24 * (16 * sclX)); o.Y = 304 - (2 * 32)
		o.A = 1; o.R = 304 - (4 * 32); o.V = 304 - (2 * 32); o.D = 1
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 3928 + (12 * (16 * sclX)); o.Y = 304 - (7 * 32)
		o.A = 2; o.R = 3928 + (19 * (16 * sclX)); o.V = 3928 + (7 * (16 * sclX)); o.D = 0
		o.C2 = 1
		objList.AddLast o
			
		Rem
		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 3928 + (0 * (16 * sclX)); o.Y = 304 - (2 * 32)
		o.A = 1; o.R = 304 - (4 * 32); o.V = 304 - (2 * 32); o.D = 1
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 3928 + (4 * (16 * sclX)); o.Y = 304 - (7 * 32)
		o.A = 1; o.R = 304 - (7 * 32); o.V = 304 - (5 * 32); o.D = 0
		objList.AddLast o
		
		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 3928 + (12 * (16 * sclX)); o.Y = 304 - (2 * 32)
		o.A = 1; o.R = 304 - (4 * 32); o.V = 304 - (2 * 32); o.D = 1
		objList.AddLast o

		o:Obj = New Obj
		o.ID = OBJ_PLAT; o.X = 3928 + (8 * (16 * sclX)); o.Y = 304 - (7 * 32)
		o.A = 1; o.R = 304 - (7 * 32); o.V = 304 - (5 * 32); o.D = 0
		objList.AddLast o
		
		EndRem
		Rem

		o.Obj = New Obj
		o\ID = 8: o\X =  3416 + (0 * 32): o\Y = 304 - (2 * 32)
		o\A = 1: o\R = 304 - (4 * 32): o\V = 304 - (2 * 32): o\D = 1

		o.Obj = New Obj
		o\ID = 8: o\X =  3416 + (4 * 32): o\Y = 304 - (7 * 32)
		o\A = 1: o\R = 304 - (7 * 32): o\V = 304 - (5 * 32): o\D = 0

		o.Obj = New Obj
		o\ID = 8: o\X =  3416 + (12 * 32): o\Y = 304 - (2 * 32)
		o\A = 1: o\R = 304 - (4 * 32): o\V = 304 - (2 * 32): o\D = 1

		o.Obj = New Obj
		o\ID = 8: o\X =  3416 + (8 * 32): o\Y = 304 - (7 * 32)
		o\A = 1: o\R = 304 - (7 * 32): o\V = 304 - (5 * 32): o\D = 0

		EndRem		
				
		' // Pickup
		o:Obj = New Obj
		o.ID = OBJ_HEALTH; o.X = 3928 + (6 * (16 * sclX)); o.Y = 304 - (9 * 32); o.F = 1
		objList.AddLast o

		' // Animal
		o:Obj = New Obj
		o.ID = OBJ_ANIMAL; o.X = 478; o.Y = 306 - 66; o.F = 0; o.D = 1
		objList.AddLast o

		' // MARK
		o:Obj = New Obj
		o.ID = OBJ_ANIMAL; o.X = 900; o.Y = 304 - 46; o.F = 0; o.D = 3
		objList.AddLast o

	ElseIf lvl = 3 Then

		' // Animal
		o:Obj = New Obj
		o.ID = OBJ_ANIMAL; o.X = 478; o.Y = 304 - 64; o.F = 0; o.D = 2
		objList.AddLast o		
		
	EndIf
	
End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NOLASER - Checks for laser particles                                 
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NoLaser:Int(myLim:Int = 2)
	Local bLaser:Int = True
	
	Local tmpC:Int = 0 
	For p:Part = EachIn partList
		If p.ID = PART_LASER Then tmpC:+1
	Next 

	If tmpC <> 0 Then
		If bHard[curPlayer-1] = True Then
			If tmpC >= myLim + 1 Then bLaser = False
		Else
			If cfgDiff = 0 Then ' // Difficulty switch
				If (tmpC >= myLim - 1) Then bLaser = False
			ElseIf cfgDiff = 1 Then
				If tmpC >= myLim Then bLaser = False
			EndIf
		EndIf
	EndIf
	
	Return bLaser
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NOSHOT - Checks for lizard/wand shots                                
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NoShot:Int(myType:Int = 0)
	
	For p:Part = EachIn partList
		If myType = 0 Then ' // Lizard shot
			If p.ID = PART_SHOT Then Return False
		ElseIf myType = 1 Then ' // Wand shot
			If p.ID = PART_WAND Then Return False
		EndIf
		
	Next 
	
	Return True
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CREATEPARTS - Creates particles                                 
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function CreateParts(X:Int, Y:Int, F:Int)
	
	If F = 2 Then ' // Pumpkin explode

		For Local i:Int = 1 To 15
			p:Part = New Part
			p.X = X + Rand(0, 55) ; p.Y = Y + Rand(0, 94); p.ID = PART_EXPLODE
			p.F = 1; p.Alp = 1; p.T = GetMilliSecs()
			p.V = i * 90 ' // Time
			partList.AddLast p
			
		Next
	
	ElseIf F = 3 Then ' // Serpent explode

		For Local i:Int = 1 To 15
			p:Part = New Part
			p.X = X + Rand(0, 74) ; p.Y = Y + Rand(0, 112); p.ID = PART_EXPLODE
			p.F = 1; p.Alp = 1; p.T = GetMilliSecs()
			p.V = i * 90 ' // Time
			partList.AddLast p
			
		Next
	
	ElseIf F = 4 Then ' // Death explode

		For Local i:Int = 1 To 30
			p:Part = New Part
			p.X = X + Rand(0, 130) ; p.Y = Y + Rand(0, 220); p.ID = PART_EXPLODE
			p.F = 1; p.Alp = 1; p.T = GetMilliSecs()
			p.V = i * 90 ' // Time
			partList.AddLast p
			
		Next
	
	EndIf

End Function

	
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CREATEDROPS - Creates title screen drops                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function CreateDrops(scr:Int = 0)

	Local bFound:Int
	Local i:Int
	Local tmpX:Int, tmpY:Int

	Repeat
		i = Rand(0, 2) ' // Side
		
		If i = 0 Then ' // Left side
			
			If scr = 0 Then ' // Title
				i = Rand(1, 5)
				If i = 1 Then
					tmpX = 41; tmpY = 286
				ElseIf i = 2 Then
					tmpX = 60; tmpY = 158
				ElseIf i = 3 Then
					tmpX = 78; tmpY = 254
				ElseIf i = 4 Then
					tmpX = 97; tmpY = 302
				ElseIf i = 5 Then
					tmpX = 115; tmpY = 238
				EndIf
			ElseIf scr = 1 Then ' // Game over
				i = Rand(1, 6)
				If i = 1 Then
					tmpX = 7; tmpY = 286
				ElseIf i = 2 Then
					tmpX = 25; tmpY = 318
				ElseIf i = 3 Then
					tmpX = 44; tmpY = 222
				ElseIf i = 4 Then
					tmpX = 63; tmpY = 254
				ElseIf i = 5 Then
					tmpX = 81; tmpY = 302
				ElseIf i = 6 Then
					tmpX = 99; tmpY = 238
				EndIf
				tmpX:-3
			EndIf
			
		ElseIf i = 1 Then ' // Middle
		
			i = Rand(1, 2)
			If i = 1 Then
				tmpX = (Rand(0, 8) * 37) + 136; tmpY = 110
			ElseIf i = 2 Then
				tmpX = (Rand(0, 8) * 37) + 153; tmpY = 112		
			EndIf
			
		ElseIf i = 2 Then ' // Right side
			If scr = 0 Then ' // Title
				i = Rand(1, 5)
				If i = 1 Then
					tmpX = 467; tmpY = 270
				ElseIf i = 2 Then
					tmpX = 485; tmpY = 222
				ElseIf i = 3 Then
					tmpX = 503; tmpY = 302
				ElseIf i = 4 Then
					tmpX = 522; tmpY = 238
				ElseIf i = 5 Then
					tmpX = 540; tmpY = 270
				EndIf
			ElseIf scr = 1 Then ' // Game over
				i = Rand(1, 6)
				If i = 1 Then
					tmpX = 486; tmpY = 318
				ElseIf i = 2 Then
					tmpX = 504; tmpY = 286
				ElseIf i = 3 Then
					tmpX = 522; tmpY = 238
				ElseIf i = 4 Then
					tmpX = 540; tmpY = 270
				ElseIf i = 5 Then
					tmpX = 558; tmpY = 334
				ElseIf i = 6 Then
					tmpX = 578; tmpY = 222
				EndIf
				tmpX:-3		
			EndIf
			
		EndIf

		bFound = False
		For o:Obj = EachIn objList
			If o.ID = OBJ_DROP And o.X = tmpX Then bFound = True; Exit
		Next 

	Until bFound = False
	
	objList.AddLast obj.Create(tmpX, tmpY, OBJ_DROP)
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYSFX - Plays a sound at desired volume                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlaySFX:TChannel(mySound:TSound)
	Local tmpChan:TChannel = AllocChannel()
	
	If cfgSFX <> 0 Then
		tmpChan = PlaySound(mySound)
		tmpChan.SetVolume(Float(cfgSFX) / 10)
	EndIf
	
	Return tmpChan
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETMILLISECS - MilliSecs rollover fix                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetMilliSecs:Int()

	If LastMilliSecs = 0 Then LastMilliSecs = MilliSecs() 
	
	If MilliSecs() > LastMilliSecs Then MyMilliSecs = MyMilliSecs + (MilliSecs() - LastMilliSecs)
	If MilliSecs() < LastMilliSecs Then MyMilliSecs = MyMilliSecs + (LastMilliSecs - MilliSecs())

	LastMilliSecs = MilliSecs()
	Return MyMilliSecs - pauseTotal ' // Time offset fix
    
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWFONT - Draws bitmap font                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawFont(myStr:String, X:Int, Y:Int, bSmall:Int = 0)

	Local i:Int
	If X = -1 Then ' // Center text
		Local tmpW:Int
		X = 294
		For i = 1 To Len(myStr$)
			tmpW:+(8 * sclX)
		Next
		X:-Int(tmpW / 2)
	EndIf
	
	Local tmpX:Int = X, tmpY:Int = Y, tmpA:Int, tmpF:Int
	For i = 1 To Len(myStr)
		tmpA = Asc(Upper$(Mid$(myStr$, i, 1)))
		
		If tmpA >= 48 And tmpA <= 57 Then ' // Numbers
			tmpF = tmpA - 47
		ElseIf tmpA >= 65 And tmpA <= 90 Then ' // Letters
			tmpF = tmpA - 54
		ElseIf tmpA = 32 Then ' // Space
			tmpF = 0
		ElseIf tmpA = 46 Then ' // Period
			tmpF = 39
		ElseIf tmpA = 42 Then ' // Asterisk
			tmpF = 47
		ElseIf tmpA = 37 Then ' // Percent
			tmpF = 51
		ElseIf tmpA = 62 Then ' // Player 1
			SetColor 255, 255, 255
			tmpF = 43
		ElseIf tmpA = 61 Then ' // Equals
			tmpF = 42
		ElseIf tmpA = 94 Then ' // Player 2
			SetColor 255, 255, 255
			tmpF = 44
		ElseIf tmpA = 41 Then ' // )
			tmpF = 50
		ElseIf tmpA = 44 Then ' // Comma
			tmpF = 40
		ElseIf tmpA = 45 Then ' // Hyphen
			tmpF = 38
		ElseIf tmpA = 33 Then ' // Exclamation
			tmpF = 45
		ElseIf tmpA = 58 Then ' // Colon
			tmpF = 41
		ElseIf tmpA = 35 Then ' // Hash
			tmpF = 47
		ElseIf tmpA = 36 Then ' // $ Up arrow
			tmpF = 53
		ElseIf tmpA = 43 Then ' // + Down arrow
			tmpF = 52
		ElseIf tmpA = 38 Then ' // & Wave star
			tmpF = 54
		ElseIf tmpA = 63 Then ' // ? 
			tmpF = 46
		EndIf
		
		DrawImage imgFont, Int(tmpX), Int(tmpY), tmpF
		If bSmall = True Then ' // Small font
			tmpX:+(6 * sclX) 
		Else ' // Big font
			tmpX:+(8 * sclX)
		EndIf
		
		If tmpA = 94 Then SetColor 0, 232, 216 ' // 2 player score color reset

	Next
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADINPUT - Reads in input CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadInput()

	Local File:TStream = ReadFile("input.cfg")
	
	For Local j:Int = 0 To 1
		For Local i:Int = 0 To 6
			inKey[j, i] = ReadLine(File)

			If j = 0 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J1" Then p1Joy = 1
			ElseIf j = 1 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J0" Then p2Joy = 0
			EndIf
			
		Next
	Next
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETINPUT - Converts inkeys to inputs                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetInput:Int(j:Int, i:Int, d:Int = 0)

	Local tmpRet:Int = False
	Local tmp:String = inKey[j, i]
	
	If Left$(tmp$, 1) = "K" Then ' // Keyboard
		tmp$ = Replace$(tmp$, "K", "")
		If d = 0 Then ' // KeyHit
			If KeyHit(Int(tmp$)) = True Then tmpRet = True		
		ElseIf d = 1 Then ' // KeyDown
			If KeyDown(Int(tmp$)) = True Then tmpRet = True
		EndIf
	ElseIf Left$(tmp$, 2) = "J0" Then ' // Joy 1
		If tmp$ = "J0U" Then ' // Up
			If JoyY(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0D" Then ' // Down
			If JoyY(0) = 1 Then tmpRet = True
		ElseIf tmp$ = "J0L" Then ' // Left
			If JoyX(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0R" Then ' // Right
			If JoyX(0) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J0", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 0) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 0) = True Then tmpRet = True
			EndIf
		EndIf
		
	ElseIf Left$(tmp$, 2) = "J1" Then ' // Joy 2
		If tmp$ = "J1U" Then ' // Up
			If JoyY(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1D" Then ' // Down
			If JoyY(1) = 1 Then tmpRet = True
		ElseIf tmp$ = "J1L" Then ' // Left
			If JoyX(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1R" Then ' // Right
			If JoyX(1) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J1", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 1) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 1) = True Then tmpRet = True
			EndIf
		EndIf
		
	EndIf
	
	Return tmpRet
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADCFG - Reads in CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadCFG()

	Local File:TStream = ReadFile("nemox.cfg")
	cfgSFX = ReadInt(File)
	cfgMusic = ReadInt(File)
	cfgFilter = ReadInt(File)
	cfgCRT = ReadInt(File)
	cfgFull = ReadInt(File)
	cfgDiff = ReadInt(File)
	
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVECFG - Writes CFG file                                 
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveCFG()

	Local File:TStream = WriteFile("nemox.cfg")
	WriteInt File, cfgSFX
	WriteInt File, cfgMusic
	WriteInt File, cfgFilter
	WriteInt File, cfgCRT
	WriteInt File, cfgFull
	WriteInt File, cfgDiff
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ENDGAME - Ends program                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function EndGame()
	SaveCFG()
	End
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVESCREEN - Saves a PNG snapshot                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveScreen()
	Local tmpFN:Int = 0, Dir:Byte Ptr = ReadDir("snaps/"), file$
	Local tmpP:Int, tmpU:Int, tmpN:Int

	Repeat 
		file$ = NextFile(Dir)
		If FileType("snaps/" + file$) = 1 Then
			tmpP = Instr(file$, ".", 1)
			tmpU = Instr(file$, "_", 1)
			tmpN = Int(Mid(file$, tmpU + 1, tmpP - tmpU))
			If tmpN > tmpFN Then tmpFN = tmpN ' // New filenumber
		EndIf
	Until file$ = ""
	CloseDir Dir

	Local tmpX:Int, tmpY:Int
	If bWindowed = False Then tmpX = 26; tmpY = 16 Else tmpX = 0; tmpY = 0

	SetMaskColor 255, 0, 255
	Local imgScreen:TPixmap = GrabPixmap(tmpX, tmpY, 588, 448)
	SavePixmapPNG(imgScreen, "snaps/snap_" + (tmpFN + 1) + ".png", 9)
	
	imgScreen = Null
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² UPLOADSCORE - Uploads score via SFTP                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function UploadScore(myScore:String)
	
	' ///////////////////////////////////////////
	' // CODE REMOVED TO KEEP SCORES SECURE
	' ///////////////////////////////////////////
	FlushInput
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² QuickSort - Sorts online hi scores                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function QuickSort(arr:String[], first:Int, last:Int)

	Local pivot:Int = 0
	Local temp:String
	Local i:Int = 0
	Local j:Int = 0

	If first < last Then
		pivot = first
		i = first
		j = last

		While (i < j)			
			While (Int(Left$(arr[i], Len(arr[i]) - 7)) >= Int(Left$(arr[pivot], Len(arr[pivot]) - 7)) And i < last)
				i = i + 1
			End While

			While (Int(Left$(arr[j], Len(arr[j]) - 7)) < Int(Left$(arr[pivot], Len(arr[pivot]) - 7)))
				j = j - 1
			End While

			If i < j Then
				temp = arr[i]
				arr[i] = arr[j]
				arr[j] = temp
			End If
		End While

		temp = arr[pivot]
		arr[pivot] = arr[j]
		arr[j] = temp
		QuickSort(arr, first, j - 1)
		QuickSort(arr, j + 1, last)
	End If

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NumFormat - Draws numbers with comma placement                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NumFormat:String(myStr$)

	If Len(myStr$) = 4 Then ' // Thousand
		myStr$ = Left$(myStr$, 1) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 5 Then ' // Ten thousand
		myStr$ = Left$(myStr$, 2) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 6
		myStr$ = Left$(myStr$, 3) + "," + Right$(myStr$, 3)

	EndIf
	
	Return myStr$
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LEGACY FUNCTIONS                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RectsOverlap%(x0:Int, y0:Int, w0:Int, h0:Int, x2:Int, y2:Int, w2:Int, h2:Int)
	If x0 > (x2 + w2) Or (x0 + w0) < x2 Then Return False
	If y0 > (y2 + h2) Or (y0 + h0) < y2 Then Return False
	Return True
End Function

Function TileScaleImage(img:TImage, X:Float, Y:Float, tmpWidth:Int = 256)

	Local tmpW:Int = tmpWidth
	
	If tileX >= 588 Then 
		tileX = tileX - 588
	ElseIf tileX <= -588 Then
		tileX = tileX + 588
	EndIf
	
	For Local tmpX:Int = tileX - (tmpW * 3) To tileX + (tmpW * 4) Step 588
		DrawImage img, -Int(tmpX), Int(Y)
	Next

End Function

Function TileCaveImage(img:TImage, X:Float, Y:Float, F:Int)

	Local tmpW:Int = 883
	Local tmpTX:Int
	tmpTX = caveX1
	 
	If tmpTX >= 883 Then 
		tmpTX = tmpTX - 883
	ElseIf tmpTX <= -883 Then
		tmpTX = tmpTX + 883
	EndIf
	
	For Local tmpX:Int = tmpTX - (tmpW * 5) To tmpTX + (tmpW * 6) Step 883
		DrawImage img, -Int(tmpX), Int(Y), F
	Next

End Function

Function TileCaveImage2(img:TImage, X:Float, Y:Float)

	Local tmpW:Int = 256
	Local tmpTX:Int
	tmpTX = caveX1
	 
	If tmpTX >= 588 Then 
		tmpTX = tmpTX - 588
	ElseIf tmpTX <= -588 Then
		tmpTX = tmpTX + 588
	EndIf
	
	For Local tmpX:Int = tmpTX - (tmpW * 3) To tmpTX + (tmpW * 4) Step 588
		DrawImage img, -Int(tmpX), Int(Y), 0
	Next

End Function

Function ImageRectCollide%(image:TImage, ix%, iy%, iframe%, rx%, ry%, rwidth%, rheight%)

   ResetCollisions
   CollideImage image, ix, iy, iframe, 0, 1
   
   If CollideRect(rx, ry, rwidth, rheight, 1, 0) Then Return True Else Return False

End Function