' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ²
' // ² X  L I B
' // ² Version 1.6
' // ²
' // ² By EikSoft (www.EikSoft.com)
' // ² 7.8.23 Project Start
' // ² 9.1.24 Last Modified
' // ²
' // ² For J.B. - In loving memory of Celeste <3
' // ²
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //

' // INPUT
Global inKey:String[2, 8]

Global INP_U:Int = 0, INP_D:Int = 1, INP_L:Int = 2, INP_R:Int = 3, INP_B:Int = 4, INP_A:Int = 5, INP_X:Int = 6, INP_S:Int = 7 
Global p1Joy:Int = 0, p2Joy:Int = 1
Global bJoyBT:Int[2]

Global PLAYER_1:Int = 0
Global PLAYER_2:Int = 1

' // TIMER AND FPS
Global MyMilliSecs:Int, LastMilliSecs:Int = MilliSecs() ' // MilliSecs FIX
Global FPS:Int, curFrames:Int, frameTimer:Int, fpsTimer:Int = GetMilliSecs() ' // FPS Counter

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYSFX - Plays a sound at desired volume                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlaySFX:TChannel(mySound:TSound, myChan:TChannel = Null)
	
	If cfgSFX <> 0 Then
		If myChan <> Null Then
			myChan.SetVolume(Float(cfgSFX))
			myChan = PlaySound(mySound, myChan)

			Return myChan		
		Else
			Local tmpChan:TChannel = AllocChannel()
			tmpChan.SetVolume(Float(cfgSFX))
			tmpChan = PlaySound(mySound, tmpChan)

			Return tmpChan
		EndIf
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADINPUT - Reads in input CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadInput()

	Local File:TStream = ReadFile("input.cfg")
	
	For Local j:Int = 0 To 1
		For Local i:Int = 0 To 7
			inKey[j, i] = ReadLine(File)

			If j = 0 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J1" Then p1Joy = 1
			ElseIf j = 1 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J0" Then p2Joy = 0
			EndIf
			
		Next
	Next
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² FLUSHINPUT - Flushes joystick and keyboard input
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function FlushInput(flushI:Int = -1)

	If flushI = -1 Then ' // Flush all
		FlushKeys; FlushJoy 0; FlushJoy 1
		If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_A) = True Or GetInput(PLAYER_1, INP_S) = True Or GetInput(PLAYER_1, INP_X) = True Then
		EndIf
		If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_A) = True Or GetInput(PLAYER_2, INP_S) = True Or GetInput(PLAYER_2, INP_X) = True Then
		EndIf
		FlushKeys; FlushJoy 0; FlushJoy 1	
	
	ElseIf flushI = 0 Then ' // Flush player 1
		FlushKeys; FlushJoy 0
		If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_A) = True Or GetInput(PLAYER_1, INP_S) = True Or GetInput(PLAYER_1, INP_X) = True Then
		EndIf
		FlushKeys; FlushJoy 0
	
	ElseIf flushI = 1 Then ' // Flush player 2
		FlushKeys; FlushJoy 1
		If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_A) = True Or GetInput(PLAYER_2, INP_S) = True Or GetInput(PLAYER_2, INP_X) = True Then
		EndIf
		FlushKeys; FlushJoy 1

	EndIf	

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DETECTJOY - Detects wired/vs wireless controllers                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DetectJoy()

	If JoyHat(0) = -1 Then bJoyBT[0] = True
	If JoyHat(1) = -1 Then bJoyBT[1] = True
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETJOYD - Detects joystick dpad input                                 
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetJoyD:Int(num:Int, dir:String)

	Local tmpB:Int = False
	
	If bJoyBT[num] = False Then ' // Wired
		Select dir$
			Case "L"
			If JoyX(num) = -1 Then tmpB = True
			
			Case "R"
			If JoyX(num) = 1 Then tmpB = True
			
			Case "U"
			If JoyY(num) = -1 Then tmpB = True
			
			Case "D"
			If JoyY(num) = 1 Then tmpB = True
			
		End Select
		
	Else ' // Wireless
		Select dir$
			Case "L"
			If JoyHat(num) = .75 Or JoyHat(num) = .875 Or JoyHat(num) = .625 Then tmpB = True
			
			Case "R"
			If JoyHat(num) = .25 Or JoyHat(num) = .375 Or JoyHat(num) = .125 Then tmpB = True
			
			Case "U"
			If JoyHat(num) = 0 Or JoyHat(num) = .875 Or JoyHat(num) = .125 Then tmpB = True
			
			Case "D"
			If JoyHat(num) = .5 Or JoyHat(num) = .625 Or JoyHat(num) = .375 Then tmpB = True
			
		End Select
		
	EndIf
	
	Return tmpB
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETINPUT - Converts inkeys to inputs                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetInput:Int(j:Int, i:Int, d:Int = 0)

	Local tmpRet:Int = False
	Local tmp:String = inKey[j, i]
	
	If Left$(tmp$, 1) = "K" Then ' // Keyboard
		tmp$ = Replace$(tmp$, "K", "")
		If d = 0 Then ' // KeyHit
			If KeyHit(Int(tmp$)) = True Then tmpRet = True		
		ElseIf d = 1 Then ' // KeyDown
			If KeyDown(Int(tmp$)) = True Then tmpRet = True
		EndIf
	ElseIf Left$(tmp$, 2) = "J0" Then ' // Joy 1
		If tmp$ = "J0U" Then ' // Up
			If GetJoyD(0, "U") = True Then tmpRet = True
		ElseIf tmp$ = "J0D" Then ' // Down
			If GetJoyD(0, "D") = True tmpRet = True
		ElseIf tmp$ = "J0L" Then ' // Left
			If GetJoyD(0, "L") = True tmpRet = True
		ElseIf tmp$ = "J0R" Then ' // Right
			If GetJoyD(0, "R") = True Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J0", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 0) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 0) = True Then tmpRet = True
			EndIf
		EndIf
		
	ElseIf Left$(tmp$, 2) = "J1" Then ' // Joy 2
		If tmp$ = "J1U" Then ' // Up
			If GetJoyD(1, "U") = True Then tmpRet = True
		ElseIf tmp$ = "J1D" Then ' // Down
			If GetJoyD(1, "D") = True Then tmpRet = True
		ElseIf tmp$ = "J1L" Then ' // Left
			If GetJoyD(1, "L") = True Then tmpRet = True
		ElseIf tmp$ = "J1R" Then ' // Right
			If GetJoyD(1, "R") Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J1", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 1) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 1) = True Then tmpRet = True
			EndIf
		EndIf
		
	EndIf
	
	Return tmpRet
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVESCREEN - Saves a PNG snapshot                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveScreen()
	Local tmpFN:Int = 0, Dir:Byte Ptr = ReadDir("snaps/"), file$
	Local tmpP:Int, tmpU:Int, tmpN:Int

	Repeat 
		file$ = NextFile(Dir)
		If FileType("snaps/" + file$) = 1 Then
			tmpP = Instr(file$, ".", 1)
			tmpU = Instr(file$, "_", 1)
			tmpN = Int(Mid(file$, tmpU + 1, tmpP - tmpU))
			If tmpN > tmpFN Then tmpFN = tmpN ' // New filenumber
		EndIf
	Until file$ = ""
	CloseDir Dir

	Local tmpX:Int, tmpY:Int
	If bWindowed = False Then tmpX = 32; tmpY = 16 Else tmpX = 0; tmpY = 0

	SetMaskColor 255, 0, 255
	Local imgScreen:TPixmap = GrabPixmap(tmpX, tmpY, 576, 448)
	SavePixmapPNG(imgScreen, "snaps/snap_" + (tmpFN + 1) + ".png", 9)
	
	GCRelease imgScreen
	GCCollect
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NumFormat - Draws numbers with comma placement                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NumFormat:String(myStr$)

	If Len(myStr$) = 4 Then ' // Thousand
		myStr$ = Left$(myStr$, 1) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 5 Then ' // Ten thousand
		myStr$ = Left$(myStr$, 2) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 6 Then ' // One hundred thousand
		myStr$ = Left$(myStr$, 3) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 7 Then ' // One million
		myStr$ = Left$(myStr$, 1) + "," + Mid$(myStr$, 2, 3) + "," + Right$(myStr$, 3)
		
	ElseIf Len(myStr$) = 8 Then ' // Ten million
		myStr$ = Left$(myStr$, 2) + "," + Mid$(myStr$, 3, 3) + "," + Right$(myStr$, 3)
		
	EndIf
	
	Return myStr$
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² RENDEROVERLAY - Draws overlaying game graphics                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawOverlay()

	' // Screen border
	'If sclX = 2.0 Then
	If bWindowed = False Then
		SetOrigin 0, 0	
		SetScale 1, 1; SetColor 0, 0, 0
		DrawRect 0, 0, 640, 16
		DrawRect 0, 0, 32, 480
		DrawRect 640 - 32, 0, 32, 480
		DrawRect 0, 480 - 16, 640, 16
		SetColor 255, 255, 255
		SetOrigin orgX, orgY; SetScale sclX, sclY
	EndIf
	
	Rem	
	ElseIf sclX = 2.3 Then
		If bWIndowed = False Then
			SetOrigin 0, 0
			SetScale 1, 1; SetColor 0, 0, 0
			DrawRect 0, 0, 640, 16; DrawRect 0, 0, 26, 480
			DrawRect 640 - 26, 0, 26, 480; DrawRect 0, 480 - 16, 640, 16
			SetColor 255, 255, 255
			SetOrigin orgX, orgY
		EndIf
		
	EndIf
	EndRem
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETMILLISECS - MilliSecs rollover fix                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetMilliSecs:Int()

	If LastMilliSecs = 0 Then LastMilliSecs = MilliSecs() 
	
	If MilliSecs() > LastMilliSecs Then MyMilliSecs = MyMilliSecs + (MilliSecs() - LastMilliSecs)
	If MilliSecs() < LastMilliSecs Then MyMilliSecs = MyMilliSecs + (LastMilliSecs - MilliSecs())

	LastMilliSecs = MilliSecs()
	Return MyMilliSecs - pauseTotal
    
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LEGACY FUNCTIONS                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RectsOverlap%(x0:Int, y0:Int, w0:Int, h0:Int, x2:Int, y2:Int, w2:Int, h2:Int)

	If x0 > (x2 + Int(w2 * sclX)) Or (x0 + Int(w0 * sclX)) < x2 Then Return False
	If y0 > (y2 + Int(h2 * sclY)) Or (y0 + Int(h0 * sclY)) < y2 Then Return False
	Return True
	
End Function

Function RectsOverlap2%(x0:Int, y0:Int, w0:Int, h0:Int, x2:Int, y2:Int, w2:Int, h2:Int)

	If x0 > (x2 + Int(w2)) Or (x0 + Int(w0)) < x2 Then Return False
	If y0 > (y2 + Int(h2)) Or (y0 + Int(h0)) < y2 Then Return False
	Return True
	
End Function

Function ImageRectCollide%(image:TImage, ix%, iy%, iframe%, rx%, ry%, rwidth%, rheight%)

   ResetCollisions
   CollideImage image, ix, iy, iframe, 0, 1
   
   If CollideRect(rx, ry, rwidth, rheight, 1, 0) Then Return True Else Return False

End Function