' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ²
' // ² J O U S T   X
' // ² Version 1.0
' // ²
' // ² By EikSoft (www.EikSoft.com)
' // ² 7.8.23 Project Start
' // ² 9.5.23 Last Modified
' // ²
' // ² For J.B. - In loving memory of Celeste <3
' // ²
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
SuperStrict

Framework BRL.GLMax2D 

Import BRL.Matrix
Import BRL.Retro
Import BRL.PNGLoader
Import BRL.Random
Import BRL.WAVLoader
Import BRL.OGGLoader
Import SDL.SDLFreeAudio
Import PUB.FreeJoy

SetAudioDriver("FreeAudio SDL")

AppTitle = "Joust X"
SetGraphicsDriver GLMax2DDriver()
SeedRnd MilliSecs()

' // Config
Global cfgSfx:Int 
Global cfgMusic:Int
Global cfgFilter:Int 
Global cfgCRT:Int
Global cfgFull:Int

' // Custom colors
Global p_Col1:Int[] = [-3650548, -3650548]
Global p_Col2:Int[] = [-16717608, -1000388]
Global p_Col3:Int[] = [-1000388, -16717608]

Global o_Col1:Int[2]
Global o_Col2:Int[2]
Global o_Col3:Int[2]

' // Hi Scores
Global hi_Name:String[] = ["Eikon", "Sonata", "JBaily", "Useful", "Charo", "Pibb", "Conrad", "MDE", "Steely", "Bytor"]
Global hi_Score:Int[] = [50000, 45000, 40000, 35000, 30000, 25000, 22500, 20000, 17500, 15000]
Global hi_Img:TImage[10]
Global hi_Col:Int = 0, hi_T:Int, hi_Place:Int
Global hi_Save:Int[2], hi_Entry:String, hi_A:Int
Local hiAxis:TAxis = New TAxis
Global hiAX:Float = 45, hiAY:Float, hiAZ:Float = 0
Global place1:Int, place2:Int

Global bOnline:Int = False
Global net_Score:String[100], netP:Int
Global uploadChan:TChannel = AllocChannel()

' // Input.Cfg
Global inKey:String[2, 7]

Global INP_U:Int = 0, INP_D:Int = 1, INP_L:Int = 2, INP_R:Int = 3, INP_B:Int = 4, INP_A:Int = 5, INP_S:Int = 6
Global p1Joy:Int = 0, p2Joy:Int = 1

LoadCFG()
LoadInput()
LoadScores()

' // Master flags
Global bWindowed:Int ' // Windowed
If cfgFull = 0 Then bWindowed = True Else bWindowed = False
Global bFilter:Int = cfgFilter ' // Bilinear filter
Global bTitle:Int = True ' // Title screen
Global bDebug:Int = False ' // Debug info

Local sfxType$ = "NES" ' // Music type

If bWindowed = True Then 
	Graphics 588, 448, 0, 60
Else
	Graphics 640, 480, 32, 60
EndIf

If bWindowed = False Then HideMouse

' // Loading screen
SetMaskColor 255, 0, 255
imgFont = LoadAnimImage("gfx/font.png", 8, 8, 0, 64, MASKEDIMAGE)
SetScale 2.299, 2.0
DrawFont "Loading", -1, 216
Flip

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DECLARES                                           
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //

' // Tick count and FPS
Global MyMilliSecs:Int, LastMilliSecs:Int = MilliSecs() ' // MilliSecs FIX
Global FPS:Int, curFrames:Int, frameTimer:Int, fpsTimer:Int = GetMilliSecs() ' // FPS Counter

' // FULL PC IS 2.5 / 2.15
' // FULL CRT IS 2.3 / 2.0
Global sclX:Float = 2.299, sclY:Float = 2.0
Global crtMode:Int = cfgCRT

' // Joystick
Global bJoy1YHit:Int = False, bJoy1XHit:Int = False
Global bJoy2YHit:Int = False, bJoy2XHit:Int = False

' // Title
Global tSel:Int = 0, tScreen:Int = 0, tCol:Int = 0, tPlayer:Int = PLAYER_1
Global tselX:Int, tselY:Int, curCol:Int = 0 ' // Custom color selection
Global champF:Int, champT:Int
Global bLoopBack:Int
Global secretC:String = "", bSecret:Int = False

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYER DECLARES                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //

Global p_X:Float[] = [80 * sclX, 160 * sclX] ' // X Position
Global p_Y:Float[] = [165 * sclY, 165 * sclY] ' // Y Position 
Global p_F:Int[2], p_D:Int[2], p_I:Float[2] ' // Frame, direction, intertia
Global p_T:Int[] = [GetMilliSecs(), GetMilliSecs()] ' // Timer
Global p_Step:Int[2], p_Skid:Int[2], p_YI:Float[2], p_Flap:Int[2], p_Fall:Int[2]
Global p_flapT:Int[2], p_Score:Int[2], p_Lives:Int[] = [5, 5]
Global p_Ghost:Int[2], p_GT:Int[2], p_GC:Int[2] ' // Ghosting
Global p_eggC:Int[2], p_airC:Int[2], p_Respawn:Int[2], p_RespawnT:Int[2], p_RespawnR:Int[2]
Global p_GameOver:Int[2]
Global p_Lastflap:Int[2]

Global p_flapC:Int[2] ' // Deprecate?
'Global p1_lastYI:Float[1] ' // Deprecates

' // Player sound channels
Global p_SkidChan:TChannel[] = [AllocChannel(), AllocChannel()]
Global p_StepChan:TChannel[] = [AllocChannel(), AllocChannel()]
Global p_SpawnChan:TChannel[] = [AllocChannel(), AllocChannel()]

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GAME LEVEL DECLARES                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //

' // Game level
Global bPaused:Int = False, pauseStart:Int, pauseTotal:Int
Global bSpawn:Int = False
Global b2Player:Int = False

' // Enemies
Global en_C:Int = 0, en_T:Int = GetMilliSecs(), en_TC:Int = 3
Global en_CT:Int
Global en_Count:Int = 0
Global pter_T:Int, bPter:Int = False
Global bEnemies:Int
Global enList:Int[100] ' // Enemy spawn list per wave

' // Lava / waterfalls
Global lavaY:Int = Int(217 * sclY), lavaD:Int = 0, lavaT:Int = GetMilliSecs(), lavaC:Int
Global waterT:Int, waterF:Int

' // Sparks
Global sparkT:Int
Global lastIce:Int = -1

' // STARS
Const MAX_STARS:Int = 300
Global stars:Star[MAX_STARS]
Global star_Speed:Float = 1.25

Global starImage:TImage = drawStarImage(1) ' // For particles
Global starImage2:TImage = drawStarImage(1) 
MidHandleImage starImage

For Local i:Int = 0 To MAX_STARS - 1
	stars[i] = Star.Create(starImage)
Next
					
' // Screen shake
Global shakeT:Int, shakeN:Int = -1, shakeD:Int

' // Waves
Global waveC:Int = 1, waveT:Int
Global tranC:Int = 0, tranT:Int
Global levelF:Int = 0
Global levelA1:Float, levelA2:Float
Global levStar:Int = 0

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² IMAGES                                           
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global imgRider:TImage[2]
Global imgRiderR:TImage[2]
Global imgTitle:TImage
Global imgLevel:TImage
Global imgFire:TImage
Global imgCRT:TImage
Global imgFont:TImage
Global imgEgg:TImage
Global imgBounder:TImage
Global imgBurst:TImage
Global imgWarp:TImage
Global imgPoints:TImage
Global imgHatched:TImage
Global imgMount:TImage
Global imgMountS:TImage
Global imgPal:TImage
Global imgFlame:TImage
Global imgPter:TImage
Global imgGold:TImage
Global imgHunter:TImage
Global imgShadow:TImage
Global imgChamp:TImage
Global imgChamp2:TImage
Global imgBurst2:TImage
Global imgSpark:TImage
Global imgWater:TImage
Global imgRock:TImage
Global imgRain:TImage
Global imgMenu:TImage
Global imgIce:TImage
Global imgComet:TImage

' // Pixmaps
Global pixRiderP:TPixmap[2]

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SOUNDS                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global sfxTitle:TSound
Global sfxSpawn:TSound
Global sfxStep1:TSound
Global sfxStep2:TSound
Global sfxSkid:TSound
Global sfxFlap:TSound
Global sfxBump:TSound
Global sfxEgg2:TSound
Global sfxPad:TSound
Global sfxParry:TSound
Global sfxDie:TSound
Global sfxPause:TSound
Global sfxRespawn:TSound
Global sfxEgg:TSound
Global sfxKill:TSound
Global sfxPter:TSound
Global sfxPdie:TSound
Global sfx1Up:TSound
Global sfxPop:TSound
Global sfxBounce:TSound
Global sfxComet:TSound
Global sfxCrash:TSound
Global sfxIce:TSound

sfxTitle = LoadSound("sfx/title.wav")
sfxSpawn = LoadSound("sfx/spawn.wav")
sfxStep1 = LoadSound("sfx/step1.wav")
sfxStep2 = LoadSound("sfx/step2.wav")
sfxSkid = LoadSound("sfx/skid.wav")
sfxFlap = LoadSound("sfx/flap.wav")
sfxBump = LoadSound("sfx/bump.wav")
sfxEgg2 = LoadSound("sfx/egg2.wav")
sfxPad = LoadSound("sfx/pad.wav")
sfxParry = LoadSound("sfx/parry2.wav")
sfxDie = LoadSound("sfx/die.wav")
sfxPause = LoadSound("sfx/pause.wav")
sfxRespawn = LoadSound("sfx/respawn.wav")
sfxEgg = LoadSound("sfx/egg.wav")
sfxKill = LoadSound("sfx/kill.wav")
sfxPter = LoadSound("sfx/pter.wav")
sfxPdie = LoadSound("sfx/pdie.wav")
sfx1Up = LoadSound("sfx/1up.wav")
sfxPop = LoadSound("sfx/pop.wav")
sfxBounce = LoadSound("sfx/bounce.wav")
sfxComet = LoadSound("sfx/comet2.wav")
sfxCrash = LoadSound("sfx/crash.wav")
sfxIce = LoadSound("sfx/ice.wav")

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² MUSIC                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global musSong1:TSound
Global musSong2:TSound
Global musSong3:TSound
Global musSong4:TSound
Global curSong:Int = 1
Global musicD:Int = -1
Global musicV:Float

Global musChan:TChannel = AllocChannel()
Global pterChan:TChannel = AllocChannel()
Global cometChan:TChannel = AllocChannel()
Global iceChan:TChannel = AllocChannel()

musSong1 = LoadSound("ogg/song1.ogg", SOUND_LOOP)
musSong2 = LoadSound("ogg/song2.ogg", SOUND_LOOP)
musSong3 = LoadSound("ogg/song3.ogg", SOUND_LOOP)
musSong4 = LoadSound("ogg/song4.ogg", SOUND_LOOP)

musChan = PlaySound(musSong1, musChan)
musChan.SetVolume(Float(cfgMusic) / 10) 

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CONSTANTS                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Const PLAYER_1:Int = 0
Const PLAYER_2:Int = 1

' // OBJECTS
Const OBJ_FIREBALL:Int = 1
Const OBJ_BUZZARD:Int = 2
Const OBJ_WARP:Int = 3
Const OBJ_EGG:Int = 4
Const OBJ_MOUNT:Int = 5
Const OBJ_FLAME:Int = 6
Const OBJ_PTER:Int = 7
Const OBJ_SPARK:Int = 8
Const OBJ_ROCK:Int = 9
Const OBJ_ICE:Int = 10
Const OBJ_COMET:Int = 11

' // PARTICLES
Const PART_SKID:Int = 1
Const PART_FIRE:Int = 2
Const PART_BURST:Int = 3
Const PART_WARP:Int = 4
Const PART_GHOST:Int = 5
Const PART_POINTS:Int = 6
Const PART_SNOW:Int = 7
Const PART_RAIN:Int = 8

' // CREATE OBJECTS
Const CREATE_EGG:Int = 1
Const CREATE_MOUNT:Int = 2
Const CREATE_BUZZARD:Int = 3

' // ENEMIES
Const ENEMY_BOUNDER:Int = 0
Const ENEMY_HUNTER:Int = 1
Const ENEMY_SHADOW:Int = 2
Const ENEMY_EGG:Int = 3
	
Global objC:Int = 0 ' // Object count
Global partC:Int = 0 ' // Particle count

Global o:Obj, objList:TList = CreateList()
Global p:Part, partList:TList = CreateList()

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² STARS                                        
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Star

	Field x:Float,y:Float
	Field xPos:Float,yPos:Float,zPos:Float
	Field zVel:Float
	Field intensity:Float
	Field size:Float
	Field image:TImage
	Field fade:Float
	
	Function Create:Star(starImage:TImage)
          Local s:Star = New Star
		  s.init()
		  s.image = starImage2
          Return s
    End Function

	Method init()
		xPos = Rnd(-1,1)
		yPos = Rnd(-1,1)
		zPos = Rnd(900,1000)
		zVel = Rnd(1, 5) 'Rnd(0.5,5)
		size = Rnd(0.1,.3)'.5)
		If waveC = 1 Then fade = .001 Else fade = 0
		If Rand(0,100) = 0 Then size = size * 3
	End Method
	
	Method fadeStar()
		fade = intensity
	End Method
	
	Method update(speed:Float=1.0)

		zPos :- Abs(zVel*speed)
		x = (xPos/zPos) * 256
		y = (yPos/zPos) * 256
		intensity = 1-(zPos*.001)
		If x < -1 Or x > 1 Or y < -1 Or y > 1 Or zPos < 1 Or zPos > 1000
			If IsMoon() = True Then init()
		End If
		
	End Method
	
	Method render()
		SetOrigin GraphicsWidth()/2, GraphicsHeight()/2	
		SetImageHandle image,ImageWidth(image)/2,ImageHeight(image)/2
		
		SetScale size*intensity*.6, size*intensity*.6
		SetBlend LIGHTBLEND
		SetRotation 0
		If fade = 0 Then
			SetAlpha intensity*1.25
		Else
			SetAlpha fade
			If fade > .005 Then fade:-.005 Else fade = .001
		EndIf
		SetColor Int(255*(intensity / 1)), Int(255*(intensity / 1)), 255
		DrawImage image, x*(GraphicsWidth()/2), y*(GraphicsHeight()/2)
		SetOrigin 0, 0
		SetScale sclX, sclY
	End Method
	
End Type

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² 3D Axis                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type TAxis
    Field vertices:Float[24] ' // 8 vertices, each with 3 coordinates

    Method New()
        vertices = [ 0:Float, -2:Float, 0:Float, ..
					1.5:Float, -1.5:Float, 0:Float, ..
                    2:Float, 0:Float, 0:Float, ..
					1.5:Float, 1.5:Float, 0:Float, ..
					0:Float, 2:Float, 0:Float, ..
					-1.5:Float, 1.5:Float, 0:Float, ..
					-2:Float, 0:Float, 0:Float, ..
					-1.5:Float, -1.5:Float, 0:Float ]
    End Method

    Method Draw(matrix:SMat4D, scale:Float, centerX:Int, centerY:Int)
        Local transformedVertices:Float[24]

        ' // Apply transformation and orthographic projection
		Local bOff:Int = 0
        For Local i:Int = 0 Until 24 Step 3
            Local vertex:SVec3D = New SVec3D(vertices[i], vertices[i + 1], vertices[i + 2])
            vertex = matrix.Apply(vertex)
			transformedVertices[i] = centerX + ((scale) * vertex.x)
            transformedVertices[i + 1] = centerY - (scale * vertex.y)

			If bOff = 0 Then SetColor 252, 152, 56 Else SetColor 252, 188, 176
			DrawRect transformedVertices[i] + .25, transformedVertices[i + 1], 4, 4
			If bOff = 0 Then bOff = 1 Else bOff = 0
			SetColor 255, 255, 255
        Next

    End Method
End Type

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PARTICLES                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Part
    Field X:Float, Y:Float, A:Int, ID:Int
	Field R:Float, S:Float, C:Int[3], Alp:Float, D:Float, HC:Int, HC2:Int
	Field C2:Int, S2:Float, T:Int, F:Int, YI:Float, SC:TChannel, Iner:Float, Rot:Int
	
    Function Create:Part(X:Float, Y:Float, Dir:Int, ID:Int, Ex:Int = 0)
		p:Part = New Part
		p.X = X; p.Y = Y; p.Alp = 1; p.ID = ID
		
		If ID = PART_SKID Then ' // Skid particle
			' // Skid vs. fireball splash particle vs. burst
			If Dir = 1 Then p.A = Rand(325, 355) ElseIf Dir = 0 Then p.A = Rand(185, 215) ElseIf (Dir = 3 Or Dir = 4) Then p.A = Rand(0, 359)
			If Dir = 2 Then p.HC = 1 ElseIf Dir = 3 Then p.HC = 2 ' // Particle type
			
			If (Dir = 0 Or Dir = 1) Then ' // Skid
				If levelF <= 1 Then ' // Lava
					p.HC2 = 0
				ElseIf levelF <= 5 Then ' // Ice 
					p.HC2 = 1
				ElseIf levelF <= 9 Then ' // Earth
					p.HC2 = 2
				ElseIf levelF <= 13 Then ' // Moon
					p.HC2 = 4
				EndIf
			ElseIf Dir = 4 Then ' // Ice shatter
				p.HC2 = 3
			ElseIf Dir = 5 Then ' // Comet shatter
				p.HC2 = 5
				p.A = Rand(0, 359)				
			EndIf
			
			p.R = 0; p.S = Rnd(1, 2.5); p.C[0] = 0; p.C[1] = 232; p.C[2] = 216
			p.D = Rnd(.075, .1); p.C2 = Rand(0, 1)
			If Dir = 2 Then p.C2 = 2; p.A = Rand(220, 320) ' // Fireball splash
			If Dir = 3 Then p.C2 = Rand(1, 2)
			If Ex = 1 Then p.S2 = 1 ' // Lava burst
			If Ex = 2 Then p.S2 = 2 ' // Water burst
			
			If Ex = 2 Or Dir = 4 Then p.A = Rand(180, 360) ' // Water/ice top angle
			If Dir = 5 Then p.C2 = Rand(0, 2) ' // Comet
			
		ElseIf ID = PART_FIRE Then ' // Fireball particle
			p.D = Rnd(.01, .1)
			p.X:+Rand(-4, 4)
			p.C2 = Ex
			'o.C2 = Rand(0, 1)
					
		ElseIf ID = PART_BURST
			p.T = GetMilliSecs()
			If Ex = 1 Then p.S2 = 1 ' // Lava burst
			
		ElseIf ID = PART_WARP Then ' // Warp particles
			p.S = Rnd(1, 4)
			p.HC = Ex
			If Ex = 1 Then p.S = Rnd(.5, 2)
			
		ElseIf ID = PART_GHOST ' // Parry ghost
			p.Alp = .5
			p.F = Dir
			p.HC = Ex
			
		ElseIf ID = PART_POINTS ' // Points
			p.D = Dir
			p.Alp = 1
			p.HC = Ex ' // Air or egg
			
		ElseIf ID = PART_SNOW ' // Snow
			p.X = Rand(0, 588); p.Y = -5; p.R = 0; p.Alp = Rnd(.2, .99); p.YI = Rnd(.5, 1)
			p.S = Rnd(1, 3); p.T = Rand(0, 1); p.C2 = Rand(2, 5); p.D = Rand(0, 1); p.S2 = Rnd(-.1, -1)
			
			p.HC = p.D; p.HC2 = p.S2
			p.A = 0
		
		ElseIf ID = PART_RAIN ' // Rain
			p.X = Rand(0, 588)
			p.Y = -8
		
			Local tmpS:Int = Rand(0, 3)
			If tmpS = 0 Then ' // Fore
				p.Alp = .7
				p.S = 5
				p.YI = 5
			ElseIf tmpS = 1 Then
				p.Alp = .6
				p.S = 4
				p.YI = 4.5
			ElseIf tmpS = 2 Then
				p.Alp = .5
				p.S = 3
				p.YI = 4
			ElseIf tmpS = 3 Then
				p.Alp = .4
				p.S = 2
				p.YI = 3.5
			EndIf
			
		EndIf
		
		partC = partC + 1
		Return p
		
    End Function
			
	Method Render() ' // Front / back
		Local Del:Int = False
		Local createP:Int = False
		Local oldX:Int, oldY:Int
		
		Select ID
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² SKID PARTICLES                                           
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case PART_SKID ' // Skid particle
			SetBlend LIGHTBLEND; SetAlpha Alp
			SetScale 1, 1
			If C2 = 0 Then 
				If HC2 = 0 Then ' // Lava skid
					SetColor 252, 152, 56
				ElseIf HC2 = 1 Then ' // Ice skid
					SetColor 122, 213, 241	
				ElseIf HC2 = 2 Then ' // Earth skid
					SetColor 164, 232, 94
				ElseIf HC2 = 3 Then ' // Ice shatter
					SetColor 73, 141, 200
				ElseIf HC2 = 4 Then ' // Moon skid
					SetColor 132, 174, 164
				ElseIf HC2 = 5 Then ' // Comet
					SetColor 69, 224, 130
				EndIf
			ElseIf C2 = 1 Then
				If HC2 = 5 Then ' // Comet
					SetColor 179, 243, 204			
				Else
					SetColor 252, 252, 252
				EndIf
			ElseIf C2 = 2 Then
				If HC2 = 5 Then ' // Comet
					SetColor 100, 176, 255
				Else
					' // Fireball, burst particles
					If HC = 1 Then SetColor 240, 188, 60 ElseIf HC = 2 Then SetColor 128, 208, 16
					If HC = 2 And S2 = 1 Then SetColor 240, 188, 60
					If HC = 2 And S2 = 2 Then SetColor 73, 141, 200 ' // Water particles
				EndIf
				
			EndIf
			
			Local tmpS:Int
			
			If S >= 1.5 Then ' // Sizing
				tmpS = 4; Alp = 1
			ElseIf S >= .5 Then
				tmpS = 3; Alp = .66
			Else
				tmpS = 2; Alp = .33
			EndIf			
			
			If HC = 1 Then tmpS:+.75 ' // Fireball particles
			If HC = 2 Then tmpS:+1 ' // Burst
			If HC = 2 And S2 = 2 Then tmpS:-2 ' // Rain splash
			'If S2 = 2 Then
			'	DrawOval Float((R * Cos(A) + X) - (tmpS / 2)), Float((R * Sin(A) + Y) - (tmpS / 2)), tmpS, tmpS
			'Else
			
			If HC2 = 3 Or HC2 = 5 Then ' // Ice / comet shatter
				If Rand(0, 1) = 1 Then DrawRect Float((R * Cos(A) + X) - (tmpS / 2)), Float((R * Sin(A) + Y) - (tmpS / 2)), tmpS, tmpS
			Else
				DrawRect Float((R * Cos(A) + X) - (tmpS / 2)), Float((R * Sin(A) + Y) - (tmpS / 2)), tmpS, tmpS
			EndIf
			
			'SetRotation 0
			
			'Rot:+5
			
			'EndIf
			
			R = R + S
			Alp = Alp - .01
			If S > 0 Then S = S - D Else Del = True

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² FIREBALL PARTICLES                                             
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case PART_FIRE ' // Fireball particle
			SetBlend LIGHTBLEND; SetAlpha Alp
			SetScale 1.5, 1.25

			If C2 = 0 Then ' // Fireball
				SetColor 240, 188, 60 
			ElseIf C2 = 1 Then ' // Spark ice
				Local tmpR1:Int = Rand(0, 2)
				If tmpR1 = 0 Then
					SetColor 69, 224, 130
				ElseIf tmpR1 = 1 Then
					SetColor 100, 176, 255			
				ElseIf tmpR1 = 2
					SetColor 179, 243, 204
				EndIf
			ElseIf C2 = 2 Then ' // Spark fire
				If Rand(0, 1) = 0 Then
					SetColor 216, 40, 0
				Else
					SetColor 252, 152, 56
				EndIf
			ElseIf C2 = 3 Then ' // Spark earth
				If Rand(0, 1) = 0 Then
					SetColor 122, 213, 241
				Else
					SetColor 54, 144, 234
				EndIf		
			EndIf
			
			'SetRotation Rot; SetHandle 1, 1
			DrawRect X, Y, 2, 2
			'SetScale .2, .2
			'DrawImage starImage, Int(x), Int(y)
			SetScale sclX, sclY
			'SetRotation 0; SetHandle 0, 0
			'Rot:+5
			
			If Alp > 0 Then Alp = Alp - D Else Del = True

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² BURST SPRITE                                        
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //		
			Case PART_BURST ' // Burst sprite
			SetBlend ALPHABLEND; SetAlpha 1
			SetScale sclX, sclY; SetColor 255, 255, 255
			
			If S2 = 0 Then
				DrawImage imgBurst, Int(X), Int(Y), F
			Else
				DrawImage imgBurst2, Int(X), Int(Y), F
			EndIf
			
			If GetMilliSecs() >= T + 60 Then
				If F < 2 Then F = F + 1 Else Del = True
				T = GetMilliSecs()
			EndIf

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² WARP PARTICLES                                        
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			Case PART_WARP ' // Warp particles
			SetBlend LIGHTBLEND; SetAlpha Alp
			SetScale sclX, sclY
			If HC = 0 Then ' // Warp
				SetColor 235, 251, 170
			ElseIf HC = 1 Then ' // Water
				SetColor 122, 213, 241
			EndIf
			
			Local tmpS:Int
			'If S >= 3 Then tmpS = 3 ElseIf S >= 2 Then tmpS = 2 Else tmpS = 1
			DrawRect X, Y, 1, 1
			SetBlend ALPHABLEND

			Y:-S; Alp:-.05
			S:-.1
			If S <= 0 Or Alp <= 0 Then Del = True

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² GHOST SPRITE                                            
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			Case PART_GHOST ' // Parry ghost
			SetScale sclX, sclY; SetBlend LIGHTBLEND; SetAlpha Alp; SetColor 255, 255, 255
			
			DrawImage imgRider[HC], Int(X), Int(Y), F
			
			If Alp > 0 Then Alp:-.05 Else Del = True
			SetBlend ALPHABLEND

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² POINTS SPRITE                                             
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case PART_POINTS ' // Points
			SetBlend ALPHABLEND; SetAlpha Alp
			SetScale sclX, sclY
			If HC = 1 Then SetColor 240, 188, 60 ElseIf HC = 0 Then SetColor 255, 255, 255
			
			DrawImage imgPoints, Int(X), Int(Y), Int(D) - 1			
			SetColor 255, 255, 255
			
			If Alp > 0 Then Alp:-.01 Else Del = True
			
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² SNOW PARTICLES                                            
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case PART_SNOW
			SetAlpha Alp; SetRotation R; SetScale 1, 1
			SetBlend LIGHTBLEND
		
			If D = 0 ' // left
				X:-Iner
				Iner:-.01
				If Iner <= S2 Then D = 1; Iner = Abs(S2)
			Else ' // Right
				X:+Iner
				Iner:-.01
				If Iner <= S2 Then D = 0; Iner = Abs(S2)
			EndIf
			
			If T = 0 Then SetColor 252, 252, 252 ElseIf T = 1 Then SetColor 122, 213, 241
			
			SetHandle C2/2, C2/2		
			DrawRect X, Y, C2, C2
			SetHandle 0, 0

			'SetColor 255, 0, 0; DrawRect Int(X), Int(Y), 1, 1
			
			Local oldY:Int = Int(Y) ' // Hold
			R:+S; Y:+YI
			'DebugLog "A: " + A + " X: " + X + " Y: " + Y + " C2: " + C2 + " YI: " + YI
			
			SetRotation 0; SetScale 1, 1; SetBlend ALPHABLEND; SetAlpha 1
			If C2 < 5 Then
				If oldY >= Int(189 * sclY) Then Del = True
			Else
				If oldY >= 448 Then Del = True
			EndIf
			
			If A = 1 And Del = False Then ' // Fade out
				If Alp > 0 Then Alp:-.01 Else Del = True
			EndIf
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² RAIN                                             
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
			Case PART_RAIN ' // Rain
			SetBlend LIGHTBLEND; SetAlpha Alp
			SetScale sclX, S
			SetColor 255, 255, 255
			
			DrawImage imgRain, Int(X), Int(Y)
										
			If S < 5 Then
				If tranC = 0 Then
					If ImagesCollide2(imgLevel, 0, 0, levelF, 0, sclX, sclY, imgRain, Int(X), Int(Y), 0, 0, sclX, S) Then 
						Del = True; createP = True
						oldX = Int(X)
						If S = 2 Then 
							oldY = Int(Y + 6)
						ElseIf S = 3 Then
							oldY = Int(Y + 9)
						ElseIf S = 4 Then
							oldY = Int(Y + 12)				
						EndIf								
					EndIf
				Else ' // During transition ground col
					oldX = Int(X)
					If S = 2 Then 
						oldY = Int(Y + 6)
					ElseIf S = 3 Then
						oldY = Int(Y + 9)
					ElseIf S = 4 Then
						oldY = Int(Y + 12)				
					EndIf
					
					If oldY >= Int(189 * sclY) Then Del = True; createP = True				
				EndIf
			Else
				If Y >= 448 Then Del = True
			EndIf
			
			Y:+YI

			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
		End Select
		
		If Del = True Then partList.Remove p; partC = partC - 1
		
		If createP = True Then ' // Create particle
			For Local i:Int = 1 To 3
				partList.AddLast part.Create(oldX, oldY, 3, PART_SKID, 2)
			Next
		EndIf
		
	End Method
	
End Type

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² OBJECTS                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Obj    
    Field X:Float, Y:Float, A:Int, ID:Int
	Field R:Float, S:Float, C:Int[3], Alp:Float, D:Float, HC:Int, HC2:Int
	Field C2:Int, S2:Float, T:Int, F:Int, YI:Float, SC:TChannel
	Field XI:Float, Targ:Int
	
    Function Create:Obj(X:Float, Y:Float, Dir:Int, ID:Int, Ex:Int = 0, Ex2:Int = 0)
		o:Obj = New Obj
		o.X = X; o.Y = Y; o.Alp = 1; o.ID = ID
		
		If ID = OBJ_FIREBALL Then ' // Bubble / fireball
			
		ElseIf ID = OBJ_BUZZARD Then ' // Bounder
			o.A = 0 ' // Warp in
			o.R = 1 ' // Draw height 
			o.T = GetMilliSecs()
			o.SC = AllocChannel() 
			o.S = en_Count ' // Unique per enemy ID
			o.HC = 0 ' // Hit check
			
			If Ex <> 0 Then ' // Captured by mount
				o.A = 1; o.D = Ex - 1 ' // Alive
				If o.D = 0 Then o.F = 0 ElseIf o.D = 1 Then o.F = 5
			EndIf
			
			o.C2 = Dir ' // Type
			o.XI = 0 ' // Accel

			If o.C2 = ENEMY_HUNTER Or o.C2 = ENEMY_SHADOW Then ' // Seeking
				If b2Player = True Then o.Targ = Rand(0, 1) Else o.Targ = 0
			EndIf
				
			en_Count:+1
			
		ElseIf ID = OBJ_WARP Then ' // Warp in
			o.Alp = 0
			o.T = GetMilliSecs()
			o.D = 0
			
		ElseIf ID = OBJ_EGG ' // Egg
			o.D = Dir ' // Left/right
			If Dir = -1 Then o.C2 = Rand(13000, 15000) ' // Egg wave random hatch time
			o.S = 0
			o.R = .8
			o.S2 = -.75
			o.T = GetMilliSecs() ' // Timer
			o.A = 0 ' // Uncracked
			o.F = 0
			o.HC = Ex ' // Per egg ID
			o.HC2 = Ex2 ' // Type
			
		ElseIf ID = OBJ_MOUNT Then ' // Mount
			o.T = GetMilliSecs()
			o.D = Dir
			If Dir = 0 Then o.F = 9 ElseIf Dir = 1 Then o.F = 11
			o.HC = Ex ' // Per egg ID
			
			' // Save original egg position
			o.S = X; o.S2 = Y
			
			' // Adjust position
			If Dir = 0 Then o.X = 588 ElseIf Dir = 1 Then o.X = -(16 * sclX)
			o.Y = Int(o.Y) - 24
			o.HC2 = Ex2 ' // Type
			
		ElseIf ID = OBJ_FLAME ' // Flame
			o.T = GetMilliSecs()
			o.D = Dir
			o.A = 0 ' // Burn phase
			o.Alp = .95
			
		ElseIf ID = OBJ_PTER ' // Pterodactyl
			o.T = GetMilliSecs()
			o.D = Dir
			If Dir = 0 Then o.F = 0 ElseIf Dir = 1 Then o.F = 4
			o.HC = Ex ' // Target player
			o.S =Rand(0, 2)
			o.SC = AllocChannel() ' // Bump channel
			If Rand(1, 10) = 5 Then o.HC2 = 1 Else o.HC2 = 0 ' // Gold pter

		ElseIf ID = OBJ_SPARK ' // Spark
			o.T = GetMilliSecs()
			o.D = Dir		
			o.HC = Ex ' // Type Ice / Fire
			o.A = 0 ' // Spawn phase
			o.S = Y
			o.S2 = Rand(0, 1)
			If o.S2 = 0 Then o.YI = -1 Else o.YI = 1; o.S2 = 2
		
		ElseIf ID = OBJ_ROCK ' // Rock
			o.D = Dir		
			o.YI = 0
			If Dir = 0 Then o.F = 3 Else o.F = 0
		
		ElseIf ID = OBJ_ICE ' // Ice
			o.T = GetMilliSecs()
			o.C2 = Rand(500, 3000) ' // Hang time
		
		ElseIf ID = OBJ_COMET ' // Space invader
			o.T = GetMilliSecs()
			o.D = Dir
			If o.D = 0 Then o.F = 0 ElseIf o.D = 1 Then o.F = 2
		EndIf
		
		objC = objC + 1
		Return o
		
    End Function

    Method Render(rLayer:Int) ' // Front / back
        Local Del:Int = False
        Local I:Int = 0, tmpR:Int
		Local oldX:Int, oldY:Int, oldD:Int, oldEx:Int, oldType:Int
		
		Local createO:Int = False
		
		If rLayer = 0 Then ' // Back layer
			Select ID

				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² BUZZARD                                        
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				Case OBJ_BUZZARD ' // Buzzard
				SetBlend ALPHABLEND; SetAlpha Alp
				SetScale sclX, sclY; SetColor 255, 255, 255
						
				If A = 0 Then ' // Spawning
					If C2 = ENEMY_BOUNDER Then ' // Bounder
						DrawSubImageRect imgBounder, Int(X), Int(Y), 16, R, 0, 0, 16, R, F
					ElseIf C2 = ENEMY_HUNTER Then ' // Hunter
						DrawSubImageRect imgHunter, Int(X), Int(Y), 16, R, 0, 0, 16, R, F
					ElseIf C2 = ENEMY_SHADOW Then ' // Shadow lord
						DrawSubImageRect imgShadow, Int(X), Int(Y), 16, R, 0, 0, 16, R, F
					EndIf
					
					If GetMilliSecs() >= T + 16 Then
						If R < 24 Then 
							R:+1; Y:-(1 * sclY) 
						Else 
							A = 1; D = Rand(0, 1) ' // Alive
							R = 0
							If D = 0 Then F = 0 Else F = 5
						EndIf
						T = GetMilliSecs()
					EndIf
				
				ElseIf A = 1 Then ' // Alive
					If C2 = ENEMY_BOUNDER Then ' // Bounder
						DrawImage imgBounder, Int(X), Int(Y), F
					ElseIf C2 = ENEMY_HUNTER Then ' // Hunter
						DrawImage imgHunter, Int(X), Int(Y), F
					ElseIf C2 = ENEMY_SHADOW Then ' // Shadow lord
						DrawImage imgShadow, Int(X), Int(Y), F
					EndIf

					If bDebug = True Then ' // Debug rects
						SetColor 255, 255, 0
						DrawRect Int(X), Int(Y), 4, 17 ' // Left
						DrawRect Int(X + (12 * sclX)), Int(Y), 4, 17 ' // Right
						DrawRect Int(X + (3 * sclX)), Int(Y + (14 * sclY)), 10, 1 ' // Feet
						DrawRect Int(X + (1 * sclX)), Int(Y - (1 * sclY)), 14, 1 ' // Head

						SetColor 255, 0, 0
						DrawRect Int(X + (3 * sclX)), Int(Y + (24 * sclY)), 10, 1 ' // Feet
						DrawRect Int(X + (3 * sclX)), Int(Y - (1 * sclY)), 10, 1 ' // Head

						DrawRect Int(X), Int(Y), 1, 22 ' // Left
						DrawRect Int(X + (15 * sclX)), Int(Y), 1, 22 ' // Right

						' // Heart
						DrawRect Int(X + (6 * sclX)), Int(Y + (8 * sclY)), 2, 2 ' // Center
																	
						SetColor 255, 255, 255
					EndIf
					
					' // Left side
					If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X), Int(Y), 1, 22) = True Then
						If D = 0 Then 
							D = 1 			
							If R = 1 Then F = 13 Else F = 1 ' // Reset				
							If ChannelPlaying(SC) = False Then SC = playSFX(sfxBump)
						EndIf
					EndIf

					' // Right side
					If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + (15 * sclX)), Int(Y), 1, 22) = True Then
						If D = 1 Then 
							D = 0 	
							If R = 1 Then F = 11 Else F = 6 ' // Reset								
							If ChannelPlaying(SC) = False Then SC = playSFX(sfxBump)
						EndIf
					EndIf
									
					Local tmpHead:Int = False
					' // Head collision
					If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + (3 * sclX)), Int(Y - (1 * sclY)), 10, 1) = True Or Y < 0 Then
						YI = .5
						If ChannelPlaying(SC) = False And Y > 0 Then SC = PlaySFX(sfxBump)
						tmpHead = True
					EndIf
					
					Local tmpFlap:Int
								
					' // Seeking
					If C2 = ENEMY_SHADOW And Y > p_Y[Targ] + 2 Then 
						tmpFlap = Rand(1, 6)
						If tmpFlap = 3 Then tmpFlap = 1 Else tmpFlap = 0
					ElseIf C2 = ENEMY_HUNTER And Y > p_Y[Targ] + 2 Then
						tmpFlap = Rand(1, 24)
						If tmpFlap = 12 Then tmpFlap = 1 Else tmpFlap = 0				
					Else 'If C2 = ENEMY_BOUNDER
						tmpFlap = Rand(1, 50) ' // Random flap
						If tmpFlap = 25 Then tmpFlap = 1 Else tmpFlap = 0
					EndIf
														
					Local tmpFeet:Int = ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + (3 * sclX)), Int(Y + (24 * sclY)), 10, 1)
					
					If Int(Y) >= 334 Then ' // Lava check
						tmpFeet = False
						YI = -.5
						If F >= 0 And F <= 4 Then
							F = 11
						ElseIf F >= 5 And F <= 9
							F = 13
						EndIf
					EndIf
					
					If tmpFeet = False Then tmpFlap = 0
					
					' // Feet collision / random flap
					If tmpFeet = False Or tmpFlap = 1 Then
						If R = 0 Or tmpFlap = 1 Then
							YI = -1.25
							If F >= 0 And F <= 4 Then
								F = 11
							ElseIf F >= 5 And F <= 9
								F = 13
							EndIf
						Else
						
							Local tmpBFlap:Int = 0
							
							' // Seeking
							If C2 = ENEMY_SHADOW Then
								If Y > p_Y[Targ] Then 
									tmpFlap = Rand(1, 3)
								ElseIf Y < p_Y[Targ] Then
									tmpFlap = Rand(1, 20)		
								EndIf
								If tmpFlap = 3 Then tmpBFlap = 1 Else tmpBFlap = 0
							ElseIf C2 = ENEMY_HUNTER Then
								If Y > p_Y[Targ] Then 
									tmpFlap = Rand(1, 5)
								ElseIf Y < p_Y[Targ] Then
									tmpFlap = Rand(1, 10)		
								EndIf
								If tmpFlap = 3 Then tmpBFlap = 1 Else tmpBFlap = 0
							
							ElseIf C2 = ENEMY_BOUNDER
								If Rand(1, 6) = 3 Then tmpBFlap = 1
							EndIf

							If tmpBFlap = 1 Then ' // Flap
								If GetMilliSecs() >= T + 25 Then
									If F = 11 Then F = 10 ElseIf F = 13 Then F = 12					
									YI:-.25
									T = GetMilliSecs()
								EndIf
							Else							
								If F = 10 Then F = 11 ElseIf F = 12 Then F = 13
								If YI < 2 Then 
									If IsMoon() = False Then YI:+.05 Else YI:+.04
								Else 
									YI = 2
								EndIf
							EndIf
						EndIf
						
						' // Frame fix
						If D = 0 And (F <> 10 And F <> 11) Then F = 11
						If D = 1 And (F <> 12 And F <> 13) Then F = 13

						R = 1
											
					Else
						' // Level with floor
						If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + (3 * sclX)), Int(Y + (23 * sclY)), 10, 1) = True Then Y:-1
						
						If R = 1 Then
							If F = 10 Or F = 11 Then 
								F = 0
							ElseIf F = 12 Or F = 13 Then
								F = 5
							EndIf
							
							T = GetMilliSecs()
							If tmpHead = False And YI > 0 Then YI = 0' DebugLog "LAND"
						EndIf
						
						R = 0
					EndIf
					
					' // Hold before changes
					oldX = Int(X); oldY = Int(Y); oldD = Int(D); oldType = C2
					
					If D = 0 Then ' // Left
						'If GetMilliSecs() >= T + 60 And R = 0 Then

						If (GetMilliSecs() >= (T + 150) - Int(Abs(XI) * 37)) And R = 0 Then				
							If F > 4 Then 
								F = 1 ' // Reset frame
							Else
								If F < 4 Then F = F + 1 Else F = 1
							EndIf
							
							T = GetMilliSecs()
						EndIf
						
						If C2 = ENEMY_BOUNDER Then ' // Accel
							If XI < 1 Then XI:+.15 Else XI = 1
						ElseIf C2 = ENEMY_HUNTER Then 
							If XI < 2.5 Then XI:+.15 Else XI = 2.5
						ElseIf C2 = ENEMY_SHADOW Then
							If XI < 4 Then XI:+.15 Else XI = 4
						EndIf
						
						X:-XI
						If X <= -(10 * sclX) Then X = 574 ' // Wrap
					
					ElseIf D = 1 Then ' // Right
						'If GetMilliSecs() >= T + 60 And R = 0 Then

						If (GetMilliSecs() >= (T + 150) - Int(Abs(XI) * 37)) And R = 0 Then	
							If F < 5 Or F > 9 Then 
								F = 6 ' // Reset frame
							Else
								If F < 9 Then F = F + 1 Else F = 6
							EndIf
							
							T = GetMilliSecs()
						EndIf

						If C2 = ENEMY_BOUNDER Then ' // Accel
							If XI < 1 Then XI:+.15 Else XI = 1
						ElseIf C2 = ENEMY_HUNTER Then 
							If XI < 2.5 Then XI:+.15 Else XI = 2.5
						ElseIf C2 = ENEMY_SHADOW Then
							If XI < 4 Then XI:+.15 Else XI = 4
						EndIf
						
						X:+XI
						If X >= 574 Then X = -(10 * sclX) ' // Wrap

					EndIf

					Y = Y + YI

					' // Check player collision
					Local tmpCol:Int = 0, i:Int = 0
			
					For Local i2:Int = 0 To b2Player
						If ImageRectCollide(imgRider[i2], Int(p_X[i2]), Int(p_Y[i2]), p_F[i2], Int(oldX), Int(oldY), 1, 17) = True Then tmpCol = 1 ' // Left side
						If ImageRectCollide(imgRider[i2], Int(p_X[i2]), Int(p_Y[i2]), p_F[i2], Int(oldX + (15 * sclX)), Int(oldY), 1, 17) = True Then tmpCol = 2 ' // Right side
						If ImageRectCollide(imgRider[i2], Int(p_X[i2]), Int(p_Y[i2]), p_F[i2], Int(oldX + (1 * sclX)), Int(oldY - (1 * sclY)), 14, 1) = True Then tmpCol = 3 ' // Head
						If R = 1 And ImageRectCollide(imgRider[i2], Int(p_X[i2]), Int(p_Y[i2]), p_F[i2], Int(oldX + (2 * sclX)), Int(oldY + (16 * sclY)), 12, 1) = True Then tmpCol = 4 ' // Feet
						If ImageRectCollide(imgRider[i2], Int(p_X[i2]), Int(p_Y[i2]), p_F[i2], Int(oldX + (6 * sclX)), Int(oldY + (8 * sclY)), 2, 2) = True Then tmpCol = 5 ' // Heart

						If tmpCol <> 0 Then i = i2; Exit
					Next
															
					Local tmpGhost:Int = -1 ' // Create ghost
					Local tmpBurst:Int = -1 ' // Create burst
					
					If p_Respawn[i] > 0 Then tmpCol = 0 ' // Player was respawning check
					
					If tmpCol <> 0 Then ' // Hit
												
						If HC2 = 0 Then			
							'DebugLog Int(p_Y[i]) + " | " + Int(oldY)
							
							If tmpCol = 5 Then ' // Heart hit - kill player
								tmpBurst = i
								
							' // Parry							
							ElseIf Int(p_Y[i]) >= Int(oldY) - 2 And Int(p_Y[i]) <= Int(oldY) + 2 Then
								PlaySFX sfxParry
								
								' // Turn enemy
								If D = 1 And tmpCol = 2 Then 
									D = 0
									If R = 1 Then F = 11 Else F = 6 ' // Reset								
								ElseIf D = 0 And tmpCol = 1 Then 
									D = 1
									If R = 1 Then F = 13 Else F = 1 ' // Reset				
								EndIf
								
								' // Turn player
								If p_I[i] < 0 And tmpCol = 2 Then
									p_I[i] = -p_I[i]
									If p_I[i] < .5 Then p_I[i] = .5 ' // Limit
									tmpGhost = i
								ElseIf p_I[i] > 0 And tmpCol = 1 Then
									p_I[i] = -p_I[i]
									If p_I[i] > -.5 Then p_I[i] = -.5 ' // Limit
									tmpGhost = i
								EndIf

								HC2 = 1
								
							ElseIf Int(p_Y[i]) < Int(oldY) Then ' // Kill buzzard
								If C2 = 0 Then ' // Bounder
									AddScore(i, 500)
								ElseIf C2 = 1 Then ' // Hunter
									AddScore(i, 1000)
								ElseIf C2 = 2 Then ' // Shadow lord
									AddScore(i, 1500)
								EndIf
								'p_Score[i]:+500							

								If tmpCol = 3 And p_YI[i] > 0 Then ' // Bounce
									If IsMoon() = False Then p_YI[i]=-p_YI[i] Else p_YI[i]=-(p_YI[i] + 1) 
								EndIf
								
								PlaySFX sfxKill
								
								partList.AddLast part.Create(X + Int(2 * sclX), Y + Int(6 * sclY), 0, PART_BURST)
								For i = 1 To 10
									partList.AddLast part.Create(X + Int(8 * sclX), Y + Int(12 * sclY), 3, PART_SKID)
								Next
													
								oldEx = S ' // Per enemy ID		
								createO = CREATE_EGG ' // Create egg					

								Del = True
								
							ElseIf Int(p_Y[i]) > Int(oldY) ' // Kill player
								If tmpCol = 4 Then YI = -1.25 ' // Bounce															
								tmpBurst = i			
								
							EndIf
						
						EndIf
					Else
						HC2 = 0
					EndIf
					
					' // Check enemy to enemy collision
					tmpCol = 0
					If Del = False Then tmpCol = CheckEnemyCol(Int(oldX), Int(oldY), F, Int(D), Int(S)) 
					If tmpCol = 1 Then
						If HC = 0 Then
							HC = 1
							
							If D = 1 Then 
								D = 0
								If R = 1 Then F = 11 Else F = 6 ' // Reset								

							Else 
								D = 1
								If R = 1 Then F = 13 Else F = 1 ' // Reset				

							EndIf
						EndIf
						
					Else
						HC = 0
						
					EndIf
					
					If tmpGhost <> -1 Then ' // Create parry ghost
						p_Ghost[tmpGhost] = True; p_GT[tmpGhost] = GetMilliSecs(); p_GC[tmpGhost] = 0
					EndIf
					
					If tmpBurst <> -1 Then DoRespawn(tmpBurst) ' // Kill player
										
				EndIf

				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² EGG                                        
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //								
				Case OBJ_EGG ' // Egg
				SetScale sclX, sclY; SetBlend ALPHABLEND; SetAlpha 1; SetColor 255, 255, 255
				
				If A = 2 Then ' // Hatched
					Local tmpOffF:Int = 0
					If HC2 = 2 Then tmpOffF = 2 ' // Hunter vs. shadow
					DrawImage imgHatched, Int(X), Int(Y), F + tmpOffF
					
				Else ' // Egg
					DrawImage imgEgg, Int(X), Int(Y), F
					
				EndIf
				
				If bDebug = True Then
					SetColor 255, 0, 0
					DrawRect Int(X + Int(2 * sclX)), Int(Y + Int(7 * sclY)), 3, 1 ' // Bottom
					DrawRect Int(X), Int(Y), 1, 6 ' // Left
					DrawRect Int(X + Int(7 * sclX)), Int(Y), 1, 6 ' // Right
					SetColor 255, 255, 255
				EndIf
			
				If A = 0 Then ' // Uncracked

					' // Player collision
					Local tmpCol:Int = -1, i:Int = 0
					For Local i2:Int = 0 To b2Player
						If ImagesCollide(imgRider[i2], Int(p_X[i2]), Int(p_Y[i2]), Int(p_F[i2]), imgEgg, Int(X), Int(Y), 0) Then tmpCol = i2; i = i2; Exit

					Next
					
					If tmpCol <> -1 Then ' // Hit player
						If p_eggC[i] < 4 Then p_eggC[i]:+1
						AddScore(i, p_eggC[i] * 250)
						'p_Score[i]:+(p_eggC[i] * 250)
						
						Local tmpOff:Int = 0, tmpOffY:Int = 8
						If p_eggC[i] <> 4 Then tmpOff = 2
						
						If o.S2 = -.75 And D <> -1 Then ' // Egg wave check
							If p_airC[i] < 2 Then p_airC[i]:+1
							AddScore(i, p_airC[i] * 250)
							'p_Score[i]:+(p_airC[i] * 250) ' // Air check
							
							partList.AddLast part.Create(Int(p_X[i] + Int(2 * sclX)), Int(p_Y[i]), p_airC[i], PART_POINTS, 1)
							partList.AddLast part.Create(Int(p_X[i] + Int(tmpOff * sclX)), Int(p_Y[i] + Int(8 * sclY)), p_eggC[i], PART_POINTS, 0)

							PlaySFX sfxEgg2					
									
						Else
							If R = 0 Then tmpOffY = 16
							partList.AddLast part.Create(Int(p_X[i] + Int(tmpOff * sclX)), Int(p_Y[i] + Int(tmpOffY * sclY)), p_eggC[i], PART_POINTS, 0)
							PlaySFX sfxEgg					

						EndIf
						
						en_C:-1 ' // Enemy count
						Del = True
											
					EndIf
					
					' // Lava check
					If (Int(Y) >= Int(lavaY) - 16) And Del = False Then
						partList.AddLast part.Create(X - Int(3 * sclX), Y - Int(3 * sclY), 0, PART_BURST, 1)
						
						For i = 1 To 10
							partList.AddLast part.Create(X + Int(4 * sclX), Y + Int(4 * sclY), 3, PART_SKID, 1)
						Next
					
						PlaySFX sfxKill
						en_C:-1
						Del = True
					EndIf
					
					Local tmpF:Int = True 
				
					If Del = False Then ' // Del check
						' // Floor collision
						If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + Int(2 * sclX)), Int(Y + Int(7 * sclY)), 3, 1) = True And S > 0 Then
							tmpF = False
							If S > .25 Then S = -(S / 2) Else S = 0
							If S2 < 0 Then S2:+.15 Else S2 = 0
							If R > 0 Then 
								R:-.1 
							Else 
								R = 0; Y = Int(Y)
								If Int(Y) >= 225 And Int(Y) <= 229 Then ' // BUG FIX
									If Int(X) >= Int(228 * sclX) And Int(X) <= Int(232 * sclX) Then
										X = Int(233 * sclX) 					
									EndIf
								EndIf
							EndIf
								
						EndIf
						
						Y:+S
						If S < 4 Then S:+.025 Else S = 4
						
						If D = 0 Then 
							If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X), Int(Y), 1, 6) = True Then ' // Left
								D = 1
							EndIf

							X:-R			
							If X <= -(4 * sclX) Then X = 580
						ElseIf D = 1  Then
							If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + Int(7 * sclX)), Int(Y), 1, 6) = True Then ' // Right
								D = 0
							EndIf
											
							X:+R
							If X >= 580 Then X = -(4 * sclX)
						EndIf
					EndIf
					
					' // Crack 15000
					Local tmpHatch:Int = 15000
					If D = -1 Then tmpHatch = C2 ' // Egg wave
					If Del = False And GetMilliSecs() >= T + tmpHatch Then A = 1; T = GetMilliSecs()
					
				ElseIf A = 1 Then ' // Cracked
				
					' // Player collision				
					Local tmpCol:Int = -1, i:Int = 0
					For Local i2:Int = 0 To b2Player
						If ImagesCollide(imgRider[i2], Int(p_X[i2]), Int(p_Y[i2]), Int(p_F[i2]), imgEgg, Int(X), Int(Y), F) Then tmpCol = i; i = i2; Exit
					Next
					
					If tmpCol <> -1 Then ' // Hit player
						If p_eggC[i] < 4 Then p_eggC[i]:+1
						AddScore(i, p_eggC[i] * 250)
						'p_Score[i]:+(p_eggC[i] * 250)
						
						Local tmpOff:Int = 0
						If p_eggC[i] <> 4 Then tmpOff = 2
						
						partList.AddLast part.Create(Int(p_X[i] + Int(tmpOff * sclX)), Int(p_Y[i] + Int(16 * sclY)), p_eggC[i], PART_POINTS, 0)
						PlaySFX sfxEgg					
					
						en_C:-1 ' // Enemy count
						Del = True
						
					Else											
						If GetMilliSecs() >= T + 125 Then
							If F < 3 Then 
								F:+1 
							Else 
								A = 2; Y:-Int(6 * sclY); F = 0 ' // Hatched				
								
								oldX = Int(X); oldY = Int(Y)
								If Int(X) >= 294 - Int(4 * sclX) Then oldD = 1 Else oldD = 0
							
								oldEx = HC ' // Per egg ID
								oldType = HC2 ' // Type
								
								createO = CREATE_MOUNT ' // Create mount
							EndIf
							
							T = GetMilliSecs()					
							
						EndIf
											
					EndIf
										
				ElseIf A = 2 Then ' // Hatched

					If GetMilliSecs() >= T + 60 Then
						If F < 1 Then F:+1 Else F = 0			
						T = GetMilliSecs()
					EndIf			

					' // Player collision				
					Local tmpCol:Int = -1, i:Int = 0
					For Local i2:Int = 0 To b2Player
						If ImagesCollide(imgRider[i2], Int(p_X[i2]), Int(p_Y[i2]), Int(p_F[i2]), imgHatched, Int(X), Int(Y), F) Then tmpCol = i; i = i2; Exit
					Next
					
					If tmpCol <> -1 Then ' // Hit player
						If p_eggC[i] < 4 Then p_eggC[i]:+1
						AddScore(i, p_eggC[i] * 250)
						'p_Score[i]:+(p_eggC[i] * 250)
						
						Local tmpOff:Int = 0
						If p_eggC[i] <> 4 Then tmpOff = 2
						
						partList.AddLast part.Create(Int(p_X[i] + Int(tmpOff * sclX)), Int(p_Y[i] + Int(16 * sclY)), p_eggC[i], PART_POINTS, 0)
						PlaySFX sfxEgg					
					
						Local tmpHC:Int = HC ' // Delete corresponding mount
						objList.Remove o; objC:-1
						For o:Obj = EachIn objList
							If o.ID = OBJ_MOUNT And o.HC = tmpHC Then objList.Remove o; objC:-1; Exit
						Next

						en_C:-1 ' // Enemy count
																	
					EndIf
					
				EndIf
																			
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² PTERODACTYL                                    
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				Case OBJ_PTER ' // Pterodactyl
				SetScale sclX, sclY; SetBlend ALPHABLEND; SetAlpha 1; SetColor 255, 255, 255
								
				If A = 0 Then ' // Alive
				If HC2 = 0 Then
					DrawImage imgPter, Int(X), Int(Y), F
				ElseIf HC2 = 1 Then ' // GOLD
					DrawImage imgGold, Int(X), Int(Y), F
				EndIf
				
				' // Cry
				If Rand(1, 150) = 75 And ChannelPlaying(pterChan) = False Then pterChan = PlaySFX(sfxPter)
				
				If bDebug = True Then
					SetColor 255, 0, 0
					DrawRect Int(X), Int(Y) + 4, 1, 16 ' // Left
					DrawRect Int(X + Int(24 * sclX)), Int(Y) + 4, 1, 16 ' // Right
					DrawRect Int(X + Int(6 * sclX)), Int(Y + (25 * sclY)), 13, 1 ' // Feet
					DrawRect Int(X), Int(Y), 24, 1 ' // Head
					SetColor 255, 255, 255
				EndIf
				
				If D = 0 Then ' // Left collision
					If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X), Int(Y) + 4, 1, 16) Then 
						D = 1; F:+4
						If ChannelPlaying(SC) = False Then SC = PlaySFX(sfxBump)
					EndIf
				ElseIf D = 1 Then ' // Right collision
					If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + Int(24 * sclX)), Int(Y) + 4, 1, 16) Then 
						D = 0; F:-4
						If ChannelPlaying(SC) = False Then SC = PlaySFX(sfxBump)
					EndIf
				EndIf			
				
				oldX = Int(X); oldY = Int(Y)
				
				Local tmpFeet:Int = False, tmpHead:Int = False ' // Collision cheat		
				' // Feet / floor
				If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + Int(6 * sclX)), Int(Y + (25 * sclY)), 13, 1) Or Int(Y) >= 327 Then
					If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + Int(6 * sclX)), Int(Y + (22 * sclY)), 13, 1) Then Y:-3
					If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + Int(6 * sclX)), Int(Y + (23 * sclY)), 13, 1) Then Y:-2
					If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + Int(6 * sclX)), Int(Y + (24 * sclY)), 13, 1) Then Y:-1
					
					S = 1; YI = -.25
					'YI = 0
					'DebugLog "PTERY: " + Y
					tmpFeet = True
					
				' // Head
				ElseIf ImageRectCollide(imgLevel, 0, 0, levelF, Int(X), Int(Y), 24, 1) Or Y <= 0 Then 
					Y:+1
					S = 2; YI = .25
					tmpHead = True
					If ChannelPlaying(SC) = False Then SC = PlaySFX(sfxBump)
					
				EndIf
		
				If Rand(1, 20) = 10 Then ' Change flight
					Local tmpRand:Int = Rand(1, 6)
					If tmpRand = 6 Then ' // Idle
						S = 0
					ElseIf tmpRand = 5 Then ' // Away
						If S = 1 Then 
							S = 2 
						ElseIf S = 2 Then 
							S = 1 
						Else 
							S = 0
						EndIf
					'If Rand(1, 10) = 5 Then ' // Idle
					'	S = 0
					Else ' // Target
						If p_Y[HC] < Y Then 
							If tmpHead = False Then S = 1
						Else
							If tmpFeet = False Then S = 2
						EndIf
					EndIf
				EndIf
				
				If S = 1 Then ' // Up
					If YI > -3 Then YI:-.05 Else YI = -3
				ElseIf S = 2 Then ' // Down
					If YI < 3 Then YI:+.05 Else YI = 3
				ElseIf S = 0 Then ' // Idle
					If YI > 0 Then YI:-.05 ElseIf YI < 0 Then YI:+.1
				EndIf
				
				If D = 0 Then ' // Left
				
					If GetMilliSecs() >= T + 150 And R = 0 Then
						If F > 3 Then 
							F = 0 ' // Reset frame
						Else
							If F < 3 Then F = F + 1 Else F = 0
						EndIf
						
						T = GetMilliSecs()
					EndIf
						
					X:-3
					If X <= -(14 * sclX) Then 
						If bEnemies = True Then X = 570 Else Del = True ' // Wrap / kill
					EndIf
					
				ElseIf D = 1 Then ' // Right
				
					If GetMilliSecs() >= T + 150 And R = 0 Then
						If F < 4 Or F > 7 Then 
							F = 4 ' // Reset frame
						Else
							If F < 7 Then F = F + 1 Else F = 4
						EndIf
						
						T = GetMilliSecs()
					EndIf
										
					X:+3
					If X >= 570 Then 
						If bEnemies = True Then X = -(14 * sclX) Else Del = True ' // Wrap / kill
					EndIf
				EndIf
				
				Y = Y + YI
				
				' // Player collision
				If Del = False Then
				For Local i:Int = 0 To b2Player
					If ImagesCollide(imgRider[i], Int(p_X[i]), Int(p_Y[i]), p_F[i], imgPter, oldX, oldY, F) Then
						
						' // Get player facing direction
						Local tmpDir:Int = -1
						If (p_F[i] >= 0 And p_F[i] <= 5) Or p_F[i] = 12 Or p_F[i] = 13 Then
							tmpDir = 0
						ElseIf (p_F[i] >= 6 And p_F[i] <= 11) Or p_F[i] = 14 Or p_F[i] = 15 Then
							tmpDir = 1
						EndIf
						
						Local tmpKill:Int = False
						If (tmpDir = 0 And D = 1) Or (tmpDir = 1 And D = 0) Then ' // Kill check
							If Int(p_Y[i] - 4) >= Int(oldY) - 2 And Int(p_Y[i] - 4) <= Int(oldY) + 2 Then
								tmpKill = True
								
								If HC2 = 0 Then
									'p_Score[i] = p_Score[i] + 1000
									AddScore(i, 1000)
								ElseIf HC2 = 1 Then ' // GOLD
									AddScore(i, 2500)
									
									'p_Score[i] = p_Score[i] + 2500
									p_Lives[i]:+1 ' // 1-UP!
									playSFX sfx1Up
								EndIf
								
								playSFX sfxPdie
								A = 1
								Alp = 1
								If D = 0 Then F = 8 ElseIf D = 1 Then F = 9
							EndIf
						EndIf
						
						If tmpKill = False Then ' // Kill player
							objList.Remove o; objC:-1						
							DoRespawn(i)												
						EndIf
						
						Exit
					EndIf
				Next
				EndIf ' // End del check
				
				ElseIf A = 1 Then ' // Dead
					SetBlend ALPHABLEND; SetAlpha Alp
					If HC2 = 0 Then
						DrawImage imgPter, Int(X), Int(Y), F
					ElseIf HC2 = 1 Then ' // Gold
						DrawImage imgGold, Int(X), Int(Y), F
					EndIf
					
					If Alp > 0 Then 
						Alp:-.015 
					Else 
						Alp = 0
						bPter = False; pter_T = GetMilliSecs()
						
						Del = True
					EndIf
					
					SetBlend ALPHABLEND; SetAlpha 1
					
				EndIf
				
			End Select
			
		ElseIf rLayer = 1 Then ' // Front layer
			Select ID

				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² WARP                                        
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
				Case OBJ_WARP ' // Warp in
				SetBlend LIGHTBLEND; SetAlpha Alp
				SetScale sclX, sclY
				
				DrawImage imgWarp, X, Y
				SetBlend ALPHABLEND
				
				If D = 0 Then
					If Alp < .5 Then Alp:+.02 Else D = 1
					partList.AddLast part.Create(Int(X + Int(Rand(0, 23) * sclX)), Int(Y + Int(33 * sclY)), 0, PART_WARP)
				Else
					If Alp > 0 Then Alp:-.02 Else Del = True
				EndIf

				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² FIREBALL                                      
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				Case OBJ_FIREBALL ' // Fireball
				If D = 0 Then ' // Bubble
					SetBlend ALPHABLEND; SetAlpha Alp
					SetScale sclX, sclY; SetColor 240, 188, 60
				
					DrawRect Int(X), Int(Y), 2, 2
				
					If Y > Int(lavaY + lavaC) Then 
						Y = Y - .25 
					Else 
						HC = Int(Y) ' // Splash point
						D = 1; S = Rnd(1, 2); R = Rand(0, 359)
						S2 = Rnd(-.25, .25)
						If S2 > 0 Then A = Rand(5, 15) Else A = Rand(-15, -5)
					EndIf

				ElseIf D = 1 Then ' // Fireball
					SetBlend LIGHTBLEND; SetAlpha .95
					SetScale .6, .6; SetColor 255, 255, 255
					SetRotation R
					DrawImage imgFire, Int(X + 2.5), Int(Y + 2)
					SetRotation 0
								
					Y = Y - S; R = R + A
					X = X + S2
					S = S - .05
					
					If Y >= Int(lavaY + lavaC) Then ' // Create fireball splash
						objList.Remove o; objC = objC - 1 
						tmpR = Rand(3, 5)
						For i = 1 To tmpR
							partList.AddLast part.Create(Int(X + 2), Int(Y - 2), 2, PART_SKID)

						Next
					Else ' // Create fireball particle
						If Rand(0, 1) = 1 Then partList.AddLast part.Create(Int(X + 1.5), Int(Y + 1), 0, PART_FIRE, 0)
					EndIf
				
				EndIf
				
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² FLAME                                    
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				Case OBJ_FLAME ' // Mount
				SetScale sclX, sclY; SetBlend LIGHTBLEND; SetAlpha .95; SetColor 255, 255, 255
				
				If A = 0 Then
					SetBlend ALPHABLEND; SetAlpha 1
					SetColor 0, 0, 0
					If D = 1 Then DrawRect 0, 378, X / sclX + 8, 4 ElseIf D = 0 Then DrawRect X, 378, 90, 4
					SetBlend LIGHTBLEND; SetAlpha .95
				EndIf
				
				SetBlend LIGHTBLEND
				If A = 2 Then SetAlpha Alp Else SetAlpha .95
				SetColor 255, 255, 255
				DrawImage imgFlame, Int(X), Int(lavaY - 32) + lavaC, F
				
				If GetMilliSecs() >= T + 150 Then
					If F < 2 Then F:+1 Else F = 0
					T = GetMilliSecs()
				EndIf
				
				If A = 0 Then ' // Burn bridge
					
					Local tmpA:Int = False
					If D = 0 Then
						If X > (217 * sclX) Then X:-.4 Else tmpA = True; X = 533
					ElseIf D = 1 Then
						If X < Int(32 * sclX) Then X:+.4 Else tmpA = True; X = 38
					EndIf
					
					If tmpA = True Then ' // End transition
						' // NEXT LEVEL FUNC / EVERYWHERE IT'S USED / TITLE / START
						tranC = 0
						waveT = GetMilliSecs()

						CreateWave(waveC)
						
						levelF = 1
						A = 1
					EndIf
					
				ElseIf A = 1 Then ' // Hand
				
				ElseIf A = 2 Then ' // Fade out
					If Alp > 0 Then Alp:-.01 Else Del = True
				EndIf
				
				SetAlpha 1
									
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² MOUNT                                     
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				Case OBJ_MOUNT ' // Mount
				SetScale sclX, sclY; SetBlend ALPHABLEND; SetAlpha 1; SetColor 255, 255, 255
				
				' // Alpha passthrough
				For Local tmpI:Int = 0 To b2Player
					If ImagesCollide(imgRider[tmpI], Int(p_X[tmpI]), Int(p_Y[tmpI]), p_F[tmpI], imgMount, Int(X), Int(Y), F) Then
						SetBlend LIGHTBLEND; SetAlpha .99; Exit 
					Else
						SetBlend ALPHABLEND; SetAlpha 1
					EndIf	
				Next
		
				If HC2 = 1 Then ' // Hunter
					DrawImage imgMount, Int(X), Int(Y), F
				ElseIf HC2 = 2 Then ' // Shadow lord
					DrawImage imgMountS, Int(X), Int(Y), F
				EndIf
				
				SetBlend ALPHABLEND
				
				Local tmpFloat:Int = False ' // Collision cheat

				' // Feet collision
				If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + (3 * sclX)), Int(Y + (16 * sclY)), 10, 1) = False Then
					If R = 0 Then
						YI = -1.5
						If F >= 0 And F <= 3 Then
							F = 9
						ElseIf F >= 4 And F <= 7
							F = 11
						EndIf
					EndIf
					
					If Y > S2 - 8 Then ' // Flap
						If F = 9 Then F = 8 ElseIf F = 11 Then F = 10					

						If GetMilliSecs() >= T + 25 Then
							YI:-.6
							T = GetMilliSecs()
						EndIf
					Else
						' // Frame fix
						If D = 0 And F <> 8 And F <> 9 Then F = 9
						If D = 1 And F <> 10 And F <> 11 Then F = 11
						
						'If GetMilliSecs() >= T + 200 Then
							If F = 8 Then F = 9 ElseIf F = 10 Then F = 11
						'EndIf
						If YI < 2 Then YI:+.1 Else YI = 2
					EndIf
					R = 1
										
				Else
					' // Level with floor
					If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + (3 * sclX)), Int(Y + (15 * sclY)), 10, 1) = True Then 
						If D = 0 Then F = 9 ElseIf D = 1 Then F = 11
						Y:-1
						tmpFloat = True
					EndIf
					
					If R = 1 And tmpFloat = False Then
						R = 0						
						If F = 8 Or F = 9 Then 
							F = 0
						ElseIf F = 10 Or F = 11 Then
							F = 4
						EndIf
						
						T = GetMilliSecs()
					EndIf
					
					YI = 0
				EndIf

				' // Hold before changes
				oldX = Int(X); oldY = Int(Y); oldD = Int(D)
				
				If tmpFloat = False Then			
					If D = 0 Then ' // Left
					
						If GetMilliSecs() >= T + 20 And R = 0 Then
							If F > 3 Then 
								F = 0 ' // Reset frame
							Else
								If F < 3 Then F = F + 1 Else F = 0
							EndIf
							
							T = GetMilliSecs()
						EndIf
							
						If X + Int(2 * sclX) > S Then X:-2
						
					ElseIf D = 1 Then ' // Right
					
						If GetMilliSecs() >= T + 20 And R = 0 Then
							If F < 4 Or F > 7 Then 
								F = 4 ' // Reset frame
							Else
								If F < 7 Then F = F + 1 Else F = 4
							EndIf
							
							T = GetMilliSecs()
						EndIf
											
						If X + Int(4 * sclX) < S Then X:+2
						
					EndIf
				EndIf
				
				Y = Y + YI
				
				' // Captured check
				Local tmpCap:Int = False
				If D = 1 Then
					If oldX + Int(4 * sclX) >= S And oldY + Int(7 * sclY) >= S2 Then tmpCap = True
				ElseIf D = 0 Then
					If oldX + Int(2 * sclX) <= S And oldY + Int(7 * sclY) >= S2 Then tmpCap = True
				EndIf
				
				If tmpCap = True Then ' // Rider captured
					Local tmpHC:Int = HC ' // Delete corresponding rider
					oldType = HC2 ' // Type
					
					' // Delete corresponding rider
					objList.Remove o; objC:-1
					For o:Obj = EachIn objList
						If o.ID = OBJ_EGG And o.A = 2 And o.HC = tmpHC Then objList.Remove o; objC:-1; Exit
					Next
					
					createO = CREATE_BUZZARD ' // Respawn buzzard with rider			
				EndIf
									
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² SPARK                                  
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				Case OBJ_SPARK ' // Spark
				SetScale sclX, sclY; SetBlend LIGHTBLEND; SetAlpha .95; SetColor 255, 255, 255
								
				SetColor 255, 255, 255
				If HC = 0 Then ' // Ice
					DrawImage imgSpark, Int(X), Int(Y), F
				ElseIf HC = 1 Then ' // Fire
					DrawImage imgSpark, Int(X), Int(Y), F + 9
				ElseIf HC = 2 Then ' // Earth
					DrawImage imgSpark, Int(X), Int(Y), F + 18			
				EndIf
				
				If A = 0 Then ' // Spawn
					If GetMilliSecs() >= T + 120 Then
						If F < 4 Then F:+1 Else F = 5; A = 1 ' // Alive
						T = GetMilliSecs()
					EndIf
				
				ElseIf A = 1 Then ' // Alive
					oldX = Int(X); oldY = Int(Y)
					
					If GetMilliSecs() >= T + 60 Then
						If D = 0 Then 
							If F < 8 Then F:+1 Else F = 5
							
							If X <= 19 Then F = 4; A = 2 ' // Despawn
						ElseIf D = 1 Then
							If F > 5 Then F:-1 Else F = 8 
							
							If X >= 550 Then F = 4; A = 2 ' // Despawn						
						EndIf
						
						T = GetMilliSecs()
					EndIf
					
					If S2 = 0 Then ' // Up / Up
						If YI < 0 Then YI:+.05 Else S2 = 1
						
					ElseIf S2 = 1 Then ' // Up / Down				
						If YI < 1 Then YI:+.05 Else S2 = 2 
												
					ElseIf S2 = 2 Then ' // Down / Down
						If YI > 0 Then YI:-.05 Else S2 = 3
					
					ElseIf S2 = 3 Then ' // Down / Up					
						If YI > -1 Then YI:-.05 Else S2 = 0 
						
					EndIf
					
					Y:+YI
					If D = 0 Then X:-2 Else X:+2
					
					Local tmpX1:Int
					If D = 0 Then tmpX1 = 17 ElseIf D = 1 tmpX1 = 0
					'If Rand(0, 1) = 1 Then 
					partList.AddLast part.Create(Int(X + tmpX1), Int(Y + Rand(0, 15)), 0, PART_FIRE, 1 + HC)

					' // Player collision
					If A <> 2 Then ' // Still alive
					For Local i:Int = 0 To b2Player
						If ImagesCollide(imgRider[i], Int(p_X[i]), Int(p_Y[i]), p_F[i], imgSpark, oldX, oldY, F) Then											
							o.A = 2						
							DoRespawn(i)												

							Exit
						EndIf
					Next
					EndIf
					
				ElseIf A = 2 Then ' // Despawn
					If GetMilliSecs() >= T + 120 Then
						T = GetMilliSecs()
						If F > 0 Then F:-1 Else Del = True ' // Delete
					EndIf
									
				EndIf		
				
				SetAlpha 1				

				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² ROCK                                  
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				Case OBJ_ROCK ' // Rock
				SetScale sclX, sclY; SetBlend ALPHABLEND; SetAlpha 1; SetColor 255, 255, 255
								
				DrawImage imgRock, Int(X), Int(Y), F
				
				If GetMilliSecs() >= T + 120 Then
					If D = 1 Then
						If F < 3 Then F:+1 Else F = 0
					ElseIf D  = 0 Then
						If F > 0 Then F:-1 Else F = 3
					EndIf
					T = GetMilliSecs()
				EndIf

				Local oldX:Int = X; oldY:Int = Y
				
				If D = 0 Then
					X:-2
				ElseIf D = 1 Then
					X:+2
				EndIf
				
				If bDebug = True Then
					SetColor 255, 0, 0
					DrawRect Int(X + (5 * sclX)), Int(Y + (16 * sclY)), 6, 1 ' // Bottom
					SetColor 255, 255, 255
				EndIf
				
				If ImageRectCollide(imgLevel, 0, 0, levelF, Int(X + (5 * sclX)), Int(Y + (16 * sclY)), 6, 1) = True And YI > 0 Then
					YI = -2
					PlaySFX sfxBounce
					
					shakeT = GetMilliSecs(); shakeN = 0; shakeD = Rand(0, 3) ' // Screen shake
				Else
					If YI < 4 Then YI:+.05 Else YI = 4
				EndIf
				
				Y:+YI

				For Local i:Int = 0 To b2Player
					If ImagesCollide(imgRider[i], Int(p_X[i]), Int(p_Y[i]), p_F[i], imgRock, oldX, oldY, F) Then											
						DoRespawn(i)												

						Exit
					EndIf
				Next
				
				If D = 0 And X < -37 Then 
					Del = True
				ElseIf D = 1 And X > 588 Then 
					Del = True
				EndIf
				
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² ICE                                 
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				Case OBJ_ICE ' // Ice
				SetScale sclX, sclY; SetBlend LIGHTBLEND; SetAlpha .85; SetColor 255, 255, 255
				
				If A = 1 And GetMilliSecs() >= T + (C2 - 500) Then ' // Shake
					DrawImage imgIce, Int(X) + Rand(-1, 1), Int(Y), F			
				Else
					DrawImage imgIce, Int(X), Int(Y), F
				EndIf
				
				SetBlend ALPHABLEND; SetAlpha 1

				If A <> 0 Then ' // Player col
					For Local i:Int = 0 To b2Player
						If ImagesCollide(imgRider[i], Int(p_X[i]), Int(p_Y[i]), p_F[i], imgIce, Int(X), Int(Y), F) Then											
							DoRespawn(i)												

							Exit
						EndIf
					Next
				EndIf
				
				If A = 0 Then ' // Forming
					If GetMilliSecs() >= T + 350 Then
						If F < 2 Then F:+1 Else F = 2; A = 1
						T = GetMilliSecs()
					EndIf
				
				ElseIf A = 1 Then ' // Hanging
					If GetMilliSecs() >= T + C2 Then A = 2
					
				ElseIf A = 2 Then ' // Falling
					If Y < 354 Then 
						Y:+3 
					Else 
						For Local i:Int = 1 To 15
							partList.AddLast part.Create(Int(X) + 8, Int(Y) + 22, 4, PART_SKID, 0)
						Next
					
						'If ChannelPlaying(iceChan) = False Then 
						iceChan = PlaySFX(sfxIce)
						Del = True
					EndIf
				EndIf

				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				' // ² COMET                              
				' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
				Case OBJ_COMET ' // COMET
				SetScale sclX, sclY; SetBlend LIGHTBLEND; SetAlpha .95; SetColor 255, 255, 255

				DrawImage imgComet, X, Y, F
				SetBlend ALPHABLEND; SetAlpha 1

				If GetMilliSecs() >= T + 80 Then				
					If D = 0 Then
						If F < 1 Then F:+1 Else F = 0
					ElseIf D = 1 Then
						If F < 3 Then F:+1 Else F = 2						
					EndIf
					
					T = GetMilliSecs()
				EndIf
				
				For Local i:Int = 1 To 2
				If D = 0 Then
					partList.AddLast part.Create(Int(X) + Rand(11, 16), Int(Y) + 20, 0, PART_FIRE, 1)
				ElseIf D = 1 Then
					partList.AddLast part.Create(Int(X) + Rand(18, 23), Int(Y) + 20, 0, PART_FIRE, 1)			
				EndIf
				Next
				
				Y:+3
				If D = 0 Then 
					If X > -37 Then X:-3 Else Del = True
					
				ElseIf D = 1 Then 
					If X < 588 Then X:+3 Else Del = True
				EndIf
				
				If Del = False Then
					If ImagesCollide(imgComet, Int(X), Int(Y), F, imgLevel, 0, 0, levelF) Then											
						Local tmpOff:Int = 9
						If D = 1 Then tmpOff = 25
						For Local i:Int = 1 To 30
							partList.AddLast part.Create(Int(X) + tmpOff, Int(Y) + 20, 5, PART_SKID, 0)
						Next
						
						shakeT = GetMilliSecs(); shakeN = 0; shakeD = Rand(0, 3) ' // Screen shake
					
						PlaySFX sfxCrash
						Del = True
					EndIf
				EndIf
				
				If Del = False Then ' // Player collision
					For Local i:Int = 0 To b2Player
						If ImagesCollide(imgRider[i], Int(p_X[i]), Int(p_Y[i]), p_F[i], imgComet, Int(X), Int(Y), F) Then											
							DoRespawn(i)												
							Exit
						EndIf
					Next
				EndIf								
				
			End Select
			
		EndIf	
	
		If Del = True Then objList.Remove o; objC = objC - 1
		
		If createO <> 0 Then ' // Create other objects
			If createO = CREATE_EGG Then ' // Create egg
				Local myEx2:Int = oldType
				If oldType < 2 Then oldType:+1 ' // Type
				objList.AddLast obj.Create(oldX + Int(4 * sclX), oldY + Int(8 * sclY), Int(oldD), OBJ_EGG, oldEx, oldType)

			ElseIf createO = CREATE_MOUNT ' // Create Mount
				objList.AddLast obj.Create(oldX, oldY, Int(oldD), OBJ_MOUNT, oldEx, oldType)
			
			ElseIf createO = CREATE_BUZZARD ' // Create Buzzard
				objList.AddLast obj.Create(oldX, oldY - Int(8 * sclY), oldType, OBJ_BUZZARD, oldD + 1)

			EndIf	

		EndIf
				
	End Method
	
End Type

LoadImages(bFilter) ' // Load all images
If bTitle = False Then NewGame False

SetBlend ALPHABLEND
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² MAIN
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Repeat
	frameTimer = GetMilliSecs()
	If bWindowed = False Then SetOrigin 26, 16 ' // Fullscreen
	SetScale sclX, sclY; SetColor 255, 255, 255
	
	' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
	' // ² TITLE                                       
	' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
	If bTitle = True Then ' // Title
		If tScreen <> 4 And tScreen <> 5 Then DrawImage imgTitle, 0, 0 ' // Background
		
		'SetScale 2, 2; SetColor 255, 255, 0
		'DrawText "X: " + Left$(String(sclX), 5) + ", " + Left$(String(sclY), 5), 0, 0

		Local tmpY:Int, tmpS:String

		If tScreen = 0 Then ' // Title
			SetColor 252, 252, 252
			DrawFont "  1 Player", -1, Int(89 * sclY)
			DrawFont "  2 Player", -1, Int(105 * sclY)
			DrawFont "  Arena   ", -1, Int(121 * sclY)
			DrawFont "  Hi Score", -1, Int(137 * sclY)
			DrawFont "  Options ", -1, Int(153 * sclY)
			DrawFont "  End Game", -1, Int(169 * sclY)
			SetColor 255, 255, 255
			
			If tSel = 0 Then tmpY = 89 ElseIf tSel = 1 Then tmpY = 105 ElseIf tSel = 2 Then tmpY = 121 ElseIf tSel = 3 Then tmpY = 137 ElseIf tSel = 4 Then tmpY = 153 ElseIf tSel = 5 Then tmpY = 169 ' // Selection
			DrawImage imgEgg, 208, Int(tmpY * sclY)
			
		ElseIf tScreen = 2 Then ' // Options
			SetColor 252, 252, 252
			DrawFont "  SFX     ", -1, Int(89 * sclY)
			DrawFont String(cfgSFX * 10) + "%", 362, Int(89 * sclY)		
			DrawFont "  Music   ", -1, Int(105 * sclY)
			DrawFont String(cfgMusic * 10) + "%", 362, Int(105 * sclY)
			DrawFont "  Filter  ", -1, Int(121 * sclY)
			If cfgFilter = 0 Then tmpS$ = "Off" Else tmpS$ = "On"
			DrawFont tmpS$, 362, Int(121 * sclY)			
			DrawFont "  CRT     ", -1, Int(137 * sclY)
			If cfgCRT = 0 Then tmpS$ = "0%" ElseIf cfgCRT = 1 Then tmpS$ = "25%" ElseIf cfgCRT = 2 Then tmpS$ = "50%" ElseIf cfgCRT = 3 Then tmpS$ = "75%" ElseIf cfgCRT = 4 Then tmpS$ = "100%"
			DrawFont tmpS$, 362, Int(137 * sclY)					
			If cfgFull = 0 Then
				DrawFont "  Window  ", -1, Int(153 * sclY)
			Else
				DrawFont "  Full    ", -1, Int(153 * sclY)
			EndIf
			DrawFont "  Colors  ", -1, Int(169 * sclY)
			DrawFont "  Back    ", -1, Int(185 * sclY)
			SetColor 255, 255, 255

			If tSel = 0 Then tmpY = 89 ElseIf tSel = 1 Then tmpY = 105 ElseIf tSel = 2 Then tmpY = 121 ElseIf tSel = 3 Then tmpY = 137 ElseIf tSel = 4 Then tmpY = 153 ElseIf tSel = 5 Then tmpY = 169 ElseIf tSel = 6 Then tmpY = 185 ' // Selection
			DrawImage imgEgg, 208, Int(tmpY * sclY)
		
		ElseIf tScreen = 3 Then ' // Colors		
			SetColor 252, 252, 252
			DrawFont " Player " + String(tPlayer + 1), -1, Int(76 * sclY) 
			DrawFont " Save ", -1, Int(153 * sclY)
			DrawFont " Reset", -1, Int(169 * sclY)
			DrawFont " Back ", -1, Int(185 * sclY)

			' // Palette border
			SetColor 255, 255, 255
			DrawRect 120, 248, 152, 1
			DrawRect 467, 249, 1, 21
			DrawRect 120, 290, 152, 1
			DrawRect 120, 249, 1, 21
			
			Local tmpOffY:Int = 0
			If bWindowed = False Then tmpOffY = 16
			DrawPixmap pixRiderP[tPlayer], (GraphicsWidth() / 2) - Int(8 * sclX), Int(92 * sclY) + tmpOffY
			
			'DrawFont "Color 1", -1, Int(136 * sclY)
			DrawImage imgPal, 294 - Int(75 * sclX), Int(125 * sclY)
			
			If tSel = 0 Then
				DrawImage imgEgg, Int(tselX), Int(tselY)
			Else
				If tSel = 1 Then 
					DrawImage imgEgg, 226, Int(153 * sclY)
				ElseIf tSel = 2 Then 
					DrawImage imgEgg, 226, Int(169 * sclY)
				ElseIf tSel = 3 Then
					DrawImage imgEgg, 226, Int(185 * sclY)				
				EndIf
			EndIf
						
			ColorRider(tPlayer, Int(tselX - 126), Int(tselY - 252))
		
		ElseIf tScreen = 4 Then ' // Hi Scores
			
			RenderHiBorder()
			
			SetScale 1, 1; SetColor 255, 255, 255
			DrawImage imgMenu, 475, 20, bOnline
			SetScale sclX, sclY
			
			If bOnline = True Then ' // Arrows
				If netP > 0 Then DrawFont "$", 531, 53
				If netP < 90 Then DrawFont "+", 531, 404
				
			EndIf
						
			If bOnline = False Then ' // Local
				' // Draw riders and scores
				Local tmpY:Int = 53
				For Local i:Int = 0 To 9
					If i = 0 Then 
						If (i = (place1 - 1) Or i = (place2 - 1)) Then SetColor 122, 213, 241 Else SetColor 251, 255, 134
					Else
						If (i = (place1 - 1) Or i = (place2 - 1)) Then SetColor 122, 213, 241 Else SetColor 252, 252, 252
					EndIf
									
					DrawFont RSet(String(i + 1), 2) + ".   " + Upper(hi_Name$[i]) + "  " + NumFormat(hi_Score[i]), 105, tmpY

					' // Draw rider
					SetColor 255, 255, 255
					'SetScale 1.75, 1.75
					DrawImage hi_Img[i], 163, tmpY - 7
					'SetScale sclX, sclY
					tmpY:+39
				Next
		
			ElseIf bOnline = True Then ' // Online

				' // Draw online scores
				Local tmpY:Int = 53
				For Local i:Int = netP To netP + 9
					If i = 0 Then 
						SetColor 251, 255, 134
					Else
						SetColor 252, 252, 252
					EndIf
									
					DrawFont RSet(String(i + 1), 3) + ". " + Upper(Right(net_Score[i], 6)) + "  " + NumFormat(Left(net_Score[i], Len(net_Score[i]) - 7)), 105, tmpY

					tmpY:+39
				Next
							
			EndIf
			
		ElseIf tScreen = 5 Then ' // Enter name screen
		
			RenderHiBorder()

			SetColor 252, 252, 252
			Local tmpP:String = "Player 1"
			If tPlayer = PLAYER_2 Then tmpP$ = "Player 2"
			
			DrawFont "Enter thy name, " + tmpP$ + "!", -1, 68
			If tSelX = 414 And tSelY = 311 Then
				SetColor 251, 252, 134
			Else
				SetColor 252, 252, 252
			EndIf
			DrawFont "END", 414, 311
			If tSelX = 414 And tSelY = 343 Then
				SetColor 251, 252, 134
			Else
				SetColor 252, 252, 252
			EndIf			
			DrawFont "UPLOAD", 414, 343
			
			SetColor 252, 252, 252
			DrawFont hi_Entry$, -1, 361
			'SetColor 251, 252, 134
			DrawFont "#" + String(hi_Place) + " Score: " + NumFormat(p_Score[tPlayer]), -1, 393
			SetColor 255, 255, 255
			
			Local tmpA:Int = 65
			For Local tmpY:Int = 119 To 311 Step 64
				For Local tmpX:Int = 94 To 496 Step 64
					If tSelX = tmpX And tSelY = tmpY Then ' // Current letter
						SetColor 251, 255, 134
						hi_A = tmpA
					Else
						SetColor 252, 252, 252
					EndIf
					DrawFont Chr(tmpA), tmpX, tmpY
					If tmpA < 90 Then tmpA:+1 Else Exit
				Next
				If tmpA = 90 Then Exit
			Next
			
			If (tSelX = 414 And tSelY = 311) Or (tSelX = 414 And tSelY = 343) Then
			Else
				SetScale sclX / 2, sclY / 2
				Local matrix:SMat4D = SMat4D.Identity()
				matrix = matrix.Translate(New SVec3D(0, 0, -6))
				matrix = matrix.Rotate(New SVec3D(0, 0, 1), hiAZ * 1.2)
				matrix = matrix.Rotate(New SVec3D(0, 1, 0), hiAY * 0.7)
				matrix = matrix.Rotate(New SVec3D(1, 0, 0), hiAX)
		
				hiAxis.Draw(matrix, 9.25, Int(tselX) + 6, Int(tselY) + 7)
				SetScale sclX, sclY; SetColor 255, 255, 255
				hiAZ:+1'; hiAY:+1; hiAZ:+1
			EndIf
			
			DebugLog "TSelX: " + tSelX + " TSelY: " + tSelY
			
		EndIf
		
		If tScreen = 0 Then
			SetColor 200, 76, 12		
			'SetColor 60, 188, 252
			DrawFont "2023 EikSoft", -1, Int(193 * sclY)
			SetColor 252, 152, 56
			'SetColor 196, 212, 252
			DrawFont "www.EikSoft.com", -1, Int(201 * sclY)
			SetColor 252, 188, 176
			'SetColor 252, 252, 252
			DrawFont "For JB", -1, Int(209 * sclY)
			
		EndIf
		
		Local bJoyUp:Int = -1
		Local bJoyDown:Int = -1
		Local bJoyLeft:Int = -1
		Local bJoyRight:Int = -1
		
		' // Up
		If GetInput(PLAYER_1, INP_U) = True And bJoy1YHit = False Then bJoyUp = PLAYER_1; secretC$:+"U" 
		If GetInput(PLAYER_2, INP_U) = True And bJoy2YHit = False Then bJoyUp = PLAYER_2
				
		' // Down
		If GetInput(PLAYER_1, INP_D) = True And bJoy1YHit = False Then bJoyDown = PLAYER_1; secretC$:+"D"
		If GetInput(PLAYER_2, INP_D) = True And bJoy2YHit = False Then bJoyDown = PLAYER_2
				
		' // Left
		If GetInput(PLAYER_1, INP_L) = True And bJoy1XHit = False Then bJoyLeft = PLAYER_1; secretC$:+"L"
		If GetInput(PLAYER_2, INP_L) = True And bJoy2XHit = False Then bJoyLeft = PLAYER_2
		
		' // Right
		If GetInput(PLAYER_1, INP_R) = True And bJoy1XHit = False Then bJoyRight = PLAYER_1; secretC$:+"R"
		If GetInput(PLAYER_2, INP_R) = True And bJoy2XHit = False Then bJoyRight = PLAYER_2

		'If KeyHit(Key1Up) Or (JoyY(0) = -1 And bJoy1YHit = False) Then bJoyUp = PLAYER_1; secretC$:+"U"
		'If KeyHit(Key2Up) Or (JoyY(1) = -1 And bJoy2YHit = False) Then bJoyUp = PLAYER_2
		'If KeyHit(Key1Down) Or (JoyY(0) = 1 And bJoy1YHit = False) Then bJoyDown = PLAYER_1; secretC$:+"D"
		'If KeyHit(Key2Down) Or (JoyY(1) = 1 And bJoy2YHit = False) Then bJoyDown = PLAYER_2
		'If KeyHit(Key1Left) Or (JoyX(0) = -1 And bJoy1XHit = False) Then bJoyLeft = PLAYER_1; secretC$:+"L"
		'If KeyHit(Key2Left) Or (JoyX(1) = -1 And bJoy2XHit = False) Then bJoyLeft = PLAYER_2
		'If KeyHit(Key1Right) Or (JoyX(0) = 1 And bJoy1XHit = False) Then bJoyRight = PLAYER_1; secretC$:+"R"
		'If KeyHit(Key2Right) Or (JoyX(1) = 1 And bJoy2XHit = False)	Then bJoyRIght = PLAYER_2

		If bJoyUp <> -1 Then
			'If sclY > 1 Then sclY:-.01 Else sclY = 1
			
			If tScreen = 3 Then
			
				If tPlayer = bJoyUp Then ' // Only allow target player
					If tSel = 0 Then
						If tselY > 252 Then tSelY:-20 Else tselY = 252; tSel = 0
					Else
						If tSel = 1 Then
							If tCol = 0 Then ' // Select color
								SeekColor(p_Col1[tPlayer]) 
							ElseIf tCol = 1 Then
								SeekColor(p_Col2[tPlayer])
							ElseIf tCol = 2 Then
								SeekColor(p_Col3[tPlayer])
							EndIf
						EndIf
						
						If tSel > 0 Then tSel:-1 Else tSel = 0
					EndIf
				EndIf
				
			ElseIf tScreen = 5 ' // Name Entry
			
				If tPlayer = bJoyUp Then ' // Only allow target player
					If tSelY > 119 Then 
						If tSelY = 343 Then tSelY:-32 Else tSelY:-64
					EndIf
				EndIf
			
			ElseIf tScreen = 4 Then ' // Online score scroll
			
				If bOnline = True And netP > 0 Then netP:-10

			Else
				If tSel > 0 Then tSel = tSel - 1 Else tSel = 0
			EndIf
			
			bJoy1YHit = True
			bJoy2YHit = True
						
		ElseIf bJoyDown <> -1 Then
			Local tmpLim:Int

			If tScreen = 3 Then
			
				If tPlayer = bJoyDown Then ' // Only allow target player
					If tSel = 0 Then
						If tselY < 272 Then 
							tselY:+20 
						Else 
							tselY = 272; tSel:+1
							
							If tCol = 0 Then ' // Select color
								SeekColor(p_Col1[tPlayer]) 
							ElseIf tCol = 1 Then
								SeekColor(p_Col2[tPlayer])
							ElseIf tCol = 2 Then
								SeekColor(p_Col3[tPlayer])
							EndIf
													
						EndIf
						
					Else
						If tSel < 3 Then tSel:+1 Else tSel = 3					
					EndIf
				EndIf
				
			ElseIf tScreen = 5 ' // Name entry
				
				If tPlayer = bJoyDown Then ' // Only allow target player
					If tSelX = 478 And tSelY = 247 Then ' // End
						tSelX = 414; tSelY = 311
					ElseIf tSelX = 414 And tSelY = 311 Then ' // Upload
						tSelX = 414; tSelY = 343
					Else
						If tSelY < 311 Then tSelY:+64
					EndIf
				EndIf
			
			ElseIf tScreen = 4 Then ' // Online score scroll
				
				If bOnline = True And netP < 90 Then netP:+10
				
			Else
				If tScreen = 0 Then tmpLim = 5 ElseIf tScreen = 2 Then tmpLim = 6
				If tSel < tmpLim Then tSel = tSel + 1 Else tSel = tmpLim
			EndIf		
			
			bJoy1YHit = True
			bJoy2YHit = True
			'sclY:+.01
		ElseIf bJoyLeft <> -1 Then
		
			If tScreen = 3 Then ' // Only allow target player
				If tSel = 0 And (tPlayer = bJoyLeft) Then
					If tselX > 126 Then tselX:-23 Else tselX = 126
				EndIf
			
			ElseIf tScreen = 5 Then ' // Name entry
			
				If tPlayer = bJoyLeft Then ' // Only allow target player
					If tSelX = 414 And tSelY = 343 Then
					Else
						If tSelX > 94 Then tSelX:-64
					EndIf
				EndIf
				
			EndIf
			
			bJoy1XHit = True
			bJoy2XHit = True			
			'If sclX > 1 Then sclX:-.01 Else sclX = 1
			
		ElseIf bJoyRight <> -1 Then
		
			If tScreen = 3 Then
				If tSel = 0 And (tPlayer = bJoyRight) Then
					If tselX < 448 Then tselX:+23 Else tselX = 448
				EndIf
				
			ElseIf tScreen = 5 Then ' // Name entry

				If tPlayer = bJoyRight Then ' // Only allow target player
					If (tSelX = 414 And tSelY = 311) Or (tSelX = 414 And tSelY = 343) Then
					Else
						If tSelX < 478 Then tSelX:+64
					EndIf
				EndIf
							
			EndIf
			
			bJoy1XHit = True
			bJoy2XHit = True			
			
			DebugLog tselX
			'sclX:+.01
		EndIf
		
		Local bJoyHit:Int = -1
		Local bJoyAHit:Int = -1
		
		If bLoopback = True Then ' // JOYSTICK BUG FIX
			FlushJoy 0
			FlushJoy 1
			bJoyHit = -1
			bJoyAHit = -1
		EndIf
		
		' // B Button
		If GetInput(PLAYER_1, INP_B, 0) = True Or GetInput(PLAYER_1, INP_S, 0) = True Then bJoyHit = PLAYER_1
		If GetInput(PLAYER_2, INP_B, 0) = True Or GetInput(PLAYER_2, INP_S, 0) = True Then bJoyHit = PLAYER_2
		
		'If JoyHit(Joy1B, 0) = True Or JoyHit(Joy1Start, 0) = True Or KeyHit(Key1B) = True Or KeyHit(Key1Start) = True Then bJoyHit = PLAYER_1 ' // Joy 1
		'If JoyHit(Joy2B, 1) = True Or JoyHit(Joy2Start, 1) = True Or KeyHit(Key2B) = True Or KeyHit(Key2Start) = True Then bJoyHit = PLAYER_2 ' // Joy 2

		' // A Button
		If GetInput(PLAYER_1, INP_A, 0) = True Then bJoyAHit = PLAYER_1; secretC$:+"A"
		If GetInput(PLAYER_2, INP_A, 0) = True Then bJoyAHit = PLAYER_2
				
		'If JoyHit(Joy1A, 0) = True Or KeyHit(Key1A) = True Then bJoyAHit = PLAYER_1; secretC$:+"A" ' // Joy 1
		'If JoyHit(Joy2A, 1) = True Or KeyHit(Key2A) = True Then bJoyAHit = PLAYER_2 ' // Joy 2
		
		'DebugLog "JOYHIT: " + bJoyHit
		
		If tScreen = 3 Or tScreen = 5 ' // Ignore non target player
			If tPlayer = PLAYER_1 And (bJoyHit = PLAYER_2 Or bJoyAHit = PLAYER_2) Then bJoyHit = -1; bJoyAHit = -1
			If tPlayer = PLAYER_2 And (bJoyHit = PLAYER_1 Or bJoyAHit = PLAYER_1) Then bJoyHit = -1; bJoyAHit = -1
		EndIf
				
		'DebugLog "x: " + tSelX + ", y: " + tSelY
		
		If bJoyAHit <> -1 Then ' // A Button
		
			If tScreen = 5 Then ' // Name entry backspace
				If Len(hi_Entry) > 0 Then
					hi_Entry = Left$(hi_Entry, Len(hi_Entry) - 1)
					playSFX sfxBump

				Else ' // Empty
				EndIf
				
				FlushKeys
				FlushJoy bJoyAHit
			
			ElseIf tScreen = 4 Then ' // Score switch
				If bOnline = False Then 
					
					For Local i:Int = 0 To 99 ' // Clear
						net_Score[i] = ""
					Next

					' // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
					' // CODE REMOVED TO KEEP ONLINE SCORES SECURE
					' // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

					PlaySFX sfxPter
											
				Else
					PlaySFX sfxEgg2
					bOnline = False
					
				EndIf
			
				FlushKeys
				FlushJoy bJoyAHit
				
			EndIf
			
		EndIf
				
		If bJoyHit <> -1 Then ' // Select
			
			If tScreen = 0 Then ' // Title
				If tSel = 0 Then ' // 1 player				
					PlaySFX sfxEgg2
					NewGame False ' // Start one player game
					
					FlushKeys
					FlushJoy bJoyHit
					
				ElseIf tSel = 1 Then ' // 2 player				
					PlaySFX sfxEgg2
					NewGame True
					
					FlushKeys
					FlushJoy bJoyHit
					
				ElseIf tSel = 2 Then ' // Arena
				
				ElseIf tSel = 3 Then ' // Hi score
					PlaySFX sfxEgg2
					LoadScores()
					tScreen = 4; tSel = 0
					champF = 0; champT = GetMilliSecs()
					hi_Col = 0; hi_T = GetMilliSecs()
					place1 = -1; place2 = -1
					
					FlushKeys
					FlushJoy bJoyHit
					
				ElseIf tSel = 4 Then ' // Options
					tScreen = 2; tSel = 0
					playSFX sfxEgg2

					FlushKeys
					FlushJoy bJoyHit								
					
				ElseIf tSel = 5 Then ' // End game
					EndGame
				EndIf
				
			ElseIf tScreen = 2 Then ' // Options
			
				If tSel <> 0 Then playSFX sfxEgg2

				If tSel = 0 Then ' // SFX
					If cfgSFX < 10 Then cfgSFX = cfgSFX + 1 Else cfgSFX = 0
					PlaySFX(sfxBump)
					
				ElseIf tSel = 1 Then ' // Music
					If cfgMusic < 10 Then cfgMusic = cfgMusic + 1 Else cfgMusic = 0
					musChan.SetVolume(Float(cfgMusic) / 10)

				ElseIf tSel = 2 Then ' // Filter
					If cfgFilter = 0 Then cfgFilter = 1; LoadImages(True) Else cfgFilter = 0; LoadImages(False)					
				ElseIf tSel = 3 Then ' // CRT
					If cfgCRT < 4 Then cfgCRT = cfgCRT + 1 Else cfgCRT = 0
					crtMode = cfgCRT
				ElseIf tSel = 4 Then ' // Full				
					If cfgFull = 0 Then cfgFull = 1 Else cfgFull = 0
				ElseIf tSel = 5 Then ' // Colors
					tPlayer = bJoyHit
					DebugLog "tplayer: " + bJoyHit
					
					o_Col1[tPlayer] = p_Col1[tplayer] ' // Hold old values
					o_Col2[tPlayer] = p_Col2[tplayer]
					o_Col3[tPlayer] = p_Col3[tplayer]
					
					pixRiderP[tPlayer] = Null
					pixRiderP[tPlayer] = LoadPixmap("gfx/rider" + String(tPlayer + 1) + "p.png") ' // Reset palette
					
					tScreen = 3; tSel = 0; tselX = 126; tselY = 252; tCol = 0
					SeekColor(p_Col1[tPlayer]) ' // Select color

					FlushKeys
					FlushJoy bJoyHit

				ElseIf tSel = 6 Then ' // Back
					tScreen = 0; tSel = 0

					FlushKeys
					FlushJoy bJoyHit
					
				EndIf
				
			ElseIf tScreen = 3 Then ' // Colors
			
				If tSel = 0 Then ' // Color selecter
					If tCol < 2 Then
						If tCol = 0 Then
							p_Col1[tPlayer] = curCol
						ElseIf tCol = 1 Then
							p_Col2[tPlayer] = curCol
						EndIf
						
						tCol:+1; tselX = 126; tselY = 252
						If tCol = 1 Then
							SeekColor(p_Col2[tPlayer]) ' // Select color
						ElseIf tCol = 2 Then
							SeekColor(p_Col3[tPlayer]) ' // Select color
						EndIf
						PlaySFX sfxEgg2
					 
					Else
						p_Col3[tPlayer] = curCol

						PlaySFX sfxEgg2
						tCol = 2
						tSel = 1
					EndIf
				Else
					If tSel = 1 Then ' // Save
						SaveCol(tPlayer) ' // Save changes to file

						tScreen = 0; tSel = 0
						FlushKeys
						FlushJoy bJoyHit
						playSFX sfxEgg2
												
					ElseIf tSel = 2 Then ' // Reset
						If tPlayer = PLAYER_1 Then
							p_Col1[PLAYER_1] = -3650548
							p_Col2[PLAYER_1] = -16717608
							p_Col3[PLAYER_1] = -1000388
												
						ElseIf tPlayer = PLAYER_2 Then
							p_Col1[PLAYER_2] = -3650548
							p_Col2[PLAYER_2] = -1000388
							p_Col3[PLAYER_2] = -16717608
						EndIf
						
						tCol = 0
						SeekColor(p_Col1[tPlayer]) ' // Select color
						ColorRider(tPlayer, 0, 0, True) ' // Color all
						
						FlushKeys
						FlushJoy bJoyHit
						playSFX sfxEgg2

					ElseIf tSel = 3 Then ' // Back
						p_Col1[tPlayer] = o_Col1[tPlayer] ' // Revert color changes
						p_Col2[tPlayer] = o_Col2[tPlayer]
						p_Col3[tPlayer] = o_Col3[tPlayer]

						tScreen = 0; tSel = 0
						FlushKeys
						FlushJoy bJoyHit
						playSFX sfxEgg2
						
					EndIf
					
				EndIf			
			
			ElseIf tScreen = 4 Then ' // Hi Scores	
				
				tScreen = 0; tSel = 0; bOnline = False
				FlushKeys
				FlushJoy bJoyHit
				playSFX sfxEgg2
			
			ElseIf tScreen = 5 Then ' // Name entry
			
				Local bDone:Int = False
				
				If (tSelX = 414 And tSelY = 311) Or (tSelX = 414 And tSelY = 343) Then ' // End / Upload
					
					If hi_Entry$ = "" Then hi_Entry$ = "JOUSTX" ' // Blank check
					
					FlushKeys
					FlushJoy 0
					FlushJoy 1
					
					Local oldTSelX:Int = tSelX, oldTSelY:Int = tSelY
					Local oldTPlayer:Int = tPlayer, oldEntry:String = hi_Entry$
					
					If tPlayer = PLAYER_1 Then
						SaveScores hi_Entry$, p_Score[PLAYER_1], PLAYER_1
						LoadScores()
						
						If b2Player = True Then
							If p_Score[PLAYER_2] > hi_Score[9] Then
								hi_Place = GetScoreNum(p_Score[PLAYER_2]) ' // Placement
								If hi_Place <> 0 Then								
									tPlayer = PLAYER_2
									tSelX = 94; tSelY = 119
									hi_Entry$ = ""
									place2 = hi_Place
									If place2 <= place1 Then place1:+1 ' // Offset
								Else
									place2 = -1
									tScreen = 4
								EndIf
							Else ' // End
								place2 = -1					
								tScreen = 4							
							EndIf 
						Else ' // End
							place2 = -1					
							tScreen = 4							
						EndIf
										
					ElseIf tPlayer = PLAYER_2
						hi_Place = GetScoreNum(p_Score[PLAYER_2])
						If hi_Place <> 0 Then place2 = hi_Place Else place2 = -1
						SaveScores hi_Entry$, p_Score[PLAYER_2], PLAYER_2
						LoadScores()
						tScreen = 4
						
					EndIf
					
					If (oldTSelX = 414 And oldTSelY = 343) Then ' // Upload score
						If oldEntry$ = "" Then oldEntry$ = "JoustX"
						uploadChan = PlaySound(sfxRespawn)					
						UploadScore(p_Score[oldTPlayer] + " " + LSet(oldEntry$, 6))						
						StopChannel uploadChan
						
					EndIf
					
				Else ' // Letter			
					If Len(hi_Entry) < 5 Then
						hi_Entry = hi_Entry + Chr(hi_A)
					Else ' // Move to end
						If Len(hi_Entry) = 5 Then hi_Entry = hi_Entry + Chr(hi_A)
						tSelX = 414; tSelY = 311
					EndIf
				EndIf
				
				FlushKeys
				FlushJoy bJoyHit
				playSFX sfxEgg2
				
			EndIf
			
		EndIf
		
		'If KeyHit(KEY_F3) Then sclX = 1; sclY = 1 ' // Reset scale
		
		' // Reset joysticks
		If JoyY(p1Joy) <= .5 And JoyY(p1Joy) >= -.5 Then 
			bJoy1YHit = False ' // Reset joystick
		EndIf
		
		If JoyX(p1Joy) <= .5 And JoyX(p1Joy) >= -.5 Then 
			bJoy1XHit = False ' // Reset joystick
		EndIf
		
		If JoyY(p2Joy) <= .5 And JoyY(p2Joy) >= -.5 Then 
			bJoy2YHit = False ' // Reset joystick
		EndIf
		
		If JoyX(p2Joy) <= .5 And JoyX(p2Joy) >= -.5 Then 
			bJoy2XHit = False ' // Reset joystick
		EndIf
		
		GetFuncInput()

		' // Secret code
		If Right$(secretC$, 10) = "UUDDLLRRAA" Then
			PlaySFX sfx1Up
			bSecret = True
			secretC$ = ""
		EndIf
		
		If bLoopback = True And Upper$(hi_Entry$) = "A" Then hi_Entry$ = "" ' // Bug fix
		bLoopback = False
		
	' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
	' // ² GAME
	' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //		
	Else ' // Game
		'SetScale 1, 1
		'DrawImage imgBack1, 0, 0
		
		SetBlend ALPHABLEND
		SetScale sclX, sclY; SetColor 255, 255, 255; SetAlpha 1	
	
		If IsMoon() = True Or (waveC = 1 And tranC = 1) Then ' // Stars
			'SetColor 255, 255, 255
			'DrawImage starImage, 64, 64
			'DrawImage starImage2, 128, 0
			
			For Local s:Star = EachIn stars
				s.update(star_speed)
				s.render()
			Next

			If bWindowed = False Then SetOrigin 26, 16 ' // Fullscreen
			SetBlend ALPHABLEND; SetAlpha 1; SetColor 255, 255, 255
			SetScale sclX, sclY
			
			If tranC = 1 Then ' // Black out during transition
				SetColor 0, 0, 0
				DrawRect 0, 378, 588, 70
				SetColor 255, 255, 255	
			EndIf
		EndIf
		
		If levelF <= 1 Then 
			RenderLava(0) ' // Lava waves
		ElseIf levelF >= 6 Then
			'RenderLava(1) ' // Water waves
		EndIf	
		
		If (waveC = 1 And tranC = 1) Or (waveC = 6 And tranC = 1) Or (waveC = 11 And tranC = 1) Or (waveC = 16 And tranC = 1) Then ' // Level transitions (blend)
			SetBlend ALPHABLEND
			SetAlpha levelA1; DrawImage imgLevel, 0, 0, levelF
			If waveC = 1 Then ' // Moon to lava
				SetAlpha levelA2; DrawImage imgLevel, 0, 0, 0
			Else
				SetAlpha levelA2; DrawImage imgLevel, 0, 0, levelF + 1
			EndIf
			SetBlend ALPHABLEND
			SetAlpha 1	

		ElseIf (waveC = 7 Or waveC = 9 Or waveC = 12 Or waveC = 13 Or waveC = 17 Or waveC = 18) And tranC = 1 Then ' // Remove platforms
			SetBlend LIGHTBLEND
			SetAlpha levelA1; DrawImage imgLevel, 0, 0, levelF
			SetAlpha levelA2; DrawImage imgLevel, 0, 0, levelF + 1
			SetBlend ALPHABLEND
			SetAlpha 1	
		
		ElseIf (waveC = 10 Or waveC = 15 Or waveC = 20) And tranC = 1 Then ' // Add platforms
			SetBlend LIGHTBLEND
			SetAlpha levelA1; DrawImage imgLevel, 0, 0, levelF
			SetAlpha LevelA2; DrawImage imgLevel, 0, 0, levelF + 1
			SetBlend ALPHABLEND			
			SetAlpha 1	
		Else
			If shakeN <> -1 Then ' // Screen shake
				If GetMilliSecs() >= shakeT + 25 Then
					Local tmpI:Int
					Repeat
						tmpI = Rand(0, 3)
					Until tmpI <> shakeD
					shakeD = tmpI
					If shakeN < 5 Then shakeN:+1 Else shakeN = -1
					shakeT = GetMilliSecs()
				EndIf
				
				Select shakeD
					Case 0 ' // Up
					DrawImage imgLevel, 0, -1, levelF
					
					Case 1 ' // Down
					DrawImage imgLevel, 0, 1, levelF
					
					Case 2 ' // Left
					DrawImage imgLevel, -1, 0, levelF
					
					Case 3 ' // Right
					DrawImage imgLevel, 1, 0, levelF
					
				End Select
				
			Else
				DrawImage imgLevel, 0, 0, levelF
			EndIf
		EndIf
		
		For o:Obj = EachIn objList; o.Render(0); Next ' // Back objects
		SetScale sclX, sclY; SetColor 255, 255, 255; SetBlend ALPHABLEND; SetAlpha 1
		
		' // RENDER PLAYERS
		If GetMilliSecs() >= waveT + 1000 Or waveC > 1 Or (waveC = 1 And levStar > 0) Then ' // Initial Spawn delay

			' // First spawn
			If bSpawn = False Then ' // First spawn
				PlaySFX(sfxSpawn); p_Lives[0]:-1; bSpawn = True 
				
				If b2Player = True Then p_Lives[1]:-1; FlushJoy(1)
				FlushKeys; FlushJoy(0)
				
			Else ' // Render players
			
				If p_GameOver[PLAYER_1] = False Then RenderPlayer(PLAYER_1)
				If b2Player = True And p_GameOver[PLAYER_2] = False Then RenderPlayer(PLAYER_2)

			EndIf		
			
		EndIf
		
		For o:Obj = EachIn objList; o.Render(1); Next ' // Front objects
		
		If (levelF >= 6 And levelF <= 9) Or (waveC = 11 And tranC = 1) Then ' // Waterfalls
			SetBlend LIGHTBLEND; SetScale sclX, sclY; SetColor 255, 255, 255
			If (waveC = 11 And tranC = 1) Then
				If levelA2 < .75 Then SetAlpha levelA2 Else SetAlpha .75 ' // Limit
			ElseIf (waveC = 16 And tranC = 1) Then
				If levelA1 > .75 Then 
					SetAlpha .75 
				Else
					If levelA1 > 0 Then SetAlpha levelA1 Else SetAlpha 0 ' // Limit		
				EndIf
			Else
				SetAlpha .75
			EndIf
			DrawImage imgWater, 0, 0, waterF
			SetBlend ALPHABLEND; SetAlpha 1
			
			If GetMilliSecs() >= waterT + 200 Then
				If waterF < 2 Then waterF:+1 Else waterF = 0
				waterT = GetMilliSecs()
			EndIf
			
			' // Water splash
			Local tmpSX:Int
			If (waveC = 11 And tranC = 1) Then
			Else
				For Local i:Int = 1 To 2
					tmpSX = Rand(0, 110)
					partList.AddLast part.Create(tmpSX, lavaY + lavaC + 1, 3, PART_WARP, 1)

					tmpSX = Rand(517, 627)
					partList.AddLast part.Create(tmpSX, lavaY + lavaC + 1, 3, PART_WARP, 1)
				Next
			EndIf
			
		EndIf
		
		For p:Part = EachIn partList; p.Render(); Next ' // Particles
		
		SetScale sclX, sclY; SetColor 255, 255, 255; SetBlend ALPHABLEND; SetAlpha 1
		
		' // Score
		DrawScore(PLAYER_1)
		If b2Player = True Then DrawScore(PLAYER_2)
		
		RenderWaves() ' // Draw wave status / game over
		
		' // DEBUG INFO
		If bDebug = True Then DrawDebug()
		SetScale sclX, sclY; SetColor 255, 255, 255; SetBlend ALPHABLEND; SetAlpha 1

		' // PLAYERS
		For Local i:Int = 0 To b2Player
			If bSpawn = False Or p_Respawn[i] <> 0 Then ' // Spawning
		
			Else ' // Alive
				If p_GameOver[i] = False Then GetInput(i) ' // Keyboard / joystick input			

				' // PLAYER LEVEL OBJECTS
				' // Ghosting
				If p_Ghost[i] = True Then
					If GetMilliSecs() >= p_GT[i] + 50 Then
						If p_GC[i] < 5 Then 
							partList.AddLast part.Create(Int(p_X[i]), Int(p_Y[i]), p_F[i], PART_GHOST, i)
							p_GC[i]:+1
							p_GT[i] = GetMilliSecs()
						Else
							p_Ghost[i] = False
						EndIf
					EndIf
				EndIf	
											
				If p_GameOver[i] = False Then PlayerCol(i) ' // Player to level collision checks
				
				' // Affect inertia
				p_X[i] = p_X[i] + p_I[i]
				p_Y[i] = p_Y[i] + p_YI[i]

				' // Screen wrapping
				If p_I[i] < 0 Then
					If p_X[i] <= -(10 * sclX) Then p_X[i] = 574
				ElseIf p_I[i] > 0 Then
					If p_X[i] >= 574 Then p_X[i] = -(10 * sclX)
				EndIf
				
			EndIf ' // End spawn check
		Next		
			
		' // LEVEL OBJECTS
		If levelF <= 1 Then
			If waveC = 6 And tranC = 1 Then ' // Ice transition
			Else ' // Lava waves
				If Rand(1, 50) = 25 Then ' // Create fireballs
					If Rand(0, 1) = 0 Then ' // Left side
						objList.AddLast obj.Create(Rand(0, Int(32 * sclX)), 448, 0, OBJ_FIREBALL)
					Else ' // Right side
						objList.AddLast obj.Create(Rand(Int(223 * sclX), 580), 448, 0, OBJ_FIREBALL)
					EndIf
				EndIf
				
				If waveC = 3 Or waveC = 4 And tranC = 0 Then ' // Fire sparks
					SpawnSpark(1)
				EndIf
				
			EndIf
		ElseIf levelF <= 5 Then ' // Ice / snow
		
			If Rand(1, 5) = 3 Then
				partList.AddLast part.Create(0, 0, 0, PART_SNOW)
			EndIf
			
			If waveC = 8 Or waveC = 9 And tranC = 0 Then ' // Ice 
				'SpawnSpark(0)
				SpawnIce()
				
			EndIf
		
		ElseIf levelF <= 9 Then ' // Earth
			
			If Rand(1, 3) = 2 Then
				partList.AddLast part.Create(0, 0, 0, PART_RAIN)
			EndIf
			
			If waveC = 13 Or waveC = 14 And tranC = 0 Then ' // Rocks
				SpawnRock() 
			EndIf
		
		ElseIf levelF < = 13 Then ' // Moon
			
			If waveC = 18 Or waveC = 19 And tranC = 0 Then ' // Comet
				SpawnComet() 
			EndIf
		
		EndIf
		
		SpawnEnemies() ' // Spawn enemies at start of wave
		SpawnPter() ' // Spawn pterodactyl check !DEBUG!
		WaveTransition() ' // Wave transitions		
		
		'If MouseHit(1) = True Then
		'	objList.AddLast obj.Create(MouseX(), MouseY(), Int(-1), OBJ_EGG, Rand(1, 100), 1)
		'EndIf
		
		If bTitle = True Then
			FlushKeys
			FlushJoy 0
			FlushJoy 1
			bSecret = False ' // Secret code
			secretC$ = "" ' // Secret code
		Else
			' // PAUSE / STEAL LIVES
			Local bP1Start:Int = False
			Local bP2Start:Int = False
	
			'If KeyHit(Key1Start) = True Or JoyHit(Joy1Start, 0) = True Then bP1Start = True
			If GetInput(PLAYER_1, INP_S) = True Then bP1Start = True
			If b2Player = True Then
				If GetInput(PLAYER_2, INP_S) = True Then bP2Start = True
				'If KeyHit(Key2Start) = True Or JoyHit(Joy2Start, 1) = True Then bP2Start = True
			EndIf
			
			If bP1Start = True Or bP2Start = True Then
				
				If (bP1Start = True And b2Player = True) And p_GameOver[PLAYER_1] = True And p_Lives[PLAYER_2] > 0 Then ' // Steal lives
					p_Lives[PLAYER_2]:-1
					p_Lives[PLAYER_1]:+1
					p_GameOver[PLAYER_1] = False
					DoRespawn PLAYER_1
					
				ElseIf bP2Start = True And p_GameOver[PLAYER_2] = True And p_Lives[PLAYER_1] > 0 Then ' // Steal lives
					p_Lives[PLAYER_1]:-1
					p_Lives[PLAYER_2]:+1
					p_GameOver[PLAYER_2] = False
					DoRespawn PLAYER_2
					
				Else ' // Pause
					If waveC <> 999 Then ' // Not game over
						bPaused = True; PlaySFX sfxPause; FlushKeys; FlushJoy(0); FlushJoy(1)
						pauseStart = GetMilliSecs() ' // Hold pause start time
						PauseChannel musChan
					EndIf
				EndIf
			EndIf		
		EndIf
		
	EndIf ' // End TITLE block
	
	' // CRT Filter
	If crtMode > 0 Then
		If crtMode = 1 Then SetAlpha .25 ElseIf crtMode = 2 Then SetAlpha .5 ElseIf crtMode = 3 Then SetAlpha .75 ElseIf crtMode = 4 Then SetAlpha 1
		SetScale .368, .373; SetColor 255, 255, 255; SetBlend ALPHABLEND
		'SetScale .574, .635
		DrawImage imgCRT, 0, 0
		SetAlpha 1
	EndIf
	
	If bWindowed = False Then ' // Fullscreen border
		SetOrigin 0, 0	
		SetScale 1, 1; SetColor 0, 0, 0
		DrawRect 0, 0, 640, 16; DrawRect 0, 0, 26, 480
		DrawRect 640 - 26, 0, 26, 480; DrawRect 0, 480 - 16, 640, 16
		SetColor 255, 255, 255
		SetOrigin 26, 16
	EndIf

	'If KeyHit(KEY_SPACE) Then DoRespawn(0) ' // DEBUG CREATE ENEMIES
	'If KeyHit(KEY_BACKSPACE) Then 
	'	For o:Obj = EachIn objList
	'		If o.ID = OBJ_BUZZARD Then objList.Remove o; partC = partC - 1
	'	Next
	'EndIf
					
	GetFuncInput ' // Function Keys
	
	If GetMilliSecs() >= fpsTimer + 1000 Then FPS = curFrames; curFrames = 0; fpsTimer = GetMilliSecs()
	curFrames = curFrames + 1
		 
Flip 1 

If bPaused = True Then ' // PAUSE
	Local tmpIn:Int = 0

	Repeat
		GetFuncInput ' // Function Keys

		If GetInput(PLAYER_1, INP_S) = True Then tmpIn = 1
		If b2Player = True Then
			If GetInput(PLAYER_2, INP_S) = True Then tmpIn = 1
		EndIf
		If KeyDown(KEY_ESCAPE) = True Then tmpIn = 2
		Delay 100 ' // Give CPU time
	Until tmpIn <> 0
	
	'Until KeyHit(Key1Start) = True Or JoyHit(Joy1Start, 0) = True Or KeyHit(Key2Start) = True Or JoyHit(Joy2Start, 1) = True Or KeyDown(KEY_ESCAPE) = True
	PlaySFX sfxPause; bPaused = False
	pauseTotal = pauseTotal + (GetMilliSecs() - pauseStart) ' // Time offset fix
	ResumeChannel musChan
	FlushJoy(0); FlushJoy(1)
	If tmpIn <> 2 Then FlushKeys
EndIf

Cls
Until KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True
EndGame

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWDEBUG - Show debug information                                       
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawDebug()

	' // DEBUG INFO
	SetScale 1, 1; SetColor 255, 255, 0
	DrawText "X: " + Int(p_X[0]) + ", Y: " + Int(p_Y[0]) + " | D: " + String(p_D[0]) + ", I: " + Left$(String(p_I[0]), 5) + ", Skid: " + p_Skid[0] + ", F: " + String(p_F[0]), 16, 16 
	DrawText "Flap: " + p_Flap[0] + ", Fall: " + p_Fall[0] + ", YI: " + Left$(String(p_YI[0]), 5) + ", EnemyC: " + en_C + ", Wave: " + waveC, 16, 32
	DrawText "FPS: " + FPS + ", Objects: " + objC + ", Parts: " + partC + ", Mem: " + String(GCMemAlloced() / 1024) + " kb", 16, 48
	
	' // Collision rects
	SetColor 255, 0, 0; SetScale sclX, sclY
	
	Local tmpSX:Int, tmpSW:Int		
	If p_Skid[0] = True And (p_X[0] > 0 And p_X[0] < 588 - Int(16 * sclX)) Then
		tmpSW = 5
		If p_I[0] > 0 Then ' // Right skid
			tmpSX = 9
		Else ' // Left skid
			tmpSX = 2
		EndIf
	Else
		tmpSX = 3; tmpSW = 10
	EndIf
	DrawRect Int(p_X[0] + (tmpSX * sclX)), Int(p_Y[0] + (24 * sclY)), tmpSW, 1 ' // Feet / skid
	
	SetColor 255, 255, 0
	DrawRect Int(p_X[0] + (2 * sclX)), Int(p_Y[0] + (16 * sclY)), 12, 1
	SetColor 255, 0, 0
	'DrawRect Int(p1_X + (3 * sclX)), Int(p1_Y + (24 * sclY)), 10, 1
	
	DrawRect Int(p_X[0] + (3 * sclX)), Int(p_Y[0] - (1 * sclY)), 10, 1 ' // Head

	DrawRect Int(p_X[0]), Int(p_Y[0]), 1, 18 ' // Left
	DrawRect Int(p_X[0] + (15 * sclX)), Int(p_Y[0]), 1, 18 ' // Right
		
	SetColor 255, 255, 255
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETFUNCINPUT - Handles function key input                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetFuncInput()

	If KeyHit(KEY_F2) Then ' // Image filter
		If bFilter = True Then bFilter = False Else bFilter = True
		cfgFilter = bFilter
		LoadImages(bFilter)
		
	ElseIf KeyHit(KEY_F1) Then ' // Save snapshot
		SaveScreen
	
	ElseIf KeyHit(KEY_F3) Then ' // CRT mode
		If crtMode < 4 Then crtMode = crtMode + 1 Else crtMode = 0
		cfgCRT = crtMode
		
	ElseIf KeyHit(KEY_F4) Then ' // Debug
		If bDebug = True Then bDebug = False Else bDebug = True
		
	EndIf
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CHECKENEMYCOL - Checks enemy to enemy collision                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function CheckEnemyCol:Int(X:Int, Y:Int, F:Int, D:Int, ID:Int)

	Local tmpRet:Int = 0

	SetScale sclX, sclY
		
	For o:Obj = EachIn objList
		If o.ID = OBJ_BUZZARD And o.S <> ID And o.D <> D And o.A <> 0 Then ' // Same obj / dir check / not spawning
			If D = 0 Then ' // Left to right
				If RectsOverlap(Int(X), Int(Y), 4, 18, Int(o.X + (12 * sclX)), Int(o.Y), 4, 18) = True Then
					PlaySFX sfxParry
				
					o.D = 0; o.HC = 1
					If o.R = 1 Then o.F = 11 Else o.F = 6 ' // Reset	
					
					Return 1
				EndIf
			Else ' // Right to left				
				If RectsOverlap(Int(o.X), Int(o.Y), 4, 18, Int(X + (12 * sclX)), Int(Y), 4, 18) = True Then
					PlaySFX sfxParry
				
					o.D = 1; o.HC = 1
					If o.R = 1 Then o.F = 13 Else o.F = 1 ' // Reset	
																
					Return 1			
				EndIf
				
			EndIf
		EndIf
		
	Next
	
	Return 0
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETINPUT - Handles keyboard and joystick gameplay input                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetInput(i:Int)
	
	Local keyRight:Int
	Local keyLeft:Int
	Local keyFlap:Int
	
	Rem
	If i = PLAYER_1 Then ' // Keycodes
		keyRight = Key1Right
		keyLeft = Key1Left
		keyFlap = Key1B
	ElseIf i = PLAYER_2 Then
		keyRight = Key2Right
		keyLeft = Key2Left
		keyFlap = Key2B
	EndIf
	EndRem
	
	'If (KeyDown(keyRight) Or JoyX(i) = 1) Then ' // Move right
	
	If GetInput(i, INP_R, 1) = True Then ' // Move right
		
		If p_Flap[i] = False Then
			If p_I[i] < 4 Then p_I[i] = p_I[i] + .15 Else p_I[i] = 4
		Else
			If p_I[i] < 4 Then p_I[i] = p_I[i] + .015 Else p_I[i] = 4
			If GetMilliSecs() >= p_T[i] + 50 Then p_F[i] = 15
		EndIf
		p_D[i] = 1			

	'ElseIf (KeyDown(keyLeft) Or JoyX(i) = -1) Then ' // Move left
	ElseIf GetInput(i, INP_L, 1) = True Then ' // Move left
	
		If p_Flap[i] = False Then
			If p_I[i] > -4 Then p_I[i] = p_I[i] - .15 Else p_I[i] = -4
		Else
			If p_I[i] > -4 Then p_I[i] = p_I[i] - .015 Else p_I[i] = -4
			If GetMilliSecs() >= p_T[i] + 50 Then p_F[i] = 13
		EndIf		
		p_D[i] = -1
		
	Else ' // Idle
		If p_Flap[i] = False Then
			If p_Skid[i] = True And p_I[i] = 0 Then ' // Frame reset
				If p_F[i] <= 5 Then 
					p_F[i] = 0
				ElseIf p_F[i] >= 6 Then
					p_F[i] = 6
				EndIf
				StopChannel p_skidChan[i]
				p_Skid[i] = False
				p_I[i] = 0
			EndIf
			
			p_D[i] = 0
		EndIf
	EndIf
	
	' // Flap
	Local tmpFlap:Int = False
	If GetInput(i, INP_B) = True Or (GetInput(i, INP_B, 1) = True And GetMilliSecs() >= p_flapT[i] + 200) Then tmpFlap = True

	'If KeyHit(keyFlap) Or (KeyDown(keyFlap) And GetMilliSecs() >= p_flapT[i] + 200) Then tmpFlap = True
	'If i = PLAYER_1 Then
	'	If JoyHit(Joy1B, i) = True Or (JoyDown(Joy1B, i) And GetMilliSecs() >= p_flapT[i] + 200) Then tmpFlap = True
	'ElseIf i = PLAYER_2 Then
	'	If JoyHit(Joy2B, i) = True Or (JoyDown(Joy2B, i) And GetMilliSecs() >= p_flapT[i] + 200) Then tmpFlap = True
	'EndIf
	
	If tmpFlap = True Then ' // Flap		
		p_flapT[i] = GetMilliSecs()
		StopChannel p_SkidChan[i]
		p_Skid[i] = False
		
		If (p_F[i] >= 0 And p_F[i] <= 5) Or p_F[i] = 12 Or p_F[i] = 13 Then  ' // Left
			p_F[i] = 12
		ElseIf p_F[i] >= 6 And p_F[i] <= 11 Or p_F[i] = 14 Or p_F[i] = 15 Then ' // Right
			p_F[i] = 14
		EndIf
		
		p_T[i] = GetMilliSecs()
		
		If p_YI[i] = 0 And p_flapC[i] = 0 Then ' // First flap from floor
			If IsMoon() = False Then p_YI[i] = -2 Else p_YI[i] = -2.5
			'p_YI[i] = -2
			p_Lastflap[i] = GetMilliSecs()
		Else
			If p_YI[i] < 0 Then ' // Rising
				If GetMilliSecs() >= p_Lastflap[i] + 50 Then ' // Double input fix
					'If IsMoon() = False Then p_YI[i]:-1.5 Else p_YI[i]:-2.5
					p_YI[i]:-1.5
					' - (p1_flapC * .4)
					p_Lastflap[i] = GetMilliSecs()
				EndIf
			Else ' // Falling
				'If IsMoon() = False Then p_YI[i]:-1.7  Else p_YI[i]:-2.7
				p_YI[i]:-1.7
				' - (p1_flapC * .4))
					'p1_flapC = 0
			EndIf
									
			If p_YI[i] < -6 Then p_YI[i] = -6 ' // Limit
		EndIf
		
		p_flapC[i]:+1
		p_Flap[i] = True
		
		PlaySFX(sfxFlap)
		
		'FlushKeys; FlushJoy
	EndIf
		
	If p_I[i] < 0 Then
		If p_Flap[i] = False Then
			If GetMilliSecs() >= (p_T[i] + 150) - Int(Abs(p_I[i]) * 37) Then
				If p_F[i] >= 1 And p_F[i] < 4 Then 
					p_F[i] = p_F[i] + 1 
				Else ' // Footfall
					p_F[i] = 1
					If p_Skid[i] = False Then
						If p_Step[i] = False Then PlaySFX(sfxStep1); p_Step[i] = True Else PlaySFX(sfxStep2); p_Step[i] = False
					EndIf
				EndIf
				p_T[i] = GetMilliSecs()
			EndIf
			
			If p_D[i] = 1 Then ' // Skid
				If p_Skid[i] = False Then p_skidChan[i] = PlaySFX(sfxSkid)
				p_F[i] = 5; p_Skid[i] = True
				If Rand(1, 6) = 3 Then partList.AddLast part.Create(p_X[i] + (8 * sclX), p_Y[i] + (24 * sclY), 1, PART_SKID)
			ElseIf p_D[i] = -1 Then 
				StopChannel p_SkidChan[i]
				p_Skid[i] = False
			ElseIf p_D[i] = 0 Then
				If p_Skid[i] = True Then
					If p_I[i] =< -.15 Then p_I[i] = p_I[i] + .15 Else p_I[i] = 0; p_D[i] = 0; p_Skid[i] = False; p_F[i] = 0; StopChannel p_SkidChan[i]
				EndIf
			EndIf
		EndIf
		
	ElseIf p_I[i] > 0 Then
		If p_Flap[i] = False Then
			If GetMilliSecs() >= (p_T[i] + 150) - Int(Abs(p_I[i]) * 37) Then
				If p_F[i] >= 6 And p_F[i] < 10 Then 
					p_F[i] = p_F[i] + 1 
				Else
					If p_Skid[i] = False Then
						If p_Step[i] = False Then PlaySFX(sfxStep1); p_Step[i] = True Else PlaySFX(sfxStep2); p_Step[i] = False
					EndIf			
					p_F[i] = 7
				EndIf
				p_T[i] = GetMilliSecs()
			EndIf
			
			If p_D[i] = -1 Then ' // Skid
				If p_Skid[i] = False Then p_skidChan[i] = PlaySFX(sfxSkid)
				p_F[i] = 11; p_Skid[i] = True
				If Rand(1, 6) = 3 Then partList.AddLast part.Create(p_X[i] + (8 * sclX), p_Y[i] + (24 * sclY), 0, PART_SKID)			 
			ElseIf p_D[i] = 1 Then 
				StopChannel p_skidChan[i]
				p_Skid[i] = False
			ElseIf p_D[i] = 0
				If p_Skid[i] = True Then
					If p_I[i] >= .15 Then p_I[i] = p_I[i] - .15 Else p_I[i] = 0; p_D[i] = 0; p_Skid[i] = False; p_F[i] = 6; StopChannel p_SkidChan[i]
				EndIf
			EndIf
		EndIf
		
	EndIf

	If levelF >= 2 And levelF <= 5 Then ' // ICE SKID
		If p_Skid[i] = True Then
			'DebugLog "SKID"
			If p_F[i] = 11 Then p_I[i]:+.075 ElseIf p_F[i] = 5 Then p_I[i]:-.075
		EndIf
	EndIf
	
	If p_YI[i] < 6 And p_Flap[i] = True Or p_Fall[i] = True Then ' // Flap
		If p_YI[i] < 6 Then 
			If IsMoon() = False Then p_YI[i] = p_YI[i] + .1 Else p_YI[i] = p_YI[i] + .08
		Else 
			p_YI[i] = 6
		EndIf
		
		If GetMilliSecs() >= p_T[i] + 50 Then 
			If p_F[i] = 12 Then p_F[i] = 13 ElseIf p_F[i] = 14 Then p_F[i] = 15
		EndIf
	Else 
		If p_F[i] = 12 Or p_F[i] = 13 Then
			p_F[i] = 0
		ElseIf p_F[i] = 14 Or p_F[i] = 15 Then
			p_F[i] = 6
		EndIf
		p_YI[i] = 0
		p_Flap[i] = False
	EndIf
					
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYERCOL - Handles player to level collision                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlayerCol(i:Int)
	
	' // Floor collision
	Local tmpSX:Int, tmpSW:Int, tmpFall:Int = True		
	If p_Skid[i] = True And (p_X[i] > 0 And p_X[i] < 588 - Int(16 * sclX)) Then ' // Skid check
		If p_Fall[i] = True Then p_skidChan[i] = PlaySFX(sfxSkid) ' // Landing skid
		tmpSW = 5
		If p_I[i] > 0 Then tmpSX = 9 Else tmpSX = 2 ' // Right / left
	Else
		tmpSX = 3; tmpSW = 10
	EndIf		
	
	' // Lava collision
	If p_YI[i] >= 0 Then
		If RectsOverlap(Int((p_X[i]) + (tmpSX * sclX)), Int((p_Y[i]) + (16 * sclY)), tmpSW, 1, 0, Int(lavaY), 588, 448 - Int(lavaY)) = True Or p_Y[i] >= Int(189 * sclY) Then
			DoRespawn i, 1; Return
		EndIf
	EndIf

	If p_YI[i] >= 0 Then
		If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (tmpSX * sclX)), Int((p_Y[i]) + (24 * sclY)), tmpSW, 1) Then
			tmpFall = False	
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (tmpSX * sclX)), Int((p_Y[i]) + (20 * sclY)), tmpSW, 1) = True Then p_Y[i] = p_Y[i] - 4
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (tmpSX * sclX)), Int((p_Y[i]) + (21 * sclY)), tmpSW, 1) = True Then p_Y[i] = p_Y[i] - 3
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (tmpSX * sclX)), Int((p_Y[i]) + (22 * sclY)), tmpSW, 1) = True Then p_Y[i] = p_Y[i] - 2
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (tmpSX * sclX)), Int((p_Y[i]) + (23 * sclY)), tmpSW, 1) = True Then p_Y[i] = p_Y[i] - 1
		EndIf
		
		If (p_X[i] <= -(8 * sclX) Or p_X[i] >= 580) And p_Flap[i] = False Then tmpFall = False ' // Wrap protection	
	EndIf
		
	' // Head / ceiling
	If p_YI[i] < 0 Then
		If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (3 * sclX)), Int((p_Y[i]) - (1 * sclY)), 10, 1) Or p_Y[i] < 0 Then
			p_YI[i] = -(p_YI[i] / 2)
			tmpFall = True
			p_Flap[i] = False
			p_FlapC[i] = 0
			If p_Y[i] > 0 Then PlaySFX sfxBump
		
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (3 * sclX)), Int((p_Y[i]) + (3 * sclY)), 10, 1) = True Then p_Y[i] = p_Y[i] + 4
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (3 * sclX)), Int((p_Y[i]) + (2 * sclY)), 10, 1) = True Then p_Y[i] = p_Y[i] + 3
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (3 * sclX)), Int((p_Y[i]) + (1 * sclY)), 10, 1) = True Then p_Y[i] = p_Y[i] + 2
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (3 * sclX)), Int((p_Y[i])), 10, 1) = True Then p_Y[i] = p_Y[i] + 1		

		EndIf
	EndIf
	
	' // Left side
	If p_I[i] < 0 Then
		If ImageRectCollide(imgLevel, 0, 0, levelF, Int(p_X[i]), Int(p_Y[i]), 1, 18) Then
			p_I[i] = -p_I[i]
			If p_I[i] < .5 Then p_I[i] = .5 ' // Limit
			PlaySFX sfxBump
		
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (4 * sclX)), Int(p_Y[i]), 1, 18) = True Then p_X[i] = p_X[i] + 4
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (3 * sclX)), Int(p_Y[i]), 1, 18) = True Then p_X[i] = p_X[i] + 3
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (2 * sclX)), Int(p_Y[i]), 1, 18) = True Then p_X[i] = p_X[i] + 2
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (1 * sclX)), Int(p_Y[i]), 1, 18) = True Then p_X[i] = p_X[i] + 1		

		EndIf
	EndIf

	' // Right side
	If p_I[i] > 0 Then
		If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (15 * sclX)), Int(p_Y[i]), 1, 18) Then
			p_I[i] = -p_I[i]
			If p_I[i] > -.5 Then p_I[i] = -.5 ' // Limit
			PlaySFX sfxBump
		
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (11 * sclX)), Int(p_Y[i]), 1, 18) = True Then p_X[i] = p_X[i] - 4
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (12 * sclX)), Int(p_Y[i]), 1, 18) = True Then p_X[i] = p_X[i] - 3
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (13 * sclX)), Int(p_Y[i]), 1, 18) = True Then p_X[i] = p_X[i] - 2
			If ImageRectCollide(imgLevel, 0, 0, levelF, Int((p_X[i]) + (14 * sclX)), Int(p_Y[i]), 1, 18) = True Then p_X[i] = p_X[i] - 1		

		EndIf
	EndIf
	
	' // Falling
	If tmpFall = True Then
		p_Fall[i] = True
		StopChannel p_SkidChan[i]
		
		If GetMilliSecs() >= p_T[i] + 50 Then
		If (p_F[i] >= 0 And p_F[i] <= 5) Or p_F[i] = 12 Or p_F[i] = 13 Then  ' // Left
			p_F[i] = 13
		ElseIf p_F[i] >= 6 And p_F[i] <= 11 Or p_F[i] = 14 Or p_F[i] = 15 Then ' // Right
			p_F[i] = 15
		EndIf
		EndIf
		p_Flap[i] = True
	Else
		p_Flap[i] = False
		p_Fall[i] = False
	EndIf
	
	If p_Flap[i] = False Or p_YI[i] > 0 Then p_flapC[i] = 0 ' // Reset flap count
				
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DORESPAWN - Respawns rider                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DoRespawn(tmpP:Int, tmpS:Int = 0)

	If p_Respawn[tmpP] <> 0 Then Return ' // Don't kill during respawn
	
	Local i:Int = 0
		
	' // Burst
	partList.AddLast part.Create(Int(p_X[tmpP] + Int(2 * sclX)), Int(p_Y[tmpP] + Int(6 * sclY)), 0, PART_BURST, tmpS)
	For i = 1 To 10
		partList.AddLast part.Create(Int(p_X[tmpP] + Int(8 * sclX)), Int(p_Y[tmpP] + Int(12 * sclY)), 3, PART_SKID, tmpS)
	Next
										
	PlaySound sfxDie

	FlushKeys
	FlushJoy tmpP

	If p_Lives[tmpP] > 0 Then 
		p_Lives[tmpP]:-1
		
	Else '' // Game over
		p_GameOver[tmpP] = True
		
		Local tmpGO:Int = False
		If b2Player = True Then ' // Check other player
			If p_GameOver[PLAYER_1] = True And p_GameOver[PLAYER_2] = True Then tmpGO = True
		Else
			tmpGO = True
		EndIf
		
		If tmpGO = True Then ' // Both players are dead
			waveC = 999 
			waveT = GetMilliSecs()
			en_T = GetMilliSecs()
			
			en_CT = 0 ' // created count
			en_TC = 0 ' // total count
		EndIf
		
	EndIf

	p_X[tmpP] = -1000; p_Y[tmpP] = -1000		

	p_I[tmpP] = 0; p_YI[tmpP] = 0; p_D[tmpP] = 0		
	p_eggC[tmpP] = 0; p_airC[tmpP] = 0; p_F[tmpP] = 19
	p_Flap[tmpP] = False; p_Fall[tmpP] = False
	p_Skid[tmpP] = False; p_flapC[tmpP] = 0; p_Step[tmpP] = False

	If p_GameOver[tmpP] = False Then ' // Respawn
		p_Respawn[tmpP] = 1
		p_RespawnR[tmpP] = 1
		p_RespawnT[tmpP] = GetMilliSecs()			
	EndIf
	
	' // Kill Pterodactyls / sparks
	For o:Obj = EachIn objList
		If o.ID = OBJ_PTER Then 
			objList.Remove o; objC:-1
		ElseIf o.ID = OBJ_SPARK Then
			o.F = 4; o.A = 2 ' // Despawn
		ElseIf o.ID = OBJ_ICE Then

		EndIf	
	Next 
	bPter = False; pter_T = GetMilliSecs()
	sparkT = GetMilliSecs()
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SETHICOLOR - Sets hi score rotating border color                                
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SetHiColor(tmpOff:Int)

	If tmpOff = 0 Then 
		SetColor 251, 107, 29
	ElseIf tmpOff = 1 Then
		SetColor 232, 59, 59
	ElseIf tmpOff = 2 Then
		SetColor 200, 76, 12
	ElseIf tmpOff = 3 Then
		SetColor 122, 48, 69
	ElseIf tmpOff = 4 Then
		SetColor 252, 167, 144
	ElseIf tmpOff = 5 Then
		SetColor 251, 255, 134
	ElseIf tmpOff = 6 Then
		SetColor 240, 188, 60
	ElseIf tmpOff = 7 Then
		SetColor 0, 173, 254
	EndIf

End Function
	
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SEEKCOLOR - Moves selector to current palette color                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SeekColor(myCol:Int)

	Local pixPalP:TPixmap = CreatePixmap(ImageWidth(imgPal), ImageHeight(imgPal), PF_RGBA8888)
	Local tmpCol:Int
	
	' // Get palette color
	pixPalP = LockImage(imgPal)
	For Local y:Int = 0 To ImageHeight(imgPal) - 1 Step 10
		For Local x:Int = 0 To ImageWidth(imgPal) - 1 Step 10
			tmpCol = ReadPixel(pixPalP, x, y) ' // Current color
			If tmpCol = myCol Then ' // Color match
				tSelX = Int(x * sclX) + 126; tSelY = Int(y * sclY) + 252
				If x <> 0 Then tSelX:+1
				Exit
			EndIf
		Next
		If tmpCol = myCol Then Exit
	Next
	UnlockImage imgPal
	pixPalP = Null	
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² COLORRIDER - Recolors player sprite                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function ColorRider(tmpPlayer:Int, tmpX:Int, tmpY:Int, bAll:Int = False)
	
	Local tmpCol:Int, tmpX2:Int, tmpY2:Int, tmpCol2:Int
	Local tmpR:Int, tmpG:Int, tmpB:Int
		
	Local pixPalP:TPixmap = CreatePixmap(ImageWidth(imgPal), ImageHeight(imgPal), PF_RGBA8888)
	
	' // Get palette color
	pixPalP = LockImage(imgPal)	
	tmpCol = ReadPixel(pixPalP, Int(tmpX / sclX), Int(tmpY / sclY)) ' // Current color
	UnlockImage imgPal
	pixPalP = Null	
	
	Local pixRiderP2:TPixmap = LoadPixmap("gfx/rider" + String(tmpPlayer + 1) + "pd.png")

	' // Defaults
	'If tmpX = 0 And tmpY = 0 Then
	'	If tmpPlayer = PLAYER_1 Then
	'		If tCol = 0 Then tmpCol = -3650548 ElseIf tCol = 1 Then tmpCol = -16717608 ElseIf tCol = 2 Then tmpCol = -1000388
	'	ElseIf tmpPlayer = PLAYER_2 Then
	'		If tCol = 0 Then tmpCol = -3650548 ElseIf tCol = 1 Then tmpCol = -1000388 ElseIf tCol = 2 Then tmpCol = -16717608
	'	EndIf
	'EndIf

	If bAll = False Then curCol = tmpCol Else curCol = p_Col1[tmpPlayer] ' // Public
	
	For tmpY2 = 0 To PixmapHeight(pixRiderP[tmpPlayer]) - 1
		For tmpX2 = 0 To PixmapWidth(pixRiderP[tmpPlayer]) - 1
			tmpCol2 = ReadPixel(pixRiderP2, tmpX2, tmpY2)
					
			'tmpR = (tmpCol2 & $FF0000) Shr 16
			'tmpG = (tmpCol2 & $FF00) Shr 8
			'tmpB = (tmpCol2 & $FF)
			'DebugLog "R: " + tmpR + ", B: " + tmpB + ", G: " + tmpG
		
			If tmpPlayer = PLAYER_1 Then
				If bAll = True Then
					WritePixel pixRiderP[0], tmpX2, tmpY2, tmpCol2				
				Else
					If (tCol = 0 And tmpCol2 = -3650548) Or (tCol = 1 And tmpCol2 = -16717608) Or (tCol = 2 And tmpCol2 = -1000388) Then
						WritePixel pixRiderP[0], tmpX2, tmpY2, tmpCol
					EndIf
				EndIf
			ElseIf tmpPlayer = PLAYER_2 Then
				If bAll = True Then
					WritePixel pixRiderP[1], tmpX2, tmpY2, tmpCol2

				Else
					If (tCol = 0 And tmpCol2 = -3650548) Or (tCol = 1 And tmpCol2 = -1000388) Or (tCol = 2 And tmpCol2 = -16717608) Then
						WritePixel pixRiderP[1], tmpX2, tmpY2, tmpCol
					EndIf
				EndIf
			EndIf
			
		Next
	Next
	
	pixRiderP2 = Null
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SaveCol - Writes player color selection to file
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveCol(tmpPlayer:Int)

	Local tmpCol:Int, tmpX2:Int, tmpY2:Int, tmpCol2:Int
	
	Local tmpPix:TPixmap, tmpPix2:TPixmap 
	Local tmpImage:TImage, tmpImage2:TImage
	Local tmpR:Int, tmpG:Int, tmpB:Int

	tmpPix = CreatePixmap(ImageWidth(imgRider[tmpPlayer]), ImageHeight(imgRider[tmpPlayer]), PF_RGBA8888)

	' // Rider
	tmpImage = LoadImage("gfx/rider" + String(tmpPlayer + 1) + "d.png")
	tmpPix = LockImage(tmpImage)

	For tmpY2 = 0 To PixmapHeight(tmpPix) - 1
		For tmpX2 = 0 To PixmapWidth(tmpPix) - 1
			tmpCol2 = ReadPixel(tmpPix, tmpX2, tmpY2)			

			Local tmpRet:Int
			
			If tmpPlayer = PLAYER_1 Then ' // Player 1
				If tmpCol2 = -3650548 Then ' // Color 1
					tmpRet = p_Col1[0]
				ElseIf tmpCol2 = -16717608 Then ' // Color 2
					tmpRet = p_Col2[0]
				ElseIf tmpCol2 = -1000388 Then ' // Color 3
					tmpRet = p_Col3[0]
				Else
					tmpRet = tmpCol2 ' // Mask
				EndIf
				
			ElseIf tmpPlayer = PLAYER_2 Then ' // Player 2
				If tmpCol2 = -3650548 Then ' // Color 1
					tmpRet = p_Col1[1]
				ElseIf tmpCol2 = -1000388 Then ' // Color 2
					tmpRet = p_Col2[1]
				ElseIf tmpCol2 = -16717608 Then ' // Color 3
					tmpRet = p_Col3[1]
				Else
					tmpRet = tmpCol2 ' // Mask
				EndIf
							
			EndIf
									
			WritePixel tmpPix, tmpX2, tmpY2, tmpRet
			
		Next
	Next
	
	UnlockImage(tmpImage)

	SavePixmapPNG(tmpPix, "gfx/rider" + String(tmpPlayer + 1) + ".png", 9)
	SavePixmapPNG(pixRiderP[tmpPlayer], "gfx/rider" + String(tmpPlayer + 1) + "p.png", 9)

	' // Save respawn image
	tmpImage:TImage = LoadAnimImage("gfx/rider" + String(tmpPlayer + 1) + ".png", 16, 24, 0, 20)	
	Local pixRespawn:TPixmap = CreatePixmap(16, 24, PF_RGBA8888)
	pixRespawn = LockImage(tmpImage, 6)	
	SavePixmapPNG(pixRespawn, "gfx/rider" + String(tmpPlayer + 1) + "r.png", 9)
	UnlockImage tmpImage, 6

	tmpImage = Null
	pixRespawn = Null
	tmpPix = Null

	LoadImages(bFilter) ' // Reload images with filter
					
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² RENDERPLAYER - Draws players in various states                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RenderPlayer(i:Int)
	
	If p_Respawn[i] = 1 Then ' // Start respawn
		If GetMilliSecs() >= p_RespawnT[i] + 500 Then
			Local tmpPort:Int = Rand(0, 2)
			If tmpPort = 0 Then ' // Left portal
				p_X[i] = Int(20 * sclX); p_Y[i] = Int(120 * sclY)
			ElseIf tmpPort = 1 Then ' // Right portal
				p_X[i] = Int(204 * sclX); p_Y[i] = Int(112 * sclY)
			ElseIf tmpPort = 2 Then ' // Bottom portal
				p_X[i] = Int(108 * sclX); p_Y[i] = Int(188 * sclY)		
			EndIf

			' // Warp in
			objList.AddLast obj.Create(Int(p_X[i] - 9), Int(p_Y[i] - Int(32 * sclY)), 0, OBJ_WARP)	
						
			p_SpawnChan[i] = PlaySFX(sfxRespawn)
			p_RespawnT[i] = GetMilliSecs()
			p_RespawnR[i] = 1
			p_Respawn[i] = 2 ' // Respawning
			
			FlushKeys; FlushJoy(i)
		EndIf
	
	ElseIf p_Respawn[i] = 2 Then ' // Respawning
		DrawSubImageRect imgRiderR[i], Int(p_X[i]), Int(p_Y[i]), 19, p_RespawnR[i], 0, 0, 19, p_RespawnR[i], 0
		'DrawSubImageRect imgRider1, Int(p1_X), Int(p1_Y), 16, p1_RespawnR, 0, 0, 16, p1_RespawnR, 16
									
		If GetMilliSecs() >= p_RespawnT[i] + 16 Then
			If p_RespawnR[i] < 24 Then 
				p_RespawnR[i]:+1; p_Y[i]:-(1 * sclY) 
			Else ' // Invul
				FlushKeys
				FlushJoy i
				
				p_Respawn[i] = 3
				p_RespawnR[i] = 1
				p_F[i] = 16
			EndIf
			p_RespawnT[i] = GetMilliSecs()
		EndIf
		
	ElseIf p_Respawn[i] = 3 Then ' // Invul
		DrawImage imgRider[i], Int(p_X[i]), Int(p_Y[i]), p_F[i]
		
		If GetMilliSecs() >= p_RespawnT[i] + 15 Then
			If p_F[i] < 19 Then p_F[i]:+1 Else p_F[i] = 16
			p_RespawnT[i] = GetMilliSecs()
		EndIf
		
		Local tmpIn:Int = False
		
		If i = PLAYER_1 Then ' // Player 1 input
			If GetInput(PLAYER_1, INP_R, 1) = True Then tmpIn = True
			If GetInput(PLAYER_1, INP_L, 1) = True Then tmpIn = True
			If GetInput(PLAYER_1, INP_B, 0) = True Then tmpIn = True
			
			'If KeyDown(Key1Right) Or JoyX(0) = 1 Then tmpIn = True
			'If KeyDown(Key1Left) Or JoyX(0) = -1 Then tmpIn = True
			'If KeyHit(Key1B) Or JoyHit(Joy1B, 0) = True Then tmpIn = True
			
		ElseIf i = PLAYER_2 Then ' // Player 2 input
			If GetInput(PLAYER_2, INP_R, 1) = True Then tmpIn = True
			If GetInput(PLAYER_2, INP_L, 1) = True Then tmpIn = True
			If GetInput(PLAYER_2, INP_B, 0) = True Then tmpIn = True
		
			'If KeyDown(Key2Right) Or JoyX(1) = 1 Then tmpIn = True
			'If KeyDown(Key2Left) Or JoyX(1) = -1 Then tmpIn = True
			'If KeyHit(Key2B) Or JoyHit(Joy2B, 1) = True Then tmpIn = True
		EndIf
		
		If tmpIn = True Then StopChannel p_SpawnChan[i]

		If ChannelPlaying(p_SpawnChan[i]) = False Then p_Respawn[i] = 0; p_F[i] = 6 ' // Alive
		
	ElseIf p_Respawn[i] = 0 ' // Alive
	
		Local tmpA:Int
		If i = 0 Then tmpA = 1 ElseIf i = 1 Then tmpA = 0
		If ImagesCollide(imgRider[i], Int(p_X[i]), Int(p_Y[i]), p_F[i], imgRider[tmpA], Int(p_X[tmpA]), Int(p_Y[tmpA]), p_F[tmpA]) Then
			SetBlend LIGHTBLEND; SetAlpha .99
		Else
			SetBlend ALPHABLEND; SetAlpha 1
		EndIf			
		
		DrawImage imgRider[i], Int(p_X[i]), Int(p_Y[i]), p_F[i]
		
		SetBlend ALPHABLEND
		
	EndIf
			
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NEWGAME - Starts a new game, resetting all vars                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NewGame(b2P:Int)

	b2Player = b2P ' // Is it a two player game?

	bTitle = False
	lastIce = -1
	levStar = 0
	
	'StopChannel musCha ' // TITLE SCREEN MUSIC

	p_X[0] = 80 * sclX; p_Y[0] = 165 * sclY	
	p_F[0] = 0

	p_X[1] = 160 * sclX; p_Y[1] = 165 * sclY	
	p_F[1] = 6
	
	For Local i:Int = 0 To 1
		'If i = 0 Then p_Score[i] = 0; p_Lives[i] = 2		
		'If i = 1 Then p_Score[i] = 0; p_Lives[i] = 2
		p_Score[i] = 0
		If bSecret = False Then p_Lives[i] = 5 Else p_Lives[i] = 10 ' // Secret code
		p_eggC[i] = 0; p_airC[i] = 0
		p_Respawn[i] = False
		p_GameOver[i] = False
	Next
		
	lavaY = Int(217 * sclY); lavaD = 0; lavaT = GetMilliSecs(); lavaC = 0
	
	waveC = 1; waveT = GetMilliSecs() ' // Wave
	tranC = 0; levelF = 0

	bSpawn = False; bPaused = False ' // Game level
	bPter = False; pter_T = GetMilliSecs()
	sparkT = GetMilliSecs()
	
	'SaveDefScores()
	
	LoadScores() ' // Update scores
	
	' // Debug
	
	' // Lava Egg wave
	'lavaY = Int(201 * sclY)
	'waveC = 3; levelF = 1

	' // Ice Egg wave
	'lavaY = Int(217 * sclY)
	'waveC = 10; levelF = 5

	' // Earth Egg wave
	'lavaY = Int(217 * sclY)
	'waveC = 15; levelF = 9

	' // Ice
	'lavaY = Int(217 * sclY)
	'waveC = 9; levelF = 4
	
	' // Lava
	'lavaY = Int(201 * sclY)
	'waveC = 4; levelF = 1

	' // Earth 13
	'lavaY = Int(217 * sclY)
	'waveC = 13; levelF = 8
	
	' // Earth 12
	'lavaY = Int(217 * sclY)
	'waveC = 13; levelF = 8

	' // Earth Egg wave
	'lavaY = Int(217 * sclY)
	'waveC = 15; levelF = 9
	
	' // Moon 18
	'lavaY = Int(217 * sclY)
	'waveC = 18; levelF = 12

	' // Moon Egg wave
	'lavaY = Int(217 * sclY)
	'waveC = 20; levelF = 13
	
	' // Music reset
	If waveC <= 5 Then ' // LAVA
		curSong = 1
		musicD = -1

	ElseIf waveC <= 10 Then ' // ICE
		StopChannel musChan
		musChan = PlaySound(musSong2, musChan)
		musChan.SetVolume(Float(cfgMusic) / 10)	
		curSong = 2
		musicD = -1
		
	ElseIf waveC <= 15 Then ' // EARTH
		StopChannel musChan
		musChan = PlaySound(musSong3, musChan)
		musChan.SetVolume(Float(cfgMusic) / 10)	
		curSong = 3
		musicD = -1

	ElseIf waveC <= 20 Then ' // MOON
		StopChannel musChan
		musChan = PlaySound(musSong4, musChan)
		musChan.SetVolume(Float(cfgMusic) / 10)	
		curSong = 4
		musicD = -1
		
	EndIf
	
	' // Reset stars
	For Local s:Star = EachIn stars
		s.Init()
	Next
					
	CreateWave(waveC)
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CREATEWAVE - Creates enemies per wave                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function CreateWave(myWave:Int)

	en_C = 0; en_T = GetMilliSecs()
	en_CT = 0 ' // created count

	' // Clear list
	For Local i:Int = 0 To 99; enList[i] = -1; Next

	If levStar = 0 Then ' // Star wave
		Select myWave

			Case 1 ' // Wave 1 
			enList[0] = ENEMY_BOUNDER
			enList[1] = ENEMY_BOUNDER
			enList[2] = ENEMY_BOUNDER
			en_TC = 2 ' // Total enemies

			Case 2 ' // Wave 2
			enList[0] = ENEMY_BOUNDER
			enList[1] = ENEMY_BOUNDER
			enList[2] = ENEMY_BOUNDER
			enList[3] = ENEMY_BOUNDER	
			en_TC = 3 ' // Total enemies

			Case 3, 4, 6 ' // Wave 3, 4, 6
			enList[0] = ENEMY_BOUNDER
			enList[1] = ENEMY_BOUNDER
			enList[2] = ENEMY_BOUNDER
			enList[3] = ENEMY_BOUNDER	
			enList[4] = ENEMY_BOUNDER		
			en_TC = 4 ' // Total enemies
						
			Case 7, 8, 9 ' // Wave 7 - 9
			enList[0] = ENEMY_BOUNDER
			enList[1] = ENEMY_BOUNDER
			enList[2] = ENEMY_BOUNDER
			enList[3] = ENEMY_BOUNDER	
			enList[4] = ENEMY_BOUNDER		
			enList[5] = ENEMY_HUNTER			
			en_TC = 5 ' // Total enemies		

			Case 11, 12, 13, 14 ' // Wave 11, 12, 13, 14
			enList[0] = ENEMY_BOUNDER
			enList[1] = ENEMY_BOUNDER
			enList[2] = ENEMY_BOUNDER
			enList[3] = ENEMY_BOUNDER	
			enList[4] = ENEMY_BOUNDER		
			enList[5] = ENEMY_HUNTER			
			enList[6] = ENEMY_HUNTER			
			en_TC = 6 ' // Total enemies		
			
			Case 16, 17, 18, 19 ' // Wave 16, 17, 18, 19
			enList[0] = ENEMY_BOUNDER
			enList[1] = ENEMY_BOUNDER
			enList[2] = ENEMY_BOUNDER
			enList[3] = ENEMY_HUNTER	
			enList[4] = ENEMY_HUNTER		
			enList[5] = ENEMY_HUNTER			
			enList[6] = ENEMY_HUNTER
			en_TC = 6 ' // Total enemies
					
			Case 5, 10, 15, 20 ' // Eggs wave		
			enList[0] = ENEMY_EGG		
			en_TC = 0
			
		End Select
	
	ElseIf levStar = 1 Then ' // Star wave 1
		Select myWave
			Case 1, 2, 3, 4 ' // Wave 1, 2, 3, 4
			enList[0] = ENEMY_BOUNDER
			enList[1] = ENEMY_BOUNDER
			enList[2] = ENEMY_HUNTER
			enList[3] = ENEMY_HUNTER	
			enList[4] = ENEMY_HUNTER		
			enList[5] = ENEMY_HUNTER			
			enList[6] = ENEMY_SHADOW
			en_TC = 6 ' // Total enemies

			Case 6, 7, 8, 9 ' // Wave 6, 7, 8, 9
			enList[0] = ENEMY_BOUNDER
			enList[1] = ENEMY_HUNTER
			enList[2] = ENEMY_HUNTER
			enList[3] = ENEMY_HUNTER	
			enList[4] = ENEMY_HUNTER		
			enList[5] = ENEMY_HUNTER			
			enList[6] = ENEMY_SHADOW
			en_TC = 6 ' // Total enemies

			Case 11, 12, 13, 14 ' // Wave 11, 12, 13, 14
			enList[0] = ENEMY_HUNTER
			enList[1] = ENEMY_HUNTER
			enList[2] = ENEMY_HUNTER
			enList[3] = ENEMY_HUNTER	
			enList[4] = ENEMY_HUNTER		
			enList[5] = ENEMY_HUNTER			
			enList[6] = ENEMY_SHADOW
			en_TC = 6 ' // Total enemies

			Case 16, 17, 18, 19 ' // Wave 16, 17, 18, 19
			enList[0] = ENEMY_HUNTER
			enList[1] = ENEMY_HUNTER
			enList[2] = ENEMY_HUNTER
			enList[3] = ENEMY_HUNTER	
			enList[4] = ENEMY_HUNTER		
			enList[5] = ENEMY_SHADOW			
			enList[6] = ENEMY_SHADOW
			en_TC = 6 ' // Total enemies
						
		End Select	

	ElseIf levStar = 2 Then ' // Star wave 2
		Select myWave
			Case 1, 2, 3, 4 ' // Wave 1, 2, 3, 4
			enList[0] = ENEMY_HUNTER
			enList[1] = ENEMY_HUNTER
			enList[2] = ENEMY_HUNTER
			enList[3] = ENEMY_HUNTER	
			enList[4] = ENEMY_SHADOW		
			enList[5] = ENEMY_SHADOW			
			enList[6] = ENEMY_SHADOW
			en_TC = 6 ' // Total enemies

			Case 6, 7, 8, 9 ' // Wave 6, 7, 8, 9
			enList[0] = ENEMY_HUNTER
			enList[1] = ENEMY_HUNTER
			enList[2] = ENEMY_HUNTER
			enList[3] = ENEMY_SHADOW	
			enList[4] = ENEMY_SHADOW		
			enList[5] = ENEMY_SHADOW			
			enList[6] = ENEMY_SHADOW
			en_TC = 6 ' // Total enemies

			Case 11, 12, 13, 14 ' // Wave 11, 12, 13, 14
			enList[0] = ENEMY_HUNTER
			enList[1] = ENEMY_HUNTER
			enList[2] = ENEMY_SHADOW
			enList[3] = ENEMY_SHADOW	
			enList[4] = ENEMY_SHADOW		
			enList[5] = ENEMY_SHADOW			
			enList[6] = ENEMY_SHADOW
			en_TC = 6 ' // Total enemies

			Case 16, 17, 18, 19 ' // Wave 16, 17, 18, 19
			enList[0] = ENEMY_HUNTER
			enList[1] = ENEMY_SHADOW
			enList[2] = ENEMY_SHADOW
			enList[3] = ENEMY_SHADOW	
			enList[4] = ENEMY_SHADOW		
			enList[5] = ENEMY_SHADOW			
			enList[6] = ENEMY_SHADOW			
			en_TC = 7 ' // Total enemies
						
		End Select
				
	ElseIf levStar >= 3 Then ' // Star wave 3
	
		For Local i:Int = 0 To waveC + 1
			enList[i] = ENEMY_SHADOW
		Next
		en_TC = waveC + 1
		
	EndIf
	
	'enList[0] = ENEMY_BOUNDER
	'en_TC = 0 ' // Total enemies
			
End Function
			
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ADDSCORE - Adds score to specified player, handles 1-UPs                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function AddScore(i:Int, S:Int)
	
	If bSecret = True Then Return ' // No hi score on cheat
	Local oldS:Int = p_Score[i]
	p_Score[i]:+S

	Local tmp1:Int = False

	For Local tmpS:Int = 1000000 To 20000 Step -20000
		If oldS < tmpS And p_Score[i] >= tmpS Then tmp1 = True; Exit ' // 1-Up check
	Next
	
	If tmp1 = True Then ' // 1-UP Check
		If p_Lives[i] < 9 Then p_Lives[i]:+1
		PlaySFX sfx1UP
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYSFX - Plays a sound at desired volume                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlaySFX:TChannel(mySound:TSound)
	Local tmpChan:TChannel = AllocChannel()
	
	If cfgSFX <> 0 Then
		tmpChan = PlaySound(mySound)
		tmpChan.SetVolume(Float(cfgSFX) / 10)
	EndIf
	
	Return tmpChan
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² RENDERLAVA - Draws lava pool
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RenderLava(myCol:Int)

	If myCol = 0 Then ' // Lava
		SetColor 216, 40, 0
	ElseIf myCol = 1 Then ' // Water
		SetColor 42, 81, 151
		lavaC = 0
		lavaY = Int(217 * sclY)
	EndIf
	
	' // Fade out to ICE
	If waveC = 6 And tranC = 1 Then SetAlpha levelA1 Else SetAlpha 1
	
	DrawRect 0, lavaY + lavaC, 54, 27
	DrawRect (201 * sclX), lavaY + lavaC, 55, 27
		
	If (GetMilliSecs() >= lavaT + 500) Then
		If tranC <> 0 Then 'lavaC = 0 ' // Don't move during wave transitions
		Else
			If lavaD = 0 Then ' // Ebb
				If lavaC > -3 Then lavaC = lavaC - 1 Else lavaD = 1
			Else
				If lavaC < 0 Then lavaC = lavaC + 1 Else lavaD = 0
			EndIf
		EndIf
		lavaT = GetMilliSecs()
	EndIf
	
	SetColor 255, 255, 255
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² RENDERWAVES - Draws wave status and handles game over
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RenderWaves()

	' // Waves
	If GetMilliSecs() >= waveT + 1000 And GetMilliSecs() <= waveT + 3000 Then
		If waveC = 999 Then ' // Game Over
			DrawFont "Game Over", -1, Int(154 * sclY)			
		Else
			Local tmpStar:String = ""
			If levStar > 0 Then  ' // Star waves
				If levStar = 1 Then 
					tmpStar$ = "&"
				ElseIf levStar = 2 Then
					tmpStar$ = "&&"
				ElseIf levStar = 3 Then
					tmpStar$ = "&&&"
				EndIf				
			EndIf
			DrawFont "Wave " + String(waveC) + tmpStar$, -1, Int(98 * sclY)
			
			If waveC Mod 5 = 0 Then ' // Eggs wave
				DrawFont "Eggs Wave", -1, Int(114 * sclY)
			EndIf
			
			bPter = False; pter_T = GetMilliSecs() ' // Reset pter timer
			sparkT = GetMilliSecs()
		EndIf
	Else ' // Game over check
		If waveC = 999 And GetMilliSecs() >= waveT + 3000 Then 
			For o:Obj = EachIn objList; objList.Remove o; Next ' // Del all objs
			For p:Part = EachIn partList; partList.Remove p; Next ' // Del all parts
			objC = 0; partC = 0
			
			LoadScores ' // Update scores
			
			' // Save high scores
			If p_Score[PLAYER_1] > hi_Score[9] Then
				hi_Save[PLAYER_1] = True 
			Else 
				hi_Save[PLAYER_1] = False
				If b2Player = True And (p_Score[PLAYER_2] > hi_Score[9]) Then hi_Save[PLAYER_2] = True									
			EndIf
			
			FlushKeys
			FlushJoy 0
			FlushJoy 1
			tSel = 0
			
			' // Check for hi scores
			If hi_Save[PLAYER_1] = True Or hi_Save[PLAYER_2] = True Then ' // Enter name screen
				If hi_Save[PLAYER_1] = False And hi_Save[PLAYER_2] = True Then tPlayer = PLAYER_2 Else tPlayer = PLAYER_1
			
				' // Outdo player 1 check
				If b2Player = True And GetScoreNum(p_Score[PLAYER_1]) = 10 Then
					If GetScoreNum(p_Score[PLAYER_2]) <= 10 And GetScoreNum(p_Score[PLAYER_2]) <> 0 Then
						If p_Score[PLAYER_2] > p_Score[PLAYER_1] Then
							hi_Save[PLAYER_1] = False
							tPlayer = PLAYER_2
						EndIf
					EndIf
				EndIf
				
				hi_Place = GetScoreNum(p_Score[tPlayer]) ' // Placement
				place1 = hi_Place
				tScreen = 5
				tSelX = 94; tSelY = 119
				champF = 0; champT = GetMilliSecs()
				hi_Col = 0; hi_T = GetMilliSecs(); hi_Entry$ = ""
			Else
				place1 = -1; place2 = -1
			EndIf
			
			If curSong <> 1 Then
				StopChannel musChan
				musChan = PlaySound(musSong1, musChan)
				curSong = 1
				musChan.SetVolume(Float(cfgMusic) / 10) 
			EndIf
			
			FlushKeys
			FlushJoy 0
			FlushJoy 1
			tSel = 0
			
			bLoopback = True
			
			secretC$ = "" ' // Secret code
			bSecret = False ' // Secret code

			bTitle = True ' // Back to title
		EndIf
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SpawnEnemies - Spawns enemies at start of wave
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SpawnEnemies()

	' // Death between waves fix
	If b2Player = False Then
		If p_GameOver[PLAYER_1] = True Then Return
	Else
		If p_GameOver[PLAYER_1] = True And p_GameOver[PLAYER_2] = True Then Return
	EndIf
	
	' // Create enemies
	If GetMilliSecs() >= waveT + 3000 Then
		If GetMilliSecs() >= (en_T + 750) Then
			
			Local tmpRand:Int = 2
			If waveC <> 1 Then tmpRand = 3
			Local tmpP:Int = Rand(0, tmpRand) ' // Portal
			Local tmpPX:Int, tmpPY:Int
			
			Select levelF

				Case 2, 3, 4, 8, 10, 11, 12 ' // Top middle gone
				Repeat
					tmpP = Rand(0, tmpRand)
				Until tmpP <> 1
				
			End Select
			
			If en_CT <= en_TC Then
				If tmpP = 0 Then ' // Left portal
					tmpPX = Int(20 * sclX); tmpPY = Int(120 * sclY)
					
				ElseIf tmpP = 1 Then ' // Top
					tmpPX = Int(92 * sclX); tmpPY = Int(72 * sclY)

				ElseIf tmpP = 2 Then ' // Right
					tmpPX = Int(204 * sclX); tmpPY = Int(112 * sclY)

				ElseIf tmpP = 3 Then ' // Bottom
					tmpPX = Int(108 * sclX); tmpPY = Int(188 * sclY)
				
				EndIf
				
				If enList[en_CT] <= ENEMY_SHADOW Then
					objList.AddLast obj.Create(tmpPX, tmpPY, enList[en_CT], OBJ_BUZZARD)
					objList.AddLast obj.Create(tmpPX - 9, tmpPY - Int(32 * sclY), 0, OBJ_WARP)
				
					PlaySFX(sfxPad)
					en_C:+1 ' // current
					en_CT:+1 ' // total created
					en_T = GetMilliSecs()
					
				Else enList[en_CT] = ENEMY_EGG ' // Eggs wave
					objList.AddLast obj.Create(Int(16.5 * sclX), Int(57.5 * sclY), -1, OBJ_EGG, 1, 1)
					objList.AddLast obj.Create(Int(88 * sclX), Int(65.5 * sclY), -1, OBJ_EGG, 2, 1)
					objList.AddLast obj.Create(Int(136 * sclX), Int(65.5 * sclY), -1, OBJ_EGG, 3, 1)
					objList.AddLast obj.Create(Int(120.5 * sclX), Int(129.5 * sclY), -1, OBJ_EGG, 4, 1)
					objList.AddLast obj.Create(Int(233 * sclX), Int(113.5 * sclY), -1, OBJ_EGG, 5, 1)
					objList.AddLast obj.Create(Int(64 * sclX), Int(181.5 * sclY), -1, OBJ_EGG, 6, 1)
					objList.AddLast obj.Create(Int(144 * sclX), Int(181.5 * sclY), -1, OBJ_EGG, 7, 1)
					
					en_TC = -1 ' // Done
				EndIf
				
			Else
				en_TC = -1 ' // Done spawning for this wave
			EndIf
				
		EndIf
	EndIf
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SpawnIce - Spawns falling icicles
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SpawnIce()
		
		Local tmpDelay:Int = 2000
		
		Select waveC
			Case 8
			tmpDelay = 2000
			
			Case 9
			tmpDelay = 1500
			
		End Select
			
		If GetMilliSecs() >= sparkT + tmpDelay Then
			sparkT = GetMilliSecs()
		Else
			Return
		EndIf

		Local tmpX:Int, tmpY:Int
		
		Local tmpR:Int
		Repeat ' // Don't stack ice
			If waveC = 8 Then tmpR = Rand(0, 3) ElseIf waveC = 9 Then tmpR = Rand(0, 2) ' // Mid gone
		Until tmpR <> lastIce
		lastIce = tmpR
		
		If tmpR = 0 Then ' // Left side
			tmpY = 256
			tmpX = Rand(1, 79)
		ElseIf tmpR = 1 Then ' // Right side top
			tmpY = 240
			tmpX = Rand(438, 494)
		ElseIf tmpR = 2 Then ' // Right side bottom
			tmpY = 256
			tmpX = Rand(529, 568)
		ElseIf tmpR = 3 Then ' // Middle
			tmpY = 288
			tmpX = Rand(216, 315)
		EndIf
		
		objList.AddLast obj.Create(tmpX, tmpY, 0, OBJ_ICE)		
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SpawnComet - Spawns a comet
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SpawnComet()
		
		Local tmpDelay:Int = 9000
		
		Select waveC
			Case 18
			tmpDelay = 9000
			
			Case 19
			tmpDelay = 7500
			
		End Select
			
		If GetMilliSecs() >= sparkT + (tmpDelay - 800) And GetMilliSecs() <= sparkT + (tmpDelay - 700) Then
			If ChannelPlaying(cometChan) = False Then cometChan = PlaySFX(sfxComet)
		EndIf
		
		If GetMilliSecs() >= sparkT + tmpDelay Then
			sparkT = GetMilliSecs()
		Else
			Return
		EndIf
		
		Local tmpD:Int, tmpX:Int, tmpY:Int, tmpP:Int
		
		' // X
		tmpD = Rand(0, 1)

		' // Y
		tmpY = -32
			
		If tmpD = 0 Then tmpX = Rand(160, 588) ElseIf tmpD = 1 Then tmpX = Rand(0, 428)
		objList.AddLast obj.Create(tmpX, tmpY, tmpD, OBJ_COMET)		
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SpawnRock - Spawns rolling boulders
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SpawnRock()
		
		Local tmpDelay:Int = 9000
		
		Select waveC
			Case 13
			tmpDelay = 9000
			
			Case 14
			tmpDelay = 7500
			
		End Select
		
		If (GetMilliSecs() >= sparkT + (tmpDelay - 1000)) And (GetMilliSecs() <= sparkT + (tmpDelay - 950)) And shakeN = -1 Then ' // Warning
			PlaySound sfxBounce
			shakeN = 0; shakeT = GetMilliSecs(); shakeD = Rand(0, 3)
		EndIf
		
		If GetMilliSecs() >= sparkT + tmpDelay Then
			sparkT = GetMilliSecs()
		Else
			Return
		EndIf
		
		Local tmpD:Int, tmpX:Int, tmpY:Int, tmpP:Int
		If b2Player = True Then tmpP = Rand(0, 1) Else tmpP = 0 ' // Target player
		
		' // X
		If Int(p_X[tmpP]) >= 294 - Int(8 * sclX) Then tmpD = 1 Else tmpD = 0
		
		' // Y
		If Int(p_Y[tmpP]) >= 242 Then ' // Bottom zone
			tmpY = 326
		Else ' // Middle zone
			tmpY = 154
		EndIf
			
		If tmpD = 0 Then tmpX = 588 ElseIf tmpD = 1 Then tmpX = -Int(16 * sclX)
		objList.AddLast obj.Create(tmpX, tmpY, tmpD, OBJ_ROCK)		
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SpawnSpark - Spawns sparks
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SpawnSpark(myType:Int)
		
		Local tmpDelay:Int = 9000
		
		Select waveC
			Case 3, 8, 13
			tmpDelay = 9000
			
			Case 4, 9, 14
			tmpDelay = 7500
			
		End Select
				
		If GetMilliSecs() >= sparkT + tmpDelay Then
			sparkT = GetMilliSecs()
		Else
			Return
		EndIf
		
		Local tmpD:Int, tmpX:Int, tmpY:Int, tmpP:Int
		If b2Player = True Then tmpP = Rand(0, 1) Else tmpP = 0 ' // Target player
		
		' // X
		If Int(p_X[tmpP]) >= 294 - Int(8 * sclX) Then tmpD = 1 Else tmpD = 0
		
		' // Y
		If Int(p_Y[tmpP]) >= 242 Then ' // Bottom zone
			tmpY = 326
		ElseIf Int(p_Y[tmpP]) >= 130 ' // Mid zone
			tmpY = 186
		Else ' // Top Zone
			tmpY = 74
		EndIf
		
		If waveC = 8 Or waveC = 9 Or waveC = 13 Or waveC = 14 Then ' // No top level
			If tmpY = 74 Then tmpY = 186
		EndIf
		
		If tmpD = 0 Then tmpX = 556 ElseIf tmpD = 1 Then tmpX = 16
		objList.AddLast obj.Create(tmpX, tmpY, tmpD, OBJ_SPARK, myType)
		
End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SpawnPter - Spawns pterodactyls
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SpawnPter()

	' Pterodactyl delay
	Local tmpDelay:Int
	If waveC = 1 Then
		tmpDelay = 30000
	ElseIf waveC = 2 Or waveC = 3 Then
		tmpDelay = 25000
	ElseIf waveC = 4 Or waveC = 5 Or waveC = 6 Then
		tmpDelay = 20000
	ElseIf waveC = 7 Or waveC = 8 Or waveC = 9 Then
		tmpDelay = 20000
	ElseIf waveC = 10 Or WaveC = 11 Or waveC = 12 Then
		tmpDelay = 15000
	Else
		tmpDelay = 15000
	EndIf
	
	' // Pterodactyl check 30000
	If bPter = False And GetMilliSecs() >= pter_T + tmpDelay Then
		Local tmpD:Int, tmpX:Int, tmpY:Int, tmpP:Int
		If b2Player = True Then tmpP = Rand(0, 1) Else tmpP = 0 ' // Target player
		
		' // X
		If Int(p_X[tmpP]) >= 294 - Int(8 * sclX) Then tmpD = 1 Else tmpD = 0
		
		' // Y
		If Int(p_Y[tmpP]) >= 242 Then ' // Bottom zone
			tmpY = 302
		ElseIf Int(p_Y[tmpP]) >= 130 ' // Mid zone
			tmpY = 177
		Else ' // Top Zone
			tmpY = 49
		EndIf
		
		If tmpD = 0 Then tmpX = 588 ElseIf tmpD = 1 Then tmpX = -Int(24 * sclX)
		objList.AddLast obj.Create(tmpX, tmpY, tmpD, OBJ_PTER, tmpP)
		
		' // Autogen
		bPter = True
		'pter_T = GetMilliSecs()
		
		pterChan = playSFX(sfxPter)
	EndIf
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² WaveTransition - Handles transitions between waves
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function WaveTransition()

	' // Scan for enemies to make sure
	Local enTest:Int = False 
	bEnemies = False
	For o:Obj = EachIn objList
		If o.ID = OBJ_BUZZARD Or o.ID = OBJ_EGG Then
			bEnemies = True
			enTest = True; Exit
		ElseIf o.ID = OBJ_PTER Then
			enTest = True
		ElseIf o.ID = OBJ_ROCK Then
			enTest = True
		ElseIf o.ID = OBJ_COMET Then
			enTest = True
		EndIf			
	Next

	'enTest = True ' // !DEBUG!
	
	' // Next wave check
	' en_C = 0
	If enTest + tranC = 0 And (GetMilliSecs() >= waveT + 5000) Then
		If waveC < 20 Then waveC:+1 Else waveC = 1; levStar:+1 ' // Wave up
		
		If waveC = 1 Or waveC = 2 Or waveC = 3 Or waveC = 6 Or waveC = 7 Or waveC = 9 Or waveC = 10 Or waveC = 11 Or waveC = 12 Or waveC = 13 Or waveC = 15 Or waveC = 16 Or waveC = 17 Or waveC = 18 Or waveC = 20 Then ' // Wave transitions
			tranC = 1; tranT = GetMilliSecs()
			
			If waveC = 1 Or waveC = 6 Or waveC = 7 Or waveC = 9 Or waveC = 10 Or waveC = 11 Or waveC = 12 Or waveC = 13 Or waveC = 15 Or waveC = 16 Or waveC = 17 Or waveC = 18 Or waveC = 20 Then
				levelA1 = 1
				levelA2 = 0
				
				If waveC = 6 Then
					' // Fade flames
					For o:Obj = EachIn objList
						If o.ID = OBJ_FLAME Then o.A = 2 
					Next 
				ElseIf waveC = 1 Then
					' // Fade stars
					For Local s:Star = EachIn stars
						s.fadeStar()
					Next					
				EndIf
				
			EndIf
						
		Else
			waveT = GetMilliSecs()
			CreateWave(waveC)

		EndIf		
		
		p_eggC[0] = 0; p_airC[0] = 0
		p_eggC[1] = 0; p_airC[1] = 0

		' // Kill Pterodactyls / sparks
		For o:Obj = EachIn objList
			If o.ID = OBJ_PTER Then 
				objList.Remove o; objC:-1
			ElseIf o.ID = OBJ_SPARK Then
				o.F = 4; o.A = 2 ' // Despawn
			ElseIf o.ID = OBJ_ICE Then
				o.F = 2; o.A = 2 ' // Fall
			EndIf
			
		Next 
		bPter = False; pter_T = GetMilliSecs()
		sparkT = GetMilliSecs()
		
	EndIf
		
	If tranC = 1 Then ' // Wave transition
		
		sparkT = GetMilliSecs() ' // BUG FIX
		
		If waveC = 2 Then ' // Wave 2 lava rise
			If GetMilliSecs() >= tranT + 250 Then
				If lavaY > Int(209 * sclY) Then
					lavaY:-1
				Else
					tranC = 0
					waveT = GetMilliSecs()
					en_T = GetMilliSecs()
										
				EndIf
				tranT = GetMilliSecs()
			EndIf
		
		ElseIf waveC = 3 Then ' // Wave 3 lava rise and bridge burn

			If GetMilliSecs() >= tranT + 250 Then
				If lavaY > Int(201 * sclY) Then
					lavaY:-1
				Else
					objList.AddLast obj.Create(-(7 * sclX), 402 - Int(16 * sclY), 1, OBJ_FLAME)
					objList.AddLast obj.Create(588, 402 - Int(16 * sclY), 0, OBJ_FLAME)
		
					tranC = 2 ' // Burn bridge phase
										
				EndIf
				tranT = GetMilliSecs()
			EndIf
		
		ElseIf waveC = 6 Then ' // Wave 6 ICE
			
			' // Lava fall
			If lavaY < Int(217 * sclY) Then
				If GetMilliSecs() >= tranT + 150 Then			
					lavaY:+1
					tranT = GetMilliSecs()
				EndIf
			Else ' // Fade
				lavaY = Int(217 * sclY)

				If GetMilliSecs() >= tranT + 15 Then
					If levelA1 > 0 Then
						levelA1:-.01
						If levelA2 < 1 Then levelA2:+.01 Else levelA2 = 1
											
						' // Music transition
						If cfgMusic > 0 Then 
							If musicD = -1 And curSong = 1 Then
								musicD = 0
								musicV = Float(cfgMusic) / 10
								
							ElseIf musicD = 0 Then ' // Fade out
								musChan.SetVolume(musicV) 
								If musicV > 0 Then musicV:-(Float(cfgMusic) / 475) Else musicV = 0; musicD = 1
								
							ElseIf musicD = 1 Then 	' // Change music
								StopChannel musChan
								musChan = PlaySound(musSong2, musChan)
								curSong = 2
								musChan.SetVolume(0) 
								musicD = 2
								
							ElseIf musicD = 2 Then ' // Fade in
								musChan.SetVolume(musicV) 
								If Int(musicV * 10) < cfgMusic Then musicV:+(Float(cfgMusic) / 475) Else musicD = 3
								'DebugLog "Fade in: " + musicV
								
							ElseIf musicD = 3 Then ' // Finished
								musChan.SetVolume(Float(cfgMusic) / 10) 
								musicD = -1
							EndIf
						EndIf
						

					Else
						If curSong <> 2 Then ' // Failsafe
							StopChannel musChan
							musChan = PlaySound(musSong2, musChan)
							curSong = 2
						EndIf
						musChan.SetVolume(Float(cfgMusic) / 10)
						musicD = -1
						
						levelA1 = 0
						levelA2 = 1
					
						levelF = 2
						
						lastIce = -1
						
						tranC = 0
						waveT = GetMilliSecs()
						en_T = GetMilliSecs()
						
						' // Delete all fireballs
						For o:Obj = EachIn objList
							If o.ID = OBJ_FIREBALL Then objList.Remove o
						Next 

					EndIf
				
					tranT = GetMilliSecs()
				EndIf
				
			EndIf
			
		ElseIf waveC = 7 Or waveC = 9 Or waveC = 10 Or waveC = 12 Or waveC = 13 Or waveC = 15 Or waveC = 17 Or waveC = 18 Or waveC = 20 Then ' // Platforms transition
			
			If GetMilliSecs() >= tranT + 15 Then

				If levelA1 > 0 Then
					levelA1:-.01
					If levelA2 < 1 Then levelA2:+.01 Else levelA2 = 1
				Else
					levelA1 = 0
					levelA2 = 1	
					levelF:+1
					
					tranC = 0
					waveT = GetMilliSecs()
					en_T = GetMilliSecs()
				EndIf

				tranT = GetMilliSecs()
			EndIf
		
		ElseIf waveC = 11 ' // Wave 11 EARTH

			lavaY = Int(217 * sclY)

			If GetMilliSecs() >= tranT + 15 Then
				If levelA1 > 0 Then
					levelA1:-.01
					If levelA2 < 1 Then levelA2:+.01 Else levelA2 = 1

					' // Music transition
					If cfgMusic > 0 Then 
						If musicD = -1 And curSong = 2 Then
							musicD = 0
							musicV = Float(cfgMusic) / 10
							
						ElseIf musicD = 0 Then ' // Fade out
							musChan.SetVolume(musicV) 
							If musicV > 0 Then musicV:-(Float(cfgMusic) / 475) Else musicV = 0; musicD = 1
							
						ElseIf musicD = 1 Then 	' // Change music
							StopChannel musChan
							musChan = PlaySound(musSong3, musChan)
							curSong = 3
							musChan.SetVolume(0) 
							musicD = 2
							
						ElseIf musicD = 2 Then ' // Fade in
							musChan.SetVolume(musicV) 
							If Int(musicV * 10) < cfgMusic Then musicV:+(Float(cfgMusic) / 475) Else musicD = 3
							'DebugLog "Fade in: " + musicV
							
						ElseIf musicD = 3 Then ' // Finished
							musChan.SetVolume(Float(cfgMusic) / 10) 
							musicD = -1
						EndIf
					EndIf
											
				Else
					If curSong <> 3 Then ' // Failsafe
						StopChannel musChan
						musChan = PlaySound(musSong3, musChan)
						curSong = 3
					EndIf
					musChan.SetVolume(Float(cfgMusic) / 10)
					musicD = -1
						
					levelA1 = 0
					levelA2 = 1

					levelF = 6
					
					tranC = 0
					waveT = GetMilliSecs()
					en_T = GetMilliSecs()
					
					' // Fade all snow
					For p:Part = EachIn partList
						If p.ID = PART_SNOW Then p.A = 1
					Next 

				EndIf
			
				tranT = GetMilliSecs()
			EndIf
									
		ElseIf waveC = 16 ' // Wave 16 MOON

			lavaY = Int(217 * sclY)

			If GetMilliSecs() >= tranT + 15 Then
				If levelA1 > 0 Then
					levelA1:-.01
					If levelA2 < 1 Then levelA2:+.01 Else levelA2 = 1

					' // Music transition
					If cfgMusic > 0 Then 
						If musicD = -1 And curSong = 3 Then
							musicD = 0
							musicV = Float(cfgMusic) / 10
							
						ElseIf musicD = 0 Then ' // Fade out
							musChan.SetVolume(musicV) 
							If musicV > 0 Then musicV:-(Float(cfgMusic) / 475) Else musicV = 0; musicD = 1
							
						ElseIf musicD = 1 Then 	' // Change music
							StopChannel musChan
							musChan = PlaySound(musSong4, musChan)
							curSong = 4
							musChan.SetVolume(0) 
							musicD = 2
							
						ElseIf musicD = 2 Then ' // Fade in
							musChan.SetVolume(musicV) 
							If Int(musicV * 10) < cfgMusic Then musicV:+(Float(cfgMusic) / 475) Else musicD = 3
							'DebugLog "Fade in: " + musicV
							
						ElseIf musicD = 3 Then ' // Finished
							musChan.SetVolume(Float(cfgMusic) / 10) 
							musicD = -1
						EndIf
					EndIf
											
				Else
					If curSong <> 4 Then ' // Failsafe
						StopChannel musChan
						musChan = PlaySound(musSong4, musChan)
						curSong = 4
					EndIf
					musChan.SetVolume(Float(cfgMusic) / 10)
					musicD = -1
						
					levelA1 = 0
					levelA2 = 1

					levelF = 10
					
					tranC = 0
					waveT = GetMilliSecs()
					en_T = GetMilliSecs()
					
					' // Reset stars
					For Local s:Star = EachIn stars
						s.Init()
					Next

					' // Fade all snow
					'For p:Part = EachIn partList
						'	If p.ID = PART_SNOW Then p.A = 1
					'Next 

				EndIf
			
				tranT = GetMilliSecs()
			EndIf
		
		ElseIf waveC = 1 Then ' // Moon to lava
										
			lavaY = Int(217 * sclY)

			If GetMilliSecs() >= tranT + 15 Then
				If levelA1 > 0 Then
					levelA1:-.01
					If levelA2 < 1 Then levelA2:+.01 Else levelA2 = 1

					' // Music transition
					If cfgMusic > 0 Then 
						If musicD = -1 And curSong = 3 Then
							musicD = 0
							musicV = Float(cfgMusic) / 10
							
						ElseIf musicD = 0 Then ' // Fade out
							musChan.SetVolume(musicV) 
							If musicV > 0 Then musicV:-(Float(cfgMusic) / 475) Else musicV = 0; musicD = 1
							
						ElseIf musicD = 1 Then 	' // Change music
							StopChannel musChan
							musChan = PlaySound(musSong1, musChan)
							curSong = 1
							musChan.SetVolume(0) 
							musicD = 2
							
						ElseIf musicD = 2 Then ' // Fade in
							musChan.SetVolume(musicV) 
							If Int(musicV * 10) < cfgMusic Then musicV:+(Float(cfgMusic) / 475) Else musicD = 3
							'DebugLog "Fade in: " + musicV
							
						ElseIf musicD = 3 Then ' // Finished
							musChan.SetVolume(Float(cfgMusic) / 10) 
							musicD = -1
						EndIf
					EndIf
											
				Else
					If curSong <> 1 Then ' // Failsafe
						StopChannel musChan
						musChan = PlaySound(musSong1, musChan)
						curSong = 1
					EndIf
					musChan.SetVolume(Float(cfgMusic) / 10)
					musicD = -1
						
					levelA1 = 0
					levelA2 = 1

					levelF = 0
					
					tranC = 0
					waveT = GetMilliSecs()
					en_T = GetMilliSecs()
					
					' // Reset stars
					'For Local s:Star = EachIn stars
					'	s.Init()
					'Next

					' // Fade all snow
					'For p:Part = EachIn partList
						'	If p.ID = PART_SNOW Then p.A = 1
					'Next 

				EndIf
			
				tranT = GetMilliSecs()
			EndIf
													
		EndIf

		If tranC = 0 Then CreateWave(waveC) ' // Create enemies
				
	EndIf		

End Function
	
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADIMAGES - Load images with desired filter
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadImages(bFil:Int)

	bFilter = bFil ' // Public
	
	Local imgFlags:Int
	If bFil = True Then imgFlags = MASKEDIMAGE|FILTEREDIMAGE Else imgFlags = MASKEDIMAGE

	' // Images
	imgRider[0] = Null; imgRider[1] = Null
	imgRiderR[0] = Null; imgRiderR[1] = Null
	imgTitle = Null
	imgLevel = Null
	imgFire = Null
	imgCRT = Null
	imgFont = Null
	imgEgg = Null
	imgBounder = Null
	imgBurst = Null
	imgWarp = Null
	imgPoints = Null
	imgHatched = Null
	imgMount = Null
	imgMountS = Null
	imgPal = Null
	imgFlame = Null
	imgPter = Null
	imgGold = Null
	imgHunter = Null
	imgShadow = Null
	imgChamp = Null
	imgChamp2 = Null
	imgBurst2 = Null
	imgSpark = Null
	imgWater = Null
	imgRock = Null
	imgRain = Null
	imgMenu = Null
	imgIce = Null
	imgComet = Null
	
	' // Pixmaps
	pixRiderP[0] = Null; pixRiderP[1] = Null
	
	SetMaskColor 255, 0, 255
	
	' // Rider graphics
	For Local i:Int = 0 To 1
		imgRider[i] = LoadAnimImage("gfx/rider" + String(i + 1) + ".png", 16, 24, 0, 20, imgFlags)
		imgRiderR[i] = LoadImage("gfx/rider" + String(i + 1) + "r.png", imgFlags)
		pixRiderP[i] = LoadPixmap("gfx/rider" + String(i + 1) + "p.png")
	Next
	
	' // Hi score riders
	For Local i:Int = 0 To 9
		hi_Img[i] = Null
		hi_Img[i] = LoadImage("gfx/hi" + String(i) + ".png", imgFlags)
	Next
	
	imgTitle = LoadImage("gfx/title.png", imgFlags)
	imgLevel = LoadAnimImage("gfx/world.png", 256, 224, 0, 14, imgFlags)
	imgWater = LoadAnimImage("gfx/water.png", 256, 224, 0, 3, imgFlags)

	imgFire = LoadImage("gfx/part2.png", imgFlags)
	imgCRT = LoadImage("gfx/crt5.png", MASKEDIMAGE)
	imgFont = LoadAnimImage("gfx/font.png", 8, 8, 0, 64, imgFlags)
	imgEgg = LoadAnimImage("gfx/egg.png", 8, 8, 0, 4, imgFlags)
	imgBounder = LoadAnimImage("gfx/bounder.png", 16, 24, 0, 14, imgFlags)
	imgHunter = LoadAnimImage("gfx/hunter.png", 16, 24, 0, 14, imgFlags)
	imgShadow = LoadAnimImage("gfx/shadow.png", 16, 24, 0, 14, imgFlags)
	imgBurst = LoadAnimImage("gfx/burst.png", 13, 13, 0, 3, imgFlags)
	imgWarp = LoadImage("gfx/warp.png", imgFlags)
	imgPoints = LoadAnimImage("gfx/points.png", 15, 6, 0, 5, imgFlags)
	imgHatched = LoadAnimImage("gfx/hatched.png", 8, 14, 0, 4, imgFlags)
	imgMount = LoadAnimImage("gfx/mount.png", 16, 16, 0, 12, imgFlags)
	imgMountS = LoadAnimImage("gfx/mounts.png", 16, 16, 0, 12, imgFlags)
	imgFlame = LoadAnimImage("gfx/flame.png", 8, 16, 0, 3, imgFlags)
	imgPal = LoadImage("gfx/pal_x.png", imgFlags)
	imgPter = LoadAnimImage("gfx/pter.png", 24, 16, 0, 10, imgFlags)
	imgGold = LoadAnimImage("gfx/gold.png", 24, 16, 0, 10, imgFlags)
	imgChamp = LoadAnimImage("gfx/champ.png", 266, 14, 0, 7, imgFlags)
	imgChamp2 = LoadAnimImage("gfx/champ2.png", 266, 14, 0, 7, imgFlags)
	imgBurst2 = LoadAnimImage("gfx/burst2.png", 13, 13, 0, 3, imgFlags)
	imgSpark = LoadAnimImage("gfx/spark2.png", 8, 8, 0, 27, imgFlags)
	imgRock = LoadAnimImage("gfx/rock.png", 16, 16, 0, 4, imgFlags)
	imgRain = LoadImage("gfx/rain.png", imgFlags)
	imgMenu = LoadAnimImage("gfx/menu.png", 96, 48, 0, 2, imgFlags)
	imgIce = LoadAnimImage("gfx/ice2.png", 6, 12, 0, 3, imgFlags)
	imgComet = LoadAnimImage("gfx/comet.png", 16, 16, 0, 4, imgFlags)
	
	MidHandleImage imgFire
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWSTARIMAGE - Creates star image                                   
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawStarImage:TImage(mode:Int = 0)

	Local sImage:TImage = CreateImage(64,64)
	SetScale 1, 1
	
	Cls
	SetBlend LIGHTBLEND
	SetAlpha .05
	For Local i:Int = 1 To 32
		If mode = 0 Then ' // Blue
			SetColor (32-i)*8,(32-i)*8,255 
		ElseIf mode = 1 Then ' // White
			SetColor (32-i)*20,(32-i)*20,(32-i)*20
		EndIf
		DrawOval (32-i),(32-i), i*2,i*2  
	Next
	SetLineWidth 3.0
	If mode = 0 Then ' // Blue
		SetColor 128,128,255
	ElseIf mode = 1 Then
		SetColor 178,178,178
	EndIf
	SetAlpha .125
	DrawLine 32,0,32,64
	DrawLine 8,32,56,32
	SetLineWidth 1.0
	DrawLine 32,4,32,60
	DrawLine 12,32,52,32
	DrawLine 4,4,60,60
	DrawLine 60,4,4,60
	
	GrabImage sImage,0,0

	SetColor 255, 255, 255
	SetBlend ALPHABLEND; SetAlpha 1
	SetScale sclX, sclY

	Return sImage

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETMILLISECS - MilliSecs rollover fix                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetMilliSecs:Int()

	If LastMilliSecs = 0 Then LastMilliSecs = MilliSecs() 
	
	If MilliSecs() > LastMilliSecs Then MyMilliSecs = MyMilliSecs + (MilliSecs() - LastMilliSecs)
	If MilliSecs() < LastMilliSecs Then MyMilliSecs = MyMilliSecs + (LastMilliSecs - MilliSecs())

	LastMilliSecs = MilliSecs()
	Return MyMilliSecs - pauseTotal ' // Time offset fix
    
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWSCORE - Renders player score and lives       
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawScore(i:Int)

	Local tmpS:String

	tmpS$ = String(p_Score[i])
	If Len(tmpS$) = 1 Then 
		tmpS$ = "00000" + tmpS$
	ElseIf Len(tmpS$) = 2 Then
		tmpS$ = "0000" + tmpS$
	ElseIf Len(tmpS$) = 3 Then
		tmpS$ = "000" + tmpS$
	ElseIf Len(tmpS$) = 4 Then
		tmpS$ = "00" + tmpS$
	ElseIf Len(tmpS$) = 5 Then
		tmpS$ = "0" + tmpS$
	EndIf
	
	SetColor 252, 252, 252

	Local tmpL:Int = p_Lives[i]
	If tmpL > 9 Then tmpL = 9 ' // Cap lives
	
	If i = PLAYER_1 Then
		' // Score
		DrawFont tmpS$, Int(49 * sclX), Int(193 * sclY)
				
		' // Lives
		DrawFont ">=" + String(tmpL), Int(96 * sclX), Int(193 * sclY)

	ElseIf i = PLAYER_2 Then
		SetColor 0, 232, 216
		' // Score
		DrawFont tmpS$, Int(137 * sclX), Int(193 * sclY)
		
		' // Lives
		DrawFont "^=" + String(tmpL), Int(184 * sclX), Int(193 * sclY)	
		
	EndIf
	
	SetColor 255, 255, 255
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NumFormat - Draws numbers with comma placement                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NumFormat:String(myStr$)

	If Len(myStr$) = 4 Then ' // Thousand
		myStr$ = Left$(myStr$, 1) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 5 Then ' // Ten thousand
		myStr$ = Left$(myStr$, 2) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 6
		myStr$ = Left$(myStr$, 3) + "," + Right$(myStr$, 3)

	EndIf
	
	Return myStr$
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² RENDERHIBORDER - Draws hi score screen border                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RenderHiBorder()

	SetColor 255, 255, 255
	'DrawFont "Joust Champions", -1, 30
	SetScale 1.001, 1.001
	If bOnline = False Then
		DrawImage imgChamp, 161, 20, champF
	Else
		DrawImage imgChamp2, 161, 20, champF
	EndIf
	
	SetScale sclX, sclY
	
	If GetMilliSecs() >= champT + 120 Then
		If champF < 6 Then champF:+1 Else champF = 0
		champT = GetMilliSecs()
	EndIf
				
	' // Draw rotating border
	Local tmpOff:Int = hi_Col
	Local tmpOff2:Int = hi_Col
	Local tmpOff3:Int = hi_Col + 4
	If tmpOff3 > 7 Then tmpOff3 = tmpOff3 - 8
	Local tmpOff4:Int = hi_Col
	If tmpOff4 > 7 Then tmpOff4 = tmpOff4 - 8
	
	Local tmpY2:Int = 0
	
	For Local tmpX:Int = 0 To 588 Step 28
		SetHiColor(tmpOff)				
		DrawRect tmpX, 0, 14, 4
		SetHiColor(tmpOff3)				
		DrawRect 588 - Int(4 * sclX), tmpY2, 4, 14

		If tmpOff < 7 Then tmpOff:+1 Else tmpOff = 0
		If tmpOff3 < 7 Then tmpOff3:+1 Else tmpOff3 = 0
		
		SetHiColor(tmpOff2)
		DrawRect 0, tmpY2, 4, 14
		SetHiColor(tmpOff4)
		DrawRect tmpX, 448 - Int(4 * sclY), 14, 4
		
		If tmpOff2 > 0 Then tmpOff2:-1 Else tmpOff2 = 7			
		If tmpOff4 > 0 Then tmpOff4:-1 Else tmpOff4 = 7
		
		'If tmpOff3 < 0 Then tmpOff3:-1 Else tmpOff3 = 7
		tmpY2:+28
	Next
	
	If GetMilliSecs() >= hi_T + 200 Then
		If hi_Col < 7 Then hi_Col:+1 Else hi_Col = 0
		hi_T = GetMilliSecs()
	EndIf
			
End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ISMOON - Determines whether or not it's a moon level                                   
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function IsMoon:Int()

	If levelF >= 10 And levelF <= 13 Then Return True Else Return False
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWFONT - Draws bitmap font                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawFont(myStr:String, X:Int, Y:Int)

	Local i:Int
	If X = -1 Then ' // Center text
		Local tmpW:Int
		X = 294
		For i = 1 To Len(myStr$)
			tmpW:+(8 * sclX)
		Next
		X:-Int(tmpW / 2)
	EndIf
	
	Local tmpX:Int = X, tmpY:Int = Y, tmpA:Int, tmpF:Int
	For i = 1 To Len(myStr)
		tmpA = Asc(Upper$(Mid$(myStr$, i, 1)))
		
		If tmpA >= 48 And tmpA <= 57 Then ' // Numbers
			tmpF = tmpA - 47
		ElseIf tmpA >= 65 And tmpA <= 90 Then ' // Letters
			tmpF = tmpA - 54
		ElseIf tmpA = 32 Then ' // Space
			tmpF = 0
		ElseIf tmpA = 46 Then ' // Period
			tmpF = 39
		ElseIf tmpA = 42 Then ' // Asterisk
			tmpF = 47
		ElseIf tmpA = 37 Then ' // Percent
			tmpF = 51
		ElseIf tmpA = 62 Then ' // Player 1
			SetColor 255, 255, 255
			tmpF = 43
		ElseIf tmpA = 61 Then ' // Equals
			tmpF = 42
		ElseIf tmpA = 94 Then ' // Player 2
			SetColor 255, 255, 255
			tmpF = 44
		ElseIf tmpA = 41 Then ' // )
			tmpF = 50
		ElseIf tmpA = 44 Then ' // Comma
			tmpF = 40
		ElseIf tmpA = 45 Then ' // Hyphen
			tmpF = 38
		ElseIf tmpA = 33 Then ' // Exclamation
			tmpF = 45
		ElseIf tmpA = 58 Then ' // Colon
			tmpF = 41
		ElseIf tmpA = 35 Then ' // Hash
			tmpF = 47
		ElseIf tmpA = 36 Then ' // $ Up arrow
			tmpF = 53
		ElseIf tmpA = 43 Then ' // + Down arrow
			tmpF = 52
		ElseIf tmpA = 38 Then ' // & Wave star
			tmpF = 54
		EndIf
		
		DrawImage imgFont, tmpX, tmpY, tmpF
		tmpX:+(8 * sclX)
		
		If tmpA = 94 Then SetColor 0, 232, 216 ' // 2 player score color reset

	Next
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADCFG - Reads in CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadCFG()

	Local File:TStream = ReadFile("joustx.cfg")
	cfgSFX = ReadInt(File)
	cfgMusic = ReadInt(File)
	cfgFilter = ReadInt(File)
	cfgCRT = ReadInt(File)
	cfgFull = ReadInt(File)
	
	p_Col1[PLAYER_1] = ReadInt(File)
	p_Col2[PLAYER_1] = ReadInt(File)
	p_Col3[PLAYER_1] = ReadInt(File)
	p_Col1[PLAYER_2] = ReadInt(File)
	p_Col2[PLAYER_2] = ReadInt(File)
	p_Col3[PLAYER_2] = ReadInt(File)
	
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADINPUT - Reads in input CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadInput()

	Local File:TStream = ReadFile("input.cfg")
	
	For Local j:Int = 0 To 1
		For Local i:Int = 0 To 6
			inKey[j, i] = ReadLine(File)

			If j = 0 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J1" Then p1Joy = 1
			ElseIf j = 1 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J0" Then p2Joy = 0
			EndIf
			
		Next
	Next
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETINPUT - Converts inkeys to inputs                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetInput:Int(j:Int, i:Int, d:Int = 0)

	Local tmpRet:Int = False
	Local tmp:String = inKey[j, i]
	
	If Left$(tmp$, 1) = "K" Then ' // Keyboard
		tmp$ = Replace$(tmp$, "K", "")
		If d = 0 Then ' // KeyHit
			If KeyHit(Int(tmp$)) = True Then tmpRet = True		
		ElseIf d = 1 Then ' // KeyDown
			If KeyDown(Int(tmp$)) = True Then tmpRet = True
		EndIf
	ElseIf Left$(tmp$, 2) = "J0" Then ' // Joy 1
		If tmp$ = "J0U" Then ' // Up
			If JoyY(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0D" Then ' // Down
			If JoyY(0) = 1 Then tmpRet = True
		ElseIf tmp$ = "J0L" Then ' // Left
			If JoyX(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0R" Then ' // Right
			If JoyX(0) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J0", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 0) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 0) = True Then tmpRet = True
			EndIf
		EndIf
		
	ElseIf Left$(tmp$, 2) = "J1" Then ' // Joy 2
		If tmp$ = "J1U" Then ' // Up
			If JoyY(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1D" Then ' // Down
			If JoyY(1) = 1 Then tmpRet = True
		ElseIf tmp$ = "J1L" Then ' // Left
			If JoyX(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1R" Then ' // Right
			If JoyX(1) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J1", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 1) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 1) = True Then tmpRet = True
			EndIf
		EndIf
		
	EndIf
	
	Return tmpRet
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVECFG - Writes CFG file                                 
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveCFG()

	Local File:TStream = WriteFile("joustx.cfg")
	WriteInt File, cfgSFX
	WriteInt File, cfgMusic
	WriteInt File, cfgFilter
	WriteInt File, cfgCRT
	WriteInt File, cfgFull
	WriteInt File, p_Col1[PLAYER_1]
	WriteInt File, p_Col2[PLAYER_1]
	WriteInt File, p_Col3[PLAYER_1]
	WriteInt File, p_Col1[PLAYER_2]
	WriteInt File, p_Col2[PLAYER_2]
	WriteInt File, p_Col3[PLAYER_2]
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVEDEFSCORES - Writes default scores and images                               
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveDefScores()

	hi_Name:String[] = ["Eikon", "Sonata", "JBaily", "Useful", "Charo", "Pibb", "Conrad", "MDE", "Steely", "Bytor"]
	hi_Score:Int[] = [50000, 45000, 40000, 35000, 30000, 25000, 22500, 20000, 17500, 15000]

	Local File:TStream = WriteFile("hiscore.dat")
	For Local i:Int = 0 To 9
		WriteString(File, LSet(hi_Name$[i], 6)) ' // Padded string
		WriteInt(File, hi_Score[i])

		Local tmpPix:TPixmap = LockImage(imgRider[0], 15)
		SavePixmapPNG(tmpPix, "gfx/hi" + String(i) + ".png", 9)
		UnlockImage imgRider[0], 15
		tmpPix = Null
		
	Next
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETSCORENUM - Gets high score placement                              
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetScoreNum:Int(myScore:Int)

	Local File:TStream = ReadFile("hiscore.dat")
	For Local i:Int = 0 To 9
		hi_Name$[i] = ReadString(File, 6)
		hi_Score[i] = ReadInt(File)
	Next
	CloseFile File

	Local tmpW:Int = -1
	For Local i:Int = 0 To 9
		If myScore > hi_Score[i] Then tmpW = i; Exit
	Next

	Return tmpW + 1
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVESCORES - Save hi scores                               
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveScores(myName:String, myScore:Int, tmpPlayer:Int)

	Local i:Int
	Local File:TStream
		
	File = ReadFile("hiscore.dat")
	For i = 0 To 9
		hi_Name$[i] = ReadString(File, 6)
		hi_Score[i] = ReadInt(File)
	Next
	CloseFile File

	Local tmpW:Int = -1
	For i = 0 To 9
		If myScore > hi_Score[i] Then tmpW = i; Exit
	Next

	If tmpW > -1 Then
		If tmpW < 9 Then
			For i = 9 To tmpW + 1 Step -1
				hi_Score[i] = hi_Score[i - 1]
				hi_Name$[i] = hi_Name$[i - 1]
				
				' // Rename image file
				DeleteFile "gfx/hi" + String(i) + ".png"
				RenameFile("gfx/hi" + String(i - 1) + ".png", "gfx/hi" + String(i) + ".png")
			Next
		EndIf
				
		hi_Score[tmpW] = myScore
		hi_Name$[tmpW] = myName$

		Local tmpPix:TPixmap = LockImage(imgRider[tmpPlayer], 15)
		SavePixmapPNG(tmpPix, "gfx/hi" + String(tmpW) + ".png", 9)
		UnlockImage imgRider[tmpPlayer], 15
		tmpPix = Null
				
	EndIf

	File = WriteFile("hiscore.dat")
	For i = 0 To 9
		WriteString(File, LSet(hi_Name$[i], 6)) ' // Padded string
		WriteInt(File, hi_Score[i])
	Next
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADSCORES - Loads hi scores
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadScores()
	
	Local bFil:Int = bFilter, imgFlags:Int
	If bFil = True Then imgFlags = MASKEDIMAGE|FILTEREDIMAGE Else imgFlags = MASKEDIMAGE

	Local File:TStream = ReadFile("hiscore.dat")
	For Local i:Int = 0 To 9
		hi_Name$[i] = ReadString(File, 6)
		hi_Score[i] = ReadInt(File)
		hi_Img[i] = Null
		hi_Img[i] = LoadImage("gfx/hi" + String(i) + ".png", imgFlags)
	Next
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ENDGAME - Ends program                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function EndGame()
	SaveCFG()
	End
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVESCREEN - Saves a PNG snapshot                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveScreen()
	Local tmpFN:Int = 0, Dir:Byte Ptr = ReadDir("snaps/"), file$
	Local tmpP:Int, tmpU:Int, tmpN:Int

	Repeat 
		file$ = NextFile(Dir)
		If FileType("snaps/" + file$) = 1 Then
			tmpP = Instr(file$, ".", 1)
			tmpU = Instr(file$, "_", 1)
			tmpN = Int(Mid(file$, tmpU + 1, tmpP - tmpU))
			If tmpN > tmpFN Then tmpFN = tmpN ' // New filenumber
		EndIf
	Until file$ = ""
	CloseDir Dir

	Local tmpX:Int, tmpY:Int
	If bWindowed = False Then tmpX = 26; tmpY = 16 Else tmpX = 0; tmpY = 0

	SetMaskColor 255, 0, 255
	Local imgScreen:TPixmap = GrabPixmap(tmpX, tmpY, 588, 448)
	SavePixmapPNG(imgScreen, "snaps/snap_" + (tmpFN + 1) + ".png", 9)
	
	imgScreen = Null
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² UPLOADSCORE - Uploads score via FTP                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function UploadScore(myScore:String)

	' // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	' // CODE REMOVED TO KEEP ONLINE SCORES SECURE
	' // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	StopChannel uploadChan	
	PlaySFX sfxPter
		
	FlushKeys
	FlushJoy 0
	FlushJoy 1
				
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² QuickSort - Sorts online hi scores                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function QuickSort(arr:String[], first:Int, last:Int)

	Local pivot:Int = 0
	Local temp:String
	Local i:Int = 0
	Local j:Int = 0

	If first < last Then
		pivot = first
		i = first
		j = last

		While (i < j)			
			While (Int(Left$(arr[i], Len(arr[i]) - 7)) >= Int(Left$(arr[pivot], Len(arr[pivot]) - 7)) And i < last)
				i = i + 1
			End While

			While (Int(Left$(arr[j], Len(arr[j]) - 7)) < Int(Left$(arr[pivot], Len(arr[pivot]) - 7)))
				j = j - 1
			End While

			If i < j Then
				temp = arr[i]
				arr[i] = arr[j]
				arr[j] = temp
			End If
		End While

		temp = arr[pivot]
		arr[pivot] = arr[j]
		arr[j] = temp
		QuickSort(arr, first, j - 1)
		QuickSort(arr, j + 1, last)
	End If

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LEGACY FUNCTIONS                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RectsOverlap%(x0:Int, y0:Int, w0:Int, h0:Int, x2:Int, y2:Int, w2:Int, h2:Int)
	If x0 > (x2 + w2) Or (x0 + w0) < x2 Then Return False
	If y0 > (y2 + h2) Or (y0 + h0) < y2 Then Return False
	Return True
End Function

Function ImageRectCollide%(image:TImage, ix%, iy%, iframe%, rx%, ry%, rwidth%, rheight%)

   ResetCollisions
   CollideImage image, ix, iy, iframe, 0, 1
   
   If CollideRect(rx, ry, rwidth, rheight, 1, 0) Then Return True Else Return False

End Function