' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ²
' // ² B U B B L E   B O B B L E   R P G
' // ² Version 1.0
' // ²
' // ² By EikSoft (www.EikSoft.com)
' // ² 12.18.23 Project Start
' // ² 4.12.24 Last Modified
' // ²
' // ² For J.B. - In loving memory of Celeste <3
' // ²
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // 
SuperStrict

Framework BRL.Retro

Import BRL.GLMax2D 
Import BRL.D3D9Max2D
Import BRL.PNGLoader
Import BRL.WAVLoader
Import BRL.OGGLoader
Import PUB.FreeJoy
'Import RANDOM.SFMT ' // Mersenne Twister
Import BRL.Random
Import SDL.SDLFreeAudio
'Import BRL.Random

SetAudioDriver("FreeAudio SDL")

AppTitle = "Bubble Bobble RPG v1.0"
SeedRnd MilliSecs()

' // Config
Global cfgSfx:Int = 70
Global cfgMusic:Int = 50
Global cfgFilter:Int = 0
Global cfgCRT:Int = 0
Global cfgFull:Int = 0
Global cfgDiff:Int = 1
Global cfgTrack:Int = 0
Global cfgGFX:Int = 0

' // Input.Cfg
Global inKey:String[2, 8]

Global INP_U:Int = 0, INP_D:Int = 1, INP_L:Int = 2, INP_R:Int = 3, INP_B:Int = 4, INP_A:Int = 5, INP_X:Int = 6, INP_S:Int = 7 
Global p1Joy:Int = 0, p2Joy:Int = 1

LoadCFG()
LoadInput()

If cfgGFX = 0 Then
	SetGraphicsDriver GLMax2DDriver()
ElseIf cfgGFX = 1 Then
	SetGraphicsDriver D3D9Max2DDriver()
EndIf

'#FS
'DefData "FS"
'cfgFull = 0
'cfgSFX = 5
'cfgMusic = 1

' // Master flags
Global bWindowed:Int ' // Windowed
If cfgFull = 0 Then bWindowed = True Else bWindowed = False
Global bTitle:Int = True ' // Title screen
Global bDebug:Int = False ' // Debug info

If bWindowed = True Then 
	Graphics 588, 448, 0, 60
Else
	Graphics 640, 480, 32, 60
	HideMouse
EndIf

' // Loading screen
SetMaskColor 255, 0, 255
imgFont = LoadAnimImage("gfx/font.png", 8, 8, 0, 64, MASKEDIMAGE)
imgFont2 = LoadAnimImage("gfx/font2.png", 8, 8, 0, 64, MASKEDIMAGE)
SetScale 2.299, 2.0
If bWindowed = False Then SetOrigin 26, 16
DrawFont "Loading", -1, 215
Flip

' // Tick count and FPS
Global MyMilliSecs:Int, LastMilliSecs:Int = MilliSecs() ' // MilliSecs FIX
Global FPS:Int, curFrames:Int, frameTimer:Int, fpsTimer:Int = GetMilliSecs() ' // FPS Counter

' // FULL PC IS 2.5 / 2.15
' // FULL CRT IS 2.3 / 2.0
Global sclX:Float = 2.3, sclY:Float = 2.0

' // Joystick
Global bJoy1YHit:Int = False, bJoy1XHit:Int = False
Global bJoy2YHit:Int = False, bJoy2XHit:Int = False

Global bPaused:Int[2], pauseStart:Int, pauseTotal:Int
Global b2Player:Int = False

' // Online high scores
Global net_Score:String[100], netP:Int

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² IMAGES                                           
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global imgCRT:TImage
Global imgFont:TImage
Global imgFont2:TImage
Global imgTitle:TImage
Global imgBub:TImage
Global imgEmber:TImage
Global imgShock:TImage
Global imgMP:TImage
Global imgHeart:TImage
Global imgBubble:TImage
Global imgZen:TImage
Global imgZen2:TImage
Global imgZen3:TImage
Global imgZen4:TImage
Global imgZen5:TImage
Global imgCap:TImage
Global imgTrap:TImage
Global imgFruit:TImage
Global imgGem:TImage
Global imgPoints:TImage
Global imgBlip:TImage
Global imgCol:TImage
Global imgMenu:TImage
Global imgStats:TImage
Global imgStars:TImage
Global imgC1:TImage
Global imgC2:TImage
Global imgFireball:TImage
Global imgFireball2:TImage
Global imgFireball3:TImage
Global imgVolt:TImage
Global imgVolt2:TImage
Global imgVolt3:TImage
Global imgSplash:TImage
Global imgSplash2:TImage
Global imgSplash3:TImage
Global imgFlare:TImage
Global imgMenu2:TImage
Global imgUp:TImage
Global imgSel:TImage
Global imgNext:TImage
Global imgFloat:TImage
Global imgTreasure:TImage
Global imgItems:TImage
Global imgBlank:TImage
Global imgTiles:TImage
Global imgLevel:TImage
Global imgMighta:TImage
Global imgMighta2:TImage
Global imgMighta3:TImage
Global imgMighta4:TImage
Global imgBlast:TImage
Global imgBlast2:TImage
Global imgBlast3:TImage
Global imgBlast4:TImage
Global imgBlast5:TImage
Global imgShop:TImage
Global imgDoor:TImage
Global imgExplode:TImage
Global imgCandy:TImage
Global imgHurry:TImage
Global imgGhost:TImage
Global imgBoss1:TImage
Global imgBoss2:TImage
Global imgScore:TImage
Global imgBossBub:TImage
Global imgBossCap:TImage
Global imgMonsta:TImage
Global imgMonsta2:TImage
Global imgMonsta3:TImage
Global imgSwoosh:TImage
Global imgSwoosh2:TImage
Global imgSwoosh3:TImage
Global imgBag:TImage
Global imgWater:TImage
Global imgZap:TImage
Global imgSLvl:TImage
Global imgComet:TImage
Global imgSpout:TImage
Global imgCross:TImage
Global imgFirework:TImage
Global imgPulpul:TImage
Global imgPulpul2:TImage
Global imgFire:TImage
Global imgFlame:TImage
Global imgGrave:TImage
Global imgBig:TImage
Global imgFlame2:TImage
Global imgBane:TImage
Global imgBuster:TImage
Global imgGonsu:TImage
Global imgDrunk:TImage
Global imgBottle:TImage
Global imgBossBub2:TImage
Global imgTut1:TImage
Global imgTut2:TImage
Global imgTut3:TImage
Global imgDrunk2:TImage
Global imgEnd:TImage
Global imgTBub:TImage
Global imgChars:TImage
Global imgCSel:TImage
Global imgStart:TImage

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SOUNDS                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global sfxPause:TSound = LoadSound("sfx/pause.wav")
Global sfxJump:TSound = LoadSound("sfx/jump.wav")
Global sfxBubble:TSound = LoadSound("sfx/bubble.wav")
Global sfxHit:TSound = LoadSound("sfx/hit.wav")
Global sfxHurt:TSound = LoadSound("sfx/hurt.wav")
Global sfxSpin:TSound = LoadSound("sfx/spin.wav")
Global sfxFruit:TSound = LoadSound("sfx/fruit.wav")
Global sfxCharge:TSound = LoadSound("sfx/charge.wav")
Global sfxFlame:TSound = LoadSound("sfx/flame.wav")
Global sfxPoof:TSound = LoadSound("sfx/poof.wav")
Global sfxEHit:TSound = LoadSound("sfx/ehit.wav")
Global sfxShock:TSound = LoadSound("sfx/shock.wav")
Global sfxSplash:TSound = LoadSound("sfx/splash.wav")
Global sfxLevel:TSound = LoadSound("sfx/level.wav")
Global sfxKey:TSound = LoadSound("sfx/key.wav")
Global sfxItem:TSound = LoadSound("sfx/item.wav")
Global sfxDeath:TSound = LoadSound("sfx/death.wav")
Global sfxOver:TSound = LoadSound("sfx/over.wav")
Global sfxReveal:TSound = LoadSound("sfx/reveal.wav")
Global sfxBomb:TSound = LoadSound("sfx/bomb.wav")
Global sfxBlip:TSound = LoadSound("sfx/blip.wav")
Global sfxGet:TSound = LoadSound("sfx/get.wav")
Global sfxTitle:TSound = LoadSound("sfx/title.wav")
Global sfxChain:TSound = LoadSound("sfx/chain.wav")
Global sfxWater:TSound = LoadSound("sfx/water.wav")
Global sfxZap:TSound = LoadSound("sfx/zap.wav")
Global sfxComet:TSound = LoadSound("sfx/comet.wav")
Global sfxWarn:TSound = LoadSound("sfx/warn.wav")
Global sfxCandy:TSound = LoadSound("sfx/candy.wav")
Global sfxBuster:TSound = LoadSound("sfx/buster.wav")
Global sfxGhost:TSound = LoadSound("sfx/ghost.wav")

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² MUSIC                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global musSong1:TSound
Global musHurry:TSound
Global musAlarm:TSound
Global musGhost:TSound
Global musBoss:TSound
Global musSpecial:TSound
Global musPass:TSound
Global musEnd:TSound
Global musStart:TSound

Global musChan:TChannel = AllocChannel()
Global sfxChan:TChannel = AllocChannel()

Global chargeChan:TChannel[2]
chargeChan[0] = AllocChannel()
chargeChan[1] = AllocChannel()

Global musType:String = "bb1"
If cfgTrack = 1 Then musType = "bb2"

musSong1 = LoadSound("ogg/" + musType$ + "_song1.ogg", SOUND_LOOP)
musHurry = LoadSound("ogg/" + musType$ + "_hurry.ogg", SOUND_LOOP)
musBoss = LoadSound("ogg/" + musType$ + "_boss.ogg", SOUND_LOOP)
musPass = LoadSound("ogg/" + musType$ + "_pass.ogg", SOUND_LOOP)
musAlarm = LoadSound("ogg/" + musType$ + "_alarm.ogg", SOUND_LOOP)
musGhost = LoadSound("ogg/ghost.ogg")
If cfgTrack = 0 Then ' // Special loop
	musSpecial = LoadSound("ogg/" + musType$ + "_special.ogg", SOUND_LOOP)
Else
	musSpecial = LoadSound("ogg/" + musType$ + "_special.ogg")
EndIf
musEnd = LoadSound("ogg/" + musType$ + "_end.ogg", SOUND_LOOP)
musStart = LoadSound("ogg/" + musType$ + "_start.ogg")

'musChan.SetVolume(Float(cfgMusic) / 10)
'musChan = PlaySound(musSong1, musChan)

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² VARIABLES                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //

' // PLAYER
Global p_X:Float[2], p_Y:Float[2], p_D:Int[2], p_F:Int[2], p_T:Int[2], p_Idle:Int[2]
Global p_J:Int[2], p_YI:Float[2], p_Fall:Int[2], p_FT:Int[2], p_Col:Int[2]
Global p_MP:Int[2], p_TMP:Int[2], p_Life:Float[2], p_S:Int[2], p_ST:Int[2]
Global p_Class:Int[2], p_bJump:Int[2], p_Speed:Float[2], p_Atk:Int[2]
Global p_Hurt:Int[2], p_HurtT:Int[2], p_XP:Int[2], p_Chain:Int[2], p_Score:Int[2]
Global p_LifeT:Float[2], p_Lvl:Int[2], p_Charge:Int[2], p_ChargeT:Int[2]
Global p_GMP:Int[2], p_Key:Int[2], p_Items:Int[2, 6], p_Item:Int[2], p_Dead:Int[2]
Global p_Points:Int[2], p_MChain:Int[2], p_MChainT:Int[2], p_MChainX:Int[2], p_MChainY:Int[2]
Global p_SpellL:Int[2], p_SpellC:Int[2], p_Zap:Int[2], p_ZapT:Int[2], p_Flame:Int[2]
Global p_Warn:Int[2], p_WarnT:Int[2], p_BombC:Int[2], p_BombT:Int[2]

' // GLOBAL
Global bubCount:Int
Global bubY:Int = 95, bubX:Int = 276
Global spec1X:Int, spec1Y:Int, spec1D:Int, spec2X:Int, spec2Y:Int, spec2D:Int
Global poppedID:Int = 0, spinT:Int
Global lvlC:Int[3], nextLevel:Int, nextT:Int, levelYI:Float, levelYD:Int, levelSel:Int
Global enemyC:Int, menuY:Int, menuT:Int, levelY:Int, floatF:Int, floatT:Int
Global keyT:Int, keyTime:Int, chestX:Int, chestY:Int, keyX:Int, keyY:Int, reloadC:Int
Global candyT:Int, candyTime:Int, candyX:Int, candyY:Int
Global allDrop:Int, oldTile:Int, objC:Int, chestT:Int
Global lastItem:Int[2], keeperF:Int, keeperT:Int, bLooped:Int
Global ghostT:Int, ghostC:Int, bSpecial:Int, bFastMus:Int, lastLevel:Int
Global bMoney:Int, specC:Int, sfxWaterT:Int, bHasSpawn2:Int
Global baseHearts:Int = 4, fruitChan:Int

Global bJBMode:Int = False
Global bXMode:Int = False
Global rXTile:Int[5]

#LEVEL
DefData "LEVEL"
Global curLevel:Int = 1
lastLevel = curLevel

Const MAX_TILES:Int = 99 ' // Max tiles

Global arrLev:Int[32, 28], levelTile:Int = Rand(0, 9)
Global arrTiles:Int[MAX_TILES + 1]
Global arrDat:Int[] = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CONSTANTS                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Const PLAYER_1:Int = 0
Const PLAYER_2:Int = 1

' // Player classes
Const CLASS_BUBBLE:Int = 0
Const CLASS_EMBER:Int = 1
Const CLASS_SHOCK:Int = 2

' // Level tiles
Const TILE_BLOCK:Int = 1
Const TILE_ENEMYR:Int = 2
Const TILE_KEY:Int = 3
Const TILE_CHEST:Int = 4
Const TILE_BUBBLE:Int = 5
Const TILE_ENEMYL:Int = 6
Const TILE_FLYERR:Int = 7
Const TILE_FLYERL:Int = 8
Const TILE_FILL:Int = 9
Const TILE_SSPAWN1:Int = 10
Const TILE_SSPAWN2:Int = 11
Const TILE_SDEST1:Int = 12
Const TILE_SDEST2:Int = 13
Const TILE_BANER:Int = 14
Const TILE_BANEL:Int = 15

' // Reserved tiles
Const TILE_WATER:Int = 100
Const TILE_ZAP:Int = 101
Const TILE_FIRE:Int = 102
Const TILE_NOCOL:Int = 103
Const TILE_ZAPWATER:Int = 104

' // Special bubbles
Const BUB_WATER:Int = 100
Const BUB_ZAP:Int = 101
Const BUB_FIRE:Int = 102
Const BUB_ZAPWATER:Int = 104

' // Particles
Const PART_POP:Int = 1
Const PART_POINTS:Int = 2
Const PART_FADE:Int = 3
Const PART_GHOST:Int = 4
Const PART_POWER:Int = 5
Const PART_EXPLODE:Int = 6
Const PART_LEVELUP:Int = 7
Const PART_HURRY:Int = 8
Const PART_SCORE:Int = 9
Const PART_BOSSBUB:Int = 10
Const PART_WATER:Int = 11
Const PART_ZAP:Int = 12
Const PART_FLAME:Int = 13
Const PART_TBUB:Int = 14

' // Objects
Const OBJ_ZEN:Int = 1
Const OBJ_DEAD:Int = 2
Const OBJ_FRUIT:Int = 3
Const OBJ_GEM:Int = 4
Const OBJ_KEY:Int = 5
Const OBJ_CHEST:Int = 6
Const OBJ_ITEM:Int = 7
Const OBJ_CANDY:Int = 8
Const OBJ_GHOST:Int = 9
Const OBJ_BOSS1:Int = 10
Const OBJ_SPAWN:Int = 11

' // Shots
Const SHOT_FIREBALL:Int = 1
Const SHOT_WAVE:Int = 2
Const SHOT_SPOUT:Int = 3
Const SHOT_BLAST:Int = 4
Const SHOT_BOMB:Int = 5
Const SHOT_BLAST2:Int = 6
Const SHOT_SWOOSH:Int = 7
Const SHOT_COMET:Int = 8
Const SHOT_CROSS:Int = 9
Const SHOT_FIREWORK:Int = 10
Const SHOT_BLAST3:Int = 11
Const SHOT_BLAST4:Int = 12
Const SHOT_BLAST5:Int = 13
Const SHOT_BOTTLE:Int = 14

' // Enemy types
Const EN_ZEN:Int = 1
Const EN_MIGHTA:Int = 2
Const EN_BOSS1:Int = 3
Const EN_MONSTA:Int = 4
Const EN_PULPUL:Int = 5
Const EN_BOSS2:Int = 6
Const EN_BANE:Int = 7
Const EN_BOSS3:Int = 8

Const MAX_ITEMS:Int = 32 ' // Max items

' // Active Items
Global ACT_GREEN_SWEET:Int[2] ' // Green candy (fast shots)
Global ACT_BLUE_SWEET:Int[2]  ' // Blue candy (fast bubbles)
Global ACT_RED_SWEET:Int[2]   ' // Red candy (far bubbles)
Global ACT_SHOES:Int[2]       ' // Speed shoes
Global ACT_BROOCH:Int[2]      ' // Brooch (enemies into gems)
Global ACT_PINK_BOOK:Int[2]   ' // Pink book (meteor storm)
Global ACT_DONUT:Int[2]       ' // Donut (enemies into candy)
Global ACT_BLUE_AMULET:Int[2] ' // Blue amulet (magic bubbles)
Global ACT_BLUE_BOOK:Int[2]   ' // Blue book (spash storm)
Global ACT_CLOVER:Int[2]      ' // Clover (enemies into money bags)
Global ACT_GREEN_BOOK:Int[2]  ' // Green book (firework storm)

' // Active Timers
Global pinkBookT:Int, pinkBookC:Int
Global blueBookT:Int, blueBookC:Int
Global greenBookT:Int, greenBookC:Int

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² BUBBLES                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global b:Bub, bubList:TList = CreateList()
Global p:Part, partList:TList = CreateList()
Global o:Obj, objList:TList = CreateList()
Global s:Shot, shotList:TList = CreateList()

Type Bub   
    Field X:Float, Y:Float, ID:Int, F:Int, F2:Int, T:Int, D:Int, YD:Int, P:Int
	Field Cnt:Int, StartT:Int, Action:Int, Homing:Int, HomingT:Int, HomingD:Int, PopSrc:Int
	Field Cap:Int, capF:Int, capT:Int, Kind:Int, Spec:Int, sNum:Int, SD:Int, SDir:Int
	Field Lvl:Int
	
    Function Create:Bub(X:Int, Y:Float, P:Int, D:Int, ID:Int, arg1:Int=0, arg2:Int=0)
		b:Obj = New Bub
		b.X = X; b.Y = Y; b.ID = ID
		b.P = P; b.F = 0; b.T = GetMilliSecs(); b.D = D
		b.Cnt = bubCount
		b.StartT = GetMilliSecs() ' // Start time
		b.F2 = -1
		b.PopSrc = -1 ' // Normal pop
		b.Cap = 0
		If arg1 >= 100 Then ' // Special bubbles
			b.Spec = arg1
			b.sNum = arg2		
			b.F = 3
			b.Kind = 0
			If arg2 = 0 Then ' // Special destination
				If b.Y < spec1Y Then b.SD = 2; b.SDir = 1 Else b.SD = 0; b.SDir = 0
				If spec1D = 1 Then b.SD = -1 ' // Ignore collision
								
			ElseIf arg2 = 1 Then
				If b.Y < spec2Y Then b.SD = 2; b.SDir = 1 Else b.SD = 0; b.SDir = 0
				If spec2D = 1 Then b.SD = -1 ' // Ignore collision
				
			EndIf
			'DebugLog "spec1: " + spec1X + ", " + spec1Y + " spec2: " + spec2X + ", " + spec2Y
			
		Else
			b.Spec = 0
			b.Kind = arg1
			b.SD = -1
		EndIf
		
		bubCount:+1	
		Return b
	End Function

	Method Render()
		Local Del:Int = False
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² BUBBLE                                 
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		If ID = 1 Then 
			SetBlend LIGHTBLEND; SetAlpha .95
			
			If Cap = 0 Then ' // Normal bubble
				Local tmpF:Int = 0
				If F2 <> -1 Then ' // Self destruct
					If F = 3 Then
						tmpF = 15 + F2 
						tmpF:+F
					Else
						If F = 4 Then tmpF = 20 ElseIf F = 5 Then tmpF = 21
					EndIf
					DrawImage imgBubble, Int(X), Int(Y), tmpF
				Else ' // Normal
					If Spec = BUB_WATER Then
						DrawImage imgWater, Int(X), Int(Y), 0
					ElseIf Spec = BUB_ZAP Then
						DrawImage imgZap, Int(X), Int(Y), 0
					ElseIf Spec = BUB_FIRE Then
						DrawImage imgFire, Int(X), Int(Y)
					Else
						If bXMode = False Then
							DrawImage imgBubble, Int(X), Int(Y), F + (p_Class[P] * 6)
						Else
							DrawImage imgBubble, Int(X), Int(Y), F + (Rand(0, 2) * 6)						
						EndIf
					EndIf
					
				EndIf
			Else ' // Captured
				objC:+1 ' // Public enemy counter
				enemyC:+1
				
				Local tmpF:Int = 0
				If F = 3 Then
					If F2 <> -1 Then ' // Self destruct
						tmpF = 3 + F2 
						DrawImage imgCap, Int(X), Int(Y), tmpF
					Else ' // Normal
						DrawImage imgCap, Int(X), Int(Y), p_Class[P]
					EndIf
					
					Local tmpKind:Int = 0
					If Kind = EN_MIGHTA Then tmpKind = 2 ElseIf Kind = EN_MONSTA Then tmpKind = 4 ElseIf Kind = EN_PULPUL Then tmpKind = 6 ElseIf Kind = EN_BANE Then tmpKind = 8
					If tmpKind = 2 And Lvl = 5 Then tmpKind = 10 ' // Gonsu
					SetBlend ALPHABLEND; SetAlpha 1
					DrawImage imgTrap, Int(X), Int(Y), capF + tmpKind
				
				Else
					If PopSrc = -1 Then ' // Self pop
						If F2 <> -1 Then
							If F = 4 Then tmpF = 20 ElseIf F = 5 Then tmpF = 21
							DrawImage imgBubble, Int(X), Int(Y), tmpF				
						Else
							DrawImage imgBubble, Int(X), Int(Y), F + (p_Class[P] * 6)
						EndIf
					EndIf
				EndIf
				
				Local tmpT:Int = 130
				If F2 <> -1 Then tmpT = 65
				If GetMilliSecs() >= capT + tmpT Then
					If capF = 0 Then capF = 1 Else capF = 0
					capT = GetMilliSecs()
				EndIf
				
			EndIf

			SetBlend ALPHABLEND; SetAlpha 1

			'SetAlpha 1
			
			If F < 3 Then ' // Growing
				Local tmpBX:Int = 7, tmpT:Int = 115
				If ACT_BLUE_SWEET[P] = 1 Then tmpBX = 14; tmpT = 60 ' // Blue sweet (fast bubbles)
				If ACT_RED_SWEET[P] = 1 Then tmpT = Int(tmpT * 2) ' // Red sweet (far bubbles)
				
				If GetMilliSecs() >= T + tmpT Then
					F:+1
					T = GetMilliSecs()
				EndIf
				
				If D = 1 Then
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 35, Int(Y) + 20, 1, 5) = False Then 
						If X + tmpBX < 515 Then X:+tmpBX Else X = 515
					EndIf
				ElseIf D = 0 Then 
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X), Int(Y) + 20, 1, 5) = False Then 
						If X - tmpBX > 37 Then X:-tmpBX Else X = 37
					EndIf
				EndIf
				
				If bDebug = True Then
					SetColor 255, 255, 0
					DrawRect Int(X) + 35, Int(Y) + 20, 1, 5
					DrawRect Int(X), Int(Y) + 20, 1, 5
					SetColor 255, 255, 255
					
				EndIf
				
			ElseIf F = 3 ' // Floating
				For Local i:Int = 0 To b2Player
					If p_Dead[i] = False Then ' // Dead check
					
					' // POP
					If ImageRectCollide(imgBubble, Int(X), Int(Y), F, Int(p_X[i]) + 12, Int(p_Y[i]) + 12, 6, 6) = True Then 
						If Spec = 0 Then ' // Normal bubble
							F = 4; T = GetMilliSecs()	
							PopSrc = i ' // Player popped
						ElseIf Spec = BUB_WATER ' // Water bubble
							X = p_X[i]
							Y = AlignY(Int(p_Y[i])) ' // Align
							F = 5
							T = GetMilliSecs() - 115
							specC:-1 ' // Special count
							PopSrc = i ' // Player popped
						ElseIf Spec = BUB_ZAP Or Spec = BUB_FIRE Then ' // Zap/fire bubble
							'X = p_X[i]
							'Y = AlignY(Int(p_Y[i])) ' // Align
							F = 5
							T = GetMilliSecs() - 115
							specC:-1 ' // Special count
							PopSrc = i ' // Player popped													
						EndIf
					Else
						' // JUMP
						If Y > 32 Then
							If ImageRectCollide(imgBubble, Int(X), Int(Y), F, Int(p_X[i]) + 5, Int(p_Y[i]) + 29, 11, 1) = True Then p_bJump[i] = 1
						EndIf
										
						' // RIGHT SIDE
						If ImageRectCollide(imgBubble, Int(X), Int(Y), F, Int(p_X[i]) + 30, Int(p_Y[i]) + 8, 2, 8) = True Then 
							If Int(X + 2) < 515 Then X:+2 Else X = 515
						' // LEFT SIDE
						ElseIf ImageRectCollide(imgBubble, Int(X), Int(Y), F, Int(p_X[i]) + 2, Int(p_Y[i]) + 8, 2, 8) = True Then 
							If Int(X - 2) > 37 Then X:-2 Else X = 37
						EndIf
					EndIf
					
					If bDebug = True Then 
						SetColor 255, 255, 0
						DrawRect Int(p_X[i]) + 30, Int(p_Y[i]) + 8, 2, 8
						DrawRect Int(p_X[i]) + 2, Int(p_Y[i]) + 8, 2, 8
						DrawRect Int(p_X[i]) + 12, Int(p_Y[i]) + 12, 6, 6
						
						DrawRect Int(X) + 19, Int(Y) + 7, 4, 9
						DrawRect Int(X) + 9, Int(Y) + 7, 4, 9
						
						SetColor 255, 255, 255
					EndIf
					
					EndIf ' // End dead block
				Next
				
				' // Self destruct
				If F2 = -1 Then
					Local tmpT:Int = 13000
					If Cap <> 0 Then 
						If lastLevel <= 10 Then ' // Enemy escape speed
							tmpT = 29000
						ElseIf lastLevel <= 20 Then
							tmpT = 24000
						ElseIf lastLevel <= 30 Then
							tmpT = 19000
						ElseIf lastLevel <= 40 Then
							tmpT = 14000
						ElseIf lastLevel <= 50 Then
							tmpT = 9000
						EndIf
					EndIf
					
					If bLooped > 0 Then ' // Hard
						tmpT:-(bLooped * 1000)
						If tmpT < 1000 Then tmpT = 1000
					EndIf
					
					If GetMilliSecs() >= StartT + tmpT Then ' // Turn red
						F2 = 0
						StartT = GetMilliSecs()
					EndIf
					
					If Spec <> 0 Then F2 = -1 ' // Special bubbles don't destruct
					
				ElseIf F2 = 0 Then
					If Action = 0 Then
						If GetMilliSecs() >= StartT + 5000 Then ' // Blink
							F2 = 1
							StartT = GetMilliSecs()
							Action = 1 ' // Self destruct
						EndIf
					Else
						If GetMilliSecs() >= StartT + 50 Then ' // Turn blue
							F2 = 1
							If Action < 80 Then Action:+1 Else F = 4; T = GetMilliSecs() ' // Pop
							StartT = GetMilliSecs()
						EndIf
					
					EndIf
					
				ElseIf F2 = 1 Then
					If GetMilliSecs() >= StartT + 50 Then ' // Turn red
						F2 = 0
						Action:+1
						StartT = GetMilliSecs()
					EndIf
					
				EndIf
				
				If F = 4 Then ' // Pop collision
					If PopSrc <> -1 Then 
						If Cap <> 0 Then 
							PoppedID = Cnt 
							p_Chain[PopSrc] = 0
						Else 
							PoppedID = -1
							p_Chain[PopSrc] = -1
						EndIf
						BubblePop(Int(X), Int(Y), Cnt, PopSrc) ' // Popped from player
						If p_Chain[PopSrc] = -1 Then p_Chain[PopSrc] = 0
						
						If p_Chain[PopSrc] > 0 Then ' // Create chain gem
							'p_Chain[PopSrc] = 6
							objList.AddLast obj.Create(Int(X), Int(Y), OBJ_GEM, p_Chain[PopSrc] - 1)
							
							p_Points[PopSrc]:+((p_Chain[PopSrc] + 1) * 1000) ' // Points
							
							For Local i:Int = 0 To 9 ' // Stars
								'partList.AddLast part.Create(Int(X) + 18, Int(Y) + 16, PART_POP, 100, i)
							Next

							' // Points
							partList.AddLast part.Create(Int(X) + 18, Int(Y) + 16, PART_SCORE, p_Chain[PopSrc], PopSrc)						
							PlaySFX sfxChain
						EndIf
						
					EndIf
				Else
					If Homing = 0 Then ' // Home in X/Y		
						If Spec = 0 Then ' // Normal bubbles
							If Int(Y) < 48 Then ' // Offscreen wrap
								If Int(Y) > -32 Then Y:-.65 Else Y = 448
								
							ElseIf Int(Y) > bubY + 1 Or Int(Y) < bubY - 32 Then 
								Y:-.65																	
									
							Else						
								If Homing = 0 Then Homing = 1; HomingT = GetMilliSecs(); HomingD = Rand(0, 1); YD = Rand(0, 1)
							EndIf
						Else ' // Special bubbles
							Local tmpX:Int = bubX, tmpY:Int = bubY
							If sNum = 0 Then 
								tmpX = spec1X; tmpY = spec1Y
							ElseIf sNum = 1 Then							
								tmpX = spec2X; tmpY = spec2Y
							EndIf
							
							' // SPECIAL LEVEL COLLISION
							If SDir = 1 Then ' // Going down
								If SD = 2 Then ' // Bottom
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 9, Int(Y) + 31, 8, 1) = True Then
										If X < tmpX Then SD = 1 Else SD = 3 ' // Left / right
										'DebugLog "X: " + X + ", destX: " + tmpX
									EndIf
								ElseIf SD = 1 Then ' // Right							
									' // Fall through
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 9, Int(Y) + 31, 8, 1) = False Then
										SD = 2
									ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 26, Int(Y) + 20, 1, 5) = True Then
										SD = 3
									EndIf
								ElseIf SD = 3 Then ' // Left
									' // Fall through
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 9, Int(Y) + 31, 8, 1) = False Then
										SD = 2
									ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 10, Int(Y) + 20, 1, 5) = True Then
										SD = 1
									EndIf
								EndIf
								
								' // Stuck check
								If SD <> -1 Then
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 18, Int(Y) + 20, 1, 1) = True Then SD = 2
								EndIf
								
							ElseIf SDir = 0 Then ' // Going up
								If SD = 0 Then ' // Top
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 9, Int(Y) + 1, 8, 1) = True Then
										If X < tmpX Then SD = 1 Else SD = 3 ' // Left / right
										'DebugLog "X: " + X + ", destX: " + tmpX
									EndIf
								ElseIf SD = 1 Then ' // Right							
									' // Fall through
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 9, Int(Y) + 1, 8, 1) = False Then
										SD = 0
									ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 26, Int(Y) + 2, 1, 5) = True Then
										SD = 3
									EndIf
								ElseIf SD = 3 Then ' // Left
									' // Fall through
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 9, Int(Y) + 1, 8, 1) = False Then
										SD = 0
									ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 10, Int(Y) + 2, 1, 5) = True Then
										SD = 1
									EndIf
								EndIf	

								' // Stuck check
								If SD <> -1 Then
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 18, Int(Y) + 12, 1, 1) = True Then SD = 0
								EndIf
								
							EndIf													
							
							If bDebug = True Then
								SetColor 255, 255, 0
								DrawRect Int(X) + 9, Int(Y) + 1, 8, 1
								DrawRect Int(X) + 9, Int(Y) + 31, 8, 1	

								'DrawRect Int(X), Int(Y) + 8, 1, 8
								'DrawRect Int(X) + 35, Int(Y) + 8, 1, 8
								
								DrawRect Int(X), Int(Y) + 20, 1, 5
								DrawRect Int(X) + 35, Int(Y) + 20, 1, 5
								
								DrawRect Int(X) + 10, Int(Y) + 2, 1, 5
								DrawRect Int(X) + 26, Int(Y) + 2, 1, 5

								DrawRect Int(X) + 18, Int(Y) + 12, 1, 1
								DrawRect Int(X) + 18, Int(Y) + 20, 1, 1
								
								SetColor 255, 255, 255
							EndIf
							
							If SD = 1 Then
								X:+1
							ElseIf SD = 3 Then
								X:-1
							EndIf
							
							If Int(Y) < tmpY - 1 Then
								If SD = 2 Or SD = -1 Then Y:+.65									
							ElseIf Int(Y) > tmpY + 1 Then 
								If SD = 0 Or SD = -1 Then Y:-.65																	
									
							Else						
								If Homing = 0 Then Homing = 1; HomingT = GetMilliSecs(); HomingD = Rand(0, 1); YD = Rand(0, 1); SD = -1
							EndIf						
							
							' // Screen wrap
							'If (tmpY = -32 And Int(Y) <= -31) Then
							'	Y = 448
							'ElseIf (tmpY = 448 And Int(Y) >= 447) Then
							'	Y = -32
							'EndIf
														
							' // Met offscreen dest
							If (tmpY = -32 And Int(Y) <= -31) Or (tmpY = 448 And Int(Y) >= 447) Then
								F = 5
								T = GetMilliSecs() - 115
								specC:-1 ' // Special count
								PopSrc = -1 ' // Player popped
							EndIf
							
							
						EndIf
						
					EndIf
					
					If Homing = 1 And F <> 5 Then ' // Random movement
						
						Local tmpX:Int = bubX, tmpY:Int = bubY
						If Spec <> 0 Then ' // Special bubbles
							If sNum = 0 Then 
								tmpX = spec1X; tmpY = spec1Y
							ElseIf sNum = 1 Then							
								tmpX = spec2X; tmpY = spec2Y
							EndIf
						
							If Int(X) < tmpX - 1 Then
								X:+1
							ElseIf Int(X) > tmpX + 1 Then
								X:-1
							EndIf
													
						Else ' // Special bubbles
							If Int(X) < tmpX - 1 Then
								X:+1
							ElseIf Int(X) > tmpX + 1 Then
								X:-1
							EndIf
						
						EndIf
																		
						If BubbleTouch(Int(X), Int(Y), Cnt) = True And X >= tmpX - 76 And X <= tmpX + 76 Then ' // Only move when touching							
							If Int(Y) < tmpY - 32 Then
								If Rand(1, 3) = 2 Then YD = 0 Else YD = 1
							ElseIf Int(Y) >= tmpY + 32 Then
								If Rand(1, 3) = 2 Then YD = 1 Else YD = 0
							EndIf
						
							If YD = 0 Then Y:-.5 ElseIf YD = 1 Then Y:+.5
						Else ' // Center
							If Int(Y) < tmpY -1 Then Y:+.5 ElseIf Int(Y) > tmpY + 1 Then Y:-.5
						EndIf

						If GetMilliSecs() >= HomingT + 100 Then ' // Vertical shake
							If HomingD = 0 Then
								Y:-2; HomingD = 1
							ElseIf HomingD = 1 Then
								Y:+2; HomingD = 0
							EndIf

							Y = Int(Y)
							HomingT = GetMilliSecs()
						EndIf
						
					EndIf
					
					'If Int(Y) < -32 Then Del = True ' // Off screen
					
					If Del = False Then
						Local tmpCol:Int
						' // Bubble to bubble collision
						If SD = -1 Then
							tmpCol = BubbleCol(Int(X), Int(Y), Cnt)
						Else
							tmpCol = -1
						EndIf
						If tmpCol <> -1 Then
							If tmpCol = 0 Then 
								If Int(X + 2) < 515 Then X:+2 Else X = 515
							ElseIf tmpCol = 1 Then 
								If Int(X - 2) > 37 Then X:-2 Else X = 37
							EndIf
						EndIf
					EndIf
				EndIf
				
			Else ' // Popping	
				If GetMilliSecs() >= T + 115 Then
					If F < 5 Then 
						If Cap <> 0 And F = 4 Then
							If PopSrc = -1 Then ' // Enemy broke free
								If Kind = EN_MONSTA Or Kind = EN_PULPUL Then ' // Flyers
									objList.AddLast obj.Create(Int(X), AlignY(Int(Y)), Cap, Int(Y), Rand(0, 3), 0, 0, Kind, Lvl)
								Else
									objList.AddLast obj.Create(Int(X), Int(Y), Cap, Int(Y), 0, 0, 0, Kind, Lvl)
								EndIf
							Else ' // Kill enemy
								If GetMilliSecs() >= spinT + 250 Then ' // Don't repeat
									PlaySFX(sfxSpin)
									spinT = GetMilliSecs()
								EndIf
															
								Local tmpXP:Int = GetXP(Cap, Kind, Lvl)
								p_XP[PopSrc]:+tmpXP
								If b2Player = True Then ' // Half experience
									If PopSrc = PLAYER_1 And p_Dead[PLAYER_2] = False Then
										p_XP[PLAYER_2]:+Int(tmpXP / 2)
									ElseIf PopSrc = PLAYER_2 And p_Dead[PLAYER_1] = False Then
										p_XP[PLAYER_1]:+Int(tmpXP / 2)									
									EndIf
								EndIf
								
								Local tmpPoints:Int = GetPoints(Cap, Kind, Lvl)
								
								p_Points[PopSrc]:+tmpPoints
								
								Local tmpD:Int = Rand(0, 1)
								'If Int(X) + 18 >= Int(p_X[PopSrc] + 18) Then tmpD = 1 Else tmpD = 0 ' // Dir
								objList.AddLast obj.Create(Int(X), Int(Y) - 16, OBJ_DEAD, Cap, tmpD, 0, Rand(0, 3), Kind, Lvl)
							EndIf
						EndIf

						F:+1
						
						Local tmpClass:Int = p_Class[P]
						If F2 <> -1 Then tmpClass = 3 ' // Red
						For Local i:Int = 1 To 5
							partList.AddLast part.Create(Int(X) + 18, Int(Y) + 16, PART_POP, tmpClass)
						Next
												
						T = GetMilliSecs()
					Else
						If nextLevel < 2 Then ' // No effect during next level
							' // Special bubble sounds
							If Spec = BUB_WATER And PopSrc <> -1 Then ' // Player popped
								' // Create waterfall
								partList.AddLast part.Create(Int(X), Int(Y), PART_WATER, PopSrc)

								If GetMilliSecs() >= sfxWaterT + 150 Then
									PlaySFX sfxWater
									sfxWaterT = GetMilliSecs()
								EndIf
							
							ElseIf Spec = BUB_ZAP And PopSrc <> -1 Then ' // Player popped
								' // Delay
								If ImagesCollide(imgBubble, Int(X), Int(Y), 3, GetClassImg(p_Class[PopSrc]), Int(p_X[PopSrc]), Int(p_Y[PopSrc]), p_F[PopSrc]) Then 
									p_Zap[PopSrc] = True
									p_ZapT[PopSrc] = GetMilliSecs()
								EndIf
								
								' // Create zap
								partList.AddLast part.Create(Int(X), Int(Y), PART_ZAP, PopSrc)

								If GetMilliSecs() >= sfxWaterT + 150 Then
									PlaySFX sfxZap
									sfxWaterT = GetMilliSecs()
								EndIf
							
							ElseIf Spec = BUB_FIRE And PopSrc <> -1 Then ' // Player popped
								' // Align X
								X = Int((X + 19) / 18.967)
								X = Int(X * 8) * sclX
								'Int(X) + 8
								
								' // Create flame								
								partList.AddLast part.Create(Int(X), Int(Y), PART_FLAME, PopSrc, 1)
															
							EndIf
						EndIf
						
						Del = True
					EndIf
				EndIf
				
			EndIf
			
		EndIf
		
		If Del = True Then bubList.Remove b
	End Method
	
End Type

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PARTICLES                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Part
    Field X:Float, Y:Float, Alp:Float, ID:Int, T:Int
	Field A:Int, R:Float, S:Float, D:Float, H:Int, C:Int, Player:Int
	Field Rot:Int, ID2:Int, SX:Float, RS:Float, F:Int, C2:Int, V:Int
	Field Fall:Int, oldY:Int, oldX:Int
	
    Function Create:Part(X:Int, Y:Int, ID:Int, arg1:Int=0, arg2:Int=0)
		p:Part = New Part
		p.X = X; p.Y = Y; p.Alp = 1; p.ID = ID
		
		If ID = PART_POP
			p.A = Rand(0, 359)								
			p.R = 0
			
			If arg1 = 100 Then ' // Stars
				'p.Rot = arg2 * 36 'Rand(0, 359)
				p.A = arg2 * 36
				p.S = Rnd(4, 5)
				p.D = Rnd(.1, .2)
				p.F = Rand(0, 3)	
				p.ID2 = 1 ' // Star
				p.SX = Rnd(1.5, 2.5)
				p.T = GetMilliSecs()
			
			ElseIf arg1 = 101 ' // Bubbles
				'p.A = arg2 * 36
				p.S = Rnd(5, 7)
				p.D = Rnd(.1, .2)
				p.F = 3	
				p.ID2 = 2 ' // Bubbles
				p.SX = Rnd(1.5, 2.5)
				p.T = GetMilliSecs()
			
			Else
				p.S = Rnd(1.5, 2.5)
				p.D = Rnd(.075, .1)
				p.C = arg1
				p.H = Rand(0, 1)
				p.ID2 = 0 ' // Pop
				
			EndIf
			
		ElseIf ID = PART_POINTS
			p.A = arg1
			p.Player = arg2
		
		ElseIf ID = PART_POWER
			p.A = Rand(0, 359)								
			p.R = Rand(32, 48)
			p.H = arg1
			p.S = Rnd(1.5, 2.5)
			p.D = Rnd(.04, .075)
			p.C = Rand(0, 1)
			
		ElseIf ID = PART_LEVELUP
			p.F = arg1
			p.S = 16
			p.T = GetMilliSecs()
			p.Player = arg2
		
		ElseIf ID = PART_HURRY
			p.T = GetMilliSecs()
		
		ElseIf ID = PART_SCORE
			p.F = arg1
			p.Player = arg2
		
		ElseIf ID = PART_BOSSBUB
			If arg1 = EN_BOSS1 Then p.ID2 = 0 ElseIf arg1 = EN_BOSS2 Then p.ID2 = 1 ElseIf arg1 = EN_BOSS3 Then p.ID2 = 2
		
		ElseIf ID = PART_WATER
			p.Player = arg1
			If p_D[p.Player] = 0 Then p.D = 1 ElseIf p_D[p.Player] = 1 Then p.D = 0
			p.Fall = True
		
		ElseIf ID = PART_GHOST
			If arg1 = 2 Then p.D = 2; p.Alp = .5
			p.T = GetMilliSecs()
		
		ElseIf ID = PART_ZAP
			p.Player = arg1
			If p_D[p.Player] = 0 Then p.D = 1 ElseIf p_D[p.Player] = 1 Then p.D = 0
		
		ElseIf ID = PART_FLAME
			If arg1 <> 2 Then
				p.Player = arg1
				If p_D[p.Player] = 0 Then p.D = 1 ElseIf p_D[p.Player] = 1 Then p.D = 0
			Else
				p.Player = 2 ' // Boss
				p.D = Rand(0, 1)
			EndIf
			p.F = 0; p.T = GetMilliSecs()
			If arg2 = 1 Then p.Fall = True Else p.V = GetMilliSecs() ' // Parent flame
			p.Alp = .8
			
		EndIf
		
		Return p
		
	End Function
	
	Method Render()
		Local Del:Int = False
		Local createP:Int = False, createX:Int, createY:Int, createD:Int, createI:Int
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² BUBBLE POP                                          
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
		If ID = PART_POP Then			
			
			If ID2 = 0 Then ' // Pop
				SetBlend LIGHTBLEND; SetAlpha Alp
				SetScale 1, 1

				If H = 0 Then
					If C = 4 Then ' // Fireball
						SetColor 248, 152, 56
					ElseIf C = 8 Then ' // Splash
						SetColor 164, 214, 244
					ElseIf C = 9 Then ' // Shock
						SetColor 214, 164, 214
					Else
						SetColor 252, 252, 252
					EndIf
				Else
					If C = CLASS_BUBBLE Then
						SetColor 92, 230, 52
					ElseIf C = CLASS_EMBER Then
						SetColor 251, 107, 29
					ElseIf C = CLASS_SHOCK Then
						SetColor 183, 51, 204
					ElseIf C = 3 Then ' // Red
						SetColor 228, 0, 88
					ElseIf C = 4 Then ' // Fireball
						SetColor 248, 248, 248
					ElseIf C = 5 Then ' // Shockwave
						SetColor 238, 204, 0
					ElseIf C = 8 Then
						SetColor 4, 78, 148
					ElseIf C = 9 Then
						SetColor 78, 4, 148				
					EndIf
				EndIf
				
				If C = 6 Then ' // Mighta blast
					Local tmpR:Int = Rand(1, 3)
					If tmpR = 1 Then
						SetColor 252, 252, 252
					ElseIf tmpR = 2 Then
						SetColor 252, 130, 116
					ElseIf tmpR = 3 Then
						SetColor 180, 30, 124
					EndIf

				ElseIf C = 7 Then ' // Mighta blast 2
					Local tmpR:Int = Rand(1, 3)
					If tmpR = 1 Then
						SetColor 252, 252, 252
					ElseIf tmpR = 2 Then
						SetColor 226, 155, 250
					ElseIf tmpR = 3 Then
						SetColor 163, 93, 217
					EndIf
				ElseIf C = 10 Then ' // Mighta blast 3
					Local tmpR:Int = Rand(1, 3)
					If tmpR = 1 Then
						SetColor 252, 252, 252
					ElseIf tmpR = 2 Then
						SetColor 143, 211, 255
					ElseIf tmpR = 3 Then
						SetColor 77, 101, 180
					EndIf
				ElseIf C = 11 Then ' // Mighta blast 4
					Local tmpR:Int = Rand(1, 3)
					If tmpR = 1 Then
						SetColor 252, 252, 252
					ElseIf tmpR = 2 Then
						SetColor 145, 219, 105
					ElseIf tmpR = 3 Then
						SetColor 35, 144, 99
					EndIf
				ElseIf C = 12 Then ' // Gonsu blast					
					Local tmpR:Int = Rand(1, 4)
					If tmpR = 1 Then
						SetColor 180, 30, 124
					ElseIf tmpR = 2 Then
						SetColor 252, 130, 116
					ElseIf tmpR = 3 Then
						SetColor 116, 130, 252
					ElseIf tmpR = 4 Then
						SetColor 76, 206, 220
					EndIf
				EndIf					
				
				Local tmpS:Int			
				If S >= 1.5 Then ' // Sizing
					tmpS = 4; Alp = 1
				ElseIf S >= .5 Then
					tmpS = 3; Alp = .66
				Else
					tmpS = 2; Alp = .33
				EndIf			

				tmpS:+1
				DrawRect Float((R * Cos(A) + X) - (tmpS / 2)), Float((R * Sin(A) + Y) - (tmpS / 2)), tmpS, tmpS
			
			Else ' // Sprite particles
				SetBlend ALPHABLEND; SetAlpha Alp		
				SetScale SX, SX
				If ID2 = 1 Then ' // Stars
					DrawImage imgStars, Float((R * Cos(A) + X)), Float((R * Sin(A) + Y)), F
				ElseIf ID2 = 2 Then ' // Bubbles
					DrawImage imgBubble, Float((R * Cos(A) + X)), Float((R * Sin(A) + Y)), 3
				EndIf
				
				If GetMilliSecs() >= T + 60 Then
					If F < 3 Then F:+1 Else F = 0
					T = GetMilliSecs()
				EndIf
				
			EndIf
			
			SetRotation 0
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255
			
			R = R + S
			If Alp > 0 Then Alp = Alp - .03 Else Del = True
			If S > 0 Then S = S - D Else Del = True
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² POINTS                                 
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = PART_POINTS Then
			SetBlend LIGHTBLEND; SetAlpha Alp		
			
			SetColor 252, 130, 116
			DrawPoints String(A), Int(X), Int(Y), Player
			SetBlend ALPHABLEND; SetAlpha 1
			
			Y:-.75
			If Alp > 0 Then Alp:-.02 Else Del = True

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² FADE                                     
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
		ElseIf ID = PART_FADE
			SetBlend LIGHTBLEND; SetAlpha Alp; SetScale 1, 1
			If C2 = 0 Then SetColor 248, 152, 56 ElseIf C2 = 1 Then SetColor 248, 248, 248 '252, 130, 116
			If C2 = 2 Then SetColor 164, 214, 244 ElseIf C2 = 3 Then SetColor 4, 78, 148 '252, 130, 116
			If C2 = 4 Then SetColor 214, 164, 244 ElseIf C2 = 5 Then SetColor 78, 4, 148 '252, 130, 116
			If C2 = 6 Then SetColor 100, 176, 255 ElseIf C2 = 7 Then SetColor 69, 224, 130
			If C2 = 8 Then SetColor 255, 176, 100 ElseIf C2 = 9 Then SetColor 130, 224, 69
			If C2 = 10 Then SetColor 176, 100, 255 ElseIf C2 = 11 Then SetColor 224, 69, 130
			If C2 = 12 Then SetColor 76, 206, 220 ElseIf C2 = 13 Then SetColor 196, 118, 252
			If C2 = 14 Then SetColor 180, 30, 124 ElseIf C2 = 15 Then SetColor 252, 130, 116
			
			'If C2 = 2 Then SetColor 252, 252, 252 ElseIf C2 = 3 Then SetColor 238, 204, 0
			'If C2 = 4 Then SetColor 252, 252, 252 ElseIf C2 = 5 Then SetColor 76, 220, 72
			
			'If C2 <= 5 Then SetRotation Rot; SetHandle 1.5, 1.5 ' // Spells rotate			
			DrawRect Int(X), Int(Y), 3, 3
			Rot:+5
			SetRotation 0; SetHandle 0, 0
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

			If Alp > 0 Then Alp:-D Else Del = True
						
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² GHOST                          
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
		ElseIf ID = PART_GHOST
			SetBlend ALPHABLEND; SetAlpha Alp; SetScale 1, 1
			If D = 0 Then ' // Wave
				'DrawImage imgWave, X, Y, F
			ElseIf D = 1 Then ' // Ghost
				SetBlend ALPHABLEND; SetAlpha Alp; SetScale sclX, sclY
				DrawImage imgGhost, X, Y, F
			ElseIf D = 2 Then ' // Water
				SetBlend LIGHTBLEND; SetAlpha Alp; SetScale sclX, sclY
				DrawImage imgWater, X, Y, 1
			ElseIf D = 3 Then ' // Cross
				SetBlend LIGHTBLEND; SetAlpha Alp; SetScale sclX, sclY
				DrawImage imgCross, X, Y, F
			EndIf
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

			If D = 1 Or D = 3 Then
				If Alp > 0 Then Alp:-.01 Else Del = True
			ElseIf D = 2 Then
				If Alp > 0 Then Alp:-.04 Else Del = True
			EndIf

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² POWER UP                                          
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
		ElseIf ID = PART_POWER Then	
			SetBlend LIGHTBLEND; SetAlpha Alp
			SetScale 1, 1							
			
			Local tmpS:Int			
			If S >= 1.5 Then ' // Sizing
				tmpS = 4; Alp = 1
			ElseIf S >= .5 Then
				tmpS = 3; Alp = .66
			Else
				tmpS = 2; Alp = .33
			EndIf			
				
			If H = 0 Then ' // Health power up
				If C = 0 Then SetColor 252, 252, 252 Else SetColor 180, 30, 124
			ElseIf H = 1 Then ' // Magic power up
				If C = 0 Then SetColor 252, 252, 252 Else SetColor 76, 206, 220
			ElseIf H = 2 Then ' // Green sweet
				If C = 0 Then SetColor 252, 252, 252 Else SetColor 92, 230, 52
			ElseIf H = 3 Then ' // Brooch
				If C = 0 Then SetColor 252, 252, 252 Else SetColor 252, 130, 116
			ElseIf H = 4 Then ' // Pink book
				If C = 0 Then SetColor 252, 252, 252 Else SetColor 252, 110, 204					
			EndIf
			
			tmpS:+1
			DrawRect Float((R * Cos(A) + X) - (tmpS / 2)), Float((R * Sin(A) + Y) - (tmpS / 2)), tmpS, tmpS

			SetRotation 0
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

			A:+2 ' // Swirl

			If Alp > 0 Then Alp = Alp - .03 Else Alp = 0
			If S > 0 Then S = S - D Else Del = True
			If R > 0 Then R = R - S Else Del = True

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² EXPLODE                                    
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //			
		ElseIf ID =  PART_EXPLODE
			SetBlend ALPHABLEND; SetAlpha Alp; SetScale sclX, sclY; SetColor 255, 255, 255

			Local tmpF:Int = 0
			If GetMilliSecs() >= T + V Then
				If Alp < .75 Then tmpF = 0 Else tmpF = 1
				'If curLevel[curPlayer-1] = 2 Then tmpF:+2 ElseIf curLevel[curPlayer-1] = 3 Then tmpF:+4
				DrawImage imgExplode, Int(X), Int(Y), tmpF + 2
				If Alp > 0 Then Alp:-.02
			EndIf
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255
			
			Local imgEn:TImage
			' // Enemy collision
			If Alp >= .5 Then

				' // MAGIC TO ENEMY COLLISION
				HandleMagicCol(SHOT_BOMB, Int(X), Int(Y), tmpF, Int(D), Player, False) ' // Do enemy collision

			EndIf
						
			If Alp <= 0 Then Del = True
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² LEVEL UP                                   
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //				
		ElseIf ID = PART_LEVELUP Then
			SetBlend LIGHTBLEND; SetAlpha .9; SetScale S, S
			SetImageHandle GetClassImg(p_Class[Player]), 8, 8
			DrawImage GetClassImg(p_Class[Player]), Int(X) + 16, Int(Y) + 16, F
			SetImageHandle GetClassImg(p_Class[Player]), 0, 0
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
			If S >= sclY Then S:-.5 Else Del = True

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² HURRY                          
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
		ElseIf ID = PART_HURRY
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			DrawImage imgHurry, X, Y
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

			If S = 0 Then ' // Rising
				If Y - 4 > 206 Then
					Y:-4
				Else
					StopChannel musChan
					'musChan.SetVolume(0)
					'musChan = 
					'musAlarm.SetVolume(Float(cfgMusic) / 5)
					musChan = AllocChannel()
					musChan.SetVolume(Float(cfgMusic) / 15)					
					musChan = PlayMusic(musAlarm, musChan)
					'ResumeChannel musChan
					bFastMus = True

					Y = 206
					T = GetMilliSecs()
					S = 1
				EndIf
			ElseIf S = 1 Then ' // Pause in middle
				If GetMilliSecs() >= T + 1000 Then S = 2
			ElseIf S = 2 Then ' // Going offscreen
				If Y - 4 > -18 Then Y:-4 Else Del = True
			EndIf

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² SCORE                          
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
		ElseIf ID = PART_SCORE
			SetBlend LIGHTBLEND; SetAlpha .95; SetScale sclX, sclY
			Local tmpF:Int = 0
			If Player = PLAYER_2 Then tmpF = 7
			If F > 6 Then F = 6
			DrawImage imgScore, X, Y, F + tmpF
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

			If Y - 4 > -32 Then Y:-4 Else Del = True

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² BOSS BUBBLE                          
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
		ElseIf ID = PART_BOSSBUB
			SetBlend ALPHABLEND; SetAlpha .9; SetScale sclX, sclY; SetColor 255, 255, 255
			
			Local tmpImg:TImage
			
			If ID2 <> 2 Then 
				DrawImage imgBossBub, X, Y
				DrawImage imgBossCap, X, Y, F + (ID2 * 2)
				tmpImg = imgBossBub
			Else
				DrawImage imgBossBub2, X, Y
				tmpImg = imgBossBub2
			EndIf
			
			SetAlpha 1
			
			objC:+1 ' // Counts towards enemies
			
			If GetMilliSecs() >= T + 130 Then
				If F = 0 Then F = 1 Else F = 0
				T = GetMilliSecs()
			EndIf

			Local tmpX:Int = 260, tmpY:Int = 209
			If ID2 = 2 Then tmpX = Int((13 * 8) * sclX); tmpY =  Int((10 * 8) * sclY) + 2

			If D = 0 Then ' // Seeking middle
				If X - 2 > tmpX Then 
					X:-2
				ElseIf X + 2 < tmpX - 4 Then
					X:+2
				Else
					X = tmpX - 2
				EndIf
				
				If Y - 1 > tmpY Then
					Y:-1
				ElseIf Y + 1 < tmpY - 2 Then
					Y:+1
				Else
					Y = tmpY - 1
				EndIf
				
				If X >= tmpX - 4 And X <= tmpX And Y >= tmpY - 3 And Y <= tmpY + 1 Then 
					X = tmpX - 2; Y = tmpY - 1
					D = 1
				EndIf
				
			ElseIf D = 1 Then ' // Waiting

				For Local i:Int = 0 To b2Player
					If p_Hurt[i] = False And p_Dead[i] = False Then
						If ImagesCollide(GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i], tmpImg, Int(X), Int(Y), 0) = True Then
							
							PlaySFX sfxSpin
							
							Local tmpK:Int

							' // SHARED XP + POINTS
							For Local i2:Int = 0 To b2Player
								If p_Dead[i2] = False Then
									If ID2 = 0 ' // MIGHTA BOSS
										p_XP[i2]:+300
										p_Points[i2]:+10000
										tmpK = EN_BOSS1
									ElseIf ID2 = 1 Then ' // MONSTA BOSS
										p_XP[i2]:+600
										p_Points[i2]:+25000
										tmpK = EN_BOSS2
									ElseIf ID2 = 2 Then ' // DRUNK BOSS
										'p_XP[i2]:+1000
										p_Points[i2]:+50000
										tmpK = EN_BOSS3								
									EndIf
								EndIf
							Next
							
							Local tmpR:Int
							If curLevel = 201 Then tmpR = 9 ElseIf curLevel = 202 Then tmpR = 14 ElseIf curLevel = 203 Then tmpR = 19
							
							Local tmpX:Int = 19, tmpY:Int = 16
							If tmpK = EN_BOSS3 Then tmpX = 37; tmpY = 32
							For Local i3:Int = 0 To tmpR
								objList.AddLast obj.Create(Int(X) + tmpX, Int(Y) + tmpY, OBJ_DEAD, OBJ_ZEN, Rand(0, 1), 0, Rand(0, 3), tmpK)
							Next
							
							' // Big treasure
							If tmpK = EN_BOSS3 Then
								objList.AddLast obj.Create(Int(X) + 21, Int(Y) + 16, OBJ_GEM, 100)
							Else
								objList.AddLast obj.Create(Int(X), Int(Y), OBJ_GEM, 100)
							EndIf
							
							createP = 1; createX = Int(X) + tmpX; createY = Int(Y) + tmpY
							Del = True
							
							Exit	
						EndIf
					EndIf
				Next
						
			EndIf
	
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² WATER FLOW                         
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
		ElseIf ID = PART_WATER
			SetBlend LIGHTBLEND; SetAlpha .4; SetScale sclX, sclY; SetColor 255, 255, 255
			
			DrawImage imgWater, X, Y, 1
			
			SetBlend ALPHABLEND; SetAlpha 1
			
			' // Player collision
			If nextLevel < 2 Then ' // Don't carry during transition
				For Local i:Int = 0 To b2Player
					If p_Dead[i] = False Then
						If p_J[i] = False Or (p_J[i] = True And p_YI[i] <= 0) Then
							If ImagesCollide(GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i], imgWater, Int(X), Int(Y), 1) = True Then
								p_X[i] = X; p_Y[i] = Y						
							EndIf
						EndIf
					EndIf
				Next
			EndIf
			
			' // Water to enemy collision
			HandleMagicCol(BUB_WATER, Int(X), Int(Y), F, 0, Player, False)

			' // Floor
			If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 18, (Int(Y) + 20), 1, 8) And Y > 48 Then
				' // Stuck check
				If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 18, Int(Y) + 16, 1, 1) = True Then				
					Y:+8
					Fall = True
				Else
					Y = AlignY(Int(Y))
					Fall = False			
				EndIf
			Else
				Y:+8
				Fall = True
			EndIf
			
			If Fall = False Then ' // Left/right col
				If D = 0 Then ' // Left side
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 5, Int(Y) + 20, 4, 2) Then
						D = 1
					Else
						X:-9
					EndIf
				ElseIf D = 1 Then ' // Right side
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 23, Int(Y) + 20, 4, 2) Then 
						D = 0
					Else
						X:+9
					EndIf
				EndIf
			EndIf
			
			If GetMilliSecs() >= T + 50 Then
				createP = 2; createX = Int(X); createY = Int(Y)
				T = GetMilliSecs()
			EndIf
			
			If bDebug = True Then
				SetColor 255, 255, 0
				DrawRect Int(X) + 18, Int(Y) + 20, 1, 8
				DrawRect Int(X) + 5, Int(Y) + 20, 4, 2
				DrawRect Int(X) + 23, Int(Y) + 20, 4, 2
				DrawRect Int(X) + 18, Int(Y) + 16, 1, 1
				SetColor 255, 255, 255
			EndIf
			
			If Y >= 448 Then Del = True

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² ZAP                        
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
		ElseIf ID = PART_ZAP
			SetBlend LIGHTBLEND; SetAlpha .95; SetScale sclX, sclY; SetColor 255, 255, 255
			
			DrawImage imgZap, X, Y, 1
			
			SetBlend ALPHABLEND; SetAlpha 1
						
			If Int(X) >= 37 And Int(X) <= 515 Then
				If D = 1 Then
					X:+5
				ElseIf D = 0 Then
					X:-5
				EndIf

				' // Water to enemy collision
				HandleMagicCol(BUB_ZAP, Int(X), Int(Y), F, 0, Player, False)
			Else
				Del = True
			EndIf

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² TITLE BUBBLE                      
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
		ElseIf ID = PART_TBUB
			SetBlend LIGHTBLEND; SetAlpha .95; SetScale sclX, sclY; SetColor 255, 255, 255			
			DrawImage imgTBub, Int(X), Int(Y), F
			SetBlend ALPHABLEND; SetAlpha 1
			
			If GetMilliSecs() >= T + 200 Then
				If F < 3 Then F:+1 Else F = 0
				T = GetMilliSecs()
			EndIf
						
			If bTitleDrop = False And D <> 2 Then ' // Move
				If D = 0 Then X:-.5 ElseIf D = 1 Then X:+.5
			EndIf
				
			If Y > -19 Then Y:-.5 Else Del = True; createP = 4
				
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² FLAME                        
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //						
		ElseIf ID = PART_FLAME
			SetBlend ALPHABLEND; SetAlpha Alp; SetScale sclX, sclY; SetColor 255, 255, 255
			If Player = 2 Then
				DrawImage imgFlame2, Int(X), Int(Y), F									
			Else
				DrawImage imgFlame, Int(X), Int(Y), F						
			EndIf
					
			SetBlend ALPHABLEND; SetAlpha 1
						
			If Fall = True Then ' // Parent flame
				
				' // Make sure it's not in the middle of a block
				Local tmpCol:Int = ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 5, Int(Y) + 12, 4, 4)

				If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 5, Int(Y) + 23, 4, 1) And Y > 34 And tmpCol = False Then 
					Fall = False
										
					Y = AlignY(Int(Y)) + 8

					createP = 3; createX = Int(X); createY = Int(Y); createD = D; createI = Player
					V = GetMilliSecs()
				Else
					Y:+2
					
					If Int(Y) > 448 Then Y = -32 ' // Screen wrap
				EndIf
					
				If bDebug = True Then
					SetColor 255, 255, 0
					DrawRect Int(X) + 5, Int(Y) + 23, 4, 1
					DrawRect Int(X) + 5, Int(Y) + 12, 4, 4
												
					SetColor 255, 255, 255
				EndIf				
			
			Else
				' // Player collision
				If C2 = False Then
					For Local i:Int = 0 To b2Player
						If p_Dead[i] = False Then
							If ImagesCollide(GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i], imgFlame, Int(X), Int(Y), F) = True Then
								p_Flame[i] = True								
							EndIf
						EndIf
					Next
				EndIf
				
				If GetMilliSecs() >= T + 30 Then
					If F < 3 Then F:+1 Else F = 0
					T = GetMilliSecs()
				EndIf
				
				If bDebug = True Then
					SetColor 255, 255, 0
					DrawRect Int(X) + 5, Int(Y) + 26, 4, 4
					DrawRect Int(X) + 5, Int(Y) + 12, 4, 4
												
					SetColor 255, 255, 255
				EndIf
				
				If GetMilliSecs() >= V + 8000 Then
					C2 = True				
				EndIf
				
				If C2 = True Then
					If Alp > 0 Then Alp:-.01 Else Del = True
				EndIf
				
			EndIf
			
			' // Flame to enemy collision
			If C2 = False Then
				If Player <> 2 Then ' // Player flame
					HandleMagicCol(BUB_FIRE, Int(X), Int(Y), F, 0, Player, False)
					
				Else ' // Boss flame
					For Local i:Int = 0 To b2Player
						If p_Hurt[i] = False And p_Dead[i] = False Then
							If ImagesCollide(GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i], imgFlame, Int(X), Int(Y), F) = True Then
								If p_Life[i] - .5 > 0 Then ' // Hurt
									If p_Life[i] = 1.5 Then PlaySFX sfxWarn
									PlaySFX sfxHurt
									
									p_Hurt[i] = True
									p_HurtT[i] = GetMilliSecs()
									p_Life[i]:-.5
									
								Else ' // Dead
									If p_Dead[i] = False Then
										PlaySFX sfxDeath
										p_Life[i] = 0
										p_T[i] = GetMilliSecs()
										p_Dead[i] = True

										For Local i2:Int = 0 To 5 ' // Clear items
											p_Items[i, i2] = -1
										Next
										
										p_MP[i] = 0 ' // Clear magic
																								
										If p_D[i] = 1 Then p_F[i] = 9 ElseIf p_D[i] = 0 Then p_F[i] = 25
									EndIf
									
								EndIf
								
							EndIf
						EndIf
					Next
									
				EndIf
			EndIf
				
		EndIf
		
		If Del = True Then partList.Remove p
		
		If createP > 0 Then ' // Create obj
			If createP = 1 Then ' // Bubbles
				For Local i:Int = 0 To 14 ' // Bubbles
					partList.AddLast part.Create(createX, createY, PART_POP, 101, i)
				Next
			ElseIf createP = 2 Then ' // Ghost
				partList.AddLast part.Create(createX, createY, PART_GHOST, 2, 0)
			
			ElseIf createP = 3 Then ' // Child flames				
				If createD = 1 Then ' // Right
					For Local tmpX:Int = createX + 18.5 To createX + 128 Step 18.5
						Local tmpCol:Int = ImageRectCollide(imgLevel, 0, 0, 0, Int(tmpX) + 5, Int(createY) + 12, 4, 4)
						
						If tmpCol = False Then
							If ImageRectCollide(imgLevel, 0, 0, 0, Int(tmpX) + 5, Int(createY) + 26, 4, 4) Then
								partList.AddLast part.Create(tmpX, Int(createY), PART_FLAME, createI, 0)
							Else
								Exit
							EndIf
						EndIf
					Next
				ElseIf createD = 0 Then ' // Left
					For Local tmpX:Int = createX - 18.5 To createX - 128 Step -18.5
						Local tmpCol:Int = ImageRectCollide(imgLevel, 0, 0, 0, Int(tmpX) + 5, Int(createY) + 12, 4, 4)
						
						If tmpCol = False Then 
							If ImageRectCollide(imgLevel, 0, 0, 0, Int(tmpX) + 5, Int(createY) + 26, 4, 4) Then
								partList.AddLast part.Create(tmpX, Int(createY), PART_FLAME, createI, 0)
							Else
								Exit
							EndIf
						EndIf
					Next
				
				EndIf							
			
			ElseIf createP = 4 Then ' // Title bubble
				Local p:Part = New Part
				p.ID = PART_TBUB; p.X = Rand(0, 570); p.Y = 448
				p.F = Rand(0, 3); p.D = Rand(0, 2); p.T = GetMilliSecs() - Rand(0, 200)
				partList.AddLast p				
			EndIf
			
		EndIf
		
	End Method
	
End Type

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² OBJECTS                                        
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Obj   
    Field X:Float, Y:Float, ID:Int, Alp:Float
	Field F:Int, T:Int, Target:Int, D:Int, D2:Int
	Field HP:Int, Fall:Int, THP:Int
	Field Hurt:Int, hurtT:Int, hurtC:Int
	Field XP:Int, Dmg:Float, Pnt:Int
	Field enemyID:Int, YI:Float, XI:Float, Spd:Float
	Field Chain:Int, Col:Int, J:Int, JT:Int, JY:Int, JS:Int, YD:Int
	Field Rot:Float, Player:Int, Drop:Int, DestY:Int
	Field Kind:Int, bDelay:Int, delayT:Int, Price:Int, SpawnT:Int
	Field bossT:Int, Lvl:Int, YSpd:Float, oldF:Int
	
    Function Create:Obj(X:Int, Y:Int, ID:Int, arg1:Int=0, arg2:Int=0, arg3:Float=0, arg4:Int=0, arg5:Int=1, arg6:Int=1)
		o:Obj = New Obj
		o.X = X; o.Y = Y; o.ID = ID
		o.T = GetMilliSecs()
		o.Lvl = arg6
		
		If b2Player = True Then 
			If p_Dead[PLAYER_1] <> False Then
				o.Target = 1
			ElseIf p_Dead[PLAYER_2] <> False Then
				o.Target = 0
			Else
				o.Target = Rand(0, 1) 
			EndIf
		Else 
			o.Target = 0 ' // Target player
		EndIf
		
		'If p_X[o.Target] < o.X Then o.D = 0 Else o.D = 1
		
		Select o.ID
			Case OBJ_ZEN ' // ZEN
			If arg5 = EN_ZEN Then ' // ZEN
				If o.Lvl = 1 Then ' // Level 1
					o.HP = 18
					o.THP = 18
					o.XP = 15
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 250
					o.Spd = 2
				ElseIf o.Lvl = 2 Then ' // Level 2
					o.HP = 26
					o.THP = 26
					o.XP = 25
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 500
					o.Spd = 2.1
				ElseIf o.Lvl = 3 Then ' // Level 3
					o.HP = 34
					o.THP = 34
					o.XP = 35
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 750
					o.Spd = 2.2		
				ElseIf o.Lvl = 4 Then ' // Level 4
					o.HP = 42
					o.THP = 42
					o.XP = 45
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 1000
					o.Spd = 2.3		
				ElseIf o.Lvl = 5 Then ' // Level 5
					o.HP = 50
					o.THP = 50
					o.XP = 55
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 1250
					o.Spd = 2.4									
				EndIf
				
			ElseIf arg5 = EN_MIGHTA Then ' // MIGHTA
				If o.Lvl = 1 Then ' // Level 1
					o.HP = 24
					o.THP = 24
					o.XP = 25
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 500
					o.Spd = 2
				ElseIf o.Lvl = 2 Then ' // Level 2
					o.HP = 32
					o.THP = 32
					o.XP = 35
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 750
					o.Spd = 2.1	
				ElseIf o.Lvl = 3 Then ' // Level 3
					o.HP = 40
					o.THP = 40
					o.XP = 45
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 1000
					o.Spd = 2.2
				ElseIf o.Lvl = 4 Then ' // Level 4
					o.HP = 48
					o.THP = 48
					o.XP = 55
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 1250
					o.Spd = 2.3									
				ElseIf o.Lvl = 5 Then ' // Gonsu
					o.HP = 56
					o.THP = 56
					o.XP = 65
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 1750
					o.Spd = 2.4													
				EndIf
				
			ElseIf arg5 = EN_BOSS1 Then ' // BOSS MIGHTA
				If b2Player = True And p_Dead[0] = False And p_Dead[1] = False Then
					o.HP = 850
					o.THP = 850
				Else
					o.HP = 600
					o.THP = 600
				EndIf
				o.XP = 300
				o.Dmg = .5
				o.Kind = arg5
				o.Pnt = 10000			
				o.Spd = 2.5
				o.bDelay = True
				o.delayT = GetMilliSecs() + 180
				o.bossT = GetMilliSecs()

				If bLooped > 0 Then ' // Hard
					o.HP:+(100 * bLooped)
					o.THP:+(100 * bLooped)
				EndIf
				
			ElseIf arg5 = EN_BOSS2 Then ' // BOSS MONSTA
				If b2Player = True And p_Dead[0] = False And p_Dead[1] = False Then
					o.HP = 1000
					o.THP = 1000
				Else
					o.HP = 750
					o.THP = 750
				EndIf
				o.XP = 600
				o.Dmg = .5
				o.Kind = arg5
				o.Pnt = 25000			
				o.Spd = 2
				o.YSpd = 2
				o.bDelay = True
				o.delayT = GetMilliSecs() + 180
				o.bossT = GetMilliSecs()
				o.D = Rand(0, 3)
			
				If bLooped > 0 Then ' // Hard
					o.HP:+(125 * bLooped)
					o.THP:+(125 * bLooped)
				EndIf
			
			ElseIf arg5 = EN_BOSS3 Then ' // BOSS DRUNK
				If b2Player = True And p_Dead[0] = False And p_Dead[1] = False Then
					o.HP = 2250
					o.THP = 2250
				Else
					o.HP = 1750
					o.THP = 1750
				EndIf
				o.XP = 1000
				o.Dmg = .5
				o.Kind = arg5
				o.Pnt = 50000			
				o.Spd = 2
				o.YSpd = 2
				o.bDelay = True
				o.delayT = GetMilliSecs() + 180
				o.bossT = GetMilliSecs()
				o.D = Rand(0, 3)

				If bLooped > 0 Then ' // Hard
					o.HP:+(150 * bLooped)
					o.THP:+(150 * bLooped)
				EndIf
							
			ElseIf arg5 = EN_MONSTA Then ' // MONSTA
				If o.Lvl = 1 Then
					o.HP = 28
					o.THP = 28
					o.XP = 30
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 750
					o.Spd = 2
					o.YSpd = 2
				ElseIf o.Lvl = 2 Then
					o.HP = 36
					o.THP = 36
					o.XP = 40
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 1000
					o.Spd = 2.1
					o.YSpd = 2.1
				ElseIf o.Lvl = 3 Then
					o.HP = 44
					o.THP = 44
					o.XP = 50
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 1250
					o.Spd = 2.2
					o.YSpd = 2.2						
				EndIf
				
				o.D2 = arg2
			
			ElseIf arg5 = EN_PULPUL Then ' // PULPUL
				If o.Lvl = 1 Then
					o.HP = 36
					o.THP = 36
					o.XP = 40
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 1000
					o.Spd = 1.8
					o.YSpd = 1
					o.D2 = arg2
				ElseIf o.Lvl = 2 Then
					o.HP = 44
					o.THP = 44
					o.XP = 50
					o.Dmg = .5
					o.Kind = arg5
					o.Pnt = 1250
					o.Spd = 2
					o.YSpd = 1.2
					o.D2 = arg2
				EndIf
				
			ElseIf arg5 = EN_BANE Then ' // BANEBOU
				o.HP = 50
				o.THP = 50
				o.XP = 55
				o.Dmg = .5
				o.Kind = arg5
				o.Pnt = 1500
				o.Spd = 2.1									
			EndIf
			
			o.Drop = True
			o.DestY = arg1
			o.D = arg2
													
			Case OBJ_DEAD ' // Dead spinner
			o.enemyID = arg1 ' // Enemy
			o.D = arg2 ' // Direction
			o.YI = Rnd(3, 5) ' // Speed
			o.Chain = arg4
			o.XI = Rnd(1, 2)
			o.Kind = arg5
			o.Lvl = arg6
			o.SpawnT = GetMilliSecs()
			If arg3 = 1 Then o.Hurt = True ' // Money bag
			
			Case OBJ_FRUIT ' // Fruit				
			o.F = arg1
			o.D = 0
			
			Case OBJ_GEM ' // Chain gem
			If arg1 = 100 Then ' // Big treasure
				o.F = Rand(0, 7)
				o.J = True ' // Big
				o.X:+20
			Else
				o.F = arg1
				If o.F > 5 Then o.F = 5
			EndIf
			
			o.Fall = True
			o.YI = 2
			o.Rot = Rand(0, 359)
			o.Alp = 0
			
			If arg2 = 1 Then ' // Brooch drop
				o.Fall = True
				o.YI = -2
			EndIf
			
			Case OBJ_CHEST ' // Treasure chest
			o.Player = arg1
			o.SpawnT = GetMilliSecs()
			
			Case OBJ_KEY ' // Key
			o.SpawnT = GetMilliSecs()
			
			Case OBJ_CANDY ' // Candy
			o.SpawnT = GetMilliSecs()
			o.F = Rand(0, 15)
			If arg1 = True Then o.Hurt = True
			
			Case OBJ_ITEM ' // Items
			o.Rot = Rand(0, 359)
			o.Alp = 0
			
			If arg1 >= 0 Then ' Chest items
				o.Player = arg1
				o.F = 0
				o.D = 0
			Else ' // Shop items
				o.HurtC = 0
				If arg1 = -1 Then ' // First item
					If b2Player = True And p_Dead[0] = False And p_Dead[1] = False Then
						o.F = 32 ' // Green potion
					Else
						o.F = Rand(16, 17)
						lastItem[0] = o.F
					EndIf
					
				ElseIf arg1 = -2 Then ' // Second item
					If b2Player = True And p_Dead[0] = False And p_Dead[1] = False Then
						o.F = Rand(18, MAX_ITEMS - 1) ' // No green potion two player
					Else				
						o.F = Rand(18, MAX_ITEMS)
					EndIf
					
				ElseIf arg1 = -3 Then ' // Third item
					If b2Player = True And p_Dead[0] = False And p_Dead[1] = False Then
						o.F = 32 ' // Green potion
					Else							
						Repeat
							o.F = Rand(16, 17)
						Until o.F <> lastItem[0]
					EndIf
					
				ElseIf arg1 = -4 Then ' // Resurrect player 1
					o.F = p_Class[0] + 33
					o.HurtC = 1
					o.Hurt = False
				ElseIf arg1 = -5 Then ' // Ressurect player 2
					o.F = p_Class[1] + 33
					o.HurtC = 2
					o.Hurt = False
				EndIf
					
				Local tmpR:Int = Rand(0, 4) ' // 300 to 500
				If b2Player = True And p_Dead[PLAYER_1] = False And p_Dead[PLAYER_2] = False Then
					o.Price = 200 + (tmpR * 50)
				Else
					o.Price = 300 + (tmpR * 50)
				EndIf
				
				If lastLevel >= 11 And lastLevel <= 20 Then
					o.Price:+200
				ElseIf lastLevel >= 21 And lastLevel <= 30 Then
					o.Price:+400
				ElseIf lastLevel >= 31 And lastLevel <= 40 Then
					o.Price:+600
				ElseIf lastLevel >= 41 And lastLevel <= 50 Then
					o.Price:+800
				EndIf
				
				o.D = 3
			EndIf
			
			Case OBJ_GHOST
			o.D = -1
			
			Case OBJ_SPAWN ' // Special bubble spawner
			o.Kind = arg1
			o.Hurt = arg2
			If o.Hurt = True Then o.T = GetMilliSecs() + 2000 Else o.T = GetMilliSecs() - 2000
			
		End Select
		
		Return o
	End Function

	Method Render()
		Local Del:Int = False
		Local createO:Int = 0, createX:Int = 0, createY:Int = 0, createID:Int = 0
		Local createD:Int = 0
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² ZEN / MIGHTA                      
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		If ID = OBJ_ZEN And nextLevel <> 9 Then
		
			Local offX:Int = 0, offY:Int = 0
			
			Local tmpF:Int = 0
			If Kind = EN_MONSTA Or Kind = EN_PULPUL Or Kind = EN_BOSS2 Or Kind = EN_BOSS3 Then ' // FLYER
				If D = 1 Or D = 2 Then tmpF = 2
			Else ' // WALKER
				If D = 1 Then tmpF = 2
			EndIf
			If Hurt > 0 Then tmpF:+(Hurt * 4) ' // Hurt frames
			
			Local imgEn:TImage = GetEnImg(Kind, Lvl)
			If Kind = EN_BOSS1 Or Kind = EN_BOSS2 Then offX = 20; offY = 30
			
			DrawImage imgEn, Int(X) - offX, Int(Y) - offY, F + tmpF
			
			If HP <> THP And Hurt = False Then ' // Show damage
				SetBlend ALPHABLEND
				
				Local tmpCalc:Float = Float(HP) / Float(THP)
							
				tmpF = 0
				If Kind = EN_MONSTA Or Kind = EN_PULPUL Or Kind = EN_BOSS2 Or Kind = EN_BOSS3 Then ' // FLYER
					If D = 1 Or D = 2 Then tmpF = 2
				Else ' // WALKER
					If D = 1 Then tmpF = 2
				EndIf
				
				SetAlpha 1
				DrawImage imgEn, Int(X) - offX, Int(Y) - offY, F + 4 + tmpF
				SetAlpha tmpCalc			
				DrawImage imgEn, Int(X) - offX, Int(Y) - offY, F + tmpF
				SetAlpha 1
				
				SetBlend ALPHABLEND; SetAlpha 1
			EndIf
			
			If GetMilliSecs() >= T + 130 Then ' // Animation
				If F = 0 Then F = 1 Else F = 0
				T = GetMilliSecs()
			EndIf
			
			If Hurt > 0 Then ' // Hurt animation
				If GetMilliSecs() >= hurtT + 40 Then
					If Hurt = 1 Then Hurt = 2 Else Hurt = 1
					If hurtC < 6 Then hurtC:+1 Else Hurt = 0; bDelay = False
					hurtT = GetMilliSecs()
				EndIf
			EndIf
			
			If Drop = True Then ' // Spawning
				If Int(Y) >= DestY Then 
					'If Kind = EN_MONSTA Or Kind = EN_PULPUL Or Kind = EN_BOSS2 Then 
					Y = DestY ' // Flyers wait
					Drop = False
				EndIf
			Else
				If allDrop = False Then Y = DestY
			EndIf
							
			' // WALKERS
			If Kind <> EN_MONSTA And Kind <> EN_PULPUL And Kind <> EN_BOSS2 And Kind <> EN_BOSS3 Then
				If J = False Then
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 5, Int(Y) + 29, 11, 1) = True And Y > 32 And Drop = False Then 
						'If Fall = True Then Y = Int(Y) - ((Int(Y) Mod 32) - 18) ' // Align					
						If Fall = True And allDrop = True Then
							If Rand(1, 3) = 2 Then ' // Seek
								If Int(o.X) + 37 < Int(p_X[o.Target]) Then o.D = 1 ElseIf Int(o.X) > Int(p_X[o.Target]) + 37 Then o.D = 0
							Else ' // Random
								If Kind <> EN_BANE Then o.D = Rand(0, 1)
							EndIf
						EndIf
											
						Fall = False
						Y = AlignY(Int(Y))
					Else
						Fall = True
					EndIf
				Else
					Fall = False
				EndIf
				
			Else ' // FLYERS
				If allDrop = False Then
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 5, Int(Y) + 29, 11, 1) = True And Y > 32 And Drop = False Then 									
						Fall = False
						Y = AlignY(Int(Y))
					Else
						If Y < DestY Then Fall = True Else Fall = False
					EndIf
				Else
					Fall = False; J = False
				EndIf
				
			EndIf
						
			' // PLAYER COLLISION			
			Local plyX:Int = 10, plyY:Int = 8, plyW:Int = 8
			If Kind = EN_BOSS1 Or Kind = EN_BOSS2 Then plyX = 10; plyY = 8; plyW = 24
			
			If allDrop = True Then ' // Drop check
			For Local i:Int = 0 To b2Player
				If p_Hurt[i] = False And p_Dead[i] = False Then
					Local tmpBHit:Int
					If Kind <> EN_BOSS3 Then
						tmpBHit = ImageRectCollide(GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i], Int(X - offX) + plyX, Int(Y - offY) + plyY, plyW, plyW)
					Else
						tmpBHit = ImagesCollide(GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i], imgDrunk, Int(X), Int(Y), F)
					EndIf
					If tmpBHit = True Then
						If p_Life[i] - Dmg > 0 Then ' // Hurt
							If p_Life[i] = 1.5 Then PlaySFX sfxWarn
							PlaySFX sfxHurt
							
							p_Hurt[i] = True
							p_HurtT[i] = GetMilliSecs()
							p_Life[i]:-Dmg
							
						Else ' // Dead
							If p_Dead[i] = False Then
								PlaySFX sfxDeath
								p_Life[i] = 0
								p_T[i] = GetMilliSecs()
								p_Dead[i] = True

								For Local i2:Int = 0 To 5 ' // Clear items
									p_Items[i, i2] = -1
								Next
								
								p_MP[i] = 0 ' // Clear magic
																						
								If p_D[i] = 1 Then p_F[i] = 9 ElseIf p_D[i] = 0 Then p_F[i] = 25
							EndIf
							
						EndIf
						
					EndIf
				EndIf
			Next
			
			' // BUBBLE COLLISION
			For b:Bub = EachIn bubList
				If b.ID = 1 And b.F < 3 Then ' // Shooting
					tmpF = 0
					If D = 1 Then tmpF = 2
					If ImagesCollide(imgEn, Int(X) - offX, Int(Y) - offY, F + tmpF, imgBubble, Int(b.X), Int(b.Y), b.F) = True Then
						
						If HP - p_Atk[b.P] > 0 Then ' // Alive
							PlaySFX sfxEHit
							
							HP:-p_Atk[b.P]
							Hurt = 1
							hurtC = 0
							hurtT = GetMilliSecs()
							
							' // Knock back
							If Kind = EN_BOSS3 Then ' // No boss knockback
								Spd:+.01
								YSpd:+.01
							Else
								If Fall = False And J = False Then
									If b.D = 0 And (D = 1 Or D = 2) Then 
										bDelay = True
										delayT = GetMilliSecs() - 120 ' // 180 ms delay
										
										'X:-12 
									ElseIf b.D = 1 And (D = 0 Or D = 3) Then 
										bDelay = True
										delayT = GetMilliSecs() - 120 ' // 180 ms delay

										'X:+12
									EndIf
								EndIf
							EndIf
							
							b.F = 4; b.T = GetMilliSecs() ' // Pop bubble
						Else ' // Captured
							
							If Kind <> EN_BOSS1 And Kind <> EN_BOSS2 And Kind <> EN_BOSS3 Then 
								' // Instapop
								If ImagesCollide(imgCol, Int(p_X[b.P]), Int(p_Y[b.P]), 0, imgCol, Int(X), Int(Y), 0) = True Then								
									b.F = 4; b.T = GetMilliSecs()
									b.PopSrc = b.P
									b.Cap = OBJ_ZEN
									b.capT = GetMilliSecs()
									b.X = X; b.Y = Y
									b.Kind = Kind
																	
								Else
									b.F = 3
									b.Cap = OBJ_ZEN
									b.X = X; b.Y = Y
									b.capT = GetMilliSecs()
									b.Kind = Kind
									
								EndIf
								
								b.Lvl = Lvl ' // Enemy level
								
							Else ' // BOSS BUBBLE
								PlaySFX sfxEHit
								b.F = 4; b.T = GetMilliSecs() ' // Pop bubble
								
								partList.AddLast part.Create(Int(X) - offX, Int(Y) - offY, PART_BOSSBUB, Kind)
								
								If curLevel = 202 Then ' // Kill all enemies
									CreateO = 7									
								EndIf
								
							EndIf
							
							Del = True
						EndIf
				
						Exit
					EndIf
					
				EndIf				
			Next
			EndIf ' // End drop check
			
			If bDebug = True Then
				SetColor 255, 255, 0
				DrawRect Int(X) + 5, Int(Y) + 29, 11, 1
				
				DrawRect Int(X - offX) + plyX, Int(Y - offY) + plyY, plyW, plyW

				DrawRect Int(X) + 12, Int(Y) -30, 4, 4			
				DrawRect Int(X) + 12, Int(Y) -46, 4, 4
				DrawRect Int(X) + 12, Int(Y) -62, 4, 4

				DrawRect Int(X) - 18, Int(Y) + 34, 4, 4
				DrawRect Int(X) + 45, Int(Y) + 34, 4, 4

				DrawRect Int(X) - 18, Int(Y) + 2, 4, 4
				DrawRect Int(X) + 45, Int(Y) + 2, 4, 4
				
				DrawRect Int(X), Int(Y) + 20, 1, 5
				DrawRect Int(X) + 35, Int(Y) + 20, 1, 5
				
				SetColor 255, 255, 255
			EndIf
			
			' // AI
			If Del = False Then
			
				If J = True Then ' // JUMPING
					If JS = 2 Then ' // Jumping sideways
						Y:-YI
						
						If Kind = EN_BOSS1 Then
							If YI > -2.5 Then YI:-.07 Else YI = -2.5; J = False; Y = AlignY(Int(Y))
						Else
							If YI > -2 Then YI:-.07 Else YI = -2; J = False; Y = AlignY(Int(Y))
						EndIf
						
						' // Bane head col
						If Kind = EN_BANE Then
							If YI > 0 Then
								If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 5, Int(Y), 11, 1) = True Then
									YI = 0
								EndIf
							EndIf
						EndIf
										
						' // Landing level col
						If YI < 0 Then
							If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 5, Int(Y) + 29, 11, 1) = True Then
								YI = -2; J = False; Y = AlignY(Int(Y))
							EndIf
						EndIf
						
						Local bBlocked:Int = False
						' // Blocked check
						If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) - 1, Int(Y) + 20, 2, 5) = True Then
							If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 35, Int(Y) + 20, 2, 5) = True Then
								bBlocked = True
							EndIf
						EndIf
						
						Local tmpCol:Int = -1
						If bBlocked = False Then ' // Can move
							If D = 0 Then
								If ImageRectCollide(imgLevel, 0, 0, 0, Int(X), Int(Y) + 20, 1, 5) Then tmpCol = 0						
								If (Int(X) - Spd > 37) And tmpCol <> 0 Then X:-Spd Else D = 1
								
							ElseIf D = 1 Then 
								If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 35, Int(Y) + 20, 1, 5) Then tmpCol = 1									
								If (Int(X) + Spd < 515) And tmpCol <> 1 Then X:+Spd Else D = 0
								
							EndIf
						EndIf
						
						If Kind = EN_BOSS1 Then ' // BOSS JUMP BLAST
							If bDelay = False And (YI > 0 And YI < .1) Then
								Local tmpX:Int = 0
								If D = 0 Then tmpX = -38 - offX ElseIf D = 1 Then tmpX = 74 - offX
								shotList.AddLast shot.Create(Int(X) + tmpX, Int(Y), SHOT_BLAST2, D, 0)
								shotList.AddLast shot.Create(Int(X) + tmpX, Int(Y), SHOT_BLAST2, D, 1)
								shotList.AddLast shot.Create(Int(X) + tmpX, Int(Y), SHOT_BLAST2, D, 2)

								bDelay = True; delayT = GetMilliSecs()
							EndIf							
						EndIf
						
						'If D = 0 Then 
						'	If Int(X) - 2 > 37 Then X:-2 Else D = 1
						'ElseIf D = 1 Then 
						'	If Int(X) + 2 < 515 Then X:+2 Else D = 0
						'EndIf
																
					Else ' // Jumping up
						If GetMilliSecs() >= JT + 400 Then
							If JS = 0 Then ' // Turn back around
								If Kind = EN_BOSS1 Then 
									J = False ' // Change direction
									If Rand(0, 1) = 1 Then
										If D = 0 Then D = 1 Else D = 0
									EndIf
								Else
									If D = 0 Then D = 1 Else D = 0
									JS = 1
								EndIf
							EndIf
							If Kind = EN_BOSS1 Then
								Local tmpX:Int = 0
								tmpX = -38 - offX
								shotList.AddLast shot.Create(Int(X) + tmpX, Int(Y), SHOT_BLAST2, 0, 0)
								tmpX = 74 - offX
								shotList.AddLast shot.Create(Int(X) + tmpX, Int(Y), SHOT_BLAST2, 1, 0)
								'shotList.AddLast shot.Create(Int(X) + tmpX, Int(Y), SHOT_BLAST2, D, 2)
								bossT = GetMilliSecs() + (Rand(0, 2) * 500)
								bDelay = True; delayT = GetMilliSecs()
							Else
								If Y > JY Then 
									Y:-2 
								Else 
									Y = JY; J = False
									If Int(o.X) + 37 < Int(p_X[o.Target]) Then o.D = 1 ElseIf Int(o.X) > Int(p_X[o.Target]) + 37 Then o.D = 0
								EndIf
							EndIf
						EndIf
					EndIf
					
				ElseIf Fall = False Then ' // WALKING
				
					If bDelay = False And (Kind <> EN_MONSTA And Kind <> EN_PULPUL And Kind <> EN_BOSS2 And Kind <> EN_BOSS3) Then ' // DELAY BLOCK
					If J = False Then ' // Jump sideways
						If Kind = EN_BANE Then ' // Banebou always jumps
							Local tmpJ:Int = False
							If Rand(1, 2) = 1 Then ' // Jump up
								If (Int(Y) > Int(p_Y[o.Target]) + 1) And (J = False And p_J[o.Target] = False) Then ' // Jump chance

								If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -46, 4, 4) = True Then ' // Floor check
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -62, 4, 4) = False Then ' // Above check
										J = True; JT = GetMilliSecs(); JY = Y - 80; JS = 0
										If D = 0 Then D = 1 Else D = 0
										tmpJ = True
									EndIf
								Else ' // Lower level
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -30, 4, 4) = True Then ' // Floor check
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -46, 4, 4) = False Then ' // Above check
											J = True; JT = GetMilliSecs(); JY = Y - 64; JS = 0
											If D = 0 Then D = 1 Else D = 0	
											tmpJ = True
										EndIf
									Else
									Rem
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -14, 4, 4) = True Then ' // Floor check
											If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -30, 4, 4) = False Then ' // Above check
												J = True; JT = GetMilliSecs(); JY = Y - 48; JS = 0
												If D = 0 Then D = 1 Else D = 0	
												tmpJ = True
											EndIf
										EndIf
									EndRem
									EndIf
								EndIf
								EndIf
							Else
								tmpJ = False
							EndIf
							
							If tmpJ = False Then J = True; JT = GetMilliSecs(); YI = 2; JS = 2

						Else
						If (Int(Y) >= Int(p_Y[o.Target]) - 1) Then
							If Rand(0, 10) <> 5 Then ' // Fall chance
							Else
								If D = 0 Then
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) -18, Int(Y) + 34, 4, 4) = False Then
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) -18, Int(Y) + 2, 4, 4) = False Then
											J = True; JT = GetMilliSecs(); YI = 2; JS = 2
										EndIf
									EndIf
									
								ElseIf D = 1 Then
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 45, Int(Y) + 34, 4, 4) = False Then
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 45, Int(Y) + 2, 4, 4) = False Then
											J = True; JT = GetMilliSecs(); YI = 2; JS = 2
										EndIf
									EndIf
									
								EndIf
							EndIf
						EndIf
						EndIf ' // END BANE BLOCK
					EndIf
					
					If Kind = EN_BOSS1 Then ' // BOSS JUMP
						If J = False And GetMilliSecs() >= bossT + 2500 Then
							If Rand(1, 2) = 2 Then ' // Change direction
								J = True; JT = GetMilliSecs(); JY = Y - 80; JS = 0
								If D = 0 Then D = 1 Else D = 0								
							Else
								J = True; JT = GetMilliSecs(); YI = 2.5; JS = 2						
								bossT = GetMilliSecs() + (Rand(0, 2) * 500)
							EndIf
						EndIf
					Else
						If (Int(Y) > Int(p_Y[o.Target]) + 1) And (J = False And p_J[o.Target] = False) Then ' // Jump chance
							If Rand(1, 50) = 25 Then
								If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -46, 4, 4) = True Then ' // Floor check
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -62, 4, 4) = False Then ' // Above check
										J = True; JT = GetMilliSecs(); JY = Y - 80; JS = 0
										If D = 0 Then D = 1 Else D = 0
									EndIf
								Else ' // Lower level
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -30, 4, 4) = True Then ' // Floor check
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -46, 4, 4) = False Then ' // Above check
											J = True; JT = GetMilliSecs(); JY = Y - 64; JS = 0
											If D = 0 Then D = 1 Else D = 0	
										EndIf										
									Else ' // Lowest level
										Rem
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -14, 4, 4) = True Then ' // Floor check
											If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -30, 4, 4) = False Then ' // Above check
												J = True; JT = GetMilliSecs(); JY = Y - 48; JS = 0
												If D = 0 Then D = 1 Else D = 0	
											EndIf
										EndIf
										EndRem
									EndIf
								EndIf
							EndIf
						EndIf
					EndIf
					EndIf ' // END DELAY BLOCK
					
					If Kind = EN_MONSTA Or Kind = EN_PULPUL Or Kind = EN_BOSS2 Or Kind = EN_BOSS3 Then J = False ' // FLYERS
					
					If J = False And allDrop = True Then ' // Drop check
						
						If bDelay = False Then ' // DELAY BLOCK
						If Kind <> EN_BOSS1 And (Kind <> EN_MONSTA And Kind <> EN_PULPUL And Kind <> EN_BOSS2 And Kind <> EN_BOSS3) Then ' // BOSS / FLYER BLOCK						
						If Rand(1, 50) = 25 Then ' // Change direction
							If (Int(Y) >= Int(p_Y[o.Target]) - 1 And Int(Y) <= Int(p_Y[o.Target]) + 1) And (p_Fall[o.Target] + p_J[o.Target]) = False Then
								If Int(o.X) + 37 < Int(p_X[o.Target]) Then o.D = 1 ElseIf Int(o.X) > Int(p_X[o.Target]) + 37 Then o.D = 0
							Else						
								' // Switch targets
								If b2Player = True Then
									Local tmpI:Int = o.Target
									If o.Target = 0 And p_Dead[PLAYER_2] = False Then
										tmpI = 1 
									ElseIf o.Target = 1 And p_Dead[PLAYER_1] = False Then
										tmpI = 0
									EndIf
									
									o.Target = tmpI

									'If (Int(Y) >= Int(p_Y[tmpI]) - 1 And Int(Y) <= Int(p_Y[tmpI]) + 1) And (p_Fall[tmpI] + p_J[tmpI]) = False Then 
									
										'o.Target = tmpI
										'If Int(o.X) + 37 < Int(p_X[o.Target]) Then o.D = 1 ElseIf Int(o.X) > Int(p_X[o.Target]) + 37 Then o.D = 0
									'EndIf
								EndIf																				
							EndIf
						ElseIf Rand(1, 100) = 50 Then ' // Switch no matter what
							' // Switch targets
							If b2Player = True Then
								Local tmpI:Int = o.Target
								If o.Target = 0 And p_Dead[PLAYER_2] = False Then
									tmpI = 1 
								ElseIf o.Target = 1 And p_Dead[PLAYER_1] = False Then
									tmpI = 0
								EndIf
								
								o.Target = tmpI

								'If (Int(Y) >= Int(p_Y[tmpI]) - 1 And Int(Y) <= Int(p_Y[tmpI]) + 1) And (p_Fall[tmpI] + p_J[tmpI]) = False Then 
									'o.Target = tmpI
									'If Int(o.X) + 37 < Int(p_X[o.Target]) Then o.D = 1 ElseIf Int(o.X) > Int(p_X[o.Target]) + 37 Then o.D = 0
								'EndIf
							EndIf						
						EndIf
						EndIf ' // END BOSS / FLYER BLOCK
						EndIf ' // END DELAY BLOCK
						
						If bDelay = True Then ' // Blast delay
							If GetMilliSecs() >= delayT + 300 Then bDelay = False
						Else
							If Kind <> EN_MONSTA And Kind <> EN_PULPUL And Kind <> EN_BOSS2 And Kind <> EN_BOSS3 Then ' // WALKERS
								Local bBlocked:Int = False
								' // Blocked check
								If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) - 1, Int(Y) + 20, 2, 5) = True Then
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 35, Int(Y) + 20, 2, 5) = True Then
										bBlocked = True
									EndIf
								EndIf
							
								Local tmpCol:Int = -1
								If bBlocked = False Then ' // Jump up to escape
									If D = 0 Then
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X), Int(Y) + 20, 1, 5) Then tmpCol = 0						
										If (Int(X) - Spd > 37) And tmpCol <> 0 Then X:-Spd Else D = 1
										
									ElseIf D = 1 Then 
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 35, Int(Y) + 20, 1, 5) Then tmpCol = 1									
										If (Int(X) + Spd < 515) And tmpCol <> 1 Then X:+Spd Else D = 0
										
									EndIf
								Else ' // Jump
									If Rand(1, 50) = 25 Then
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 12, Int(Y) -62, 4, 4) = False Then ' // Above check
											J = True; JT = GetMilliSecs(); JY = Y - 80; JS = 0
										Else
											J = True; JT = GetMilliSecs(); JY = Y - 64; JS = 0
										EndIf
									EndIf
									If D = 0 Then D = 1 Else D = 0	
								EndIf
							
							Else ' // FLYERS
								Local plyX:Int = 7, plyY:Int = 2, plyW:Int = 10
								If Kind = EN_BOSS2 Then ' // Boss
									plyX = 10; plyY = 8; plyW = 24																							
								EndIf
								
								If Kind <> EN_BOSS3 Then
								If D = 0 Then ' // UP / LEFT
									Y:-YSpd

									If Y > -24 And Y < 440 Then 
										X:-Spd

										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX) + plyX, Int(Y - offY), plyW, 1) = True Then 
											D = 3; X:-Rnd(0,.2) '; DebugLog "HIT1"
										ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX), Int(Y - offY) + 7, 1, plyW) = True Then 
											D = 1; Y:-Rnd(0,.2)'; DebugLog "HIT2"
										EndIf
									EndIf
									
								ElseIf D = 1 Then ' // UP / RIGHT
									Y:-YSpd

									If Y > -24 And Y < 440 Then 
										X:+Spd

										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX) + plyX, Int(Y - offY), plyW, 1) = True Then 
											D = 2; X:+Rnd(0,.2) '; DebugLog "HIT3"
										ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(X + offX) + 35, Int(Y - offY) + 7, 1, plyW) = True Then 
											D = 0; Y:-Rnd(0,.2) '; DebugLog "HIT4"
										EndIf
									EndIf
									
								ElseIf D = 2 Then ' // DOWN / RIGHT
									Y:+YSpd

									If Y > -24 And Y < 440 Then 
										X:+Spd
																	
										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX) + plyX, Int(Y) + 32, plyW, 1) = True Then 								
											D = 1; X:+Rnd(0,.2)'; DebugLog "HIT5"
										ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(X + offX) + 35, Int(Y - offY) + 7, 1, plyW) = True Then 
											D = 3; Y:+Rnd(0,.2)'; DebugLog "HIT6"
										EndIf
									EndIf

								ElseIf D = 3 Then ' // DOWN / LEFT
									Y:+YSpd

									If Y > -24 And Y < 440 Then 
										X:-Spd

										If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX) + plyX, Int(Y) + 32, plyW, 1) = True Then 
											D = 0; X:-Rnd(0,.2)'; DebugLog "HIT7"
										ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX), Int(Y - offY) + 7, 1, plyW) = True Then 
											D = 2; Y:+Rnd(0,.2)'; DebugLog "HIT8"
										EndIf
									EndIf
																	
								EndIf
														
								' // Stuck check L/R
								If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX) + plyX, Int(Y - offY), plyW, 1) = True Then 
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX) + plyX, Int(Y) + 32, plyW, 1) = True Then 
										If D = 0 Or D = 3 Then 
											If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX), Int(Y - offY) + 7, 1, plyW) = False Then X:-1 Else D = 1
										ElseIf D = 1 Or D = 2 Then 
											If ImageRectCollide(imgLevel, 0, 0, 0, Int(X + offX) + 35, Int(Y - offY) + 7, 1, plyW) = False X:+1 Else D = 0
										EndIf
									EndIf
								EndIf
								
								' // Stuck check U/D
								If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX), Int(Y - offY) + 7, 1, plyW) = True Then 
									If ImageRectCollide(imgLevel, 0, 0, 0, Int(X + offX) + 35, Int(Y - offY) + 7, 1, plyW) = True Then 
										If D = 0 Or D = 1 Then 
											If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX) + plyX, Int(Y - offY), plyW, 1) = False Then Y:-1 Else D = 2
										ElseIf D = 1 Or D = 2 Then 
											If ImageRectCollide(imgLevel, 0, 0, 0, Int(X - offX) + plyX, Int(Y) + 32, plyW, 1) = False Y:+1 Else D = 0
										EndIf
									EndIf
								EndIf
																
								If Int(Y) > 448 Then 
									Y = -32 ' // Screen wrap down
								ElseIf Int(Y) < -32 Then 
									Y = 448 ' // Screen wrap up
								EndIf
								
								If bDebug = True Then
									SetColor 255, 0, 0
									DrawRect Int(X - offX) + plyX, Int(Y - offY), plyW, 1
									DrawRect Int(X - offX), Int(Y - offY) + 7, 1, plyW
									DrawRect Int(X + offX) + 35, Int(Y - offY) + 7, 1, plyW
									DrawRect Int(X - offX) + plyX, Int(Y) + 32, plyW, 1
									SetColor 255, 255, 255
								EndIf
								Else ' // End Drunk boss block
									If D = 0 Then ' // UP / LEFT
										Y:-YSpd
										X:-Spd
										
										If X < 37 Then
											D = 1
										ElseIf Y < 47 Then
											D = 3
										EndIf
																				
									ElseIf D = 1 Then ' // UP / RIGHT
										Y:-YSpd
										X:+Spd

										If X > 552 - Int(ImageWidth(imgDrunk) * sclX) Then
											D = 0
										ElseIf Y < 47 Then
											D = 2
										EndIf
																				
									ElseIf D = 2 Then ' // DOWN / RIGHT
										Y:+YSpd
										X:+Spd

										If X > 552 - Int(ImageWidth(imgDrunk) * sclX) Then
											D = 3
										ElseIf Y > 416 - 96 Then
											D = 1
										EndIf

									ElseIf D = 3 Then ' // DOWN / LEFT
										Y:+YSpd
										X:-Spd

										If X < 37 Then
											D = 2
										ElseIf Y > 416 - 96 Then
											D = 0
										EndIf
																		
									EndIf								
																
								EndIf
							EndIf
							
						EndIf
						
						' // MIGHTA BLAST
						If Kind = EN_MIGHTA Then
							Local tmpR:Int = 200
							If lastLevel >= 11 And lastLevel <= 20 Then
								tmpR = 190
							ElseIf lastLevel >= 21 And lastLevel <= 30 Then
								tmpR = 180
							ElseIf lastLevel >= 31 And lastLevel <= 40 Then
								tmpR = 170
							ElseIf lastLevel >= 41 And lastLevel <= 50 Then
								tmpR = 160
							EndIf
							
							If bLooped > 0 Then ' // Hard
								tmpR:-(bLooped * 10)
								If tmpR < 10 Then tmpR = 10
							EndIf
							
							If Rand(1, tmpR) = Int(tmpR / 2) And bDelay = False Then
								Local tmpX:Int = 0
								'If D = 0 Then tmpX = -38 ElseIf D = 1 Then tmpX = 38
								Local tmpID:Int = SHOT_BLAST
								If Lvl = 2 Then tmpID = SHOT_BLAST2
								If Lvl = 3 Then tmpID = SHOT_BLAST3
								If Lvl = 4 Then tmpID = SHOT_BLAST4
								If Lvl = 5 Then tmpID = SHOT_BLAST5 ' // Gonsu
								shotList.AddLast shot.Create(Int(X) + tmpX, Int(Y), tmpID, D)
								bDelay = True; delayT = GetMilliSecs()
							EndIf
						ElseIf Kind = EN_BOSS2 Then
							If GetMilliSecs() >= bossT + 3500 Then
								bDelay = True; delayT = GetMilliSecs()
								bossT = GetMilliSecs()
								
								Local tmpR:Int = Rand(1, 5)
								
								If tmpR <= 2 Then
									createO = 6
									createX = Int(X); createY = Int(Y)
									createD = D
									If D = 1 Or D = 2 Then createX:+16 ElseIf D = 0 Or D = 3 Then createX:-16
								ElseIf tmpR <= 4 Then ' // Fire
									
									Local tmpX:Int	' // Align X
									tmpX = Int((X + 19) / 18.967)
									tmpX = Int(tmpX * 8) * sclX
									'tmpX:+8
									
									' // Create flame								
									partList.AddLast part.Create(Int(tmpX), Int(Y) + 16, PART_FLAME, 2, 1)

								Else ' // Change direction
									Local tmpD:Int
									Repeat
										tmpD = Rand(0, 3)
									Until tmpD <> D
									D = tmpD
								EndIf
								'EndIf
								
							EndIf
							'If Rand(1, 50) = 25 And bDelay = False Then
							'	Local tmpX:Int = 0
							'	'If D = 0 Then tmpX = -38 ElseIf D = 1 Then tmpX = 38
							'	shotList.AddLast shot.Create(Int(X) + tmpX, Int(Y), SHOT_BLAST, D)
							'	bDelay = True; delayT = GetMilliSecs()
							'EndIf
						ElseIf Kind = EN_BOSS3 Then
							If GetMilliSecs() >= bossT + 2500 Then
								Local tmpPass:Int = False
								If D = 1 Or D = 2 Then
									If X < 442 Then tmpPass = True
								Else
									If X > 146 Then tmpPass = True
								EndIf
								
								If tmpPass = True
									'bDelay = True; delayT = GetMilliSecs()
									bossT = GetMilliSecs() + (Rand(-1, 1) * 500)
									
									Local tmpX:Int = 25
									If D = 1 Or D = 2 Then tmpX = 80
									For Local i:Int = 0 To 5
										shotList.AddLast shot.Create(Int(X) + tmpX, Int(Y) + 64, SHOT_BOTTLE, D, i)
									Next
								EndIf
								
							EndIf										
										
						EndIf
					
					EndIf
					
				Else
					If Int(Y) < 448 Then Y:+2 Else Y = -32 ' // Screen wrap
				EndIf
				
			EndIf
									
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² DEAD SPINNER                                 
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = OBJ_DEAD Then
									
			If enemyID = OBJ_ZEN Then
				If Kind = EN_ZEN Then
					'If curLevel >= 11 Then ' // Level 2
					'	DrawImage imgZen2, Int(X), Int(Y), 12 + F
					'Else ' // Level 1
						DrawImage imgZen, Int(X), Int(Y), 12 + F
					'EndIf
				ElseIf Kind = EN_MIGHTA Then
					If Hurt = True Then ' // Money bag
						DrawImage imgBag, Int(X), Int(Y), F
					Else
						'If curLevel >= 16 Then ' // Level 2
						'	DrawImage imgMighta2, Int(X), Int(Y), 12 + F
						'Else
						If Lvl = 5 Then ' // Gonsu
							DrawImage imgGonsu, Int(X), Int(Y), 12 + F
						Else
							DrawImage imgMighta, Int(X), Int(Y), 12 + F
						EndIf
					EndIf
				ElseIf Kind = EN_BOSS1 Then
					DrawImage imgMighta2, Int(X), Int(Y), 12 + F
				ElseIf Kind = EN_MONSTA Or Kind = EN_BOSS2 Then		
					DrawImage imgMonsta, Int(X), Int(Y), 12 + F
				ElseIf Kind = EN_PULPUL Then
					DrawImage imgPulPul, Int(X), Int(Y), 12 + F				
				ElseIf Kind = EN_BANE Then
					DrawImage imgBane, Int(X), Int(Y), 12 + F								
				ElseIf Kind = EN_BOSS3 Then
					DrawImage imgDrunk2, Int(X), Int(Y), 12 + F												
				EndIf
				
			EndIf
			
			If GetMilliSecs() >= T + 70 Then
				If F < 3 Then F:+1 Else F = 0
				T = GetMilliSecs()
			EndIf
			
			If YI < -2 Then ' // LEVEL COLLISION			
			
				' // LEFT / RIGHT COLLISION
				Col = -1
				If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 19, Int(Y) + 7, 4, 9) Then Col = 1
				If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 9, Int(Y) + 7, 4, 9) Then Col = 0

				If Col = -1 Then
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 10, Int(Y) + 29, 7, 1) And Y > 34 Then 
						
						' // Make sure it's not in the middle of a block
						If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 10, Int(Y) + 8, 8, 8) = False Then
							Local tmpPass:Int = False
							If Kind = EN_BOSS1 Or Kind = EN_BOSS2 Or Kind = EN_BOSS3 Then tmpPass = Rand(0, 1) ' // Fruit vs. candy
							
							If tmpPass = False Then ' // Fruit
								createO = 1 ' // Create fruit
								createX = Int(X)
								createY = AlignY(Int(Y))								
								'If chain <= 3 Then createID = Chain Else 
								createID = Rand(0, 3)
								
							Else ' // Candy
								createO = 3 ' // Create candy
								createX = Int(X)
								createY = AlignY(Int(Y))
							EndIf
							
							' // Brooch (enemies into gems)
							If ACT_BROOCH[0] = 1 Or ACT_BROOCH[1] = 1 Then
								createO = 5 ' // Create gem
								createX = Int(X)
								createY = AlignY(Int(Y))
							ElseIf ACT_DONUT[0] = 1 Or ACT_DONUT[1] = 1 Then ' // Donut
								createO = 3 ' // Create candy
								createX = Int(X)
								createY = AlignY(Int(Y))
							ElseIf ACT_CLOVER[0] = 1 Or ACT_CLOVER[1] = 1 Then ' // Clover
								createO = 4 ' // Create money bag
								createX = Int(X)
								createY = AlignY(Int(Y))							
							EndIf
							
							If Hurt = True Then ' // Money bag
								createO = 4 ' // Create money bag
								createX = Int(X)
								createY = AlignY(Int(Y))							
							EndIf
							
							Rem
							If curLevel = 202 Then ' // Child monstas drop candy
								createO = 3 ' // Create candy
								createX = Int(X)
								createY = AlignY(Int(Y))							
							EndIf
							EndRem
							
							Del = True
						EndIf
						
					EndIf
				EndIf
				
				If bDebug = True Then
					SetColor 255, 255, 0
					DrawRect Int(X) + 10, Int(Y) + 29, 7, 1								
					DrawRect Int(X) + 19, Int(Y) + 7, 4, 9
					DrawRect Int(X) + 9, Int(Y) + 7, 4, 9
					SetColor 255, 255, 255
				EndIf				
			EndIf
			
			' // AI
			If Del = False Then
				Local tmpX:Float = XI
				If XI > .5 Then
					If D = 0 Then 
						If Int(X - tmpX) > 37 Then X:-tmpX Else D = 1
					ElseIf D = 1 Then 
						If Int(X + tmpX) < 515 Then X:+tmpX Else D = 0
					EndIf					
					XI:-.005
				Else
					XI = 0
					X = Int(X)
				EndIf
				
				If YI > -4 Then ' // Rise
					Y:-YI			
					YI:-.05 
				Else ' // Fall
					Y:+2
					YI = -4
				EndIf
				
				If Int(Y) > 448 Then 
					Y = -32 ' // Screen wrap down
				ElseIf Int(Y) < -32 Then 
					Y = 448 ' // Screen wrap up
				EndIf
			EndIf

			' // Force delete if not landing
			If GetMilliSecs() >= SpawnT + 10000 Then Del = True
			
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² FRUIT                               
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = OBJ_FRUIT Then
			
			If D = 0 Then ' // Normal
				Local tmpF:Int = 0
				If lastLevel >= 11 And lastLevel <= 20 Then ' // SECOND SET
					tmpF = 4
				ElseIf lastLevel >= 21 And lastLevel <= 30 Then ' // THIRD SET
					tmpF = 8
				ElseIf lastLevel >= 31 And lastLevel <= 40 Then ' // FOURTH SET
					tmpF = 12
				ElseIf lastLevel >= 41 And lastLevel <= 50 Then ' // FIFTH SET
					tmpF = 16
				EndIf
				
				DrawImage imgFruit, Int(X), Int(Y), F + tmpF
				
				If GetMilliSecs() >= T + 9500 Then
					D = 1
					F = 0
					T = GetMilliSecs()
				EndIf
				
			ElseIf D = 1 Then ' // Vanish
				DrawImage imgBlip, Int(X), Int(Y), F
				
				If GetMilliSecs() >= T + 115 Then
					If F < 1 Then F:+1 Else Del = True
					T = GetMilliSecs()
				EndIf
				
			EndIf
			
			' // PLAYER COLLISION
			If D = 0 Then ' // Vanish check
				For Local i:Int = 0 To b2Player
					If p_Dead[i] = False Then ' // Dead check
					
					If ImagesCollide(imgFruit, Int(X), Int(Y), F, GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i]) = True Then
						If GetMilliSecs() >= fruitChan + 150 Then 
							PlaySFX(sfxFruit)
							fruitChan = GetMilliSecs()
						EndIf
						
						Del = True
						Local tmpScore:Int
						If F = 0 Then      ' // Apple
							tmpScore:+10
						ElseIf F = 1 Then  ' // Bell pepper
							tmpScore:+15 
						ElseIf F = 2 Then  ' // Cucumber
							tmpScore:+20
						ElseIf F = 3 Then  ' // Grape
							tmpScore:+25
						EndIf
						
						If lastLevel >= 11 And lastLevel <= 20 Then ' // SECOND SET
							tmpScore:+10
						ElseIf lastLevel >= 21 And lastLevel <= 30 Then ' // THIRD SET
							tmpScore:+15
						ElseIf lastLevel >= 31 And lastLevel <= 40 Then ' // FOURTH SET
							tmpScore:+20
						ElseIf lastLevel >= 41 And lastLevel <= 50 Then ' // FIFTH SET
							tmpScore:+25
						EndIf
				
						Local tmpX:Int = 8
						If Len(String(tmpScore)) = 3 Then tmpX = 3
						
						p_Score[i]:+tmpScore
						If i = PLAYER_1 Then ' // Share gold
							If p_Dead[PLAYER_2] = False Then p_Score[PLAYER_2]:+Int(tmpScore/2)
						ElseIf i = PLAYER_2 Then
							If p_Dead[PLAYER_1] = False Then p_Score[PLAYER_1]:+Int(tmpScore/2)
						EndIf
						p_Points[i]:+250
						
						partList.AddLast part.Create(Int(X) + tmpX, Int(Y) - 8, PART_POINTS, tmpScore, i)

						Exit
					EndIf
					
					EndIf ' // End dead block
				Next
			EndIf

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² GEM                        
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = OBJ_GEM Then
		
			Local offX:Int, offY:Int
			If J = True Then offX = 20; offY = 30

			If D = 0 Then
				If J = False Then
					SetAlpha LIGHTBLEND; SetAlpha Alp; SetRotation Rot
					If F = 0 Then SetColor 92, 230, 52 ElseIf F = 1 Then SetColor 252, 130, 116 ElseIf F = 2 Then SetColor 196, 118, 252 ElseIf F = 3 Then SetColor 76, 206, 220
					If F = 4 Then SetColor 250, 105, 163 ElseIf F = 5 Then SetColor 251, 219, 123
					DrawImage imgFlare, Int(X) + 18, Int(Y) + 16
					Rot:+.25
					
					If Alp < .225 Then Alp:+.005 Else Alp = .225
				EndIf
				
				SetAlpha ALPHABLEND; SetAlpha 1; SetRotation 0; SetColor 255, 255, 255
				If J = False Then
					DrawImage imgGem, Int(X), Int(Y), F

					If GetMilliSecs() >= T + 9500 Then
						D = 1
						oldF = F
						F = 0
						T = GetMilliSecs()						
					EndIf
				Else
					DrawImage imgBig, Int(X) - offX, Int(Y) - offY, F
				EndIf
				
			ElseIf D = 1 Then ' // Vanish
				SetAlpha LIGHTBLEND; SetAlpha Alp; SetRotation Rot
				If oldF = 0 Then SetColor 92, 230, 52 ElseIf oldF = 1 Then SetColor 252, 130, 116 ElseIf oldF = 2 Then SetColor 196, 118, 252 ElseIf oldF = 3 Then SetColor 76, 206, 220
				If oldF = 4 Then SetColor 250, 105, 163 ElseIf oldF = 5 Then SetColor 251, 219, 123
				DrawImage imgFlare, Int(X) + 18, Int(Y) + 16
				Rot:+.25
				SetAlpha ALPHABLEND; SetAlpha 1; SetRotation 0; SetColor 255, 255, 255

				If Alp > 0 Then Alp:-.005 Else Alp = 0
							
				DrawImage imgBlip, Int(X), Int(Y), F
				
				If GetMilliSecs() >= T + 115 Then
					If F < 1 Then 
						F:+1 
					Else 
						Del = True
					EndIf
					T = GetMilliSecs()
				EndIf
			
			ElseIf D = 2 Then ' // Fade away
				SetAlpha LIGHTBLEND; SetAlpha Alp; SetRotation Rot
				If F = 0 Then SetColor 92, 230, 52 ElseIf F = 1 Then SetColor 252, 130, 116 ElseIf F = 2 Then SetColor 196, 118, 252 ElseIf F = 3 Then SetColor 76, 206, 220
				If F = 4 Then SetColor 250, 105, 163 ElseIf F = 5 Then SetColor 251, 219, 123
				DrawImage imgFlare, Int(X) + 18, Int(Y) + 16
				Rot:+.25
				SetAlpha ALPHABLEND; SetAlpha 1; SetRotation 0; SetColor 255, 255, 255

				If Alp > 0 Then Alp:-.005 Else Del = True
			EndIf	
				
			If D = 0 And Del = False Then
				If YI > -2 Then ' // Rising
					Y:-YI
					
					If YI > -2 Then YI:-.05 Else YI = -2
					
				ElseIf Fall = True Then ' // Falling
					' // Make sure it's not in the middle of a block
					Local tmpCol:Int = ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 10, Int(Y) + 8, 8, 8)

					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 6, Int(Y) + 29, 8, 1) And Y > 34 And tmpCol = False Then 
						Fall = False
											
						Y = AlignY(Int(Y))
					Else
						Y:+2
						
						If Int(Y) > 448 Then Y = -32 ' // Screen wrap
					EndIf
					
					If bDebug = True Then
						SetColor 255, 255, 0
						DrawRect Int(X) + 6, Int(Y) + 29, 8, 1								
						SetColor 255, 255, 255
					EndIf	
					
				ElseIf Fall = False Then ' // Resting
					For Local i:Int = 0 To b2Player
						If p_Dead[i] = False Then ' // Dead check
						
						Local tmpImg:TImage = imgGem
						If J = True Then tmpImg = imgBig
						
						If ImagesCollide(tmpImg, Int(X) - offX, Int(Y) - offY, F, GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i]) = True Then
							If GetMilliSecs() >= fruitChan + 150 Then 
								PlaySFX(sfxFruit)
								fruitChan = GetMilliSecs()
							EndIf
						
							'Del = True
							If J = False Then
								D = 2'; Alp = .35 ' // Fade away
							Else
								Del = True
							EndIf
							
							Local tmpScore:Int
							If F = 0 Then      ' // Green
								tmpScore:+50
							ElseIf F = 1 Then  ' // Orange
								tmpScore:+75
							ElseIf F = 2 Then  ' // Purple
								tmpScore:+100
							ElseIf F = 3 Then  ' // Blue
								tmpScore:+150
							ElseIf F = 4 Then  ' // Red
								tmpScore:+200
							ElseIf F = 5 Then  ' // Gold
								tmpScore:+250
							EndIf
							
							' // By level
							If lastLevel >= 11 And lastLevel <= 20 Then
								tmpScore:+25
							ElseIf lastLevel >= 21 And lastLevel <= 30 Then
								tmpScore:+50
							ElseIf lastLevel >= 31 And lastLevel <= 40 Then
								tmpScore:+75
							ElseIf lastLevel >= 41 And lastLevel <= 50 Then
								tmpScore:+100
							EndIf
							
							If J = True Then ' // Big treasure
								If curLevel = 201 Then
									tmpScore = 250
								ElseIf curLevel = 202 Then
									tmpScore = 500
								ElseIf curLevel = 203 Then
									tmpScore = 750
								EndIf
							EndIf
							
							Local tmpX:Int = 8
							If Len(String(tmpScore)) = 3 Then tmpX = 3
							
							p_Score[i]:+tmpScore
							If i = PLAYER_1 Then ' // Share gold
								If p_Dead[PLAYER_2] = False Then p_Score[PLAYER_2]:+Int(tmpScore/2)
							ElseIf i = PLAYER_2 Then
								If p_Dead[PLAYER_1] = False Then p_Score[PLAYER_1]:+Int(tmpScore/2)
							EndIf							
							p_Points[i]:+500
							
							partList.AddLast part.Create(Int(X) + tmpX, Int(Y) - 8 - offX, PART_POINTS, tmpScore, i)

							Exit
						EndIf
						
						EndIf ' // End dead check
					Next			
				EndIf
			EndIf

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² KEY                             
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = OBJ_KEY Then
			
			DrawImage imgTreasure, Int(X), Int(Y), 0
			
			If GetMilliSecs() >= spawnT + 250 Then
			For Local i:Int = 0 To b2Player
				If p_Dead[i] = False Then ' // Dead check
					If ImagesCollide(imgTreasure, Int(X), Int(Y), 0, GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i]) = True Then
						PlaySFX sfxKey

						p_Points[i]:+250 ' // Points

						keyTime = -2 ' // Key is gone
						p_Key[i] = True
						Del = True
						Exit
						
					EndIf
				EndIf ' // End dead block
			Next
			EndIf
			
			If GetMilliSecs() >= T + 8000 Then keyTime = -3; Del = True

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² TREASURE CHEST                       
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = OBJ_CHEST Then
			
			DrawImage imgTreasure, Int(X), Int(Y), 1
			
			If GetMilliSecs() >= SpawnT + 250 Then
				If ImagesCollide(imgTreasure, Int(X), Int(Y), 1, GetClassImg(Player), Int(p_X[Player]), Int(p_Y[Player]), p_F[Player]) = True Then
					PlaySFX sfxPoof
					
					createO = 2
					createX = X; createY = Y; createID = Player
					
					p_Key[Player] = False
					Del = True
				EndIf
			EndIf
			
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² ITEM
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = OBJ_ITEM Then
			
			objC:-1 ' // Doesn't count against timer
			
			If D <> 0 And D <> 3 Then
				SetAlpha LIGHTBLEND; SetAlpha Alp; SetRotation Rot
				SetColor 255, 255, 255
				DrawImage imgFlare, Int(X) + 18, Int(Y) + 16 + YI
				Rot:+.25				
				SetAlpha ALPHABLEND; SetAlpha 1; SetRotation 0; SetColor 255, 255, 255
				
				If D = 4 Then ' // Fade away
					If Alp > 0 Then Alp:-.005 Else Del = True
				ElseIf D <> 0 Then ' // Fade in
					If Alp < .1 Then Alp:+.005 Else Alp = .1
				EndIf
			EndIf
			
			If D = 0 Then ' // Blip
				DrawImage imgBlip, Int(X), Int(Y), F
				
				If GetMilliSecs() >= T + 115 Then
					If F < 1 Then 
						F:+1 
					Else 
						D = 1
						YI = 4
						If Rand(1, 2) = 1 Then ' // Treasure 50% chance
							'For Local i:Int = 1 To 7 ' // Shuffle 7 times
								F = Rand(0, 15)
							'Next
						Else ' // Item 50% chance
							'For Local i:Int = 1 To 7 ' // Shuffle 7 times
								F = Rand(16, MAX_ITEMS)
							'Next						
						EndIf
						
						If bXMode = True Then F = Rand(16, MAX_ITEMS) ' // X Mode
					EndIf
					
					T = GetMilliSecs()
				EndIf
				
			ElseIf D = 1 Then ' // Rising
						
				DrawImage imgItems, Int(X), Int(Y), F
				
				Y:-YI
				
				If YI > 0 Then YI:-.25 Else D = 2; T = GetMilliSecs()
				
			ElseIf D = 2 Then ' // Done		
				'If GetMilliSecs() >= T + 1250 Then
				'	If Rand(0, 1) = 1 Then DrawImage imgItems, Int(X), Int(Y), F
				'Else
					DrawImage imgItems, Int(X), Int(Y), F
				'EndIf
				If GetMilliSecs() >= T + 800 Then
				
					If F <= 15 Then ' // Treasure
						Local tmpScore:Int
						If F >= 0 And F <= 3 Then       ' // Shards
							tmpScore:+25
						ElseIf F >= 4 And F <= 7 Then   ' // Diamonds
							tmpScore:+50
						ElseIf F >= 8 And F <= 11 Then  ' // Crowns
							tmpScore:+75
						ElseIf F >= 12 And F <= 15 Then ' // Kings
							tmpScore:+100
						EndIf
						
						' // By level
						If lastLevel >= 11 And lastLevel <= 20 Then
							tmpScore:+15
						ElseIf lastLevel >= 21 And lastLevel <= 30 Then
							tmpScore:+25
						ElseIf lastLevel >= 31 And lastLevel <= 40 Then
							tmpScore:+35
						ElseIf lastLevel >= 41 And lastLevel <= 50 Then
							tmpScore:+50
						EndIf
							
						PlaySFX sfxBlip
						
						Local tmpX:Int = 8
						If Len(String(tmpScore)) = 3 Then tmpX = 3
						p_Score[Player]:+tmpScore

						If Player = PLAYER_1 Then ' // Share gold
							If p_Dead[PLAYER_2] = False Then p_Score[PLAYER_2]:+Int(tmpScore/2)
						ElseIf Player = PLAYER_2 Then
							If p_Dead[PLAYER_1] = False Then p_Score[PLAYER_1]:+Int(tmpScore/2)
						EndIf
						
						partList.AddLast part.Create(Int(X) + tmpX, Int(Y) + 6, PART_POINTS, tmpScore, Player)
						
					Else ' // Inventory item					
						Local bCheck:Int = False										
						For Local i:Int = 0 To 5
							If p_Items[Player, i] = -1 Then 
								p_Items[Player, i] = F
								bCheck = True
								Exit
							EndIf
						Next
						
						PlaySFX sfxGet
						
						If bCheck = True Then
							If p_Item[Player] = -1 Then p_Item[Player] = 0
						Else
							p_Score[Player]:+50 ' // Full items, give gold
						EndIf
					
					EndIf
					
					p_Points[Player]:+1000 ' // Points

					'Del = True
					D = 4'; Alp = .25 ' // Fade away
				EndIf
				
			ElseIf D = 3 Then ' // Shop item
			
				Local tmpXOff:Int = 8
				If Len(String(o.Price)) = 4 Then tmpXOff = 18
				DrawFont String(o.Price), Int(X) - tmpXOff, Int(Y) - 32, 0, True
				If HurtC > 0 Then SetBlend LIGHTBLEND; SetAlpha .8
				If Hurt = False Then
					DrawImage imgItems, Int(X), Int(Y) + YI, F				
				Else
					If Rand(0, 1) = True Then DrawImage imgItems, Int(X), Int(Y) + YI, F
				EndIf
				SetBlend ALPHABLEND; SetAlpha 1
				
				If YD = 0 Then
					If YI > -2 Then YI:-.1 Else YD = 1
				ElseIf YD = 1 Then
					If YI < 2 Then YI:+.1 Else YD = 0
				EndIf
				
				If HurtC > 0 Then Hurt = False ' // Resurrect check
				
				If Hurt = False Then
					For Local i:Int = 0 To b2Player
						If p_Dead[i] = False Then ' // Dead block
						
						If ImagesCollide(imgItems, Int(X), Int(Y + YI), F, GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i]) = True Then
							If p_Score[i] >= Price Then
																					
								If HurtC <> 0 Then ' // Ressurrect
									PlaySFX sfxGet
									p_Score[i]:-Price

									Local tmpI:Int = HurtC - 1
									If tmpI = 0 Then
										p_X[0] = 55; p_Y[0] = 386
										p_D[0] = 1
										p_F[0] = 0
										
									ElseIf tmpI = 1 Then
										p_X[1] = 497; p_Y[1] = 386
										p_D[1] = 0
										p_F[1] = 16

									EndIf							
									
									FlushKeys tmpI
									
									If p_Life[tmpI] + baseHearts < p_LifeT[tmpI] Then p_Life[tmpI]:+baseHearts Else p_Life[tmpI] = p_LifeT[tmpI] ' // Health up
									If p_MP[tmpI] + 9 < p_GMP[tmpI] Then p_MP[tmpI]:+9 Else p_MP[tmpI] = p_GMP[tmpI] ' // MP up
									p_Points[tmpI] = 0 ' // Zero out points
									p_Dead[tmpI] = False
									
									Del = True
								Else
									If p_Items[i, 5] = -1 Then ' // 6 items max
										PlaySFX sfxGet
										p_Score[i]:-Price
									
										' // Add item
										For Local i2:Int = 0 To 5
											If p_Items[i, i2] = -1 Then 
												p_Items[i, i2] = F
												Exit
											EndIf
										Next
										
										If p_Item[i] = -1 Then p_Item[i] = 0
										Hurt = True; HurtT = GetMilliSecs()
									EndIf
								EndIf
								
								Exit
							EndIf
						EndIf
						
						EndIf ' // End dead block
					Next
				Else
					If GetMilliSecs() >= HurtT + 750 Then ' // Shuffle
						Hurt = False
						
						F = FindItem()
						
						Local tmpR:Int = Rand(0, 4) ' // 350 to 550
						If b2Player = True And p_Dead[PLAYER_1] = False And p_Dead[PLAYER_2] = False Then
							Price = 200 + (tmpR * 50)
						Else
							Price = 300 + (tmpR * 50)
						EndIf
						If lastLevel >= 11 And lastLevel <= 20 Then
							Price:+200
						ElseIf lastLevel >= 21 And lastLevel <= 30 Then
							Price:+400
						ElseIf lastLevel >= 31 And lastLevel <= 40 Then
							Price:+600
						ElseIf lastLevel >= 41 And lastLevel <= 50 Then
							Price:+800
						EndIf														
						
					EndIf
				EndIf
				
			EndIf
						
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² CANDY / MONEY BAG                         
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = OBJ_CANDY Then

			Local tmpImg:TImage
			If Hurt = True Then tmpImg = imgBag; F = 0 Else tmpImg = imgCandy
			
			DrawImage tmpImg, Int(X), Int(Y), F
			
			If (GetMilliSecs() >= spawnT + 250) Or Hurt = True Then
			For Local i:Int = 0 To b2Player
				If p_Dead[i] = False Then ' // Dead block
				
				If ImagesCollide(tmpImg, Int(X), Int(Y), F, GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i]) = True Then
					If curLevel > 200 Then 
						If GetMilliSecs() >= fruitChan + 150 Then 
							PlaySFX sfxFruit
							fruitChan = GetMilliSecs()
						EndIf
					Else
						PlaySFX(sfxCandy)
					EndIf
					
					p_Points[i]:+1000 ' // Points
					
					If Hurt = False Then
						' // Restore HP and MP						
						If p_Life[i] + .5 < p_LifeT[i] Then p_Life[i]:+.5 Else p_Life[i] = p_LifeT[i] ' // Health up
						If p_MP[i] + 1 < p_GMP[i] Then p_MP[i]:+1 Else p_MP[i] = p_GMP[i] ' // MP up

						If i = PLAYER_1 Then ' // Share gold
							If p_Dead[PLAYER_2] = False Then 
								If p_Life[PLAYER_2] + .5 < p_LifeT[PLAYER_2] Then p_Life[PLAYER_2]:+.5 Else p_Life[PLAYER_2] = p_LifeT[PLAYER_2] ' // Health up
								If p_MP[PLAYER_2] + 1 < p_GMP[PLAYER_2] Then p_MP[PLAYER_2]:+1 Else p_MP[PLAYER_2] = p_GMP[PLAYER_2] ' // MP up
							EndIf
						ElseIf i = PLAYER_2 Then
							If p_Dead[PLAYER_1] = False Then 
								If p_Life[PLAYER_1] + .5 < p_LifeT[PLAYER_1] Then p_Life[PLAYER_1]:+.5 Else p_Life[PLAYER_1] = p_LifeT[PLAYER_1] ' // Health up
								If p_MP[PLAYER_1] + 1 < p_GMP[PLAYER_1] Then p_MP[PLAYER_1]:+1 Else p_MP[PLAYER_1] = p_GMP[PLAYER_1] ' // MP up
							EndIf
						EndIf
						
						candyTime = -1 ' // Candy is gone
					Else
						Local tmpS:Int = 50
						If lastLevel >= 11 And lastLevel <= 20 Then
							tmpS:+10
						ElseIf lastLevel >= 21 And lastLevel <= 30 Then
							tmpS:+20
						ElseIf lastLevel >= 31 And lastLevel <= 40 Then
							tmpS:+30
						ElseIf lastLevel >= 41 And lastLevel <= 50 Then
							tmpS:+50
						EndIf
												
						p_Score[i]:+tmpS
						If i = PLAYER_1 Then ' // Share gold
							If p_Dead[PLAYER_2] = False Then p_Score[PLAYER_2]:+Int(tmpS / 2)
						ElseIf i = PLAYER_2 Then
							If p_Dead[PLAYER_1] = False Then p_Score[PLAYER_1]:+Int(tmpS / 2)
						EndIf
					
						partList.AddLast part.Create(Int(X) + 8, Int(Y) - 8, PART_POINTS, tmpS, i)

					EndIf
					
					Del = True
					Exit
					
				EndIf
				
				EndIf ' // End dead block
			Next
			EndIf ' // TIMED PICKUP CHECK
			
			If GetMilliSecs() >= T + 8000 Then candyTime = -1; Del = True
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² SPECIAL BUBBLE SPAWNER                           
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //	
		ElseIf ID = OBJ_SPAWN Then
			If nextLevel <> 9 Then
				objC:-1 ' // Decrement obj count
				
				If GetMilliSecs() >= T + 4000 Then
					If specC < 5 Then
						If Kind = TILE_ZAPWATER Then ' // Zap / Water
							Local tmpR:Int = Rand(1, 2)
							If tmpR = 1 Then tmpR = BUB_ZAP ElseIf tmpR = 2 Then tmpR = BUB_WATER
							If bXMode = True Then ' // Random special
								bubList.AddLast bub.Create(Int(X), Int(Y), 0, 0, 1, Rand(100, 102), Hurt)
							Else
								bubList.AddLast bub.Create(Int(X), Int(Y), 0, 0, 1, tmpR, Hurt)	
							EndIf
						Else
							If bXMode = True Then ' // Random special
								bubList.AddLast bub.Create(Int(X), Int(Y), 0, 0, 1, Rand(100, 102), Hurt)	
							Else
								bubList.AddLast bub.Create(Int(X), Int(Y), 0, 0, 1, Kind, Hurt)	
							EndIf
						EndIf
						specC:+1
					EndIf
					If bHasSpawn2 = True Then 
						T = GetMilliSecs() + 4000 ' // Offset spawning if double
					Else
						T = GetMilliSecs()
					EndIf
				EndIf
			Else
				If Hurt = True Then T = GetMilliSecs() + 4000 Else T = GetMilliSecs()
				
			EndIf
			
		EndIf
			
		If Del = True Then objList.Remove o
		
		If createO > 0 Then ' // Create obj
			If createO = 1 Then ' // Fruit
				objList.AddLast obj.Create(createX, createY, OBJ_FRUIT, createID)
			ElseIf createO = 2 Then ' // Item
				objList.AddLast obj.Create(createX, createY, OBJ_ITEM, createID)
			ElseIf createO = 3 Then ' // Candy
				objList.AddLast obj.Create(createX, createY, OBJ_CANDY, 0)				
			ElseIf createO = 4 Then ' // Money bag
				objList.AddLast obj.Create(createX, createY, OBJ_CANDY, 1)
			ElseIf createO = 5 Then ' // Gem (brooch)
				objList.AddLast obj.Create(createX, createY, OBJ_GEM, Rand(0, 2), 1)
			ElseIf createO = 6 Then ' // Boss children
				objList.AddLast obj.Create(createX, createY, OBJ_ZEN, createY, createD, 0, 0, EN_MONSTA, 1)								
			ElseIf createO = 7 Then ' // Delete all enemies
				DeadAllEnemies()			
			EndIf
		EndIf
		
	End Method
	
	Method Render2()
		Local Del:Int = False
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² GHOST
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		If ID = OBJ_GHOST Then 
			SetBlend LIGHTBLEND; SetAlpha 1; SetScale sclX, sclY
			DrawImage imgGhost, Int(X), Int(Y), F
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
					
			If D = -1 Then ' // Spawning
				If GetMilliSecs() >= T + 130 Then
					If F < 1 Then 
						F:+1 
					Else
						' // Seek
						If b2Player = False Then
							Target = 0
						Else
							If p_Dead[0] <> False Then
								Target = 1
							ElseIf p_Dead[1] <> False Then
								Target = 0
							Else
								Local tmpDist1:Int = 9999, tmpDist2:Int = 9999 ' // Figure out who's closer
								If p_X[0] > X Then tmpDist1:+(p_X[0] - X) Else tmpDist1:+(X - p_X[0])
								If p_Y[0] > Y Then tmpDist1:+(p_Y[0] - Y) Else tmpDist1:+(Y - p_Y[0])
									
								If p_X[1] > X Then tmpDist2:+(p_X[1] - X) Else tmpDist2:+(X - p_X[1])
								If p_Y[1] > Y Then tmpDist2:+(p_Y[1] - Y) Else tmpDist2:+(Y - p_Y[1])
																
								If tmpDist1 < tmpDist2 Then Target = 0 Else Target = 1							
							EndIf
						EndIf

						If p_X[Target] > X Then D = 1; F = 2; XI = 2 Else D = 0; F = 4; XI = -2
						If p_Y[Target] > Y + 2 Then 
							YI = 2
						ElseIf p_Y[Target] < Y - 2 Then
							YI = -2
						EndIf
					
						bDelay = True
						DelayT = GetMilliSecs()
						
					EndIf
					T = GetMilliSecs() 
				EndIf
			
			ElseIf D >= 0 And D <= 3 Then  ' // Seeking
				If GetMilliSecs() >= T + 130 Then
					If D = 0 Then
						If F < 5 Then F:+1 Else F = 4
					Else
						If F < 3 Then F:+1 Else F = 2
					EndIf
					T = GetMilliSecs()
				EndIf
				
				Local bSeek:Int = False
				If bDelay = True Then ' // Pause
					If GetMilliSecs() >= delayT + 800 Then bDelay = False; delayT = GetMilliSecs()
				Else
					If p_X[Target] > X + 2 Then 
						If D = 0 Then F = 2
						D = 1 
						If XI < 2 Then XI:+.06
					ElseIf p_X[Target] < X - 2 Then
						If D = 1 Then F = 4
						D = 0
						If XI > -2 Then XI:-.06
					EndIf

					X:+XI
					
					If p_Y[Target] > Y + 2 Then 
						If YI < 2 Then YI:+.045
					ElseIf p_Y[Target] < Y - 2 Then
						If YI > -2 Then YI:-.045
					EndIf
					
					Y:+YI
					
					If Int(Y) > 448 Then 
						Y = -32 ' // Screen wrap
					ElseIf Int(Y) < -32 Then 
						Y = 448 ' // Screen wrap
					EndIf
					
					Rem
					If D = 0 Then ' // Left
						If X - 2 > (OX - 115) Then X:-2 Else bSeek = True
					ElseIf D = 1 Then ' // Right
						If X + 2 < (OX + 115) Then X:+2 Else bSeek = True
					ElseIf D = 3 Then ' // Down
						If Y + 2 < (OY + 92) Then Y:+2 Else bSeek = True
					ElseIf D = 2 Then ' // Up
						If Y - 2 > (OY - 92) Then Y:-2 Else bSeek = True			
					EndIf
					EndRem
					
					'If GetMilliSecs() >= delayT + 800 Then ' // Seek
					'	bDelay = True; DelayT = GetMilliSecs()

						' // Seek
						If b2Player = False Then
							Target = 0
						Else
							If p_Dead[0] <> False Then
								Target = 1
							ElseIf p_Dead[1] <> False Then
								Target = 0
							Else
								Local tmpDist1:Int = 9999, tmpDist2:Int = 9999 ' // Figure out who's closer
								If p_X[0] > X Then tmpDist1:+(p_X[0] - X) Else tmpDist1:+(X - p_X[0])
								If p_Y[0] > Y Then tmpDist1:+(p_Y[0] - Y) Else tmpDist1:+(Y - p_Y[0])
									
								If p_X[1] > X Then tmpDist2:+(p_X[1] - X) Else tmpDist2:+(X - p_X[1])
								If p_Y[1] > Y Then tmpDist2:+(p_Y[1] - Y) Else tmpDist2:+(Y - p_Y[1])
																
								If tmpDist1 < tmpDist2 Then Target = 0 Else Target = 1							
							EndIf
						EndIf
												
					'EndIf
				EndIf
				
				Rem
				If bSeek = True Then ' // Seek					
					Local tmpR:Int = Rand(1, 3)
					If tmpR <> 2 Then ' // X Seek
						If p_X[Target] > X Then D = 1; F = 2 Else D = 0; F = 4
						OX = Int(X)						
					ElseIf tmpR = 2 Then ' // Y Seek
						If p_Y[Target] > Y Then D = 3 Else D = 2
						F = 2
						OY = Int(Y)
					EndIf
					bDelay = True
					DelayT = GetMilliSecs()
					
				EndIf				
				EndRem

				For Local i:Int = 0 To b2Player
					If p_Dead[i] = False And p_Hurt[i] = False Then ' // Dead block
					
					If ImagesCollide(imgGhost, Int(X), Int(Y), F, GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i]) = True Then

						If p_Life[i] - .5 > 0 Then ' // Hurt
							If p_Life[i] = 1.5 Then PlaySFX sfxWarn
							PlaySFX sfxHurt
							
							p_Hurt[i] = True
							p_HurtT[i] = GetMilliSecs()
							p_Life[i]:-.5
							
						Else ' // Dead
							If p_Dead[i] = False Then
								PlaySFX sfxDeath
								p_Life[i] = 0
								p_T[i] = GetMilliSecs()
								p_Dead[i] = True

								For Local i2:Int = 0 To 5 ' // Clear items
									p_Items[i, i2] = -1
								Next
								
								p_MP[i] = 0 ' // Clear magic
																						
								If p_D[i] = 1 Then p_F[i] = 9 ElseIf p_D[i] = 0 Then p_F[i] = 25
							EndIf
							
						EndIf
						
					EndIf
					
					EndIf ' // End dead block
				Next
				
				If enemyC = 0 Then ' // Check clear
					' // Check captured bubbles
					Local tmpCheck:Int = True
					For b:Bub = EachIn bubList
						If b.ID = 1 And b.Cap = True Then tmpCheck = False; Exit
					Next
					
					If tmpCheck = True Then 
						D = 5; F = 1; T = GetMilliSecs()
						For p:Part = EachIn partList
							If p.ID = PART_GHOST Then partList.Remove p
						Next
					EndIf
				EndIf

				If GetMilliSecs() >= JT + 130 And D <> 5 Then
					Local p:Part = New Part
					p.ID = PART_GHOST; p.X = X; p.Y = Y; p.Alp = .3
					p.F = F; p.D = 1
					partList.AddLast p					
					JT = GetMilliSecs()
				EndIf
											
			ElseIf D = 5 Then ' // Disappear
				
				If GetMilliSecs() >= T + 130 Then
					If F > 0 Then F:-1 Else Del = True
					T = GetMilliSecs()
				EndIf
				
			EndIf
		EndIf

		If Del = True Then objList.Remove o
						
	End Method
			
End Type

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SHOTS                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Shot   
    Field X:Float, Y:Float, ID:Int, T:Int
	Field D:Int, F:Int, Player:Int, XI:Float, OD:Int, Turn:Int, YD:Int
	Field ST:Int, Dmg:Float, Hurt:Int, Fall:Int, Lvl:Int, A:Int, R:Float, Rot:Int
	
    Function Create:Shot(X:Float, Y:Float, ID:Int, arg1:Int, arg2:Int = 0, arg3:Int = 0)
		s:Shot = New Shot
		s.X = X; s.Y = Y; s.ID = ID
		s.T = GetMilliSecs()
		
		If ID = SHOT_FIREBALL Then
			s.D = arg1
			s.Player = arg2 ' // Player
			s.Lvl = arg3

			If p_Class[s.Player] = CLASS_BUBBLE Then
				If s.D = 0 Then 
					If s.Lvl = 2 Then s.F = 3 Else s.F = 4
				EndIf
			ElseIf p_Class[s.Player] = CLASS_EMBER Then
				If s.D = 0 Then 
					If s.Lvl = 3 Then s.F = 4 Else s.F = 2
				EndIf
			ElseIf p_Class[s.Player] = CLASS_SHOCK Then
				If s.D = 0 Then 
					If s.Lvl = 2 Then s.F = 3 ElseIf s.Lvl = 1 Then s.F = 6 ElseIf s.Lvl = 3 Then s.F = 4
				EndIf
			EndIf
			
			If arg3 = 999 Then ' // Buster
				If s.D = 0 Then s.F = 4
			EndIf
						
		'ElseIf ID = SHOT_WAVE Then
		'	s.D = arg1
		'	s.Player = arg2 ' // Player
		'	s.OD = s.D
		'	
		'	If s.D = 1 Then
		'		s.XI = 6
		'	ElseIf s.D = 0 Then
		'		s.XI = -6
		'	EndIf
		
		ElseIf ID = SHOT_SPOUT Then
			s.OD = arg1 ' // Frames
			s.Player = arg2 ' // Player
			s.ST = arg3
		
		ElseIf ID = SHOT_BLAST Or ID = SHOT_BLAST3 Or ID = SHOT_BLAST4 Or ID = SHOT_BLAST5 Then
			s.D = arg1
			If s.D = 0 Then s.F = 4
			s.Dmg = .5
		
		ElseIf ID = SHOT_BOMB Then
			s.Player = arg1
			s.Fall = True

		ElseIf ID = SHOT_BLAST2 Then
			s.D = arg1
			If s.D = 0 Then s.F = 4
			s.Dmg = .5
			s.Turn = arg2 ' // Angle
			
		ElseIf ID = SHOT_SWOOSH Then
			s.D = arg1
			If s.D = 0 Then s.F = 8
			s.Player = arg2
			s.Lvl = arg3
		
		ElseIf ID = SHOT_COMET Then
			s.D = arg1
			s.Player = arg2
		
		ElseIf ID = SHOT_CROSS Then
			s.A = Rand(0, 359)
			s.R = 36
			s.Player = arg2
		
		ElseIf ID = SHOT_BOTTLE Then
			If arg1 = 1 Or arg1 = 2 Then
				s.A = -50 + (arg2 * 20)				
				s.D = 1
			Else
				s.A = -230 + (arg2 * 20)
				s.D = 0			
			EndIf
			s.R = 0
			s.F = 0
			s.Dmg = .5
			
		EndIf
		
		Return s
		
	End Function

	Method Render()
		Local Del:Int = False
		Local cX:Int = 0, cY:Int = 0
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² FIREBALL                                
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		If ID = SHOT_FIREBALL Then 
			SetBlend LIGHTBLEND; SetAlpha .9; SetScale sclX, sclY
			Local tmpImg:TImage
			
			If Lvl = 999 Then ' // Buster
				DrawImage imgBuster, Int(X), Int(Y), F
				tmpImg = imgBuster
			Else
				If p_Class[Player] = CLASS_EMBER Then
					If Lvl = 1 Then
						DrawImage imgFireball, Int(X), Int(Y), F
						tmpImg = imgFireball
					ElseIf Lvl = 2 Then
						DrawImage imgFireball2, Int(X), Int(Y), F
						tmpImg = imgFireball2
					ElseIf Lvl = 3 Then
						SetScale sclX + .4, sclY + .4
						DrawImage imgFireball3, Int(X), Int(Y), F
						SetScale sclX, sclY
						tmpImg = imgFireball3					
					EndIf
					
				ElseIf p_Class[Player] = CLASS_BUBBLE Then
					If Lvl = 1 Then
						DrawImage imgSplash, Int(X), Int(Y), F
						tmpImg = imgSplash
					ElseIf Lvl = 2 Then
						DrawImage imgSplash2, Int(X), Int(Y), F
						tmpImg = imgSplash2
					ElseIf Lvl = 3 Then
						DrawImage imgSplash3, Int(X), Int(Y), F
						tmpImg = imgSplash3						
					EndIf
					
				ElseIf p_Class[Player] = CLASS_SHOCK Then
					If Lvl = 1 Then
						DrawImage imgVolt, Int(X), Int(Y), F
						tmpImg = imgVolt
					ElseIf Lvl = 2 Then
						DrawImage imgVolt2, Int(X), Int(Y), F
						tmpImg = imgVolt2
					ElseIf Lvl = 3 Then
						DrawImage imgVolt3, Int(X), Int(Y), F
						tmpImg = imgVolt3					
					EndIf
				EndIf			
			EndIf			
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			If GetMilliSecs() >= T + 80 Then
				If Lvl = 999 Then ' // Buster
					If D = 1 Then
						If F < 3 Then F:+1 Else F = 0
					Else
						If F < 7 Then F:+1 Else F = 4
					EndIf					
				Else
					If p_Class[Player] = CLASS_BUBBLE Then
						If D = 1 Then
							If Lvl <> 2 Then
								If F < 3 Then F:+1 Else F = 0
							Else
								If F < 2 Then F:+1 Else F = 0
							EndIf
						Else
							If Lvl <> 2 Then
								If F < 7 Then F:+1 Else F = 4
							Else
								If F < 5 Then F:+1 Else F = 3
							EndIf
						EndIf
					ElseIf p_Class[Player] = CLASS_EMBER Then
						If D = 1 Then
							If Lvl <> 3 Then
								If F < 1 Then F:+1 Else F = 0
							Else
								If F < 3 Then F:+1 Else F = 0
							EndIf
						Else
							If Lvl <> 3 Then
								If F < 3 Then F:+1 Else F = 2
							Else
								If F < 7 Then F:+1 Else F = 4
							EndIf
						EndIf
					ElseIf p_Class[Player] = CLASS_SHOCK Then
						If Lvl = 1 Then
							If D = 1 Then
								If F < 5 Then F:+1 Else F = 0
							Else
								If F < 11 Then F:+1 Else F = 6
							EndIf
						ElseIf Lvl = 2 Then
							If D = 1 Then
								If F < 2 Then F:+1 Else F = 0
							Else
								If F < 5 Then F:+1 Else F = 3
							EndIf
						ElseIf Lvl = 3 Then
							If D = 1 Then
								If F < 3 Then F:+1 Else F = 0
							Else
								If F < 7 Then F:+1 Else F = 4
							EndIf								
						EndIf
					EndIf
				EndIf
				
				T = GetMilliSecs()
			EndIf
					
			If D = 1 Then
				X = X + 5
			Else
				X = X - 5
			EndIf
						
			' // MAGIC TO ENEMY COLLISION
			'DebugLog "Frame: " + F
			HandleMagicCol(SHOT_FIREBALL, Int(X), Int(Y), F, D, Player, True, Lvl) ' // Do enemy collision
						
			If Int(X) >= 37 And (Int(X) + Int((ImageWidth(tmpImg) * sclX))) <= 552 Then
				
				Local tmpI:Int = 0
				If Lvl = 999 Or Lvl = 3 Then tmpI = 1
				For Local i:Int = 0 To tmpI
				Local p:Part = New Part
				p.ID = PART_FADE; p.Alp = 1	
				
				If Lvl = 999 Then ' // Buster
					p.C2 = Rand(2, 3)
					
					cY = Int(Y + Rand(8, 28))
					If D = 1 Then cX = Int(X + 46) ElseIf D = 0 Then cX = Int(X + 16)
				
				Else
					If p_Class[Player] = CLASS_EMBER Then				
						p.C2 = Rand(0, 1)
						If Lvl = 1 Then
							cY = Int(Y + Rand(0, 17))
							If D = 1 Then cX = Int(X + 12) ElseIf D = 0 Then cX = Int(X + 18)
						ElseIf Lvl = 2 Then
							cY = Int(Y + Rand(0, 25))
							If D = 1 Then cX = Int(X + 13) ElseIf D = 0 Then cX = Int(X + 22)
						ElseIf Lvl = 3 Then
							cY = Int(Y + Rand(0, 34))
							If D = 1 Then cX = Int(X + 20) ElseIf D = 0 Then cX = Int(X + 22)							
						EndIf
						
					ElseIf p_Class[Player] = CLASS_BUBBLE Then
						p.C2 = Rand(2, 3)
						If Lvl = 1 Then
							cY = Int(Y + Rand(0, 14))
							If D = 1 Then cX = Int(X + 18) ElseIf D = 0 Then cX = Int(X + 16)
						ElseIf Lvl = 2 Then
							cY = Int(Y + Rand(0, 22))
							If D = 1 Then cX = Int(X + 18) ElseIf D = 0 Then cX = Int(X + 16)
						ElseIf Lvl = 3 Then
							cY = Int(Y + Rand(0, 30))
							If D = 1 Then cX = Int(X + 18) ElseIf D = 0 Then cX = Int(X + 18)						
						EndIf
						
					ElseIf p_Class[Player] = CLASS_SHOCK Then
						p.C2 = Rand(4, 5)
						If Lvl = 1 Then
							cY = Int(Y + Rand(0, 21))
							If D = 1 Then cX = Int(X + 14) ElseIf D = 0 Then cX = Int(X + 14)
						ElseIf Lvl = 2 Then
							cY = Int(Y + Rand(0, 30))
							If D = 1 Then cX = Int(X + 18) ElseIf D = 0 Then cX = Int(X + 18)
						ElseIf Lvl = 3 Then 
							cY = Int(Y + Rand(0, 34))
							If D = 1 Then cX = Int(X + 28) ElseIf D = 0 Then cX = Int(X + 34)
						EndIf
						
					EndIf
				EndIf
				p.X = cX; p.Y = cY
				p.D = Rnd(.025, .075)						
				partList.AddLast p	
				Next
				
				Rem
				If D = 1 Then ' // Left level col
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 35, Int(Y) + 11, 1, 5) Then Del = True
				ElseIf D = 0 Then ' // Right level col
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(X), Int(Y) + 11, 1, 5) Then Del = True
				EndIf
				
				If bDebug = True Then
					SetColor 255, 255, 0
					If D = 1 Then DrawRect Int(X) + 35, Int(Y) + 11, 1, 5 'DrawRect Int(X) + 20, Int(Y) + 3, 4, 4
					If D = 0 Then DrawRect Int(X), Int(Y) + 11, 1, 5 'Int(X) + 8, Int(Y) + 3, 4, 4
					
					SetColor 255, 255, 255
				EndIf	
				EndRem
							
			Else
				Del = True
				
			EndIf		

			If Del = True Then ' // Particles
				PlaySFX sfxHit
				
				Local tmpX:Int = 0, tmpY:Int = 0, tmpC:Int = 0
				If p_Class[Player] = CLASS_EMBER Then				
					tmpC = 4; tmpY = 10
					If D = 1 Then tmpX = 32
				ElseIf p_Class[Player] = CLASS_BUBBLE Then
					tmpC = 8; tmpY = 8
					If D = 1 Then tmpX = 37				
				ElseIf p_Class[Player] = CLASS_SHOCK Then
					tmpC = 9; tmpY = 11
					If D = 1 Then tmpX = 34							
				EndIf
				
				If Lvl = 999 Then
					tmpC = 8; tmpY = 20
					If D = 1 Then tmpX = 40					
				EndIf
				
				If D = 1 Then tmpX = (Int(X) + Int((ImageWidth(tmpImg) * sclX))) ElseIf D = 0 Then tmpX = Int(X)
				If p_Class[Player] = CLASS_EMBER And Lvl = 3 Then 
					tmpY = ImageHeight(tmpImg) * (sclY + .4)
				Else
					tmpY = ImageHeight(tmpImg) * sclY
				EndIf
				tmpY = Int(tmpY / 2)
				
				For Local i:Int = 1 To 15
					partList.AddLast part.Create(Int(tmpX), Int(Y) + tmpY, PART_POP, tmpC)
				Next
			EndIf
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² SPOUT                        
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = SHOT_SPOUT Then 
			SetBlend LIGHTBLEND; SetAlpha .9; SetScale sclX, sclY
			DrawImage imgSpout, Int(X), Int(Y), F + (OD * 6)			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
											
			If GetMilliSecs() >= T + 80 Then
				If D = 0 Then
					If F < 5 Then F:+1 Else D = 1
				ElseIf D = 1 Then
					If F > 0 Then F:-1 Else Del = True
				EndIf
				T = GetMilliSecs()
			EndIf				
				
			' // MAGIC TO ENEMY COLLISION
			If Del = False Then
				HandleMagicCol(SHOT_SPOUT, Int(X), Int(Y), F, 0, Player, False) ' // Do enemy collision
			EndIf
					
	
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² MIGHTA BLAST                                
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = SHOT_BLAST Or ID = SHOT_BLAST2 Or ID = SHOT_BLAST3 Or ID = SHOT_BLAST4 Or ID = SHOT_BLAST5 Then 
			SetBlend LIGHTBLEND; SetAlpha .9; SetScale sclX, sclY
			If ID = SHOT_BLAST Then
				DrawImage imgBlast, Int(X), Int(Y), F
			ElseIf ID = SHOT_BLAST2 Then
				DrawImage imgBlast2, Int(X), Int(Y), F
			ElseIf ID = SHOT_BLAST3 Then
				DrawImage imgBlast3, Int(X), Int(Y), F
			ElseIf ID = SHOT_BLAST4 Then
				DrawImage imgBlast4, Int(X), Int(Y), F
			ElseIf ID = SHOT_BLAST5 Then
				DrawImage imgBlast5, Int(X), Int(Y), F									
			EndIf
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			If GetMilliSecs() >= T + 60 Then
				If F < 8 Then
					If D = 1 Then
						If F < 3 Then F:+1 Else F = 0
					Else
						If F < 7 Then F:+1 Else F = 4
					EndIf
				Else
					If F < 9 Then F:+1 Else Del = True
				EndIf
				T = GetMilliSecs()
			EndIf

			If bDebug = True Then
				SetColor 255, 255, 0
				DrawRect Int(X) + 2, Int(Y) + 2, 14, 14
				SetColor 255, 255, 255
			EndIf
											
			If F < 8 Then ' // Level collision
				If D = 1 Then
					If ID = SHOT_BLAST Then X = X + 2 ElseIf ID = SHOT_BLAST2 Then X = X + 2.5 ElseIf ID = SHOT_BLAST3 Then X = X + 3 ElseIf ID = SHOT_BLAST4 Then X = X + 3.5 ElseIf ID = SHOT_BLAST5 Then X = X + 4
				Else
					If ID = SHOT_BLAST Then X = X - 2 ElseIf ID = SHOT_BLAST2 Then X = X - 2.5 ElseIf ID = SHOT_BLAST3 Then X = X - 3 ElseIf ID = SHOT_BLAST4 Then X = X - 3.5 ElseIf ID = SHOT_BLAST5 Then X = X - 4
				EndIf
				
				If ID = SHOT_BLAST2 Then
					If Turn = 1 Then Y:-1 ElseIf Turn = 2 Then Y:+1
				EndIf
				
				If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 2, Int(Y) + 2, 14, 14) = True Then

					PlaySFX sfxHit
					
					Local tmpX:Int = 0
					For Local i:Int = 1 To 15
						If ID = SHOT_BLAST Then
							partList.AddLast part.Create(Int(X) + 18, Int(Y) + 16, PART_POP, 6)
						ElseIf ID = SHOT_BLAST2 Then
							partList.AddLast part.Create(Int(X) + 18, Int(Y) + 16, PART_POP, 7)
						ElseIf ID = SHOT_BLAST3 Then
							partList.AddLast part.Create(Int(X) + 18, Int(Y) + 16, PART_POP, 10)						
						ElseIf ID = SHOT_BLAST4 Then
							partList.AddLast part.Create(Int(X) + 18, Int(Y) + 16, PART_POP, 11)													
						ElseIf ID = SHOT_BLAST5 Then
							partList.AddLast part.Create(Int(X) + 18, Int(Y) + 16, PART_POP, 12)																				
						EndIf
					Next
									
					F = 8; T = GetMilliSecs()
				EndIf
				
				' // PLAYER COLLISION
				If F < 8 Then
					For Local i:Int = 0 To b2Player
						If p_Hurt[i] = False And p_Dead[i] = False Then
							If ImagesCollide(GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i], imgBlast, Int(X), Int(Y), F) = True Then
								If p_Life[i] - Dmg > 0 Then ' // Hurt
									If p_Life[i] = 1.5 Then PlaySFX sfxWarn
									PlaySFX sfxHurt
									
									p_Hurt[i] = True
									p_HurtT[i] = GetMilliSecs()
									p_Life[i]:-Dmg
									
								Else ' // Dead
									If p_Dead[i] = False Then
										PlaySFX sfxDeath
										p_Life[i] = 0
										p_T[i] = GetMilliSecs()
										p_Dead[i] = True

										For Local i2:Int = 0 To 5 ' // Clear items
											p_Items[i, i2] = -1
										Next
										
										p_MP[i] = 0 ' // Clear magic
																		
										If p_D[i] = 1 Then p_F[i] = 9 ElseIf p_D[i] = 0 Then p_F[i] = 25
									EndIf
									
								EndIf
								
							EndIf
						EndIf
					Next				
				EndIf
				
			EndIf

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² BOMB                              
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = SHOT_BOMB Then 
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			If Hurt = True Then
				If Rand(0, 1) = 1 Then DrawImage imgItems, Int(X), Int(Y), 18
			Else
				DrawImage imgItems, Int(X), Int(Y), 18
			EndIf
			
			Local bEx:Int = False ' // Explode check
			
			If Hurt = False Then
				If GetMilliSecs() >= T + 8000 Then Hurt = True
			Else
				If GetMilliSecs() >= T + 10000 Then bEx = True
			EndIf
			
			If Rand(1, 10) = 5 Then partList.AddLast part.Create(Int(X) + 18, Int(Y), PART_POP, 6)

			Local imgEn:TImage
			
			' // Enemy collision
			For o:Obj = EachIn objList
				If o.ID = OBJ_ZEN And o.Hurt = False And allDrop = True Then

					Local offX:Int = 0, offY:Int = 0
					If o.Kind = EN_BOSS1 Or o.Kind = EN_BOSS2 Then offX = 20; offY = 30

					Local tmpF:Int = 0
					If o.D = 1 Then tmpF = 2
					
					Local imgEn:TImage = GetEnImg(o.Kind)
					
					If ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, imgItems, Int(X), Int(Y), 6) = True Then bEx = True											
				EndIf
			Next
				
			If Fall = True Then ' // Falling
				' // Make sure it's not in the middle of a block
				Local tmpCol:Int = ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 10, Int(Y) + 8, 8, 8)

				If ImageRectCollide(imgLevel, 0, 0, 0, Int(X) + 6, Int(Y) + 29, 8, 1) And Y > 34 And tmpCol = False Then 
					Fall = False
										
					Y = AlignY(Int(Y))
				Else
					Y:+2
					
					If Int(Y) > 448 Then Y = -32 ' // Screen wrap
				EndIf
				
				If bDebug = True Then
					SetColor 255, 255, 0
					DrawRect Int(X) + 6, Int(Y) + 29, 8, 1								
					SetColor 255, 255, 255
				EndIf	
							
			EndIf

			If bEx = True Then ' // Explode
				PlaySFX sfxBomb
				
				For Local i:Int = 1 To 5
					p:Part = New Part
					If i = 5 Then ' // Z pattern
						p.X = Int(X) + 18
						p.Y = Int(Y) + 16
					ElseIf i = 2 Then
						p.X = Int(X) + 18 + 18
						p.Y = Int(Y) + 16 - 16
					ElseIf i = 4 Then
						p.X = Int(X) + 18 + 18
						p.Y = Int(Y) + 16 + 16
					ElseIf i = 3 Then
						p.X = Int(X) + 18 - 18
						p.Y = Int(Y) + 16 + 16
					ElseIf i = 1 Then
						p.X = Int(X) + 18 - 18
						p.Y = Int(Y) + 16 - 16
					EndIf
					p.ID = PART_EXPLODE
					p.F = 1; p.Alp = 1; p.T = GetMilliSecs()
					p.V = i * 100 ' // Time
					p.Player = Player
					partList.AddLast p
					
				Next
						
				Del = True
			EndIf
					
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² MAGIC SWOOSH
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = SHOT_SWOOSH Then 
			Local tmpX:Int, tmpY:Int
			tmpX = 18; tmpY = 16
						
			SetBlend LIGHTBLEND; SetAlpha .75; SetScale sclX, sclY
			If Lvl = 999 Then ' // Buster
				SetScale sclX + .75, sclY + .75
				DrawImage imgSwoosh2, Int(p_X[Player]) + tmpX, Int(p_Y[Player]) + tmpY, F
			Else			
				If Lvl = 1 Then 
					SetScale sclX + .25, sclY + .25
				ElseIf Lvl = 2 Then
					SetScale sclX + .5, sclY + .5
				ElseIf Lvl = 3 Then
					SetScale sclX + .75, sclY + .75					
				EndIf
					
				If p_Class[PLAYER] = CLASS_EMBER Then
					DrawImage imgSwoosh, Int(p_X[Player]) + tmpX, Int(p_Y[Player]) + tmpY, F
					
				ElseIf p_Class[PLAYER] = CLASS_BUBBLE Then
					DrawImage imgSwoosh2, Int(p_X[Player]) + tmpX, Int(p_Y[Player]) + tmpY, F
					
				ElseIf p_Class[PLAYER] = CLASS_SHOCK Then
					DrawImage imgSwoosh3, Int(p_X[Player]) + tmpX, Int(p_Y[Player]) + tmpY, F
					
				EndIf
			EndIf
			
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY

			' // MAGIC TO ENEMY COLLISION
			HandleMagicCol(SHOT_SWOOSH, Int(p_X[Player]) + tmpX, Int(p_Y[Player]) + tmpY, F, D, Player, True, Lvl) ' // Do enemy collision

			If GetMilliSecs() >= T + 30 Then
				If D = 1 Then
					If F < 7 Then F:+1 Else Del = True
				ElseIf D = 0 Then
					If F < 15 Then F:+1 Else Del = True
				EndIf
				
				T = GetMilliSecs()
			EndIf
			
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² COMET                              
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = SHOT_COMET Then 
			SetScale sclX, sclY; SetBlend LIGHTBLEND; SetAlpha .95; SetColor 255, 255, 255

			DrawImage imgComet, X, Y, F + (D * 2)

			SetBlend ALPHABLEND; SetAlpha 1

			If GetMilliSecs() >= T + 80 Then				
				If F < 1 Then F:+1 Else F = 0
				
				T = GetMilliSecs()
			EndIf

			For Local i:Int = 0 To 2
			Local p:Part = New Part
			p.ID = PART_FADE; p.Alp = 1	
			If D = 0 Then
				p.C2 = Rand(6, 7)
			ElseIf D = 1 Then
				p.C2 = Rand(8, 9)
			ElseIf D = 2 Then
				p.C2 = Rand(10, 11)
			EndIf
			
			p.X = Int(X) + Rand(14, 27); p.Y = Int(Y) + 20
			p.D = Rnd(.025, .075)						
			partList.AddLast p	
			Next
							
			If Y < 448 Then Y:+3 Else Del = True
			If X < 588 Then X:+3 Else Del = True		
			
			If Del = False Then ' // Col
				' // MAGIC TO ENEMY COLLISION
				HandleMagicCol(SHOT_COMET, Int(X), Int(Y), F, 0, Player, False) ' // Do enemy collision
			EndIf

		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² CROSS                             
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = SHOT_CROSS Then 
			SetScale sclX, sclY; SetBlend LIGHTBLEND; SetAlpha .8; SetColor 255, 255, 255
			Local tmpX:Int = Int(p_X[Player] + 18), tmpY:Int = Int(p_Y[Player] + 16 + p_YI[Player])
			DrawImage imgCross, Int(R * Cos(A) + tmpX), Int(R * Sin(A) + tmpY), Player
			DrawImage imgCross, Int(R * Cos(A) + tmpX), Int(R * Sin(A) + tmpY), Player

			SetBlend ALPHABLEND; SetAlpha 1

			If A + 12 < 359 Then A:+12 Else A:-359
			
			'If GetMilliSecs() >= T + 20 Then
			For Local i:Int = 1 To 3
				Local p:Part = New Part
				p.ID = PART_FADE; p.Alp = 1	
				If Player = 1 Then
					p.C2 = Rand(12, 13)
				ElseIf Player = 0 Then
					p.C2 = Rand(14, 15)
				EndIf
				
				p.X = Int(R * Cos(A) + tmpX) + Rand(-6, 6); p.Y = Int(R * Sin(A) + tmpY) + Rand(-4, 4)
				p.D = Rnd(.025, .075)						
				partList.AddLast p	
			
				' // MAGIC TO ENEMY COLLISION
				HandleMagicCol(SHOT_CROSS, Int(R * Cos(A) + tmpX), Int(R * Sin(A) + tmpY), F, 0, Player, False) ' // Do enemy collision
			Next
			
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² FIREWORKS                            
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		ElseIf ID = SHOT_FIREWORK Then 
			SetScale sclX, sclY; SetBlend LIGHTBLEND; SetAlpha .9; SetColor 255, 255, 255
			DrawImage imgFirework, Int(X), Int(Y), F + (D * 5)
			DrawImage imgFirework, Int(X), Int(Y), F + (D * 5)
						
			SetBlend ALPHABLEND; SetAlpha 1

			If GetMilliSecs() >= T + 80 Then
				If F < 4 Then F:+1 Else Del = True
				T = GetMilliSecs()
			EndIf
			
			' // MAGIC To ENEMY COLLISION
			HandleMagicCol(SHOT_FIREWORK, Int(X), Int(Y), F, 0, Player, False) ' // Do enemy collision
		
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
		' // ² DRUNK BOTTLE                          
		' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //	
		ElseIf ID = SHOT_BOTTLE Then
			SetScale sclX, sclY; SetBlend ALPHABLEND; SetAlpha 1; SetColor 255, 255, 255	
								
			DrawImage imgBottle, Int((R * Cos(A)) + X), Int((R * Sin(A)) + Y), F
			
			' // Player collision
			For Local i:Int = 0 To b2Player
				If p_Hurt[i] = False And p_Dead[i] = False Then
					If ImagesCollide(GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i], imgBottle, Int((R * Cos(A)) + X), Int((R * Sin(A)) + Y), F) = True Then
						If p_Life[i] - Dmg > 0 Then ' // Hurt
							If p_Life[i] = 1.5 Then PlaySFX sfxWarn
							PlaySFX sfxHurt
							
							p_Hurt[i] = True
							p_HurtT[i] = GetMilliSecs()
							p_Life[i]:-Dmg
							
						Else ' // Dead
							If p_Dead[i] = False Then
								PlaySFX sfxDeath
								p_Life[i] = 0
								p_T[i] = GetMilliSecs()
								p_Dead[i] = True

								For Local i2:Int = 0 To 5 ' // Clear items
									p_Items[i, i2] = -1
								Next
								
								p_MP[i] = 0 ' // Clear magic
																
								If p_D[i] = 1 Then p_F[i] = 9 ElseIf p_D[i] = 0 Then p_F[i] = 25
							EndIf
							
						EndIf
						
					EndIf
				EndIf
			Next	
					
			R:+5
			
			If GetMilliSecs() >= T + 80 Then
				If D = 0 Then
					If F < 3 Then F:+1 Else F = 0
				ElseIf D = 1 Then
					If F > 0 Then F:-1 Else F = 3
				EndIf
				T = GetMilliSecs()
			EndIf
			
			If Int((R * Cos(A)) + X) < 37 Or Int((R * Cos(A)) + X) > 552 Then Del = True
			If Int((R * Sin(A)) + Y) < 47 Or Int((R * Sin(A)) + Y) > 416 Then Del = True
			
		EndIf
		
		If Del = True Then shotList.Remove s

	End Method
	
End Type

'If bTitle = False Then NewGame False

SetBlend ALPHABLEND
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² MAIN
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
#MAIN
DefData "MAIN"

LoadImages(cfgFilter) ' // Load all images

Global bTitleDrop:Int = True ' // First time logo drop

bTitle = True

If bTitle = False Then
	b2Player = False

	p_Class[0] = CLASS_BUBBLE
	p_Class[1] = CLASS_EMBER

	NewGame()
	keyT = GetMilliSecs(); keyTime = Rand(5000, 15000)
	candyT = GetMilliSecs(); candyTime = Rand(5000, 15000)
	ghostT = GetMilliSecs(); ghostC = 0
	
EndIf

FlushInput
Repeat
	Cls
	frameTimer = GetMilliSecs()	
	
	SetScale sclX, sclY; SetColor 255, 255, 255; SetBlend ALPHABLEND; SetAlpha 1
	If bWindowed = False Then SetOrigin 26, 16 Else SetOrigin 0, 0 ' // Fullscreen

	If bTitle = True Then ' // TITLE SCREEN
		DrawTitle()
		
	Else ' // GAME
		DrawLevel()
			
		enemyC = 0; objC = 0 ' // Enemy count
		For o:Obj = EachIn objList ' // Render objects
			o.Render
			If o.ID = OBJ_ZEN Then enemyC:+1
			objC:+1
		Next 
				
		CheckDrop() ' // Check enemy drop status
	
		If (curLevel > 100 And curLevel < 200) And nextLevel <> 9 Then DrawKeeper() ' // Draw shopkeeper
		
		For p:Part = EachIn partList ' // Render back particles
			If p.ID = PART_WATER Then p.Render
		Next 

		If nextLevel <> 9 Then ' // Playing
			DrawPlayers() ' // Render players
		Else ' // Floating
			DrawFloat() ' // Bubble floating to next level
		EndIf
	
		' // Render second set objects (ghost)
		For o:Obj = EachIn objList; o.Render2; Next 

		DrawBubbles() ' // Render bubbles
			
		For s:Shot = EachIn shotList; s.Render; Next ' // Render shots
		p_Flame[0] = False; p_Flame[1] = False ' // Flamed
		For p:Part = EachIn partList ' // Render front particles
			If p.ID <> PART_WATER Then p.Render
		Next 

		HandleTimers()  ' // Level based timers

		HandleMChain()  ' // Magic chain
		HandleActives() ' // Active items
				
		If nextLevel < 8 Then DrawHUD() ' // Render HUD
	
		HandleNext() ' // Next level checks
		
		' // INPUT BLOCK
		If nextLevel < 2 Then GetUserInput()	' // Player input		
	
		If nextLevel <> 9 Then PlayerCol() ' // Player collision
	
		HandleDeath()
		
		If bJBMode = True Then ' // JB MODE
			For Local i:Int = 0 To b2Player
				p_Life[i] = p_LifeT[i]
			Next
		EndIf
		
	EndIf ' // GAME BLOCK
	
	GetFuncInput() ' // Function Keys
	
	DrawOverlay() ' // Overlay graphics
	
	If GetMilliSecs() >= fpsTimer + 1000 Then FPS = curFrames; curFrames = 0; fpsTimer = GetMilliSecs()
	curFrames = curFrames + 1
	
	Flip -1 
	HandlePause() ' // Pause game
	
Until KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True
EndGame

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADIMAGES - Load images with desired filter
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadImages(bFil:Int, bReload:Int = False)

	Local imgFlags:Int
	If bFil = True Then imgFlags = MASKEDIMAGE|FILTEREDIMAGE Else imgFlags = MASKEDIMAGE
	
	GCRelease imgCRT
	GCRelease imgFont
	GCRelease imgFont2
	GCRelease imgBub
	GCRelease imgEmber
	GCRelease imgShock
	GCRelease imgMP
	GCRelease imgHeart
	GCRelease imgBubble
	GCRelease imgZen
	GCRelease imgZen2	
	GCRelease imgZen3
	GCRelease imgZen4	
	GCRelease imgZen5	
	GCRelease imgCap
	GCRelease imgTrap
	GCRelease imgFruit
	GCRelease imgGem
	GCRelease imgPoints
	GCRelease imgBlip
	GCRelease imgCol
	GCRelease imgMenu
	GCRelease imgStats
	GCRelease imgStars
	GCRelease imgC1
	GCRelease imgC2
	GCRelease imgFireball
	GCRelease imgFireball2	
	GCRelease imgFireball3	
	GCRelease imgVolt
	GCRelease imgVolt2
	GCRelease imgVolt3	
	GCRelease imgSplash
	GCRelease imgSplash2
	GCRelease imgSplash3	
	GCRelease imgFlare
	GCRelease imgMenu2
	GCRelease imgUp
	GCRelease imgFloat
	GCRelease imgTreasure
	GCRelease imgItems
	GCRelease imgBlank
	GCRelease imgTiles
	GCRelease imgLevel
	GCRelease imgMighta
	GCRelease imgMighta2
	GCRelease imgMighta3
	GCRelease imgMighta4	
	GCRelease imgBlast
	GCRelease imgBlast2
	GCRelease imgBlast3
	GCRelease imgBlast4
	GCRelease imgBlast5		
	GCRelease imgShop
	GCRelease imgDoor
	GCRelease imgExplode
	GCRelease imgCandy
	GCRelease imgHurry
	GCRelease imgGhost
	GCRelease imgTitle
	GCRelease imgBoss1
	GCRelease imgBoss2	
	GCRelease imgScore
	GCRelease imgBossBub
	GCRelease imgBossCap
	GCRelease imgMonsta
	GCRelease imgMonsta2
	GCRelease imgMonsta3	
	GCRelease imgNext
	GCRelease imgSwoosh
	GCRelease imgSwoosh2
	GCRelease imgSwoosh3
	GCRelease imgBag
	GCRelease imgWater
	GCRelease imgZap
	GCRelease imgSLvl
	GCRelease imgComet
	GCRelease imgSpout
	GCRelease imgCross
	GCRelease imgFirework
	GCRelease imgPulpul
	GCRelease imgPulpul2	
	GCRelease imgFire
	GCRelease imgFlame
	GCRelease imgGrave
	GCRelease imgBig
	GCRelease imgFlame2
	GCRelease imgBane
	GCRelease imgBuster
	GCRelease imgGonsu
	GCRelease imgDrunk
	GCRelease imgBottle
	GCRelease imgBossBub2
	GCRelease imgTut1
	GCRelease imgTut2
	GCRelease imgTut3	
	GCRelease imgDrunk2
	GCRelease imgEnd
	GCRelease imgTBub
	GCRelease imgChars
	GCRelease imgCSel
	GCRelease imgStart
	
	GCCollect
	
	SetMaskColor 255, 0, 255
	
	imgCRT = LoadImage("gfx/crt5.png", MASKEDIMAGE)
	imgFont = LoadAnimImage("gfx/font.png", 8, 8, 0, 64, imgFlags)
	imgFont2 = LoadAnimImage("gfx/font2.png", 8, 8, 0, 64, imgFlags)
	imgBub = LoadAnimImage("gfx/bub.png", 16, 16, 0, 32, imgFlags)
	imgEmber = LoadAnimImage("gfx/ember.png", 16, 16, 0, 32, imgFlags)
	imgShock = LoadAnimImage("gfx/shock.png", 16, 16, 0, 32, imgFlags)
	imgMP = LoadAnimImage("gfx/mp.png", 1, 6, 0, 6, imgFlags)
	imgHeart = LoadAnimImage("gfx/heart.png", 7, 8, 0, 9, imgFlags)
	imgBubble = LoadAnimImage("gfx/bubbles.png", 16, 16, 0, 24, imgFlags)
	imgZen = LoadAnimImage("gfx/zen.png", 16, 16, 0, 16, imgFlags)
	imgZen2 = LoadAnimImage("gfx/zen2.png", 16, 16, 0, 16, imgFlags)
	imgZen3 = LoadAnimImage("gfx/zen3.png", 16, 16, 0, 16, imgFlags)
	imgZen4 = LoadAnimImage("gfx/zen4.png", 16, 16, 0, 16, imgFlags)
	imgZen5 = LoadAnimImage("gfx/zen5.png", 16, 16, 0, 16, imgFlags)
	imgCap = LoadAnimImage("gfx/cap.png", 16, 16, 0, 5, imgFlags)
	imgTrap = LoadAnimImage("gfx/trap.png", 16, 16, 0, 12, imgFlags)
	imgFruit = LoadAnimImage("gfx/fruit.png", 16, 16, 0, 20, imgFlags)
	imgGem = LoadAnimImage("gfx/gem.png", 16, 16, 0, 6, imgFlags)
	imgPoints = LoadAnimImage("gfx/points.png", 4, 8, 0, 10, imgFlags)
	imgBlip = LoadAnimImage("gfx/blip.png", 16, 16, 0, 2, imgFlags)
	imgCol = LoadAnimImage("gfx/col.png", 16, 16, 0, 2, MASKEDIMAGE)
	imgMenu = LoadImage("gfx/menu.png", imgFlags)
	imgStats = LoadAnimImage("gfx/stats.png", 16, 16, 0, 11, imgFlags)
	imgStars = LoadAnimImage("gfx/stars.png", 16, 16, 0, 4, imgFlags)
	imgC1 = LoadAnimImage("gfx/C1.png", 16, 16, 0, 32, imgFlags)
	imgC2 = LoadAnimImage("gfx/C2.png", 16, 16, 0, 32, imgFlags)
	imgFireball = LoadAnimImage("gfx/fireball.png", 14, 10, 0, 4, imgFlags)
	imgFireball2 = LoadAnimImage("gfx/fireball2.png", 17, 14, 0, 4, imgFlags)
	imgFireball3 = LoadAnimImage("gfx/fireball3.png", 17, 15, 0, 8, imgFlags)
	imgVolt = LoadAnimImage("gfx/volt.png", 12, 12, 0, 12, imgFlags)
	imgVolt2 = LoadAnimImage("gfx/volt2.png", 16, 16, 0, 6, imgFlags)
	imgVolt3 = LoadAnimImage("gfx/volt3.png", 27, 18, 0, 8, imgFlags)
	imgSplash = LoadAnimImage("gfx/splash.png", 16, 8, 0, 8, imgFlags)
	imgSplash2 = LoadAnimImage("gfx/splash2.png", 18, 12, 0, 6, imgFlags)
	imgSplash3 = LoadAnimImage("gfx/splash3.png", 16, 16, 0, 8, imgFlags)	
	imgMenu2 = LoadImage("gfx/menu2.png", imgFlags)
	imgUp = LoadImage("gfx/up.png", imgFlags)
	imgSel = LoadAnimImage("gfx/sel.png", 47, 59, 0, 2, imgFlags)
	imgFloat = LoadAnimImage("gfx/float.png", 28, 32, 0, 6, imgFlags)
	imgTreasure = LoadAnimImage("gfx/treasure.png", 16, 16, 0, 2, imgFlags)
	imgItems = LoadAnimImage("gfx/items.png", 16, 16, 0, MAX_ITEMS + 4, imgFlags)
	imgBlank = LoadAnimImage("gfx/blank.png", 8, 8, 0, 3, imgFlags)
	imgTiles = LoadAnimImage("gfx/tiles.png", 8, 8, 0, MAX_TILES + 1, imgFlags)
	imgMighta = LoadAnimImage("gfx/mighta.png", 16, 16, 0, 16, imgFlags)
	imgMighta2 = LoadAnimImage("gfx/mighta2.png", 16, 16, 0, 16, imgFlags)
	imgMighta3 = LoadAnimImage("gfx/mighta3.png", 16, 16, 0, 16, imgFlags)
	imgMighta4 = LoadAnimImage("gfx/mighta4.png", 16, 16, 0, 16, imgFlags)
	imgBlast = LoadAnimImage("gfx/blast.png", 16, 16, 0, 10, imgFlags)
	imgBlast2 = LoadAnimImage("gfx/blast2.png", 16, 16, 0, 10, imgFlags)
	imgBlast3 = LoadAnimImage("gfx/blast3.png", 16, 16, 0, 10, imgFlags)
	imgBlast4 = LoadAnimImage("gfx/blast4.png", 16, 16, 0, 10, imgFlags)
	imgBlast5 = LoadAnimImage("gfx/blast5.png", 16, 16, 0, 10, imgFlags)
	imgShop = LoadAnimImage("gfx/shop.png", 8, 8, 0, 4, imgFlags)
	imgDoor = LoadAnimImage("gfx/door.png", 16, 32, 0, 2, imgFlags)
	imgExplode = LoadAnimImage("gfx/ex1.png", 24, 24, 0, 6, imgFlags)
	imgCandy = LoadAnimImage("gfx/candy.png", 16, 16, 0, 16, imgFlags)
	imgHurry = LoadImage("gfx/hurry.png", imgFlags)
	imgGhost = LoadAnimImage("gfx/ghost.png", 16, 16, 0, 6, imgFlags)
	imgFlare = LoadImage("gfx/flare2.png", imgFlags)
	imgTitle = LoadImage("gfx/title.png", imgFlags)
	imgBoss1 = LoadAnimImage("gfx/boss1.png", 32, 32, 0, 16, imgFlags)
	imgBoss2 = LoadAnimImage("gfx/boss2.png", 32, 32, 0, 16, imgFlags)
	imgScore = LoadAnimImage("gfx/score.png", 32, 16, 0, 14, imgFlags)
	imgBossBub = LoadImage("gfx/bossbub.png", imgFlags)
	imgBossCap = LoadAnimImage("gfx/bosscap.png", 32, 32, 0, 4, imgFlags)
	imgMonsta = LoadAnimImage("gfx/monsta.png", 16, 16, 0, 16, imgFlags)
	imgMonsta2 = LoadAnimImage("gfx/monsta2.png", 16, 16, 0, 16, imgFlags)
	imgMonsta3 = LoadAnimImage("gfx/monsta3.png", 16, 16, 0, 16, imgFlags)
	imgSwoosh = LoadAnimImage("gfx/swoosh.png", 32, 32, 0, 16, imgFlags)
	imgSwoosh2 = LoadAnimImage("gfx/swoosh2.png", 32, 32, 0, 16, imgFlags)
	imgSwoosh3 = LoadAnimImage("gfx/swoosh3.png", 32, 32, 0, 16, imgFlags)
	imgBag = LoadAnimImage("gfx/bag.png", 16, 16, 0, 4, imgFlags)
	imgWater = LoadAnimImage("gfx/water.png", 16, 16, 0, 2, imgFlags)
	imgZap = LoadAnimImage("gfx/zap.png", 16, 16, 0, 2, imgFlags)
	imgSLvl = LoadAnimImage("gfx/slvl.png", 7, 4, 0, 2, imgFlags)
	imgComet = LoadAnimImage("gfx/comet.png", 16, 16, 0, 6, imgFlags)
	imgSpout = LoadAnimImage("gfx/spout.png", 16, 32, 0, 18, imgFlags)
	imgCross = LoadAnimImage("gfx/cross.png", 16, 16, 0, 2, imgFlags)
	imgFirework = LoadAnimImage("gfx/fireworks.png", 32, 32, 0, 15, imgFlags)
	imgPulpul = LoadAnimImage("gfx/pulpul.png", 16, 16, 0, 16, imgFlags)
	imgPulpul2 = LoadAnimImage("gfx/pulpul2.png", 16, 16, 0, 16, imgFlags)
	imgFire = LoadImage("gfx/fire.png", imgFlags)
	imgFlame = LoadAnimImage("gfx/flame.png", 8, 12, 0, 4, imgFlags)
	imgGrave = LoadImage("gfx/grave.png", imgFlags)
	imgBig = LoadAnimImage("gfx/big.png", 32, 32, 0, 8, imgFlags)
	imgFlame2 = LoadAnimImage("gfx/flame2.png", 8, 12, 0, 4, imgFlags)
	imgBane = LoadAnimImage("gfx/bane.png", 16, 16, 0, 16, imgFlags)
	imgBuster = LoadAnimImage("gfx/buster.png", 28, 20, 0, 8, imgFlags)
	imgGonsu = LoadAnimImage("gfx/gonsu.png", 16, 16, 0, 16, imgFlags)
	imgDrunk = LoadAnimImage("gfx/drunk.png", 46, 48, 0, 12, imgFlags)
	imgBottle = LoadAnimImage("gfx/bottle.png", 13, 14, 0, 4, imgFlags)
	imgBossBub2 = LoadImage("gfx/bossbub2.png", imgFlags)
	imgTut1 = LoadImage("gfx/tut1.png", imgFlags)
	imgTut2 = LoadImage("gfx/tut2.png", imgFlags)
	imgTut3 = LoadImage("gfx/tut3.png", imgFlags)
	imgDrunk2 = LoadAnimImage("gfx/drunk2.png", 16, 16, 0, 16, imgFlags)
	imgEnd = LoadAnimImage("gfx/end.png", 256, 224, 0, 2, imgFlags)
	imgTBub = LoadAnimImage("gfx/tbub.png", 8, 8, 0, 4, imgFlags)
	imgChars = LoadAnimImage("gfx/chars.png", 78, 95, 0, 3, imgFlags)
	imgCSel = LoadAnimImage("gfx/csel.png", 78, 95, 0, 2, imgFlags)
	imgStart = LoadImage("gfx/start.png", imgFlags)
	
	SetMaskColor 0, 0, 0
	imgLevel = CreateImage(256, 224, 1, DYNAMICIMAGE|imgFlags)
	imgNext = CreateImage(256, 224, 1, DYNAMICIMAGE|imgFlags)
		
	LoadLevel(curLevel, bReload)
	SetMaskColor 255, 0, 255

	MidHandleImage imgStars
	MidHandleImage imgFlare
	MidHandleImage imgExplode
	MidHandleImage imgScore
	MidHandleImage imgCross
	MidHandleImage imgFirework
	MidHandleImage imgSwoosh
	MidHandleImage imgSwoosh2
	MidHandleImage imgSwoosh3
	MidHandleImage imgBottle
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SHUFFLELEVELS - Shuffles tiles and dat order                                   
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function ShuffleLevels(bFirst:Int = False)

	Local j:Int, tmp:Int
	Local tmpOff:Int = 0

	If bFirst = True Then ' // Shuffle tiles
		For Local i:Int = 0 To MAX_TILES
			arrTiles[i] = i
		Next
	EndIf
	
	If curLevel <= 10 Then
		tmpOff = 0
	ElseIf curLevel <= 20 Then
		tmpOff = 10
	ElseIf curLevel <= 30 Then
		tmpOff = 20
	ElseIf curLevel <= 40 Then
		tmpOff = 30
	ElseIf curLevel <= 50 Then
		tmpOff = 40
	EndIf
	
	For Local i:Int = 0 To 9
		arrDat[i] = (i + tmpOff) + 1
	Next
		
	For Local shuf:Int = 1 To 7 ' // Shuffle 7 times

		If bFirst = True Then
			For Local i:Int = 0 To MAX_TILES ' // Tiles
				j = Rand(i, MAX_TILES)

				' // Swap 
				tmp = arrTiles[i]
				arrTiles[i] = arrTiles[j]
				arrTiles[j] = tmp
			Next
		EndIf
		
		For Local i:Int = 0 To 4 ' // First five
			j = Rand(i, 4)

			' // Swap 
			tmp = arrDat[i]
			arrDat[i] = arrDat[j]
			arrDat[j] = tmp
		Next

		For Local i:Int = 5 To 9 ' // Last five
			j = Rand(i, 9)

			' // Swap 
			tmp = arrDat[i]
			arrDat[i] = arrDat[j]
			arrDat[j] = tmp
		Next		
		
	Next
	
	' // Debug
	If bFirst = True Then
		For Local i:Int = 0 To MAX_TILES
			DebugLog "Tile " + i + ": " + arrTiles[i]
		Next
	EndIf
	
	For Local i:Int = 0 To 9
		DebugLog "Dat " + i + ": " + arrDat[i]
	Next
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADLEVEL - Loads level from dat file                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadLevel(myLev:Int, bReload:Int = False)
	
	Rem
	If bReload = 2 Then ' // Next level
		Local imgFlags:Int
		If cfgFilter = True Then imgFlags = MASKEDIMAGE|FILTEREDIMAGE Else imgFlags = MASKEDIMAGE
		
		'GCRelease imgNext
		'GCCollect
		
		SetMaskColor 0, 0, 0
		SetMaskColor 255, 0, 255
	EndIf
	EndRem
	
	Local File:TStream

	Local levNum:Int
	Local bTest:Int = False, testLevel:Int = 1
	If bTest = True Then ' // Test level
		myLev = testLevel
		levNum = testLevel
		curLevel = testLevel ' // Set public
		lastLevel = curLevel
		
		levelTile = testLevel - 1
		File = ReadFile("data/lev" + String(testLevel) + ".dat")	
			
	Else ' // Get from randomized array
		'DebugLog "LOAD " + myLev + "/" + arrDat[myLev]
		
		If myLev < 101 Then ' // LEVELS
			Local tmpOff:Int = 0
			
			If myLev <= 10 Then
				tmpOff = 0
			ElseIf myLev <= 20 Then
				tmpOff = 10
			ElseIf myLev <= 30 Then
				tmpOff = 20
			ElseIf myLev <= 40 Then
				tmpOff = 30
			ElseIf myLev <= 50 Then
				tmpOff = 40
			EndIf		
			
			levelTile = arrTiles[myLev - 1]	

			File = ReadFile("data/lev" + String(arrDat[(myLev - tmpOff) - 1]) + ".dat")
			levNum = arrDat[(myLev - tmpOff) - 1]
			
		ElseIf myLev < 201 Then ' // SHOP
			If myLev = 101 Then levelTile = 0 ElseIf myLev = 102 Then levelTile = 1
			File = ReadFile("data/lev" + String(myLev) + ".dat")
			levNum = myLev
			
			bMoney = True
		ElseIf myLev < 301 Then ' // BOSS
			levelTile = 2
			File = ReadFile("data/lev" + String(myLev) + ".dat")
			levNum = myLev
			
		EndIf
				
	EndIf

	' // DEFAULT
	lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252	
	
	If myLev < 101 Then ' // Color from file
		Select levelTile + 1
			Case 1; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 2; lvlC[0] = 252; lvlC[1] = 188; lvlC[2] = 176
			Case 3; lvlC[0] = 252; lvlC[1] = 216; lvlC[2] = 168
			Case 4; lvlC[0] = 224; lvlC[1] = 252; lvlC[2] = 160
			Case 5; lvlC[0] = 224; lvlC[1] = 252; lvlC[2] = 160
			Case 6; lvlC[0] = 212; lvlC[1] = 200; lvlC[2] = 252
			Case 7; lvlC[0] = 168; lvlC[1] = 228; lvlC[2] = 252
			Case 8; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 9; lvlC[0] = 252; lvlC[1] = 228; lvlC[2] = 160
			Case 10; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 11; lvlC[0] = 168; lvlC[1] = 240; lvlC[2] = 188
			Case 12; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 13; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 14; lvlC[0] = 0; lvlC[1] = 232; lvlC[2] = 216
			Case 15; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 16; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 17; lvlC[0] = 136; lvlC[1] = 112; lvlC[2] = 0
			Case 18; lvlC[0] = 252; lvlC[1] = 188; lvlC[2] = 176
			Case 19; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 20; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 21; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 22; lvlC[0] = 156; lvlC[1] = 252; lvlC[2] = 240
			Case 23; lvlC[0] = 136; lvlC[1] = 112; lvlC[2] = 0
			Case 24; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 25; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 26; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 27; lvlC[0] = 252; lvlC[1] = 216; lvlC[2] = 168
			Case 28; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 29; lvlC[0] = 168; lvlC[1] = 228; lvlC[2] = 252
			Case 30; lvlC[0] = 252; lvlC[1] = 228; lvlC[2] = 160
			Case 31; lvlC[0] = 252; lvlC[1] = 216; lvlC[2] = 168
			Case 32; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 33; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 34; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 35; lvlC[0] = 60; lvlC[1] = 188; lvlC[2] = 252
			Case 36; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 37; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 38; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 39; lvlC[0] = 252; lvlC[1] = 216; lvlC[2] = 168
			Case 40; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 216
			Case 41; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 42; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 43; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 44; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 45; lvlC[0] = 252; lvlC[1] = 216; lvlC[2] = 168
			Case 46; lvlC[0] = 252; lvlC[1] = 216; lvlC[2] = 168
			Case 47; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 48; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 49; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 50; lvlC[0] = 224; lvlC[1] = 252; lvlC[2] = 160
			Case 51; lvlC[0] = 252; lvlC[1] = 188; lvlC[2] = 176
			Case 52; lvlC[0] = 252; lvlC[1] = 188; lvlC[2] = 176
			Case 53; lvlC[0] = 156; lvlC[1] = 252; lvlC[2] = 240
			Case 54; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 55; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 56; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 57; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 58; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 59; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 216
			Case 60; lvlC[0] = 212; lvlC[1] = 200; lvlC[2] = 252
			Case 61; lvlC[0] = 252; lvlC[1] = 216; lvlC[2] = 168
			Case 62; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 63; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 64; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 65; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 66; lvlC[0] = 240; lvlC[1] = 188; lvlC[2] = 60
			Case 67; lvlC[0] = 156; lvlC[1] = 252; lvlC[2] = 240
			Case 68; lvlC[0] = 168; lvlC[1] = 228; lvlC[2] = 252
			Case 69; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 70; lvlC[0] = 252; lvlC[1] = 216; lvlC[2] = 168
			Case 71; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 72; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 73; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 74; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 216
			Case 75; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 76; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 77; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 78; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 79; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 80; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 81; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 82; lvlC[0] = 252; lvlC[1] = 216; lvlC[2] = 168
			Case 83; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 84; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 85; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 86; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 87; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 252
			Case 88; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 89; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 90; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 91; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 92; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 93; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 94; lvlC[0] = 176; lvlC[1] = 252; lvlC[2] = 204
			Case 95; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 96; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 97; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 98; lvlC[0] = 0; lvlC[1] = 232; lvlC[2] = 216
			Case 99; lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
			Case 100; lvlC[0] = 252; lvlC[1] = 196; lvlC[2] = 216
									
		End Select
		
	ElseIf myLev = 101 Then ' // Shop
		lvlC[0] = 244; lvlC[1] = 218; lvlC[2] = 164
		
	ElseIf myLev = 102 Then ' // Boss shop
		lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
		
	ElseIf myLev = 201 Or myLev = 202 Or myLev = 203 Then ' // Boss
		lvlC[0] = 252; lvlC[1] = 252; lvlC[2] = 252
		
	EndIf
	
	Local arrKeyX:Int[8]
	Local arrKeyY:Int[8]
	Local spawnX:Int[31]
	
	Local keyI:Int = 0
	Local specType:Int = 0, bSpec1:Int, bSpec2:Int
	
	If bReload <> False Then ' // Default special bubble destination
		bSpec1 = False; bSpec2 = False
		spec1D = 0; spec2D = 0
		bHasSpawn2 = False ' // Single spawn check

		For Local i9:Int = 0 To 2
			rXTile[i9] = Rand(0, 99)
		Next
	EndIf
		
	Cls; SetColor 255, 255, 255
	SetScale 1, 1
	For Local y:Int = 0 To 27
		For Local x:Int = 0 To 31
			arrLev[x, y] = ReadInt(File)
			
			' // Block score
			If y = 2 And (x = 15 Or x = 16) Then DrawImage imgBlank, x * 8, y * 8, 2
			
			' // Reserved tiles			
			If arrLev[x, y] <> 0 Then
				If x = 0 And y = 0 Then ' // Special bubbles
					If arrLev[x, y] = TILE_WATER Then 
						specType = BUB_WATER
					ElseIf arrLev[x, y] = TILE_ZAP Then
						specType = BUB_ZAP
					ElseIf arrLev[x, y] = TILE_FIRE Then
						specType = BUB_FIRE
					ElseIf arrLev[X, y] = TILE_ZAPWATER Then
						specType = BUB_ZAPWATER
					EndIf
					
				ElseIf x = 1 And y = 0 Then ' // Reserved 2
					If arrLev[x, y] = TILE_NOCOL Then 
						spec1D = 1; spec2D = 1 ' // No collision
					EndIf
								
				EndIf
				
				If arrLev[x, y] = TILE_BLOCK Then
					If myLev < 101 Then
						If bXMode = False Then ' // X Mode
							DrawImage imgTiles, x * 8, y * 8, levelTile
						Else
							DrawImage imgTiles, x * 8, y * 8, rXTile[Rand(0, 2)]
						EndIf
					Else ' // Shop
						DrawImage imgShop, x * 8, y * 8, levelTile
						'DebugLog x * 8 + ", " + y * 8
					EndIf
					
				ElseIf arrLev[x, y] = TILE_FILL Then ' // FILL TILE
					DrawImage imgBlank, x * 8, y * 8, 2			
					
				Else
				
					If bReload <> False Then ' // First load
						If bXMode = True Then ' // Random enemy
							Select arrLev[x, y]
								Case TILE_ENEMYR, TILE_ENEMYL, TILE_FLYERR, TILE_FLYERL, TILE_BANER, TILE_BANEL
								If levNum = 1 Then
									Local tmpRen:Int = Rand(0, 3)
									If tmpRen = 0 Then 
										arrLev[x, y] = TILE_ENEMYR
									ElseIf tmpRen = 1 Then
										arrLev[x, y] = TILE_ENEMYL
									ElseIf tmpRen = 2 Then
										arrLev[x, y] = TILE_BANER
									ElseIf tmpRen = 3 Then
										arrLev[x, y] = TILE_BANEL								
									EndIf								
								Else
									Local tmpRen:Int = Rand(0, 5)
									If tmpRen = 0 Then 
										arrLev[x, y] = TILE_ENEMYR
									ElseIf tmpRen = 1 Then
										arrLev[x, y] = TILE_ENEMYL
									ElseIf tmpRen = 2 Then
										arrLev[x, y] = TILE_FLYERR
									ElseIf tmpRen = 3 Then
										arrLev[x, y] = TILE_FLYERL
									ElseIf tmpRen = 4 Then
										arrLev[x, y] = TILE_BANER
									ElseIf tmpRen = 5 Then
										arrLev[x, y] = TILE_BANEL								
									EndIf
								EndIf
												
							End Select
						EndIf
						
						If arrLev[x, y] = TILE_BUBBLE Then
							bubX = Int((x * 8) * sclX); bubY = Int((y * 8) * sclY)
						ElseIf arrLev[x, y] = TILE_CHEST Then
							chestX = Int((x * 8) * sclX); chestY = Int((y * 8) * sclY) + 2
						ElseIf arrLev[x, y] = TILE_KEY Then
							arrKeyX[keyI] = Int((x * 8) * sclX)
							arrKeyY[keyI] = Int((y * 8) * sclY) + 2
							keyI:+1
						ElseIf arrLev[x, y] = TILE_ENEMYR Then
							Local tmpE:Int = 1, tmpLvl:Int = 1
							Local tmpHard:Int = 40
							If bLooped > 0 Then tmpHard = 40 - (bLooped * 10)
							If tmpHard < 0 Then tmpHard = 1
							
							If myLev >= tmpHard Then
								tmpE = Rand(1, 3)
							ElseIf myLev >= 6 Then
								tmpE = Rand(1, 2)
							EndIf
							If levNum = 9 Then tmpE = 2 ' // MIGHTA LVL
							If levNum = 42 Then tmpE = 3 ' // GONSU LVL
							If levNum = 29 Then tmpE = 1 ' // ZEN LVL
							
							If bXMode = True Then tmpE = Rand(1, 3)
							
							If tmpE = 1 Then ' // ZEN
								If myLev >= 11 Then tmpLvl = 2 ' // ZEN LEVEL 2
								If myLev >= 21 Then tmpLvl = 3 ' // ZEN LEVEL 3
								If myLev >= 31 Then tmpLvl = 4 ' // ZEN LEVEL 4
								If myLev >= 41 Then tmpLvl = 5 ' // ZEN LEVEL 5
																
								If bLooped > 0 Then ' // Hard
									tmpLvl:+bLooped
									If tmpLvl > 5 Then tmpLvl = 5
								EndIf

								If bXMode = True Then tmpLvl = Rand(1, 5)
								
							ElseIf tmpE = 2 Then ' // MIGHTA
								If myLev >= 16 Then tmpLvl = 2 ' // MIGHTA LEVEL 2
								If myLev >= 26 Then tmpLvl = 3 ' // MIGHTA LEVEL 3
								If myLev >= 36 Then tmpLvl = 4 ' // MIGHTA LEVEL 4
								
								If bLooped > 0 Then ' // Hard
									tmpLvl:+bLooped
									If tmpLvl > 4 Then tmpLvl = 4
								EndIf

								If bXMode = True Then tmpLvl = Rand(1, 4)
								
							ElseIf tmpE = 3 Then ' // GONSU
								tmpE = 2
								tmpLvl = 5
							EndIf
														
							objList.AddLast obj.Create(Int((x * 8) * sclX), -32 + spawnX[x], OBJ_ZEN, Int((y * 8) * sclY), 1, 0, 0, tmpE, tmpLvl)
							spawnX[x]:-32
						ElseIf arrLev[x, y] = TILE_ENEMYL Then ' // WALKER
							Local tmpE:Int = 1, tmpLvl:Int = 1
							Local tmpHard:Int = 40
							If bLooped > 0 Then tmpHard = 40 - (bLooped * 10)
							If tmpHard < 0 Then tmpHard = 1
														
							If myLev >= tmpHard Then
								tmpE = Rand(1, 3)
							ElseIf myLev >= 6 Then
								tmpE = Rand(1, 2)
							EndIf
							If levNum = 9 Then tmpE = 2 ' // MIGHTA LVL
							If levNum = 42 Then tmpE = 3 ' // GONSU LVL
							If levNum = 29 Then tmpE = 1 ' // ZEN LVL

							If bXMode = True Then tmpE = Rand(1, 3)
							
							If tmpE = 1 Then ' // ZEN
								If myLev >= 11 Then tmpLvl = 2 ' // ZEN LEVEL 2
								If myLev >= 21 Then tmpLvl = 3 ' // ZEN LEVEL 3
								If myLev >= 31 Then tmpLvl = 4 ' // ZEN LEVEL 4
								If myLev >= 41 Then tmpLvl = 5 ' // ZEN LEVEL 5
								
								If bLooped > 0 Then ' // Hard
									tmpLvl:+bLooped
									If tmpLvl > 5 Then tmpLvl = 5
								EndIf

								If bXMode = True Then tmpLvl = Rand(1, 5)
								
							ElseIf tmpE = 2 Then ' // MIGHTA
								If myLev >= 16 Then tmpLvl = 2 ' // MIGHTA LEVEL 2
								If myLev >= 26 Then tmpLvl = 3 ' // MIGHTA LEVEL 3
								If myLev >= 36 Then tmpLvl = 4 ' // MIGHTA LEVEL 4
								
								If bLooped > 0  Then ' // Hard
									tmpLvl:+bLooped
									If tmpLvl > 4 Then tmpLvl = 4
								EndIf

								If bXMode = True Then tmpLvl = Rand(1, 4)
																
							ElseIf tmpE = 3 Then ' // GONSU
								tmpE = 2
								tmpLvl = 5
							EndIf
							objList.AddLast obj.Create(Int((x * 8) * sclX), -32 + spawnX[x], OBJ_ZEN, Int((y * 8) * sclY), 0, 0, 0, tmpE, tmpLvl)
							spawnX[x]:-32
						ElseIf arrLev[x, y] = TILE_FLYERR Then ' // FLYER
							Local tmpE:Int = EN_MONSTA, tmpLvl:Int = 1 ' // MONSTA
							If myLev >= 20 Then tmpE = Rand(4, 5) ' // PULPUL
							If levNum = 24 Then tmpE = 5 ' // PULPUL LVL

							If bXMode = True Then tmpE = Rand(4, 5)
							
							If tmpE = 4 Then
								If myLev >= 26 Then tmpLvl = 2 ' // MONSTA LEVEL 2
								If myLev >= 41 Then tmpLvl = 3 ' // MONSTA LEVEL 3
								
								If bLooped > 0 Then ' // Hard
									tmpLvl:+bLooped
									If tmpLvl > 3 Then tmpLvl = 3
								EndIf
								
								If bXMode = True Then tmpLvl = Rand(1, 3)

							ElseIf tmpE = 5 Then
								If myLev >= 36 Then tmpLvl = 2 ' // PULPUL LEVEL 2

								If bLooped > 0 Then ' // Hard
									tmpLvl:+bLooped
									If tmpLvl > 2 Then tmpLvl = 2
								EndIf

								If bXMode = True Then tmpLvl = Rand(1, 2)
														
							EndIf
							objList.AddLast obj.Create(Int((x * 8) * sclX), -32 + spawnX[x], OBJ_ZEN, Int((y * 8) * sclY), 1, 0, 0, tmpE, tmpLvl)
							spawnX[x]:-32
						ElseIf arrLev[x, y] = TILE_FLYERL Then ' // FLYER
							Local tmpE:Int = EN_MONSTA, tmpLvl:Int = 1 ' // MONSTA
							If myLev >= 20 Then tmpE = Rand(4, 5) ' // PULPUL
							If levNum = 24 Then tmpE = 5 ' // PULPUL LVL

							If bXMode = True Then tmpE = Rand(4, 5)
							
							If tmpE = 4 Then
								If myLev >= 26 Then tmpLvl = 2 ' // MONSTA LEVEL 2
								If myLev >= 41 Then tmpLvl = 3 ' // MONSTA LEVEL 3

								If bLooped > 0 Then ' // Hard
									tmpLvl:+bLooped
									If tmpLvl > 3 Then tmpLvl = 3
								EndIf

								If bXMode = True Then tmpLvl = Rand(1, 3)
																
							ElseIf tmpE = 5 Then
								If myLev >= 36 Then tmpLvl = 2 ' // PULPUL LEVEL 2

								If bLooped > 0 Then ' // Hard
									tmpLvl:+bLooped
									If tmpLvl > 2 Then tmpLvl = 2
								EndIf

								If bXMode = True Then tmpLvl = Rand(1, 2)
																
							EndIf							
							objList.AddLast obj.Create(Int((x * 8) * sclX), -32 + spawnX[x], OBJ_ZEN, Int((y * 8) * sclY), 0, 0, 0, tmpE, tmpLvl)
							spawnX[x]:-32
						ElseIf arrLev[x, y] = TILE_SSPAWN1 Then ' // Special spawn 1
							Local tmpY:Int
							If y = 0 Then tmpY = -32 ElseIf y = 27 Then tmpY = 448							
							objList.AddLast obj.Create(Int((x * 8) * sclX), tmpY, OBJ_SPAWN, specType, 0)
							specC = 0							
						ElseIf arrLev[x, y] = TILE_SSPAWN2 Then ' // Special spawn 2
							Local tmpY:Int
							If y = 0 Then tmpY = -32 ElseIf y = 27 Then tmpY = 448							
							objList.AddLast obj.Create(Int((x * 8) * sclX), tmpY, OBJ_SPAWN, specType, 1)
							specC = 0
							bHasSpawn2 = True ' // Public													
						ElseIf arrLev[x, y] = TILE_SDEST1 Then
							spec1X = Int((x * 8) * sclX); spec1Y = Int((y * 8) * sclY)
							If y = 0 Then spec1Y = -32 ElseIf y = 27 Then spec1Y = 448
							bSpec1 = True
							
						ElseIf arrLev[x, y] = TILE_SDEST2 Then
							spec2X = Int((x * 8) * sclX); spec2Y = Int((y * 8) * sclY)
							If y = 0 Then spec2Y = -32 ElseIf y = 27 Then spec2Y = 448
							bSpec2 = True

						ElseIf arrLev[x, y] = TILE_BANER Then ' // BANEBOU
							objList.AddLast obj.Create(Int((x * 8) * sclX), -32 + spawnX[x], OBJ_ZEN, Int((y * 8) * sclY), 1, 0, 0, EN_BANE, 1)
							spawnX[x]:-32
							
						ElseIf arrLev[x, y] = TILE_BANEL Then ' // BANEBOU
							objList.AddLast obj.Create(Int((x * 8) * sclX), -32 + spawnX[x], OBJ_ZEN, Int((y * 8) * sclY), 0, 0, 0, EN_BANE, 1)
							spawnX[x]:-32
														
						ElseIf arrLev[x, y] = TILE_ZAP Then
						
						EndIf
					EndIf
					
				EndIf
			Else
				'DrawImage imgBlank, x * 8, y * 8, 0	
			EndIf
			
		Next
	Next
	CloseFile File
	
	If bReload <> False Then ' // Special destination defaults
		If bSpec1 = False Then spec1X = bubX; spec1Y = bubY
		If bSpec2 = False Then spec2X = bubX; spec2Y = bubY

	EndIf
	
	'DebugLog "spec1: " + spec1X + ", " + spec1Y
	'DebugLog "spec2: " + spec2X + ", " + spec2Y
	
	Local grabX:Int = 0, grabY:Int = 0
	If bWindowed = False Then grabX = 26; grabY = 16 ' // Fullscreen
	
	If bReload = 2 Then 
		GrabImage imgNext, grabX, grabY ' // Next level		
	Else
		GrabImage imgLevel, grabX, grabY
	EndIf
		
	SetScale sclX, sclY
	
	' // Random key position
	If bReload <> False And keyI > 0 Then
		Local tmpR:Int = Rand(0, keyI - 1)
		keyX = arrKeyX[tmpR]
		keyY = arrKeyY[tmpR]
		
		' // Candy
		Local tmpR2:Int
		Repeat
			tmpR2 = Rand(0, keyI - 1)
		Until tmpR2 <> tmpR
		candyX = arrKeyX[tmpR2]
		candyY = arrKeyY[tmpR2]
		
	EndIf
	
	' // Shop items
	If (myLev > 100 And myLev < 200) And bReload = False Then
		objList.AddLast obj.Create(Int(56 * sclX), Int(104 * sclY), OBJ_ITEM, -1)			
		objList.AddLast obj.Create(Int(120 * sclX), Int(104 * sclY), OBJ_ITEM, -2)			
		objList.AddLast obj.Create(Int(184 * sclX), Int(104 * sclY), OBJ_ITEM, -3)			
		
		' // Resurrect
		If curLevel = 101 Or curLevel = 102 Then
			If b2Player = True Then
				If p_Dead[0] = 4 Then
					objList.AddLast obj.Create(Int(55), Int(336), OBJ_ITEM, -4)			
				ElseIf p_Dead[1] = 4 Then
					objList.AddLast obj.Create(Int(497), Int(336), OBJ_ITEM, -5)					
				EndIf
				
			EndIf				
		EndIf
					
	ElseIf (myLev > 200 And myLev < 300) And bReload = False Then ' // BOSS
		If myLev = 201 Then ' // Boss 1
			objList.AddLast obj.Create(Int((15 * 8) * sclX), Int((24 * 8) * sclY) + 2, OBJ_ZEN, Int((24 * 8) * sclY) + 2, 0, 0, 0, EN_BOSS1)
		ElseIf myLev = 202 Then ' // Boss 2
			objList.AddLast obj.Create(Int((15 * 8) * sclX), Int((14 * 8) * sclY) + 2, OBJ_ZEN, Int((14 * 8) * sclY) + 2, 0, 0, 0, EN_BOSS2)
		ElseIf myLev = 203 Then ' // Boss 3
			objList.AddLast obj.Create(Int((13 * 8) * sclX), Int((12 * 8) * sclY) + 2, OBJ_ZEN, Int((12 * 8) * sclY) + 2, 0, 0, 0, EN_BOSS3)		
		EndIf
		
		Rem
		StopChannel musChan
		musChan = AllocChannel()
		musChan.SetVolume(Float(cfgMusic) / 5)				
		musChan = PlayMusic(musBoss, musChan)
		EndRem
		
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETINPUT - Handles player keyboard and joystick input                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetUserInput()

	Local i:Int
	
	For i = 0 To b2Player
		If p_Zap[i] = True Then ' // End zapped
			If GetMilliSecs() >= p_ZapT[i] + 330 Then p_Zap[i] = False
		EndIf
		
		If p_Dead[i] = False And p_Zap[i] = False Then ' // Dead / zap check
		
		If curLevel > 100 And curLevel < 200 Then ' // Shop exit
			Local tmpJoy:Int
			If i = PLAYER_1 Then tmpJoy = bJoy1YHit ElseIf i = PLAYER_2 Then tmpJoy = bJoy2YHit
			
			If GetInput(i, INP_U) = True And tmpJoy = False Then 					
				If (p_X[i] >= 269 And p_X[i] <= 283) And p_Y[i] = 386 And p_J[i] = False And p_Fall[i] = False Then				
					nextLevel = 8
					
					FlushInput
				EndIf


				bJoy1YHit = True
				bJoy2YHit = True				
			EndIf

			If JoyY(p1Joy) <= .5 And JoyY(p1Joy) >= -.5 Then 
				bJoy1YHit = False ' // Reset joystick
			EndIf
					
			If JoyY(p2Joy) <= .5 And JoyY(p2Joy) >= -.5 Then 
				bJoy2YHit = False ' // Reset joystick
			EndIf						

		EndIf
		
		If GetInput(i, INP_R, 1) = True Then ' // RIGHT
			
			If (GetMilliSecs() <= p_FT[i] + 100) And p_D[i] = 0 Then ' // Fall through fix
				p_X[i]:-1				
			Else
				If p_J[i] = False And p_Fall[i] = False Then
					If p_F[i] > 3 Then p_F[i] = 0 ' // Frame reset
					
					Local tmpT:Int = 130
					If ACT_SHOES[i] = 1 Then tmpT = 65
					
					If GetMilliSecs() >= p_T[i] + tmpT Then ' // Animate
						If p_F[i] < 3 Then p_F[i]:+1 Else p_F[i] = 0
						p_T[i] = GetMilliSecs()
					EndIf
				Else
					If p_D[i] = 0 Then p_F[i]:-16 ' // Frame reset					
				EndIf

				Local tmpSp:Int = p_Speed[i]
				If ACT_SHOES[i] = 1 Then tmpSp = 4 ' // Speed shoes
				If p_Flame[i] = True Then tmpSp = 1
				
				If Int(p_X[i] + tmpSp) < 515 Then 
					If p_Col[i] <> 1 Then p_X[i]:+tmpSp ' // Collision check				
				Else 
					p_X[i] = 515 ' // Bounds
				EndIf					

				p_D[i] = 1					
				p_Idle[i] = False
			EndIf
			
		ElseIf GetInput(i, INP_L, 1) = True Then ' // LEFT
		
			If (GetMilliSecs() <= p_FT[i] + 100) And p_D[i] = 1 Then ' // Fall through fix
				p_X[i]:+1
			Else
				If p_J[i] = False And p_Fall[i] = False Then
					If p_F[i] < 16 Or p_F[i] > 19 Then p_F[i] = 16 ' // Frame reset

					Local tmpT:Int = 130
					If ACT_SHOES[i] = 1 Then tmpT = 65
									
					If GetMilliSecs() >= p_T[i] + tmpT Then ' // Animate
						If p_F[i] < 19 Then p_F[i]:+1 Else p_F[i] = 16
						p_T[i] = GetMilliSecs()
					EndIf
				Else
					If p_D[i] = 1 Then p_F[i]:+16 ' // Frame reset					
				EndIf

				Local tmpSp:Int = p_Speed[i]
				If ACT_SHOES[i] = 1 Then tmpSp = 4 ' // Speed shoes
				If p_Flame[i] = True Then tmpSp = 1
				
				If Int(p_X[i] - tmpSp) > 37 Then 
					If p_Col[i] <> 0 Then p_X[i]:-tmpSp ' // Collision check
				Else 
					p_X[i] = 37 ' // Bounds
				EndIf

				p_D[i] = 0
				p_Idle[i] = False
			EndIf
			
		Else ' // IDLE
			If p_J[i] = False And p_Fall[i] = False Then
				If p_Idle[i] = False Then
					If p_D[i] = 1 Then ' // Frame reset
						If p_F[i] = 1 Or p_F[i] = 3 Then p_F[i] = 0 Else p_F[i] = 1
					ElseIf p_D[i] = 0 Then
						If p_F[i] = 17 Or p_F[i] = 19 Then p_F[i] = 16 Else p_F[i]= 17
					EndIf
					
					p_X[i] = Int(p_X[i]); p_Y[i] = Int(p_Y[i]) ' // Align
					
					p_T[i] = GetMilliSecs()
				EndIf
						
				If GetMilliSecs() >= p_T[i] + 260 Then ' // Animate
					If p_D[i] = 1 Then
						If p_F[i] < 1 Then p_F[i]:+1 Else p_F[i] = 0
					ElseIf p_D[i] = 0 Then
						If p_F[i] < 17 Then p_F[i]:+1 Else p_F[i] = 16
					EndIf
					
					p_T[i] = GetMilliSecs()
				EndIf
				
				p_Idle[i] = True
			EndIf
			
		EndIf
				
		If (GetInput(i, INP_A) = True And p_Fall[i] = False) Or (GetInput(i, INP_A, 1) = True And p_bJump[i] = 1 And p_YI[i] <= 0) Then ' // JUMP
			If p_J[i] = False Or (p_YI[i] <= 0 And p_bJump[i] = True) Then 
				p_J[i] = True
				p_YI[i] = 6
				p_T[i] = GetMilliSecs()
				
				If p_D[i] = 0 Then p_F[i] = 20 ElseIf p_D[i] = 1 Then p_F[i] = 4
				PlaySFX sfxJump
			EndIf
		EndIf
			
		' // USE ITEM
		If GetInput(i, INP_U, 1) = True And GetInput(i, INP_X) = True And p_Item[i] <> -1 Then
			' // Disable red amulet/money on bosses
			If curLevel > 200 And (p_Items[i, p_Item[i]] = 24 Or p_Items[i, p_Item[i]] = 25) Then
			Else
				If p_Items[i, p_Item[i]] <> -1 Then
					PlaySFX sfxItem
					
					DoItemAction(i, p_Items[i, p_Item[i]]) ' // Item action
					
					Local bSet:Int = False
					For Local i2:Int = p_Item[i] + 1 To 5 ' // Shift items
						p_Items[i, i2 - 1] = p_Items[i, i2]
						p_Items[i, i2] = -1
					Next

					p_Items[i, 5] = -1				

					If p_Items[i, p_Item[i]] = -1 Then p_Item[i]:-1
				EndIf
			EndIf
		EndIf
		
		'DebugLog p_Item[0] + "/" + p_Item[1]
		
		' // GIVE ITEM
		If GetInput(i, INP_D, 1) = True And GetInput(i, INP_X) = True And p_Item[i] <> -1 And b2Player = True Then
			If p_Items[i, p_Item[i]] <> -1 Then
				
				Local bPass:Int = False, myP:Int
				If i = PLAYER_1 Then myP = PLAYER_2 ElseIf i = PLAYER_2 Then myP = PLAYER_1
				
				' // Make sure there's room
				If p_Dead[myP] = False Then
					For Local i3:Int = 0 To 5
						If p_Items[myP, i3] = -1 Then 
							p_Items[myP, i3] = p_Items[i, p_Item[i]]
							If p_Item[myP] = -1 Then p_Item[myP] = 0											
							bPass = True
							Exit
						EndIf
					Next
				EndIf
				
				If bPass = True Then ' // Given
					PlaySFX sfxPoof
									
					Local bSet:Int = False
					For Local i2:Int = p_Item[i] + 1 To 5 ' // Shift items
						p_Items[i, i2 - 1] = p_Items[i, i2]
						p_Items[i, i2] = -1
					Next

					p_Items[i, 5] = -1				

					If p_Items[i, p_Item[i]] = -1 Then p_Item[i]:-1
				EndIf
			EndIf
		EndIf
		
		If GetInput(i, INP_B, 1) = True And (p_MP[i] > 0 Or ACT_BLUE_AMULET[i] = True) Then ' // CHARGE
			If (p_S[i] = False And GetMilliSecs() >= p_ST[i] + 430) Then
				If p_Charge[i] = 0 Then 
					p_Charge[i] = 1; p_ChargeT[i] = GetMilliSecs()
					'If ChannelPlaying(chargeChan[i]) = False Then 
					chargeChan[i] = PlaySFX(sfxCharge, chargeChan[i])
					' // BUGFIX
					If ChannelPlaying(chargeChan[i]) = False Then chargeChan[i] = PlaySFX(sfxCharge, chargeChan[i])
				EndIf
			EndIf
			
		ElseIf GetInput(i, INP_B) = True Then ' // SHOOT		
			
			If p_Charge[i] < 14 Then ' // BUBBLE
				
				Local tmpShootT:Int = 430
				If ACT_GREEN_SWEET[i] = 1 Then tmpShootT = 250 ' // Green sweet fast shooting
				
				If (p_S[i] = False And GetMilliSecs() >= p_ST[i] + tmpShootT) Then
					PlaySFX sfxBubble
					
					Local tmpX:Int
					If p_D[i] = 1 Then tmpX = 7 ElseIf p_D[i] = 0 Then tmpX = -7
					bubList.AddLast bub.Create(Int(p_X[i]) + tmpX, Int(p_Y[i]), i, p_D[i], 1)
											
					p_S[i] = True
					p_ST[i] = GetMilliSecs()
					p_Charge[i] = 0
				EndIf
				
				If ChannelPlaying(chargeChan[i]) = True Then StopChannel chargeChan[i]; chargeChan[i] = AllocChannel()

			EndIf
					
		Else ' // STOP CHARGING
			If p_Charge[i] >= 14 Then
				p_Charge[i] = -1 ' // Must release

				Local tmpX:Int, tmpY:Int
				If ACT_BLUE_AMULET[i] = True Then
					If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -46
					tmpY = -4
				
					PlaySFX sfxBuster
					shotList.AddLast shot.Create(Int(p_X[i]) + tmpX, Int(p_Y[i]) + tmpY, SHOT_FIREBALL, p_D[i], i, 999)
					shotList.AddLast shot.Create(Int(p_X[i]) - 18, Int(p_Y[i]) - 16, SHOT_SWOOSH, p_D[i], i, 999)
				
				Else
				If p_Class[i] = CLASS_EMBER Then ' // FIREBALL
					p_MP[i]:-1 ' // MAGIC

					PlaySFX sfxFlame
					If p_SpellL[i] = 1 Then ' // LEVEL 1		
						If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -14
						tmpY = 6
					ElseIf p_SpellL[i] = 2 Then ' // LEVEL 2
						If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -20
						tmpY = 2
					ElseIf p_SpellL[i] = 3 Then ' // LEVEL 3
						If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -28
						tmpY = -2				
					EndIf
					shotList.AddLast shot.Create(Int(p_X[i]) + tmpX, Int(p_Y[i]) + tmpY, SHOT_FIREBALL, p_D[i], i, p_SpellL[i])
					shotList.AddLast shot.Create(Int(p_X[i]) - 18, Int(p_Y[i]) - 16, SHOT_SWOOSH, p_D[i], i, p_SpellL[i])
					
				ElseIf p_Class[i] = CLASS_SHOCK Then ' // SHOCK
					p_MP[i]:-1 ' // MAGIC

					PlaySFX sfxShock
					If p_SpellL[i] = 1 Then ' // LEVEL 1		
						If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -10
						tmpY = 4
					ElseIf p_SpellL[i] = 2 Then ' // LEVEL 2
						If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -18
						tmpY = 0
					ElseIf p_SpellL[i] = 3 Then ' // LEVEL 3
						If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -44
						tmpY = -2
					EndIf
										
					shotList.AddLast shot.Create(Int(p_X[i]) + tmpX, Int(p_Y[i]) + tmpY, SHOT_FIREBALL, p_D[i], i, p_SpellL[i])
					shotList.AddLast shot.Create(Int(p_X[i]) - 18, Int(p_Y[i]) - 16, SHOT_SWOOSH, p_D[i], i, p_SpellL[i])
				
				ElseIf p_Class[i] = CLASS_BUBBLE Then ' // SPLASH
					p_MP[i]:-1 ' // MAGIC

					PlaySFX sfxSplash
					If p_SpellL[i] = 1 Then ' // LEVEL 1		
						If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -18
						tmpY = 8
					ElseIf p_SpellL[i] = 2 Then ' // LEVEL 2
						If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -22
						tmpY = 4
					ElseIf p_SpellL[i] = 3 Then ' // LEVEL 3
						If p_D[i] = 1 Then tmpX = 18 ElseIf p_D[i] = 0 Then tmpX = -18
						tmpY = 0						
					EndIf
					shotList.AddLast shot.Create(Int(p_X[i]) + tmpX, Int(p_Y[i]) + tmpY, SHOT_FIREBALL, p_D[i], i, p_SpellL[i])
					shotList.AddLast shot.Create(Int(p_X[i]) - 18, Int(p_Y[i]) - 16, SHOT_SWOOSH, p_D[i], i, p_SpellL[i])				
					
				EndIf
				EndIf ' // END BLUE AMULET BLOCK
						
				p_S[i] = True
				p_ST[i] = GetMilliSecs()
				p_Charge[i] = 0				
			Else
				p_Charge[i] = 0
			EndIf
			StopChannel chargeChan[i]; chargeChan[i] = AllocChannel()
			
		EndIf
		
		Rem
		If bDebug = True And p_Class[i] = CLASS_BUBBLE Then ' // SPLASH COL
			SetColor 0, 0, 255
			DrawRect Int(p_X[i]) + 50, Int(p_Y[i]) + 34, 4, 4
			DrawRect Int(p_X[i]) + 50, Int(p_Y[i]) + 18, 4, 4

			DrawRect Int(p_X[i]) - 22, Int(p_Y[i]) + 34, 4, 4

			DrawRect Int(p_X[i]) + 86, Int(p_Y[i]) + 34, 4, 4
			DrawRect Int(p_X[i]) + 122, Int(p_Y[i]) + 34, 4, 4
			
			SetColor 255, 255, 255
			'DrawRect Int(X) + 12, Int(Y) -62, 4, 4
		EndIf		
		EndRem
		
		' // SELECT ITEM
		If GetInput(i, INP_X) = True Then
			If p_Item[i] = 5 Then
				p_Item[i] = 0
			ElseIf p_Items[i, p_Item[i] + 1] <> -1 Then 
				p_Item[i]:+1
			Else
				p_Item[i] = 0
			EndIf
		EndIf
		
		If p_J[i] = True Then ' // JUMP ACTION
			p_Y[i]:-p_YI[i]
			If p_YI[i] > -6 Then p_YI[i]:-.215 Else p_J[i] = False; p_Fall[i] = True
			
			If p_YI[i] > 0 Then ' // Animate rise
				If GetMilliSecs() >= p_T[i] + 160 Then
					If p_F[i] = 4 Then p_F[i] = 5 ElseIf p_F[i] = 20 Then p_F[i] = 21				
				EndIf
			Else ' // Animate fall
				If p_F[i] = 5 Or p_F[i] = 4 Then 
					p_F[i] = 7; p_T[i] = GetMilliSecs()
				ElseIf p_F[i] = 21 Or p_F[i] = 20 Then
					p_F[i] = 23; p_T[i] = GetMilliSecs()
				EndIf
				
				If GetMilliSecs() >= p_T[i] + 260 Then
					If p_F[i] = 23 Then p_F[i] = 22 ElseIf p_F[i] = 22 Then p_F[i] = 23
					If p_F[i] = 7 Then p_F[i] = 6 ElseIf p_F[i] = 6 Then p_F[i] = 7
					
					p_T[i] = GetMilliSecs()
				EndIf
			EndIf
		
			p_Idle[i] = False
			
		ElseIf p_Fall[i] = True Then ' // FALL ACTION
			If Int(p_Y[i]) < 448 Then p_Y[i]:+2 Else p_Y[i] = -32 ' // Screen wrap

			If GetMilliSecs() >= p_T[i] + 260 Then
				If p_F[i] = 23 Then p_F[i] = 22 ElseIf p_F[i] = 22 Then p_F[i] = 23				
				If p_F[i] = 7 Then p_F[i] = 6 ElseIf p_F[i] = 6 Then p_F[i] = 7
				
				p_T[i] = GetMilliSecs()
			EndIf
			
			p_YI[i] = 0
			p_Idle[i] = False
				
		EndIf	
		
		If p_S[i] = True Then ' // SHOOT ACTION
			If p_D[i] = 1 Then p_F[i] = 8 ElseIf p_D[i] = 0 Then p_F[i] = 24
			
			p_Idle[i] = False
						
			If GetMilliSecs() >= p_ST[i] + 280 Then 
				p_S[i] = False
				
				' // Reset to proper frame
				If p_J[i] = True Then
					If p_Y[i] > 0 Then
						If GetMilliSecs() >= p_T[i] + 160 Then
							If p_D[i] = 1 Then p_F[i] = 5 ElseIf p_D[i] = 0 Then p_F[i] = 21
						Else
							If p_D[i] = 1 Then p_F[i] = 4 ElseIf p_D[i] = 0 Then p_F[i] = 20
						EndIf
					Else
						If p_D[i] = 1 Then p_F[i] = 6 ElseIf p_D[i] = 0 Then p_F[i] = 22
					EndIf
					p_T[i] = GetMilliSecs()					
					
				ElseIf p_Fall[i] = True Then
					If p_D[i] = 1 Then p_F[i] = 6 ElseIf p_D[i] = 0 Then p_F[i] = 22
					p_T[i] = GetMilliSecs()

				Else
					p_T[i] = 0
				EndIf
				
			EndIf
		EndIf	
		
		' // PAUSE
		If GetInput(i, INP_S) = True Then
			DrawStats()
			
			bPaused[i] = True; PlaySFX sfxPause
			PauseChannel musChan
			FlushInput		
			pauseStart = GetMilliSecs() ' // Hold pause start time
		EndIf
		EndIf ' // Dead / zap block
	Next
			
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DoItemAction - Executes item actions                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DoItemAction(myP:Int, myI:Int)

	Select myI
	
		Case 16 ' // Health potion (+3)
		'p_Life[myP] = p_LifeT[myP]
		If p_Life[myP] + baseHearts < p_LifeT[myP] Then p_Life[myP]:+baseHearts Else p_Life[myP] = p_LifeT[myP] ' // Health up
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 0)
		Next
					
		Case 17 ' // Magic potion (+10)
		'p_MP[myP] = p_GMP[myP]
		If p_MP[myP] + 10 < p_GMP[myP] Then p_MP[myP]:+10 Else p_MP[myP] = p_GMP[myP] ' // MP up

		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 1)
		Next
				
		Case 18 ' // Bomb
		shotList.AddLast shot.Create(Int(p_X[myP]), Int(p_Y[myP]), SHOT_BOMB, myP)
		p_BombC[myP] = 1
		p_BombT[myP] = GetMilliSecs()
		
		Case 19 ' // Pink book (meteor storm)
		If myP = 0 Then ' // Only one active at a time
			If ACT_PINK_BOOK[1] = 0 Then ACT_PINK_BOOK[0] = 1; pinkBookC = 0
		ElseIf myP = 1 Then
			If ACT_PINK_BOOK[0] = 0 Then ACT_PINK_BOOK[1] = 1; pinkBookC = 0
		EndIf
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 4)
		Next		
		
		Case 20 ' // Green sweet (faster shooting)
		ACT_GREEN_SWEET[myP] = 1
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 2)
		Next
		
		Case 21 ' // Blue sweet (faster bubbles)
		ACT_BLUE_SWEET[myP] = 1
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 1)
		Next

		Case 22 ' // Red sweet (far bubbles)
		ACT_RED_SWEET[myP] = 1
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 0)
		Next
		
		Case 23 ' // Speed shoes
		ACT_SHOES[myP] = 1
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 0)
		Next
		
		Case 24 ' // Red amulet (all basic powerups)
		ACT_GREEN_SWEET[myP] = 1
		ACT_BLUE_SWEET[myP] = 1
		ACT_RED_SWEET[myP] = 1
		ACT_SHOES[myP] = 1
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 0)
		Next
		
		Case 25 ' // Brooch (enemies into gems)
		ACT_BROOCH[myP] = 1

		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 3)
		Next

		' // Switch all fruits to gems
		For o:Obj = EachIn objList
			If o.ID = OBJ_FRUIT Then 
				o.ID = OBJ_GEM; o.F = Rand(0, 2)
				o.Fall = True
				o.YI = -2
			EndIf				
		Next
		
		Case 26 ' // Donut (enemies into candy)
		ACT_DONUT[myP] = 1
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 4)
		Next
		
		' // Switch all fruits to candy
		For o:Obj = EachIn objList
			If o.ID = OBJ_FRUIT Then 
				o.ID = OBJ_CANDY; o.F = Rand(0, 15)
			EndIf				
		Next
		
		Case 27 ' // Blue amulet (magic doesn't spend MP)
		ACT_BLUE_AMULET[myP] = 1		
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 1)
		Next
		
		Case 28 ' // Blue book (splash storm)
		If myP = 0 Then ' // Only one active at a time
			If ACT_BLUE_BOOK[1] = 0 Then ACT_BLUE_BOOK[0] = 1; blueBookC = 0
		ElseIf myP = 1 Then
			If ACT_BLUE_BOOK[0] = 0 Then ACT_BLUE_BOOK[1] = 1; blueBookC = 0
		EndIf
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 1)
		Next
		
		Case 29 ' // Cross
		shotList.AddLast shot.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, SHOT_CROSS, 0, myP)

		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 0)
		Next
		
		Case 30 ' // Clover (enemies into money bags)
		ACT_CLOVER[myP] = 1
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 2)
		Next
		
		' // Switch all fruits to money bags
		For o:Obj = EachIn objList
			If o.ID = OBJ_FRUIT Then 
				o.ID = OBJ_CANDY; o.Hurt = True
			EndIf				
		Next
		
		Case 31 ' // Green book (firework storm)
		If myP = 0 Then ' // Only one active at a time
			If ACT_GREEN_BOOK[1] = 0 Then ACT_GREEN_BOOK[0] = 1; greenBookC = 0
		ElseIf myP = 1 Then
			If ACT_GREEN_BOOK[0] = 0 Then ACT_GREEN_BOOK[1] = 1; greenBookC = 0
		EndIf
		
		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 2)
		Next
		
		Case 32 ' // Green potion
		If p_Life[myP] + baseHearts < p_LifeT[myP] Then p_Life[myP]:+baseHearts Else p_Life[myP] = p_LifeT[myP] ' // Health up
		If p_MP[myP] + 10 < p_GMP[myP] Then p_MP[myP]:+10 Else p_MP[myP] = p_GMP[myP] ' // MP up

		For Local i:Int = 1 To 15
			partList.AddLast part.Create(Int(p_X[myP]) + 18, Int(p_Y[myP]) + 16, PART_POWER, 2)
		Next
		
	End Select
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NEWGAME - Resets all variables at start of game                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NewGame(bStart:Int=False)

	If bTitle = True Then
		curLevel = 1
		lastLevel = 1
		nextLevel = 0
		reloadC = 0
	EndIf
	
	' // Level setup
	ShuffleLevels(True)
	LoadImages(cfgFilter, True) ' // Load all images
	Cls
	
	If bStart = True Then ' // Transition to first level
		Local sY:Int = 0

		Repeat
			Cls
			
			DrawImage imgStart, 0, Int(sY)
			DrawImage imgLevel, 0, Int(sY + 448)
			
			DrawFloat()
			
			If (sY - 3) > -448 Then 
				sY:-3
			Else ' // End transition			
				If sY <> -448 Then sY = -448 Else sY = -1
			EndIf

			Flip -1		
		Until sY = -1
		StopChannel musChan; musChan = AllocChannel()		
	EndIf
	
	' // General
	p_X[0] = 55; p_Y[0] = 386
	p_D[0] = 1
	
	p_X[1] = 497; p_Y[1] = 386
	p_D[1] = 0
	p_F[1] = 16
	
	If cfgDiff = 0 ' // Easy mode
		baseHearts = 4
	ElseIf cfgDiff = 1 Then ' // Normal
		baseHearts = 3
	ElseIf cfgDiff = 2 Then ' // Hard
		baseHearts = 2
	EndIf
	
	If bXMode = True Then baseHearts = 5 ' // X Mode
	
	p_Dead[0] = 4 ' // Default dead
	p_Dead[1] = 4
	
	' // Classes
	For Local i:Int = 0 To b2Player

		' // Shared
		p_Speed[i] = 2
		p_ST[i] = -250 ' // Input time
		p_Idle[i] = True
		p_J[i] = False
		p_Fall[i] = False
		p_Col[i] = -1
		p_S[i] = False
		p_Hurt[i] = False
		p_XP[i] = 0
		p_Chain[i] = 0
		p_Score[i] = 0
		p_Lvl[i] = 1
		p_Charge[i] = -1
		p_Key[i] = 0
		p_Item[i] = -1
		p_Dead[i] = False
		If bLooped = 0 Then p_Points[i] = 0
		p_MChain[i] = 0
		p_SpellL[i] = 1
		p_SpellC[i] = 1
		p_Zap[i] = False
		p_Flame[i] = False
		p_Warn[i] = False
		p_BombC[i] = 0
		
		For Local i2:Int = 0 To 5 ' // Clear items
			p_Items[i, i2] = -1
		Next
				
		If p_Class[i] = CLASS_BUBBLE Then ' // BUBBLE KNIGHT
			p_Atk[i] = 10
			p_MP[i] = 8; p_TMP[i] = 10; p_GMP[i] = 8
			p_Life[i] = baseHearts; p_LifeT[i] = baseHearts

		ElseIf p_Class[i] = CLASS_EMBER Then ' // EMBER ROGUE
			p_Atk[i] = 6
			p_MP[i] = 9; p_TMP[i] = 12; p_GMP[i] = 9
			p_Life[i] = baseHearts + .5; p_LifeT[i] = baseHearts + .5
			
		ElseIf p_Class[i] = CLASS_SHOCK Then ' // SHOCK MAGE
			p_Atk[i] = 8
			p_MP[i] = 10; p_TMP[i] = 14; p_GMP[i] = 10		
			p_Life[i] = baseHearts - .5; p_LifeT[i] = baseHearts - .5
			
		EndIf
	Next
	
	'p_Score[0] = 3000
	'p_Score[1] = 3000
	
	' // Lvl 10 Ember ///////////////////
	'p_Lvl[0] = 10
	'p_Atk[0] =16
	'p_MP[0] = 12; p_TMP[0] = 16; p_GMP[0] = 12		
	'p_Life[0] = 4.0; p_LifeT[0] = 4.0
	' ////////////////////

	Rem
	' // Lvl 10 Shock ///////////////////
	p_Lvl[0] = 10
	p_Atk[0] = 16
	p_MP[0] = 13; p_TMP[0] = 20; p_GMP[0] = 13
	p_Life[0] = 3.5; p_LifeT[0] = 3.5
	p_XP[0] = 3700
	
	' ////////////////////	
	EndRem	


	' // Lvl 12 Bubble (LEVEL 31) ///////////////////
	'p_Lvl[0] = 12
	'p_Atk[0] = 20
	'p_MP[0] = 13; p_TMP[0] = 20; p_GMP[0] = 13
	'p_Life[0] = 3.5; p_LifeT[0] = 3.5
	'p_XP[0] = 6150
	'p_SpellL[0] = 2
	' ////////////////////	

	Rem
	If bLooped = 0 Then
	' // Lvl 17 Bubble (LEVEL 50)
	p_Lvl[0] = 17
	p_Atk[0] = 26
	p_MP[0] = 14; p_TMP[0] = 22; p_GMP[0] = 14
	p_Life[0] = 4; p_LifeT[0] = 4
	p_XP[0] = 13270
	p_SpellL[0] = 2	
	
	p_Items[0, 0] = 16
	'p_Items[0, 1] = Rand(18, 31)
	'p_Items[0, 2] = Rand(18, 31)
	'p_Items[0, 3] = Rand(18, 31)
	'p_Items[0, 4] = Rand(18, 31)
	'p_Items[0, 5] = Rand(18, 31)
	p_Item[0] = 0
	EndIf	
	EndRem
	
	'p_XP[0] = 500
	
	'p_Lvl[0] = 5
	'p_Atk[0]:+20
	'p_TMP[0]:+4

	'p_MP[0]
	'p_GMP[0] = 21
	
	'p_Items[0, 0] = 19
	'p_Items[0, 1] = 28
	'p_Items[0, 2] = 19
	'p_Items[0, 3] = 18
	'p_Items[0, 4] = 29
	'p_Item[0] = 0
	
	'p_Items[1, 0] = 31
	'p_Items[1, 1] = 28
	'p_Items[1, 2] = 19
	'p_Items[1, 3] = 6
	'p_Item[1] = 0
		
	'p_Atk[0] = 20
	'p_XP[0] = 100
	'p_XP[1] = 0
	'p_Score[0] = 1500
	'p_Score[1] = 1500
	
	'p_XP[0] = 100
	
	'p_Points[0] = 999999
	
	keyT = GetMilliSecs(); keyTime = Rand(5000, 15000)
	candyT = GetMilliSecs(); candyTime = Rand(5000, 15000)
	ghostT = GetMilliSecs(); ghostC = 0

	ResetActives() ' // Turn off all active items
	
	StopChannel musChan
	musChan = AllocChannel()
	musChan.SetVolume(0)
	musChan = PlayMusic(musSong1, musChan)
	'ResumeChannel musChan
	
	'musChan.SetVolume(Float(cfgMusic) / 5)
	
	bSpecial = False
	bFastMus = False
	bMoney = False
	allDrop = False
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² RESETACTIVES - Turn off all active items                                
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function ResetActives()

	For Local i:Int = 0 To 1
		ACT_GREEN_SWEET[i] = 0
		ACT_BLUE_SWEET[i] = 0
		ACT_RED_SWEET[i] = 0
		ACT_SHOES[i] = 0
		ACT_BROOCH[i] = 0
		ACT_PINK_BOOK[i] = 0
		ACT_DONUT[i] = 0
		ACT_BLUE_AMULET[i] = 0
		ACT_BLUE_BOOK[i] = 0
		ACT_CLOVER[i] = 0
		ACT_GREEN_BOOK[i] = 0
		
	Next
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² HANDLEACTIVES - Creates active spell objects                                
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function HandleActives()

	Local myP:Int
	
	' // Meteor storm (pink book)
	If ACT_PINK_BOOK[0] = 1 Or ACT_PINK_BOOK[1] = 1 Then
		If GetMilliSecs() >= pinkBookT + 250 Then ' // Create meteor
			
			' // Player
			If ACT_PINK_BOOK[0] = 1 Then myP = 0 ElseIf ACT_PINK_BOOK[1] = 1 Then myP = 1
			
			If Rand(0, 1) = 0 Then ' // Top
				shotList.AddLast shot.Create(Rand(-38, 400), -32, SHOT_COMET, Rand(0, 2), myP)
			Else ' // Left
				shotList.AddLast shot.Create(-38, Rand(-32, 332), SHOT_COMET, Rand(0, 2), myP)				
			EndIf

			If pinkBookC < 24 Then ' // 25 total
				pinkBookC:+1
				If pinkBookC = 1 Or pinkBookC Mod 4 = 0 Then PlaySFX sfxComet
			Else
				ACT_PINK_BOOK[0] = 0
				ACT_PINK_BOOK[1] = 0
			EndIf
			
			pinkBookT = GetMilliSecs()
		EndIf
	
	' // Splash storm (blue book)
	ElseIf ACT_BLUE_BOOK[0] = 1 Or ACT_BLUE_BOOK[1] = 1 Then
		If GetMilliSecs() >= blueBookT + 250 Then ' // Create splash
			
			' // Player
			If ACT_BLUE_BOOK[0] = 1 Then myP = 0 ElseIf ACT_BLUE_BOOK[1] = 1 Then myP = 1
			
			'If Rand(0, 1) = 0 Then ' // Top
			'	shotList.AddLast shot.Create(Rand(-38, 400), -32, SHOT_COMET, Rand(0, 2), myP)
			'Else ' // Left
			'	shotList.AddLast shot.Create(-38, Rand(-32, 332), SHOT_COMET, Rand(0, 2), myP)				
			'EndIf

			' // Find available space
			Local tmpX:Int, tmpY:Int, tmpFail:Int = True	
			Repeat
				tmpFail = True
				tmpX = Rand(2, 29); tmpY = Rand(4, 26)
				If arrLev[tmpX, tmpY] = TILE_BLOCK Then
					If arrLev[tmpX, tmpY-1] = 0 Then 
						tmpFail = False
						tmpY:-4
					EndIf
				EndIf
			Until tmpFail = False
			
			shotList.AddLast shot.Create(Int((tmpX * 8) * sclX) - 9, Int((tmpY * 8) * sclY), SHOT_SPOUT, Rand(0, 2), myP)

			If blueBookC < 24 Then ' // 25 total
				blueBookC:+1
				If blueBookC = 1 Or blueBookC Mod 4 = 0 Then PlaySFX sfxSplash
			Else
				ACT_BLUE_BOOK[0] = 0
				ACT_BLUE_BOOK[1] = 0
			EndIf
			
			blueBookT = GetMilliSecs()
		EndIf

	' // Firework storm (green book)
	ElseIf ACT_GREEN_BOOK[0] = 1 Or ACT_GREEN_BOOK[1] = 1 Then
		If GetMilliSecs() >= greenBookT + 250 Then ' // Create splash
			
			' // Player
			If ACT_GREEN_BOOK[0] = 1 Then myP = 0 ElseIf ACT_GREEN_BOOK[1] = 1 Then myP = 1
			
			' // Find available space
			Local tmpX:Int, tmpY:Int, tmpFail:Int = True	
			Repeat
				tmpFail = True
				tmpX = Rand(2, 29); tmpY = Rand(4, 26)
				If arrLev[tmpX, tmpY] = TILE_BLOCK Then
					If arrLev[tmpX, tmpY-1] = 0 Then 
						tmpFail = False
						tmpY:-Rand(1, 3)
					EndIf
				EndIf
			Until tmpFail = False

			Local X:Int = Int((tmpX * 8) * sclX) + 8
			Local Y:Int = Int((tmpY * 8) * sclY)
			s:Shot = New Shot
			s.ID = SHOT_FIREWORK
			s.X = Int(X)
			s.Y = Int(Y)
			s.F = 0; s.T = GetMilliSecs()
			s.D = Rand(0, 2)
			s.Player = myP
			shotList.AddLast s
											
			If greenBookC < 24 Then ' // 25 total
				greenBookC:+1
				If greenBookC = 1 Or greenBookC Mod 4 = 0 Then PlaySFX sfxBomb
			Else
				ACT_GREEN_BOOK[0] = 0
				ACT_GREEN_BOOK[1] = 0
			EndIf
			
			greenBookT = GetMilliSecs()
		EndIf
			
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYERCOL - Handles player to level collision                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlayerCol()

	Local i:Int
	Local tmpSX:Int = 5
	Local tmpSX2:Int = 5
	
	'If p_D[i] = 1 Then tmpSX = 7; tmpSX2 = 7 ' // Offset
	
	For i = 0 To b2Player
		If p_Dead[i] = False Then ' // Dead block
		
		p_Col[i] = -1 ' // Reset collision
	
		' // FLOOR COLLISION
		If (p_J[i] = True And p_YI[i] <= 0) Or (p_J[i] = False And GetMilliSecs() >= p_FT[i] + 150) Then ' // Fall check
			Local bCheck:Int = False
						
			If ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) + tmpSX2, Int(p_Y[i]) + 29, 11, 1) Then
				bCheck = True

				' // Bounds check
				If ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) + tmpSX, Int(p_Y[i]) + 20, 11, 1) Or p_Y[i] < 32 Then 
					bCheck = False
				Else
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) + tmpSX2, Int(p_Y[i]) + 25, 11, 1) Then 
						p_Y[i]:-4
					ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) + tmpSX2, Int(p_Y[i]) + 26, 11, 1) Then 
						p_Y[i]:-3
					ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) + tmpSX2, Int(p_Y[i]) + 27, 11, 1) Then 
						p_Y[i]:-2
					ElseIf ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) + tmpSX2, Int(p_Y[i]) + 28, 11, 1) Then 
						p_Y[i]:-1
					EndIf
				EndIf
				
				If bCheck = True Then p_Y[i] = Int(p_Y[i]); p_YI[i] = 6 ' // Align

			EndIf
			
			If bCheck = True Then ' // Collision hit
				p_Fall[i] = False
				If p_J[i] = True Then ' // Stop jumping
					p_J[i] = False
					If p_D[i] = 1 Then p_F[i] = 0 ElseIf p_D[i] = 0 Then p_F[i] = 16
				EndIf
				p_FT[i] = GetMilliSecs() - 150
			Else ' // Falling
				If p_J[i] = False And p_Fall[i] = False Then 
					p_Fall[i] = True; p_T[i] = GetMilliSecs()
					If p_D[i] = 0 Then p_F[i] = 23 ElseIf p_D[i] = 1 Then p_F[i] = 7
					p_FT[i] = GetMilliSecs()
				EndIf
			EndIf
			
			If bDebug = True Then
				SetColor 255, 0, 0
				DrawRect Int(p_X[i]) + tmpSX2, Int(p_Y[i]) + 32, 11, 1
				DrawRect Int(p_X[i]) + tmpSX, Int(p_Y[i]) + 20, 11, 1
			EndIf
			
		EndIf
			
		' // LEFT SIDE
		If p_D[i] = 0 Then		
			If ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]), Int(p_Y[i]) + 20, 1, 5) Then p_Col[i] = 0
			
			If p_Col[i] = 0 And (p_J[i] = True And p_YI[i] > 0) Then ' // Head check
				If ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) - 4, Int(p_Y[i]), 2, 2) = False Then
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) - 4, Int(p_Y[i]) + 46, 2, 2) = False Then p_Col[i] = -1'; DebugLog "LEFT CHECK"
				EndIf
			EndIf
			
			If bDebug = True Then
				SetColor 255, 0, 0
				DrawRect Int(p_X[i]), Int(p_Y[i]) + 20, 1, 5
				DrawRect Int(p_X[i] - 4), Int(p_Y[i]), 2, 2
				DrawRect Int(p_X[i] - 4), Int(p_Y[i]) + 46, 2, 2
			EndIf
		
		' // RIGHT SIDE
		ElseIf p_D[i] = 1 Then
			If ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) + 35, Int(p_Y[i]) + 20, 1, 5) Then p_Col[i] = 1
			
			If p_Col[i] = 1 And (p_J[i] = True And p_YI[i] > 0) Then ' // Head check
				If ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) + 36, Int(p_Y[i]), 2, 2) = False Then
					If ImageRectCollide(imgLevel, 0, 0, 0, Int(p_X[i]) + 36, Int(p_Y[i]) + 46, 2, 2) = False Then p_Col[i] = -1'; DebugLog "RIGHT CHECK"
				EndIf
			EndIf
			
			If bDebug = True Then
				SetColor 255, 0, 0
				DrawRect Int(p_X[i]) + 35, Int(p_Y[i]) + 20, 1, 5
				DrawRect Int(p_X[i]) + 36, Int(p_Y[i]), 2, 2
				DrawRect Int(p_X[i]) + 36, Int(p_Y[i]) + 46, 2, 2
				
			EndIf
		
		EndIf
				
		If (Int(p_Y[i]) <= 0 Or Int(p_Y[i]) >= 432) And p_Fall[i] = True Then p_Col[i] = p_D[i]
		 
		If p_Y[i] < 32 Then p_Col[i] = -1 ' // No collision at top of screen

		EndIf ' // End dead block
	Next
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETFUNCINPUT - Handles function key input                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetFuncInput()
		
	If KeyHit(KEY_F1) Then ' // Save snapshot
		SaveScreen
	EndIf
	
	' // Can only take a snapshot when paused
	If bPaused[PLAYER_1] = True Or bPaused[PLAYER_2] = True Then Return
	
	If KeyHit(KEY_F2) And nextLevel <> 9 Then ' // Image filter
		If cfgFilter = True Then cfgFilter = False Else cfgFilter = True
		reloadC = 1 ' // Reload all images
		
	ElseIf KeyHit(KEY_F3) Then ' // CRT mode
		If cfgCRT < 4 Then cfgCRT = cfgCRT + 1 Else cfgCRT = 0
		
	ElseIf KeyHit(KEY_F4) Then ' // Debug
		If bDebug = True Then bDebug = False Else bDebug = True
			
	EndIf
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWFLOAT - Renders players floating in bubbles                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawFloat()

	If p_Dead[PLAYER_1] = False Then 
		DrawImage imgFloat, Int(p_X[0]) - 12, Int(p_Y[0]) - 16, floatF + (p_Class[0] * 2)
		
		' // Return to spawn
		If Int(p_X[0]) - 3 > 55 Then 
			p_X[0]:-3.5
		ElseIf Int(p_X[0]) + 3 < 55 Then
			p_X[0]:+3.5
		Else
			p_X[0] = 55
		EndIf

		If Int(p_Y[0]) - 2 > 370 Then 
			p_Y[0]:-2.5
		ElseIf Int(p_Y[0]) + 2 < 370 Then
			p_Y[0]:+2.5
			DebugLog "FDOWN"
		Else
			p_Y[0] = 370
		EndIf
	Else ' // Set offscreen
		p_X[0] = -50
		p_Y[0] = -50
	EndIf
	
	If b2Player = True Then 
		If p_Dead[PLAYER_2] = False Then 
			DrawImage imgFloat, Int(p_X[1]) - 12, Int(p_Y[1]) - 16, floatF + (p_Class[1] * 2)

			If Int(p_X[1]) - 3 > 497 Then 
				p_X[1]:-3.5
			ElseIf Int(p_X[1]) + 3 < 497 Then
				p_X[1]:+3.5
			Else
				p_X[1] = 497
			EndIf

			If Int(p_Y[1]) - 2 > 370 Then 
				p_Y[1]:-2.5
			ElseIf Int(p_Y[1]) + 2 < 370 Then
				p_Y[1]:+2.5
			Else
				p_Y[1] = 370
			EndIf	
		EndIf
	Else ' // Set offscreen
		p_X[1] = -50
		p_Y[1] = -50	
	EndIf
		
	'p_X[0] = 55; p_Y[0] = 386	
	'p_X[1] = 497; p_Y[1] = 386

	If GetMilliSecs() >= floatT + 250 Then
		If floatF = 0 Then floatF = 1 ElseIf floatF = 1 Then floatF = 0
		floatT = GetMilliSecs()
	EndIf

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWLEVEL - Renders level and handles transitions                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawLevel()

	If reloadC <> 0 Then
		If reloadC = 1 Then ' // Reload all images
			LoadImages(cfgFilter)
		ElseIf reloadC = 2 Then ' // Load next level
			LoadLevel(curLevel, 2)
		EndIf
		reloadC = 0
		Cls
	EndIf
	
	' // RENDER BLOCK
	If nextLevel <> 9 Then ' // Playing
		DrawImage imgLevel, 0, 0
		
	Else ' // Transition
		DrawImage imgLevel, 0, Int(levelY)
		DrawImage imgNext, 0, Int(levelY) + 448
		
		If (levelY - 3) > -448 Then 
			levelY:-3
		Else ' // End transition			
			levelY = -448
			 
			reloadC = 1 ' // Swap
			nextLevel = 0 ' // Play
			
			If curLevel < 101 Then
				keyT = GetMilliSecs(); keyTime = Rand(5000, 15000)
				candyT = GetMilliSecs(); candyTime = Rand(5000, 15000)
				ghostT = GetMilliSecs(); ghostC = 0
				
				p_Key[0] = 0; p_Key[1] = 0
			Else
				keyT = -3
				candyTime = -1
				ghostC = -1
				
			EndIf
			
			p_X[0] = 55; p_Y[0] = 370
			p_X[1] = 497; p_Y[1] = 370
			
			FlushInput
		EndIf
	EndIf
	
	' // Level # vs. SHOP vs. BOSS
	If nextLevel <> 9 Then
		SetColor lvlC[0], lvlC[1], lvlC[2]
		If bJBMode = True Then
			DrawFont "JB", 278, 15, 0, True
		ElseIf bXMode = True Then
			DrawFont "X", 278, 15, 0, True		
		EndIf
		
		Local tmpStr:String = ""
		If curLevel < 101 Then
			If Len(String(curLevel)) = 1 Then tmpStr$ = "0"
			DrawFont tmpStr$ + String(curLevel), 278, 30, 0, True
			
		ElseIf curLevel < 201 Then
			DrawFont "SHOP", 260, 30, 0, True
			
			If curLevel = 101 Then 
				DrawFont "EXIT", 260, 416, 0, False

				SetColor 255, 255, 255
				If bMoney = True Then
					DrawFont "Buy somethin' will ya!", -1, 112, 0, True
				Else
					DrawFont "Hey! Watch it, Bub", -1, 112, 0, True
				EndIf
				
				DrawImage imgDoor, 276, 352, 0

			ElseIf curLevel = 102 Then
				DrawFont "BOSS", 260, 416, 0, False

				SetColor 255, 255, 255
				If bMoney = True Then
					If lastLevel = 50 Then
						DrawFont "End of the road, Bub!", -1, 112, 0, True
					Else
						DrawFont "There's trouble ahead!", -1, 112, 0, True
					EndIf
				Else
					DrawFont "Hey! Watch it, Bub", -1, 112, 0, True					
				EndIf

				DrawImage imgDoor, 276, 352, 1

			EndIf
		
		ElseIf curLevel < 301 Then ' // Boss
			DrawFont "BOSS", 260, 30, 0, True
				
		EndIf
		
		SetColor 255, 255, 255
	EndIf

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWTITLE - Renders title screen                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawTitle()

	'bTitleDrop = False
	'b2Player = True
	
	Local bExit:Int = False
	Local phase:Int = 1
	
	bLooped = 0 ' // Game reset
	bJBMode = False ' // JB Mode
	bXMode = False ' // X Mode
	
	If bTitleDrop = True Then PlaySFX sfxTitle	
	Local logoX:Int = 0, logoY:Float = -228
	If bTitleDrop = False Then logoY = 16
	
	FlushInput
	
	Local titleT:Int = GetMilliSecs()
	Local selT:Int = GetMilliSecs()
	
	Local cSel1:Int = 0
	Local cSel2:Int = 2
	
	Local bSel1:Int = False
	Local bSel2:Int = False
	
	Local p1Ang:Float = Rand(0, 359)
	Local p2Ang:Float = Rand(0, 359)	
	
	Local musTime:Int, bMus:Int
	Local flashT:Int, flashF:Int = Rand(8, 11)
	
	Local cTime:Int

	Local pCheck:Int = False
	
	For p:Part = EachIn partList ' Check for bubbles from name entry
		If p.ID = PART_TBUB Then pCheck = True Else partList.Remove p
	Next 
	
	' // Delete all types
	For o:Obj = EachIn objList; objList.Remove o; Next 
	For s:Shot = EachIn shotList; shotList.Remove s; Next
	For b:Bub = EachIn bubList; bubList.Remove b; Next
	
	If pCheck = True Then ' // Coming from name entry
		PlaySFX sfxOver
		
	Else ' // Create bubbles
		For Local i:Int = 0 To 39
			Local p:Part = New Part
			p.ID = PART_TBUB; p.X = Rand(0, 570); p.Y = Rand(0, 430)
			p.F = Rand(0, 3); p.D = Rand(0, 2); p.T = GetMilliSecs() - Rand(0, 200)
			partList.AddLast p	
		Next
	EndIf
	
	Local tScreen:Int = 0, tSel:Int = 0, menuY:Int = 252
		
	Local secretC:String = "" ' // Secret code
	
	Repeat
		Cls
		If reloadC <> 0 Then
			If reloadC = 1 Then LoadImages(cfgFilter) ' // Reload all images			
			reloadC = 0
			Cls
		EndIf

		If tScreen < 4 Then
			For p:Part = EachIn partList ' // Render back particles
				p.Render
			Next 
		EndIf
		
		If tScreen = 0 Then ' // Logo
			If phase = 1 Then
				DrawImage imgTitle, Int(294 - ((ImageWidth(imgTitle) * sclX) / 2)), Int(logoY)
			EndIf
			
		ElseIf tScreen >= 4 Then ' // Tutorial
			SetScale 1, 1
			If tScreen = 4 Then
				DrawImage imgTut1, 0, 0
			ElseIf tScreen = 5 Then
				DrawImage imgTut2, 0, 0
			ElseIf tScreen = 6 Then
				DrawImage imgTut3, 0, 0
			EndIf
			SetScale sclX, sclY
		EndIf
		
		If bTitleDrop = True Then
			If GetMilliSecs() >= titleT + 1300 Then
				If Int(logoY + 2) < 16 Then logoY:+2 Else logoY = 16; bTitleDrop = False
			EndIf
		EndIf
					
		If bTitleDrop = False And phase = 1 Then	
			Local bJoyUp:Int = -1
			Local bJoyDown:Int = -1
			Local bJoyLeft:Int = -1
			Local bJoyRight:Int = -1

			If GetInput(PLAYER_1, INP_U) = True And bJoy1YHit = False Then bJoyUp = PLAYER_1; secretC$:+"U" 			
			If GetInput(PLAYER_1, INP_D) = True And bJoy1YHit = False Then bJoyDown = PLAYER_1; secretC$:+"D"				
			If GetInput(PLAYER_1, INP_L) = True And bJoy1XHit = False Then bJoyLeft = PLAYER_1; secretC$:+"L"
			If GetInput(PLAYER_1, INP_R) = True And bJoy1XHit = False Then bJoyRight = PLAYER_1; secretC$:+"R"

			SetColor 255, 255, 255
			If tScreen = 0 Then ' // Title
				menuY  = 252			
				
				'DrawFont "v1.0", 508, 424, 0, True
				
				DrawFont "  1 Player", -1, menuY, 0, True
				DrawFont "  2 Player", -1, menuY + 28, 0, True
				DrawFont "  Hi Score", -1, menuY + (28 * 2), 0, True
				DrawFont "  Options ", -1, menuY + (28 * 3), 0, True
				DrawFont "  Tutorial", -1, menuY + (28 * 4), 0, True
				DrawFont "  End Game", -1, menuY + (28 * 5), 0, True

				SetBlend LIGHTBLEND; SetAlpha .95
				DrawImage imgBubble, 196, (menuY - 7) + (28 * tSel), 2
				SetBlend ALPHABLEND; SetAlpha 1
				
				SetColor 252, 130, 116
				DrawFont "     Eiksoft.com", -1, 424, 0, True
				SetColor 255, 255, 255
				DrawFont "2024            ", -1, 424, 0, True		
			
			ElseIf tScreen = 2 Then ' // Hi scores
				
				If netP > 0 Then DrawFont "$", 546, 28
				If netP < 90 Then DrawFont "+", 546, 424

				DrawImage imgItems, 95, 12, flashF
				DrawImage imgItems, 454, 12, flashF
				
				If GetMilliSecs() >= flashT + 60 Then
					Local tmpF:Int
					Repeat
						tmpF = Rand(8, 11)
					Until tmpF <> flashF
					flashF = tmpF
					flashT = GetMilliSecs()
				EndIf
				
				DrawFont "Online Top 100", -1, 28, 0, True

				DrawFont "  #    NAME     LVL      SCORE", 24, 55, 0, True
				
				' // Draw online scores
				Local tmpY:Int = 78
				For Local i:Int = netP To netP + 9
					If i = 0 Then 
						'SetColor 252, 130, 116
						SetColor 92, 230, 52
					Else
						SetColor 252, 252, 252
					EndIf
					
					If net_Score[i] <> "" Then
						Local tmpSpl:String[] = net_Score[i].Split("_")						
						DrawFont RSet$(String(i + 1), 3) + "    " + tmpSpl[1] + " " + RSet$(tmpSpl[3], 3) + " " + RSet$(NumFormat(tmpSpl[0]), 10), 24, tmpY, 0, True
						'DrawFont "100" + "    " + "EIKON123" + " " + "100" + " " + "10,000,000", 24, tmpY, 0, True
						SetColor 255, 255, 255
						DrawImage GetClassImg(Int(tmpSpl[2])), 95, tmpY - 7, 7
					Else
						DrawFont RSet$(String(i + 1), 3), 24, tmpY, 0, True
					EndIf
					
					tmpY:+36
				Next
							
			ElseIf tScreen = 3 Then ' // Options					
				menuY:Int = 103
				Local tmpS:String
				
				SetColor 252, 252, 252
				DrawFont "  SFX     ", -1, menuY, 0, True
				DrawFont String(cfgSFX * 10) + "%", 362, menuY, 0, True
				
				DrawFont "  Music   ", -1, menuY + 28, 0, True
				DrawFont String(cfgMusic * 10) + "%", 362, menuY + 28, 0, True

				DrawFont "  Track   ", -1, menuY + (28 * 2), 0, True
				If cfgTrack = 0 Then tmpS$ = "BB1" Else tmpS$ = "BB2"
				DrawFont tmpS$, 362, menuY + (28 * 2), 0, True

				DrawFont "  GFX     ", -1, menuY + (28 * 3), 0, True
				If cfgGFX = 0 Then tmpS$ = "GL" Else tmpS$ = "D3D"
				DrawFont tmpS$, 362, menuY + (28 * 3), 0, True
				
				DrawFont "  Filter  ", -1, menuY + (28 * 4), 0, True
				If cfgFilter = 0 Then tmpS$ = "Off" Else tmpS$ = "On"
				DrawFont tmpS$, 362, menuY + (28 * 4), 0, True
				
				DrawFont "  CRT     ", -1, menuY + (28 * 5), 0, True
				If cfgCRT = 0 Then tmpS$ = "0%" ElseIf cfgCRT = 1 Then tmpS$ = "25%" ElseIf cfgCRT = 2 Then tmpS$ = "50%" ElseIf cfgCRT = 3 Then tmpS$ = "75%" ElseIf cfgCRT = 4 Then tmpS$ = "100%"
				DrawFont tmpS$, 362, menuY + (28 * 5), 0, True
				
				If cfgFull = 0 Then
					DrawFont "  Window  ", -1, menuY + (28 * 6), 0, True
				Else
					DrawFont "  Full    ", -1, menuY + (28 * 6), 0, True
				EndIf

				If cfgDiff = 0 Then
					DrawFont "  Easy    ", -1, menuY + (28 * 7), 0, True
				ElseIf cfgDiff = 1 Then
					DrawFont "  Normal  ", -1, menuY + (28 * 7), 0, True
				EndIf

				DrawFont "  Back    ", -1, menuY + (28 * 8), 0, True
				SetColor 255, 255, 255

				SetBlend LIGHTBLEND; SetAlpha .95
				DrawImage imgBubble, 196, (menuY - 7) + (28 * tSel), 2
				SetBlend ALPHABLEND; SetAlpha 1
				
				If tSel = 2 Or tSel = 3 Or tSel = 6 Then
					SetColor 255, 255, 255
					DrawFont "Requires Restart", -1, 424, 0, True						
				EndIf
				
			EndIf		
			
			If bJoyDown = 0 Then
				If tScreen = 0 Then
					If tSel < 5 Then tSel:+1 Else tSel = 5
				ElseIf tScreen = 2 Then
					If netP < 90 Then netP:+10				
				ElseIf tScreen = 3 Then
					If tSel < 8 Then tSel:+1 Else tSel = 8				
				EndIf
			
				bJoy1YHit = True
			
			ElseIf bJoyUp = 0 Then
				If tScreen = 0 Or tScreen = 3 Then
					If tSel > 0 Then tSel:-1 Else tSel = 0
				ElseIf tScreen = 2 Then
					If netP > 0 Then netP:-10				
				EndIf
				
				bJoy1YHit = True
			EndIf

			If tScreen = 0 Then
				If GetInput(PLAYER_1, INP_A) = True Then secretC$:+"A"
			EndIf
					
			' // Accept
			If GetInput(PLAYER_1, INP_S) = True Or GetInput(PLAYER_1, INP_B) = True Then 
				If tScreen = 0 Then

					If tSel = 0 Then ' // 1 player
						b2Player = False
						phase = 2
					
						PlaySFX sfxBubble; FlushInput
						
					ElseIf tSel = 1 Then ' // 2 player
						b2Player = True
						phase = 2
						
						PlaySFX sfxBubble; FlushInput
					
					ElseIf tSel = 2 Then ' // Hi Scores
						If LoadScores() = True Then
							tSel = 0
							tScreen = 2
						EndIf
						FlushInput
						
					ElseIf tSel = 3 Then ' // Options
						tScreen = 3
						tSel = 0
						
						PlaySFX sfxBubble; FlushInput
						
					ElseIf tSel = 4 Then ' // Tutorial
						tScreen = 4
						tSel = 0

						PlaySFX sfxBubble; FlushInput
						
					ElseIf tSel = 5 Then ' // End game
						bExit = True
						
					EndIf

				ElseIf tScreen = 2 Then ' // Hi scores
					PlaySFX sfxPoof
					
					tSel = 0
					tScreen = 0
						
					FlushInput
								
				ElseIf tScreen = 3 Then ' // Options
					If tSel = 0 Then ' // SFX
						If cfgSFX < 10 Then cfgSFX = cfgSFX + 1 Else cfgSFX = 0
					
					ElseIf tSel = 1 Then ' // Music
						If cfgMusic < 10 Then cfgMusic = cfgMusic + 1 Else cfgMusic = 0

					ElseIf tSel = 2 Then ' // Track
						If cfgTrack = 0 Then cfgTrack = 1 Else cfgTrack = 0

					ElseIf tSel = 3 Then ' // GFX
						If cfgGFX = 0 Then cfgGFX = 1 Else cfgGFX = 0
					
					ElseIf tSel = 4 Then ' // Filter
						If cfgFilter = 0 Then cfgFilter = 1 Else cfgFilter = 0
						reloadC = 1 ' // Reload all images
						
					ElseIf tSel = 5 Then ' // CRT
						If cfgCRT < 4 Then cfgCRT = cfgCRT + 1 Else cfgCRT = 0
						
					ElseIf tSel = 6 Then ' // Full
						If cfgFull = 0 Then cfgFull = 1 Else cfgFull = 0
					
					ElseIf tSel = 7 Then ' // Diff
						If cfgDiff = 0 Then cfgDiff = 1 Else cfgDiff = 0
						
					ElseIf tSel = 8 Then ' // Back
						tScreen = 0
						
						FlushInput
						
					EndIf					
					
					If tSel <> 8 Then PlaySFX sfxBubble Else PlaySFX sfxPoof; tSel = 0
								
				ElseIf tScreen = 4 Then ' // Tutorial 1
					PlaySFX sfxBubble
					tScreen = 5
					
				ElseIf tScreen = 5 Then ' // Tutorial 2
					PlaySFX sfxBubble				
					tScreen = 6
				
				EndIf
			
			ElseIf GetInput(PLAYER_1, INP_A) = True Then
				
				If tScreen >= 4 Then 
					tScreen = 0
					
					PlaySFX sfxPoof
					FlushInput					
				EndIf
				
			EndIf
			
			If Right$(secretC$, 9) = "DADDADDAD" Then ' // JB Mode
				If bJBMode = False Then
					PlaySFX sfxLevel
					bJBMode = True
				EndIf				
			ElseIf Right$(secretC$, 9) = "UDAAUAADU" ' // X Mode
				If bXMode = False Then
					PlaySFX sfxGhost
					bXMode = True
				EndIf			
			EndIf				
			
			' // Reset joysticks
			If JoyY(p1Joy) <= .5 And JoyY(p1Joy) >= -.5 Then 
				bJoy1YHit = False ' // Reset joystick
			EndIf
			
			If JoyX(p1Joy) <= .5 And JoyX(p1Joy) >= -.5 Then 
				bJoy1XHit = False ' // Reset joystick
			EndIf			
		
		ElseIf bTitleDrop = False And phase = 2 ' // Class select
		
			DrawFont "Choose Your Dragon", -1, 81, 0, True
			
			DrawImage imgChars, 13, 224 - ((ImageHeight(imgChars) * sclY) / 2), 0
			DrawImage imgChars, 204, 224 - ((ImageHeight(imgChars) * sclY) / 2), 1
			DrawImage imgChars, 395, 224 - ((ImageHeight(imgChars) * sclY) / 2), 2
			
			If GetMilliSecs() >= selT + 80 Then
				' // Player 1 select
				If cSel1 = 0 Then
					DrawImage imgCSel, 13, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 0
				ElseIf cSel1 = 1 Then
					DrawImage imgCSel, 204, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 0
				ElseIf cSel1 = 2 Then
					DrawImage imgCSel, 395, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 0
				EndIf
				
				' // Player 2 select
				If b2Player = True Then
					If cSel2 = 0 Then
						DrawImage imgCSel, 13, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 1
					ElseIf cSel2 = 1 Then
						DrawImage imgCSel, 204, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 1
					ElseIf cSel2 = 2 Then
						DrawImage imgCSel, 395, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 1
					EndIf			
				EndIf
				
				If GetMilliSecs() >= selT + 160 Then selT = GetMilliSecs()
			EndIf
			
			If bSel1 = True Then ' // Selected
				If cSel1 = 0 Then
					DrawImage imgCSel, 13, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 0
				ElseIf cSel1 = 1 Then
					DrawImage imgCSel, 204, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 0
				ElseIf cSel1 = 2 Then
					DrawImage imgCSel, 395, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 0
				EndIf			
			EndIf
			If bSel2 = True And b2Player = True Then ' // Selected
				If cSel2 = 0 Then
					DrawImage imgCSel, 13, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 1
				ElseIf cSel2 = 1 Then
					DrawImage imgCSel, 204, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 1
				ElseIf cSel2 = 2 Then
					DrawImage imgCSel, 395, 224 - ((ImageHeight(imgCSel) * sclY) / 2), 1
				EndIf				
			EndIf
			
			Local bJoy1Left:Int = -1, bJoy2Left:Int = -1
			Local bJoy1Right:Int = -1, bJoy2Right:Int = -1

			If GetInput(PLAYER_1, INP_L) = True And bJoy1XHit = False Then bJoy1Left = True
			If GetInput(PLAYER_1, INP_R) = True And bJoy1XHit = False Then bJoy1Right = True
			
			If b2Player = True Then
				If GetInput(PLAYER_2, INP_L) = True And bJoy2XHit = False Then bJoy2Left = True
				If GetInput(PLAYER_2, INP_R) = True And bJoy2XHit = False Then bJoy2Right = True

				If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_S) = True Then
					bSel2 = True
					PlaySFX sfxBubble
				EndIf
				
				If bJoy2Left = True And bSel2 = False Then
					If cSel2 > 0 Then
						cSel2:-1
						If cSel1 > 0 Then cSel2 = 0 Else cSel2 = cSel1 + 1
					EndIf
					bJoy2XHit = True
				EndIf

				If bJoy2Right = True And bSel2 = False Then
					If cSel2 < 2 Then
						cSel2:+1
						If cSel1 < 2 Then cSel2 = 2 Else cSel2 = cSel1 - 1
					EndIf
					bJoy2XHit = True				
				EndIf				
			EndIf
			
			If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_S) = True Then
				bSel1 = True
				PlaySFX sfxBubble
			EndIf
				
			If bJoy1Left = True And bSel1 = False Then
				If cSel1 > 0 Then
					cSel1:-1
					If b2Player = True And cSel1 = cSel2 Then
						If cSel2  > 0 Then cSel1 = 0 Else cSel1 = cSel2 + 1
					EndIf
				EndIf
				bJoy1XHit = True
			EndIf

			If bJoy1Right = True And bSel1 = False Then
				If cSel1 < 2 Then
					cSel1:+1
					If b2Player = True And cSel1 = cSel2 Then
						If cSel2 < 2 Then cSel1 = 2 Else cSel1 = cSel2 - 1
					EndIf
				EndIf
				bJoy1XHit = True				
			EndIf			
			
			If JoyX(p1Joy) <= .5 And JoyX(p1Joy) >= -.5 Then 
				bJoy1XHit = False ' // Reset joystick
			EndIf
			
			If JoyX(p2Joy) <= .5 And JoyX(p2Joy) >= -.5 Then 
				bJoy2XHit = False ' // Reset joystick
			EndIf
			
			' // Select class
			If b2Player = False Then
				If bSel1 = True Then 
					p_Class[PLAYER_1] = cSel1
					phase = 3
				EndIf
				
			ElseIf b2Player = True Then
				If bSel1 = True And bSel2 = True Then
					p_Class[PLAYER_1] = cSel1
					p_Class[PLAYER_2] = cSel2
					phase = 3
				EndIf
				
			EndIf
			
			If phase = 3 Then ' // Cinema
				FlushInput

				If musType$ = "bb1" Then ' // BB1 track
					StopChannel musChan
					musChan = AllocChannel()
					musChan.SetVolume(Float(cfgMusic) / 15)					
					musChan = PlayMusic(musStart, musChan)
				EndIf
				
				For p:Part = EachIn partList ' // Clear title bubbles
					partList.Remove p
				Next 				
				
				cTime = GetMilliSecs()
				musTime = GetMilliSecs(); bMus = False
							
			EndIf

		ElseIf bTitleDrop = False And phase = 3 ' // Cinema
			
			If musType$ = "bb2" And bMus = False Then ' // Delay BB2 track
				If GetMilliSecs() >= musTime + 3000 Then
					StopChannel musChan
					musChan = AllocChannel()
					musChan.SetVolume(Float(cfgMusic) / 15)					
					musChan = PlayMusic(musStart, musChan)
				
					bMus = True
				EndIf
			EndIf
			
			DrawImage imgStart, 0, 0
			
			DrawImage imgFloat, Float(50 * Cos(p1Ang)) + 100, Float(50 * Sin(p1Ang)) + 200, floatF + (p_Class[0] * 2)
			p1Ang:+2
			
			If b2Player = True Then
				DrawImage imgFloat, Float(50 * Cos(p2Ang)) + 424, Float(50 * Sin(p2Ang)) + 200, floatF + (p_Class[1] * 2)
				p2Ang:-2
			EndIf

			If GetMilliSecs() >= floatT + 250 Then
				If floatF = 0 Then floatF = 1 ElseIf floatF = 1 Then floatF = 0
				floatT = GetMilliSecs()
			EndIf
			
			If GetMilliSecs() >= cTime + 5500 Then
				p_X[0] = Int((50 * Cos(p1Ang)) + 100); p_Y[0] = Int(50 * Sin(p1Ang)) + 200
				p_Dead[0] = False
				If b2Player = True Then
					p_X[1] = Int(50 * Cos(p2Ang)) + 424; p_Y[1] = Int(50 * Sin(p2Ang)) + 200
					p_Dead[1] = False
				EndIf
				phase =  4 ' // Start
			EndIf
		EndIf	
		
		If KeyDown(KEY_ESCAPE) Or AppTerminate() = True Then bExit = True

		GetFuncInput() ' // Function Keys
	
		DrawOverlay() ' // Overlay graphics
	
		If GetMilliSecs() >= fpsTimer + 1000 Then FPS = curFrames; curFrames = 0; fpsTimer = GetMilliSecs()
		curFrames = curFrames + 1
	
		Flip -1 
	Until bTitle = False Or bExit = True Or phase = 4

	If bExit = True Then EndGame()
	
	For p:Part = EachIn partList ' // Clear title bubbles
		partList.Remove p
	Next 
	
	NewGame(True)	
	bTitle = False
	
	FlushInput

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWPLAYERS - Draw players                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawPlayers()

	' // OVERLAP CHECK	
	'Local tmpCheck:Int = False
	'If b2Player = True Then tmpCheck = ImagesCollide2(imgBub, Int(p_X[0]), Int(p_Y[0]), p_F[0], 0, sclX, sclY, imgBob, Int(p_X[1]), Int(p_Y[1]), p_F[1], 0, sclX, sclY)
	
	' // BLEND PLAYERS
	'If tmpCheck = True Then SetBlend LIGHTBLEND; SetAlpha .99
	
	For Local i:Int = 0 To b2Player
		If p_Dead[i] <> False Then ' // Dead
			p_Zap[i] = False
			p_Flame[i] = False
			p_BombC[i] = 0

			If p_Dead[i] < 3 Then
				DrawImage GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), p_F[i]
				
				If GetMilliSecs() >= p_T[i] + 130 Then
					If p_D[i] = 1 Then
						If p_F[i] < 12 Then p_F[i]:+1 Else p_Dead[i]:+1; p_F[i] = 9
					ElseIf p_D[i] = 0 Then
						If p_F[i] < 28 Then p_F[i]:+1 Else p_Dead[i]:+1; p_F[i] = 25
					EndIf
					p_T[i] = GetMilliSecs()
					If p_Dead[i] = 3 Then p_F[i] = 0
				EndIf
			ElseIf p_Dead[i] = 3 Then
				DrawImage imgBlip, Int(p_X[i]), Int(p_Y[i]), p_F[i]
				
				If GetMilliSecs() >= p_T[i] + 130 Then
					If p_F[i] < 1 Then 
						p_F[i]:+1 
					Else 
						p_Dead[i] = 4 ' // Perma
						p_X[i] = -50
						p_Y[i] = -50

						If b2Player = True Then ' // Swap keys
							If i = 0 And p_Dead[1] = False Then
								If p_Key[0] = 1 Then p_Key[1] = 1; p_Key[0] = 0
							ElseIf i = 1 And p_Dead[0] = False Then
								If p_Key[1] = 1 Then p_Key[0] = 1; p_Key[1] = 0
							EndIf
						EndIf
						
					EndIf
				EndIf
				
			EndIf
			
		ElseIf p_Hurt[i] = False Then ' // Invul check
			If p_Charge[i] = -1 Then p_Charge[i] = 0
			If p_Life[i] > 1 Then p_Warn[i] = False
			
			Local tmpF:Int = p_F[i]
			If p_Zap[i] = True Or p_Flame[i] = True Then ' // Zapped / flamed
				If p_D[i] = 1 Then tmpF = 9 ElseIf p_D[i] = 0 Then tmpF = 25
			EndIf
			
			If p_Charge[i] <= 0 Then
				If p_Warn[i] = True Then ' // Low health warning
					If GetMilliSecs() >= p_WarnT[i] + 200 Then
						DrawImage imgC2, Int(p_X[i]), Int(p_Y[i]), tmpF'p_F[i]
						If GetMilliSecs() >= p_WarnT[i] + 400 Then p_WarnT[i] = GetMilliSecs()
					Else
						DrawImage GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), tmpF'p_F[i]
					EndIf
				Else
					DrawImage GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), tmpF'p_F[i]
				EndIf
			Else ' // CHARGING
				If p_Charge[i] < 4 Then
					If p_Warn[i] = True Then ' // Low health warning
						If GetMilliSecs() >= p_WarnT[i] + 200 Then
							DrawImage imgC2, Int(p_X[i]), Int(p_Y[i]), tmpF'p_F[i]
							If GetMilliSecs() >= p_WarnT[i] + 400 Then p_WarnT[i] = GetMilliSecs()
						Else
							DrawImage GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), tmpF'p_F[i]
						EndIf
					Else				
						DrawImage GetClassImg(p_Class[i]), Int(p_X[i]), Int(p_Y[i]), tmpF'p_F[i]
					EndIf
				Else
					Local remain:Int = p_Charge[i] Mod 2
					If remain = 0 Then
						DrawImage imgC1, Int(p_X[i]), Int(p_Y[i]), tmpF'p_F[i]
					Else
						DrawImage imgC2, Int(p_X[i]), Int(p_Y[i]), tmpF'p_F[i]
					EndIf
				EndIf
				
				If GetMilliSecs() >= p_ChargeT[i] + 60 Then
					p_Charge[i]:+1
					p_ChargeT[i] = GetMilliSecs()
				EndIf
			EndIf
		Else
			'If p_Charge[i] > 0 Then
			'	p_Charge[i] = -1
			'	If ChannelPlaying(chargeChan[i]) = True Then StopChannel chargeChan[i]; chargeChan[i] = AllocChannel()
			'EndIf
			
			Local tmpImg:TImage = GetClassImg(p_Class[i])
			If p_Charge[i] > 0 Then
				If p_Charge[i] > 4 Then
					Local remain:Int = p_Charge[i] Mod 2
					If remain = 0 Then tmpImg = imgC1 Else tmpImg = imgC2
				EndIf
				
				If GetMilliSecs() >= p_ChargeT[i] + 60 Then
					p_Charge[i]:+1
					p_ChargeT[i] = GetMilliSecs()
				EndIf
			EndIf
						
			If GetMilliSecs() >= p_HurtT[i] + 300 Then
				Local tmpF:Int = p_F[i]
				If p_Zap[i] = True Or p_Flame[i] = True Then ' // Zapped / flamed
					If p_D[i] = 1 Then tmpF = 9 ElseIf p_D[i] = 0 Then tmpF = 25
				EndIf
				
				If Rand(0, 1) = 0 Then DrawImage tmpImg, Int(p_X[i]), Int(p_Y[i]), tmpF'p_F[i]
			Else
				Local tmpF:Int = 9
				If p_D[i] = 0 Then tmpF = 25
				If Rand(0, 1) = 0 Then DrawImage tmpImg, Int(p_X[i]), Int(p_Y[i]), tmpF
			EndIf
			If GetMilliSecs() >= p_HurtT[i] + 1000 Then 
				p_Hurt[i] = False ' // Back to normal				
				If p_Life[i] <= 1.0 Then ' // Low health warning
					If p_Warn[i] = False Then p_WarnT[i] = GetMilliSecs()
					p_Warn[i] = True
				EndIf
			EndIf		
			
		EndIf ' // END DEAD BLOCK

		' // Bomb spell
		If p_BombC[i] <> 0 Then
			If GetMilliSecs() >= p_BombT[i] + 1000 Then
				If p_BombC[i] < 5 Then
					shotList.AddLast shot.Create(Int(p_X[i]), Int(p_Y[i]), SHOT_BOMB, i)
					p_BombC[i]:+1
				Else
					p_BombC[i] = 0
				EndIf
				p_BombT[i] = GetMilliSecs()
			EndIf
		EndIf		
		
	Next
			
	SetBlend ALPHABLEND; SetAlpha 1
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWKEEPER - Draws shop keeper
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawKeeper()

	Local tmpF:Int = 8
	
	' // Shop type
	'If curLevel = 101 Then tmpF = 8 ElseIf curLevel = 102 Then tmpF = 4
	DrawImage imgMighta, 515, 146, tmpF + keeperF
	
	If b2Player = True Then ' // Graves
		If p_Dead[0] = 4 Then
			DrawImage imgGrave, 55, 386
		ElseIf p_Dead[1] = 4 Then
			DrawImage imgGrave, 497, 386
		EndIf
	EndIf
	
	If GetMilliSecs() >= keeperT + 130 Then
		If keeperF = 0 Then keeperF = 1 Else keeperF = 0
		keeperT = GetMilliSecs()
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWSTATS - Draws player status screen
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawStats()

	If p_Dead[PLAYER_1] = False Then
		DrawImage imgMenu, 55, 64

		SetColor lvlC[0], lvlC[1], lvlC[2]
		DrawFont "Level " + p_Lvl[0], 86, 96, 0, 1
		DrawFont "BP " + Int(p_ATK[0] * 2), 104, 128, 0, 1
		DrawFont "MP " + Int(p_TMP[0] * 2), 104, 160, 0, 1
		DrawFont "HP " + Int(p_LifeT[0] * 2), 104, 192, 0, 1
		DrawFont "XP  " + Int(p_XP[0]), 86, 224, 0, 1
		DrawFont "   /" + GetLevelXP(p_Lvl[0]), 86, 240, 0, 0
		DrawFont NumFormat(String(p_Points[0])), 86, 272, 0, 1
		SetColor 255, 255, 255
		
		'Local tmpS:String
		'If p_Class[0] = CLASS_BUBBLE Then
		'	tmpS$ = "B.BOUNCE"
		'ElseIf p_Class[0] = CLASS_EMBER Then
		'	tmpS$ = "FIREBALL"
		'ElseIf p_Class[0] = CLASS_SHOCK Then
		'	tmpS$ = "SHOCKWAVE"
		'EndIf
		
		'DrawFont tmpS$, 93, 224, 0, 1
		
		SetScale 1, 1
		DrawImage imgStats, 85, 129, p_Class[0]
		DrawImage imgStats, 85, 161, p_Class[0] + 3
		DrawImage imgStats, 85, 193, p_Class[0] + 6
		SetScale sclX, sclY
	EndIf
	
	If b2Player = True And p_Dead[PLAYER_2] = False Then
		DrawImage imgMenu, 313, 64

		SetColor lvlC[0], lvlC[1], lvlC[2]
		DrawFont "Level " + p_Lvl[1], 343, 96, 0, 1
		DrawFont "BP " + Int(p_ATK[1] * 2), 362, 128, 0, 1
		DrawFont "MP " + Int(p_TMP[1] * 2), 362, 160, 0, 1
		DrawFont "HP " + Int(p_LifeT[1] * 2), 362, 192, 0, 1
		DrawFont "XP  " + Int(p_XP[1]), 343, 224, 0, 1
		DrawFont "   /" + GetLevelXP(p_Lvl[1]), 343, 240, 0, 0
		DrawFont NumFormat(String(p_Points[1])), 343, 272, 0, 1	
		SetColor 255, 255, 255

		SetScale 1, 1
		DrawImage imgStats, 342, 129, p_Class[1]
		DrawImage imgStats, 342, 161, p_Class[1] + 3
		DrawImage imgStats, 342, 193, p_Class[1] + 6
		SetScale sclX, sclY
		
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² EnterName - Enter name for high scores
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function EnterName(myP:Int)
	
	FlushInput
	
	Local tScreen:Int = 0
	Local tSelX:Int = 141, tSelY:Int = 126, hi_A:Int
	
	Local tmpName:String = ""
	
	Local bExit:Int = False

	Local pCheck:Int = False
	
	For p:Part = EachIn partList ' Check for bubbles from name entry
		If p.ID = PART_TBUB Then pCheck = True Else partList.Remove p
	Next 
	
	If pCheck = False Then ' // Create bubbles
		For Local i:Int = 0 To 39
			Local p:Part = New Part
			p.ID = PART_TBUB; p.X = Rand(0, 570); p.Y = Rand(0, 430)
			p.F = Rand(0, 3); p.D = Rand(0, 2); p.T = GetMilliSecs() - Rand(0, 200)
			partList.AddLast p	
		Next
	EndIf
		
	Repeat
		Cls
		If reloadC <> 0 Then
			If reloadC = 1 Then LoadImages(cfgFilter) ' // Reload all images			
			reloadC = 0
			Cls
		EndIf
				
		For p:Part = EachIn partList ' // Render back particles
			p.Render
		Next 
		
		If b2Player = True Then
			DrawFont "Player " + String(myP + 1) + ", Enter your name", -1, 64, 0, True
		Else
			DrawFont "Enter your name", -1, 64, 0, True
		EndIf
				 
		DrawFont tmpName$, -1, 314, 0, True
		
		Local tmpA:Int = 65
		For Local tmpY:Int = 126 To 311 Step 42
			For Local tmpX:Int = 141 To 435 Step 48
				If tSelX = tmpX And tSelY = tmpY Then ' // Current letter
					'SetColor Rand(128, 255), 0, 0
					hi_A = tmpA
				Else
					SetColor 252, 252, 252
				EndIf
				DrawFont Chr(tmpA), tmpX, tmpY, 0, True
				If tmpA < 90 Then tmpA:+1 Else Exit
			Next
			If tmpA = 90 Then Exit
		Next
		
		DrawFont "-", 381, 252, 0, True
		
		If tSelX = 429 And tSelY = 252 Then 
			SetColor 252, 130, 116  'SetColor Rand(78, 255), 0, 0 Else SetColor 255, 255, 255
		Else
			SetColor 255, 255, 255
			DrawImage imgBubble, tSelX - 11, tSelY - 6, 3

			'			
			'DrawImage imgHi, Int(tSelX - 10), Int(tSelY - 6)
		EndIf

		DrawFont "END", 429, 252, 0, True
		SetColor 255, 255, 255
		
		'DebugLog "TSelX: " + tSelX + " TSelY: " + tSelY

		Local bJoyUp:Int = -1
		Local bJoyDown:Int = -1
		Local bJoyLeft:Int = -1
		Local bJoyRight:Int = -1
		
		If GetInput(myP, INP_U) = True And bJoy1YHit = False Then bJoyUp = PLAYER_1 
		If GetInput(myP, INP_D) = True And bJoy1YHit = False Then bJoyDown = PLAYER_1
		If GetInput(myP, INP_L) = True And bJoy1XHit = False Then bJoyLeft = PLAYER_1			
		If GetInput(myP, INP_R) = True And bJoy1XHit = False Then bJoyRight = PLAYER_1

		If bJoyUp = 0 Then
			If tSelY > 126 Then tSelY:-42
		
			bJoy1YHit = True
			bJoy2YHit = True
			
		ElseIf bJoyDown = 0 Then
			If tSelY < 252 Then 
				'If tSelX = 381 And tSelY = 210 Then tSelX:-48 ' // End
				tSelY:+42
			EndIf
			
			bJoy1YHit = True
			bJoy2YHit = True					
			
		ElseIf bJoyLeft = 0 Then
			If tSelX > 141 Then tSelX:-48
		
			bJoy1XHit = True
			bJoy2XHit = True
			
		ElseIf bJoyRight = 0 Then			
			If tSelX < 429 Then 
				'If tSelX = 381 And tSelY = 252 Then ' // End
				'Else
					tSelX:+48	
				'EndIf
			EndIf
			
			bJoy1XHit = True
			bJoy2XHit = True					
		EndIf

		If GetInput(myP, INP_B) Or GetInput(myP, INP_S) = True Then 
			If tSelX = 429 And tSelY = 252 Then ' // End (UPLOAD)
				PlaySFX sfxBubble
				If tmpName$ = "" Then tmpName$ = "BubbleX" ' // Default
								
				sfxChan = PlaySFX(sfxCharge)					
				UploadScore(p_Points[myP] + "_" + LSet(tmpName$, 8) + "_" + p_Class[myP] + "_" + String(lastLevel + (bLooped * 50)))
				bExit = True
				
			Else ' // Letter
				If tSelX = 381 And tSelY = 252 Then hi_A = 45 ' // -
			
				If Len(tmpName$) < 8 Then tmpName$ = tmpName$ + Chr(hi_A); PlaySFX sfxBubble
			EndIf
			
		EndIf
		
		If GetInput(myP, INP_A) = True Then
			If Len(tmpName$) > 0 Then tmpName$ = Left$(tmpName$, Len(tmpName$) - 1); PlaySFX sfxPoof

		EndIf
     
		' // Reset joysticks
		Local tmpJoy:Int = PLAYER_1
		If b2Player = True Then
			If myP = PLAYER_1 Then tmpJoy = p1Joy ElseIf myP = PLAYER_2 Then tmpJoy = p2Joy				
		EndIf
		
		If JoyY(tmpJoy) <= .5 And JoyY(tmpJoy) >= -.5 Then 
			bJoy1YHit = False ' // Reset joystick
		EndIf
		
		If JoyX(tmpJoy) <= .5 And JoyX(tmpJoy) >= -.5 Then 
			bJoy1XHit = False ' // Reset joystick
		EndIf
		
		If JoyY(tmpJoy) <= .5 And JoyY(tmpJoy) >= -.5 Then 
			bJoy2YHit = False ' // Reset joystick
		EndIf
		
		If JoyX(tmpJoy) <= .5 And JoyX(tmpJoy) >= -.5 Then 
			bJoy2XHit = False ' // Reset joystick
		EndIf

		GetFuncInput() ' // Function Keys
	
		DrawOverlay() ' // Overlay graphics
	
		If GetMilliSecs() >= fpsTimer + 1000 Then FPS = curFrames; curFrames = 0; fpsTimer = GetMilliSecs()
		curFrames = curFrames + 1
			
		Flip -1
	Until bExit = True Or KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True 

	If bExit = False Then EndGame ' // End game
	
	FlushInput
	
End Function
		
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² HandleDeath - Checks if one or both players or dead
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function HandleDeath()

	If p_Dead[PLAYER_1] = 4 Then ' // Death check
		If b2Player = True Then
			If p_Dead[PLAYER_2] = 4 Then bTitle = True
		Else
			bTitle = True
		EndIf
		If bTitle = True Then 
			' // Delete all types
			For o:Obj = EachIn objList; objList.Remove o; Next 
			For s:Shot = EachIn shotList; shotList.Remove s; Next 
			For p:Part = EachIn partList; partList.Remove p; Next 
			For b:Bub = EachIn bubList; bubList.Remove b; Next
						
			StopChannel musChan; musChan = AllocChannel()
			If cfgDiff = 0 Or bJBMode = True Or bXMode = True Then ' // Easy or cheating
				PlaySFX sfxOver		
				FlushInput
						
			Else ' // Hi score		
				StopChannel musChan
				musChan = AllocChannel()
				musChan.SetVolume(Float(cfgMusic) / 15)					
				musChan = PlayMusic(musPass, musChan)
				
				Local bPass:Int = False
				If p_Points[0] > 0 Then EnterName(PLAYER_1); bPass = True
				If b2Player = True And p_Points[1] > 0 Then EnterName(PLAYER_2); bPass = True
				
				If bPass = False Then PlaySFX sfxOver ' // No high score
				FlushInput
				StopChannel musChan		
						
			EndIf
			
			curLevel = 1

		EndIf
	EndIf
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² HANDLENEXT - Handles next level transition
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function HandleNext()

	Local bEnd:Int = False
	
	If nextLevel = 2 Or nextLevel = 5 Then ' // Pull down menu
	
		Local bPass:Int = True
		'For p:Part = EachIn partList
		'	If p.ID = PART_LEVELUP Then bPass = False; Exit
		'Next
		
		If bPass = True Then
			SetColor 255, 255, 255
			DrawSubImageRect imgMenu2, 37, 64, 224, menuY, 0, 0, 224, menuY, 0, 0, 0
		
			If GetMilliSecs() >= menuT + 20 Then
				If menuY < 128 Then 
					menuY:+8 
				Else 
					FlushInput
					
					menuY = 128
					If nextLevel = 5 Then nextLevel = 6 ' // Player 2
				EndIf
				menuT = GetMilliSecs()
			EndIf
		EndIf
		
	ElseIf nextLevel = 4 Or nextLevel = 7 Then ' // Pull menu up
		SetColor 255, 255, 255
		DrawSubImageRect imgMenu2, 37, 64, 224, menuY, 0, 0, 224, menuY, 0, 0, 0
		
		If GetMilliSecs() >= menuT + 20 Then
			If menuY > 0 Then 
				menuY:-8 
			Else 
				menuY = 0
				
				If nextLevel = 4 Then
					If b2Player = True And p_XP[PLAYER_2] >= GetLevelXP(p_Lvl[PLAYER_2]) And p_Dead[PLAYER_2] = False Then ' // P2 Level up
						nextLevel = 5; levelYI = 0; levelYD = 0; levelSel = 0			
						p_Lvl[PLAYER_2]:+1	
									
						PlaySFX sfxLevel 
						menuY = 0; menuT = GetMilliSecs()
					Else
						nextLevel = 8 ' // Done
					EndIf
				Else ' // Done
					nextLevel = 8
				EndIf
				
			EndIf
			menuT = GetMilliSecs()
		EndIf
	
	ElseIf nextLevel = 3 Or nextLevel = 6 Then ' // Level up
		Local tmpP:Int
		If nextLevel = 3 Then tmpP = PLAYER_1 ElseIf nextLevel = 6 Then tmpP = PLAYER_2

		SetColor 255, 255, 255
		DrawImage imgMenu2, 37, 64
		
		DrawImage GetClassImg(p_Class[tmpP]), 85, 105, 7
		DrawImage GetClassImg(p_Class[tmpP]), 468, 105, 23
		
		SetColor lvlC[0], lvlC[1], lvlC[2]
		DrawFont "Player " + String(tmpP + 1) + " Level " + String(p_Lvl[tmpP]) + "!", -1, 96, 0, True
		DrawFont "Select a powerup", -1, 128, 0, True
		DrawFont "BP       MP       HP", -1, 176, 0, True		
		DrawFont Int(p_ATK[tmpP] * 2) + " " + String(Int(p_ATK[tmpP] * 2) + 4) + "    " + Int(p_TMP[tmpP] * 2) + " " + String(Int(p_TMP[tmpP] * 2) + 4) + "    " + RSet(Int(p_LifeT[tmpP] * 2), 2) + " " + LSet(Int((p_LifeT[tmpP] * 2) + 1), 2), -1, 256
		SetColor 255, 255, 255
		
		DrawImage imgStats, 112, Int(208 + levelYI), p_Class[tmpP]
		DrawImage imgStats, 276, Int(208 + levelYI), p_Class[tmpP] + 3
		DrawImage imgStats, 436, Int(208 + levelYI), p_Class[tmpP] + 6

		' // Spell count
		DrawImage imgSLvl, 316, 203, 1
		If p_SpellC[tmpP] >= 3 Then DrawImage imgSLvl, 316, 213, 0 Else DrawImage imgSLvl, 316, 213, 1	
		If p_SpellC[tmpP] >= 2 Then DrawImage imgSLvl, 316, 223, 0 Else DrawImage imgSLvl, 316, 223, 1
		If p_SpellC[tmpP] >= 1 Then DrawImage imgSLvl, 316, 233, 0 Else DrawImage imgSLvl, 316, 233, 1
		
		SetScale 1, 1
		DrawImage imgUp, 124, 256
		DrawImage imgUp, 286, 256
		DrawImage imgUp, 447, 256		
		
		SetScale sclX, sclY
		DrawImage imgSel, 78 + Int(levelSel * 161.5), 166, tmpP

		If levelYD = 0 Then
			If levelYI > -2 Then levelYI:-.1 Else levelYD = 1
		ElseIf levelYD = 1 Then
			If levelYI < 2 Then levelYI:+.1 Else levelYD = 0
		EndIf
		
		Local tmpJoy:Int
		If tmpP = PLAYER_1 Then tmpJoy = bJoy1XHit ElseIf tmpP = PLAYER_2 Then tmpJoy = bJoy2XHit
		
		If GetInput(tmpP, INP_L) = True And tmpJoy = False Then
			If levelSel > 0 Then levelSel:-1 Else levelSel = 0
			bJoy1XHit = True
			bJoy2XHit = True
			
		ElseIf GetInput(tmpP, INP_R) = True And tmpJoy = False Then			
			If levelSel < 2 Then levelSel:+1 Else levelSel = 2
			bJoy1XHit = True
			bJoy2XHit = True

		EndIf
		
		If GetInput(tmpP, INP_B) = True Or GetInput(tmpP, INP_S) = True Then
			If levelSel = 0 Then 
				p_ATK[tmpP]:+2
			ElseIf levelSel = 1 Then
				p_TMP[tmpP]:+2
				p_GMP[tmpP]:+1 ' // Gauge
			
				' // Spell Level
				If p_SpellC[tmpP] < 3 Then
					p_SpellC[tmpP]:+1
				Else
					If p_SpellL[tmpP] < 3 Then 
						p_SpellL[tmpP]:+1 ' // Spell level up
						p_SpellC[tmpP] = 1
					EndIf
				EndIf
				
				' // Refill
				'If p_MP[tmpP] + 5 < p_GMP[tmpP] Then p_MP[tmpP]:+5 Else p_MP[tmpP] = p_GMP[tmpP] ' // MP up

				'p_MP[tmpP] = p_GMP[tmpP] ' // Refill
				
			ElseIf levelSel = 2 Then
				If p_LifeT[tmpP] < 15 Then p_LifeT[tmpP]:+.5 ' // 15 heart cap
				If p_Life[tmpP] + .5 < p_LifeT[tmpP] Then p_Life[tmpP]:+.5 Else p_Life[tmpP] = p_LifeT[tmpP] ' // Health up

				'p_Life[tmpP] = p_LifeT[tmpP] ' // Refill
				
			EndIf
			
			PlaySFX sfxBubble
			menuY = 128; menuT = GetMilliSecs()
			If nextLevel = 3 Then nextLevel = 4 ElseIf nextLevel = 6 Then nextLevel = 7 ' // Roll up
			FlushInput
		EndIf

		If JoyX(p1Joy) <= .5 And JoyX(p1Joy) >= -.5 Then 
			bJoy1XHit = False ' // Reset joystick
		EndIf
				
		If JoyX(p2Joy) <= .5 And JoyX(p2Joy) >= -.5 Then 
			bJoy2XHit = False ' // Reset joystick
		EndIf
	
	ElseIf nextLevel = 8 Then ' // Level tran
	
		' // Pop all bubble
		For b:Bub = EachIn bubList
			'If b.ID = 1 And b.F = 3 Then 
				'If b.Spec = 0 Then b.F = 4 Else 
			'	b.F = 5 ' // Special bubbles
			'Else
				bubList.Remove b
			'EndIf
		Next ' // Render bubbles
	
		' // Delete all objects
		For s:Shot = EachIn shotList; shotList.Remove s; Next
		For o:Obj = EachIn objList; objList.Remove o; Next
		For p:Part = EachIn partList; partList.Remove p; Next
		
		If curLevel = 101 Then ' // MID SHOPS SHOP
			curLevel = lastLevel + 1
			lastLevel = curLevel
			
			If curLevel = 21 Or curLevel = 31 Or curLevel = 41 Then ShuffleLevels ' // Shuffle every 10				

		ElseIf curLevel = 102 Then ' // BOSS SHOP
		
			StopChannel musChan
			musChan = AllocChannel()
			musChan.SetVolume(Float(cfgMusic) / 15)				
			musChan = PlayMusic(musBoss, musChan)
						
			If lastLevel = 10 Then ' // Boss 1
				curLevel = 201
			ElseIf lastLevel = 25 Then ' // Boss 2
				curLevel = 202
			ElseIf lastLevel = 50 Then ' // Boss 3
				curLevel = 203
			EndIf

		ElseIf curLevel = 201 Or curLevel = 202 Or curLevel = 203 Then ' // Bosses			
			StopChannel musChan
			musChan = AllocChannel()
			musChan.SetVolume(Float(cfgMusic) / 15)				
			If curLevel = 203 Then
				musChan = PlayMusic(musEnd, musChan)								
				bEnd = True
				
			Else
				musChan = PlayMusic(musSong1, musChan)
				
				curLevel = lastLevel + 1
				lastLevel = curLevel
			EndIf
					
			If curLevel = 11 Then ShuffleLevels
			If curLevel = 26 Then ShuffleLevels
			
		Else
			If curLevel = 5 Or curLevel = 15 Or curLevel = 20 Or curLevel = 30 Or curLevel = 35 Or curLevel = 40 Or curLevel = 45 Then ' // Shop
				lastLevel = curLevel
				curLevel = 101
				
			ElseIf curLevel = 10 Or curLevel = 25 Or curLevel = 50 Then ' // Shop 2 (Boss)
				lastLevel = curLevel
				curLevel = 102
						
			Else
				curLevel:+1			
				lastLevel = curLevel
				
			EndIf		
			
		EndIf
		
		If bEnd = True Then ' // END GAME
			' // Delete all types
			For o:Obj = EachIn objList; objList.Remove o; Next 
			For s:Shot = EachIn shotList; shotList.Remove s; Next 
			For p:Part = EachIn partList; partList.Remove p; Next 
			For b:Bub = EachIn bubList; bubList.Remove b; Next
		
			Local tmpF:Int = 0, tmpT:Int = GetMilliSecs(), bExit:Int = False
			FlushInput
			SetColor 255, 255, 255

			Repeat
				Cls
				If reloadC <> 0 Then
					If reloadC = 1 Then LoadImages(cfgFilter) ' // Reload all images			
					reloadC = 0
					Cls
				EndIf
					
				DrawImage imgEnd, 0, 0, tmpF
				
				If GetMilliSecs() >= tmpT + 250 Then 
					If tmpF < 1 Then tmpF:+1 Else tmpF = 0
					tmpT = GetMilliSecs()
				EndIf
				
				If cfgDiff = 0 Then ' // Easy
					DrawFont "Try again on normal difficulty!", -1, 376
				Else
					DrawFont "Your journey is not over yet!", -1, 376
				EndIf

				DrawFont "Press Start to continue", -1, 406
				
				If KeyDown(KEY_ESCAPE) Or AppTerminate() = True Then bExit = True
				If GetInput(0, INP_S) = True Then bEnd = False
				
				GetFuncInput() ' // Function Keys
			
				DrawOverlay() ' // Overlay graphics
			
				If GetMilliSecs() >= fpsTimer + 1000 Then FPS = curFrames; curFrames = 0; fpsTimer = GetMilliSecs()
				curFrames = curFrames + 1
			
				Flip -1 
			Until bEnd = False Or bExit = True

			If bExit = True Then EndGame()

			curLevel = 1
			lastLevel = 1
			reloadC = 0
			nextLevel = 0			

			StopChannel musChan; musChan = AllocChannel()
			FlushInput
			
			If cfgDiff = 0 Then 
				bTitle = True '// Easy						
			Else
				bLooped:+1 ' // Hard mode
				NewGame()
			EndIf
					
		Else
			reloadC = 2 ' // Load next level
			allDrop = False
			levelY = 0
			p_BombC[0] = 0; p_BombC[1] = 0
			
			ResetActives() ' // Turn off actives items
			
			floatF = 0; floatT = GetMilliSecs()
											
			nextLevel = 9 ' // Transistion
			
			If bSpecial = True Or bFastMus = True Then
				StopChannel musChan
				'musChan = 
				musChan = AllocChannel()
				musChan.SetVolume(Float(cfgMusic) / 15)		
				musChan = PlayMusic(musSong1, musChan)
				bSpecial = False; bFastMus = False
			
			EndIf
		EndIf
		
	EndIf

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² HANDLETIMERS - Handles all level based titles
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function HandleTimers()

	If objC = 0 And keyTime < 0 And (curLevel <> 101 And curLevel <> 102) Then ' // Give key time to spawn
		Local bPass:Int = True
		If b2Player = False Then
			If p_Dead[PLAYER_1] <> False Then bPass = False
		Else
			If p_Dead[PLAYER_1] <> False And p_Dead[PLAYER_2] <> False Then bPass = False
		EndIf
		
		If bPass = True Then ' // Make sure players are alive
			If nextLevel = False Then nextLevel = 1; nextT = GetMilliSecs()
		EndIf
		
	Else
		' // Reset next level check
		If nextLevel = True Then nextLevel = False; nextT = GetMilliSecs()
	EndIf

	' // KEY
	If (GetMilliSecs() >= (keyT + keyTime)) And keyTime > 0 And nextLevel = False Then
		If curLevel < 101 Then ' // No keys in shop
			objList.AddLast obj.Create(keyX, keyY, OBJ_KEY)
			keyTime = -1
		Else
			keyTime = -3		
		EndIf
		
	EndIf
	
	' // CANDY
	If (GetMilliSecs() >= (candyT + candyTime)) And candyTime > 0 And nextLevel = False Then
		If curLevel < 101 Then ' // No candy in shop
			objList.AddLast obj.Create(candyX, candyY, OBJ_CANDY)
			candyTime = -1
		Else
			candyTime = -1
		EndIf
		
	EndIf

	Local hurryTime:Int = 50000
	If lastLevel >= 11 And lastLevel <= 20 Then ' // SECOND SET
		hurryTime = 47500
	ElseIf lastLevel >= 21 And lastLevel <= 30 Then ' // THIRD SET
		hurryTime = 45000
	ElseIf lastLevel >= 31 And lastLevel <= 40 Then ' // FOURTH SET
		hurryTime = 42500
	ElseIf lastLevel >= 41 And lastLevel <= 50 Then ' // FIFTH SET
		hurryTime = 40000
	EndIf
					
	' // GHOST / HURRY
	If ghostC = 0 Then
		If (GetMilliSecs() >= ghostT + hurryTime) Then
			If enemyC > 0 And nextLevel = False Then 		
				partList.AddLast part.Create(250, 448, PART_HURRY)

				ghostC = 1 ' // HURRY
			EndIf
		EndIf
	
	ElseIf ghostC = 1 Then ' // GHOST
		If (GetMilliSecs() >= ghostT + (hurryTime + 10000)) Then
			If enemyC > 0 And nextLevel = False Then 		
				StopChannel musChan
				'musChan = 
				musChan = AllocChannel()
				musChan.SetVolume(Float(cfgMusic) / 15)				
				musChan = PlayMusic(musGhost, musChan)
				
				Local tmpX:Int, tmpY:Int, tmpR:Int
				tmpR = Rand(1, 4)
				If tmpR = 1 Then ' // Bottom left
					tmpX = 74; tmpY = 372
				ElseIf tmpR = 2 Then ' // Top left
					tmpX = 74; tmpY = 84
				ElseIf tmpR = 3 Then ' // Top right
					tmpX = 478; tmpY = 84
				ElseIf tmpR = 4 Then ' // Bottom left
					tmpX = 478; tmpY = 372
				EndIf
				
				objList.AddLast obj.Create(tmpX, tmpY, OBJ_GHOST)

				ghostC = 2 ' // GHOST
			EndIf
		EndIf
	
	ElseIf ghostC = 2 Then ' // Play music in a loop
		'DebugLog "MUS: " + ChannelPlaying(musChan)
	
		If ChannelPlaying(musChan) = False Then
			'DebugLog "HIT"

			'PauseChannel musChan
			'musChan = 
			' // BUG FIX
			musChan = AllocChannel()
			musChan.SetVolume(Float(cfgMusic) / 15)
			musChan = PlayMusic(musHurry, musChan)
			bFastMus = True
			
			ghostC = 3 ' // Done
		EndIf
		
	EndIf
	
	If ghostC > 0 And enemyC = 0 Then ' // BACK TO NORMAL
		StopChannel musChan
		'musChan = 
		musChan = AllocChannel()
		musChan.SetVolume(Float(cfgMusic) / 15)		
		musChan = PlayMusic(musSong1, musChan)
		ghostC = -1
		bFastMus = False
		
	EndIf
	
	If enemyC > 0 Then 
		chestT = -1 
	Else
		If chestT = -1 Then chestT = GetMilliSecs()
	EndIf
		
	If enemyC = 0 And (GetMilliSecs() >= chestT + 2000) Then ' // Chest check
		If (p_Key[0] = True Or p_Key[1] = True) And keyTime = -2 Then
			Local tmpP:Int
			If p_Key[0] = True Then tmpP = 0 ElseIf p_Key[1] = True Then tmpP = 1
			objList.AddLast obj.Create(chestX, chestY, OBJ_CHEST, tmpP)

			keyTime = -3
		EndIf
	EndIf
	
	If nextLevel = True And GetMilliSecs() >= nextT + 2000 Then ' // Next level delay
		Local tmpPass:Int = False
		If p_XP[PLAYER_1] >= GetLevelXP(p_Lvl[PLAYER_1]) And p_Dead[PLAYER_1] = False Then 
			tmpPass = True			
			'partList.AddLast part.Create(Int(p_X[0]), Int(p_Y[0]), PART_LEVELUP, p_F[PLAYER_1], 0)
			
		Else
			If b2Player = True And p_XP[PLAYER_2] >= GetLevelXP(p_Lvl[PLAYER_2]) And p_Dead[PLAYER_2] = False Then 
				tmpPass = True
				'partList.AddLast part.Create(Int(p_X[1]), Int(p_Y[1]), PART_LEVELUP, p_F[PLAYER_2], 1)
				
			EndIf
		EndIf
		
		'DebugLog "PASS: " + tmpPass + "XP: " + p_XP[PLAYER_1] + " / " + GetLevelXP(p_Lvl[PLAYER_1])
		
		If tmpPass = True Then ' // Level up
			nextLevel = 2
			PlaySFX sfxLevel 
			menuY = 0; menuT = GetMilliSecs()
			
			StopChannel musChan
			'musChan = 
			musChan = AllocChannel()
			musChan.SetVolume(Float(cfgMusic) / 15)		
			musChan = PlayMusic(musSpecial, musChan)
			bSpecial = True
					
		Else ' // Next level
			nextLevel = 8
		EndIf
		
		StopChannel chargeChan[0]; chargeChan[0] = AllocChannel()
		StopChannel chargeChan[1]; chargeChan[1] = AllocChannel()
		
		p_Charge[0] = -1
		p_Charge[1] = -1
		p_J[0] = False
		p_J[1] = False
		p_Fall[0] = False
		p_Fall[1] = False
		
		FlushInput
	EndIf
	
	If nextLevel = 2 And GetMilliSecs() >= nextT + 2600 Then ' // Next level
		If p_XP[PLAYER_1] >= GetLevelXP(p_Lvl[PLAYER_1]) And p_Dead[PLAYER_1] = False Then ' // P1 Level up
			nextLevel = 3; levelYI = 0; levelYD = 0; levelSel = 0
			p_Lvl[PLAYER_1]:+1
			
		ElseIf b2Player = True And p_XP[PLAYER_2] >= GetLevelXP(p_Lvl[PLAYER_2]) And p_Dead[PLAYER_2] = False Then ' // P2 Level up
			nextLevel = 6; levelYI = 0; levelYD = 0; levelSel = 0			
			p_Lvl[PLAYER_2]:+1
			
		EndIf
		
		FlushInput
	EndIf

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² HANDLEMAGICCOL - Handles magic to enemy collision
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function HandleMagicCol(myID:Int, X:Int, Y:Int, F:Int, D:Int, Player:Int, bKnock:Int = False, sLvl:Int = 1)

	Local tmpImg:TImage

	Local bShop:Int = False, createBag:Int = False
	If curLevel > 100 And curLevel < 200 Then bShop = True
	
	' // Shop keeper drop
	If bShop = True And bMoney = True And myID = SHOT_FIREBALL Then
		Local tmpHit2:Int = False

		If p_Class[Player] = CLASS_BUBBLE Then
			If sLvl = 1 Then
				tmpImg = imgSplash
			ElseIf sLvl = 2 Then
				tmpImg = imgSplash2
			ElseIf sLvl = 3 Then
				tmpImg = imgSplash3
			EndIf
		ElseIf p_Class[Player] = CLASS_EMBER Then
			If sLvl = 1 Then
				tmpImg = imgFireball
			ElseIf sLvl = 2 Then
				tmpImg = imgFireball2
			ElseIf sLvl = 3 Then
				tmpImg = imgFireball3
			EndIf
		ElseIf p_Class[Player] = CLASS_SHOCK Then
			If sLvl = 1 Then
				tmpImg = imgVolt
			ElseIf sLvl = 2 Then
				tmpImg = imgVolt2
			ElseIf sLvl = 3 Then
				tmpImg = imgVolt3
			EndIf
		EndIf
		If sLvl = 999 Then tmpImg = imgBuster
		
		If p_Class[Player] = CLASS_EMBER And sLvl = 3 Then
			tmpHit2 = ImagesCollide2(imgMighta, 515, 146, keeperF, 0, sclX, sclY, tmpImg, Int(X), Int(Y), F, 0, sclX + .4, sclY + .4)
		Else
			tmpHit2 = ImagesCollide(imgMighta, 515, 146, keeperF, tmpImg, Int(X), Int(Y), F)
		EndIf
		
		If tmpHit2 = True Then ' // Shop keeper hit
			PlaySFX sfxChain
			createBag = True
			bMoney = False
		EndIf
	EndIf
		
	' // Enemy collision
	For o:Obj = EachIn objList
		If o.ID = OBJ_ZEN And o.Hurt = False And allDrop = True Then
			
			Local offX:Int = 0, offY:Int = 0
			If o.Kind = EN_BOSS1 Or o.Kind = EN_BOSS2 Then offX = 20; offY = 30'; bKnock = False

			Local tmpF:Int = 0
			If o.D = 1 Then tmpF = 2

			Local imgEn:TImage = GetEnImg(o.Kind)
			
			Local tmpHit:Int = False, tmpDmg:Int = 0
									
			Select myID
				Case SHOT_FIREBALL ' // FIREBALL LEVEL 1
				If p_Class[Player] = CLASS_BUBBLE Then
					If sLvl = 1 Then
						tmpImg = imgSplash
					ElseIf sLvl = 2 Then
						tmpImg = imgSplash2
					ElseIf sLvl = 3 Then
						tmpImg = imgSplash3
					EndIf
				ElseIf p_Class[Player] = CLASS_EMBER Then
					If sLvl = 1 Then
						tmpImg = imgFireball
					ElseIf sLvl = 2 Then
						tmpImg = imgFireball2
					ElseIf sLvl = 3 Then
						tmpImg = imgFireball3
					EndIf
				ElseIf p_Class[Player] = CLASS_SHOCK Then
					If sLvl = 1 Then
						tmpImg = imgVolt
					ElseIf sLvl = 2 Then
						tmpImg = imgVolt2
					ElseIf sLvl = 3 Then
						tmpImg = imgVolt3
					EndIf
				EndIf
				If sLvl = 999 Then tmpImg = imgBuster
				
				If p_Class[Player] = CLASS_EMBER And sLvl = 3 Then
					tmpHit = ImagesCollide2(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, 0, sclX, sclY, tmpImg, Int(X), Int(Y), F, 0, sclX + .4, sclY + .4)							
				Else
					tmpHit = ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, tmpImg, Int(X), Int(Y), F)							
				EndIf
				tmpDmg = Int(p_TMP[Player] * 1)
				
				'Case SHOT_WAVE ' // SHOCK WAVE LEVEL 1
				'tmpHit = ImageRectCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, Int(X) + 15, Int(Y) + 5, 4, 4)
				'tmpDmg =  Int(p_TMP[Player] * 1)
				
				Case SHOT_SPOUT ' // SPOUT
				tmpHit = ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, imgSpout, Int(X), Int(Y), F)
				If curLevel > 200 Then ' // Boss
					tmpDmg = Int(p_TMP[Player] * 1)
				Else
					tmpDmg = Int(p_TMP[Player] * 2)
				EndIf
				
				Case SHOT_BOMB ' // BOMB EXPLOSION
				tmpHit = ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, imgExplode, Int(X), Int(Y), F)
				If curLevel > 200 Then ' // Boss
					tmpDmg = Int(p_TMP[Player] * 1)
				Else
					tmpDmg =  Int(p_TMP[Player] * 2)				
				EndIf
				
				Case SHOT_SWOOSH ' // MAGIC SWOOSH
				Local tmpSX:Float = sclX + .25, tmpSY:Float = sclY + .25
				If sLvl = 2 Then tmpSX:+.5; tmpSY:+.5
				If sLvl = 3 Or sLvl = 999 Then tmpSX:+.75; tmpSY:+.75
				tmpHit = ImagesCollide2(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, 0, sclX, sclY, imgSwoosh, Int(X), Int(Y), F, 0, tmpSX, tmpSY)
				tmpDmg =  Int(p_TMP[Player] * 1)				
				
				Case BUB_WATER ' // WATER BUBBLE
				tmpHit = ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, imgCol, Int(X), Int(Y), 1)
				If curLevel > 200 Then ' // Boss
					tmpDmg = Int(p_TMP[Player] * 1.5)
				Else
					tmpDmg = 9999				
				EndIf
				
				Case BUB_ZAP ' // ZAP BUBBLE
				tmpHit = ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, imgZap, Int(X), Int(Y), 1)
				If curLevel > 200 Then ' // Boss
					tmpDmg = Int(p_TMP[Player] * 1.5)
				Else
					tmpDmg = 9999				
				EndIf

				Case BUB_FIRE ' // FIRE BUBBLE
				tmpHit = ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, imgFlame, Int(X), Int(Y), F)
				If curLevel > 200 Then ' // Boss
					tmpDmg = Int(p_TMP[Player] * 1.5)
				Else
					tmpDmg = 9999				
				EndIf
				
				Case SHOT_COMET ' // COMET (pink book)
				tmpHit = ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, imgComet, Int(X), Int(Y), F)
				If curLevel > 200 Then ' // Boss
					tmpDmg = Int(p_TMP[Player] * 1)				
				Else
					tmpDmg = Int(p_TMP[Player] * 2)				
				EndIf
				
				Case SHOT_CROSS ' // CROSS
				tmpHit = ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, imgCross, Int(X), Int(Y), F)
				If curLevel > 200 Then ' // Boss
					tmpDmg = Int(p_TMP[Player] * 1)				
				Else
					tmpDmg = Int(p_TMP[Player] * 2)				
				EndIf
				
				Case SHOT_FIREWORK ' // FIREWORK
				tmpHit = ImagesCollide(imgEn, Int(o.X) - offX, Int(o.Y) - offY, o.F + tmpF, imgFirework, Int(X), Int(Y), F)
				If curLevel > 200 Then ' // Boss
					tmpDmg = Int(p_TMP[Player] * 1)				
				Else
					tmpDmg = Int(p_TMP[Player] * 2)				
				EndIf
								
			End Select						
			
			If tmpHit = True Then
				If o.HP - tmpDmg > 0 Then ' // Alive
					PlaySFX sfxEHit
					
					o.HP:-tmpDmg
					o.Hurt = 1
					o.hurtC = -2 ' // Hurt for longer to let magic pass through
					o.hurtT = GetMilliSecs() ' // Hurt for longer
					
					If o.Kind = EN_BOSS3 Then
						o.Spd:+.01
						o.YSpd:+.01
					EndIf
					
					' // Knock back regardless of direction
					If bKnock = True Then
						If o.Fall = False And o.J = False Then
							'If D = 0 And (o.D = 1 Or o.D = 2) Then 
								If o.Kind <> EN_BOSS3 Then o.bDelay = True; o.delayT = GetMilliSecs() - 120
							'ElseIf D = 1 And (o.D = 0 Or o.D = 3) Then 
							'	o.bDelay = True; o.delayT = GetMilliSecs() - 120
							'EndIf
						EndIf
					EndIf
					
					p_MChainT[Player] = GetMilliSecs()

				Else ' // Dead
					If o.Kind <> EN_BOSS1 And o.Kind <> EN_BOSS2 And o.Kind <> EN_BOSS3 Then					
						If GetMilliSecs() >= spinT + 250 Then ' // Don't repeat
							PlaySFX(sfxSpin)
							spinT = GetMilliSecs()
						EndIf
													
						Local tmpXP:Int = GetXP(OBJ_ZEN, o.Kind, o.Lvl)
						p_XP[Player]:+tmpXP
						If b2Player = True Then ' // Half experience
							If Player = PLAYER_1 And p_Dead[PLAYER_2] = False Then
								p_XP[PLAYER_2]:+Int(tmpXP / 2)
							ElseIf Player = PLAYER_2 And p_Dead[PLAYER_1] = False Then
								p_XP[PLAYER_1]:+Int(tmpXP / 2)									
							EndIf
						EndIf
						
						p_Points[Player]:+o.Pnt ' // Points
						
						' // MAGIC CHAIN
						p_MChain[Player]:+1
						p_MChainX[Player] = o.X
						p_MChainY[Player] = o.Y
						p_MChainT[Player] = GetMilliSecs()
						
						Local OX:Int = Int(o.X), OY:Int = Int(o.Y), OK:Int = o.Kind, OL:Int = o.Lvl
						objList.Remove o
						
						objList.AddLast obj.Create(OX, OY, OBJ_DEAD, OBJ_ZEN, Rand(0, 1), 0, Rand(0, 3), OK, OL)
					
					Else ' // BOSS BUBBLE
						partList.AddLast part.Create(Int(o.X) - offX, Int(o.Y) - offY, PART_BOSSBUB, o.Kind)
						objList.Remove o
						If curLevel = 202 Then DeadAllEnemies()
						
					EndIf				
					
				EndIf
									
			EndIf
		EndIf
	Next
	
	If createBag = True Then ' // Keeper drop
		objList.AddLast obj.Create(515, 146, OBJ_DEAD, OBJ_ZEN, Rand(0, 1), 1, Rand(0, 3), EN_MIGHTA)
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² HANDLEMCHAIN - Handles magic chaining
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function HandleMChain()

	For Local i2:Int = 0 To b2Player
		If p_Dead[i2] = False Then ' // MAGIC CHAIN
			If GetMilliSecs() >= p_MChainT[i2] + 300 Then
				If p_MChain[i2] > 1 Then 					
					objList.AddLast obj.Create(Int(p_MChainX[i2]), Int(p_MChainY[i2]), OBJ_GEM, p_MChain[i2] - 2)
							
					p_Points[i2]:+((p_MChain[i2]) * 1000) ' // Points
							
					For Local i:Int = 0 To 9 ' // Stars
						'partList.AddLast part.Create(Int(p_MChainX[i2]) + 18, Int(p_MChainY[i2]) + 16, PART_POP, 100, i)
					Next

					' // Points
					partList.AddLast part.Create(Int(p_MChainX[i2]) + 18, Int(p_MChainY[i2]) + 16, PART_SCORE, p_MChain[i2] - 1, i2)			
					PlaySFX sfxChain
				EndIf
				
				p_MChain[i2] = 0
			EndIf
		EndIf
	Next

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NumFormat - Draws numbers with comma placement                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NumFormat:String(myStr$)

	If Len(myStr$) = 4 Then ' // Thousand
		myStr$ = Left$(myStr$, 1) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 5 Then ' // Ten thousand
		myStr$ = Left$(myStr$, 2) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 6 Then ' // One hundred thousand
		myStr$ = Left$(myStr$, 3) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 7 Then ' // One million
		myStr$ = Left$(myStr$, 1) + "," + Mid$(myStr$, 2, 3) + "," + Right$(myStr$, 3)
		
	ElseIf Len(myStr$) = 8 Then ' // Ten million
		myStr$ = Left$(myStr$, 2) + "," + Mid$(myStr$, 3, 3) + "," + Right$(myStr$, 3)
		
	EndIf
	
	Return myStr$
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GHECKDROP - Checks if all enemies have dropped
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function CheckDrop()

	Local tmpCheck:Int = True
	
	For o:Obj = EachIn objList ' // Render objects
		If o.ID = OBJ_ZEN And o.Drop = True Then tmpCheck = False; Exit
	Next 
	
	If tmpCheck = True Then allDrop = True ' // Set public
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DeadAllEnemies - Kills all enemies
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DeadAllEnemies()
	
	Local OX:Int, OY:Int
	For o:Obj = EachIn objList
		If o.ID = OBJ_ZEN Then
			If o.Kind = EN_MONSTA Then
				If GetMilliSecs() >= spinT + 250 Then ' // Don't repeat
					PlaySFX(sfxSpin)
					spinT = GetMilliSecs()
				EndIf
				
				OX = Int(o.X); OY = Int(o.Y)
				objList.Remove o
				objList.AddLast obj.Create(OX, OY, OBJ_DEAD, OBJ_ZEN, Rand(0, 1), 0, Rand(0, 3), EN_MONSTA)
				
			EndIf
		EndIf
	Next
	
	' // Captured bubble
	For b:Bub = EachIn bubList
		If b.Cap <> 0 Then
			If GetMilliSecs() >= spinT + 250 Then ' // Don't repeat
				PlaySFX(sfxSpin)
				spinT = GetMilliSecs()
			EndIf
						
			objList.AddLast obj.Create(Int(b.X), Int(b.Y) - 16, OBJ_DEAD, b.Cap, Rand(0, 1), 0, Rand(0, 3), b.Kind, b.Lvl)		
			bubList.Remove b
		EndIf
	Next
	
	' // Kill flames
	For p:Part = EachIn partList
		If p.ID = PART_FLAME And p.Player = 2 Then
			If p.Fall = True Then ' // Falling
				partList.Remove p
			Else
				p.C2 = True ' // Fade out
			EndIf
		EndIf
	Next
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETLEVELXP - Returns XP needed for current level
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetLevelXP:Int(myL:Int)

	Select myL
	
		Case 1; Return 100
		Case 2; Return 200
		Case 3; Return 400
		Case 4; Return 700
		Case 5; Return 1100
		Case 6; Return 1600
		Case 7; Return 2200
		Case 8; Return 2900
		Case 9; Return 3700
		Case 10; Return 4600
		Case 11; Return 5600
		Case 12; Return 6700
		Case 13; Return 7900
		Case 14; Return 9200
		Case 15; Return 10600
		Case 16; Return 12100
		Case 17; Return 13700
		Case 18; Return 15400
		Case 19; Return 17200
		Case 20; Return 19100
		Case 21; Return 21100
		Case 22; Return 23200
		Case 23; Return 25400
		Case 24; Return 27700
		Case 25; Return 30100	
		Default; Return 999999
		
	End Select
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWBUBBLES - Draws bubbles
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawBubbles()

	p_bJump[0] = 0; p_bJump[1] = 0
	Local p1Cnt:Int = 0, p2Cnt:Int = 0
	For b:Bub = EachIn bubList
		If b.ID = 1 And b.F = 3 And b.Spec = 0 Then ' // Count bubbles
			If b.P = PLAYER_1 Then p1Cnt:+1 ElseIf b.P = PLAYER_2 Then p2Cnt:+1
		EndIf

		b.Render
	Next ' // Render bubbles

	' // Keep to 32 total bubbles between two players, 16 each
	If p1Cnt > 16 Or p2Cnt > 16 Then
		For b:Bub = EachIn bubList
			If b.ID = 1 And b.F = 3 Then ' // Pop extras
				If b.P = PLAYER_1 And p1Cnt > 16 And b.Cap = 0 And b.Spec = 0 Then bubList.Remove b; p1Cnt:-1
				If b.P = PLAYER_2 And p2Cnt > 16 And b.Cap = 0 And b.Spec = 0 Then bubList.Remove b; p2Cnt:-1				
			EndIf
		Next
	EndIf

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETCLASSIMG - Returns image handle based on player class                                   
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetClassImg:TImage(myClass:Int)

	If myClass = CLASS_BUBBLE Then 
		Return imgBub
	ElseIf myClass = CLASS_EMBER Then
		Return imgEmber
	ElseIf myClass = CLASS_SHOCK Then
		Return imgShock
	EndIf
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETENIMG - Returns image handle based on enemy type                                 
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetEnImg:TImage(myEn:Int, myLev:Int = 1)

	If myEn = EN_ZEN Then 
		If myLev = 1 Then Return imgZen ElseIf myLev = 2 Then Return imgZen2 ElseIf myLev = 3 Then Return imgZen3 ElseIf myLev = 4 Then Return imgZen4 ElseIf myLev = 5 Then Return imgZen5
	ElseIf myEn = EN_MIGHTA Then 
		If myLev = 1 Then Return imgMighta ElseIf myLev = 2 Then Return imgMighta2 ElseIf myLev = 3 Then Return imgMighta3 ElseIf myLev = 4 Then Return imgMighta4 ElseIf myLev = 5 Then Return imgGonsu
	ElseIf myEn = EN_BOSS1 Then
		Return imgBoss1
	ElseIf myEn = EN_BOSS2 Then
		Return imgBoss2
	ElseIf myEn = EN_BOSS3 Then
		Return imgDrunk
	ElseIf myEn = EN_MONSTA Then
		If myLev = 1 Then Return imgMonsta ElseIf myLev = 2 Then Return imgMonsta2 ElseIf myLev = 3 Then Return imgMonsta3
	ElseIf myEn = EN_PULPUL Then
		If myLev = 1 Then Return imgPulPul ElseIf myLev = 2 Then Return imgPulPul2
	ElseIf myEn = EN_BANE Then
		Return imgBane
	EndIf

End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ALIGNY - Aligns to map on the Y plane                                   
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function AlignY:Int(myY:Int)

	For Local tmpY:Int = 32 To 416 Step 16
		If myY >= tmpY And myY <= tmpY + 16 Then Return tmpY + 2
	Next
	
	Return myY
	
End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWHUD - Render heads up display                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawHUD()

	' // Player 1
	
	' // MAGIC METER
	Local tmpX:Int = 20 '65
	For Local tmpMP:Int = 1 To p_GMP[0]
		DrawImage imgMP, tmpX, 434, 1 + (p_Class[0] * 2)
		tmpX:+4
	Next
	tmpX = 20
	For Local tmpMP:Int = 1 To p_MP[0]
		DrawImage imgMP, tmpX, 434, 0 + (p_Class[0] * 2)
		tmpX:+4
	Next
	
	' // TOTAL HEARTS
	tmpX = 18
	For Local tmpL:Int = 1 To p_LifeT[0]
		DrawImage imgHeart, tmpX, 15, 6 + p_Class[0]
		tmpX:+18
	Next
	If Instr(p_LifeT[0], ".5") Then DrawImage imgHeart, tmpX, 15, 6 + p_Class[0] 
	
	' // HEARTS
	tmpX = 18
	For Local tmpL:Int = 1 To p_Life[0]
		DrawImage imgHeart, tmpX, 15, p_Class[0] * 2
		tmpX:+18
	Next
	If Instr(p_Life[0], ".5") Then DrawImage imgHeart, tmpX, 15, 1 + p_Class[0] * 2

	' // POINTS
	SetColor lvlC[0], lvlC[1], lvlC[2]
	DrawFont p_Score[0], 37, 32, 0
	DrawFont String(p_SpellL[0]), 2, 430, 0, True ' // Spell Level
	SetColor 255, 255, 255
	
	DrawFont " ", 19, 32, 0
	SetScale 1, 1
	DrawImage imgStats, 18, 32, 9
	SetAlpha 1
	If p_Key[0] = True Then DrawImage imgStats, 0, 15, 10		
	SetScale sclX, sclY
		
	' // ITEMS
	tmpX = 18
	For Local i:Int = 0 To 5
		If p_Items[0, i] <> -1 Then
			SetScale sclX + .1, sclY			
			DrawImage imgBlank, tmpX, 416, 0
			SetScale 1, 1
			DrawImage imgItems, tmpX + 1, 416, p_Items[0, i]
			SetScale sclX + .1, sclY
			If p_Item[0] = i Then DrawImage imgBlank, tmpX, 416, 1			
			tmpX:+19
		EndIf
		
	Next
	SetScale sclX, sclY
	
	' // Player 2
	If b2Player = True Then
		
		' // MAGIC METER
		tmpX = 566
		For Local tmpMP:Int = 1 To p_GMP[1]
			DrawImage imgMP, tmpX, 434, 1 + (p_Class[1] * 2)
			tmpX:-4
		Next
		tmpX = 566
		For Local tmpMP:Int = 1 To p_MP[1]
			DrawImage imgMP, tmpX, 434, 0 + (p_Class[1] * 2)
			tmpX:-4
		Next
		
		' // TOTAL HEARTS
		tmpX = 554
		For Local tmpL:Int = 1 To p_LifeT[1]
			DrawImage imgHeart, tmpX, 15, 6 + p_Class[1]
			tmpX:-18
		Next
		If Instr(p_LifeT[1], ".5") Then DrawImage imgHeart, tmpX, 15, 6 + p_Class[1] 

		' // HEARTS
		tmpX = 554
		For Local tmpL:Int = 1 To p_Life[1]
			DrawImage imgHeart, tmpX, 15, p_Class[1] * 2
			tmpX:-18
		Next
		If Instr(p_Life[1], ".5") Then DrawImage imgHeart, tmpX, 15, 1 + p_Class[1] * 2
		
		' // POINTS
		SetColor lvlC[0], lvlC[1], lvlC[2]
		tmpX = 0
		tmpX = (18 * Len(String(p_Score[1])))
		DrawFont p_Score[1], 552 - tmpX, 32, 0
		DrawFont String(p_SpellL[1]), 570, 430, 0, True ' // Spell Level
		SetColor 255, 255, 255
		
		DrawFont " ", 552, 32, 0
		SetScale 1, 1
		DrawImage imgStats, 552, 32, 9
		If p_Key[1] = True Then DrawImage imgStats, 572, 15, 10			
		SetScale sclX, sclY

		' // ITEMS
		tmpX = 554
		For Local i:Int = 0 To 5
			If p_Items[1, i] <> -1 Then
				SetScale sclX + .1, sclY			
				DrawImage imgBlank, tmpX, 416, 0
				SetScale 1, 1
				DrawImage imgItems, tmpX + 1, 416, p_Items[1, i]
				SetScale sclX + .1, sclY
				If p_Item[1] = i Then DrawImage imgBlank, tmpX, 416, 1			
				tmpX:-19
			EndIf
			
		Next
		SetScale sclX, sclY
			
	EndIf
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWDEBUG - Show debug information                                       
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawDebug()

	' // DEBUG INFO
	SetScale 1, 1; SetColor 255, 255, 0
	DrawText "FPS: " + FPS + ", Mem: " + String(GCMemAlloced() / 1024) + " kb", 40, 50
	DrawText "pX: " + Left(String(p_X[0]), 5) + " / pY: " + Left(String(p_Y[0]), 5) + " / J: " + p_J[0] + " / Fall: " + p_Fall[0] + " / XP: " + p_XP[0], 40, 62
	DrawText "pYI: " + Left(String(p_YI[0]), 5), 40, 74
	
	SetColor 255, 255, 255
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWOVERLAY - Draw overlay                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawOverlay()

	' // Debug info
	If bDebug = True Then DrawDebug
	
	' // CRT Filter
	If cfgCRT > 0 Then
		If cfgCRT = 1 Then SetAlpha .25 ElseIf cfgCRT = 2 Then SetAlpha .5 ElseIf cfgCRT = 3 Then SetAlpha .75 ElseIf cfgCRT = 4 Then SetAlpha 1
		SetScale .368, .3735; SetColor 255, 255, 255; SetBlend ALPHABLEND
		DrawImage imgCRT, 0, 0
		SetAlpha 1
	EndIf
	
	If bWindowed = False Then ' // Fullscreen border
		SetOrigin 0, 0	
		SetScale 1, 1; SetColor 0, 0, 0
		DrawRect 0, 0, 640, 16; DrawRect 0, 0, 26, 480
		DrawRect 640 - 26, 0, 26, 480; DrawRect 0, 480 - 16, 640, 16
		SetColor 255, 255, 255
		SetOrigin 26, 16
	EndIf
	
	SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETXP - Gets experience points based on enemy type
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetXP:Int(ID:Int, Kind:Int, Lvl:Int)
	
	If bLooped > 0 Then 
		Lvl:-bLooped ' // Hard
		If Lvl < 0 Then Lvl = 1
	EndIf
	
	Select ID
		Case OBJ_ZEN
		If Kind = EN_ZEN Then 
			If Lvl = 1 Then Return 15 ElseIf Lvl = 2 Then Return 25 ElseIf Lvl = 3 Then Return 35 ElseIf Lvl = 4 Then Return 45 ElseIf Lvl = 5 Then Return 55
		ElseIf Kind = EN_MIGHTA Then
			If Lvl = 1 Then Return 25 ElseIf Lvl = 2 Then Return 35 ElseIf Lvl = 3 Then Return 45 ElseIf Lvl = 4 Then Return 55 ElseIf Lvl = 5 Then Return 65
		ElseIf Kind = EN_MONSTA Then
			If Lvl = 1 Then Return 30 ElseIf Lvl = 2 Then Return 40 ElseIf Lvl = 3 Then Return 50
		ElseIf Kind = EN_PULPUL Then
			If Lvl = 1 Then Return 40 ElseIf Lvl = 2 Then Return 50
		ElseIf Kind = EN_BANE Then
			Return 55			
		EndIf
	
	End Select

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETPOINTS - Gets point total based on enemy type
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetPoints:Int(ID:Int, Kind:Int, Lvl:Int)

	Select ID
		Case OBJ_ZEN
		If Kind = EN_ZEN Then 
			If Lvl = 1 Then Return 250 ElseIf Lvl = 2 Then Return 500 ElseIf Lvl = 3 Then Return 750 ElseIf Lvl = 4 Then Return 1000 ElseIf Lvl = 5 Then Return 1250
		ElseIf Kind = EN_MIGHTA Then
			If Lvl = 1 Then Return 500 ElseIf Lvl = 2 Then Return 750 ElseIf Lvl = 3 Then Return 1000 ElseIf Lvl = 4 Then Return 1250 ElseIf Lvl = 5 Then Return 1750
		ElseIf Kind = EN_MONSTA Then
			If Lvl = 1 Then Return 750 ElseIf Lvl = 2 Then Return 1000 ElseIf Lvl = 3 Then Return 1250
		ElseIf Kind = EN_PULPUL Then
			If Lvl = 1 Then Return 1000 ElseIf Lvl = 2 Then Return 1250
		ElseIf Kind = EN_BANE Then
			Return 1500
		EndIf
	
	End Select
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² FINDITEM - Find unique item ID for shop
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function FindItem:Int()
	
	Local tmpList:TList = objList
	
	Local tmpR:Int, tmpPass:Int
	
	Local tmpLim:Int = MAX_ITEMS
	If b2Player = True And p_Dead[0] = False And p_Dead[1] = False Then tmpLim = MAX_ITEMS - 1
	
	Repeat 
		tmpPass = True
		tmpR = Rand(18, tmpLim)
		For o:Obj = EachIn objList
			If o.ID = OBJ_ITEM And o.D = 3 And o.Hurt = False Then
				If o.F = tmpR Then tmpPass = False; Exit
			EndIf
		Next
	Until tmpPass = True

	tmpList = Null
	Return tmpR
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² BUBBLECOL - Handles bubble to bubble collision
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function BubbleCol:Int(X:Int, Y:Int, ID:Int)

	Local tmpList:TList = bubList
	Local tmpRet:Int = -1
																	
	For b:Bub = EachIn tmpList
	
		If b.ID = 1 And b.F = 3 And b.SD = -1 Then		
			' // RIGHT SIDE TO RIGHT
			If RectsOverlap(Int(X) + 19, Int(Y) + 7, 4, 9, Int(b.X) + 19, Int(b.Y) + 7, 4, 9) = True Then
				b.X:+2
				tmpRet = 1

			' // LEFT SIDE TO LEFT
			ElseIf RectsOverlap(Int(X) + 9, Int(Y) + 7, 4, 9, Int(b.X) + 9, Int(b.Y) + 7, 4, 9) = True Then 
				b.X:-2
				tmpRet = 0

			' // LEFT SIDE TO RIGHT
			ElseIf RectsOverlap(Int(X) + 9, Int(Y) + 7, 4, 9, Int(b.X) + 19, Int(b.Y) + 7, 4, 9) = True Then
				b.X:-2
				tmpRet = 0
			
			' // RIGHT SIDE TO LEFT
			ElseIf RectsOverlap(Int(X) + 19, Int(Y) + 7, 4, 9, Int(b.X) + 9, Int(b.Y) + 7, 4, 9) = True Then
				b.X:+2
				tmpRet = 1

			EndIf		
		EndIf
		
		If tmpRet <> -1 Then Exit
	Next

	tmpList = Null
	
	Return tmpRet

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² BUBBLEPOP - Handles popping touching bubbles
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function BubblePop(X:Int, Y:Int, ID:Int, Pop:Int)

	Local tmpList:TList = bubList
	Local tmpRet:Int = -1
	
	For b:Bub = EachIn tmpList
		If b.ID = 1 And b.F = 3 And b.Cnt <> ID Then
			'// imgBubble / frame 3
			If ImagesCollide(imgCol, Int(X), Int(Y), 1, imgCol, Int(b.X), Int(b.Y), 1) Then 
				b.F = 4; b.T = GetMilliSecs()
				b.PopSrc = Pop ' // Source	
				If b.Spec <> 0 Then 
					specC:-1 ' // Decrement special bubble
					b.F = 5; b.T = GetMilliSecs() - 115
				EndIf
				If b.Cap <> 0 And b.Cnt <> PoppedID Then p_Chain[Pop]:+1 ' // Add to chain
				BubblePop(Int(b.X), Int(b.Y), b.Cnt, Pop) ' // Recursive
			EndIf
		EndIf
	Next

	tmpList = Null
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² BUBBLETOUCH - Returns whether bubbles are touching
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function BubbleTouch:Int(X:Int, Y:Int, ID:Int)

	Local tmpList:TList = bubList
	Local tmpRet:Int = 0
													
	For b:Bub = EachIn tmpList
		If b.ID = 1 And b.F = 3 And b.Cnt <> ID Then
			If ImagesCollide(imgBubble, Int(X), Int(Y), 3, imgBubble, Int(b.X), Int(b.Y), 3) Then 
				tmpList = Null
				Return True
			EndIf
		EndIf
	Next
	
	tmpList = Null
	Return False
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² HANDLEPAUSE - Handles pausing                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function HandlePause()

	If bPaused[PLAYER_1] = True Or bPaused[PLAYER_2] = True Then ' // PAUSE
		Local tmpIn:Int = 0

		Repeat
			GetFuncInput ' // Function Keys

			' // Only paused player can unpause
			If bPaused[PLAYER_1] = True Then
				If GetInput(PLAYER_1, INP_S) = True Then tmpIn = 1
			ElseIf bPaused[PLAYER_2] = True Then		
				If GetInput(PLAYER_2, INP_S) = True Then tmpIn = 1
			EndIf
			
			If KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True Then tmpIn = 2
			Delay 100 ' // Give CPU time
		Until tmpIn <> 0

		ResumeChannel musChan
		
		PlaySFX sfxPause; bPaused[PLAYER_1] = False; bPaused[PLAYER_2] = False
		pauseTotal = pauseTotal + (GetMilliSecs() - pauseStart) ' // Time offset fix

		FlushInput()
		
		If tmpIn = 2 Then EndGame ' // Allow escape to end program
		
	EndIf

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYSFX - Plays a sound at desired volume                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlaySFX:TChannel(mySound:TSound, myChan:TChannel = Null)
	
	If cfgSFX <> 0 Then
		If myChan <> Null Then
			myChan = PlaySound(mySound, myChan)
			myChan.SetVolume(Float(cfgSFX) / 10)

			Return myChan		
		Else
			Local tmpChan:TChannel = AllocChannel()
			tmpChan = PlaySound(mySound, tmpChan)
			tmpChan.SetVolume(Float(cfgSFX) / 10)

			Return tmpChan
		EndIf
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYMUSIC - Plays music at desired volume                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlayMusic:TChannel(mySound:TSound, myChan:TChannel = Null)
	
	'If cfgMusic <> 0 Then
		If myChan <> Null Then
			myChan = PlaySound(mySound, myChan)
			myChan.SetVolume(Float(cfgMusic) / 15)

			Return myChan		
		Else
			Local tmpChan:TChannel = AllocChannel()
			tmpChan = PlaySound(mySound, tmpChan)
			tmpChan.SetVolume(Float(cfgMusic) / 15)

			Return tmpChan
		EndIf
	'EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETMILLISECS - MilliSecs rollover fix                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetMilliSecs:Int()

	If LastMilliSecs = 0 Then LastMilliSecs = MilliSecs() 
	
	If MilliSecs() > LastMilliSecs Then MyMilliSecs = MyMilliSecs + (MilliSecs() - LastMilliSecs)
	If MilliSecs() < LastMilliSecs Then MyMilliSecs = MyMilliSecs + (LastMilliSecs - MilliSecs())

	LastMilliSecs = MilliSecs()
	Return MyMilliSecs - pauseTotal ' // Time offset fix
    
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWFONT - Draws bitmap font                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawFont(myStr:String, X:Int, Y:Int, bSmall:Int = 0, bMask:Int = False)

	Local fontW:Int = 8
	If bSmall = True Then fontW = 4; SetScale 1, 1
	
	Local i:Int
	If X = -1 Then ' // Center text
		Local tmpW:Int
		X = 294
		For i = 1 To Len(myStr$)
			tmpW:+(fontW * sclX)
		Next
		X:-Int(tmpW / 2)
	EndIf
	
	Local tmpX:Int = X, tmpY:Int = Y, tmpA:Int, tmpF:Int
	For i = 1 To Len(myStr)
		tmpA = Asc(Upper$(Mid$(myStr$, i, 1)))
		
		If tmpA >= 48 And tmpA <= 57 Then ' // Numbers
			tmpF = tmpA - 47
		ElseIf tmpA >= 65 And tmpA <= 90 Then ' // Letters
			tmpF = tmpA - 54
		ElseIf tmpA = 32 Then ' // Space
			tmpF = 0
		ElseIf tmpA = 46 Then ' // Period
			tmpF = 39
		ElseIf tmpA = 42 Then ' // Asterisk
			tmpF = 47
		ElseIf tmpA = 37 Then ' // Percent
			tmpF = 51			
		ElseIf tmpA = 47 Then ' // /
			tmpF = 51
		ElseIf tmpA = 62 Then ' // Player 1
			tmpF = 43
		ElseIf tmpA = 61 Then ' // Equals
			tmpF = 42
		ElseIf tmpA = 94 Then ' // Player 2
			tmpF = 44
		ElseIf tmpA = 41 Then ' // )
			tmpF = 50
		ElseIf tmpA = 44 Then ' // Comma
			tmpF = 40
		ElseIf tmpA = 45 Then ' // Hyphen
			tmpF = 38
		ElseIf tmpA = 33 Then ' // Exclamation
			tmpF = 45
		ElseIf tmpA = 58 Then ' // Colon
			tmpF = 41
		ElseIf tmpA = 35 Then ' // Hash
			tmpF = 47
		ElseIf tmpA = 36 Then ' // $ Up arrow
			tmpF = 53
		ElseIf tmpA = 43 Then ' // + Down arrow
			tmpF = 52
		ElseIf tmpA = 38 Then ' // & Wave star
			tmpF = 54
		ElseIf tmpA = 39 Then ' // '
			tmpF = 55
		EndIf
		
		'DebugLog tmpF
		
		If bMask = True Then
			DrawImage imgFont2, tmpX, tmpY, tmpF
		Else
			DrawImage imgFont, tmpX, tmpY, tmpF	
		EndIf
		
		tmpX:+(fontW * sclX)
		
	Next
	
	SetScale sclX, sclY' SetColor 255, 255, 255

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWPOINTS - Draws points
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawPoints(myStr:String, X:Int, Y:Int, P:Int = 0)

	Local fontW:Int = 5
	
	Local i:Int
	If X = -1 Then ' // Center text
		Local tmpW:Int
		X = 294
		For i = 1 To Len(myStr$)
			tmpW:+(fontW * sclX)
		Next
		X:-Int(tmpW / 2)
	EndIf
	
	Local tmpX:Int = X, tmpY:Int = Y, tmpA:Int, tmpF:Int
	For i = 1 To Len(myStr)
		tmpA = Asc(Upper$(Mid$(myStr$, i, 1)))
		
		If tmpA >= 48 And tmpA <= 57 Then ' // Numbers
			tmpF = tmpA - 48
		EndIf
		
		If P = 0 Then SetColor 92, 230, 52 ElseIf P = 1 Then SetColor 76, 206, 220
		DrawImage imgPoints, tmpX, tmpY, tmpF
		
		tmpX:+(fontW * sclX)	
	Next
	
	SetScale sclX, sclY; SetColor 255, 255, 255

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADINPUT - Reads in input CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadInput()

	Local File:TStream = ReadFile("input.cfg")
	
	For Local j:Int = 0 To 1
		For Local i:Int = 0 To 7
			inKey[j, i] = ReadLine(File)

			If j = 0 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J1" Then p1Joy = 1
			ElseIf j = 1 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J0" Then p2Joy = 0
			EndIf
			
		Next
	Next
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² FLUSHINPUT - Flushes joystick and keyboard input
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function FlushInput(flushI:Int = -1)

	If flushI = -1 Then ' // Flush all
		FlushKeys; FlushJoy 0; FlushJoy 1
		If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_A) = True Or GetInput(PLAYER_1, INP_S) = True Or GetInput(PLAYER_1, INP_X) = True Then
		EndIf
		If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_A) = True Or GetInput(PLAYER_2, INP_S) = True Or GetInput(PLAYER_2, INP_X) = True Then
		EndIf
		FlushKeys; FlushJoy 0; FlushJoy 1	
	
	ElseIf flushI = 0 Then ' // Flush player 1
		FlushKeys; FlushJoy 0
		If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_A) = True Or GetInput(PLAYER_1, INP_S) = True Or GetInput(PLAYER_1, INP_X) = True Then
		EndIf
		FlushKeys; FlushJoy 0
	
	ElseIf flushI = 1 Then ' // Flush player 2
		FlushKeys; FlushJoy 1
		If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_A) = True Or GetInput(PLAYER_2, INP_S) = True Or GetInput(PLAYER_2, INP_X) = True Then
		EndIf
		FlushKeys; FlushJoy 1

	EndIf	

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETINPUT - Converts inkeys to inputs                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetInput:Int(j:Int, i:Int, d:Int = 0)

	Local tmpRet:Int = False
	Local tmp:String = inKey[j, i]
	
	If Left$(tmp$, 1) = "K" Then ' // Keyboard
		tmp$ = Replace$(tmp$, "K", "")
		If d = 0 Then ' // KeyHit
			If KeyHit(Int(tmp$)) = True Then tmpRet = True		
		ElseIf d = 1 Then ' // KeyDown
			If KeyDown(Int(tmp$)) = True Then tmpRet = True
		EndIf
	ElseIf Left$(tmp$, 2) = "J0" Then ' // Joy 1
		If tmp$ = "J0U" Then ' // Up
			If JoyY(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0D" Then ' // Down
			If JoyY(0) = 1 Then tmpRet = True
		ElseIf tmp$ = "J0L" Then ' // Left
			If JoyX(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0R" Then ' // Right
			If JoyX(0) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J0", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 0) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 0) = True Then tmpRet = True
			EndIf
		EndIf
		
	ElseIf Left$(tmp$, 2) = "J1" Then ' // Joy 2
		If tmp$ = "J1U" Then ' // Up
			If JoyY(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1D" Then ' // Down
			If JoyY(1) = 1 Then tmpRet = True
		ElseIf tmp$ = "J1L" Then ' // Left
			If JoyX(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1R" Then ' // Right
			If JoyX(1) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J1", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 1) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 1) = True Then tmpRet = True
			EndIf
		EndIf
		
	EndIf
	
	Return tmpRet
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADCFG - Reads in CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadCFG()

	Local File:TStream = ReadFile("bubbleRPG.cfg")
	cfgSFX = ReadInt(File)
	cfgMusic = ReadInt(File)
	cfgFilter = ReadInt(File)
	cfgCRT = ReadInt(File)
	cfgFull = ReadInt(File)
	cfgDiff = ReadInt(File)
	cfgTrack = ReadInt(File)
	cfgGFX = ReadInt(File)	
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVECFG - Writes CFG file                                 
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveCFG()

	Local File:TStream = WriteFile("bubbleRPG.cfg")
	WriteInt File, cfgSFX
	WriteInt File, cfgMusic
	WriteInt File, cfgFilter
	WriteInt File, cfgCRT
	WriteInt File, cfgFull
	WriteInt File, cfgDiff
	WriteInt File, cfgTrack
	WriteInt File, cfgGFX
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ENDGAME - Ends program                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function EndGame()
	SaveCFG()
	End
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² UPLOADSCORE - Uploads score via SFTP                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function UploadScore(myScore:String)

	' // CODE REMOVED TO KEEP SCORES SECURE

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADSCORES - Loads online hi scores
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadScores:Int()
	
	' // CODE REMOVED TO KEEP SCORES SECURE
					
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² QuickSort - Sorts online hi scores                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function QuickSort(arr:String[], first:Int, last:Int)

	Local pivot:Int = 0
	Local temp:String
	Local i:Int = 0
	Local j:Int = 0

	If first < last Then
		pivot = first
		i = first
		j = last

		While (i < j)			
			While (Int(Left$(arr[i], Len(arr[i]) - 8)) >= Int(Left$(arr[pivot], Len(arr[pivot]) - 8)) And i < last)
				i = i + 1
			End While

			While (Int(Left$(arr[j], Len(arr[j]) - 8)) < Int(Left$(arr[pivot], Len(arr[pivot]) - 8)))
				j = j - 1
			End While

			If i < j Then
				temp = arr[i]
				arr[i] = arr[j]
				arr[j] = temp
			End If
		End While

		temp = arr[pivot]
		arr[pivot] = arr[j]
		arr[j] = temp
		QuickSort(arr, first, j - 1)
		QuickSort(arr, j + 1, last)
	End If

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVESCREEN - Saves a PNG snapshot                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveScreen()
	Local tmpFN:Int = 0, Dir:Byte Ptr = ReadDir("snaps/"), file$
	Local tmpP:Int, tmpU:Int, tmpN:Int

	Repeat 
		file$ = NextFile(Dir)
		If FileType("snaps/" + file$) = 1 Then
			tmpP = Instr(file$, ".", 1)
			tmpU = Instr(file$, "_", 1)
			tmpN = Int(Mid(file$, tmpU + 1, tmpP - tmpU))
			If tmpN > tmpFN Then tmpFN = tmpN ' // New filenumber
		EndIf
	Until file$ = ""
	CloseDir Dir

	Local tmpX:Int, tmpY:Int
	If bWindowed = False Then tmpX = 26; tmpY = 16 Else tmpX = 0; tmpY = 0

	SetMaskColor 255, 0, 255
	Local imgScreen:TPixmap = GrabPixmap(tmpX, tmpY, 588, 448)
	SavePixmapPNG(imgScreen, "snaps/snap_" + (tmpFN + 1) + ".png", 9)
	
	GCRelease imgScreen
	GCCollect
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LEGACY FUNCTIONS                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RectsOverlap%(x0:Int, y0:Int, w0:Int, h0:Int, x2:Int, y2:Int, w2:Int, h2:Int)

	If x0 > (x2 + Int(w2 * sclX)) Or (x0 + Int(w0 * sclX)) < x2 Then Return False
	If y0 > (y2 + Int(h2 * sclY)) Or (y0 + Int(h0 * sclY)) < y2 Then Return False
	Return True
	
End Function

Function ImageRectCollide%(image:TImage, ix%, iy%, iframe%, rx%, ry%, rwidth%, rheight%)

   ResetCollisions
   CollideImage image, ix, iy, iframe, 0, 1
   
   If CollideRect(rx, ry, rwidth, rheight, 1, 0) Then Return True Else Return False

End Function

