' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ²
' // ² E I K O S
' // ² Version 1.0
' // ²
' // ² By EikSoft (www.EikSoft.com)
' // ² 4.20.24 Project Start
' // ² 4.25.24 Last Modified
' // ²
' // ² For J.B. - In loving memory of Celeste <3
' // ²
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //

SuperStrict

Framework BRL.Retro

Import BRL.GLMax2D 
Import BRL.D3D9Max2D
Import BRL.PNGLoader
Import BRL.WAVLoader
Import BRL.OGGLoader
Import PUB.FreeJoy
Import BRL.Random
Import SDL.SDLFreeAudio

SetAudioDriver("FreeAudio SDL")

AppTitle = "EikOS v1.0"
SeedRnd MilliSecs()

Global cfgGFX:Int = 0
Global cfgSFX:Int = 7
Global cfgFull:Int = 0
Global cfgLast:Int = 0
Global cfgDesk:Int[3]
Global cfgTitle:Int[3]
Global cfgWin:Int[3]
Global cfgText:Int[3]
Global cfgBorder:Int[3]
Global cfgSaver:Int = 0
Global cfgCurX:Int
Global cfgCurY:Int
Global cfgCur:Int

Global cfgShadow:Int

' // Input.Cfg
Global inKey:String[2, 8]

Global INP_U:Int = 0, INP_D:Int = 1, INP_L:Int = 2, INP_R:Int = 3, INP_B:Int = 4, INP_A:Int = 5, INP_X:Int = 6, INP_S:Int = 7 
Global p1Joy:Int = 0, p2Joy:Int = 1

Const PLAYER_1:Int = 0
Const PLAYER_2:Int = 1

LoadCFG()
LoadInput()

'cfgFull = 0

If cfgGFX = 0 Then
	SetGraphicsDriver GLMax2DDriver()
ElseIf cfgGFX = 1 Then
	SetGraphicsDriver D3D9Max2DDriver()
EndIf

' // Master flags
Global bWindowed:Int ' // Windowed
If cfgFull = 0 Then bWindowed = True Else bWindowed = False
Global bTitle:Int = True ' // Title screen
Global bDebug:Int = False ' // Debug info

If bWindowed = True Then 
	Graphics 588, 448, 0, 60
Else
	Graphics 640, 480, 32, 60
	HideMouse
EndIf

' // Tick count and FPS
Global MyMilliSecs:Int, LastMilliSecs:Int = MilliSecs() ' // MilliSecs FIX
Global FPS:Int, curFrames:Int, frameTimer:Int, fpsTimer:Int = GetMilliSecs() ' // FPS Counter

Global sclX:Float = 2.3, sclY:Float = 2.0

' // Joystick
Global bJoy1YHit:Int = False, bJoy1XHit:Int = False
Global curIn:Int = 0
Global inKeys:String[16]

SetMaskColor 255, 0, 255

' // OS
Global imgCur:TImage = LoadImage("gfx/cur2.png", MASKEDIMAGE)
Global imgClose:TImage = LoadImage("gfx/close.png", MASKEDIMAGE)
Global imgFont:TImage = LoadAnimImage("gfx/font.png", 5, 5, 0, 40, MASKEDIMAGE)

' // ICONS
Global imgJoustX:TImage = LoadImage("gfx/joustx.png", MASKEDIMAGE)
Global imgNemoX:TImage = LoadImage("gfx/nemox.png", MASKEDIMAGE)
Global imgDemonX:TImage = LoadImage("gfx/demonx.png", MASKEDIMAGE)
Global imgBubbleX:TImage = LoadImage("gfx/bubblex.png", MASKEDIMAGE)
Global imgGear:TImage = LoadImage("gfx/gear.png", MASKEDIMAGE)
Global imgCheck:TImage = LoadAnimImage("gfx/check.png", 8, 8, 0, 2, MASKEDIMAGE)
Global imgButton:TImage = LoadImage("gfx/button.png", MASKEDIMAGE)
Global imgPal:TImage = LoadImage("gfx/pal4.png", MASKEDIMAGE)
Global imgAsc:TImage = LoadAnimImage("gfx/asc.png", 8, 12, 0, 4, MASKEDIMAGE)
Global imgCurJoust:TImage = LoadAnimImage("gfx/cur_joust.png", 32, 32, 0, 2, MASKEDIMAGE)
Global imgCurBubble:TImage = LoadAnimImage("gfx/cur_bubble.png", 32, 32, 0, 2, MASKEDIMAGE)
Global imgCurNemo:TImage = LoadAnimImage("gfx/cur_nemo.png", 32, 32, 0, 4, MASKEDIMAGE)
Global imgCurNes:TImage = LoadAnimImage("gfx/cur_nes.png", 42, 66, 0, 4, MASKEDIMAGE)
Global imgBIOS:TImage = LoadImage("gfx/bios.png", MASKEDIMAGE)
Global imgCurJB:TImage = LoadAnimImage("gfx/cur_jb.png", 34, 30, 0, 2, MASKEDIMAGE)

' // SFX
Global sfxBoot:TSound = LoadSound("sfx/boot.wav")
Global sfxHum:TSound = LoadSound("sfx/hum.ogg", SOUND_LOOP)
Global sfxClick:TSound = LoadSound("sfx/click.wav")
Global sfxStartup:TSound = LoadSound("sfx/startup.wav")
Global sfxChord:TSound = LoadSound("sfx/chord.wav")

Global humChan:TChannel = AllocChannel()

Global curX:Int = 294, curY:Int = 224, curS:Int = 3, curT:Int = GetMilliSecs()
Global bConfig:Int = False, bMouseDown:Int = False, bBoot:Int = True
Global bootC:Int = 0, bootT:Int = GetMilliSecs(), curBlink:Int = False
Global flashT:Int, flashC:Int, cSel:Int = 0, ramC:Int = 0
Global saverT:Int, bSaver:Int = False, saverD:Int, curF:Int
Global bJB:Int = False, jbC:Int = 0

Global o:Obj, objList:TList = CreateList()

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² OBJECTS                                        
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Obj   
    Field X:Float, Y:Float, ID:Int, F:Int, D:Float, Spd:Float, YSpd:Float
	Field A:Int, R:Float, S:Float, Alp:Float, H:Int, Rot:Int, T:Int, OY:Int
	
    Function Create:Obj(X:Int, Y:Int, ID:Int, F:Int)
		o:Obj = New Obj
		o.X = X; o.Y = Y; o.ID = ID
		
		If o.ID = 1 Then ' // Bounce
			o.F = F
			o.D = saverD
			o.Spd = 2
			o.YSpd = 3
			o.Rot = Rand(0, 359)
			
		ElseIf o.ID = 2 Then ' // Particles
			o.A = Rand(0, 359)								
			o.R = 0
			o.S = Rnd(1.5, 4)
			o.D = Rnd(.05, .1)
			o.H = Rand(0, 1)
		
		ElseIf o.ID = 3 Then ' // Matrix
			o.D = Rand(33, 126)
			o.T = GetMilliSecs()
			o.OY = Y
		
		ElseIf o.ID = 4 Then ' // Fader
			o.T = GetMilliSecs()
			o.D = F
			o.Alp = 1
			o.A = 0
		EndIf
		
		Return o
		
	End Function
	
	Method Render()
		Local Del:Int = False
		Local createO:Int = 0, cX:Int, cY:Int, cD:Int
		
		If ID = 1 Then ' // Bounce

			Rem
			If F = 0 Then
				SetAlpha ALPHABLEND; SetScale 1, 1
				If F = 0 Then SetAlpha .1 ElseIf F = 1 Then SetAlpha .05 ElseIf F = 2 Then SetAlpha .035 ElseIf F = 3 Then SetAlpha .02
				SetRotation Rot
				SetColor cfgText[0], cfgText[1], cfgText[2]
				DrawImage imgFlare, Int(X) + 8, Int(Y) + 12
				Rot:+1
				SetAlpha ALPHABLEND; SetAlpha 1; SetRotation 0
			EndIf
			EndRem
			
			SetScale 2, 2
			SetColor cfgText[0], cfgText[1], cfgText[2]
			If F = 0 Then SetAlpha 1 ElseIf F = 1 Then SetAlpha .5 ElseIf F = 2 Then SetAlpha .35 ElseIf F = 3 Then SetAlpha .2
			DrawImage imgAsc, Int(X), Int(Y), F
			SetAlpha 1
			SetColor 255, 255, 255
			SetScale sclX, sclY
			
			Local oldD:Int = D
			If D = 0 Then ' // UP / LEFT
				Y:-YSpd
				X:-Spd
				
				If X - Spd < 0 Then
					D = 1
				ElseIf Y - YSpd < 0 Then
					D = 3
				EndIf
														
			ElseIf D = 1 Then ' // UP / RIGHT
				Y:-YSpd
				X:+Spd

				If X + Spd > 588 - Int(ImageWidth(imgAsc) * 2) Then
					D = 0
				ElseIf Y - YSpd < 0 Then
					D = 2
				EndIf
														
			ElseIf D = 2 Then ' // DOWN / RIGHT
				Y:+YSpd
				X:+Spd

				If X + Spd > 588 - Int(ImageWidth(imgAsc) * 2) Then
					D = 3
				ElseIf Y + YSpd > 448 - Int(ImageHeight(imgAsc) * 2) Then
					D = 1
				EndIf

			ElseIf D = 3 Then ' // DOWN / LEFT
				Y:+YSpd
				X:-Spd

				If X -Spd < 0 Then
					D = 2
				ElseIf Y + YSpd > 448 - Int(ImageHeight(imgAsc) * 2) Then
					D = 0
				EndIf
												
			EndIf	
		
			If oldD <> D And F = 0 Then 
				createO = 1
				If oldD = 0 Then 
					cX = X; cY = Y
				ElseIf oldD = 1 Then
					cX = X + 16; cY = Y
				ElseIf oldD = 2 Then
					cX = X + 16; cY = Y + 24
				ElseIf oldD = 3 Then
					cX = X; cY = Y + 24
				EndIf
			EndIf
			
		ElseIf ID = 2 Then ' // Particle
			SetBlend LIGHTBLEND; SetAlpha Alp
			SetScale 1, 1

			If H = 0 Then
				SetColor 255, 255, 255
			Else
				SetColor cfgText[0], cfgText[1], cfgText[2]
			EndIf							
			
			Local tmpS:Int			
			If S >= 1.5 Then ' // Sizing
				tmpS = 4; Alp = 1
			ElseIf S >= .5 Then
				tmpS = 3; Alp = .66
			Else
				tmpS = 2; Alp = .33
			EndIf			

			tmpS:+1
			DrawRect Float((R * Cos(A) + X) - (tmpS / 2)), Float((R * Sin(A) + Y) - (tmpS / 2)), tmpS, tmpS
						
			SetRotation 0
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255
			
			R = R + S
			If Alp > 0 Then Alp = Alp - .03 Else Del = True
			If S > 0 Then S = S - D Else Del = True
		
		ElseIf ID = 3 Then ' // Matrix	
				
			SetScale 2, 2
			'SetColor cfgText[0], cfgText[1], cfgText[2]
			SetColor 255, 255, 255
			DrawText Chr(D), Int(X), Int(Y)
			SetAlpha 1
			SetColor 255, 255, 255
			SetScale sclX, sclY
			
			If GetMilliSecs() >= T + 80 Then
				D = Rand(33, 126)
				T = GetMilliSecs()
			EndIf
			
			If Y < 448 Then 
				Y:+4 

				If Y - 4 >= OY + 24 Then 
					createO = 2
					cX = X
					cY = Y - 4
					cD = D
					
					OY = Y - 4
					
					CheckFader(Int(X), Int(Y - 4))
				EndIf
				
			Else 
				Del = True
				
			EndIf
								
		ElseIf ID = 4 Then ' // Fader

			SetScale 2, 2
			If A = 0 Then
				SetColor cfgText[0], cfgText[1], cfgText[2]
			Else
				SetColor 255, 255, 255
			EndIf
			SetAlpha Alp
			DrawText Chr(D), Int(X), Int(Y)
			SetAlpha 1
			SetColor 255, 255, 255
			SetScale sclX, sclY
			
			If Rand(1, 1000) = 500 Then
				If A = 0 Then A = 1
			EndIf

			If Rand(1, 200) = 100 Then
				D = Rand(33, 126)
			EndIf
			'If GetMilliSecs() >= T + 80 Then
			'	D = Rand(33, 126)
			'	T = GetMilliSecs()
			'EndIf
			
			Alp:-.015
			If Alp <= 0 Del = True
					
		EndIf
		
		If Del = True Then objList.Remove o
		
		If createO <> 0 Then
			If createO = 1 Then
				For Local i:Int = 0 To 14
					objList.AddLast obj.Create(cX, cY, 2, 0)
				Next
			ElseIf createO = 2 Then
				objList.AddLast obj.Create(cX, cY, 4, cD)
			EndIf
			
		EndIf
		
	End Method
	
End Type

If AppArgs.length >= 2 Then ' // First boot check
	If AppArgs[1] = "1" Then bBoot = False; curX = cfgCurX; curY = cfgCurY
EndIf

If bBoot = True Then 
	cfgLast = 0
	If cfgFull = 1 Then SleepDelay(2000) ' // Allow screen change
EndIf

' // Config window
Global winX:Int = 121, winY:Int = 130, winW:Int = 150, winH:Int = 94

#MAIN
DefData "MAIN"

' // Restore last window
If cfgLast = 1 Then ' // Config
	bConfig = True
	cSel = 0
EndIf

HideMouse
SetScale sclX, sclY

' // DEBUG
'bBoot = False; bConfig = True; cSel = 1

If bBoot = True Then PlaySFX sfxBoot Else humChan = PlaySFX(sfxHum)

saverT = GetMilliSecs()
bootT = GetMilliSecs()

FlushInput
Repeat
	Cls
	frameTimer = GetMilliSecs()	

	SetColor 255, 255, 255; SetBlend ALPHABLEND; SetAlpha 1
	If bWindowed = False Then SetOrigin 26, 16 Else SetOrigin 0, 0 ' // Fullscreen
	SetScale sclX, sclY

	If bBoot = True Then ' // Booting
		DrawBoot()
		
	Else ' // Running
		DrawDesktop()
			
		' // DESKTOP ICONS
		DrawIcon(imgJoustX, 33, 40, "JoustX")
		DrawIcon(imgNemoX, 128, 40, "NemoX")
		DrawIcon(imgDemonX, 224, 40, "DemonX")
		DrawIcon(imgBubbleX, 320, 40, "BBRPG")
		DrawIcon(imgGear, 33, 378, "Config")
		
		If bConfig = True Then DrawConfig() ' // Config window		

		DrawCursor() ' // Mouse cursor
		DrawSaver() ' // Screen saver
		
		UserInput() ' // Mouse Input	
	EndIf
	
	If KeyHit(KEY_F1) Then SaveScreen ' // PNG snapshot	
		
	If GetMilliSecs() >= fpsTimer + 1000 Then FPS = curFrames; curFrames = 0; fpsTimer = GetMilliSecs()
	curFrames = curFrames + 1

	DrawOverlay()
	Flip -1
Until KeyHit(KEY_ESCAPE) Or AppTerminate() = True
EndGame()

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² UserINPUT - Gets user input to operate the mouse
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function UserInput()

	If GetInput(0, INP_A, True) = True Then ' // Mouse speed
		curS = 6
		saverT = GetMilliSecs(); bSaver = False
	Else
		curS = 3
	EndIf

	bMouseDown = False
	
	If GetInput(0, INP_B) = True Then
		If bSaver = False Then bMouseDown = True
		
		If curX = 577 And curY = 429 And bConfig = False Then
			jbC:+1
			
			If jbC >= 7 And bJB = False Then bJB = True
		EndIf
		
		PlaySFX sfxClick
		
		'SetColor 255, 255, 0
		'DrawRect 566, 2, 8, 8
		'SetColor 255, 255, 255
		
		If bSaver = False Then
			If RectsOverlap(566, 2, 8, 8, curX, curY, 1, 1) Then
				If bConfig = False Then
					SleepDelay(100)
					EndGame() ' // CLOSE
				Else
					If bConfig = True Then ' // Flash active window
						flashC = 1; flashT = GetMilliSecs()
					EndIf				
				EndIf
			EndIf
				
			If RectsOverlap(Int((winX + (winW * sclX)) - 22), winY + 2, 8, 8, curX, curY, 1, 1) Then ' // CLOSE
				If bConfig = True Then
					bConfig = False
					cfgLast = 0
				EndIf
			EndIf
		EndIf
		
		bSaver = False
		saverT = GetMilliSecs()

	EndIf
		
	If GetInput(0, INP_R, True) = True Then
		If curX + curS < 588 - ImageWidth(imgCur) Then curX:+curS Else curX = 588 - ImageWidth(imgCur)
		saverT = GetMilliSecs(); bSaver = False

	ElseIf GetInput(0, INP_L, True) = True Then
		If curX - curS > 0 Then curX:-curS Else curX = 0
		saverT = GetMilliSecs(); bSaver = False

	EndIf
	
	If GetInput(0, INP_D, True) = True Then
		If curY + curS < 448 - ImageHeight(imgCur) Then curY:+curS Else curY = 448 - ImageHeight(imgCur)
		saverT = GetMilliSecs(); bSaver = False

	ElseIf GetInput(0, INP_U, True) = True Then
		If curY - curS > 0 Then curY:-curS Else curY = 0
		saverT = GetMilliSecs(); bSaver = False

	EndIf

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWBOOT - Draws boot sequence                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawBoot()
		
	SetColor 255, 255, 255; SetScale 1, 1
	DrawImage imgBIOS, 588 - ImageWidth(imgBIOS) - 32, (3 * 16) + 8
		
	SetScale sclX, sclY
	SetColor 51, 255, 0
	If bootC >= 0 Then DrawFont "EikBIOS Version 4.04", 8, (0 * 16) + 8
	If bootC >= 1 Then DrawFont "Copyright 1986-2024 EikSoft - All Rights Reserved.", 8, (1 * 16) + 8
	If bootC >= 2 Then DrawFont "", 8, (2 * 16) + 8
	If bootC >= 3 Then DrawFont "CPU 486DX4 100mhz", 8, (3 * 16) + 8	
	If bootC >= 4 Then DrawFont "0000640K System RAM Passed", 8, (4 * 16) + 8
	If bootC >= 5 Then ' // RAM Counter
		Local tmpS:String = String(ramC)
		If ramC = 999999 Then tmpS$ = "15360"
		tmpS$ = RSet(tmpS$, 7)
		tmpS$ = Replace(tmpS$, " ", "0")
		
		DrawFont tmpS$ + "K Extended RAM Passed", 8, (5 * 16) + 8
		If ramC + 64 < 15360 Then ' // Counting
			ramC:+64 
		Else ' // Done
			If ramC <> 999999 Then bootC:+1; bootT = GetMilliSecs()		
			ramC = 999999
		EndIf
	EndIf
	If bootC >= 6 Then DrawFont "0256K Cache SRAM Passed", 8, (6 * 16) + 8
	If bootC >= 7 Then DrawFont "", 8, (7 * 16) + 8
	If bootC >= 8 Then 
		DrawFont "Starting EikOS...", 8, (9 * 16) + 8
		bootC = 9
	EndIf
	
	If curBlink = False Then DrawFont "_", 8, ((bootC + 1) * 16) + 8
	
	' // Cursor blink
	If GetMilliSecs() >= curT + 530 Then
		If curBlink = False Then curBlink = True Else curBlink = False
		curT = GetMilliSecs()
	EndIf
	
	' // Boot sequence
	If bootC <> 5 Then 
		If GetMilliSecs() >= bootT + 545 Then
			If bootC < 8 Then 
				bootC:+1
				If bootC = 7 Then humChan = PlaySFX(sfxHum)
				bootT = GetMilliSecs()
			Else 
				If GetMilliSecs() >= bootT + 2500 Then 
					saverT = GetMilliSecs()
					bBoot = False
					PlaySFX sfxStartup				
					FlushInput
				EndIf
			EndIf
		EndIf
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWDESKTOP - Draws desktop area with titlebar                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawDesktop()

	' // Desktop
	'SetColor 0, 0, 76
	SetColor cfgDesk[0], cfgDesk[1], cfgDesk[2]
	DrawRect 0, 0, 256, 224

	' // Top Menu
	SetColor cfgTitle[0], cfgTitle[1], cfgTitle[2]
	DrawRect 0, 0, 256, 10
	SetColor 255, 255, 255

	'If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawRect 0, 20, 256, 1
	'EndIf
	
	' // EIKOS
	SetScale sclX, sclY
	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]		
		DrawFont "EikOS v1.0", 10, 7
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "EikOS v1.0", 8, 5
	SetColor 255, 255, 255	
	DrawImage imgClose, 566, 2

	' // SYSTEM TIME
	DrawTime(470, 5)
	
	DrawImage imgClose, 566, 2 ' // CLOSE

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWCONFIG - Draws config window                        
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawConfig()

	SetScale sclX, sclY

	If flashC > 0 Then
		If flashC Mod 2 = 0 Then 
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2] 
		Else 
			SetColor 255 ~ cfgBorder[0] , 255 ~ cfgBorder[1], 255 ~ cfgBorder[2]			
		EndIf
		
		If GetMilliSecs() >= flashT + 100 Then
			If flashC < 8 Then flashC:+1 Else flashC = 0
			flashT = GetMilliSecs()
		EndIf
	Else
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2] 
		
	EndIf
	
	DrawRect winX - 2, winY - 2, winW + 2, winH + 2
			
	SetColor cfgWin[0], cfgWin[1], cfgWin[2]
	DrawRect winX, winY, winW, winH
	
	' // Top Menu
	SetColor cfgTitle[0], cfgTitle[1], cfgTitle[2]
	DrawRect winX, winY, winW, 10		

	'If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawRect winX, winY + 20, winW, 1
	'EndIf
	
	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawFont "Config", winX + 10, winY + 7
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "Config", winX + 8, winY + 5	
	SetColor 255, 255, 255	
	DrawImage imgClose, (winX + (winW * sclX)) - 22, winY + 2

	Local listW:Int = 68, listH:Int = 76
	
	' // Listbox
	SetColor 168, 168, 168
	DrawRect winX + 8, winY + 28, listW, listH
	SetColor 0, 0, 0
	DrawRect winX + 10, winY + 30, listW - 2, listH - 2
	SetColor 255, 255, 255
	
	' // Selection
	SetColor cfgTitle[0], cfgTitle[1], cfgTitle[2]
	DrawRect winX + 12, (winY + 32) + (cSel * 16), listW - 4, 8

	'DrawRect winX + 12, winY + 48, listW - 4, 8
	
	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawFont "OS Options", winX + 16, winY + 36
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "OS Options", winX + 14, winY + 34

	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawFont "Input", winX + 16, winY + 52
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "Input", winX + 14, winY + 50

	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawFont "Screensaver", winX + 16, winY + 68
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "Screensaver", winX + 14, winY + 66

	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]	
		DrawFont "Mouse cursor", winX + 16, winY + 84
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "Mouse cursor", winX + 14, winY + 82

	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawFont "Desk Color", winX + 16, winY + 100
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "Desk Color", winX + 14, winY + 98

	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawFont "Title Color", winX + 16, winY + 116
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "Title Color", winX + 14, winY + 114

	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawFont "Win Color", winX + 16, winY + 132
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "Win Color", winX + 14, winY + 130

	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]	
		DrawFont "Text Color", winX + 16, winY + 148
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "Text Color", winX + 14, winY + 146

	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]	
		DrawFont "Border Color", winX + 16, winY + 164
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont "Border Color", winX + 14, winY + 162
	SetColor 255, 255, 255	

	If cSel = 0 Then ' // BIOS
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 28, cfgFull ' // FS
		
		Local tmpC:Int = 0
		If cfgGFX = 0 Then tmpC = 1 Else tmpC = 0
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 52, tmpC ' // GL

		If cfgGFX = 1 Then tmpC = 1 Else tmpC = 0		
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 76, tmpC ' // D3D
		
		If cfgSFX <> 0 Then tmpC = 1 Else tmpC = 0		
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 100, tmpC ' // SOUND
		
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 124, cfgShadow ' // SHADOW

		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "Fullscreen", Int(winX + (listW * sclX)) + 52, winY + 33
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "Fullscreen", Int(winX + (listW * sclX)) + 50, winY + 31

		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "OpenGL", Int(winX + (listW * sclX)) + 52, winY + 57
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "OpenGL", Int(winX + (listW * sclX)) + 50, winY + 55

		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "DirectDD9", Int(winX + (listW * sclX)) + 52, winY + 81
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "Direct3D9", Int(winX + (listW * sclX)) + 50, winY + 79
	
		If cfgShadow = True Then		
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "Sound", Int(winX + (listW * sclX)) + 52, winY + 105
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "Sound", Int(winX + (listW * sclX)) + 50, winY + 103

		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "Text Shadow", Int(winX + (listW * sclX)) + 52, winY + 129
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "Text Shadow", Int(winX + (listW * sclX)) + 50, winY + 127	
		
		SetColor 255, 255, 255
		DrawImage imgButton, Int(winX + (listW * sclX)) + 24, winY + 148
		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "Defaults", Int(winX + (listW * sclX)) + 32, winY + 157
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "Defaults", Int(winX + (listW * sclX)) + 30, winY + 155
		SetColor 255, 255, 255
		
		If bMouseDown = True Then ' // Click
			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 28), 8, 8, curX, curY, 1, 1) Then ' // FS
				If cfgFull = 0 Then cfgFull = 1 Else cfgFull = 0
				cfgLast = 1; SaveCFG()
				SleepDelay(100)
				system_("launcher.exe 9")
				EndGame				
			EndIf
			
			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 52), 8, 8, curX, curY, 1, 1) Then ' // GL
				If cfgGFX = 1 Then cfgGFX = 0
			EndIf

			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 76), 8, 8, curX, curY, 1, 1) Then ' // D3D
				If cfgGFX = 0 Then cfgGFX = 1
			EndIf
			
			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 100), 8, 8, curX, curY, 1, 1) Then ' // Sound
				If cfgSFX = 7 Then 
					cfgSFX = 0 
					StopChannel humChan
				Else 
					cfgSFX = 7
					humChan = PlaySFX(sfxHum)
				EndIf
			EndIf
			
			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 124), 8, 8, curX, curY, 1, 1) Then ' // D3D
				If cfgShadow = 0 Then cfgShadow = 1 Else cfgShadow = 0
			EndIf
			
			If RectsOverlap(Int(winX + (listW * sclX)) + 24, winY + 148, 43, 12, curX, curY, 1, 1) Then ' // DEFAULTS
				cfgFull = 0
				cfgSFX = 7
				cfgGFX = 0
				
				StopChannel humChan
				humChan = PlaySFX(sfxHum)
				
				' // Desk color
				cfgDesk[0] = 0
				cfgDesk[1] = 0
				cfgDesk[2] = 168

				' // Text color
				cfgText[0] = 184
				cfgText[1] = 248
				cfgText[2] = 24
				
				' // Text shadow
				cfgShadow = 1

				' // Title color
				cfgTitle[0] = 0
				cfgTitle[1] = 88
				cfgTitle[2] = 248

				' // Win color
				cfgWin[0] = 0
				cfgWin[1] = 0
				cfgWin[2] = 255

				' // Border color
				cfgBorder[0] = 0
				cfgBorder[1] = 0
				cfgBorder[2] = 0	
							
				cfgSaver = 2
				cfgCur = 0
				
			EndIf
			
		EndIf
	
	ElseIf cSel = 1 Then ' // INPUT

		DrawImage imgButton, Int(winX + (listW * sclX)) + 24, winY + 28
		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "EikOS", Int(winX + (listW * sclX)) + 48, winY + 37
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "EikOS", Int(winX + (listW * sclX)) + 46, winY + 35
		SetColor 255, 255, 255
		
		DrawImage imgButton, Int(winX + (listW * sclX)) + 24, winY + 58		
		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "JoustX", Int(winX + (listW * sclX)) + 41, winY + 67
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "JoustX", Int(winX + (listW * sclX)) + 39, winY + 65
		SetColor 255, 255, 255

		DrawImage imgButton, Int(winX + (listW * sclX)) + 24, winY + 88		
		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "NemoX", Int(winX + (listW * sclX)) + 45, winY + 97
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "NemoX", Int(winX + (listW * sclX)) + 43, winY + 95
		SetColor 255, 255, 255

		DrawImage imgButton, Int(winX + (listW * sclX)) + 24, winY + 118		
		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "DemonX", Int(winX + (listW * sclX)) + 39, winY + 127
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "DemonX", Int(winX + (listW * sclX)) + 37, winY + 125
		SetColor 255, 255, 255

		DrawImage imgButton, Int(winX + (listW * sclX)) + 24, winY + 148		
		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "BBRPG", Int(winX + (listW * sclX)) + 48, winY + 157
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "BBRPG", Int(winX + (listW * sclX)) + 46, winY + 155
		SetColor 255, 255, 255
		
		If bMouseDown = True Then
			If RectsOverlap(Int(winX + (listW * sclX)) + 24, winY + 28, 43, 12, curX, curY, 1, 1) Then ' // EIKOS		
				InpConfig(0)	
			EndIf

			If RectsOverlap(Int(winX + (listW * sclX)) + 24, winY + 58, 43, 12, curX, curY, 1, 1) Then ' // JOUSTX
				If FileType("JoustX\joustx.exe") = 0 Then
					PlaySFX sfxChord
				Else				
					InpConfig(1)
				EndIf
			EndIf
			
			If RectsOverlap(Int(winX + (listW * sclX)) + 24, winY + 88, 43, 12, curX, curY, 1, 1) Then ' // NEMOX
				If FileType("NemoX\nemox.exe") = 0 Then
					PlaySFX sfxChord
				Else			
					InpConfig(2)
				EndIf
			EndIf

			If RectsOverlap(Int(winX + (listW * sclX)) + 24, winY + 118, 43, 12, curX, curY, 1, 1) Then ' // DEMONX
				If FileType("DemonX\demonx.exe") = 0 Then
					PlaySFX sfxChord
				Else					
					InpConfig(3)
				EndIf
			EndIf
									
			If RectsOverlap(Int(winX + (listW * sclX)) + 24, winY + 148, 43, 12, curX, curY, 1, 1) Then ' // BBRPG
				If FileType("BubbleRPG\bubblerpg.exe") = 0 Then
					PlaySFX sfxChord
				Else			
					InpConfig(4)
				EndIf
			EndIf
												
		EndIf
	
	ElseIf cSel = 2 Then ' // SCREENSAVER
		Local tmpC:Int = 0
		If cfgSaver = 0 Then tmpC = 1 Else tmpC = 0
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 28, tmpC ' // OFF
		
		If cfgSaver = 1 Then tmpC = 1 Else tmpC = 0
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 52, tmpC ' // BOUNCE

		If cfgSaver = 2 Then tmpC = 1 Else tmpC = 0
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 76, tmpC ' // MATRIX
		
		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "Off", Int(winX + (listW * sclX)) + 52, winY + 33
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "Off", Int(winX + (listW * sclX)) + 50, winY + 31

		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "Bounce", Int(winX + (listW * sclX)) + 52, winY + 57
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "Bounce", Int(winX + (listW * sclX)) + 50, winY + 55

		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "Matrix", Int(winX + (listW * sclX)) + 52, winY + 81
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "Matrix", Int(winX + (listW * sclX)) + 50, winY + 79		
	
		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]	
			DrawFont "30 secs start", Int(winX + (listW * sclX)) + 26, winY + 164
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "30 secs start", Int(winX + (listW * sclX)) + 24, winY + 162
		SetColor 255, 255, 255	
		
		If bMouseDown = True Then
			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 28), 8, 8, curX, curY, 1, 1) Then ' // FS
				cfgSaver = 0
			EndIf
			
			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 52), 8, 8, curX, curY, 1, 1) Then ' // GL
				cfgSaver = 1
			EndIf

			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 76), 8, 8, curX, curY, 1, 1) Then ' // D3D
				cfgSaver = 2
			EndIf
					
		EndIf
	
	ElseIf cSel = 3 Then ' // CURSOR
		Local tmpC:Int = 0
		If cfgCur = 0 Then tmpC = 1 Else tmpC = 0
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 28, tmpC ' // Default
		
		If cfgCur = 1 Then tmpC = 1 Else tmpC = 0
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 52, tmpC ' // Joust

		If cfgCur = 2 Then tmpC = 1 Else tmpC = 0	
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 76, tmpC ' // Nemo
		
		If cfgCur = 3 Then tmpC = 1 Else tmpC = 0	
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 100, tmpC ' // Bubble
		
		If cfgCur = 4 Then tmpC = 1 Else tmpC = 0	
		DrawImage imgCheck, Int(winX + (listW * sclX)) + 24, winY + 124, tmpC ' // Nesticle

		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "Default", Int(winX + (listW * sclX)) + 52, winY + 33
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "Default", Int(winX + (listW * sclX)) + 50, winY + 31

		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "JoustX", Int(winX + (listW * sclX)) + 52, winY + 57
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "JoustX", Int(winX + (listW * sclX)) + 50, winY + 55

		If cfgShadow = True Then
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "NemoX", Int(winX + (listW * sclX)) + 52, winY + 81
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "NemoX", Int(winX + (listW * sclX)) + 50, winY + 79

		If cfgShadow = True Then		
			SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "BBRPG", Int(winX + (listW * sclX)) + 52, winY + 105
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "BBRPG", Int(winX + (listW * sclX)) + 50, winY + 103

		If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
			DrawFont "NESticle", Int(winX + (listW * sclX)) + 52, winY + 129
		EndIf
		SetColor cfgText[0], cfgText[1], cfgText[2]
		DrawFont "NESticle", Int(winX + (listW * sclX)) + 50, winY + 127	
				
		If bMouseDown = True Then ' // Click
			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 28), 8, 8, curX, curY, 1, 1) Then ' // FS
				cfgCur = 0
				curF = 0
			EndIf
			
			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 52), 8, 8, curX, curY, 1, 1) Then ' // GL
				cfgCur = 1
				curF = 0
			EndIf

			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 76), 8, 8, curX, curY, 1, 1) Then ' // D3D
				cfgCur = 2
				curF = 0
			EndIf
			
			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 100), 8, 8, curX, curY, 1, 1) Then ' // Sound
				cfgCur = 3
				curF = 0
			EndIf

			If RectsOverlap(Int(winX + (listW * sclX) + 24), Int(winY + 124), 8, 8, curX, curY, 1, 1) Then ' // Sound
				cfgCur = 4
				curF = 0
			EndIf
						
		EndIf
		
	ElseIf cSel >= 4 Then ' // DESK COLOR
		
		SetScale 1.5, 1.5
		DrawImage imgPal, Int(winX + (listW * sclX)) + 24, winY + 28
		
		If bMouseDown = True Then
			'SetColor 255, 255, 0
			'DrawRect Int(winX + (listW * sclX)) + 24, winY + 28, 84, 96
			'SetColor 255, 255, 255
			
			If RectsOverlap2(Int(winX + (listW * sclX)) + 24, winY + 28, 84, 96, curX, curY, 1, 1) Then ' // PAL
				Local tmpX:Int = Int(winX + (listW * sclX) + 24 - curX)
				Local tmpY:Int = Int((winY + 28) - curY)
				'DebugLog "X: " + String(Abs(tmpX))
				'DebugLog "Y: " + String(Abs(tmpY))
				Local tmpCol:Int = SeekColor(Abs(tmpX), Abs(tmpY))
				
				Local tmpR:Int, tmpG:Int, tmpB:Int
				If cSel = 4 Then ' // Desk color
					cfgDesk[0] = (tmpCol & $FF0000) Shr 16
					cfgDesk[1] = (tmpCol & $FF00) Shr 8
					cfgDesk[2] = (tmpCol & $FF)
					
				ElseIf cSel = 5 Then ' // Title color
					cfgTitle[0] = (tmpCol & $FF0000) Shr 16
					cfgTitle[1] = (tmpCol & $FF00) Shr 8
					cfgTitle[2] = (tmpCol & $FF)		
						
				ElseIf cSel = 6 Then ' // Win color
					cfgWin[0] = (tmpCol & $FF0000) Shr 16
					cfgWin[1] = (tmpCol & $FF00) Shr 8
					cfgWin[2] = (tmpCol & $FF)		
				
				ElseIf cSel = 7 Then ' // Text color
					cfgText[0] = (tmpCol & $FF0000) Shr 16
					cfgText[1] = (tmpCol & $FF00) Shr 8
					cfgText[2] = (tmpCol & $FF)
				
				ElseIf cSel = 8 Then ' // Border color
					cfgBorder[0] = (tmpCol & $FF0000) Shr 16
					cfgBorder[1] = (tmpCol & $FF00) Shr 8
					cfgBorder[2] = (tmpCol & $FF)
				
				EndIf
				
				'DebugLog "R: " + tmpR + ", B: " + tmpB + ", G: " + tmpG
			
			EndIf			
			
		EndIf

		SetScale sclX, sclY
		
	EndIf
	
	' // Listbox clicks
	If bMouseDown = True Then
		For Local i:Int = 0 To 8
			If RectsOverlap(winX + 12, (winY + 32) + (i * 16), listW - 4, 8, curX, curY, 1, 1) = True Then
				cSel = i
			EndIf		
		Next
		
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWCURSOR - Draws mouse cursor                        
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawCursor()
	SetColor 255, 255, 255
	
	SetScale 1, 1	
	
	If bJB = True Then ' // Easter Egg JB Mode
		DrawImage imgCurJB, curX, curY, curF
		
		If GetMilliSecs() >= curT + 240 Then
			If curF = 0 Then curF = 1 Else curF = 0
			curT = GetMilliSecs()
		EndIf
		
		Return
	EndIf
	
	' // Mouse cursor
	If cfgCur = 0 Then
		DrawImage imgCur, curX, curY
				
	ElseIf cfgCur = 1 Then
		DrawImage imgCurJoust, curX, curY, curF
		
		If GetMilliSecs() >= curT + 320 Then
			If curF = 0 Then curF = 1 Else curF = 0
			curT = GetMilliSecs()
		EndIf
		
	ElseIf cfgCur = 2 Then
		DrawImage imgCurNemo, curX, curY, curF
		
		If GetMilliSecs() >= curT + 160 Then
			If curF < 3 Then curF:+1 Else curF = 0
			curT = GetMilliSecs()
		EndIf
		
	ElseIf cfgCur = 3 Then
		DrawImage imgCurBubble, curX, curY, curF
		
		If GetMilliSecs() >= curT + 320 Then
			If curF = 0 Then curF = 1 Else curF = 0
			curT = GetMilliSecs()
		EndIf
	
	ElseIf cfgCur = 4 Then
		DrawImage imgCurNes, curX, curY, curF
		
		If GetMilliSecs() >= curT + 240 Then
			If curF < 3 Then curF:+1 Else curF = 0
			curT = GetMilliSecs()
		EndIf
	
	EndIf
	
	SetScale sclX, sclY
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWICON - Draws clickable icon with text                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawIcon(tmpImg:TImage, iX:Int, iY:Int, iText:String)

	SetScale 1, 1
	If RectsOverlap(iX - 2, iY - 2, 16, 18, curX, curY, 1, 1) And bConfig = False Then
		SetColor cfgText[0], cfgText[1], cfgText[2] 
		DrawRect iX - 2, iY - 2, 36, 36
	EndIf

	Local tmpX:Int
	Select Upper$(iText$)
		Case "JOUSTX"; tmpX = 15
		Case "NEMOX"; tmpX = 11
		Case "DEMONX"; tmpX = 17
		Case "BBRPG"; tmpX = 9
		Case "CONFIG"; tmpX = 15
	
	End Select
	
	If cfgShadow = True Then
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawFont iText$, iX - tmpX, iY + 42
	EndIf
	SetColor 255, 255, 255	
	SetScale 1, 1
	DrawImage tmpImg, iX, iY
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont iText$, iX - (tmpX + 2), iY + 40
	SetScale 1, 1
	SetColor 255, 255, 255	

	If bMouseDown = True Then ' // Check for click
		If RectsOverlap(iX - 2, iY - 2, 16, 18, curX, curY, 1, 1) = True Then ' // JoustX
			If bConfig = False Then
				
				Select Upper$(iText$)
					Case "JOUSTX"
					If FileType("JoustX\joustx.exe") = 0 Then
						PlaySFX sfxChord
					Else
						cfgLast = 0; SaveCFG()
						ForceFull(0, cfgFull)
						SleepDelay(100)
						system_("launcher.exe 1")
						EndGame
					EndIf
					
					Case "NEMOX"
					If FileType("NemoX\nemox.exe") = 0 Then
						PlaySFX sfxChord
					Else					
						cfgLast = 0; SaveCFG()
						ForceFull(1, cfgFull)	
						SleepDelay(100)
						system_("launcher.exe 3")
						EndGame
					EndIf
					
					Case "DEMONX"
					If FileType("DemonX\demonx.exe") = 0 Then
						PlaySFX sfxChord
					Else					
						cfgLast = 0; SaveCFG()				
						ForceFull(2, cfgFull)	
						SleepDelay(100)
						system_("launcher.exe 5")
						EndGame
					EndIf
					
					Case "BBRPG"
					If FileType("BubbleRPG\bubblerpg.exe") = 0 Then
						PlaySFX sfxChord
					Else										
						cfgLast = 0; SaveCFG()			
						ForceFull(3, cfgFull)							
						SleepDelay(100)
						system_("launcher.exe 7")
						EndGame
					EndIf
					
					Case "CONFIG"
					bConfig = True
					cfgLast = 1
					cSel = 0
					
				End Select
			
			Else ' // Not active window
				If bConfig = True Then ' // Flash active window
					flashC = 1; flashT = GetMilliSecs()					
				EndIf
				
			EndIf			
		EndIf		
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWSAVER - Draws screen saver                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawSaver()
	
	If cfgSaver > 0 Then
		If bSaver = False Then
			For o:Obj = EachIn objList
				objList.Remove o
			Next
			
			If GetMilliSecs() >= saverT + 30000 Then
				If cfgSaver = 1 Then ' // Bounce
					Local tmpX:Int = 294 - 8, tmpY:Int = 224 - 12
					saverD = Rand(0, 3)
					objList.AddLast obj.Create(tmpX, tmpY, 1, 0)
					If saverD = 0 Then
						objList.AddLast obj.Create(tmpX + 16, tmpY + 24, 1, 1)
						objList.AddLast obj.Create(tmpX + 32, tmpY + 48, 1, 2)
						objList.AddLast obj.Create(tmpX + 48, tmpY + 72, 1, 3)					
					ElseIf saverD = 1 Then
						objList.AddLast obj.Create(tmpX - 16, tmpY + 24, 1, 1)
						objList.AddLast obj.Create(tmpX - 32, tmpY + 48, 1, 2)
						objList.AddLast obj.Create(tmpX - 48, tmpY + 72, 1, 3)					
					ElseIf saverD = 2 Then
						objList.AddLast obj.Create(tmpX - 16, tmpY - 24, 1, 1)
						objList.AddLast obj.Create(tmpX - 32, tmpY - 48, 1, 2)
						objList.AddLast obj.Create(tmpX - 48, tmpY - 72, 1, 3)
					ElseIf saverD = 3
						objList.AddLast obj.Create(tmpX + 16, tmpY - 24, 1, 1)
						objList.AddLast obj.Create(tmpX + 32, tmpY - 48, 1, 2)
						objList.AddLast obj.Create(tmpX + 48, tmpY - 72, 1, 3)					
					EndIf
					
				ElseIf cfgSaver = 2 Then

				EndIf
				bSaver = True
			EndIf
		Else
			If cfgSaver = 1 Then ' // Bounce				
				Cls
					
				For o:Obj = EachIn objList
					o.Render
				Next	
			
			ElseIf cfgSaver = 2 Then ' // Matrix
				Cls
				If Rand(1, 2) = 1 Then
					Local tmpX:Int
					Local tmpC:Int
					Local tmpCount:Int = 0
					Repeat
						tmpX = (Rand(0, 35) * 16) + 5
						tmpC = True
						
						For o:Obj = EachIn objList
							If o.ID = 3 Then
								If o.X = tmpX And o.Y < 112 Then tmpC = False
								tmpCount:+1
							EndIf
						Next
						
					Until tmpC = True Or tmpCount >= 128
					
					If tmpCount < 128 Then
						objList.AddLast obj.Create(tmpX, -24, 3, 0)
					EndIf
				EndIf
							
				For o:Obj = EachIn objList
					o.Render
				Next	
			
			EndIf
		EndIf
	Else
		For o:Obj = EachIn objList
			objList.Remove o
		Next
	EndIf
	
End Function

	
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWOVERLAY - Draws system time converted to 12 hr AM/PM                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawTime(tX:Int, tY:Int)

	Local tmpPM:String = " AM"
	Local tmpTime:String = Left(CurrentTime$(), 5)
	If Int(Left$(tmpTime$, 2)) > 12 Then 
		tmpPM$ = " PM"
		Local tmpT2:String = String(Int(Left$(tmpTime$, 2)) - 12)
		If Len(tmpT2$) = 1 Then tmpT2$ = "0" + tmpT2$
		tmpTime$ = tmpT2$ + Right(tmpTime$, Len(tmpTime$) - 2)
	ElseIf Left$(tmpTime$, 2) = "12" Then
		tmpPM$ = " PM"		
	ElseIf Left$(tmpTime$, 2) = "00" Then
		Local tmpT2:String = String(Int(Left$(tmpTime$, 2)) + 12)
		If Len(tmpT2$) = 1 Then tmpT2$ = "0" + tmpT2$
		tmpTime$ = tmpT2$ + Right(tmpTime$, Len(tmpTime$) - 2)
	EndIf
	If cfgShadow = True Then	
		SetColor cfgBorder[0], cfgBorder[1], cfgBorder[2]
		DrawFont tmpTime$ + tmpPM$, tX + 2, tY + 2
	EndIf
	SetColor cfgText[0], cfgText[1], cfgText[2]
	DrawFont tmpTime$ + tmpPM$, tX, tY
	SetColor 255, 255, 255	

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² InpConfig - Handles input configuration for all games                              
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function InpConfig(myC:Int)

	Local bJoy:Int[2, 4]
	
	curIn = 0
	Local tY:Int = 1

	Local joyT:Int = GetMilliSecs()
	Local tmpExit:Int

	' // Clear arrays
	For Local y:Int = 0 To 1
		For Local x:Int = 0 To 7
			inKey[y, x] = ""
		Next
	Next

	For Local i:Int = 0 To 15
		inKeys[i] = ""
	Next
		
	SleepDelay 100 ' // Clear input
	
	SetScale 1.6, 1.4
	Repeat
		Local tmpStr$ = "", tmpLim:Int, tmpLim2:Int
		tY = 0
		If myC = 0 Then 
			tmpStr$ = "EIKOS"
		ElseIf myC = 1 Then
			tmpStr$ = "JOUST X"
		ElseIf myC = 2 Then
			tmpStr$ = "LITTLE NEMO X"
		ElseIf myC = 3 Then
			tmpStr$ = "DEMON ATTACK X"
		ElseIf myC = 4 Then
			tmpStr$ = "BUBBLE BOBBLE RPG"
		EndIf
		SetColor 51, 255, 0
		DrawText "[" + tmpStr$ + "]", 1, tY
		SetColor 255, 255, 255
		DrawText " " + tmpStr$ + " ", 1, tY; tY:+36
		
		SetColor 252, 152, 56
		DrawText "PLAYER 1 - PRESS KEYSTROKE OR JOYSTICK INPUT", 1, tY; tY:+18

		SetColor 252, 188, 176
		If curIn >= 0 Then DrawText "UP: " + inKeys[0], 1, tY; tY:+18
		If curIn >= 1 Then DrawText "DOWN: " + inKeys[1], 1, tY; tY:+18
		If curIn >= 2 Then DrawText "LEFT: " + inKeys[2], 1, tY; tY:+18
		If curIn >= 3 Then DrawText "RIGHT: " + inKeys[3], 1, tY; tY:+18
		If curIn >= 4 Then DrawText "B: " + inKeys[4], 1, tY; tY:+18
		If curIn >= 5 Then DrawText "A: " + inKeys[5], 1, tY; tY:+18
		If myC <> 4 Then ' // Bubble bobble uses select
			If curIn >= 6 Then DrawText "START: " + inKeys[6], 1, tY; tY:+36
			tmpLim = 7	
		Else
			If curIn >= 6 Then DrawText "SELECT: " + inKeys[6], 1, tY; tY:+18
			If curIn >= 7 Then DrawText "START: " + inKeys[7], 1, tY; tY:+36
			tmpLim = 8
		EndIf

		If curIn >= tmpLim Then
			If myC <> 0 Then ' // EikOS is player 1 only
				SetColor 60, 188, 252
				DrawText "PLAYER 2 - PRESS KEYSTROKE OR JOYSTICK INPUT", 1, tY; tY:+18
		
				SetColor 196, 212, 252
				DrawText "UP: " + inKeys[tmpLim], 1, tY; tY:+18
			Else			
				SetColor 251, 255, 134
				DrawText "INPUT CONFIG COMPLETE - PRESS ESCAPE", 1, tY
				tmpLim2 = 7
			EndIf
		EndIf
		
		If myC <> 0 Then
			If curIn >= tmpLim + 1 Then DrawText "DOWN: " + inKeys[tmpLim + 1], 1, tY; tY:+18
			If curIn >= tmpLim + 2 Then DrawText "LEFT: " + inKeys[tmpLim + 2], 1, tY; tY:+18
			If curIn >= tmpLim + 3 Then DrawText "RIGHT: " + inKeys[tmpLim + 3], 1, tY; tY:+18
			If curIn >= tmpLim + 4 Then DrawText "B: " + inKeys[tmpLim + 4], 1, tY; tY:+18
			If curIn >= tmpLim + 5 Then DrawText "A: " + inKeys[tmpLim + 5], 1, tY; tY:+18
			If myC <> 4 Then ' // Bubble bobble uses select
				If curIn >= tmpLim + 6 Then DrawText "START: " + inKeys[tmpLim + 6], 1, tY; tY:+36
				tmpLim2 = tmpLim + 7
			Else
				If curIn >= tmpLim + 6 Then DrawText "SELECT: " + inKeys[tmpLim + 6], 1, tY; tY:+18
				If curIn >= tmpLim + 7 Then DrawText "START: " + inKeys[tmpLim + 7], 1, tY; tY:+36
				tmpLim2 = tmpLim + 8
			EndIf
		Else
			tmpLim2 = tmpLim + 7
		EndIf
		
		If curIn >= tmpLim2 Then
			SetColor 251, 255, 134
			DrawText "INPUT CONFIG COMPLETE - PRESS ESCAPE", 1, tY
			
		Else
			' // Get keys
			For Local i:Int = 0 To 220
				If KeyHit(i) = True Then 
					inKeys[curIn] = "K" + String(i)
					If CheckKey(inKeys[curIn]) = False Then curIn:+1
					Exit
				EndIf
			Next
			
			' // Get Joy Button
			Local bExit:Int = False
			If GetMilliSecs() >= joyT + 250 Then
				For Local j:Int = 0 To 1
					For Local b:Int = 0 To 15
						If JoyHit(b, j) = True Then 
							inKeys[curIn] = "J" + String(j) + String(b)
							If CheckKey(inKeys[curIn]) = False Then curIn:+1
							FlushJoy(0); FlushJoy(1); joyT = GetMilliSecs()
							bExit = True; Exit
						EndIf
					Next
					If bExit = True Then Exit
				Next
			EndIf
			
			' // Get Joy Direction
			If GetMilliSecs() >= joyT + 250 Then
				For Local j:Int = 0 To 1
					If JoyX(j) = -1 And bJoy[j, 0] = 0 Then 
						inKeys[curIn] = "J" + String(j) + "L"
						If CheckKey(inKeys[curIn]) = False Then curIn:+1
						bJoy[j, 0] = 1	
					
						FlushJoy(0); FlushJoy(1); joyT = GetMilliSecs()
						Exit
						
					ElseIf JoyX(j) = 1 And bJoy[j, 1] = 0 Then
						inKeys[curIn] = "J" + String(j) + "R"
						If CheckKey(inKeys[curIn]) = False Then curIn:+1
						bJoy[j, 1] = 1	

						FlushJoy(0); FlushJoy(1); joyT = GetMilliSecs()
						Exit
						
					ElseIf JoyY(j) = -1 And bJoy[j, 2] = 0 Then
						inKeys[curIn] = "J" + String(j) + "U"
						If CheckKey(inKeys[curIn]) = False Then curIn:+1
						bJoy[j, 2] = 1	

						FlushJoy(0); FlushJoy(1); joyT = GetMilliSecs()
						Exit
						
					ElseIf JoyY(j) = 1 And bJoy[j, 3] = 0 Then
						inKeys[curIn] = "J" + String(j) + "D"
						If CheckKey(inKeys[curIn]) = False Then curIn:+1
						bJoy[j, 3] = 1	

						FlushJoy(0); FlushJoy(1); joyT = GetMilliSecs()
						Exit
						
					EndIf
					
				Next
			EndIf
			
			For Local i:Int = 0 To 1
				If bJoy[i, 0] = 1 And JoyX(i) > -.5 Then bJoy[i, 0] = 0
				If bJoy[i, 1] = 1 And JoyX(i) < .5 Then bJoy[i, 1] = 0
				If bJoy[i, 2] = 1 And JoyY(i) > -.5 Then bJoy[i, 2] = 0
				If bJoy[i, 3] = 1 And JoyY(i) < .5 Then bJoy[i, 3] = 0
			Next
				
		EndIf
		
		Flip -1; Cls
		
		tmpExit = 0
		If KeyHit(KEY_ESCAPE) = True Then tmpExit = 1
		If AppTerminate() = True Then tmpExit = 2
	Until tmpExit <> 0
	
	If tmpExit = 2 Then EndGame()
		
	SetScale sclX, sclY
	
	FlushInput

	Local tmpC:Int
	Local myPath:String = ""
	
	If myC = 0 Then
		tmpC = 7
		myPath$ = "input.cfg"
	ElseIf myC = 1 Then
		tmpC = 14
		myPath$ = "JoustX\input.cfg"
	ElseIf myC = 2 Then
		tmpC = 14
		myPath$ = "NemoX\input.cfg"
	ElseIf myC = 3 Then
		tmpC = 14
		myPath$ = "DemonX\input.cfg"
	ElseIf myC = 4 Then
		tmpC = 16
		myPath$ = "BubbleRPG\input.cfg"
	EndIf
	
	If curIn >= tmpC Then ' // Write Input.CFG
		Local File:TStream = WriteFile(myPath$)
		For Local i:Int = 0 To tmpC - 1
			WriteLine File, inKeys[i]
		Next
		CloseFile File
	EndIf

	LoadInput() ' // Reload EIKOS input
	
	saverT = GetMilliSecs()
	FlushInput

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CheckKey - Checks for input                              
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function CheckKey:Int(tmp:String)

	For Local i:Int = 0 To curIn - 1
		If inKeys[i] <> 0 Then
			If inKeys[i] = tmp$ Then Return True
		EndIf
	Next

	Return False

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ForceFull - Forces game into fullscreen mode to match OS                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function ForceFull(myG:Int, myFull:Int)

	If myG = 0 Then ' // JOUST X
		Local myArgs:Int[12]
		
		Local File:TStream = ReadFile("JoustX\joustx.cfg")
		For Local i:Int = 0 To 11
			myArgs[i] = ReadInt(File)
		Next
		CloseFile File
		
		If myArgs[4] <> myFull Then ' // Force full
			myArgs[4] = myFull

			Local File:TStream = WriteFile("JoustX\joustx.cfg")
			For Local i:Int = 0 To 11
				WriteInt File, myArgs[i]
			Next
			CloseFile File		
		EndIf
	
	ElseIf myG = 1 Then ' // NEMO X
		Local myArgs:Int[6]
		
		Local File:TStream = ReadFile("NemoX\nemox.cfg")
		For Local i:Int = 0 To 5
			myArgs[i] = ReadInt(File)
		Next
		CloseFile File
		
		If myArgs[4] <> myFull Then ' // Force full
			myArgs[4] = myFull

			Local File:TStream = WriteFile("NemoX\nemox.cfg")
			For Local i:Int = 0 To 5
				WriteInt File, myArgs[i]
			Next
			CloseFile File		
		EndIf
	
	ElseIf myG = 2 Then ' // DEMON X
		Local myArgs:Int[7]
		
		Local File:TStream = ReadFile("DemonX\demonx.cfg")
		For Local i:Int = 0 To 6
			myArgs[i] = ReadInt(File)
		Next
		CloseFile File
		
		If myArgs[5] <> myFull Then ' // Force full
			myArgs[5] = myFull

			Local File:TStream = WriteFile("DemonX\demonx.cfg")
			For Local i:Int = 0 To 6
				WriteInt File, myArgs[i]
			Next
			CloseFile File		
		EndIf
	
	ElseIf myG = 3 Then ' // BBRPG
		Local myArgs:Int[8]
		
		Local File:TStream = ReadFile("BubbleRPG\bubbleRPG.cfg")
		For Local i:Int = 0 To 7
			myArgs[i] = ReadInt(File)
		Next
		CloseFile File
		
		If myArgs[4] <> myFull Then ' // Force full
			myArgs[4] = myFull

			Local File:TStream = WriteFile("BubbleRPG\bubbleRPG.cfg")
			For Local i:Int = 0 To 7
				WriteInt File, myArgs[i]
			Next
			CloseFile File		
		EndIf
			
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWOVERLAY - Draws screen overlay                              
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawOverlay()

	If bWindowed = False Then ' // Fullscreen border
		SetOrigin 0, 0	
		SetScale 1, 1; SetColor 0, 0, 0
		DrawRect 0, 0, 640, 16; DrawRect 0, 0, 26, 480
		DrawRect 640 - 26, 0, 26, 480; DrawRect 0, 480 - 16, 640, 16
		SetColor 255, 255, 255
		SetOrigin 26, 16
	EndIf
	
	SetBlend ALPHABLEND; SetAlpha 1
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SLEEPDELAY - Waits X millisecs                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SleepDelay(myD:Int)

	Local tmpDelay:Int = GetMilliSecs()
	Repeat
		FlushInput
	Until GetMilliSecs() >= tmpDelay + myD 
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWFONT - Draws bitmap font                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawFont(myStr:String, X:Int, Y:Int)

	SetScale sclX, sclY' SetColor 255, 255, 255

	Local fontW:Int = 5
	
	Local i:Int
	If X = -1 Then ' // Center text
		Local tmpW:Int
		X = 294
		For i = 1 To Len(myStr$)
			tmpW:+(fontW * sclX)
		Next
		X:-Int(tmpW / 2)
	EndIf
	
	Local tmpX:Int = X, tmpY:Int = Y, tmpA:Int, tmpF:Int
	For i = 1 To Len(myStr)
		tmpA = Asc(Upper$(Mid$(myStr$, i, 1)))
		
		If tmpA >= 48 And tmpA <= 57 Then ' // Numbers
			tmpF = (tmpA - 48) + 26
		ElseIf tmpA >= 65 And tmpA <= 90 Then ' // Letters
			tmpF = tmpA - 65			
		ElseIf tmpA = 46 Then ' // Space
			tmpF = 36
		ElseIf tmpA = 45 Then ' // -
			tmpF = 37
		ElseIf tmpA = 58 Then ' // :
			tmpF = 38
		ElseIf tmpA = 95 Then ' // _
			tmpF = 39
		EndIf
		
		If tmpA <> 32 Then ' // Space
			DrawImage imgFont, tmpX, tmpY, tmpF	
		EndIf
		
		tmpX:+(fontW * sclX)
		If tmpA = 77 Or tmpA = 78 Or tmpA = 86 Or tmpA = 87 Or tmpA = 88 Or tmpA = 89 Then tmpX:+2

	Next
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CheckFader - Deletes matrix fader if it overwrites                                
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function CheckFader(x:Int, y:Int)
	
	Local tmpList:TList = objList
													
	For o:Obj = EachIn ObjList
		If o.ID = 4 And o.X = X And o.Y = Y Then
			objList.Remove o
		EndIf
	Next
	
	tmpList = Null
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SEEKCOLOR - Moves selector to current palette color                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SeekColor:Int(x:Int, y:Int)

	x = Int(x / 1.5)
	y = Int(y / 1.5)
	
	Local pixPalP:TPixmap = CreatePixmap(ImageWidth(imgPal), ImageHeight(imgPal), PF_RGBA8888)
	Local tmpCol:Int
	
	' // Get palette color
	pixPalP = LockImage(imgPal)
	tmpCol = ReadPixel(pixPalP, x, y) ' // Current color
	UnlockImage imgPal
	pixPalP = Null	
	
	Return tmpCol
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADINPUT - Reads in input CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadInput()

	Local File:TStream = ReadFile("input.cfg")
	
	'For Local j:Int = 0 To 1
		For Local i:Int = 0 To 7
			inKey[0, i] = ReadLine(File)

			If Left$(inKey[0, i], 2) = "J1" Then p1Joy = 1
			
		Next
	'Next
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² FLUSHINPUT - Flushes joystick and keyboard input
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function FlushInput(flushI:Int = -1)

	If flushI = -1 Then ' // Flush all
		FlushKeys; FlushJoy 0; FlushJoy 1
		If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_A) = True Or GetInput(PLAYER_1, INP_S) = True Or GetInput(PLAYER_1, INP_X) = True Then
		EndIf
		If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_A) = True Or GetInput(PLAYER_2, INP_S) = True Or GetInput(PLAYER_2, INP_X) = True Then
		EndIf
		FlushKeys; FlushJoy 0; FlushJoy 1	
	
	ElseIf flushI = 0 Then ' // Flush player 1
		FlushKeys; FlushJoy 0
		If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_A) = True Or GetInput(PLAYER_1, INP_S) = True Or GetInput(PLAYER_1, INP_X) = True Then
		EndIf
		FlushKeys; FlushJoy 0
	
	ElseIf flushI = 1 Then ' // Flush player 2
		FlushKeys; FlushJoy 1
		If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_A) = True Or GetInput(PLAYER_2, INP_S) = True Or GetInput(PLAYER_2, INP_X) = True Then
		EndIf
		FlushKeys; FlushJoy 1

	EndIf	

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETINPUT - Converts inkeys to inputs                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetInput:Int(j:Int, i:Int, d:Int = 0)

	Local tmpRet:Int = False
	Local tmp:String = inKey[j, i]
	
	If Left$(tmp$, 1) = "K" Then ' // Keyboard
		tmp$ = Replace$(tmp$, "K", "")
		If d = 0 Then ' // KeyHit
			If KeyHit(Int(tmp$)) = True Then tmpRet = True		
		ElseIf d = 1 Then ' // KeyDown
			If KeyDown(Int(tmp$)) = True Then tmpRet = True
		EndIf
	ElseIf Left$(tmp$, 2) = "J0" Then ' // Joy 1
		If tmp$ = "J0U" Then ' // Up
			If JoyY(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0D" Then ' // Down
			If JoyY(0) = 1 Then tmpRet = True
		ElseIf tmp$ = "J0L" Then ' // Left
			If JoyX(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0R" Then ' // Right
			If JoyX(0) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J0", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 0) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 0) = True Then tmpRet = True
			EndIf
		EndIf
		
	ElseIf Left$(tmp$, 2) = "J1" Then ' // Joy 2
		If tmp$ = "J1U" Then ' // Up
			If JoyY(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1D" Then ' // Down
			If JoyY(1) = 1 Then tmpRet = True
		ElseIf tmp$ = "J1L" Then ' // Left
			If JoyX(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1R" Then ' // Right
			If JoyX(1) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J1", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 1) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 1) = True Then tmpRet = True
			EndIf
		EndIf
		
	EndIf
	
	Return tmpRet
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYSFX - Plays a sound at desired volume                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlaySFX:TChannel(mySound:TSound, myChan:TChannel = Null)
	
	If cfgSFX <> 0 Then
		Local tmpChan:TChannel = AllocChannel()
		tmpChan = PlaySound(mySound, tmpChan)
		tmpChan.SetVolume(Float(cfgSFX) / 10)

		Return tmpChan
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ENDGAME - Ends program                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function EndGame()
	SaveCFG()
	End
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVECFG - Writes CFG file                                 
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveCFG()

	Local File:TStream = WriteFile("EikOS.cfg")
	WriteInt File, cfgFull
	WriteInt File, cfgLast
	WriteInt File, cfgSFX
	WriteInt File, cfgGFX
	
	' // Desk color
	WriteInt File, cfgDesk[0]
	WriteInt File, cfgDesk[1]
	WriteInt File, cfgDesk[2]

	' // Text color
	WriteInt File, cfgText[0]
	WriteInt File, cfgText[1]
	WriteInt File, cfgText[2]
	
	' // Text shadow
	WriteInt File, cfgShadow
	
	' // Text color
	WriteInt File, cfgTitle[0]
	WriteInt File, cfgTitle[1]
	WriteInt File, cfgTitle[2]

	' // Win color
	WriteInt File, cfgWin[0]
	WriteInt File, cfgWin[1]
	WriteInt File, cfgWin[2]

	' // Border color
	WriteInt File, cfgBorder[0]
	WriteInt File, cfgBorder[1]
	WriteInt File, cfgBorder[2]
	
	WriteInt File, cfgSaver
	
	WriteInt File, curX
	WriteInt File, curY
	
	WriteInt File, cfgCur
	
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADCFG - Reads in CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadCFG()

	Local File:TStream = ReadFile("EikOS.cfg")
	cfgFull = ReadInt(File)
	cfgLast = ReadInt(File)
	cfgSFX = ReadInt(File)
	cfgGFX = ReadInt(File)
	
	' // Desk color
	cfgDesk[0] = ReadInt(File)
	cfgDesk[1] = ReadInt(File)
	cfgDesk[2] = ReadInt(File)

	' // Text color
	cfgText[0] = ReadInt(File)
	cfgText[1] = ReadInt(File)
	cfgText[2] = ReadInt(File)
	
	' // Text shadow
	cfgShadow = ReadInt(File)

	' // Title color
	cfgTitle[0] = ReadInt(File)
	cfgTitle[1] = ReadInt(File)
	cfgTitle[2] = ReadInt(File)

	' // Win color
	cfgWin[0] = ReadInt(File)
	cfgWin[1] = ReadInt(File)
	cfgWin[2] = ReadInt(File)

	' // Border color
	cfgBorder[0] = ReadInt(File)
	cfgBorder[1] = ReadInt(File)
	cfgBorder[2] = ReadInt(File)
	
	cfgSaver = ReadInt(File)
	
	cfgCurX = ReadInt(File)
	cfgCurY = ReadInt(File)
	
	cfgCur = ReadInt(File)
	
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVESCREEN - Saves a PNG snapshot                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveScreen()
	Local tmpFN:Int = 0, Dir:Byte Ptr = ReadDir("snaps/"), file$
	Local tmpP:Int, tmpU:Int, tmpN:Int

	Repeat 
		file$ = NextFile(Dir)
		If FileType("snaps/" + file$) = 1 Then
			tmpP = Instr(file$, ".", 1)
			tmpU = Instr(file$, "_", 1)
			tmpN = Int(Mid(file$, tmpU + 1, tmpP - tmpU))
			If tmpN > tmpFN Then tmpFN = tmpN ' // New filenumber
		EndIf
	Until file$ = ""
	CloseDir Dir

	Local tmpX:Int, tmpY:Int
	If bWindowed = False Then tmpX = 26; tmpY = 16 Else tmpX = 0; tmpY = 0

	SetMaskColor 255, 0, 255
	Local imgScreen:TPixmap = GrabPixmap(tmpX, tmpY, 588, 448)
	SavePixmapPNG(imgScreen, "snaps/snap_" + (tmpFN + 1) + ".png", 9)
	
	GCRelease imgScreen
	GCCollect
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETMILLISECS - MilliSecs rollover fix                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetMilliSecs:Int()

	If LastMilliSecs = 0 Then LastMilliSecs = MilliSecs() 
	
	If MilliSecs() > LastMilliSecs Then MyMilliSecs = MyMilliSecs + (MilliSecs() - LastMilliSecs)
	If MilliSecs() < LastMilliSecs Then MyMilliSecs = MyMilliSecs + (LastMilliSecs - MilliSecs())

	LastMilliSecs = MilliSecs()
	Return MyMilliSecs' - pauseTotal ' // Time offset fix
    
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LEGACY FUNCTIONS                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RectsOverlap%(x0:Int, y0:Int, w0:Int, h0:Int, x2:Int, y2:Int, w2:Int, h2:Int)

	If x0 > (x2 + Int(w2 * sclX)) Or (x0 + Int(w0 * sclX)) < x2 Then Return False
	If y0 > (y2 + Int(h2 * sclY)) Or (y0 + Int(h0 * sclY)) < y2 Then Return False
	Return True
	
End Function

Function RectsOverlap2%(x0:Int, y0:Int, w0:Int, h0:Int, x2:Int, y2:Int, w2:Int, h2:Int)

	If x0 > (x2 + Int(w2 * 1.5)) Or (x0 + Int(w0 * 1.5)) < x2 Then Return False
	If y0 > (y2 + Int(h2 * 1.5)) Or (y0 + Int(h0 * 1.5)) < y2 Then Return False
	Return True
	
End Function

Function ImageRectCollide%(image:TImage, ix%, iy%, iframe%, rx%, ry%, rwidth%, rheight%)

   ResetCollisions
   CollideImage image, ix, iy, iframe, 0, 1
   
   If CollideRect(rx, ry, rwidth, rheight, 1, 0) Then Return True Else Return False

End Function
