' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ²
' // ² D E M O N   A T T A C K   X
' // ² Version 1.0
' // ²
' // ² By EikSoft (www.EikSoft.com)
' // ² 10.18.23 Project Start
' // ² 11.27.23 Last Modified
' // ²
' // ² Ported from the TRS-80 version of Demon Attack, IMAGIC 1984
' // ² 
' // ² For J.B. - In loving memory of Celeste <3
' // ²
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // 
SuperStrict

Framework BRL.GLMax2D 

Import BRL.Retro
Import BRL.PNGLoader
Import BRL.Random
Import BRL.WAVLoader
Import BRL.OGGLoader
Import SDL.SDLFreeAudio
Import PUB.FreeJoy

SetAudioDriver("FreeAudio SDL")

AppTitle = "Demon Attack X v1.0"
SetGraphicsDriver GLMax2DDriver()
SeedRnd MilliSecs()

Global cfgSFX:Int = 100
Global cfgMusic:Int = 70
Global cfgBR:Int = 0
Global cfgFilter:Int = 0
Global cfgCRT:Int = 0
Global cfgFull:Int = 0
Global cfgEGA:Int = 0

' // Input.Cfg
Global inKey:String[2, 7]

Global INP_U:Int = 0, INP_D:Int = 1, INP_L:Int = 2, INP_R:Int = 3, INP_B:Int = 4, INP_A:Int = 5, INP_S:Int = 6
Global p1Joy:Int = 0, p2Joy:Int = 1

LoadCFG()
LoadInput()

Global bWindowed:Int = True
If cfgFull = 1 Then bWindowed = False

If bWindowed = True Then 
	Graphics 588, 448, 0, 60
Else
	Graphics 640, 480, 32, 60
EndIf

If bWindowed = False Then HideMouse 

' // Loading screen
SetMaskColor 255, 0, 255
imgFont = LoadAnimImage("gfx/font.png", 12, 10, 0, 40, MASKEDIMAGE)
SetScale 1.149, 1.167
If bWindowed = False Then SetOrigin 26, 16
DrawFont "Loading", -1, 218
Flip

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² IMAGES                                           
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global imgCRT:TImage

Global imgBack:TImage
Global imgBack2:TImage
Global imgLogo:TImage
Global imgFont:TImage
Global imgShip:TImage
Global imgShot:TImage
Global imgWarp:TImage
Global imgDemon1:TImage
Global imgDemon2:TImage
Global imgDemon3:TImage
Global imgDemon4:TImage
Global imgDemon5:TImage
Global imgDemon6:TImage
Global imgDemon7:TImage
Global imgDemon8:TImage
Global imgExplode:TImage
Global imgLives:TImage
Global imgDeath:TImage
Global imgScore:TImage
Global imgSplit:TImage
Global imgBird:TImage
Global imgBoss:TImage
Global imgEye:TImage
Global imgMouth:TImage
Global imgShield:TImage
Global imgTran:TImage
Global imgEye2:TImage
Global imgMouth2:TImage
Global imgFade:TImage
Global imgFade2:TImage
'Global imgStars:TImage

'Global imgLayer1:TImage

Global arrInv:Byte[588, 448] ' // Inversion map
LoadInvert

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SOUNDS                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global sfxShot:TSound = LoadSound("sfx/shot.wav")
Global sfxWarp:TSound = LoadSound("sfx/warp.wav")
Global sfxExplode:TSound = LoadSound("sfx/explode.wav")
Global sfxPulse1:TSound = LoadSound("sfx/pulse1.wav")
Global sfxPulse2:TSound = LoadSound("sfx/pulse2.wav")
Global sfxPulse3:TSound = LoadSound("sfx/pulse3.wav")
Global sfxPulse4:TSound = LoadSound("sfx/pulse4.wav")
Global sfxPulse5:TSound = LoadSound("sfx/pulse5.wav")
Global sfxPulse6:TSound = LoadSound("sfx/pulse6.wav")
Global sfxPulse7:TSound = LoadSound("sfx/pulse7.wav")
Global sfxDeath:TSound = LoadSound("sfx/death.wav")
Global sfx1Up:TSound = LoadSound("sfx/1up.wav")
Global sfxShield1:TSound = LoadSound("sfx/shield1.wav")
Global sfxShield2:TSound = LoadSound("sfx/shield2.wav")
Global sfxShield3:TSound = LoadSound("sfx/shield3.wav")
Global sfxShield4:TSound = LoadSound("sfx/shield4.wav")
Global sfxShield5:TSound = LoadSound("sfx/shield5.wav")
Global sfxShield6:TSound = LoadSound("sfx/shield6.wav")
Global sfxBDeath:TSound = LoadSound("sfx/bdeath.wav")
Global sfxPause:TSound = LoadSound("sfx/pause.wav")
Global sfxDive:TSound = LoadSound("sfx/dive.wav")
Global sfxSplit:TSound = LoadSound("sfx/split.wav")
Global sfxUpload:TSound = LoadSound("sfx/upload.wav")

Global sfxChan:TChannel = AllocChannel()
Global pulseChan:TChannel = AllocChannel()
Global diveChan:TChannel = AllocChannel()

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² MUSIC                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Global musSong1:TSound
Global musSong2:TSound

Global musChan:TChannel = AllocChannel()

musSong1 = LoadSound("ogg/song1.ogg", SOUND_LOOP)

musChan = PlaySound(musSong1, musChan)
musChan.SetVolume(Float(cfgMusic) / 100) 

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² VARIABLES                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // Tick count and FPS
Global MyMilliSecs:Int, LastMilliSecs:Int = MilliSecs() ' // MilliSecs FIX
Global FPS:Int, curFrames:Int, frameTimer:Int, fpsTimer:Int = GetMilliSecs() ' // FPS Counter

Global bPaused:Int = False, pauseStart:Int, pauseTotal:Int

Global bHit:Int = False, quadC:Int = 3, shotX:Int = 0, shotX2:Int, shotY:Int, shotY2:Int
Global dShot:Int = 0
Global bFlash:Int = False, flashT:Int, livesF:Int = -1, livesT:Int
Global demonT:Int = 0, bWin:Int = False, winT:Int
Global pulseT:Int, birdID:Int = 1, switchID:Int = 0, bFromTitle:Int
Global bfirstWarp:Int = True, shieldF:Float = 0
Global demonCount:Int, eyeF:Int = 0, eyeT:Int
Global bTran:Int = False, tranY:Int = 0, tranT:Int ' // Screen transitions
Global bForceFlash:Int = False, flashF:Int = 0, birdT:Int
Global bossDeath:Int = False, mouthF:Int = 0, mouthT:Int, fadeF:Int
Global scoreD:Int, scoreB:Int
Global spawnT:Int, spawnS:Float
Global maxShot:Int = 7, maxLaser:Int = 8
Global shotSpeed:Float = 1.75, shotTime:Int = 140
Global demSpeed:Int = 10
Global gameTime:Int, bHas2:Int = True
Global shootStop:Int
Global topScore:Int
Global secretCode:String = "", bSecret:Int = False, secLevel:Int, oldSecL:Int = -1

' // Hi scores
Global net_Score:String[100], netP:Int
Global uploadChan:TChannel = AllocChannel()
Global hi_Entry:String, hi_A:Int
Global tSelX:Int = 141, tSelY:Int = 148

Global ega1:Int, ega2:Int, ega3:Int
Global invR1:Int, invG1:Int, invB1:Int
Global invR2:Int, invG2:Int, invB2:Int
Global oldEGA1:Int = -1, oldEGA2:Int = -1
Global backA1:Float = 0, backA2:Float = 1, backTran:Int = False, backT:Int = False
Global bLoopback:Int = False

'Global sX:Float, sX2:Float

Global startLevel:Int = 1

Global curLevel:Int = startLevel

' // Joystick
Global bJoy1YHit:Int = False, bJoy1XHit:Int = False
Global bJoy2YHit:Int = False, bJoy2XHit:Int = False

' // Title
Global bTitle:Int = True, tSel:Int = 0, tScreen:Int = 0

' // Demon AI
Global yVel:Float = 2.2
Global dSmart:Int = 40

Global bDebug:Int
Global b2Player:Int = False

Global debugWarp:Int, debugExplode:Int, debugQ:Int

Global sclX:Float =  1.149, sclY:Float = 1.167
Global objC:Int, partC:Int

Global pX:Float[2], pY:Float[2], pT:Int[2], pLives:Int = 2, pDeath:Int[2], pF:Int[2]
Global pScore:Int = 0, pFlawless:Int = True, pD:Int = Rand(0, 1)

Global bP1Start:Int = False, bP2Start:Int = False

pX[0] = 273; pY[0] = 392
GenSecret()

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CONSTANTS                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Const PLAYER_1:Int = 0
Const PLAYER_2:Int = 1

Const OBJ_DEMON:Int = 1
Const OBJ_BIRD:Int = 2

Const PART_SHOT:Int = 1
Const PART_EXPLODE:Int = 2
Const PART_LASER:Int = 3
Const PART_FLARE:Int = 4

Global o:Obj, o2:Obj, objList:TList = CreateList()
Global p:Part, partList:TList = CreateList()

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PARTICLES                                         
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Part   
    Field X:Float, Y:Float, ID:Int, K:Int
	Field Alp:Float, F:Int, T:Int, FT:Int, Lev:Int
	Field D:Int, Q:Int, oldY:Float
	
    Function Create:Part(X:Float, Y:Float, ID:Int, K:Int = 0, Q:Int = -1)
		p:Part = New Part
		p.X = X; p.Y = Y; p.ID = ID
		
		If ID = PART_SHOT Then ' // Player shot
			If p.K = 0 Then shotX = X ElseIf p.K = 1 Then shotX2 = X
			p.T = GetMilliSecs()
			p.K = K
			
		ElseIf ID = PART_EXPLODE Then ' // Explode
			p.T = GetMilliSecs()
			p.F = 0
			p.K = K
			p.D = Rand(0, 1)
			p.FT = GetMilliSecs()
			p.Q = Q
			
		ElseIf ID = PART_LASER Then ' // Alien laser
			p.FT = GetMilliSecs()
			p.Lev = Q
			p.K = K
			p.oldY = Y
			
		ElseIf ID = PART_FLARE Then ' // Hit flare
			p.T = GetMilliSecs()
			p.F = 0
			p.FT = GetMilliSecs()
					
		EndIf
		
		Return p
	End Function

	Method Render()
        Local Del:Int = False

		Select ID
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² PLAYER SHOT 
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			Case PART_SHOT
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
			Local tmpF:Int = cfgBR
			If K = 1 Then
				If cfgBR = 1 Then tmpF = 0 Else tmpF = 1
			EndIf
			DrawImage imgShot, X, Y, tmpF
			
			If bSecret = True Then ' // Mode 2
				If K = 0 Then X = pX[0] + 20 ElseIf K = 1 Then X = pX[1] + 20
				If K = 0 Then shotX = X ElseIf K = 1 Then shotX2 = X
			EndIf
			
			If GetMilliSecs() >= T + 60 Then ' // Shot delay
				If IsBoss() = True And shieldF <> -1 Then
					If Y - 7 > 210 Then 
						Y:-7 
					Else 
						Del = True
						If K = 0 Then shotX = 0; shotY = 0 ElseIf K = 1 Then shotX2 = 0; shotY2 = 0
					EndIf
				Else
					If Y - 7 > 28 Then 
						Y:-7 
					Else 
						Del = True
						If K = 0 Then shotX = 0; shotY = 0 ElseIf K = 1 Then shotX2 = 0; shotY2 = 0
					EndIf
				EndIf
				
				If K = 0 Then shotY = Y + 26 ElseIf K = 1 Then shotY2 = Y + 26 ' // Shot Y
			EndIf
			
			' // BOSS DEATH			
			If IsBoss() = True And shieldF = -1 And pDeath[K] = False Then
				If eyeF = 0 Or eyeF = 4 Then
					If RectsOverlap(Int(X), Int(Y), 5, 26, 276, 77, 36, 16) Then 
						Del = True
						If K = 0 Then shotX = 0; shotY = 0 ElseIf K = 1 Then shotX2 = 0; shotY2 = 0
						
						bForceFlash = True
						bFlash = True
						flashT = GetMilliSecs()
						flashF = 0
						
						gameTime = GetMilliSecs()	
							
						' // Explode all enemies
						For o:Obj = EachIn objList
							If o.ID = OBJ_DEMON Or o.ID = OBJ_BIRD Then o.bForceDel = True
						Next
						
						'If bTitle = False Then playSFX sfxBDeath
						bossDeath = True
						eyeF = 0; eyeT = GetMilliSecs()
						mouthF = -1; mouthT = GetMilliSecs()
					EndIf
										
				EndIf
			EndIf
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² EXPLODE 
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			Case PART_EXPLODE
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
			Local tmpOff:Int = 0 ' // Palette offset
			If K = 0 Then ' // Explode
				If cfgBR = 1 Then tmpOff = 4

				DrawImage imgExplode, X, Y, F + tmpOff
							
				If GetMilliSecs() >= T + 120 Then
					If F < 3 Then F:+1 Else Del = True
					T = GetMilliSecs()
				EndIf
				
			ElseIf K = 1 Then ' // Split
				If cfgBR = 1 Then tmpOff = 3

				DrawImage imgSplit, X, Y, F + tmpOff

				Local bFrame:Int = False
				If GetMilliSecs() >= FT + 60 Then ' // Frame timer
					bFrame = True
					FT = GetMilliSecs()
				EndIf

				If bFrame = True Then
					' // X
					If D = 0 Then
						If X - 5 > 0 Then X:-5 Else D = 1
					ElseIf D = 1 Then
						If X + 5 < 588 - 60 Then X:+5 Else D = 0
					EndIf

					Local tmpR:Int
					If Rand(1, 8) = 4 Then
						If D = 0 Then D = 1 Else D = 0
					EndIf
				EndIf
												
				If GetMilliSecs() >= T + 120 Then
					If F < 2 Then F:+1 Else Del = True
					T = GetMilliSecs()
				EndIf
				
				If Del = True Then ' // Create birds
					Local tmpA:Int = -1, tmpA2:Int = -1
					If Rand(0, 1) = 0 Then tmpA = 1; tmpA2 = -1 Else tmpA = -1; tmpA2 = 1
					objList.AddLast obj.Create(X - 16, Y, OBJ_DEMON, Q, birdID, tmpA)
					objList.AddLast obj.Create(X + 40, Y, OBJ_DEMON, Q, birdID, tmpA2)
					birdID:+1
				
				EndIf
				
			EndIf
			
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² ALIEN LASER 
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			Case PART_LASER
			SetBlend ALPHABLEND; SetAlpha 1; SetScale 1, 1

			SetColor 255, 255, 255
			
			If IsLaser(Lev) = False Then ' // Spread shot
				SetInvColor X, Int(Y); DrawRect X, Y, 4, 2
				SetInvColor X, Int(Y + 2); DrawRect X, Y + 2, 4, 2
				SetInvColor X, Int(Y + 4); DrawRect X, Y + 4, 4, 2
				SetInvColor X, Int(Y + 6); DrawRect X, Y + 6, 4, 2
			Else ' // Dual laser
				SetInvColor X + 4, Int(Y + 1); DrawRect X, Y, 8, 2
			EndIf
			
			SetColor 255, 255, 255
			
			SetScale sclX, sclY

			Local bFrame:Int = False
			If GetMilliSecs() >= FT + 60 Then ' // Frame timer
				bFrame = True
				FT = GetMilliSecs()
			EndIf
			If IsLaser(Lev) = False Then bFrame = True 
			'If Lev <> 2 And Lev <> 11 Then 
			
			If bFrame = True Then		
				If IsLaser(Lev) = False Then
					If (Y + 8) + shotSpeed < 412 Then Y:+shotSpeed Else Del = True; dShot:-1
					
					If Int(Y) >= oldY + 32 Then ' // Shift
						If Rand(0, 1) = 0 Then X:-4 Else X:+4
						oldY = Int(Y)
					EndIf

				Else
					If (Y + 2) + 9 < 412 Then 
						Y:+9 
					Else 
						Del = True
						If K = 0 Then dShot:-1
					EndIf
				EndIf
			EndIf
						
			If Del = False Then ' // Player collision
			
				For Local i:Int = 0 To b2Player
					If pDeath[i] = False And Del = False Then
						Local bCol:Int = False
						If IsLaser(Lev) = False Then ' // Spead shot
							bCol = ImageRectCollide(imgShip, Int(pX[i]), Int(pY[i]), 0, Int(X), Int(Y), 4, 8)
						Else ' // Dual laser
							bCol = ImageRectCollide(imgShip, Int(pX[i]), Int(pY[i]), 0, Int(X), Int(Y), 8, 2)
						EndIf
						
						If bCol = True Then ' // Player hit
							Del = True
							If K = 0 Then dShot:-1
							pDeath[i] = True
							bForceFlash = False
							pT[i] = GetMilliSecs()
							pF[i] = 0
							If bTitle = False Then PlaySFX sfxDeath
							shootStop = GetMilliSecs() ' // Shooting pause to recover
						EndIf
					EndIf
				Next
				
			EndIf
			
			If del = True And dShot < 0 Then dShot = 0 ' // Failsafe
				
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² FLARE 
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			Case PART_FLARE
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
			Local tmpOff:Int = 0 ' // Palette offset
			If cfgBR = 1 Then tmpOff = 4

			DrawImage imgExplode, X, Y, F + tmpOff
						
			If GetMilliSecs() >= T + 120 Then
				If F < 1 Then F:+1 Else Del = True
				T = GetMilliSecs()
			EndIf
										
		End Select
		
		partC:+1
		If Del = True Then partList.Remove p
		
	End Method
End Type

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² OBJECTS                                          
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Type Obj    
    Field X:Float, Y:Float, ID:Int
	Field Q:Int, A:Int, F:Int, Lev:Int, W1:Int, W2:Int, T:Int, OX:Int, OY:Int
	Field D:Int, YD:Int, FT:Int, YI:Float, YR:Float, CS:Int, ST:Int, bShoot:Int
	Field FT2:Int, bFall:Int, K:Int, Act:Int, bForceDel:Int, Dive:Int, Moved:Int
	Field bTarget:Int, Life:Int, hitK:Int, vin:Int, vinT:Int, dLas:Int
	Field bInvis:Int, invisT:Int, invisR:Int
	
    Function Create:Obj(X:Float, Y:Float, ID:Int, Q:Int = 0, K:Int = 0, Act:Int = -1)
		o:Obj = New Obj
		o.X = X; o.Y = Y; o.ID = ID
		o.FT = GetMilliSecs()
		o.bForceDel = False
		
		If ID = OBJ_DEMON Then ' // Demon
			o.Q = Q ' // Quadrent
			o.A = 0 ' // Warp in
			
			If bSecret = True Then
				o.Lev = secLevel
				o.dLas = Rand(0, 1) ' // Laser or spread
			Else
				o.Lev = curLevel
			EndIf
			
			o.F = Rand(0, 3)
			o.W1 = X - 418 ' // Warp X1
			o.W2 = X + 418 ' // Warp X2
			o.T = GetMilliSecs()
			o.bFall = False
			o.K = K ' // Bird ID
			o.Dive = False
			
			If K > 0 Then o.A = 1; o.Act = Act ' // Bird active
			
			If o.A = 0 Then o.Moved = False
			
			' // Player target / alien life
			If b2Player = False Then 
				o.bTarget = 0; o.Life = 1 
			ElseIf b2Player = True Then 
				o.bTarget = Rand(0, 1)
				If bHas2 = True Then o.Life = 2 Else o.Life = 1
			EndIf
			
			o.bInvis = False; o.invisT = GetMilliSecs(); o.invisR = Rand(2000, 3500)
			o.hitK = -1
			o.vin = False
			
		ElseIf ID = OBJ_BIRD Then ' // Bird
			o.Lev = curLevel
			o.F = Rand(0, 3)
			o.T = GetMilliSecs()
			o.D = Rand(0, 1)
			o.YD = Rand(0, 1)
			If o.YD = 0 Then o.YR = 2.6 Else o.YR = -Rnd(2.6, 4.5)
			'o.YR = -Rnd(2.6, 4.5)

			If o.D = 0 Then o.X:-24 ElseIf o.D = 1 Then o.X:+24 ' // Leave room for laser
			
			' // Player target / alien life
			If b2Player = False Then 
				o.bTarget = 0; o.Life = 1 
			ElseIf b2Player = True Then 
				o.bTarget = Rand(0, 1)
				'If bHas2 = True Then o.Life = 2 Else o.Life = 1
				o.Life = 1 ' // Always 1
			EndIf
			
			o.hitK = -1
			o.vin = False
			
			o.bInvis = False; o.invisT = GetMilliSecs(); o.invisR = Rand(2000, 3500)

		EndIf
		
		Return o
	End Function

	Method Render()
        Local Del:Int = False

		Select ID	
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² DEMON 
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //	
			Case OBJ_DEMON
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
			
			Local tmpImg:TImage 
			If Lev = 1 Or Lev = 15 Or Lev = 31 Or Lev = 47 Then ' // Demon 1
				tmpImg = imgDemon1
			ElseIf Lev = 2 Or Lev = 17 Or Lev = 33 Or Lev = 49 Then
				tmpImg = imgDemon2
			ElseIf Lev = 3 Or Lev = 19 Or Lev = 35 Or Lev = 51 Then
				tmpImg = imgDemon3
			ElseIf Lev = 5 Or Lev = 21 Or Lev = 37 Or Lev = 53 Then
				tmpImg = imgDemon4
			ElseIf Lev = 7 Or Lev = 23 Or Lev = 39 Or Lev = 55 Then
				tmpImg = imgDemon5
			ElseIf Lev = 9 Or Lev = 25 Or Lev = 41 Or Lev = 57 Then
				tmpImg = imgDemon6
			ElseIf Lev = 11 Or Lev = 27 Or Lev = 43 Or Lev = 59 Then
				tmpImg = imgDemon7
			ElseIf Lev = 13 Or Lev = 29 Or Lev = 45 Or Lev = 61 Then
				tmpImg = imgDemon8
			EndIf
			
			If K <> 0 Then tmpImg = imgBird ' // Bird
			
			Local tmpOff:Int = 0, tmpOff2:Int = 0 ' // Palette offset
			If hitK = -1 Then
				If cfgBR = 1 Then tmpOff = 4; tmpOff2 = 2
			Else
				If cfgBR = 0 Then tmpOff = 4; tmpOff2 = 2
			EndIf
			
			Local bFrame:Int = False
			If GetMilliSecs() >= FT + 90 Then ' // Frame timer
				bFrame = True
				FT = GetMilliSecs()
			EndIf
			
			Local bFrame2:Int = False
			If GetMilliSecs() >= FT2 + 45 Then ' // Frame timer
				bFrame2 = True
				FT2 = GetMilliSecs()
			EndIf
			
			If A = 0 Then ' // Warp in
				If Moved = True Then
					DrawImage imgWarp, W1, Y, 0 + tmpOff2
					DrawImage imgWarp, W2, Y, 1 + tmpOff2
				EndIf
				
				Local bEx:Int = False
				For p:Part = EachIn partList
					If p.ID = PART_EXPLODE And p.K = 0 Then bEx = True; Exit
				Next
				
				If bEx = False Or Moved = True Then ' // Wait for explosion to go away
					If Moved = False And bTitle = False Then PlaySFX sfxWarp

					Moved = True ' // Safe to warp in
					If W1 + 14 < X Then W1:+14 Else W1 = X
					If W2 - 14 > X Then W2:-14 Else W2 = X
					
				EndIf
				
				If W1 = X And W2 = X Then ' // Become alive
					A = 1 
					D = Rand(0, 1)
					YD = Rand(0, 1)
					If YD = 0 Then
						YR = Rnd(1, yVel)
					Else
						YR = Rnd(-1, -yVel)
					EndIf
					YI = 0
					
				EndIf
				
			ElseIf A = 1 Then ' // Alive
				If Dive = True Then Act = 0; bShoot = False ' // Failsafe
				
				If b2Player = True Then ' // Target switch on death
					If bTarget = 0 And pDeath[0] = 2 Then 
						bTarget = 1
					ElseIf bTarget = 1 And pDeath[1] = 2 Then
						bTarget = 0
					EndIf
				EndIf
				
				Local tmpInvis:Int = False 
				If bSecret = True Then ' // Mode 3
					If GetMilliSecs() >= invisT + invisR Then
						If bInvis = True Then 
							bInvis = False 
							invisR = Rand(2000, 4500)						
						Else 
							bInvis = True
							invisR = Rand(1000, 2500)						
						EndIf
						invisT = GetMilliSecs()

					EndIf					
					tmpInvis = bInvis					
				EndIf
				
				If tmpInvis = False Then
					If vin = False Then
						DrawImage tmpImg, Int(X), Int(Y), F + tmpOff
					Else
						If Rand(1, 2) = 1 Then SetBlend ALPHABLEND; SetAlpha .5
						DrawImage tmpImg, Int(X), Int(Y), F + tmpOff
						SetBlend ALPHABLEND; SetAlpha 1
						If GetMilliSecs() >= vinT + 500 Then vin = False
					EndIf
				EndIf
				
				If bFrame = True Then
					
					Local tmpXOff:Int = 60
					If K <> 0 Then tmpXOff = 32
					
					If (bShoot = True And dShot <= 3) And pDeath[bTarget] = False Then ' // Shooting
						If Rand(1, 2) = 1 Then
						Else
						If D = 0 Then D = 1 Else D = 0
						If D = 0 Then
							If X - demSpeed > 0 Then X:-demSpeed Else D = 1
						ElseIf D = 1 Then
							If X + demSpeed < 588 - tmpXOff Then X:+demSpeed Else D = 0
						EndIf
						EndIf
					Else
						' // X
						If D = 0 Then
							If X - demSpeed > 0 Then X:-demSpeed Else D = 1
						ElseIf D = 1 Then
							If X + demSpeed < 588 - tmpXOff Then X:+demSpeed Else D = 0
						EndIf

						Local tmpR:Int
						If Q = 3 And Y >= 256 And pDeath[bTarget] = False And bShoot = False Then
							If K <> 0 Then ' // Bird seek
								If Act = 1 Then
									If pX[bTarget] + 20 >= X + 16 Then D = 1 Else D = 0
								ElseIf Dive = True
									' // Seek
									If pX[bTarget] + 20 >= X + 66 Then 
										D = 1 
									ElseIf pX[bTarget] + 20 <= X - 36 Then
										D = 0
									EndIf
								
								EndIf
							Else
								If pX[bTarget] + 20 >= X + 30 Then D = 1 Else D = 0
							EndIf
						Else
							'If (Q = 3 And K = 0) Or (Q = 3 And Act = 1) Then ' // Seek
							'	If Act = 1 Then
							'		If pX + 20 >= X + 16 Then D = 1 Else D = 0
							'	Else
							'		If pX + 20 >= X + 30 Then D = 1 Else D = 0
							'	EndIf
							'Else
								If Rand(1, 15) = 7 Then
									If D = 0 Then D = 1 Else D = 0
								EndIf
							'EndIf
						EndIf
											
					EndIf														
																													
				EndIf
										
				' // Shot avoidance
				Local tmpSmart:Int = dSmart
				If K <> 0 Then tmpSmart = dSmart / 2 ' // Bird AI
				If tmpSmart < 2 Then tmpSmart = 2
				
				If Rand(1, tmpSmart) = Int(tmpSmart / 2) Then
					If shotX <> 0 And shotY >= Y Then
						Local tmpXOff:Int = 30
						If K <> 0 Then tmpXOff = 16
						
						If D = 0 Then
							If X + tmpXOff >= shotX And X - tmpXOff <= shotX Then D = 1
						ElseIf D = 1 Then
							If X + (tmpXOff * 3) >= shotX And X + tmpXOff <= shotX Then D = 0
						EndIf
					EndIf
					
					If shotX2 <> 0 And shotY2 >= Y Then
						Local tmpXOff:Int = 30
						If K <> 0 Then tmpXOff = 16
						
						If D = 0 Then
							If X + tmpXOff >= shotX2 And X - tmpXOff <= shotX2 Then D = 1
						ElseIf D = 1 Then
							If X + (tmpXOff * 3) >= shotX2 And X + tmpXOff <= shotX2 Then D = 0
						EndIf
					EndIf
				EndIf
																
				' // Y
				If (bFrame2 = True And bShoot = False) Or (bShoot = True And dShot > 3 And bFrame2 = True) Then
					If Dive = False Then ' // Not diving
						Local tmpY:Int
						If YD = 0 Then ' // Fly up
							If Q = 1 Then tmpY = 117 - 20 ElseIf Q = 2 Then tmpY = 198 - 20 ElseIf Q = 3 Then tmpY = 280 - 20
							
							If Y - YI > tmpY Then ' // Within range
								Y:-YI
								bFall = False 
							Else
								If bFall = False Then
									YD = 1
									YR = Rnd(-2, -3.5)
								EndIf
							EndIf
							
							If YI < YR Then YI:+.5 Else YD = 1; YR = Rnd(-2, -3.5)
							
						ElseIf YD = 1 Then ' // Fly down
							If Q = 1 Then tmpY = 117 + 20 ElseIf Q = 2 Then tmpY = 198 + 20 ElseIf Q = 3 Then tmpY = 280 + 16 ' // BUG FIX
							
							If Y - YI < tmpY Then 
								Y:-YI 
							Else 							
								YD = 0
								YR = Rnd(2, 3.5)
							EndIf
							
							If YI > YR Then YI:-.5 Else YD = 0; YR = Rnd(2, 3.5)
						EndIf	
					
						If bFall = True Then
							If Q = 2 And Y < 174 Then Y:+1.75
							If Q = 3 And Y < 256 Then Y:+1.5
						EndIf
						
						If Rand(1, 10) = 5 Then
							If YD = 0 Then YD = 1 Else YD = 0
						EndIf
					
					Else ' // Diving
						Local tmpY:Int
						If YD = 0 Then ' // Fly up
							
							If YI < YR Then ' // Within range
								Y:-YI
								YI:+.5

							Else
								YD = 1; YR = -4.5
							EndIf
												
						ElseIf YD = 1 Then ' // Fly down							
							If YI > YR Then 
								Y:-YI 
								YI:-.5

							Else 							
								YD = 0; YR = 2.6 
							EndIf
							
						EndIf						
						
					EndIf
					
					'If Rand(1, 20) = 10 Then
					'	If YD = 0 Then YD = 1; YR = Rnd(-1, -yVel) Else YD = 0; YR = Rnd(1, yVel)
					'EndIf
				EndIf
							
				Local oldX:Int, oldY:Int, oldQ:Int, oldLev:Int, oldK:Int
												
				If vin = False Then ' // Invin check				
				For p:Part = EachIn partList ' // Particles	
					If p.ID = PART_SHOT Then 
						If ImagesCollide2(tmpImg, Int(X), Int(Y), F + tmpOff, 0, sclX, sclY, imgShot, Int(p.X), Int(p.Y), 0, 0, sclX, sclY) Then
							Local oldSX:Int = p.X, oldSY:Int = p.Y
							If p.K = 0 Then shotX = 0; shotY = 0 ElseIf p.K = 1 Then shotX2 = 0; shotY2 = 0
							partList.Remove p
							
							' // Per player
							'If hitK = -1 Or hitK <> p.K Then
							'	Life:-1
							'	hitK = p.K
							'   If hitK = 0 Then bTarget = 1 ElseIf hitK = 1 Then bTarget = 0 ' // Switch target player						
							'EndIf

							Life:-1
							
							If Life > 0 Then ' // 2 Player
								vin = True
								vinT = GetMilliSecs()
								
								hitK = p.K
								If hitK = 0 Then bTarget = 1 ElseIf hitK = 1 Then bTarget = 0 ' // Switch target player						
								
								If bTitle = False And bForceDel = False Then playSFX sfxExplode
								
								Local tmpYOff:Int = 0
								If K <> 0 Then tmpYOff = 2
								partList.AddLast part.Create(oldSX - 28, Y - tmpYOff, PART_FLARE) ' // Hit flare

							Else
								Del = True
								oldX = X; oldY = Y; oldQ = Q; oldLev = Lev; oldK = K
								objList.Remove o
								
								If oldQ = 3 Then 
									If curLevel < 3 Then 
										bHit:+1 ' // Shift demons

									Else
										If oldK <> 0 Then ' // Match birds									
											If CheckBird(oldK) = False And Dive = False Then bHit:+1
										EndIf								
									EndIf
								EndIf
								
								'quadC = 3
								If oldK = 0 And curLevel < 3 Then ' // Demon
									If oldQ = 2 Then 
										quadC = 4 ' // Spawn middle
										If demonT = 9 Then bHit:+1 ' // Shift
									EndIf
								ElseIf oldK <> 0 Then 
									If oldQ = 2 Then
										If CheckBird(oldK) = False Then 
											quadC = 4 ' // Spawn middle
											If demonT = 9 Then bHit:+1
										EndIf
									EndIf
								EndIf
							EndIf								
							
							Exit
						EndIf
					EndIf
				Next				
				EndIf ' // End invin check
								
				If bForceDel = True Then  ' // Force delete
					Del = True
					oldX = X; oldY = Y; oldQ = Q; oldLev = Lev; oldK = K
					objList.Remove o
				EndIf
				
				Local bDive:Int = False
				If Dive = True And Del = False Then ' // Dive collision
					For Local i:Int = 0 To b2Player
						If pDeath[i] = False And Del = False Then
							If ImagesCollide2(imgBird, Int(X), Int(Y), F + tmpOff, 0, sclX, sclY, imgShip, Int(pX[i]), Int(pY[i]), 0, 0, sclX, sclY) Then			
								pDeath[i] = True
								bForceFlash = False
								pT[i] = GetMilliSecs()
								pF[i] = 0
								If bTitle = False Then PlaySFX sfxDeath
								
								oldX = X; oldY = Y; oldQ = Q; oldLev = Lev; oldK = K
								'quadC = oldQ - 1

								objList.Remove o
								bDive = 2
								Del = True
							EndIf
						EndIf
					Next
				EndIf				
				
				If Dive = True And Del = False And bTitle = False Then ' // Dive sound
					If ChannelPlaying(diveChan) = False Then diveChan = PlaySFX(sfxDive)
				EndIf
				
				If Dive = True And Y >= 412 - 12 And Del = False Then ' // Dive death
					StopChannel diveChan
					Del = True; bDive = True
					oldX = X; oldY = Y; oldQ = Q; oldLev = Lev; oldK = K
					'quadC = oldQ - 1

					objList.Remove o
				EndIf
				
				If Del = False Then ' // Shoot / animate
				
					Local bLaser:Int = False, tmpLev:Int
					If bSecret = True Then
						bLaser = dLas
						If bLaser = False Then tmpLev = 1 Else tmpLev = 2
					Else
						bLaser = IsLaser(Lev)
						tmpLev = Lev
					EndIf
					
					If Q = 3 And dShot <= 0 And pDeath[bTarget] = False And GetMilliSecs() >= shootStop + 1250 Then ' // No shot check
					
						If (K <> 0 And Act < 1) Or Dive = True Then ' // Active bird check
						Else
							If bLaser = False Then ' // Spread shot
								If K = 0 Then
									CS = Rand(maxShot - 6, maxShot) ' // Current shot
								Else ' // Bird shot
									If Rand(1, 10) = 5 Then
										CS = Rand(maxShot - 6, maxShot - 3)
									Else
										CS = maxShot
									EndIf
								EndIf

								OX = X; OY = Y							
								ST = GetMilliSecs() - shotTime ' // Shot timer
								
							Else ' // Dual laser
								'If o.K = 0 Then CS = maxLaser Else CS = Int(maxLaser / 2)
								CS = maxLaser
								OX = X; OY = Y

								ST = GetMilliSecs() - 60 ' // Shot timer
							EndIf
							
							bShoot = True
						EndIf
						
					EndIf

					If bShoot = True Then					
						If dShot < CS Then
							Local tmpXOff:Int = 15, tmpYOff:Int = 16
							If K <> 0 Then tmpXOff = 0; tmpYOff = 12
							
							If bLaser = False Then ' // Spread shot
								If GetMilliSecs() >= ST + shotTime Then
									partList.AddLast part.Create(X + tmpXOff + (Rand(0, 7) * 4), Y + tmpYOff, PART_LASER, 0, tmpLev) ' // Laser
									dShot:+1
									ST = GetMilliSecs()

									If Rand(1, 4) = 2 And dShot < CS Then ' // Second shot
										partList.AddLast part.Create(X + tmpXOff + (Rand(0, 7) * 4), Y + tmpYOff, PART_LASER, 0, tmpLev) ' // Laser
										dShot:+1
									EndIf
								EndIf

							Else ' // Dual laser
								If GetMilliSecs() >= ST + 60 Then
									If o.K = 0 Then ' // Dual laser
										partList.AddLast part.Create(OX + 12, OY + 20, PART_LASER, 0, tmpLev) ' // Laser
										partList.AddLast part.Create(OX + 40, OY + 20, PART_LASER, 1, tmpLev) ' // Laser

										If dShot + 1 < CS Then
											partList.AddLast part.Create(OX + 12, OY + 16, PART_LASER, 0, tmpLev) ' // Laser
											partList.AddLast part.Create(OX + 40, OY + 16, PART_LASER, 1, tmpLev) ' // Laser

											dShot:+2											
										Else
											dShot:+1
										EndIf
																												
									Else ' // Bird laser
										partList.AddLast part.Create(OX + 12, OY + 20, PART_LASER, 0, tmpLev) ' // Laser

										If dShot + 1 < CS Then
											partList.AddLast part.Create(OX + 12, OY + 16, PART_LASER, 0, tmpLev) ' // Laser											
											dShot:+2
										Else
											dShot:+1
										EndIf
									
									EndIf
									
									ST = GetMilliSecs()
								EndIf

							EndIf
							
						Else
							If Act = 1 Then ' // Seek after shooting
								If pX[bTarget] + 20 >= X + 16 Then D = 1 Else D = 0
							Else
								If pX[bTarget] + 20 >= X + 30 Then D = 1 Else D = 0
							EndIf

							bShoot = False
						EndIf
					EndIf
					
					Local tmpT:Int = 180
					If GetMilliSecs() >= T + tmpT Then
						Local tmpF:Int
						If F < Rand(2, 3) Then 
							F:+1 
						Else 
							F = 0
						EndIf
						
						T = GetMilliSecs()
					EndIf
									
				Else ' // Delete
					If bDive = False Then
						Local tmpK:Int = 0, tmpOff:Int = 0
						If curLevel >= 3 And K = 0 Then tmpK = 1 ' // Demon vs. bird
						If K <> 0 Then tmpOff = 16
						partList.AddLast part.Create(oldX - tmpOff, oldY, PART_EXPLODE, tmpK, oldQ) ' // Explosion / split
						If bTitle = False And bForceDel = False Then 
							If tmpK = 0 Then playSFX sfxExplode Else playSFX sfxSplit
						EndIf
						If K <> 0 Then pScore:+scoreB Else pScore:+scoreD ' // Score
						
					ElseIf bDive = 2 Then ' // Dive bomb
						Local tmpK:Int = 0, tmpOff:Int = 0
						If curLevel >= 3 And K = 0 Then tmpK = 1 ' // Demon vs. bird
						If K <> 0 Then tmpOff = 16
						partList.AddLast part.Create(oldX - tmpOff, oldY, PART_EXPLODE, tmpK, oldQ) ' // Explosion / split
					
					EndIf
					
					Del = False ' // Already removed
					
				EndIf
											
			EndIf ' // End alive block

			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
			' // ² BIRD
			' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //	
			Case OBJ_BIRD
			SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY
						
			Local tmpOff:Int = 0, tmpOff2:Int = 0 ' // Palette offset
			If hitK = -1 Then
				If cfgBR = 1 Then tmpOff = 4; tmpOff2 = 2
			Else
				If cfgBR = 0 Then tmpOff = 4; tmpOff2 = 2
			EndIf
			
			Local bFrame:Int = False
			If GetMilliSecs() >= FT + 90 Then ' // Frame timer
				bFrame = True
				FT = GetMilliSecs()
			EndIf
			
			Local bFrame2:Int = False
			If GetMilliSecs() >= FT2 + 45 Then ' // Frame timer
				bFrame2 = True
				FT2 = GetMilliSecs()
			EndIf

			Local tmpInvis:Int = False 
			If bSecret = True Then ' // Mode 3
				If GetMilliSecs() >= invisT + invisR Then
					If bInvis = True Then 
						bInvis = False 
						invisR = Rand(2000, 4500)						
					Else 
						bInvis = True
						invisR = Rand(1000, 2500)						
					EndIf
					invisT = GetMilliSecs()

				EndIf
				If Y > 246 Or shieldF = -1 Then tmpInvis = bInvis ' // out of shield											
			EndIf
			
			If tmpInvis = False Then
				If vin = False Then
					DrawImage imgBird, Int(X), Int(Y), F + tmpOff
				Else
					If Rand(1, 2) = 1 Then SetBlend ALPHABLEND; SetAlpha .5
					DrawImage imgBird, Int(X), Int(Y), F + tmpOff
					SetBlend ALPHABLEND; SetAlpha 1
					If GetMilliSecs() >= vinT + 750 Then vin = False
				EndIf
			EndIf
							
			If Y + 12 >= 210 And Y <= 246 And shieldF <> -1 Then ' // In forcefield
				Y:+spawnS
				CS = 1
			Else
			If CS = 1 Then YD = 1; YR = -4.5; CS = 0 ' // Coming out of shield
			
			If bFrame = True Then
					
				Local tmpXOff:Int = 32

				' // X
				If D = 0 Then
					If X - demSpeed > 0 Then X:-demSpeed Else D = 1
				ElseIf D = 1 Then
					If X + demSpeed < 588 - tmpXOff Then X:+demSpeed Else D = 0
				EndIf

				If A = 0 Then
					If Rand(1, 15) = 7 Then
						If D = 0 Then D = 1 Else D = 0
					EndIf
				EndIf
				
			EndIf
																						
			' // Y
			If bFrame2 = True Then
				Local tmpY:Int
				If YD = 0 Then ' // Fly up
					
					If YI < YR Then ' // Within range
						Y:-YI
						YI:+.5

						'If Y + 12 >= 338 Then A = 1; YR = -5.5; YD = 1

					Else
						YD = 1
						'If A = 0 Then YR = -4 Else YR = -5.5
						If Y + 12 >= 324 And A = 0 Then
							A = 1; YR = -6.1
						Else
							If Y + 12 >= 340 Or A = 1 Then 
								YR = -5.2; A = 1 Else YR = -4.5
							EndIf
						EndIf
					EndIf
										
				ElseIf YD = 1 Then ' // Fly down
					If A = 0 And Y > 246 Then Y:+.75 ' // Force down for dive
					
					If YI > YR Then 
						Y:-YI 
						'DebugLog "DY: " + Y + " / Y: " + pY
						YI:-.5

						'If Y + 12 >= pY Then A = 1; YR = 5.5; YD = 0

					Else 							
						YD = 0
						'If Y + 12 >= pY Or A = 1 Then YR = 5.5; A = 1 Else YR = 2.5
						If A = 0 Then YR = 2.6 Else YR = 5.2

					EndIf
					
				EndIf	
				
				If Y >= pY[0] Then Y = pY[0] ' // Limit
									
				'If Rand(1, 20) = 10 Then
				'	If YD = 0 Then YD = 1; YR = Rnd(-1, -yVel) Else YD = 0; YR = Rnd(1, yVel)
				'EndIf
			EndIf
			EndIf ' // End forcefield check
											
			Local oldX:Int, oldY:Int
			If vin = False Then ' // Invin block
			For p:Part = EachIn partList ' // Particles	
				If p.ID = PART_SHOT Then 
					If ImagesCollide2(imgBird, Int(X), Int(Y), F + tmpOff, 0, sclX, sclY, imgShot, Int(p.X), Int(p.Y), 0, 0, sclX, sclY) Then
						Local oldSX:Int = p.X, oldSY:Int = p.Y
						If p.K = 0 Then shotX = 0; shotY = 0 ElseIf p.K = 1 Then shotX2 = 0; shotY2 = 0
						partList.Remove p
						
						If CS = 1 Then ' // In shield
							bForceFlash = True
							bFlash = True
							flashT = GetMilliSecs()
							flashF = 0
							gameTime = GetMilliSecs()
							
							If Int(shieldF) = 0 Then
								PlaySFX sfxShield1
							ElseIf Int(shieldF) = 1 Then
								PlaySFX sfxShield2
							ElseIf Int(shieldF) = 2 Then
								PlaySFX sfxShield3
							ElseIf Int(shieldF) = 3 Then
								PlaySFX sfxShield4
							ElseIf Int(shieldF) = 4 Then
								PlaySFX sfxShield5
							ElseIf Int(shieldF) = 5 Then
								PlaySFX sfxShield6
							EndIf
							
							Local tmpLim:Float = 5
							If b2Player = True And bHas2 = True Then tmpLim = 5.5
							
							If shieldF < tmpLim Then 
								If b2Player = True Then
									If bHas2 = True Then 
										shieldF:+.5
									Else 
										shieldF:+1
									EndIf
								Else
									shieldF:+1 
								EndIf
							Else 
								shieldF = -1
							EndIf
							Life = 0
						Else
							If bTitle = False And bForceDel = False playSFX sfxExplode

							Life:-1
							
							If Life > 0 Then
								partList.AddLast part.Create(oldSX - 28, Y - 2, PART_FLARE) ' // Hit flare
								vin = True
								vinT = GetMilliSecs()
								
							EndIf
							' // Per player hit
							'If hitK = -1 Or hitK <> p.K Then
							'	Life:-1
								hitK = p.K
							'	If hitK = 0 Then bTarget = 1 ElseIf hitK = 1 Then bTarget = 0 ' // Switch target player						
							'EndIf
								
						EndIf
							
						If Life <= 0 Then ' // 2 Player											
							oldX = X; oldY = Y
							objList.Remove o
							Del = True						
						EndIf
						
						Exit						
					EndIf
				EndIf
			Next								
			EndIf
			
			If bForceDel = True Then ' // Force delete
				oldX = X; oldY = Y
				objList.Remove o
				Del = True			
			EndIf
			
			' // Player collision	
			If Del = False Then
				For Local i:Int = 0 To b2Player
					If pDeath[i] = False And Del = False Then
						If ImagesCollide2(imgBird, Int(X), Int(Y), F + tmpOff, 0, sclX, sclY, imgShip, Int(pX[i]), Int(pY[i]), 0, 0, sclX, sclY) Then			
							pDeath[i] = True
							bForceFlash = False
							pT[i] = GetMilliSecs()
							pF[i] = 0
							If bTitle = False Then PlaySFX sfxDeath
							
							oldX = X; oldY = Y
							objList.Remove o
							Del = True
						EndIf
					EndIf
				Next
			EndIf
						
			If Del = False Then				
				Local tmpT:Int = 180
				If GetMilliSecs() >= T + tmpT Then
					Local tmpF:Int
					If F < Rand(2, 3) Then 
						F:+1 
					Else 
						F = 0
					EndIf
					
					T = GetMilliSecs()
				EndIf
								
			Else ' // Delete
				partList.AddLast part.Create(oldX - 16, oldY, PART_EXPLODE, 0) ' // Explosion
				pScore:+scoreB
				
				Del = False				
			EndIf
												
		End Select
		
		objC:+1
		If Del = True Then objList.Remove o
		
	End Method
End Type

LoadImages(cfgFilter)

Repeat
	SetBlend ALPHABLEND; SetAlpha 1; SetScale sclX, sclY; SetColor 255, 255, 255

	If bWindowed = False Then
		SetOrigin 26, 16 ' // Fullscreen
	Else
		SetOrigin 0, 0
	EndIf

	Local tmpF:Int = 0
	If bFlash = True Then tmpF = 2 Else tmpF = cfgBR	
	If IsBoss() = True Then	
		If bTran = True Then ' // Screen transition
			Local tmpF4:Int = cfgBR
			DrawImage imgBack, 0, 0, tmpF
			DrawSubImageRect imgTran, 0, 0, 512, tranY, 0, 0, 512, tranY, 0, 0, tmpF4
			If tranY >= 37 Then
				Local tmpTranY:Int = tranY
				If tmpTranY >= 179 Then tmpTranY = 179
				DrawSubImageRect imgBoss, 0, 37, 512, tmpTranY - 37, 0, 0, 512, tmpTranY - 37, 0, 0, tmpF4
			EndIf
			
			'If GetMilliSecs() >= tranT + 1 Then
			If tranY < 384 Then 
				tranY:+20
			Else 
				bTran = False; eyeT = GetMilliSecs()
				If b2Player = False Then
					pX[0] = 273; pY[0] = 392
				Else
					pX[PLAYER_1] = 137; pY[PLAYER_1] = 392
					pX[PLAYER_2] = 410; pY[PLAYER_2] = 392
				EndIf
				birdT = GetMilliSecs()
			EndIf
			tranT = GetMilliSecs()
			'EndIf
			
		Else
			'SetColor 251, 255, 134
			DrawImage imgBack2, 0, 0, tmpF
			'SetColor 143, 211, 255
			DrawImage imgBoss, 0, 37, tmpF
			
			If bossDeath = False Then
				SetScale sclX * 2, sclY * 2
				Local tmpF3:Int = 0
				If bFlash = True Then tmpF3 = 12 Else tmpF3 = (cfgBR * 6)		
				If shieldF <> -1 Then DrawImage imgShield, 0, 175, Int(shieldF) + tmpF3
				SetScale sclX, sclY
				
				Local tmpF2:Int = 0
				If bFlash = True Then tmpF2 = 16 Else tmpF2 = (cfgBR * 8)
			
				DrawImage imgEye, 267, 70, eyeF + tmpF2
				DrawImage imgMouth, 253, 130, eyeF + tmpF2

				If GetMilliSecs() >= eyeT + 260 Then
					If eyeF < 7 Then eyeF:+1 Else eyeF = 0
					eyeT = GetMilliSecs()
				EndIf			
				
			ElseIf (bossDeath = True And bFlash = False) Then ' // Death animation
				Local tmpF5:Int = (cfgBR * 10)
				Local tmpF6:Int = (cfgBR * 8)
				
				DrawImage imgEye2, 257, 61, eyeF + tmpF5
				If mouthF <> -1 Then
					DrawImage imgMouth2, 253, 130, mouthF + tmpF6
				Else
					DrawImage imgMouth2, 253, 130, tmpF6
				EndIf
				
				If eyeF = 9 And mouthF = 6 Then ' // Fade
					SetScale sclX * 2, sclY * 2
					If cfgBR = 0 Then 
						DrawImage imgFade, 0, 0, fadeF
					ElseIf cfgBR = 1 Then
						DrawImage imgFade2, 0, 0, fadeF
					EndIf
					SetScale sclX, sclY
				EndIf
				
				Local tmpT:Int
				If eyeF <= 2 Then tmpT:Int = 150 Else tmpT = 100
				If GetMilliSecs() >= eyeT + tmpT Then
					If eyeF < 9 Then
						eyeF:+1
						If eyeF = 1 Then PlaySFX sfxbDeath
					Else 
						eyeF = 9
						If mouthF = -1 Then mouthF = 0; mouthT = GetMilliSecs()
					EndIf
					eyeT = GetMilliSecs()
				EndIf	
				
				If GetMilliSecs() >= mouthT + 134 Then
					If mouthF = 6 And fadeF = -1 Then fadeF = 0
					
					If mouthF <> -1 And mouthF <> 6 Then
						If mouthF < 6 Then 
							mouthF:+1 
						Else 
							mouthF = 6
						EndIf
					Else
						If fadeF < 20 Then 
							fadeF:+1 
						Else 
							fadeF = 20

							If bTran = False Then
								curLevel:+1
								UpScore()
								
								'LoadImages(cfgFilter)
								
								bTran = True
								For o:Obj = EachIn objList; objList.Remove o; Next
								For p:Part = EachIn partList; partList.Remove p; Next
								bTran = True; tranT = GetMilliSecs(); tranY = 0
								dShot = 0; demonT = 0; bFirstWarp = True; quadC = 3; bHit = False
								bFlash = False; fadeF = -1							
								flushInput
								bossDeath = False
								pFlawLess = True
							EndIf							
						EndIf
						
					EndIf
					
					mouthT = GetMilliSecs()					
				EndIf
				
			EndIf
			
			SetColor 255, 255, 255
		EndIf
		
	Else
		If bTran = True Then	
			DrawImage imgBack2, 0, 0, tmpF
			If fadeF <> -1 Then DrawImage imgBoss, 0, 37, tmpF ' // Boss defeated?

			' // Shield
			SetScale sclX * 2, sclY * 2
			Local tmpF3:Int = 0
			If bFlash = True Then tmpF3 = 12 Else tmpF3 = (cfgBR * 6)	
			If shieldF <> -1 Then DrawImage imgShield, 0, 175, Int(shieldF) + tmpF3
			SetScale sclX, sclY
			
			Local tmpF4:Int = cfgBR	
			If cfgEGA = True Then tmpF4 = 3 ' // Mono
			DrawSubImageRect imgBack, 0, 0, 512, tranY, 0, 0, 512, tranY, 0, 0, tmpF4
			
			If tranY <= 384 Then 
				tranY:+24
			Else
				If bTitle = False Then 
					LoadImages(cfgFilter)

					'sX = 0; sX2 = 0

					If cfgEGA = True Then 
						backA1 = 0; backA2 = 1; backTran = True
						backT = GetMilliSecs()
					EndIf
				EndIf
				
				bTran = False; eyeT = GetMilliSecs()
				If b2Player = False Then
					pX[0] = 273; pY[0] = 392
				Else
					pX[PLAYER_1] = 137; pY[PLAYER_1] = 392
					pX[PLAYER_2] = 410; pY[PLAYER_2] = 392				
				EndIf
			EndIf
			tranT = GetMilliSecs()		
		Else
			'SetColor 213, 111, 255
			If backTran = True Then
				SetBlend LIGHTBLEND; SetAlpha backA1
				DrawImage imgBack, 0, 0, tmpF

				SetAlpha backA2
				DrawImage imgBack, 0, 0, 3
				
				If GetMilliSecs() >= backT + 1 Then
					If backA1 < 1 Then backA1:+.0125 Else backA1 = 1
					If backA2 > 0 Then backA2:-.0125 Else backA2 = 0
					
					If backA1 = 1 And backA2 = 0 Then backTran = False
					backT = GetMilliSecs()
				EndIf
				SetBlend ALPHABLEND; SetAlpha 1
			Else
				DrawImage imgBack, 0, 0, tmpF
			EndIf
			
			'SetColor 255, 255, 255
		EndIf
	EndIf
		
	If bTitle = True Then
		If bTran = False Then ' // Transistion		
		DrawImage imgLogo, 0, 0, tmpF
		
		If cfgBR = 1 Then SetColor invR2, invG2, invB2 Else SetColor invR1, invG1, invB1
		If bFlash = True Then SetColor 255, 90, 255
		If tScreen = 0 Or tScreen = 1 Then ' // Main / Options
			DrawFont "2023 EikSoft", -1, 120
		ElseIf tScreen = 3 Then
			DrawFont "Enter your name", -1, 120
		EndIf
		
		'If tScreen <> 2 Then
			If bFlash = True Then SetColor 255, 255, 255 Else SetColor 0, 0, 0
			DrawRect 193, 160, 173, 164 
		'Else
			'SetColor 255, 255, 255
			'DrawRect 118, 136, 301, 175
			
			'If bFlash = True Then SetColor 255, 255, 255 Else SetColor 0, 0, 0 
			'DrawRect 120, 138, 298, 171
		'EndIf
		
		If bFlash = True Then SetColor 255, 112, 59 Else SetColor 255, 255, 255
		If bSecret = True And tScreen < 2 Then DrawFont "4 JB", 456, 120
		
		If tScreen = 0 Then ' // Title
			DrawFont "1 Player", -1, 166
			DrawFont "2 Player", -1, 190
			DrawFont "Hi Score", -1, 214
			DrawFont "Options ", -1, 238
			DrawFont "End Game", -1, 262	
				
		ElseIf tScreen = 1 Then ' // Options
			Local tmpS:String

			DrawFont "SFX     ", -1, 166
			DrawFont String(cfgSFX) + "%", 344, 166
			
			DrawFont "Music   ", -1, 190
			DrawFont String(cfgMusic) + "%", 344, 190
			
			DrawFont "PAL     ", -1, 214
			If cfgBR = 0 Then tmpS$ = "BR" Else tmpS$ = "RB"
			DrawFont tmpS$, 344, 214

			DrawFont "EGA     ", -1, 238
			If cfgEGA = 0 Then tmpS$ = "off" Else tmpS$ = "on"
			DrawFont tmpS$, 344, 238

			DrawFont "Filter  ", -1, 262
			If cfgFilter = 0 Then tmpS$ = "off" Else tmpS$ = "on"
			DrawFont tmpS$, 344, 262
			
			DrawFont "CRT     ", -1, 286		
			If cfgCRT = 0 Then tmpS$ = "0%" ElseIf cfgCRT = 1 Then tmpS$ = "25%" ElseIf cfgCRT = 2 Then tmpS$ = "50%" ElseIf cfgCRT = 3 Then tmpS$ = "75%" ElseIf cfgCRT = 4 Then tmpS$ = "100%"			
			DrawFont tmpS$, 344, 286

			If cfgFull = 0 Then tmpS$ = "Window  " Else tmpS$ = "Full    "
			DrawFont tmpS$, -1, 310	
			
			DrawFont "Back    ", -1, 334		
		
		ElseIf tScreen = 2 Then ' // Hi scores

			If netP > 0 Then DrawFont "$", 444, 142
			If netP < 90 Then DrawFont "+", 444, 340

			DrawFont "Online Top 100", -1, 120
			
			' // Draw online scores
			Local tmpY:Int = 142
			For Local i:Int = netP To netP + 9
				If i = 0 Then 
					If cfgBR = 1 Then SetColor invR2, invG2, invB2 Else SetColor invR1, invG1, invB1
					If bFlash = True Then SetColor 255, 90, 255
				Else
					If bFlash = True Then SetColor 255, 112, 59 Else SetColor 255, 255, 255
				EndIf
								
				DrawFont RSet(String(i + 1), 3) + " " + Upper(Right(net_Score[i], 6)) + " " + NumFormat(Left(net_Score[i], Len(net_Score[i]) - 7)), 124, tmpY
				SetColor 255, 255, 255
				tmpY:+22
			Next
		
		ElseIf tScreen = 3 Then ' // Name entry
		
			If bFlash = True Then SetColor 255, 255, 255 Else SetColor 0, 0, 0
			DrawRect 132, 226, 45, 24
			If bFlash = True Then SetColor 255, 112, 59 Else SetColor 255, 255, 255
			DrawFont hi_Entry$, -1, 316
			
			Local tmpA:Int = 65
			For Local tmpY:Int = 148 To 333 Step 42
				For Local tmpX:Int = 141 To 435 Step 48
					If tSelX = tmpX And tSelY = tmpY Then ' // Current letter
						If cfgBR = 1 Then SetColor invR2, invG2, invB2 Else SetColor invR1, invG1, invB1
						If bFlash = True Then SetColor 255, 90, 255
						hi_A = tmpA
					Else
						If bFlash = True Then SetColor 255, 112, 59 Else SetColor 255, 255, 255
					EndIf
					DrawFont Chr(tmpA), tmpX, tmpY
					If tmpA < 90 Then tmpA:+1 Else Exit
				Next
				If tmpA = 90 Then Exit
			Next
						
			If tSelX = 381 And tSelY = 274 Then 
				If cfgBR = 1 Then SetColor invR2, invG2, invB2 Else SetColor invR1, invG1, invB1
				If bFlash = True Then SetColor 255, 90, 255
			Else
				If bFlash = True Then SetColor 255, 112, 59 Else SetColor 255, 255, 255
			EndIf

			DrawFont "END", 383, 274
			SetColor 255, 255, 255
			
			'DebugLog "TSelX: " + tSelX + " TSelY: " + tSelY
								
		EndIf
		EndIf ' // End transistion block
		
		SetColor 255, 255, 255		
		
		Local tmpY:Int
		If tSel = 0 Then tmpY = 163 ElseIf tSel = 1 Then tmpY = 187 ElseIf tSel = 2 Then tmpY = 211 ElseIf tSel = 3 Then tmpY = 235 ElseIf tSel = 4 Then tmpY = 259 ElseIf tSel = 5 Then tmpY = 283 ElseIf tSel = 6 Then tmpY = 307 ElseIf tSel = 7 Then tmpY = 331
		Local tmpF:Int = 0
		If cfgBR = 1 Then tmpF = 4
		If tScreen < 2 Then DrawImage imgExplode, 173, tmpY, 0 + tmpF

		Local bJoyUp:Int = -1
		Local bJoyDown:Int = -1
		Local bJoyLeft:Int = -1
		Local bJoyRight:Int = -1
		
		' // Up
		If GetInput(PLAYER_1, INP_U) = True And bJoy1YHit = False Then bJoyUp = PLAYER_1; secretCode$:+"U" 
				
		' // Down
		If GetInput(PLAYER_1, INP_D) = True And bJoy1YHit = False Then bJoyDown = PLAYER_1; secretCode$:+"D" 

		' // Left
		If GetInput(PLAYER_1, INP_L) = True And bJoy1XHit = False Then bJoyLeft = PLAYER_1
				
		' // Right
		If GetInput(PLAYER_1, INP_R) = True And bJoy1XHit = False Then bJoyRight = PLAYER_1

		If bJoyUp <> -1 Then
			If tScreen = 0 Or tScreen = 1 Then
				If tSel > 0 Then tSel:-1 Else tSel = 0
			ElseIf tScreen = 2 Then ' // Hi scores
				If netP > 0 Then netP:-10
			ElseIf tScreen = 3 Then ' // Name entry
				If tSelY > 148 Then tSelY:-42
				
			EndIf
			
			bJoy1YHit = True
			
		ElseIf bJoyDown <> -1 Then
			If tScreen = 0 Then
				If tSel < 4 Then tSel:+1 Else tSel = 4
			ElseIf tScreen = 1 Then
				If tSel < 7 Then tSel:+1 Else tSel = 7
			ElseIf tScreen = 2 Then ' // Hi scores
				If netP < 90 Then netP:+10
			ElseIf tScreen = 3 Then ' // Name entry
				If tSelY < 274 Then 
					If tSelX = 429 And tSelY = 232 Then tSelX:-48 ' // End
					tSelY:+42
				EndIf
			EndIf
			
			bJoy1YHit = True
		
		ElseIf bJoyLeft <> -1 Then
			If tScreen = 3 Then ' // Name entry
				If tSelX > 141 Then tSelX:-48
			EndIf
			
			bJoy1XHit = True
			
		ElseIf bJoyRight <> -1 Then ' // Name entry
			If tSelX < 429 Then 
				If tSelX = 381 And tSelY = 274 Then ' // End
				Else
					tSelX:+48	
				EndIf
			EndIf
			
			bJoy1XHit = True
			
		EndIf

		If bLoopback = True Then ' // JOYSTICK BUG FIX
			FlushJoy 0
			FlushJoy 1
		EndIf
		
		If GetInput(PLAYER_1, INP_A, 0) = True Then 
			If tScreen = 0 Then 
				secretCode$:+"A" 
			ElseIf tScreen = 3 Then ' // Name entry
				If Len(hi_Entry$) > 0 Then hi_Entry$ = Left$(hi_Entry$, Len(hi_Entry$) - 1); PlaySFX sfxSplit

			EndIf
			
			FlushInput
		EndIf
		
			
		If GetInput(PLAYER_1, INP_B, 0) = True Or GetInput(PLAYER_1, INP_S, 0) = True Then
		
			If tScreen = 0 Then ' // Title
				If tSel = 0 Then ' // 1 Player
					PlaySFX(sfxShot)					
					b2Player = False
					
					NewGame(b2Player)
					
					bTitle = False				
					gameTime = GetMilliSecs()
					Repeat
						Local tmpF:Int = 0
						If bFlash = True Then tmpF = 2 Else tmpF = cfgBR	
						DrawImage imgBack, 0, 0, tmpF
						
						RenderOverlay
						
						Flip -1
					Until GetMilliSecs() >= gameTime + 500
					
					bFromTitle = True
					FlushInput
					
				ElseIf tSel = 1 Then ' // 2 Player
					PlaySFX(sfxShot)					
					b2Player = True
					
					NewGame(b2Player)
					
					bTitle = False				
					gameTime = GetMilliSecs()
					Repeat
						Local tmpF:Int = 0
						If bFlash = True Then tmpF = 2 Else tmpF = cfgBR	
						DrawImage imgBack, 0, 0, tmpF
						
						RenderOverlay
						
						Flip -1
					Until GetMilliSecs() >= gameTime + 500
					
					bFromTitle = True
					FlushInput
									
				ElseIf tSel = 2 Then ' // Scores
					If LoadScores() = True Then
						tSel = 0
						tScreen = 2
					EndIf
					FlushInput
									
				ElseIf tSel = 3 Then ' // Options
					PlaySFX(sfxShot)
					tScreen = 1; tSel = 0
					FlushInput
					
				ElseIf tSel = 4 Then ' // End
					EndGame
					
				EndIf	
			
			ElseIf tScreen = 1 Then ' // Options
						
				If tSel = 0 Then ' // SFX
					If cfgSFX < 100 Then cfgSFX = cfgSFX + 10 Else cfgSFX = 0
					PlaySFX(sfxShot)
				
				ElseIf tSel = 1 Then ' // Music
					PlaySFX(sfxShot)					

					If cfgMusic < 100 Then cfgMusic:+10 Else cfgMusic = 0				
					musChan.SetVolume(Float(cfgMusic) / 100) 					
					
				ElseIf tSel = 2 Then ' // Palette
					If cfgEGA = 0 Then
						If cfgBR = 0 Then cfgBR = 1 Else cfgBR = 0
					EndIf
					PlaySFX(sfxShot)

				ElseIf tSel = 3 Then ' // EGA
					If cfgEGA = 0 Then cfgEGA = 1; cfgBR = 0 Else cfgEGA = 0
					LoadImages cfgFilter, False
					
					PlaySFX(sfxShot)
				
				ElseIf tSel = 4 Then ' // Filter
					If cfgFilter = 0 Then cfgFilter = 1 Else cfgFilter = 0
					LoadImages cfgFilter, False
					
					PlaySFX(sfxShot)
				
				ElseIf tSel = 5 Then ' // CRT
					If cfgCRT < 4 Then cfgCRT = cfgCRT + 1 Else cfgCRT = 0
					PlaySFX(sfxShot)
					
				ElseIf tSel = 6 Then ' // Window
					If cfgFull = 0 Then cfgFull = 1 Else cfgFull = 0
					PlaySFX(sfxShot)
				
				ElseIf tSel = 7 Then ' // Back
					tScreen = 0
					tSel = 0
					PlaySFX(sfxShot)
					
					FlushInput
				EndIf
			
			ElseIf tScreen = 2 Then ' // Hi score		
				PlaySFX sfxShot
				
				tSel = 0
				tScreen = 0
					
				FlushInput
			
			ElseIf tScreen = 3 Then ' // Name entry

				If tSelX = 381 And tSelY = 274 Then ' // End (UPLOAD)
					PlaySFX sfxShot
					If hi_Entry$ = "" Then hi_Entry$ = "DemonX" ' // Default
					
					sfxChan = PlaySFX(sfxUpload)					
					UploadScore(pScore + " " + LSet(hi_Entry$, 6))	

					tScreen = 0; tSel = 0
					
				Else ' // Letter
					If Len(hi_Entry$) < 6 Then hi_Entry$ = hi_Entry$ + Chr(hi_A); PlaySFX sfxShot
				EndIf

				FlushInput
							
			EndIf
			
		EndIf
		
		' // Secret code
		If Right$(secretCode$, 12) = "UDUUDDAUADAA" Then
			PlaySFX sfx1Up
			bSecret = True
			secretCode$ = ""
		EndIf
		
		If bLoopback = True And Upper$(hi_Entry$) = "A" Then hi_Entry$ = "" ' // Bug fix
		bLoopback = False

		' // Reset joysticks
		If JoyY(p1Joy) <= .5 And JoyY(p1Joy) >= -.5 Then 
			bJoy1YHit = False ' // Reset joystick
		EndIf
		
		If JoyX(p1Joy) <= .5 And JoyX(p1Joy) >= -.5 Then 
			bJoy1XHit = False ' // Reset joystick
		EndIf
		
	EndIf

	If pDeath[0] = False Then ' // Player ship
		If bTran = False Then 
			Local tmpShipF:Int = cfgBR
			If bForceFlash = True And bFlash = True Then tmpShipF = 2
			If b2Player = True And pDeath[1] = False Then
				If pDeath[0] = False Then
					If ImagesCollide2(imgShip, Int(pX[0]), Int(pY[0]), 0, 0, sclX, sclY, imgShip, Int(pX[1]), Int(pY[1]), 0, 0, sclX, sclY) = True Then
						SetBlend ALPHABLEND
						SetAlpha .8
					Else
						SetBlend ALPHABLEND
						SetAlpha 1
					EndIf
				EndIf			
			EndIf
			DrawImage imgShip, pX[0], pY[0], tmpShipF ' // Player 1
			SetBlend ALPHABLEND; SetAlpha 1
		EndIf
	EndIf
	
	If b2Player = True Then
		If bTran = False And pDeath[1] = False Then 
			Local tmpShipF:Int
			If cfgBR = 0 Then tmpShipF = 1 ElseIf cfgBR = 1 Then tmpShipF = 0
			If bForceFlash = True And bFlash = True Then tmpShipF = 2
			If pDeath[0] = False Then
				If ImagesCollide2(imgShip, Int(pX[0]), Int(pY[0]), 0, 0, sclX, sclY, imgShip, Int(pX[1]), Int(pY[1]), 0, 0, sclX, sclY) = True Then
					SetBlend ALPHABLEND
					SetAlpha .8
				Else
					SetBlend ALPHABLEND
					SetAlpha 1
				EndIf
			EndIf
			DrawImage imgShip, pX[1], pY[1], tmpShipF ' // Player 1
			SetBlend ALPHABLEND; SetAlpha 1
		EndIf	
	EndIf
	
	Local shotC:Int = 0, shotC2:Int = 0, demonC:Int = 0, bWarp:Int = False
	Local qList:Int[] = [0,0,0,0,0,0,0,0,0,0], qA:Int = 0

	For Local tmpClear:Int = 0 To 9; qList[tmpClear] = 0; Next
	
	objC = 0
	For o:Obj = EachIn objList ' // Objects
		o.Render()
		
		If o.ID = OBJ_DEMON Then 		
			If o.A = 0 Then bWarp = True
			'If o.Q = lastQ Then lastQ = o.Q - 1

			Local bCheck:Int = True
			For Local tmpI:Int = 0 To 9
				If qList[tmpI] = o.Q Then bCheck = False; Exit
			Next
						
			If (bCheck = True And o.Dive = False) Then ' // One demon per quadrant
				demonC:+1
				qList[qA] = o.Q
				qA:+1
			'Else
			'	If o.Dive = True Then demonC:+1
			EndIf
		EndIf
				
	Next

	' // Check for dives
	For o:Obj = EachIn objList
		If o.ID = OBJ_DEMON And o.K <> 0 And o.Dive = True Then demonC:+1
	Next
	
	' // Check for splits
	For p:Part = EachIn partList
		If p.ID = PART_EXPLODE And p.K = 1 Then demonC:+1
	Next
	
	If demonC >= 3 And bFirstWarp = True Then bFirstWarp = False
	
	demonCount = demonC ' // Public
	
	If switchID <> 0 Then ' // Switch active bird
		For o:Obj = EachIn objList ' // Objects	
			If o.ID = OBJ_DEMON And switchID = o.K Then 
				o.Act = 1 ' Else o.Dive = 1 ' // Active vs. dive
				Exit ' // Set active
			EndIf
		Next
	EndIf
		
	'Local lastK:Int = 0
	If bHit > 0 Then ' // Shift demons
		'If quadC = 4 And demonT = 9 Then quadC = 3
		bHit:-1
		
		For o:Obj = EachIn objList ' // Objects		
			If o.ID = OBJ_DEMON Then
				If o.Q <> 3 Then
				
					' // Check quad is empty
					Local tmpList:TList = objList, tmpCheck:Int = False
					For o2:Obj = EachIn tmpList
						If o2.ID = OBJ_DEMON Then
							If o.K = 0 Then
								If o2.Dive = False And o2.Q = o.Q + 1 Then tmpCheck = True; Exit
							Else
								If o2.Dive = False And o2.K <> o.K And o2.Q = o.Q + 1 Then tmpCheck = True; Exit
							EndIf
						EndIf
					Next
					
					For p:Part = EachIn partList
						If p.ID = PART_EXPLODE And p.K = 1 And p.Q = o.Q + 1 Then tmpCheck = True; Exit
					Next
					
					'DebugLog "SHIFT" + Rand(1, 100)
					If tmpCheck = False Then ' // Quad is empty and not warping in
						'DebugLog "SHIFT" + Rand(1, 100)

						o.Q:+1; o.bFall = True
						If o.Q = 3 And o.K <> 0 Then ' // Set active
							tmpList = objList; tmpCheck = False
							For o2:Obj = EachIn tmpList
								If o2.ID = OBJ_DEMON And o2.K <> 0 And o2.K = o.K And o2.Act = 1 Then tmpCheck = True; Exit
							Next
							If tmpCheck = False Then o.Act = 1; DebugLog "SET ACTIVE " + Rand(1, 100) 
						EndIf
					Else
						bHit:+1 ' // Try again
					EndIf
					
				EndIf
			EndIf
		Next

	EndIf
	
	If curLevel >= 5 And IsBoss() = False Then ' // Set dive
		Local diveC:Int = 0
		Local bDC:Int = False
		
		For o:Obj = EachIn objList
			If o.ID = OBJ_DEMON And o.K <> 0 And o.Q = 3 Then 
				diveC:+1 
				If o.Dive = True Then bDC = True
			EndIf
		Next
		If bDC = True Then diveC = -1 ' // Already a diver		
		
		' // Set dive
		If diveC = 1 Or diveC = 3 Then
			For o:Obj = EachIn ObjList
				If o.ID = OBJ_DEMON And o.K <> 0 And o.Q = 3 And o.Dive = False Then
					If o.Y >= 275 Then 
						o.Act = 0; o.Dive = True
						'o.hitK = 0; o.Life = 1 ' // Weaken on dive
						o.bFall = False
						bHit:+1 ' // Shift
					ElseIf o.Y >= 260 Then
						o.bFall = True
						'o.Act = 1
					EndIf
					Exit
				EndIf
			Next
		EndIf
		
	EndIf
	
	'If demonT = 9 Then ' // Force them down when all have spawned
		If curLevel >= 3 And IsBoss() = False And demonC <= 2 Then bHit = 1; DebugLog "FORCE DOWN" + Rand(1, 100)
	'EndIf
	
	If bTitle = False Then
		' // Score
		If pScore > 0 Then DrawScore pScore, 23, 2
		
		' // Lives
		Local tmpX:Int = 520
		tmpF:Int = 0
		If cfgBR = 1 Then tmpF = 4
		If bFlash = True Then tmpF = 8
		For Local i:Int = 1 To pLives
			If bWin = True And livesF <> -1 And i = pLives Then ' // 1-Up
				DrawImage imgLives, tmpX, 2, livesF + tmpF		
				If GetMilliSecs() >= livesT + 120 Then
					If GetMilliSecs() >= winT + 1320 And livesF = 2 Then
					Else
						If livesF < 3 Then livesF:+1 Else livesF = 0
						livesT = GetMilliSecs()
					EndIf
				EndIf
			Else
				DrawImage imgLives, tmpX, 2, 2 + tmpF
			EndIf
			tmpX:-37
		Next
	Else ' // Top score
		If topScore > 0 Then DrawScore topScore, 23, 2

	EndIf
	
	partC = 0
	Local bExplode:Int = False
	For p:Part = EachIn partList ' // Particles
		p.Render()
		
		If p.ID = PART_SHOT And p.K = 0 Then shotC:+1
		If p.ID = PART_SHOT And p.K = 1 Then shotC2:+1
		
		'If p.ID = PART_EXPLODE Then bExplode = True
	Next
	
	For Local i:Int = 0 To b2Player
		If pDeath[i] = False Then
			If b2Player = True Then
				If i = 0 Then
					If pDeath[1] = False And bForceFlash = False Then bFlash = False
				ElseIf i = 1 Then
					If pDeath[0] = False And bForceFlash = False Then bFlash = False
				EndIf		
			Else
				If bForceFlash = False Then bFlash = False				
			EndIf	
		
		ElseIf pDeath[i] = True Then
		
			If IsBoss() = True Then ' // Delete shots in boss 
				For p:Part = EachIn partList
					If p.ID = PART_SHOT And p.K = i Then partList.Remove p
				Next
			EndIf
			
			pFlawless = False
			
			Local tmpF:Int = 0
			If i = PLAYER_1 Then
				If cfgBR = 1 Then tmpF = 4
			ElseIf i = PLAYER_2 Then
				If cfgBR = 0 Then tmpF = 4
			EndIf
			DrawImage imgDeath, pX[i] - 10, 371, pF[i] + tmpF

			If GetMilliSecs() >= flashT + 18 And bFlash = True Then bFlash = False
			If GetMilliSecs() >= flashT + 60 Then
				bFlash = True
				flashT = GetMilliSecs()	
			EndIf
				
			If GetMilliSecs() >= pT[i] + 120 Then
				If pF[i] < 3 Then 
					pF[i]:+1
				Else				
					If bTitle = False Then 
						If pLives > 0 Then ' // Still alive
							If IsBoss() = True Then
								If b2Player = True Then
									If (i = 0 And pDeath[1] <> False) Or (i = 1 And pDeath[0] <> False) Then pLives:-1
								Else
									pLives:-1
								EndIf
							Else
								pLives:-1
							EndIf
							
						Else ' // Game over
							If IsBoss() = True Then
								If b2Player = True Then
									If (i = 0 And pDeath[1] <> False) Or (i = 1 And pDeath[0] <> False) Then pLives = -1							
								Else
									pLives = -1
								EndIf
							Else
								pLives = -1
							EndIf
						EndIf
					EndIf

					pDeath[i] = 2
					flashT = GetMilliSecs()
					bFlash = False						

					'pX = 273; pY = 392
				EndIf

				pT[i] = GetMilliSecs()
			EndIf
		EndIf
	Next
	
	For Local i:Int = 0 To b2Player
		If pDeath[i] = 2 Then ' // Death delay / GAME OVER
			If GetMilliSecs() >= pT[i] + 1000 Then 
				If pLives >= 0 Then
				
					If IsBoss() = True Then ' // One life per boss
						If b2Player = False Or (pDeath[0] + pDeath[1] = 4) Then
							curLevel:+1
							UpScore() ' // Increase score
							
							'LoadImages(cfgFilter)
						
							bTran = True; tranT = GetMilliSecs(); tranY = 0

							If b2Player = False Then
								pX[0] = 273; pY[0] = 392
							Else
								pX[PLAYER_1] = 137; pY[PLAYER_1] = 392
								pX[PLAYER_2] = 410; pY[PLAYER_2] = 392					
							EndIf

							For o:Obj = EachIn objList; objList.Remove o; Next
							For p:Part = EachIn partList; partList.Remove p; Next
							dShot = 0; demonT = 0; bFirstWarp = True; quadC = 3; bHit = False
							bFlash = False; pFlawless = True
							
							pDeath[0] = False; pDeath[1] = False
						EndIf
						
					Else			
						pDeath[i] = False
						FlushInput i

					EndIf
										
				Else
					Local bCheck:Int = False
					If b2Player = True Then
						If pDeath[0] + pDeath[1] = 4 Then bCheck = True
					Else
						bCheck = True
					EndIf
					
					If bCheck = True Then
						If IsBoss() = True Then ' // Died at boss
							curLevel:-1 
							bTran = True; tranT = GetMilliSecs(); tranY = 0
							fadeF = 0
						EndIf
												
						pD = Rand(0, 1)
						pX[0] = 273; pY[0] = 392

						For o:Obj = EachIn objList; objList.Remove o; Next
						For p:Part = EachIn partList; partList.Remove p; Next
						dShot = 0; demonT = 0; bFirstWarp = True; quadC = 3; bHit = False
						bFlash = False; pDeath[0] = False
						pLives = 2
						
						FlushInput
						
						If pScore > 0 Then topScore = pScore
						
						bLoopback = True
						b2Player = False
						hi_Entry$ = ""
						tSelX = 141; tSelY = 148
						If pScore > 0 And bSecret = False Then tScreen = 3 ' // Name entry
						bSecret = False; secretCode$ = ""
						tSel = 0; bTitle = True
					EndIf
					
				EndIf
			EndIf
		EndIf
	Next
	
	' // Forced flash
	If bForceFlash = True Then ' // Force flash
		If GetMilliSecs() >= flashT + 18 And bFlash = True Then bFlash = False
		If GetMilliSecs() >= flashT + 60 Then
			bFlash = True
			flashT = GetMilliSecs()
		EndIf

		If GetMilliSecs() >= gameTime + 120 Then
			If flashF < 1 Then 
				flashF:+1 
			Else 
				flashT = GetMilliSecs()
				bFlash = False
				bForceFlash = False
			EndIf
			gameTime = GetMilliSecs()
		EndIf
				
	EndIf
			
	If demonT = 9 And demonC = 0 And dShot <= 0 Then ' // End level
		If bWin = False Then
			If pFlawless = True And bTitle = False Then ' // 1-Up
				If pLives < 9 Then 
					pLives:+1 
					livesF = 0
					livesT = GetMilliSecs()
					PlaySFX sfx1Up
				Else 
					pLives = 9 ' // Cap
				EndIf
			EndIf
			
			winT = GetMilliSecs()
			bWin = True

		Else
			If GetMilliSecs() >= winT + 1320 Then
				If bTitle = False Then
					curLevel:+1
					UpScore() ' // Increase score
					
					If b2Player = False Then
						pX[0] = 273; pY[0] = 392
					Else
						pX[PLAYER_1] = 137; pY[PLAYER_1] = 392
						pX[PLAYER_2] = 410; pY[PLAYER_2] = 392					
					EndIf
					
					If IsBoss() Then ' // Screen transition						
						bTran = True; tranY = 0; tranT = GetMilliSecs()
						shieldF = 0
					EndIf
				EndIf
				demonT = 0
				livesF = -1
				'lastQ = 3
				bWin = False
				eyeF = 0
				pFlawless = True
				bFirstWarp = True
			EndIf
		EndIf
	
	Else ' // Pulsing
		If bWarp = False And bExplode = False And pDeath[0] = False And bWin = False And demonC > 0 And bTitle = False Then
			Local tmpS:TSound = Null
			Select demonT
				Case 3; tmpS = sfxPulse1
				Case 4; tmpS = sfxPulse2
				Case 5; tmpS = sfxPulse3
				Case 6; tmpS = sfxPulse4
				Case 7; tmpS = sfxPulse5
				Case 8; tmpS = sfxPulse6
				Case 9; tmpS = sfxPulse7
			End Select
			
			If tmpS <> Null And GetMilliSecs() >= pulseT + 250 Then ' // Restart delay
				If ChannelPlaying(diveChan) = False Then
					If ChannelPlaying(pulseChan) = False Then pulseChan = PlaySFX(tmpS)
				EndIf
			EndIf
		Else
			pulseT = GetMilliSecs()
		EndIf
	EndIf
	
	If IsBoss() = False Then ' // Boss level check
		debugWarp = bWarp; debugExplode = bExplode
		
		If demonC < 3 And bWarp = False And bTran = False Then ' // Create demon			
			
			Local lastQ:Int = 0
			Local bHas1:Int = False, bHas2:Int = False, bHas3:Int = False

			' // Last spawn check
			Local tmpQuad:Int = 3
			For o:Obj = EachIn objList
				If o.ID = OBJ_DEMON And o.Q <= tmpQuad Then tmpQuad = o.Q - 1
				If o.ID = OBJ_DEMON And o.Q = 3 Then bHas3 = True
				If o.ID = OBJ_DEMON And o.Q = 2 Then bHas2 = True
			Next
			For p:Part = EachIn partList
				If p.ID = PART_EXPLODE And p.K = 1 And p.Q <= tmpQuad Then tmpQuad = p.Q - 1
			Next
			lastQ = tmpQuad ' // Find blank space
						
			If quadC = 4 Then 
				lastQ = 2; quadC = 3 ' // Force middle
			ElseIf lastQ < 1 Then ' // Check middle
				
				bHas1 = False; bHas2 = False; bHas3 = False
				For o:Obj = EachIn objList
					If o.ID = OBJ_DEMON Then
						If o.Q = 1 Then 
							bHas1 = True
						ElseIf o.Q = 2 Then
							bHas2 = True
						ElseIf o.Q = 3 And o.Dive = False Then
							bHas3 = True
						EndIf
					EndIf
				Next
				
				If bHas1 = True And bHas3 = True And bHas2 = False Then ' // Fill middle
					lastQ = 2	
				EndIf
				
			EndIf

			'For p:Part = EachIn partList
			'	If p.ID = PART_EXPLODE And p.K = 0 Then lastQ = 0
			'Next
			
			'DebugLog "QuadC: " + quadC
			
			'If lastQ < 1 Then lastQ = 2
			
			' // Last check	that quad is empty
			bHas1 = False; bHas2 = False; bHas3 = False
			For o:Obj = EachIn objList
				If o.ID = OBJ_DEMON And o.Q = lastQ And o.Dive = False Then lastQ = -1

				If o.Q = 1 Then 
					bHas1 = True
				ElseIf o.Q = 2 Then
					bHas2 = True
				ElseIf o.Q = 3 And o.Dive = False Then
					bHas3 = True
				EndIf				
			Next
			
			If lastQ = 3 And bfirstWarp = False Then lastQ = -1 ' // No third quad
			If bHas1 = True And bHas2 = True And bHas3 = True Then lastQ = -99 ' // Full
			
			Local tmpY:Int
			If lastQ = 3 Then 
				tmpY = 280 + Rand(-24, 24)
			ElseIf lastQ = 2 Then
				tmpY = 198 + Rand(-24, 24)
			ElseIf lastQ = 1 Then
				tmpY = 117 + Rand(-24, 24)
			EndIf
						
			If demonT < 9 And lastQ > 0 Then ' // 9 total demons
				'DebugLog "LASTQ: " + lastQ
				objList.AddLast obj.Create(Rand(170, 418) - 30, tmpY, OBJ_DEMON, lastQ)
				'If bTitle = False Then 
				demonT:+1
			Else
				If demonT = 9 Or lastQ < 0 And lastQ <> -99 Then ' // Check for shift down
					Local bCheck:Int = False, bK:Int = 0
					For o:Obj = EachIn objList
						If o.ID = OBJ_DEMON And o.Dive = False And o.Q = 3 Then 
							bK = o.K
							bCheck = True
							Exit
						EndIf
					Next
					
					debugQ = -99

					If bCheck = False Then ' // shift
						For o:Obj = EachIn objList
							If o.ID = OBJ_DEMON And o.K = 0 And o.Q = 2 Then
								Local tmpCheck:Int = False
								For p:Part = EachIn partList
									If p.ID = PART_EXPLODE And p.K = 1 And p.Q = o.Q + 1 Then tmpCheck = True; Exit
								Next
								If tmpCheck = False Then
									o.Q:+1; o.bFall = True
									bCheck = True
									DebugLog "DEMON SHIFT" + Rand(1, 100)
									Exit
								EndIf
							EndIf
						Next
						
						debugQ = -98
																					
					EndIf
					
				EndIf
				
			EndIf
		EndIf
	
	Else ' // Birds
		
		If bTran = False And bossDeath = False Then
			' // Level timer
			If GetMilliSecs() >= birdT + spawnT Then
				objList.AddLast obj.Create(279, 135, OBJ_BIRD, 1)
			
				birdT = GetMilliSecs()
			EndIf
		EndIf
		
	EndIf
		
	If bTitle = False Then ' // Game vs. title
		If bossDeath = False And bTran = False Then ' // Player input
			
			For Local i:Int = 0 To b2Player
				If pDeath[i] = False Then
					If GetInput(i, INP_L, 1) Then
						If pX[i] - 4.5 > 0 Then pX[i]:-4.5
						
					ElseIf GetInput(i, INP_R, 1) Then
						If pX[i] + 4.5 < 588 - 41 Then pX[i]:+4.5
					EndIf
					
					If GetInput(i, INP_B, 1) Then
						Local tmpShot:Int
						If i = PLAYER_1 Then tmpShot = shotC ElseIf i = PLAYER_2 Then tmpShot = shotC2
						If tmpShot = 0 Then
							partList.AddLast part.Create(pX[i] + 18, pY[i] - 10, PART_SHOT, i)
							PlaySFX sfxShot
						EndIf
					EndIf
					
					If GetInput(i, INP_S) = True Then 
						If i = PLAYER_1 Then bP1Start = True ElseIf i = PLAYER_2 Then bP2Start = True
					EndIf
					
					If bP1Start = True Or bP2Start = True Then			
						bPaused = True; PlaySFX sfxPause
						PauseChannel musChan
						FlushInput		
						pauseStart = GetMilliSecs() ' // Hold pause start time
					EndIf
						
				EndIf
				
			Next
		EndIf
		
	Else ' // Title
		If pDeath[0] = False And bTran = False And bossDeath = False Then 
			If pD = 0 Then
				If pX[0] - 4 > 0 Then pX[0]:-4 Else pD = 1
			ElseIf pD = 1 Then
				If pX[0] + 4 < 588 - 41 Then pX[0]:+4 Else pD = 0
			EndIf
			
			If shotC = 0 Then partList.AddLast part.Create(pX[0] + 18, pY[0] - 10, PART_SHOT)
			
		EndIf
		
	EndIf
		
	If bDebug = True Then DrawDebug ' // Debug
	If bFromTitle = False Then RenderOverlay()
	bFromTitle = False
	
	GetFuncInput()

	If GetMilliSecs() >= fpsTimer + 1000 Then FPS = curFrames; curFrames = 0; fpsTimer = GetMilliSecs()
	curFrames = curFrames + 1
		
	Flip -1
	
	If bPaused = True Then ' // PAUSE
		Local tmpIn:Int = 0

		DebugLog "Start: " + bP1Start + " / " + bP2Start
		
		Repeat
			GetFuncInput ' // Function Keys
			
			If bP1Start = True Then
				If GetInput(PLAYER_1, INP_S) = True Then tmpIn = 1
			ElseIf bP2Start = True Then
				If GetInput(PLAYER_2, INP_S) = True Then tmpIn = 1
			EndIf

			If KeyDown(KEY_ESCAPE) = True Then tmpIn = 2
			Delay 10 ' // Give CPU time
		Until tmpIn <> 0
		
		bP1Start = False; bP2Start = False
		PlaySFX sfxPause; bPaused = False
		pauseTotal = pauseTotal + (GetMilliSecs() - pauseStart) ' // Time offset fix

		If tmpIn <> 2 Then 
			ResumeChannel musChan
			FlushInput
		Else
			EndGame
		EndIf
		
	EndIf
	
	Cls
Until KeyDown(KEY_ESCAPE) = True Or AppTerminate() = True
EndGame

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADIMAGES - Loads images with filter                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadImages(bFilter:Int, bUpdate:Int = True)

	Local imgFlags:Int
	If bFilter = 0 Then imgFlags = MASKEDIMAGE Else imgFlags = MASKEDIMAGE|FILTEREDIMAGE
	
	GCRelease imgCRT
	GCRelease imgBack
	GCRelease imgBack2
	GCRelease imgLogo
	GCRelease imgFont
	GCRelease imgShip
	GCRelease imgShot
	GCRelease imgWarp
	GCRelease imgDemon1
	GCRelease imgDemon2
	GCRelease imgDemon3
	GCRelease imgDemon4
	GCRelease imgDemon5
	GCRelease imgDemon6
	GCRelease imgDemon7
	GCRelease imgDemon8
	GCRelease imgExplode
	GCRelease imgLives
	GCRelease imgDeath
	GCRelease imgScore
	GCRelease imgSplit
	GCRelease imgBird
	GCRelease imgBoss
	GCRelease imgEye
	GCRelease imgMouth
	GCRelease imgShield
	GCRelease imgTran
	GCRelease imgEye2
	GCRelease imgMouth2
	GCRelease imgFade
	GCRelease imgFade2
	'GCRelease imgStars
	GCCollect
	
	SetMaskColor 255, 0, 255
	
	imgCRT = LoadImage("gfx/crt5.png", MASKEDIMAGE)	
	imgBack = LoadAnimImage("gfx/back.png", 512, 384, 0, 4, imgFlags)
	imgBack2 = LoadAnimImage("gfx/back2.png", 512, 384, 0, 3, imgFlags)
	imgLogo = LoadAnimImage("gfx/logo.png", 512, 156, 0, 3, imgFlags)
	imgFont = LoadAnimImage("gfx/font.png", 12, 10, 0, 42, imgFlags)
	imgShip = LoadAnimImage("gfx/ship.png", 36, 18, 0, 3, imgFlags)
	imgShot = LoadAnimImage("gfx/shot.png", 4, 22, 0, 2, imgFlags)
	imgWarp = LoadAnimImage("gfx/warp.png", 52, 14, 0, 4, imgFlags)
	imgDemon1 = LoadAnimImage("gfx/demon1.png", 52, 14, 0, 8, imgFlags)
	imgDemon2 = LoadAnimImage("gfx/demon2.png", 52, 14, 0, 8, imgFlags)
	imgDemon3 = LoadAnimImage("gfx/demon3.png", 52, 14, 0, 8, imgFlags)
	imgDemon4 = LoadAnimImage("gfx/demon4.png", 52, 14, 0, 8, imgFlags)
	imgDemon5 = LoadAnimImage("gfx/demon5.png", 52, 14, 0, 8, imgFlags)
	imgDemon6 = LoadAnimImage("gfx/demon6.png", 52, 14, 0, 8, imgFlags)
	imgDemon7 = LoadAnimImage("gfx/demon7.png", 52, 14, 0, 8, imgFlags)
	imgDemon8 = LoadAnimImage("gfx/demon8.png", 52, 14, 0, 8, imgFlags)
	imgExplode = LoadAnimImage("gfx/explode.png", 52, 14, 0, 8, imgFlags)
	imgLives = LoadAnimImage("gfx/lives.png", 20, 16, 0, 12, imgFlags)
	imgDeath = LoadAnimImage("gfx/death.png", 52, 26, 0, 12, imgFlags)
	imgScore = LoadAnimImage("gfx/score.png", 20, 18, 0, 10, imgFlags)
	imgSplit = LoadAnimImage("gfx/split.png", 52, 14, 0, 6, imgFlags)
	imgBird = LoadAnimImage("gfx/bird.png", 28, 12, 0, 8, imgFlags)
	imgBoss = LoadAnimImage("gfx/boss.png", 512, 142, 0, 3, imgFlags)
	imgEye = LoadAnimImage("gfx/eye.png", 48, 20, 0, 24, imgFlags)
	imgMouth = LoadAnimImage("gfx/mouth.png", 72, 22, 0, 24, imgFlags)
	imgShield = LoadAnimImage("gfx/shield2.png", 256, 31, 0, 18, imgFlags)
	imgTran = LoadAnimImage("gfx/tran.png", 512, 384, 0, 2, imgFlags)
	imgEye2 = LoadAnimImage("gfx/eye2.png", 64, 38, 0, 20, imgFlags)
	imgMouth2 = LoadAnimImage("gfx/mouth2.png", 72, 42, 0, 16, imgFlags)
	imgFade = LoadAnimImage("gfx/fade.png", 256, 87, 0, 21, imgFlags)
	imgFade2 = LoadAnimImage("gfx/fade2.png", 256, 87, 0, 21, imgFlags)
	'imgStars = LoadAnimImage("gfx/stars.png", 512, 384, 0, 3, imgFlags)
		
	invR1 = 255; invG1 = 128; invB1 = 0
	invR2 = 0; invG2 = 128; invB2 = 255
	
	If cfgEGA = 1 Then UpdateColors(bUpdate)
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² UPDATECOLORS - Updates colors of all images in EGA
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function UpdateColors(bUpdate:Int = True)

	' // EGA colors
	'ega3 = ($FF Shl 24) | (240 Shl 16) | (79 Shl 8) | 120

	Local tmpR1:Int	
	If bUpdate = True Or oldEGA1 = -1 Then
		Repeat
			tmpR1 = Rand(0, 7)
		Until tmpR1 <> oldEGA1
		oldEGA1 = tmpR1
	Else
		tmpR1 = oldEGA1
	EndIf
	
	'tmpR1 = 1
	Select tmpR1
		Case 0; ega3 = ($FF Shl 24) | (240 Shl 16) | (79 Shl 8) | 120
		Case 1; ega3 = ($FF Shl 24) | (169 Shl 16) | (233 Shl 8) | 63
		Case 2; ega3 = ($FF Shl 24) | (143 Shl 16) | (211 Shl 8) | 255
		Case 3; ega3 = ($FF Shl 24) | (159 Shl 16) | (140 Shl 8) | 203
		Case 4; ega3 = ($FF Shl 24) | (251 Shl 16) | (107 Shl 8) | 29
		Case 5; ega3 = ($FF Shl 24) | (48 Shl 16) | (225 Shl 8) | 185
		Case 6; ega3 = ($FF Shl 24) | (245 Shl 16) | (219 Shl 8) | 65
		Case 7; ega3 = ($FF Shl 24) | (49 Shl 16) | (127 Shl 8) | 251
				
	End Select

	' // Invert
	invR1 = (ega3 & $FF0000) Shr 16
	invG1 = (ega3 & $FF00) Shr 8
	invB1 = (ega3 & $FF)
		
	Local tmpR2:Int
	If bUpdate = True Or oldEGA2 = -1 Then
		Repeat
			tmpR2 = Rand(0, 15)	
		Until tmpR2 <> oldEGA2 And tmpR2 <> tmpR1 And tmpR2 <> 1 And tmpR2 <> 2 And tmpR2 <> 5 And tmpR2 <> 6
		oldEGA2 = tmpR2
	Else
		tmpR2 = oldEGA2
	EndIf
	
	'tmpR2 = 7
	Select tmpR2
		Case 0; ega2 = ($FF Shl 24) | (240 Shl 16) | (79 Shl 8) | 120
		'Case 1; ega2 = ($FF Shl 24) | (169 Shl 16) | (233 Shl 8) | 63
		'Case 2; ega2 = ($FF Shl 24) | (143 Shl 16) | (211 Shl 8) | 255
		Case 3; ega2 = ($FF Shl 24) | (159 Shl 16) | (140 Shl 8) | 203
		Case 4; ega2 = ($FF Shl 24) | (251 Shl 16) | (107 Shl 8) | 29
		'Case 5; ega2 = ($FF Shl 24) | (48 Shl 16) | (225 Shl 8) | 185
		'Case 6; ega2 = ($FF Shl 24) | (245 Shl 16) | (219 Shl 8) | 65
		Case 7; ega2 = ($FF Shl 24) | (49 Shl 16) | (127 Shl 8) | 251
			
		Case 8; ega2 = ($FF Shl 24) | (188 Shl 16) | (0 Shl 8) | 49	
		Case 9; ega2 = ($FF Shl 24) | (80 Shl 16) | (166 Shl 8) | 62
		Case 10; ega2 = ($FF Shl 24) | (77 Shl 16) | (101 Shl 8) | 180
		Case 11; ega2 = ($FF Shl 24) | (107 Shl 16) | (62 Shl 8) | 117
		Case 12; ega2 = ($FF Shl 24) | (122 Shl 16) | (48 Shl 8) | 69
		Case 13; ega2 = ($FF Shl 24) | (11 Shl 16) | (94 Shl 8) | 101
		Case 14; ega2 = ($FF Shl 24) | (223 Shl 16) | (156 Shl 8) | 44
		Case 15; ega2 = ($FF Shl 24) | (120 Shl 16) | (151 Shl 8) | 166

	End Select
	
	' // Invert
	invR2 = (ega2 & $FF0000) Shr 16
	invG2 = (ega2 & $FF00) Shr 8
	invB2 = (ega2 & $FF)

	'ega2 = ($FF Shl 24) | (143 Shl 16) | (211 Shl 8) | 255
	'ega2 = ($FF Shl 24) | (240 Shl 16) | (79 Shl 8) | 120
	
	'ega1 = ($FF Shl 24) | (251 Shl 16) | (255 Shl 8) | 134 ' // White
	ega1 = ($FF Shl 24) | (255 Shl 16) | (255 Shl 8) | 255
		
	' // Replace boss color
	'Local tmpPix:TPixmap = CreatePixmap(ImageWidth(imgShip), ImageHeight(imgShip), PF_RGB888)
	
	Local tmpT:Int = GetMilliSecs()

	ColorImage(imgBack, 1)
	ColorImage(imgBack2, 1)
	ColorImage(imgLogo, 1)
	ColorImage(imgFont, 41)
	ColorImage(imgShip, 1)
	ColorImage(imgShot, 1)
	ColorImage(imgWarp, 3)
	ColorImage(imgDemon1, 7)
	ColorImage(imgDemon2, 7)
	ColorImage(imgDemon3, 7)
	ColorImage(imgDemon4, 7)
	ColorImage(imgDemon5, 7)
	ColorImage(imgDemon6, 7)
	ColorImage(imgDemon7, 7)
	ColorImage(imgDemon8, 7)
	ColorImage(imgExplode, 7)
	ColorImage(imgLives, 7)
	ColorImage(imgDeath, 7)
	ColorImage(imgScore, 9)
	ColorImage(imgSplit, 5)
	ColorImage(imgBird, 7)
	ColorImage(imgBoss, 1)
	ColorImage(imgEye, 15)
	ColorImage(imgMouth, 15)
	ColorImage(imgShield, 11)
	ColorImage(imgTran, 1)
	ColorImage(imgEye2, 19)
	ColorImage(imgMouth2, 15)
	ColorImage(imgFade, 20)
	ColorImage(imgFade2, 20)
	'ColorImage(imgStars, 2)
	
	'Next
		
	'Notify("Total time: " + String(GetMilliSecs() - tmpT))
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² COLORIMAGE - Recolors an image and all its frames
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function ColorImage(myImage:TImage, eFrame:Int)

	Local i:Int = 0
	For Local i:Int = 0 To eFrame
		Local tmpPix:TPixmap = LockImage(myImage, i)
		Local tmpCol:Int

		For Local y:Int = 0 To PixmapHeight(tmpPix) - 1
			For Local x:Int = 0 To PixmapWidth(tmpPix) - 1
				tmpCol = ReadPixel(tmpPix, x, y) 
				'DebugLog tmpCol
				
				If tmpCol = -1 ' // White
					tmpCol = ega1
				ElseIf tmpCol = -16744193 ' // Blue
					tmpCol = ega2
				ElseIf tmpCol = -32768 ' // Orange
					tmpCol = ega3
				EndIf
		
				WritePixel tmpPix, x, y, tmpCol 
			
			Next
		Next

		UnlockImage(myImage, i) 		
	Next
		
End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ENDGAME - Ends program                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function EndGame()
	SaveCFG()
	End
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SETINVCOLOR - Sets inverted color                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SetInvColor(X:Float, Y:Float)

	' // Arr limits
	If X < 0 Or Y < 0 Then Return
	If X > 587 Or Y > 447 Then Return
	
	If arrInv[X, Y] = 0 Then ' // Invert black
		SetColor 255, 255, 255 
	ElseIf arrInv[X, Y] = 1 Then ' // Invert white
		SetColor 0, 0, 0
	ElseIf arrInv[X, Y] = 2 Then ' // Invert orange
		If cfgBR = 0 Then SetColor invR2, invG2, invB2 Else SetColor invR1, invG1, invB1
	EndIf
	
End Function

Function NewGame(tmpPlayer:Int)

	If tmpPlayer = False Then
		pX[PLAYER_1] = 273; pY[PLAYER_1] = 392
		
		bHas2 = False
		
	ElseIf tmpPlayer = True Then
		pX[PLAYER_1] = 137; pY[PLAYER_1] = 392
		pX[PLAYER_2] = 410; pY[PLAYER_2] = 392
		
		bHas2 = True
	EndIf
	
	pF[PLAYER_1] = 0
	pDeath[PLAYER_1] = False

	pF[PLAYER_2] = 0
	pDeath[PLAYER_2] = False

	pLives = 2; pScore = 0; pFlawless = True
	
	dSmart = 40; curLevel = startLevel; dShot = 0; bFlash = False; quadC = 3; bHit = False 
	demonT = 0; bFirstWarp = True; shieldF = 0
	
	shotX = 0; shotY = 0
	shotX2 = 0; shotY2 = 0
	
	' // Transition debug
	'If IsBoss() = True Then bTran = True; tranY = 0; tranT = GetMilliSecs(); shieldF = 0
	
	For o:Obj = EachIn objList; objList.Remove o; Next ' // Objects
	For p:Part = EachIn partList; partList.Remove p; Next ' // Particles
	
	scoreD = 10; scoreB = 15 ' // Reset score counters
	spawnT = 1750; spawnS = .70
	maxShot = 7; maxLaser = 8
	shotSpeed = 1.75
	shotTime = 140
	demSpeed = 10
	
	'shieldF = -1
	'demSpeed = 12
	'shotTime = 100
	'shotSpeed:+.75
	'maxShot:+3
	
	bTran = False; backTran = False
				
	GenSecret
				
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GENSECRET - Secret levels
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GenSecret()

	Local tmpRnd:Int
	Repeat ' // Don't repeat levels
		tmpRnd = Rand(0, 7)
	Until tmpRnd <> oldSecL
	oldSecL = tmpRnd
	
	Select tmpRnd
		Case 0; secLevel = 1
		Case 1; secLevel = 2
		Case 2; secLevel = 3
		Case 3; secLevel = 5
		Case 4; secLevel = 7
		Case 5; secLevel = 9
		Case 6; secLevel = 11
		Case 7; secLevel = 13
		
	End Select

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² ISBOSS - Is it a boss wave                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function IsBoss:Int()

	Local bBoss:Int = False
	Select curLevel
		Case 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62
		bBoss = True
		
	End Select
	
	Return bBoss
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADINVERT - Load inversion map                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadInvert()
	
	Local File:TStream = ReadFile("invert.dat")
	
	For Local Y:Int = 0 To 447
		For Local X:Int = 0 To 587
			'DebugLog "X: " + X + ", Y: " + Y
			
			arrInv[X, Y] = ReadByte(File)
		Next
	Next
	
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² UPSCORE - Increases score                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function UpScore()

	If curLevel > 62 Then curLevel = 1 ' // Wrap

	If IsBoss() = False Then
		GenSecret

		scoreD:+10
		If curLevel > 3 Then scoreB:+5
		If dSmart > 2 Then dSmart:-2 Else dSmart = 2

		' // Laser up
		If curLevel = 11 Or curLevel = 17 Or curLevel = 27 Or curLevel = 33 Or curLevel = 43 Or curLevel = 49 Or curLevel = 59 Then maxLaser:+3
		
		' // Shot up
		If curLevel = 5 Or curLevel = 13 Or curLevel = 21 Or curLevel = 29 Or curLevel = 37 Or curLevel = 45 Or curLevel = 53 Or curLevel = 61 Then maxShot:+1

		If curLevel = 15 Or curLevel = 31 Or curLevel = 47 Then ' // Level up
			shotSpeed:+.75
			If shotTime > 20 Then shotTime:-40 Else shotTime = 20
			demSpeed:+2
		EndIf
		
	Else
		If curLevel <> 4 Then
			spawnT:-50
			If Int(spawnS) < 1 Then spawnS:+.05 Else spawnS = 1
		EndIf
	EndIf
		
	If b2Player = True Then ' // 2 Players still alive check
		bHas2 = True
		If pLives <= 0 And (pDeath[0] = 2 Or pDeath[1] = 2) Then bHas2 = False
	Else
		bHas2 = False
	EndIf
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² IsLaser - Laser level check                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function IsLaser:Int(tmpLev:Int)

	Local tmpCheck:Int = False
	If tmpLev = 2 Or tmpLev = 11 Or tmpLev = 17 Or tmpLev = 27 Or tmpLev = 33 Or tmpLev = 43 Or tmpLev = 49 Or tmpLev = 59 Then tmpCheck = True
	Return tmpCheck
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² CHECKBIRD - Checks if bird match exists                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function CheckBird:Int(ID:Int)

	Local bFound:Int = False
	Local tmpList:TList = objList
	
	For o2:Obj = EachIn tmpList ' // Objects	
		If o2.ID = OBJ_DEMON Then
			If o2.K <> 0 And o2.K = ID Then 
				If o2.Q = 3 And o2.Act <> 1 Then switchID = ID ' // Set active
				bFound = True
				Exit
			EndIf
		EndIf
	Next
	
	GCRelease tmpList
	Return bFound
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWDEBUG - Show debug information                                       
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawDebug()

	' // DEBUG INFO
	SetScale 1, 1; SetColor 255, 255, 0
	'DrawText "ScrollX: " + Left$(String(scrollX), 7) + " / pX: " + Int(pX) + " / pY: " + Int(pY), 16, 16
	'DrawText "Jump: " + pJ + " / Fall: " + pFall + " / Hurt: " + pHurt + " / Dead: " + pDeath + " / Plat: " + bPlat, 16, 32
	DrawText "FPS: " + FPS + " / Objs: " + objC + " / Parts: " + partC + " / Mem: " + String(GCMemAlloced() / 1024) + " kb", 16, 16
	DrawText "dShot: " + dShot + " / AI: " + dSmart + " / demonC: " + demonCount + " / demonT: " + demonT, 16, 32
	DrawText "Ex: " + debugExplode + " / Warp: " + debugWarp + " / Tran: " + bTran + " / lastQ: " + debugQ, 16, 48
	DrawText "scoreD: " + scoreD + " / scoreB: " + scoreB + " / spawnT: " + spawnT + " / spawnS: " + spawnS, 16, 64

	SetColor 255, 255, 255; SetScale sclX, sclY
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWSCORE - Draws player score in bitmap font                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawScore(myScore:Int, X:Int, Y:Int)

	Local tmpS:String = String(myScore)
	Local tmpX:Int = 23
	Local tmpA:Int
	
	If bFlash = True Then SetColor 255, 112, 59 Else SetColor 255, 255, 255
	For Local i:Int = 1 To Len(tmpS$)
		tmpA = Asc(Mid$(tmpS$, i, 1)) - 48
		DrawImage imgScore, tmpX, 2, tmpA	
		tmpX:+37
	Next
	SetColor 255, 255, 255
	
End Function


' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETFUNCINPUT - Handles function key input                                      
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetFuncInput()
		
	If KeyHit(KEY_F1) Then ' // Save snapshot
		SaveScreen

	ElseIf KeyHit(KEY_F2) Then ' // Image filter
		If cfgFilter = True Then cfgFilter = False Else cfgFilter = True
		LoadImages(cfgFilter, False)
	
	ElseIf KeyHit(KEY_F3) Then ' // CRT mode
		If cfgCRT < 4 Then cfgCRT = cfgCRT + 1 Else cfgCRT = 0
		
	ElseIf KeyHit(KEY_F4) Then ' // Debug
		If bDebug = True Then bDebug = False Else bDebug = True

	ElseIf KeyHit(KEY_F5) Then ' // Palette
		If cfgEGA = 0 Then
			If cfgBR = 0 Then cfgBR = 1 Else cfgBR = 0
		EndIf
	
	ElseIf KeyHit(KEY_F6) And bTran = False And backTran = False Then ' // EGA
		If cfgEGA = 0 Then cfgEGA = 1; cfgBR = 0 Else cfgEGA = 0
		LoadImages(cfgFilter, False)
	
	ElseIf KeyHit(KEY_F11) Then ' // Cycle EGA
		If cfgEGA = 1 Then LoadImages(cfgFilter)
		
	EndIf
		
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² PLAYSFX - Plays a sound at desired volume                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function PlaySFX:TChannel(mySound:TSound)
	Local tmpChan:TChannel = AllocChannel()
	
	If cfgSFX <> 0 Then
		tmpChan = PlaySound(mySound)
		tmpChan.SetVolume(Float(cfgSFX) / 50)
	EndIf
	
	Return tmpChan
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² RENDEROVERLAY - Draws overlaying game graphics                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RenderOverlay()

	' // CRT Filter
	If cfgCRT > 0 Then
		If cfgCRT = 1 Then SetAlpha .25 ElseIf cfgCRT = 2 Then SetAlpha .5 ElseIf cfgCRT = 3 Then SetAlpha .75 ElseIf cfgCRT = 4 Then SetAlpha 1
		SetScale .368, .3735; SetColor 255, 255, 255; SetBlend ALPHABLEND
		DrawImage imgCRT, 0, 0
		SetAlpha 1; SetScale sclX, sclY
	EndIf
	
	If bWindowed = False Then ' // Fullscreen border
		SetOrigin 0, 0	
		SetScale 1, 1; SetColor 0, 0, 0
		DrawRect 0, 0, 640, 16; DrawRect 0, 0, 26, 480
		DrawRect 640 - 26, 0, 26, 480; DrawRect 0, 480 - 16, 640, 16
		SetColor 255, 255, 255
		SetOrigin 26, 16; SetScale sclX, sclY
	EndIf

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² DRAWFONT - Draws bitmap font                                    
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function DrawFont(myStr:String, X:Int, Y:Int)

	Local i:Int
	If X = -1 Then ' // Center text
		Local tmpW:Int
		X = 294
		For i = 1 To Len(myStr$)
			tmpW:+(16 * sclX)
		Next
		X:-Int(tmpW / 2)
	EndIf
	
	Local tmpX:Int = X, tmpY:Int = Y, tmpA:Int, tmpF:Int
	For i = 1 To Len(myStr)
		tmpA = Asc(Upper$(Mid$(myStr$, i, 1)))
		
		If tmpA >= 48 And tmpA <= 57 Then ' // Numbers
			tmpF = tmpA - 47
		ElseIf tmpA >= 65 And tmpA <= 90 Then ' // Letters
			tmpF = tmpA - 54
		ElseIf tmpA = 32 Then ' // Space
			tmpF = 0
		ElseIf tmpA = 44 Then ' // Comma
			tmpF = 37
		ElseIf tmpA = 46 Then ' // Period
			tmpF = 38
		ElseIf tmpA = 37 Then ' // Percent
			tmpF = 39
		ElseIf tmpA = 36 Then ' // $ Up arrow
			tmpF = 40
		ElseIf tmpA = 43 Then ' // + Down arrow
			tmpF = 41			
		EndIf
		
		DrawImage imgFont, Int(tmpX), Int(tmpY), tmpF
		tmpX:+(16 * sclX)
		
	Next
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADSCORES - Loads online hi scores
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadScores:Int()
	
	' // CODE REMOVED TO KEEP SCORES SECURE
						
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² UPLOADSCORE - Uploads score via SFTP                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function UploadScore(myScore:String)
	
	' // CODE REMOVED TO KEEP SCORES SECURE
		
	FlushInput
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² QuickSort - Sorts online hi scores                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function QuickSort(arr:String[], first:Int, last:Int)

	Local pivot:Int = 0
	Local temp:String
	Local i:Int = 0
	Local j:Int = 0

	If first < last Then
		pivot = first
		i = first
		j = last

		While (i < j)			
			While (Int(Left$(arr[i], Len(arr[i]) - 7)) >= Int(Left$(arr[pivot], Len(arr[pivot]) - 7)) And i < last)
				i = i + 1
			End While

			While (Int(Left$(arr[j], Len(arr[j]) - 7)) < Int(Left$(arr[pivot], Len(arr[pivot]) - 7)))
				j = j - 1
			End While

			If i < j Then
				temp = arr[i]
				arr[i] = arr[j]
				arr[j] = temp
			End If
		End While

		temp = arr[pivot]
		arr[pivot] = arr[j]
		arr[j] = temp
		QuickSort(arr, first, j - 1)
		QuickSort(arr, j + 1, last)
	End If

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADINPUT - Reads in input CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadInput()

	Local File:TStream = ReadFile("input.cfg")
	
	For Local j:Int = 0 To 1
		For Local i:Int = 0 To 6
			inKey[j, i] = ReadLine(File)

			If j = 0 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J1" Then p1Joy = 1
			ElseIf j = 1 And i = 0 Then ' // Check joystick port
				If Left$(inKey[j, i], 2) = "J0" Then p2Joy = 0
			EndIf
			
		Next
	Next
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETINPUT - Converts inkeys to inputs                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetInput:Int(j:Int, i:Int, d:Int = 0)

	Local tmpRet:Int = False
	Local tmp:String = inKey[j, i]
	
	If Left$(tmp$, 1) = "K" Then ' // Keyboard
		tmp$ = Replace$(tmp$, "K", "")
		If d = 0 Then ' // KeyHit
			If KeyHit(Int(tmp$)) = True Then tmpRet = True		
		ElseIf d = 1 Then ' // KeyDown
			If KeyDown(Int(tmp$)) = True Then tmpRet = True
		EndIf
	ElseIf Left$(tmp$, 2) = "J0" Then ' // Joy 1
		If tmp$ = "J0U" Then ' // Up
			If JoyY(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0D" Then ' // Down
			If JoyY(0) = 1 Then tmpRet = True
		ElseIf tmp$ = "J0L" Then ' // Left
			If JoyX(0) = -1 Then tmpRet = True
		ElseIf tmp$ = "J0R" Then ' // Right
			If JoyX(0) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J0", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 0) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 0) = True Then tmpRet = True
			EndIf
		EndIf
		
	ElseIf Left$(tmp$, 2) = "J1" Then ' // Joy 2
		If tmp$ = "J1U" Then ' // Up
			If JoyY(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1D" Then ' // Down
			If JoyY(1) = 1 Then tmpRet = True
		ElseIf tmp$ = "J1L" Then ' // Left
			If JoyX(1) = -1 Then tmpRet = True
		ElseIf tmp$ = "J1R" Then ' // Right
			If JoyX(1) = 1 Then tmpRet = True
		Else
			tmp$ = Replace$(tmp$, "J1", "")
			If d = 0 Then ' // JoyHit
				If JoyHit(Int(tmp$), 1) = True Then tmpRet = True
			ElseIf d = 1 Then ' // JoyDown
				If JoyDown(Int(tmp$), 1) = True Then tmpRet = True
			EndIf
		EndIf
		
	EndIf
	
	Return tmpRet
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² FLUSHINPUT - Flushes joystick and keyboard input
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function FlushInput(flushI:Int = -1)

	If flushI = -1 Then ' // Flush all
		FlushKeys; FlushJoy 0; FlushJoy 1
		If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_A) = True Or GetInput(PLAYER_1, INP_S) = True Then
		EndIf
		If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_A) = True Or GetInput(PLAYER_2, INP_S) = True Then
		EndIf
		FlushKeys; FlushJoy 0; FlushJoy 1	
	
	ElseIf flushI = 0 Then ' // Flush player 1
		FlushKeys; FlushJoy 0
		If GetInput(PLAYER_1, INP_B) = True Or GetInput(PLAYER_1, INP_A) = True Or GetInput(PLAYER_1, INP_S) = True Then
		EndIf
		FlushKeys; FlushJoy 0
	
	ElseIf flushI = 1 Then ' // Flush player 2
		FlushKeys; FlushJoy 1
		If GetInput(PLAYER_2, INP_B) = True Or GetInput(PLAYER_2, INP_A) = True Or GetInput(PLAYER_2, INP_S) = True Then
		EndIf
		FlushKeys; FlushJoy 1

	EndIf	

End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LOADCFG - Reads in CFG file                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function LoadCFG()

	Local File:TStream = ReadFile("demonx.cfg")
	cfgSFX = ReadInt(File)
	cfgMusic = ReadInt(File)
	cfgBR = ReadInt(File)
	cfgFilter = ReadInt(File)
	cfgCRT = ReadInt(File)
	cfgFull = ReadInt(File)
	cfgEGA = ReadInt(File)
	
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVECFG - Writes CFG file                                 
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveCFG()

	Local File:TStream = WriteFile("demonx.cfg")
	WriteInt File, cfgSFX
	WriteInt File, cfgMusic
	WriteInt File, cfgBR
	WriteInt File, cfgFilter
	WriteInt File, cfgCRT
	WriteInt File, cfgFull
	WriteInt File, cfgEGA
	CloseFile File
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² NumFormat - Draws numbers with comma placement                                  
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function NumFormat:String(myStr$)

	If Len(myStr$) = 4 Then ' // Thousand
		myStr$ = Left$(myStr$, 1) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 5 Then ' // Ten thousand
		myStr$ = Left$(myStr$, 2) + "," + Right$(myStr$, 3)

	ElseIf Len(myStr$) = 6
		myStr$ = Left$(myStr$, 3) + "," + Right$(myStr$, 3)

	EndIf
	
	Return myStr$
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² SAVESCREEN - Saves a PNG snapshot                                             
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function SaveScreen()
	Local tmpFN:Int = 0, Dir:Byte Ptr = ReadDir("snaps/"), file$
	Local tmpP:Int, tmpU:Int, tmpN:Int

	Repeat 
		file$ = NextFile(Dir)
		If FileType("snaps/" + file$) = 1 Then
			tmpP = Instr(file$, ".", 1)
			tmpU = Instr(file$, "_", 1)
			tmpN = Int(Mid(file$, tmpU + 1, tmpP - tmpU))
			If tmpN > tmpFN Then tmpFN = tmpN ' // New filenumber
		EndIf
	Until file$ = ""
	CloseDir Dir

	Local tmpX:Int, tmpY:Int
	If bWindowed = False Then tmpX = 26; tmpY = 16 Else tmpX = 0; tmpY = 0

	SetMaskColor 255, 0, 255
	Local imgScreen:TPixmap = GrabPixmap(tmpX, tmpY, 588, 448)
	SavePixmapPNG(imgScreen, "snaps/snap_" + (tmpFN + 1) + ".png", 9)
	
	GCRelease imgScreen
	GCCollect
	
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² GETMILLISECS - MilliSecs rollover fix                                     
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function GetMilliSecs:Int()

	If LastMilliSecs = 0 Then LastMilliSecs = MilliSecs() 
	
	If MilliSecs() > LastMilliSecs Then MyMilliSecs = MyMilliSecs + (MilliSecs() - LastMilliSecs)
	If MilliSecs() < LastMilliSecs Then MyMilliSecs = MyMilliSecs + (LastMilliSecs - MilliSecs())

	LastMilliSecs = MilliSecs()
	Return MyMilliSecs - pauseTotal ' // Time offset fix
    
End Function

' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
' // ² LEGACY FUNCTIONS                                            
' // ²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²²² //
Function RectsOverlap%(x0:Int, y0:Int, w0:Int, h0:Int, x2:Int, y2:Int, w2:Int, h2:Int)
	If x0 > (x2 + w2) Or (x0 + w0) < x2 Then Return False
	If y0 > (y2 + h2) Or (y0 + h0) < y2 Then Return False
	Return True
End Function

Function ImageRectCollide%(image:TImage, ix%, iy%, iframe%, rx%, ry%, rwidth%, rheight%)

   ResetCollisions
   CollideImage image, ix, iy, iframe, 0, 1
   
   If CollideRect(rx, ry, rwidth, rheight, 1, 0) Then Return True Else Return False

End Function
