' // Lvl2Dat by EikSoft
Framework BRL.GLMax2D 
'Framework BRL.D3D9Max2D

Import BRL.Retro
Import BRL.PNGLoader

AppTitle = "Lvl2Dat"
SetGraphicsDriver GLMax2DDriver()
'SetGraphicsDriver D3D9Max2DDriver()
SeedRnd MilliSecs()

Graphics 256, 224, 0, 60

Global arrLev:Int[32, 28]

Local tmpCol:Int, tmpR:Int, tmpG:Int, tmpB:Int
Local levR:Int, levG:Int, levB:Int

Const TILE_BLOCK = 1
Const TILE_ENEMYR = 2
Const TILE_KEY = 3
Const TILE_CHEST = 4
Const TILE_BUBBLE = 5
Const TILE_ENEMYL = 6
Const TILE_FLYERR = 7
Const TILE_FLYERL = 8
Const TILE_FILL = 9
Const TILE_SSPAWN1 = 10
Const TILE_SSPAWN2 = 11
Const TILE_SDEST1 = 12
Const TILE_SDEST2 = 13
Const TILE_BANER = 14
Const TILE_BANEL = 15

' // Reserved tiles
Const TILE_WATER = 100
Const TILE_ZAP = 101
Const TILE_FIRE = 102
Const TILE_NOCOL = 103
Const TILE_ZAPWATER = 104

Local imgLev:TImage
Local pixLev:TPixmap

For Local fNum:Int = 1 To 1

	' // Clear array
	For Local y:Int = 0 To 27
		For Local x:Int = 0 To 31
			arrLev[x, y] = 0
		Next
	Next
	
	SetMaskColor 255, 0, 255
	
	GCRelease imgLev
	GCRelease pixLev
	
	imgLev = LoadImage("lvl/lev" + String(fNum) + ".png", DYNAMICIMAGE)
	pixLev = CreatePixmap(ImageWidth(imgLev), ImageHeight(imgLev), PF_RGBA8888)

	Local lvlR:Int, lvlG:Int, lvlB:Int
	
	pixLev = LockImage(imgLev)
	For Local y:Int = 0 To 27
		For Local x:Int = 0 To 31
			tmpCol = ReadPixel(pixLev, (x * 8) + 4, (y * 8) + 3)
			
			tmpR = (tmpCol & $FF0000) Shr 16
			tmpG = (tmpCol & $FF00) Shr 8
			tmpB = (tmpCol & $FF)
			
			' // Reserved tiles
			If x = 0 And y = 0 Then ' // Special bubbles
				If tmpR = 0 And tmpG = 128 And tmpB = 255 Then ' // Water
					arrLev[x, y] = TILE_WATER
					
				ElseIf tmpR = 128 And tmpG = 128 And tmpB = 0 Then ' // Zap
					arrLev[x, y] = TILE_ZAP
					
				ElseIf tmpR = 255 And tmpG = 0 And tmpB = 128 Then ' // Fire
					arrLev[x, y] = TILE_FIRE
				
				ElseIf tmpR = 255 And tmpG = 128 And tmpB = 64 Then ' // Zap / Water
					arrLev[x, y] = TILE_ZAPWATER
									
				EndIf
				
			ElseIf x = 1 And y = 0 Then ' // No collision check
				If tmpR = 128 And tmpG = 128 And tmpB = 128 Then ' // No col
					arrLev[x, y] = TILE_NOCOL
				EndIf
				
			ElseIf x = 2 And y = 0 Then ' // X out
				
			Else ' // Level tiles

				If tmpR = 0 And tmpG = 0 And tmpB = 0 Then ' // Blank
					arrLev[x, y] = 0
					
				ElseIf tmpR = 255 And tmpG = 255 And tmpB = 255 Then ' // Enemy Right
					arrLev[x, y] = TILE_ENEMYR
							
				ElseIf tmpR = 0 And tmpG = 255 And tmpB = 255 Then ' // Enemy Left
					arrLev[x, y] = TILE_ENEMYL
				
				ElseIf tmpR = 255 And tmpG = 255 And tmpB = 0 Then ' // Key
					arrLev[x, y] = TILE_KEY

				ElseIf tmpR = 128 And tmpG = 64 And tmpB = 0 Then ' // Chest
					arrLev[x, y] = TILE_CHEST

				ElseIf tmpR = 0 And tmpG = 255 And tmpB = 0 Then ' // Bubble
					arrLev[x, y] = TILE_BUBBLE
				
				ElseIf tmpR = 255 And tmpG = 0 And tmpB = 0 Then ' // Flyer right
					arrLev[x, y] = TILE_FLYERR
				
				ElseIf tmpR = 128 And tmpG = 0 And tmpB = 0 Then ' // Flyer left
					arrLev[x, y] = TILE_FLYERL

				ElseIf tmpR = 192 And tmpG = 192 And tmpB = 192 Then ' // Fill
					arrLev[x, y] = TILE_FILL
				
				ElseIf tmpR = 0 And tmpG = 0 And tmpB = 255 Then ' // Special spawn 1
					arrLev[x, y] = TILE_SSPAWN1
				
				ElseIf tmpR = 0 And tmpG = 0 And tmpB = 128 Then ' // Special spawn 2
					arrLev[x, y] = TILE_SSPAWN2
								
				ElseIf tmpR = 0 And tmpG = 255 And tmpB = 128 Then ' // Special destination 1
					arrLev[x, y] = TILE_SDEST1

				ElseIf tmpR = 0 And tmpG = 128 And tmpB = 0 Then ' // Special destination 2
					arrLev[x, y] = TILE_SDEST2

				ElseIf tmpR = 128 And tmpG = 128 And tmpB = 255 Then ' // Banebou R
					arrLev[x, y] = TILE_BANER

				ElseIf tmpR = 0 And tmpG = 64 And tmpB = 128 Then ' // Banebou L
					arrLev[x, y] = TILE_BANEL
					
				Else ' // Block
					arrLev[x, y] = TILE_BLOCK
				
				EndIf				
				
			EndIf
					
		Next
	Next

	UnlockImage imgLev

	Local File:TStream = WriteFile("lev" + String(fNum) + ".dat")
	For Local y:Int = 0 To 27
		For Local x:Int = 0 To 31
			WriteInt File, arrLev[x, y]
		Next
	Next

	CloseFile File
Next