' // ESP Tester 1.1
' // Modules
Framework BRL.Max2D 
Import BRL.D3D7Max2D
Import BRL.Retro
Import BRL.PNGLoader
Import PUB.Mersenne
Import BRL.WAVLoader
Import BRL.Audio
Import BRL.FreeAudioAudio

Extern "win32"
	Function FindWindow(lpClassName$z, lpWindowName$z) = "FindWindowA@8"
	Function GetDesktopWindow()
	Function GetWindowRect(hWnd, lpRect:Byte Ptr)
	Function SetWindowPos(hWnd, after, x, y, w, h, flags)
	Function IsZoomed%(hwnd%)
End Extern

Type lpRECT ' Comment
	Field l, t, r, b
End Type

Global myhWnd, vidMode

AppTitle = "ESP Tester 1.1"
SetGraphicsDriver D3D7Max2DDriver()
Graphics 640, 480, 0, 60
WindowMode  
SeedRand MilliSecs()

Global imgCards:TImage = LoadAnimImage("cards.png", 96, 128, 0, 6, FILTEREDIMAGE|MIPMAPPEDIMAGE)
Global Card1, Card2, myStep = 0, StepTime = MilliSecs(), mySlot = RandRange(1, 3), myChoice, Chances = 1, Wins
Global ChoiceArr[999, 3], ChoiceNum = 0, highestNum = 0, tmpPow
Global myBeep:TSound = LoadSound("beep.wav")

GenRand
Repeat
MH1 = MouseHit(1)

If MH1 = True And myStep = 0 Then myStep = 1 ' Diablo

If myStep = 0 Then
    DrawText "Find the " + CardText$(Card1), 320 - (TextWidth("Find the " + CardText$(Card1)) / 2), 100

    tmpI = 0
    For tmpX = 114 To 500 Step 156
		If tmpI = 0 Or tmpI = 2 Then tmpF = Card2 Else tmpF = Card1
		If mySlot = 1 And tmpI = 0 Then 
			DrawImage imgCards, tmpX, 176, Card1
		ElseIf mySlot = 2 And tmpI = 1 Then
			DrawImage imgCards, tmpX, 176, Card1
		ElseIf mySlot = 3 And tmpI = 2 Then
			DrawImage imgCards, tmpX, 176, Card1
		EndIf			
        DrawImage imgCards, tmpX, 176, 0'tmpF
        tmpI:+1
    Next
ElseIf mystep = 1
    tmpI = 1
    For tmpX = 114 To 500 Step 156
        DrawImage imgCards, tmpX, 176, 0

        If MH1 = True Then
            If MouseX() >= tmpX And MouseX() <= tmpX + 96 And MouseY() >= 176 And MouseY() <= 176 + 128 Then
                myStep = 2; myChoice = tmpI
                If myChoice = mySlot Then wins:+1; PlaySound myBeep

                ChoiceArr[choiceNum, 0] = myChoice
                ChoiceArr[choiceNum, 1] = mySlot
                ChoiceArr[choiceNum, 2] = Card1
                If choiceNum < 999 Then choiceNum:+1 Else choiceNum = 0

                StepTime = MilliSecs()
            EndIf
        EndIf
        tmpI = tmpI + 1
    Next

Else
    If myChoice = mySlot Then tmpStr$ = "correct!" Else tmpStr$ = "wrong"
    DrawText "You are " + tmpStr$, 320 - (TextWidth("You are " + tmpStr$) / 2), 100
    
    tmpI = 1
    For tmpX = 114 To 500 Step 156
        If tmpI = mySlot Then tmpF = Card1 Else tmpF = Card2
        DrawImage imgCards, tmpX, 176, tmpF
        tmpI:+1
    Next
  
EndIf

DrawText "Current: " + wins + "/" + Chances, 13, 5
DrawText "Probable: " + (Chances - 1) / 3 + "/" + (Chances - 1), 5, 21

DrawRect 320 - 128, 400, 256, 24
SetColor 0, 0, 0
DrawRect 320 - 127, 401, 254, 22
SetColor 255, 255, 255

DrawText "Psychic Power", 320 - (TextWidth("Psychic Power") / 2), 430

If wins > (Chances - 1) / 3 Then
    tmpPow = wins - (Chances - 1) / 3
    If myStep <= 1 Then
        If tmpPow > highestNum Then highestNum = tmpPow
	EndIf

    tmpPow:*20

    If tmpPow > 254 Then tmpPow = 254
    SetColor 255, 0, 0
    DrawRect 320 - 127, 401, tmpPow, 22
    SetColor 255, 255, 255
EndIf

If MilliSecs() >= StepTime + 2000 And myStep <> 1 Then
    If myStep = 0 Then myStep = 1 Else myStep = 0; GenRand; StepTime = MilliSecs(); Chances:+1
    If myStep = 0 Then mySlot = RandRange(1, 3)
EndIf

If KeyHit(KEY_SPACE) = True Then GenRand

HandleVideo

Flip; Cls
Forever

Function GenRand()

Card1 = RandRange(1, 5)

Repeat
    Card2 = RandRange(1, 5)
Until Card2 <> Card1

End Function

Function CardText$(F)

Select F
    Case 1; Return "Cross"
    Case 2; Return "Square"
    Case 3; Return "Triangle"
    Case 4; Return "Wave"
    Case 5; Return "Circle"

End Select

End Function

Function HandleVideo()

If iszoomed(myhWnd) Then
	EndGraphics
	Graphics 640, 480, 32, 60
	vidMode = 1
EndIf

If KeyHit(KEY_ESCAPE) Or AppTerminate() = True Then
    If vidMode = 1 Then
        EndGraphics
        Graphics 640, 480, 0, 60
        WindowMode 
        vidMode = 2
        FlushKeys

    Else
		File = WriteFile("results.txt")
        CrLf$ = Chr$(13) + Chr$(10)
		WriteString File, "ESP Tester 1.1 Results" + CrLf$
		WriteString File, CurrentDate() + ":" + CurrentTime() + CrLf$
		WriteString File, "-------------------------------------" + CrLf$
		WriteString File, "You were correct " + wins + " out of " + (chances - 1) + " times" + CrLf$
		WriteString File, "By chance, you should have gotten " + ((Chances -1) / 3) + " out of " + (chances - 1) + " correct" + CrLf$
		WriteString File, "Your peak wins over probable was " + highestNum + CrLf$ + CrLf$
		tmp$ = "No ESP"
		If highestNum >= 2 And highestNum <= 4 Then
			tmp$ = "Slight ESP Ability"
		ElseIf highestNum > 4 And highestNum <= 6 Then
			tmp$ = "Strong ESP Ability"
		ElseIf highestNum > 6 And highestNum <= 8 Then
			tmp$ = "Definite ESP Ability"
		ElseIf highestNum > 8 Then
			tmp$ = "Gifted"
		EndIf
		WriteString File, "Psychic Rating: " + tmp$ + CrLf$
		WriteString File, "-------------------------------------" + CrLf$
		
        tmpT = 0; tmpT2 = 0
        For i = 0 To 999
            If ChoiceArr[i, 0] = 1 Then tmpT:+1
            If ChoiceArr[i, 1] = 1 Then tmpT2:+1
        Next
        WriteString File, "You chose the left card " + tmpT + " times" + CrLf$
        WriteString File, "The left card was the correct choice " + tmpT2 + " times" + CrLf$ + CrLf$

        tmpT = 0; tmpT2 = 0
        For i = 0 To 999
            If ChoiceArr[i, 0] = 2 Then tmpT:+1
            If ChoiceArr[i, 1] = 2 Then tmpT2:+1
        Next
        WriteString File, "You chose the middle card " + tmpT + " times" + CrLf$
        WriteString File, "The middle card was the correct choice " + tmpT2 + " times" + CrLf$ + CrLf$

        tmpT = 0; tmpT2 = 0
        For i = 0 To 999
            If ChoiceArr[i, 0] = 3 Then tmpT:+1
            If ChoiceArr[i, 1] = 3 Then tmpT2:+1
        Next
        WriteString File, "You chose the right card " + tmpT + " times" + CrLf$
        WriteString File, "The right card was the correct choice " + tmpT2 + " times" + CrLf$ + CrLf$

        tmpT = 0
        For i = 0 To 999
            If ChoiceArr[i, 2] = 1 Then tmpT:+1
        Next
        WriteString File, "The cross was the right card " + tmpT + " times" + CrLf$

        tmpT = 0
        For i = 0 To 999
            If ChoiceArr[i, 2] = 2 Then tmpT:+1
        Next
        WriteString File, "The square was the right card " + tmpT + " times" + CrLf$

        tmpT = 0
        For i = 0 To 999
            If ChoiceArr[i, 2] = 3 Then tmpT:+1
        Next
        WriteString File, "The triangle was the right card " + tmpT + " times" + CrLf$

        tmpT = 0
        For i = 0 To 999
            If ChoiceArr[i, 2] = 4 Then tmpT:+1
        Next
        WriteString File, "The wave was the right card " + tmpT + " times" + CrLf$

        tmpT = 0
        For i = 0 To 999
            If ChoiceArr[i, 2] = 5 Then tmpT:+1
        Next
        WriteString File, "The circle was the right card " + tmpT + " times" + CrLf$

		CloseFile File
		End
	
    EndIf
    
EndIf
    
FlushKeys
End Function

Function WindowMode()

	Local hWnd% = FindWindow("BBDX7Device Window Class", "ESP Tester 1.1")

	Local desk_hWnd% = GetDesktopWindow(), l:lpRect = New lpRECT
	GetWindowRect desk_hWnd, l:lpRECT 

	SetWindowPos hWnd, -2, (l.r / 2) - (640 / 2), (l.b / 2) - (480 / 2), 0, 0, 1
	l:lpRECT = Null
	
	Local tmp:Long = GetWindowLongA( hWnd, GWL_STYLE )
	tmp = tmp | WS_MINIMIZEBOX
	SetWindowLongA hWnd, GWL_STYLE, tmp
	DrawMenuBar hWnd
	
	tmp = GetWindowLongA( hWnd, GWL_STYLE )
	tmp = tmp | WS_MAXIMIZEBOX
	SetWindowLongA  hWnd, GWL_STYLE, tmp 
	DrawMenuBar hWnd 
	
	myhWnd = hWnd
	
End Function
