; ////////////////////////////////////////////////////////////////////////////////////////////////////
; // AscGame Example
; //
; // A simple game that demonstrates how to use the BBASCII functions.
; //
; // Collect the different gems and avoid the baddies.
; // 
; ////////////////////////////////////////////////////////////////////////////////////////////////////
Graphics 640, 300, 16, 2
SetBuffer BackBuffer()
SeedRnd MilliSecs()

Type Obj
	Field X, Y, T, cF, cB, A ; X, Y, Time, Fore color, Back color, ASCII Character Code
End Type

Include "lib/bbasc.bb" ; Include BBASCII Library (b2d/b3d version)

; // Locals
Local fps_Count = 0, fps_Current = 0, fps_Time# = MilliSecs() + 1 ; FPS Counter
Global PX = 37, PY = 24, PS = 0 ; Paddle Position in console coords + Score

GameTime = CreateTimer(60) ; 60 FPS
InputTime = MilliSecs()
While Not KeyDown(1)
Cls
fps_Count = fps_Count + 1
If MilliSecs() >= fps_Time Then fps_Current = fps_Count: fps_Count = 0: fps_Time = fps_Time + 1000

RObj()

AscText 0, 0, 14, 1, " Score: " + PS + "     "
AscChar PX, PY, 14, 0, 1

If Rand(1, 10) = 5 Then ; New Obj
	o.Obj = New Obj
	o\X = Rand(0, 79): o\Y = 0
	o\cF = Rand(1, 15): o\cB = 0: o\T = MilliSecs(): o\A = 4
	If Rand(1, 10) = 5 Then o\A = 2 ; Baddie
EndIf

If MilliSecs() >= InputTime + 50 Then ; Check Input
	If KeyDown(203) And PX > 0 Then PX = PX - 1
	If KeyDown(205) And PX < 79 Then PX = PX + 1
	InputTime = MilliSecs()
EndIf

AppTitle "AscGame Example     FPS: " + fps_Current
WaitTimer GameTime: Flip 1
Wend: End

Function RObj()
For o.Obj = Each Obj
	Del = 0
	AscChar o\X, o\Y, o\cF, o\cB, o\A
	If MilliSecs() >= o\T + 100 Then o\Y = o\Y + 1: o\T = MilliSecs()
	If o\X = PX And o\Y = PY Then 
		If o\A = 2 Then GameOver Else del = 1: PS = PS + o\cF * 10
	EndIf
	If o\Y >= 25 Then Del = 1
	If Del = 1 Then Delete o
Next
End Function

Function GameOver()
Cls
AscText 0, 0, 14, 1, " GAME OVER "
AscText 0, 1, 14, 1, " Score: " + PS + "     "
Flip
FlushKeys()
WaitKey()

End
End Function
