; /////////////////////////////////////////////////////////////////////////////////////////////////////
; // BBASCII Library Functions by Eikon
; // version 1.0
; // Last Modified October 18, 2004
; //
; // Path$ should point to bb.asc
; //
; /////////////////////////////////////////////////////////////////////////////////////////////////////
Global bbAsc = CreateImage(2304, 13)
Global bbChr  = CreateImage(8, 12)
Global bbChr2 = CreateImage(8, 12): MaskImage bbChr2, 255, 0, 185

Path$ = "lib/" ; <---------- Point this to where your bb.asc is located

LockBuffer ImageBuffer(bbAsc)
File = ReadFile(path$ + "bb.asc")
For b = 0 To 11
For a = 0 To 2302
	tmp = ReadByte(File)
	If tmp = 1 Then 
		WritePixelFast a, b, 185 Or (0 Shl 8) Or (255 Shl 16), ImageBuffer(bbAsc)
	Else 
		WritePixelFast a, b, 0 Or (0 Shl 8) Or (0 Shl 16), ImageBuffer(bbAsc)
	EndIf	
Next
Next
CloseFile File
UnlockBuffer ImageBuffer(bbAsc)

; // AscText Function
Function AscText(X, Y, cF, cB, aText$)
oldBuff = GraphicsBuffer(): tmpX = 0

For i = 1 To Len(aText$)
	aC = Asc(Mid(aText$, i, 1))      ; Get Chr
	
	If aC > 200 Then aC = aC - 1
	TX = aC * 9
	
	SetBuffer ImageBuffer(bbChr)
	Cls
	CopyRect TX, 0, 8, 12, 0, 0, ImageBuffer(bbAsc), ImageBuffer(bbChr)

	SetBuffer ImageBuffer(bbChr2)
   	Cls
	AscColor cF ; Set Foreground Color
		
	Rect 0, 0, 8, 12, 1
	DrawImage bbChr, 0, 0
		
	SetBuffer oldBuff
	AscColor cB ; Set Background Color
	Rect (X * 8) + tmpX, Y * 12, 8, 12, 1
	DrawImage bbChr2, (X * 8) + tmpX, Y * 12

	tmpX = tmpX + 8
Next

End Function

; // bbAscChar Function
Function AscChar(X, Y, cF, cB, aC)
If aC > 200 Then aC = aC - 1
oldBuff = GraphicsBuffer(): TX = aC * 9

SetBuffer ImageBuffer(bbChr)
Cls
CopyRect TX, 0, 8, 12, 0, 0, ImageBuffer(bbAsc), ImageBuffer(bbChr)

SetBuffer ImageBuffer(bbChr2)
Cls
AscColor cF ; Set Foreground Color
		
Rect 0, 0, 8, 12, 1
DrawImage bbChr, 0, 0
		
SetBuffer oldBuff
AscColor cB ; Set Background Color
Rect X * 8, Y * 12, 8, 12, 1
DrawImage bbChr2, X * 8, Y * 12
	
End Function

; // AscColor Function
Function AscColor(col)

Select col
	Case  0: Color 0, 0, 0       ; Black
	Case  1: Color 0, 0, 128     ; Blue
	Case  2: Color 0, 128, 0     ; Green
	Case  3: Color 0, 128, 128   ; Cyan
	Case  4: Color 128, 0, 0     ; Red
	Case  5: Color 128, 0, 128   ; Magenta	
	Case  6: Color 128, 128, 0   ; Brown
	Case  7: Color 192, 192, 192 ; Light Grey
	Case  8: Color 128, 128, 128 ; Dark Grey
	Case  9: Color 0, 0, 255     ; Bright Blue
	Case 10: Color 0, 255, 0     ; Bright Green
	Case 11: Color 0, 255, 255   ; Bright Cyan
	Case 12: Color 255, 0, 0     ; Bright Red
	Case 13: Color 255, 0, 255   ; Bright Magenta
	Case 14: Color 255, 255, 0   ; Yellow
	Case 15: Color 255, 255, 255 ; White

End Select
End Function