; ////////////////////////////////////////////////////////////////////////////////////////////////////
; // AscChar Function Example
; // 2000 Characters per pass
; //
; // AscChar takes 5 parameters: (X%, Y%, cF%, cB%, aC%)
; // ----------+-------------------------------------
; // 1. X      | The X location in console units (8x12) the character will be drawn to
; // 2. Y      | The Y location in console untis (8x12) the character will be drawn to
; // 3. cF     | The console color value (1-15) for the foreground of the character
; // 4. cB     | The console color value for the background of the character
; // 5. aC     | The characters ASCII code
; //
; ////////////////////////////////////////////////////////////////////////////////////////////////////
Graphics 640, 300, 16, 2
SetBuffer BackBuffer()
SeedRnd MilliSecs()

Include "lib/bbasc.bb" ; Include BBASCII Library

; // Locals
Local fps_Count = 0, fps_Current = 0, fps_Time# = MilliSecs() + 1 ; FPS Counter

While Not KeyDown(1)
fps_Count = fps_Count + 1
If MilliSecs() >= fps_Time Then fps_Current = fps_Count: fps_Count = 0: fps_Time = fps_Time + 1000

For Y = 0 To 300 Step 12
For X = 0 To 640 Step 8
	AscChar X/8, Y/12, Rand(0, 15), Rand(0, 15), Rand(0, 255)
Next
Next

AppTitle "FPS: " + fps_Current
Flip 0
Wend: End